// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisvideoarchivedmedia

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Contains the range of timestamps for the requested media, and the source
// of the timestamps.
type DASHFragmentSelector struct {
	_ struct{} `type:"structure"`

	// The source of the timestamps for the requested media.
	//
	// When FragmentSelectorType is set to PRODUCER_TIMESTAMP and GetDASHStreamingSessionURLInput$PlaybackMode
	// is ON_DEMAND or LIVE_REPLAY, the first fragment ingested with a producer
	// timestamp within the specified FragmentSelector$TimestampRange is included
	// in the media playlist. In addition, the fragments with producer timestamps
	// within the TimestampRange ingested immediately following the first fragment
	// (up to the GetDASHStreamingSessionURLInput$MaxManifestFragmentResults value)
	// are included.
	//
	// Fragments that have duplicate producer timestamps are deduplicated. This
	// means that if producers are producing a stream of fragments with producer
	// timestamps that are approximately equal to the true clock time, the MPEG-DASH
	// manifest will contain all of the fragments within the requested timestamp
	// range. If some fragments are ingested within the same time range and very
	// different points in time, only the oldest ingested collection of fragments
	// are returned.
	//
	// When FragmentSelectorType is set to PRODUCER_TIMESTAMP and GetDASHStreamingSessionURLInput$PlaybackMode
	// is LIVE, the producer timestamps are used in the MP4 fragments and for deduplication.
	// But the most recently ingested fragments based on server timestamps are included
	// in the MPEG-DASH manifest. This means that even if fragments ingested in
	// the past have producer timestamps with values now, they are not included
	// in the HLS media playlist.
	//
	// The default is SERVER_TIMESTAMP.
	FragmentSelectorType DASHFragmentSelectorType `type:"string" enum:"true"`

	// The start and end of the timestamp range for the requested media.
	//
	// This value should not be present if PlaybackType is LIVE.
	TimestampRange *DASHTimestampRange `type:"structure"`
}

// String returns the string representation
func (s DASHFragmentSelector) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DASHFragmentSelector) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.FragmentSelectorType) > 0 {
		v := s.FragmentSelectorType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FragmentSelectorType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TimestampRange != nil {
		v := s.TimestampRange

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TimestampRange", v, metadata)
	}
	return nil
}

// The start and end of the timestamp range for the requested media.
//
// This value should not be present if PlaybackType is LIVE.
//
// The values in the DASHimestampRange are inclusive. Fragments that begin before
// the start time but continue past it, or fragments that begin before the end
// time but continue past it, are included in the session.
type DASHTimestampRange struct {
	_ struct{} `type:"structure"`

	// The end of the timestamp range for the requested media. This value must be
	// within 3 hours of the specified StartTimestamp, and it must be later than
	// the StartTimestamp value.
	//
	// If FragmentSelectorType for the request is SERVER_TIMESTAMP, this value must
	// be in the past.
	//
	// The EndTimestamp value is required for ON_DEMAND mode, but optional for LIVE_REPLAY
	// mode. If the EndTimestamp is not set for LIVE_REPLAY mode then the session
	// will continue to include newly ingested fragments until the session expires.
	//
	// This value is inclusive. The EndTimestamp is compared to the (starting) timestamp
	// of the fragment. Fragments that start before the EndTimestamp value and continue
	// past it are included in the session.
	EndTimestamp *time.Time `type:"timestamp"`

	// The start of the timestamp range for the requested media.
	//
	// If the DASHTimestampRange value is specified, the StartTimestamp value is
	// required.
	//
	// This value is inclusive. Fragments that start before the StartTimestamp and
	// continue past it are included in the session. If FragmentSelectorType is
	// SERVER_TIMESTAMP, the StartTimestamp must be later than the stream head.
	StartTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DASHTimestampRange) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DASHTimestampRange) MarshalFields(e protocol.FieldEncoder) error {
	if s.EndTimestamp != nil {
		v := *s.EndTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.StartTimestamp != nil {
		v := *s.StartTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Represents a segment of video or other time-delimited data.
type Fragment struct {
	_ struct{} `type:"structure"`

	// The playback duration or other time value associated with the fragment.
	FragmentLengthInMilliseconds *int64 `type:"long"`

	// The unique identifier of the fragment. This value monotonically increases
	// based on the ingestion order.
	FragmentNumber *string `min:"1" type:"string"`

	// The total fragment size, including information about the fragment and contained
	// media data.
	FragmentSizeInBytes *int64 `type:"long"`

	// The timestamp from the producer corresponding to the fragment.
	ProducerTimestamp *time.Time `type:"timestamp"`

	// The timestamp from the AWS server corresponding to the fragment.
	ServerTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s Fragment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Fragment) MarshalFields(e protocol.FieldEncoder) error {
	if s.FragmentLengthInMilliseconds != nil {
		v := *s.FragmentLengthInMilliseconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FragmentLengthInMilliseconds", protocol.Int64Value(v), metadata)
	}
	if s.FragmentNumber != nil {
		v := *s.FragmentNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FragmentNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FragmentSizeInBytes != nil {
		v := *s.FragmentSizeInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FragmentSizeInBytes", protocol.Int64Value(v), metadata)
	}
	if s.ProducerTimestamp != nil {
		v := *s.ProducerTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProducerTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.ServerTimestamp != nil {
		v := *s.ServerTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ServerTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Describes the timestamp range and timestamp origin of a range of fragments.
//
// Only fragments with a start timestamp greater than or equal to the given
// start time and less than or equal to the end time are returned. For example,
// if a stream contains fragments with the following start timestamps:
//
//    * 00:00:00
//
//    * 00:00:02
//
//    * 00:00:04
//
//    * 00:00:06
//
// A fragment selector range with a start time of 00:00:01 and end time of 00:00:04
// would return the fragments with start times of 00:00:02 and 00:00:04.
type FragmentSelector struct {
	_ struct{} `type:"structure"`

	// The origin of the timestamps to use (Server or Producer).
	//
	// FragmentSelectorType is a required field
	FragmentSelectorType FragmentSelectorType `type:"string" required:"true" enum:"true"`

	// The range of timestamps to return.
	//
	// TimestampRange is a required field
	TimestampRange *TimestampRange `type:"structure" required:"true"`
}

// String returns the string representation
func (s FragmentSelector) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FragmentSelector) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FragmentSelector"}
	if len(s.FragmentSelectorType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("FragmentSelectorType"))
	}

	if s.TimestampRange == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimestampRange"))
	}
	if s.TimestampRange != nil {
		if err := s.TimestampRange.Validate(); err != nil {
			invalidParams.AddNested("TimestampRange", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FragmentSelector) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.FragmentSelectorType) > 0 {
		v := s.FragmentSelectorType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FragmentSelectorType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TimestampRange != nil {
		v := s.TimestampRange

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TimestampRange", v, metadata)
	}
	return nil
}

// Contains the range of timestamps for the requested media, and the source
// of the timestamps.
type HLSFragmentSelector struct {
	_ struct{} `type:"structure"`

	// The source of the timestamps for the requested media.
	//
	// When FragmentSelectorType is set to PRODUCER_TIMESTAMP and GetHLSStreamingSessionURLInput$PlaybackMode
	// is ON_DEMAND or LIVE_REPLAY, the first fragment ingested with a producer
	// timestamp within the specified FragmentSelector$TimestampRange is included
	// in the media playlist. In addition, the fragments with producer timestamps
	// within the TimestampRange ingested immediately following the first fragment
	// (up to the GetHLSStreamingSessionURLInput$MaxMediaPlaylistFragmentResults
	// value) are included.
	//
	// Fragments that have duplicate producer timestamps are deduplicated. This
	// means that if producers are producing a stream of fragments with producer
	// timestamps that are approximately equal to the true clock time, the HLS media
	// playlists will contain all of the fragments within the requested timestamp
	// range. If some fragments are ingested within the same time range and very
	// different points in time, only the oldest ingested collection of fragments
	// are returned.
	//
	// When FragmentSelectorType is set to PRODUCER_TIMESTAMP and GetHLSStreamingSessionURLInput$PlaybackMode
	// is LIVE, the producer timestamps are used in the MP4 fragments and for deduplication.
	// But the most recently ingested fragments based on server timestamps are included
	// in the HLS media playlist. This means that even if fragments ingested in
	// the past have producer timestamps with values now, they are not included
	// in the HLS media playlist.
	//
	// The default is SERVER_TIMESTAMP.
	FragmentSelectorType HLSFragmentSelectorType `type:"string" enum:"true"`

	// The start and end of the timestamp range for the requested media.
	//
	// This value should not be present if PlaybackType is LIVE.
	TimestampRange *HLSTimestampRange `type:"structure"`
}

// String returns the string representation
func (s HLSFragmentSelector) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HLSFragmentSelector) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.FragmentSelectorType) > 0 {
		v := s.FragmentSelectorType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FragmentSelectorType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TimestampRange != nil {
		v := s.TimestampRange

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TimestampRange", v, metadata)
	}
	return nil
}

// The start and end of the timestamp range for the requested media.
//
// This value should not be present if PlaybackType is LIVE.
//
// The values in the HLSTimestampRange are inclusive. Fragments that begin before
// the start time but continue past it, or fragments that begin before the end
// time but continue past it, are included in the session.
type HLSTimestampRange struct {
	_ struct{} `type:"structure"`

	// The end of the timestamp range for the requested media. This value must be
	// within 3 hours of the specified StartTimestamp, and it must be later than
	// the StartTimestamp value.
	//
	// If FragmentSelectorType for the request is SERVER_TIMESTAMP, this value must
	// be in the past.
	//
	// The EndTimestamp value is required for ON_DEMAND mode, but optional for LIVE_REPLAY
	// mode. If the EndTimestamp is not set for LIVE_REPLAY mode then the session
	// will continue to include newly ingested fragments until the session expires.
	//
	// This value is inclusive. The EndTimestamp is compared to the (starting) timestamp
	// of the fragment. Fragments that start before the EndTimestamp value and continue
	// past it are included in the session.
	EndTimestamp *time.Time `type:"timestamp"`

	// The start of the timestamp range for the requested media.
	//
	// If the HLSTimestampRange value is specified, the StartTimestamp value is
	// required.
	//
	// This value is inclusive. Fragments that start before the StartTimestamp and
	// continue past it are included in the session. If FragmentSelectorType is
	// SERVER_TIMESTAMP, the StartTimestamp must be later than the stream head.
	StartTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s HLSTimestampRange) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HLSTimestampRange) MarshalFields(e protocol.FieldEncoder) error {
	if s.EndTimestamp != nil {
		v := *s.EndTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.StartTimestamp != nil {
		v := *s.StartTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

// The range of timestamps for which to return fragments.
type TimestampRange struct {
	_ struct{} `type:"structure"`

	// The ending timestamp in the range of timestamps for which to return fragments.
	//
	// EndTimestamp is a required field
	EndTimestamp *time.Time `type:"timestamp" required:"true"`

	// The starting timestamp in the range of timestamps for which to return fragments.
	//
	// StartTimestamp is a required field
	StartTimestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s TimestampRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimestampRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TimestampRange"}

	if s.EndTimestamp == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndTimestamp"))
	}

	if s.StartTimestamp == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTimestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TimestampRange) MarshalFields(e protocol.FieldEncoder) error {
	if s.EndTimestamp != nil {
		v := *s.EndTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.StartTimestamp != nil {
		v := *s.StartTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}
