// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsecuretunneling

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// The state of a connection.
type ConnectionState struct {
	_ struct{} `type:"structure"`

	// The last time the connection status was updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The connection status of the tunnel. Valid values are CONNECTED and DISCONNECTED.
	Status ConnectionStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s ConnectionState) String() string {
	return awsutil.Prettify(s)
}

// The destination configuration.
type DestinationConfig struct {
	_ struct{} `type:"structure"`

	// A list of service names that identity the target application. Currently,
	// you can only specify a single name. The AWS IoT client running on the destination
	// device reads this value and uses it to look up a port or an IP address and
	// a port. The AWS IoT client instantiates the local proxy which uses this information
	// to connect to the destination application.
	//
	// Services is a required field
	Services []string `locationName:"services" min:"1" type:"list" required:"true"`

	// The name of the IoT thing to which you want to connect.
	//
	// ThingName is a required field
	ThingName *string `locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DestinationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DestinationConfig"}

	if s.Services == nil {
		invalidParams.Add(aws.NewErrParamRequired("Services"))
	}
	if s.Services != nil && len(s.Services) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Services", 1))
	}

	if s.ThingName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An arbitary key/value pair used to add searchable metadata to secure tunnel
// resources.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value of the tag.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Tunnel timeout configuration.
type TimeoutConfig struct {
	_ struct{} `type:"structure"`

	// The maximum amount of time (in minutes) a tunnel can remain open. If not
	// specified, maxLifetimeTimeoutMinutes defaults to 720 minutes. Valid values
	// are from 1 minute to 12 hours (720 minutes)
	MaxLifetimeTimeoutMinutes *int64 `locationName:"maxLifetimeTimeoutMinutes" min:"1" type:"integer"`
}

// String returns the string representation
func (s TimeoutConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeoutConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TimeoutConfig"}
	if s.MaxLifetimeTimeoutMinutes != nil && *s.MaxLifetimeTimeoutMinutes < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxLifetimeTimeoutMinutes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A connection between a source computer and a destination device.
type Tunnel struct {
	_ struct{} `type:"structure"`

	// The time when the tunnel was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// A description of the tunnel.
	Description *string `locationName:"description" type:"string"`

	// The destination configuration that specifies the thing name of the destination
	// device and a service name that the local proxy uses to connect to the destination
	// application.
	DestinationConfig *DestinationConfig `locationName:"destinationConfig" type:"structure"`

	// The connection state of the destination application.
	DestinationConnectionState *ConnectionState `locationName:"destinationConnectionState" type:"structure"`

	// The last time the tunnel was updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The connection state of the source application.
	SourceConnectionState *ConnectionState `locationName:"sourceConnectionState" type:"structure"`

	// The status of a tunnel. Valid values are: Open and Closed.
	Status TunnelStatus `locationName:"status" type:"string" enum:"true"`

	// A list of tag metadata associated with the secure tunnel.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`

	// Timeout configuration for the tunnel.
	TimeoutConfig *TimeoutConfig `locationName:"timeoutConfig" type:"structure"`

	// The Amazon Resource Name (ARN) of a tunnel. The tunnel ARN format is arn:aws:tunnel:<region>:<account-id>:tunnel/<tunnel-id>
	TunnelArn *string `locationName:"tunnelArn" min:"1" type:"string"`

	// A unique alpha-numeric ID that identifies a tunnel.
	TunnelId *string `locationName:"tunnelId" type:"string"`
}

// String returns the string representation
func (s Tunnel) String() string {
	return awsutil.Prettify(s)
}

// Information about the tunnel.
type TunnelSummary struct {
	_ struct{} `type:"structure"`

	// The time the tunnel was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// A description of the tunnel.
	Description *string `locationName:"description" type:"string"`

	// The time the tunnel was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The status of a tunnel. Valid values are: Open and Closed.
	Status TunnelStatus `locationName:"status" type:"string" enum:"true"`

	// The Amazon Resource Name of the tunnel. The tunnel ARN format is arn:aws:tunnel:<region>:<account-id>:tunnel/<tunnel-id>
	TunnelArn *string `locationName:"tunnelArn" min:"1" type:"string"`

	// The unique alpha-numeric identifier for the tunnel.
	TunnelId *string `locationName:"tunnelId" type:"string"`
}

// String returns the string representation
func (s TunnelSummary) String() string {
	return awsutil.Prettify(s)
}
