// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ioteventsiface provides an interface to enable mocking the AWS IoT Events service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ioteventsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/iotevents"
)

// ClientAPI provides an interface to enable mocking the
// iotevents.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS IoT Events.
//    func myFunc(svc ioteventsiface.ClientAPI) bool {
//        // Make svc.CreateDetectorModel request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := iotevents.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        ioteventsiface.ClientPI
//    }
//    func (m *mockClientClient) CreateDetectorModel(input *iotevents.CreateDetectorModelInput) (*iotevents.CreateDetectorModelOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateDetectorModelRequest(*iotevents.CreateDetectorModelInput) iotevents.CreateDetectorModelRequest

	CreateInputRequest(*iotevents.CreateInputInput) iotevents.CreateInputRequest

	DeleteDetectorModelRequest(*iotevents.DeleteDetectorModelInput) iotevents.DeleteDetectorModelRequest

	DeleteInputRequest(*iotevents.DeleteInputInput) iotevents.DeleteInputRequest

	DescribeDetectorModelRequest(*iotevents.DescribeDetectorModelInput) iotevents.DescribeDetectorModelRequest

	DescribeInputRequest(*iotevents.DescribeInputInput) iotevents.DescribeInputRequest

	DescribeLoggingOptionsRequest(*iotevents.DescribeLoggingOptionsInput) iotevents.DescribeLoggingOptionsRequest

	ListDetectorModelVersionsRequest(*iotevents.ListDetectorModelVersionsInput) iotevents.ListDetectorModelVersionsRequest

	ListDetectorModelsRequest(*iotevents.ListDetectorModelsInput) iotevents.ListDetectorModelsRequest

	ListInputsRequest(*iotevents.ListInputsInput) iotevents.ListInputsRequest

	ListTagsForResourceRequest(*iotevents.ListTagsForResourceInput) iotevents.ListTagsForResourceRequest

	PutLoggingOptionsRequest(*iotevents.PutLoggingOptionsInput) iotevents.PutLoggingOptionsRequest

	TagResourceRequest(*iotevents.TagResourceInput) iotevents.TagResourceRequest

	UntagResourceRequest(*iotevents.UntagResourceInput) iotevents.UntagResourceRequest

	UpdateDetectorModelRequest(*iotevents.UpdateDetectorModelInput) iotevents.UpdateDetectorModelRequest

	UpdateInputRequest(*iotevents.UpdateInputInput) iotevents.UpdateInputRequest
}

var _ ClientAPI = (*iotevents.Client)(nil)
