// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListProvisioningTemplatesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListProvisioningTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProvisioningTemplatesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListProvisioningTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListProvisioningTemplatesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListProvisioningTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// A token to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of fleet provisioning templates
	Templates []ProvisioningTemplateSummary `locationName:"templates" type:"list"`
}

// String returns the string representation
func (s ListProvisioningTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListProvisioningTemplatesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Templates != nil {
		v := s.Templates

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "templates", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListProvisioningTemplates = "ListProvisioningTemplates"

// ListProvisioningTemplatesRequest returns a request value for making API operation for
// AWS IoT.
//
// Lists the fleet provisioning templates in your AWS account.
//
//    // Example sending a request using ListProvisioningTemplatesRequest.
//    req := client.ListProvisioningTemplatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListProvisioningTemplatesRequest(input *ListProvisioningTemplatesInput) ListProvisioningTemplatesRequest {
	op := &aws.Operation{
		Name:       opListProvisioningTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/provisioning-templates",
	}

	if input == nil {
		input = &ListProvisioningTemplatesInput{}
	}

	req := c.newRequest(op, input, &ListProvisioningTemplatesOutput{})
	return ListProvisioningTemplatesRequest{Request: req, Input: input, Copy: c.ListProvisioningTemplatesRequest}
}

// ListProvisioningTemplatesRequest is the request type for the
// ListProvisioningTemplates API operation.
type ListProvisioningTemplatesRequest struct {
	*aws.Request
	Input *ListProvisioningTemplatesInput
	Copy  func(*ListProvisioningTemplatesInput) ListProvisioningTemplatesRequest
}

// Send marshals and sends the ListProvisioningTemplates API request.
func (r ListProvisioningTemplatesRequest) Send(ctx context.Context) (*ListProvisioningTemplatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListProvisioningTemplatesResponse{
		ListProvisioningTemplatesOutput: r.Request.Data.(*ListProvisioningTemplatesOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListProvisioningTemplatesResponse is the response type for the
// ListProvisioningTemplates API operation.
type ListProvisioningTemplatesResponse struct {
	*ListProvisioningTemplatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListProvisioningTemplates request.
func (r *ListProvisioningTemplatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
