// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetRepositoryPolicyInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID associated with the registry that contains the repository.
	// If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository with the policy to retrieve.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRepositoryPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositoryPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetRepositoryPolicyInput"}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetRepositoryPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The JSON repository policy text associated with the repository.
	PolicyText *string `locationName:"policyText" type:"string"`

	// The registry ID associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation
func (s GetRepositoryPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetRepositoryPolicy = "GetRepositoryPolicy"

// GetRepositoryPolicyRequest returns a request value for making API operation for
// Amazon EC2 Container Registry.
//
// Retrieves the repository policy for a specified repository.
//
//    // Example sending a request using GetRepositoryPolicyRequest.
//    req := client.GetRepositoryPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetRepositoryPolicy
func (c *Client) GetRepositoryPolicyRequest(input *GetRepositoryPolicyInput) GetRepositoryPolicyRequest {
	op := &aws.Operation{
		Name:       opGetRepositoryPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRepositoryPolicyInput{}
	}

	req := c.newRequest(op, input, &GetRepositoryPolicyOutput{})
	return GetRepositoryPolicyRequest{Request: req, Input: input, Copy: c.GetRepositoryPolicyRequest}
}

// GetRepositoryPolicyRequest is the request type for the
// GetRepositoryPolicy API operation.
type GetRepositoryPolicyRequest struct {
	*aws.Request
	Input *GetRepositoryPolicyInput
	Copy  func(*GetRepositoryPolicyInput) GetRepositoryPolicyRequest
}

// Send marshals and sends the GetRepositoryPolicy API request.
func (r GetRepositoryPolicyRequest) Send(ctx context.Context) (*GetRepositoryPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRepositoryPolicyResponse{
		GetRepositoryPolicyOutput: r.Request.Data.(*GetRepositoryPolicyOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRepositoryPolicyResponse is the response type for the
// GetRepositoryPolicy API operation.
type GetRepositoryPolicyResponse struct {
	*GetRepositoryPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRepositoryPolicy request.
func (r *GetRepositoryPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
