// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datasync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// CancelTaskExecutionRequest
type CancelTaskExecutionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the task execution to cancel.
	//
	// TaskExecutionArn is a required field
	TaskExecutionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CancelTaskExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelTaskExecutionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CancelTaskExecutionInput"}

	if s.TaskExecutionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskExecutionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CancelTaskExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelTaskExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCancelTaskExecution = "CancelTaskExecution"

// CancelTaskExecutionRequest returns a request value for making API operation for
// AWS DataSync.
//
// Cancels execution of a task.
//
// When you cancel a task execution, the transfer of some files are abruptly
// interrupted. The contents of files that are transferred to the destination
// might be incomplete or inconsistent with the source files. However, if you
// start a new task execution on the same task and you allow the task execution
// to complete, file content on the destination is complete and consistent.
// This applies to other unexpected failures that interrupt a task execution.
// In all of these cases, AWS DataSync successfully complete the transfer when
// you start the next task execution.
//
//    // Example sending a request using CancelTaskExecutionRequest.
//    req := client.CancelTaskExecutionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CancelTaskExecution
func (c *Client) CancelTaskExecutionRequest(input *CancelTaskExecutionInput) CancelTaskExecutionRequest {
	op := &aws.Operation{
		Name:       opCancelTaskExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelTaskExecutionInput{}
	}

	req := c.newRequest(op, input, &CancelTaskExecutionOutput{})
	return CancelTaskExecutionRequest{Request: req, Input: input, Copy: c.CancelTaskExecutionRequest}
}

// CancelTaskExecutionRequest is the request type for the
// CancelTaskExecution API operation.
type CancelTaskExecutionRequest struct {
	*aws.Request
	Input *CancelTaskExecutionInput
	Copy  func(*CancelTaskExecutionInput) CancelTaskExecutionRequest
}

// Send marshals and sends the CancelTaskExecution API request.
func (r CancelTaskExecutionRequest) Send(ctx context.Context) (*CancelTaskExecutionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CancelTaskExecutionResponse{
		CancelTaskExecutionOutput: r.Request.Data.(*CancelTaskExecutionOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CancelTaskExecutionResponse is the response type for the
// CancelTaskExecution API operation.
type CancelTaskExecutionResponse struct {
	*CancelTaskExecutionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CancelTaskExecution request.
func (r *CancelTaskExecutionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
