// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to describe a user pool client.
type DescribeUserPoolClientInput struct {
	_ struct{} `type:"structure"`

	// The app client ID of the app associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The user pool ID for the user pool you want to describe.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserPoolClientInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserPoolClientInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeUserPoolClientInput"}

	if s.ClientId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientId", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server from a request to describe the user
// pool client.
type DescribeUserPoolClientOutput struct {
	_ struct{} `type:"structure"`

	// The user pool client from a server response to describe the user pool client.
	UserPoolClient *UserPoolClientType `type:"structure"`
}

// String returns the string representation
func (s DescribeUserPoolClientOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeUserPoolClient = "DescribeUserPoolClient"

// DescribeUserPoolClientRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Client method for returning the configuration information and metadata of
// the specified user pool app client.
//
//    // Example sending a request using DescribeUserPoolClientRequest.
//    req := client.DescribeUserPoolClientRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolClient
func (c *Client) DescribeUserPoolClientRequest(input *DescribeUserPoolClientInput) DescribeUserPoolClientRequest {
	op := &aws.Operation{
		Name:       opDescribeUserPoolClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserPoolClientInput{}
	}

	req := c.newRequest(op, input, &DescribeUserPoolClientOutput{})
	return DescribeUserPoolClientRequest{Request: req, Input: input, Copy: c.DescribeUserPoolClientRequest}
}

// DescribeUserPoolClientRequest is the request type for the
// DescribeUserPoolClient API operation.
type DescribeUserPoolClientRequest struct {
	*aws.Request
	Input *DescribeUserPoolClientInput
	Copy  func(*DescribeUserPoolClientInput) DescribeUserPoolClientRequest
}

// Send marshals and sends the DescribeUserPoolClient API request.
func (r DescribeUserPoolClientRequest) Send(ctx context.Context) (*DescribeUserPoolClientResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeUserPoolClientResponse{
		DescribeUserPoolClientOutput: r.Request.Data.(*DescribeUserPoolClientOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeUserPoolClientResponse is the response type for the
// DescribeUserPoolClient API operation.
type DescribeUserPoolClientResponse struct {
	*DescribeUserPoolClientOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeUserPoolClient request.
func (r *DescribeUserPoolClientResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
