// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateFieldLevelEncryptionConfigInput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryptionConfig"`

	// Request to update a field-level encryption configuration.
	//
	// FieldLevelEncryptionConfig is a required field
	FieldLevelEncryptionConfig *FieldLevelEncryptionConfig `locationName:"FieldLevelEncryptionConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`

	// The ID of the configuration you want to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the configuration
	// identity to update. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s UpdateFieldLevelEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFieldLevelEncryptionConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFieldLevelEncryptionConfigInput"}

	if s.FieldLevelEncryptionConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("FieldLevelEncryptionConfig"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.FieldLevelEncryptionConfig != nil {
		if err := s.FieldLevelEncryptionConfig.Validate(); err != nil {
			invalidParams.AddNested("FieldLevelEncryptionConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFieldLevelEncryptionConfigInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.IfMatch != nil {
		v := *s.IfMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-Match", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.FieldLevelEncryptionConfig != nil {
		v := s.FieldLevelEncryptionConfig

		metadata := protocol.Metadata{XMLNamespaceURI: "http://cloudfront.amazonaws.com/doc/2019-03-26/"}
		e.SetFields(protocol.PayloadTarget, "FieldLevelEncryptionConfig", v, metadata)
	}
	return nil
}

type UpdateFieldLevelEncryptionConfigOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryption"`

	// The value of the ETag header that you received when updating the configuration.
	// For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the results of updating the configuration.
	FieldLevelEncryption *FieldLevelEncryption `type:"structure"`
}

// String returns the string representation
func (s UpdateFieldLevelEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFieldLevelEncryptionConfigOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.FieldLevelEncryption != nil {
		v := s.FieldLevelEncryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "FieldLevelEncryption", v, metadata)
	}
	return nil
}

const opUpdateFieldLevelEncryptionConfig = "UpdateFieldLevelEncryptionConfig2019_03_26"

// UpdateFieldLevelEncryptionConfigRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Update a field-level encryption configuration.
//
//    // Example sending a request using UpdateFieldLevelEncryptionConfigRequest.
//    req := client.UpdateFieldLevelEncryptionConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateFieldLevelEncryptionConfig
func (c *Client) UpdateFieldLevelEncryptionConfigRequest(input *UpdateFieldLevelEncryptionConfigInput) UpdateFieldLevelEncryptionConfigRequest {
	op := &aws.Operation{
		Name:       opUpdateFieldLevelEncryptionConfig,
		HTTPMethod: "PUT",
		HTTPPath:   "/2019-03-26/field-level-encryption/{Id}/config",
	}

	if input == nil {
		input = &UpdateFieldLevelEncryptionConfigInput{}
	}

	req := c.newRequest(op, input, &UpdateFieldLevelEncryptionConfigOutput{})
	return UpdateFieldLevelEncryptionConfigRequest{Request: req, Input: input, Copy: c.UpdateFieldLevelEncryptionConfigRequest}
}

// UpdateFieldLevelEncryptionConfigRequest is the request type for the
// UpdateFieldLevelEncryptionConfig API operation.
type UpdateFieldLevelEncryptionConfigRequest struct {
	*aws.Request
	Input *UpdateFieldLevelEncryptionConfigInput
	Copy  func(*UpdateFieldLevelEncryptionConfigInput) UpdateFieldLevelEncryptionConfigRequest
}

// Send marshals and sends the UpdateFieldLevelEncryptionConfig API request.
func (r UpdateFieldLevelEncryptionConfigRequest) Send(ctx context.Context) (*UpdateFieldLevelEncryptionConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateFieldLevelEncryptionConfigResponse{
		UpdateFieldLevelEncryptionConfigOutput: r.Request.Data.(*UpdateFieldLevelEncryptionConfigOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateFieldLevelEncryptionConfigResponse is the response type for the
// UpdateFieldLevelEncryptionConfig API operation.
type UpdateFieldLevelEncryptionConfigResponse struct {
	*UpdateFieldLevelEncryptionConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateFieldLevelEncryptionConfig request.
func (r *UpdateFieldLevelEncryptionConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
