// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package amplify

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Request structure for create webhook request.
type CreateWebhookInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Name for a branch, part of an Amplify App.
	//
	// BranchName is a required field
	BranchName *string `locationName:"branchName" min:"1" type:"string" required:"true"`

	// Description for a webhook.
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation
func (s CreateWebhookInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWebhookInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateWebhookInput"}

	if s.AppId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AppId", 1))
	}

	if s.BranchName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BranchName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateWebhookInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.BranchName != nil {
		v := *s.BranchName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "branchName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AppId != nil {
		v := *s.AppId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "appId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Result structure for the create webhook request.
type CreateWebhookOutput struct {
	_ struct{} `type:"structure"`

	// Webhook structure.
	//
	// Webhook is a required field
	Webhook *Webhook `locationName:"webhook" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateWebhookOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateWebhookOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Webhook != nil {
		v := s.Webhook

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "webhook", v, metadata)
	}
	return nil
}

const opCreateWebhook = "CreateWebhook"

// CreateWebhookRequest returns a request value for making API operation for
// AWS Amplify.
//
// Create a new webhook on an App.
//
//    // Example sending a request using CreateWebhookRequest.
//    req := client.CreateWebhookRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateWebhook
func (c *Client) CreateWebhookRequest(input *CreateWebhookInput) CreateWebhookRequest {
	op := &aws.Operation{
		Name:       opCreateWebhook,
		HTTPMethod: "POST",
		HTTPPath:   "/apps/{appId}/webhooks",
	}

	if input == nil {
		input = &CreateWebhookInput{}
	}

	req := c.newRequest(op, input, &CreateWebhookOutput{})
	return CreateWebhookRequest{Request: req, Input: input, Copy: c.CreateWebhookRequest}
}

// CreateWebhookRequest is the request type for the
// CreateWebhook API operation.
type CreateWebhookRequest struct {
	*aws.Request
	Input *CreateWebhookInput
	Copy  func(*CreateWebhookInput) CreateWebhookRequest
}

// Send marshals and sends the CreateWebhook API request.
func (r CreateWebhookRequest) Send(ctx context.Context) (*CreateWebhookResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateWebhookResponse{
		CreateWebhookOutput: r.Request.Data.(*CreateWebhookOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateWebhookResponse is the response type for the
// CreateWebhook API operation.
type CreateWebhookResponse struct {
	*CreateWebhookOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateWebhook request.
func (r *CreateWebhookResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
