// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/service/waf"
)

type UpdateGeoMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The GeoMatchSetId of the GeoMatchSet that you want to update. GeoMatchSetId
	// is returned by CreateGeoMatchSet and by ListGeoMatchSets.
	//
	// GeoMatchSetId is a required field
	GeoMatchSetId *string `min:"1" type:"string" required:"true"`

	// An array of GeoMatchSetUpdate objects that you want to insert into or delete
	// from an GeoMatchSet. For more information, see the applicable data types:
	//
	//    * GeoMatchSetUpdate: Contains Action and GeoMatchConstraint
	//
	//    * GeoMatchConstraint: Contains Type and Value You can have only one Type
	//    and Value per GeoMatchConstraint. To add multiple countries, include multiple
	//    GeoMatchSetUpdate objects in your request.
	//
	// Updates is a required field
	Updates []waf.GeoMatchSetUpdate `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateGeoMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGeoMatchSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateGeoMatchSetInput"}

	if s.ChangeToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeToken", 1))
	}

	if s.GeoMatchSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GeoMatchSetId"))
	}
	if s.GeoMatchSetId != nil && len(*s.GeoMatchSetId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GeoMatchSetId", 1))
	}

	if s.Updates == nil {
		invalidParams.Add(aws.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil && len(s.Updates) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Updates", 1))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateGeoMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateGeoMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateGeoMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateGeoMatchSet = "UpdateGeoMatchSet"

// UpdateGeoMatchSetRequest returns a request value for making API operation for
// AWS WAF Regional.
//
// Inserts or deletes GeoMatchConstraint objects in an GeoMatchSet. For each
// GeoMatchConstraint object, you specify the following values:
//
//    * Whether to insert or delete the object from the array. If you want to
//    change an GeoMatchConstraint object, you delete the existing object and
//    add a new one.
//
//    * The Type. The only valid value for Type is Country.
//
//    * The Value, which is a two character code for the country to add to the
//    GeoMatchConstraint object. Valid codes are listed in GeoMatchConstraint$Value.
//
// To create and configure an GeoMatchSet, perform the following steps:
//
// Submit a CreateGeoMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateGeoMatchSet request.
//
// Submit an UpdateGeoMatchSet request to specify the country that you want
// AWS WAF to watch for.
//
// When you update an GeoMatchSet, you specify the country that you want to
// add and/or the country that you want to delete. If you want to change a country,
// you delete the existing country and add the new one.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
//    // Example sending a request using UpdateGeoMatchSetRequest.
//    req := client.UpdateGeoMatchSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateGeoMatchSet
func (c *Client) UpdateGeoMatchSetRequest(input *UpdateGeoMatchSetInput) UpdateGeoMatchSetRequest {
	op := &aws.Operation{
		Name:       opUpdateGeoMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGeoMatchSetInput{}
	}

	req := c.newRequest(op, input, &UpdateGeoMatchSetOutput{})
	return UpdateGeoMatchSetRequest{Request: req, Input: input, Copy: c.UpdateGeoMatchSetRequest}
}

// UpdateGeoMatchSetRequest is the request type for the
// UpdateGeoMatchSet API operation.
type UpdateGeoMatchSetRequest struct {
	*aws.Request
	Input *UpdateGeoMatchSetInput
	Copy  func(*UpdateGeoMatchSetInput) UpdateGeoMatchSetRequest
}

// Send marshals and sends the UpdateGeoMatchSet API request.
func (r UpdateGeoMatchSetRequest) Send(ctx context.Context) (*UpdateGeoMatchSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateGeoMatchSetResponse{
		UpdateGeoMatchSetOutput: r.Request.Data.(*UpdateGeoMatchSetOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateGeoMatchSetResponse is the response type for the
// UpdateGeoMatchSet API operation.
type UpdateGeoMatchSetResponse struct {
	*UpdateGeoMatchSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateGeoMatchSet request.
func (r *UpdateGeoMatchSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
