// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeCustomAvailabilityZonesInput struct {
	_ struct{} `type:"structure"`

	// The custom AZ identifier. If this parameter is specified, information from
	// only the specific custom AZ is returned.
	CustomAvailabilityZoneId *string `type:"string"`

	// A filter that specifies one or more custom AZs to describe.
	Filters []Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeCustomAvailabilityZones
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so you can retrieve the remaining results.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeCustomAvailabilityZonesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCustomAvailabilityZonesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeCustomAvailabilityZonesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeCustomAvailabilityZonesOutput struct {
	_ struct{} `type:"structure"`

	// The list of CustomAvailabilityZone objects for the AWS account.
	CustomAvailabilityZones []CustomAvailabilityZone `locationNameList:"CustomAvailabilityZone" type:"list"`

	// An optional pagination token provided by a previous DescribeCustomAvailabilityZones
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeCustomAvailabilityZonesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeCustomAvailabilityZones = "DescribeCustomAvailabilityZones"

// DescribeCustomAvailabilityZonesRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Returns information about custom Availability Zones (AZs).
//
// A custom AZ is an on-premises AZ that is integrated with a VMware vSphere
// cluster.
//
// For more information about RDS on VMware, see the RDS on VMware User Guide.
// (https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html)
//
//    // Example sending a request using DescribeCustomAvailabilityZonesRequest.
//    req := client.DescribeCustomAvailabilityZonesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCustomAvailabilityZones
func (c *Client) DescribeCustomAvailabilityZonesRequest(input *DescribeCustomAvailabilityZonesInput) DescribeCustomAvailabilityZonesRequest {
	op := &aws.Operation{
		Name:       opDescribeCustomAvailabilityZones,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCustomAvailabilityZonesInput{}
	}

	req := c.newRequest(op, input, &DescribeCustomAvailabilityZonesOutput{})
	return DescribeCustomAvailabilityZonesRequest{Request: req, Input: input, Copy: c.DescribeCustomAvailabilityZonesRequest}
}

// DescribeCustomAvailabilityZonesRequest is the request type for the
// DescribeCustomAvailabilityZones API operation.
type DescribeCustomAvailabilityZonesRequest struct {
	*aws.Request
	Input *DescribeCustomAvailabilityZonesInput
	Copy  func(*DescribeCustomAvailabilityZonesInput) DescribeCustomAvailabilityZonesRequest
}

// Send marshals and sends the DescribeCustomAvailabilityZones API request.
func (r DescribeCustomAvailabilityZonesRequest) Send(ctx context.Context) (*DescribeCustomAvailabilityZonesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeCustomAvailabilityZonesResponse{
		DescribeCustomAvailabilityZonesOutput: r.Request.Data.(*DescribeCustomAvailabilityZonesOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeCustomAvailabilityZonesRequestPaginator returns a paginator for DescribeCustomAvailabilityZones.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeCustomAvailabilityZonesRequest(input)
//   p := rds.NewDescribeCustomAvailabilityZonesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeCustomAvailabilityZonesPaginator(req DescribeCustomAvailabilityZonesRequest) DescribeCustomAvailabilityZonesPaginator {
	return DescribeCustomAvailabilityZonesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeCustomAvailabilityZonesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeCustomAvailabilityZonesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeCustomAvailabilityZonesPaginator struct {
	aws.Pager
}

func (p *DescribeCustomAvailabilityZonesPaginator) CurrentPage() *DescribeCustomAvailabilityZonesOutput {
	return p.Pager.CurrentPage().(*DescribeCustomAvailabilityZonesOutput)
}

// DescribeCustomAvailabilityZonesResponse is the response type for the
// DescribeCustomAvailabilityZones API operation.
type DescribeCustomAvailabilityZonesResponse struct {
	*DescribeCustomAvailabilityZonesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeCustomAvailabilityZones request.
func (r *DescribeCustomAvailabilityZonesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
