// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package mediatailoriface provides an interface to enable mocking the AWS MediaTailor service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package mediatailoriface

import (
	"github.com/aws/aws-sdk-go-v2/service/mediatailor"
)

// ClientAPI provides an interface to enable mocking the
// mediatailor.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // MediaTailor.
//    func myFunc(svc mediatailoriface.ClientAPI) bool {
//        // Make svc.DeletePlaybackConfiguration request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := mediatailor.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        mediatailoriface.ClientPI
//    }
//    func (m *mockClientClient) DeletePlaybackConfiguration(input *mediatailor.DeletePlaybackConfigurationInput) (*mediatailor.DeletePlaybackConfigurationOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	DeletePlaybackConfigurationRequest(*mediatailor.DeletePlaybackConfigurationInput) mediatailor.DeletePlaybackConfigurationRequest

	GetPlaybackConfigurationRequest(*mediatailor.GetPlaybackConfigurationInput) mediatailor.GetPlaybackConfigurationRequest

	ListPlaybackConfigurationsRequest(*mediatailor.ListPlaybackConfigurationsInput) mediatailor.ListPlaybackConfigurationsRequest

	ListTagsForResourceRequest(*mediatailor.ListTagsForResourceInput) mediatailor.ListTagsForResourceRequest

	PutPlaybackConfigurationRequest(*mediatailor.PutPlaybackConfigurationInput) mediatailor.PutPlaybackConfigurationRequest

	TagResourceRequest(*mediatailor.TagResourceInput) mediatailor.TagResourceRequest

	UntagResourceRequest(*mediatailor.UntagResourceInput) mediatailor.UntagResourceRequest
}

var _ ClientAPI = (*mediatailor.Client)(nil)
