// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the user account in the directory used for identity management.
	// If Amazon Connect cannot access the directory, you can specify this identifier
	// to authenticate users. If you include the identifier, we assume that Amazon
	// Connect cannot access the directory. Otherwise, the identity information
	// is used to authenticate users from your directory.
	//
	// This parameter is required if you are using an existing directory for identity
	// management in Amazon Connect when Amazon Connect cannot access your directory
	// to authenticate users. If you are using SAML for identity management and
	// include this parameter, an error is returned.
	DirectoryUserId *string `type:"string"`

	// The identifier of the hierarchy group for the user.
	HierarchyGroupId *string `type:"string"`

	// The information about the identity of the user.
	IdentityInfo *UserIdentityInfo `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The password for the user account. A password is required if you are using
	// Amazon Connect for identity management. Otherwise, it is an error to include
	// a password.
	Password *string `type:"string"`

	// The phone settings for the user.
	//
	// PhoneConfig is a required field
	PhoneConfig *UserPhoneConfig `type:"structure" required:"true"`

	// The identifier of the routing profile for the user.
	//
	// RoutingProfileId is a required field
	RoutingProfileId *string `type:"string" required:"true"`

	// The identifier of the security profile for the user.
	//
	// SecurityProfileIds is a required field
	SecurityProfileIds []string `min:"1" type:"list" required:"true"`

	// One or more tags.
	Tags map[string]string `min:"1" type:"map"`

	// The user name for the account. For instances not using SAML for identity
	// management, the user name can include up to 20 characters. If you are using
	// SAML for identity management, the user name can include up to 64 characters
	// from [a-zA-Z0-9_-.\@]+.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateUserInput"}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceId", 1))
	}

	if s.PhoneConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("PhoneConfig"))
	}

	if s.RoutingProfileId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoutingProfileId"))
	}

	if s.SecurityProfileIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityProfileIds"))
	}
	if s.SecurityProfileIds != nil && len(s.SecurityProfileIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityProfileIds", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}

	if s.Username == nil {
		invalidParams.Add(aws.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Username", 1))
	}
	if s.IdentityInfo != nil {
		if err := s.IdentityInfo.Validate(); err != nil {
			invalidParams.AddNested("IdentityInfo", err.(aws.ErrInvalidParams))
		}
	}
	if s.PhoneConfig != nil {
		if err := s.PhoneConfig.Validate(); err != nil {
			invalidParams.AddNested("PhoneConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateUserInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DirectoryUserId != nil {
		v := *s.DirectoryUserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DirectoryUserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HierarchyGroupId != nil {
		v := *s.HierarchyGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HierarchyGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IdentityInfo != nil {
		v := s.IdentityInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "IdentityInfo", v, metadata)
	}
	if s.Password != nil {
		v := *s.Password

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Password", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PhoneConfig != nil {
		v := s.PhoneConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PhoneConfig", v, metadata)
	}
	if s.RoutingProfileId != nil {
		v := *s.RoutingProfileId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoutingProfileId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityProfileIds != nil {
		v := s.SecurityProfileIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityProfileIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Username != nil {
		v := *s.Username

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Username", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "InstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user account.
	UserArn *string `type:"string"`

	// The identifier of the user account.
	UserId *string `type:"string"`
}

// String returns the string representation
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateUserOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.UserArn != nil {
		v := *s.UserArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateUser = "CreateUser"

// CreateUserRequest returns a request value for making API operation for
// Amazon Connect Service.
//
// Creates a user account for the specified Amazon Connect instance.
//
//    // Example sending a request using CreateUserRequest.
//    req := client.CreateUserRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUser
func (c *Client) CreateUserRequest(input *CreateUserInput) CreateUserRequest {
	op := &aws.Operation{
		Name:       opCreateUser,
		HTTPMethod: "PUT",
		HTTPPath:   "/users/{InstanceId}",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	req := c.newRequest(op, input, &CreateUserOutput{})
	return CreateUserRequest{Request: req, Input: input, Copy: c.CreateUserRequest}
}

// CreateUserRequest is the request type for the
// CreateUser API operation.
type CreateUserRequest struct {
	*aws.Request
	Input *CreateUserInput
	Copy  func(*CreateUserInput) CreateUserRequest
}

// Send marshals and sends the CreateUser API request.
func (r CreateUserRequest) Send(ctx context.Context) (*CreateUserResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateUserResponse{
		CreateUserOutput: r.Request.Data.(*CreateUserOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateUserResponse is the response type for the
// CreateUser API operation.
type CreateUserResponse struct {
	*CreateUserOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateUser request.
func (r *CreateUserResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
