// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListRoomsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The member ID (user ID or bot ID).
	MemberId *string `location:"querystring" locationName:"member-id" type:"string"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListRoomsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRoomsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListRoomsInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRoomsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-results", protocol.Int64Value(v), metadata)
	}
	if s.MemberId != nil {
		v := *s.MemberId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "member-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListRoomsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`

	// The room details.
	Rooms []Room `type:"list"`
}

// String returns the string representation
func (s ListRoomsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRoomsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Rooms != nil {
		v := s.Rooms

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Rooms", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListRooms = "ListRooms"

// ListRoomsRequest returns a request value for making API operation for
// Amazon Chime.
//
// Lists the room details for the specified Amazon Chime account. Optionally,
// filter the results by a member ID (user ID or bot ID) to see a list of rooms
// that the member belongs to.
//
//    // Example sending a request using ListRoomsRequest.
//    req := client.ListRoomsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRooms
func (c *Client) ListRoomsRequest(input *ListRoomsInput) ListRoomsRequest {
	op := &aws.Operation{
		Name:       opListRooms,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/rooms",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoomsInput{}
	}

	req := c.newRequest(op, input, &ListRoomsOutput{})
	return ListRoomsRequest{Request: req, Input: input, Copy: c.ListRoomsRequest}
}

// ListRoomsRequest is the request type for the
// ListRooms API operation.
type ListRoomsRequest struct {
	*aws.Request
	Input *ListRoomsInput
	Copy  func(*ListRoomsInput) ListRoomsRequest
}

// Send marshals and sends the ListRooms API request.
func (r ListRoomsRequest) Send(ctx context.Context) (*ListRoomsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListRoomsResponse{
		ListRoomsOutput: r.Request.Data.(*ListRoomsOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListRoomsRequestPaginator returns a paginator for ListRooms.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListRoomsRequest(input)
//   p := chime.NewListRoomsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListRoomsPaginator(req ListRoomsRequest) ListRoomsPaginator {
	return ListRoomsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListRoomsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListRoomsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListRoomsPaginator struct {
	aws.Pager
}

func (p *ListRoomsPaginator) CurrentPage() *ListRoomsOutput {
	return p.Pager.CurrentPage().(*ListRoomsOutput)
}

// ListRoomsResponse is the response type for the
// ListRooms API operation.
type ListRoomsResponse struct {
	*ListRoomsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListRooms request.
func (r *ListRoomsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
