package apimanagementapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/apimanagement/mgmt/2019-01-01/apimanagement"
	"github.com/Azure/go-autorest/autorest"
)

// APIClientAPI contains the set of methods on the APIClient type.
type APIClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, apiid string, parameters apimanagement.APICreateOrUpdateParameter, ifMatch string) (result apimanagement.APICreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, ifMatch string, deleteRevisions *bool) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, apiid string) (result apimanagement.APIContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, apiid string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, tags string, expandAPIVersionSet *bool) (result apimanagement.APICollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, tags string, expandAPIVersionSet *bool) (result apimanagement.APICollectionIterator, err error)
	ListByTags(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, includeNotTaggedApis *bool) (result apimanagement.TagResourceCollectionPage, err error)
	ListByTagsComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, includeNotTaggedApis *bool) (result apimanagement.TagResourceCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, apiid string, parameters apimanagement.APIUpdateContract, ifMatch string) (result autorest.Response, err error)
}

var _ APIClientAPI = (*apimanagement.APIClient)(nil)

// APIRevisionClientAPI contains the set of methods on the APIRevisionClient type.
type APIRevisionClientAPI interface {
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32) (result apimanagement.APIRevisionCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32) (result apimanagement.APIRevisionCollectionIterator, err error)
}

var _ APIRevisionClientAPI = (*apimanagement.APIRevisionClient)(nil)

// APIReleaseClientAPI contains the set of methods on the APIReleaseClient type.
type APIReleaseClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, apiid string, releaseID string, parameters apimanagement.APIReleaseContract, ifMatch string) (result apimanagement.APIReleaseContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, releaseID string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, apiid string, releaseID string) (result apimanagement.APIReleaseContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, apiid string, releaseID string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32) (result apimanagement.APIReleaseCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32) (result apimanagement.APIReleaseCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, apiid string, releaseID string, parameters apimanagement.APIReleaseContract, ifMatch string) (result autorest.Response, err error)
}

var _ APIReleaseClientAPI = (*apimanagement.APIReleaseClient)(nil)

// APIOperationClientAPI contains the set of methods on the APIOperationClient type.
type APIOperationClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, apiid string, operationID string, parameters apimanagement.OperationContract, ifMatch string) (result apimanagement.OperationContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, operationID string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, apiid string, operationID string) (result apimanagement.OperationContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, apiid string, operationID string) (result autorest.Response, err error)
	ListByAPI(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32, tags string) (result apimanagement.OperationCollectionPage, err error)
	ListByAPIComplete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32, tags string) (result apimanagement.OperationCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, apiid string, operationID string, parameters apimanagement.OperationUpdateContract, ifMatch string) (result autorest.Response, err error)
}

var _ APIOperationClientAPI = (*apimanagement.APIOperationClient)(nil)

// APIOperationPolicyClientAPI contains the set of methods on the APIOperationPolicyClient type.
type APIOperationPolicyClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, apiid string, operationID string, parameters apimanagement.PolicyContract, ifMatch string) (result apimanagement.PolicyContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, operationID string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, apiid string, operationID string, formatParameter apimanagement.PolicyExportFormat) (result apimanagement.PolicyContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, apiid string, operationID string) (result autorest.Response, err error)
	ListByOperation(ctx context.Context, resourceGroupName string, serviceName string, apiid string, operationID string) (result apimanagement.PolicyCollection, err error)
}

var _ APIOperationPolicyClientAPI = (*apimanagement.APIOperationPolicyClient)(nil)

// TagClientAPI contains the set of methods on the TagClient type.
type TagClientAPI interface {
	AssignToAPI(ctx context.Context, resourceGroupName string, serviceName string, apiid string, tagID string) (result apimanagement.TagContract, err error)
	AssignToOperation(ctx context.Context, resourceGroupName string, serviceName string, apiid string, operationID string, tagID string) (result apimanagement.TagContract, err error)
	AssignToProduct(ctx context.Context, resourceGroupName string, serviceName string, productID string, tagID string) (result apimanagement.TagContract, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, tagID string, parameters apimanagement.TagCreateUpdateParameters, ifMatch string) (result apimanagement.TagContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, tagID string, ifMatch string) (result autorest.Response, err error)
	DetachFromAPI(ctx context.Context, resourceGroupName string, serviceName string, apiid string, tagID string) (result autorest.Response, err error)
	DetachFromOperation(ctx context.Context, resourceGroupName string, serviceName string, apiid string, operationID string, tagID string) (result autorest.Response, err error)
	DetachFromProduct(ctx context.Context, resourceGroupName string, serviceName string, productID string, tagID string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, tagID string) (result apimanagement.TagContract, err error)
	GetByAPI(ctx context.Context, resourceGroupName string, serviceName string, apiid string, tagID string) (result apimanagement.TagContract, err error)
	GetByOperation(ctx context.Context, resourceGroupName string, serviceName string, apiid string, operationID string, tagID string) (result apimanagement.TagContract, err error)
	GetByProduct(ctx context.Context, resourceGroupName string, serviceName string, productID string, tagID string) (result apimanagement.TagContract, err error)
	GetEntityState(ctx context.Context, resourceGroupName string, serviceName string, tagID string) (result autorest.Response, err error)
	GetEntityStateByAPI(ctx context.Context, resourceGroupName string, serviceName string, apiid string, tagID string) (result autorest.Response, err error)
	GetEntityStateByOperation(ctx context.Context, resourceGroupName string, serviceName string, apiid string, operationID string, tagID string) (result autorest.Response, err error)
	GetEntityStateByProduct(ctx context.Context, resourceGroupName string, serviceName string, productID string, tagID string) (result autorest.Response, err error)
	ListByAPI(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32) (result apimanagement.TagCollectionPage, err error)
	ListByAPIComplete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32) (result apimanagement.TagCollectionIterator, err error)
	ListByOperation(ctx context.Context, resourceGroupName string, serviceName string, apiid string, operationID string, filter string, top *int32, skip *int32) (result apimanagement.TagCollectionPage, err error)
	ListByOperationComplete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, operationID string, filter string, top *int32, skip *int32) (result apimanagement.TagCollectionIterator, err error)
	ListByProduct(ctx context.Context, resourceGroupName string, serviceName string, productID string, filter string, top *int32, skip *int32) (result apimanagement.TagCollectionPage, err error)
	ListByProductComplete(ctx context.Context, resourceGroupName string, serviceName string, productID string, filter string, top *int32, skip *int32) (result apimanagement.TagCollectionIterator, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, scope string) (result apimanagement.TagCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, scope string) (result apimanagement.TagCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, tagID string, parameters apimanagement.TagCreateUpdateParameters, ifMatch string) (result autorest.Response, err error)
}

var _ TagClientAPI = (*apimanagement.TagClient)(nil)

// APIProductClientAPI contains the set of methods on the APIProductClient type.
type APIProductClientAPI interface {
	ListByApis(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32) (result apimanagement.ProductCollectionPage, err error)
	ListByApisComplete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32) (result apimanagement.ProductCollectionIterator, err error)
}

var _ APIProductClientAPI = (*apimanagement.APIProductClient)(nil)

// APIPolicyClientAPI contains the set of methods on the APIPolicyClient type.
type APIPolicyClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, apiid string, parameters apimanagement.PolicyContract, ifMatch string) (result apimanagement.PolicyContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, apiid string, formatParameter apimanagement.PolicyExportFormat) (result apimanagement.PolicyContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, apiid string) (result autorest.Response, err error)
	ListByAPI(ctx context.Context, resourceGroupName string, serviceName string, apiid string) (result apimanagement.PolicyCollection, err error)
}

var _ APIPolicyClientAPI = (*apimanagement.APIPolicyClient)(nil)

// APISchemaClientAPI contains the set of methods on the APISchemaClient type.
type APISchemaClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, apiid string, schemaID string, parameters apimanagement.SchemaCreateOrUpdateContract, ifMatch string) (result apimanagement.SchemaContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, schemaID string, ifMatch string, force *bool) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, apiid string, schemaID string) (result apimanagement.SchemaContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, apiid string, schemaID string) (result autorest.Response, err error)
	ListByAPI(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32) (result apimanagement.SchemaCollectionPage, err error)
	ListByAPIComplete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32) (result apimanagement.SchemaCollectionIterator, err error)
}

var _ APISchemaClientAPI = (*apimanagement.APISchemaClient)(nil)

// APIDiagnosticClientAPI contains the set of methods on the APIDiagnosticClient type.
type APIDiagnosticClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, apiid string, diagnosticID string, parameters apimanagement.DiagnosticContract, ifMatch string) (result apimanagement.DiagnosticContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, diagnosticID string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, apiid string, diagnosticID string) (result apimanagement.DiagnosticContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, apiid string, diagnosticID string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32) (result apimanagement.DiagnosticCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32) (result apimanagement.DiagnosticCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, apiid string, diagnosticID string, parameters apimanagement.DiagnosticContract, ifMatch string) (result autorest.Response, err error)
}

var _ APIDiagnosticClientAPI = (*apimanagement.APIDiagnosticClient)(nil)

// APIIssueClientAPI contains the set of methods on the APIIssueClient type.
type APIIssueClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string, parameters apimanagement.IssueContract, ifMatch string) (result apimanagement.IssueContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string, expandCommentsAttachments *bool) (result apimanagement.IssueContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, expandCommentsAttachments *bool, top *int32, skip *int32) (result apimanagement.IssueCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, expandCommentsAttachments *bool, top *int32, skip *int32) (result apimanagement.IssueCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string, parameters apimanagement.IssueUpdateContract, ifMatch string) (result autorest.Response, err error)
}

var _ APIIssueClientAPI = (*apimanagement.APIIssueClient)(nil)

// APIIssueCommentClientAPI contains the set of methods on the APIIssueCommentClient type.
type APIIssueCommentClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string, commentID string, parameters apimanagement.IssueCommentContract, ifMatch string) (result apimanagement.IssueCommentContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string, commentID string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string, commentID string) (result apimanagement.IssueCommentContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string, commentID string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string, filter string, top *int32, skip *int32) (result apimanagement.IssueCommentCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string, filter string, top *int32, skip *int32) (result apimanagement.IssueCommentCollectionIterator, err error)
}

var _ APIIssueCommentClientAPI = (*apimanagement.APIIssueCommentClient)(nil)

// APIIssueAttachmentClientAPI contains the set of methods on the APIIssueAttachmentClient type.
type APIIssueAttachmentClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string, attachmentID string, parameters apimanagement.IssueAttachmentContract, ifMatch string) (result apimanagement.IssueAttachmentContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string, attachmentID string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string, attachmentID string) (result apimanagement.IssueAttachmentContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string, attachmentID string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string, filter string, top *int32, skip *int32) (result apimanagement.IssueAttachmentCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, issueID string, filter string, top *int32, skip *int32) (result apimanagement.IssueAttachmentCollectionIterator, err error)
}

var _ APIIssueAttachmentClientAPI = (*apimanagement.APIIssueAttachmentClient)(nil)

// APITagDescriptionClientAPI contains the set of methods on the APITagDescriptionClient type.
type APITagDescriptionClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, apiid string, tagID string, parameters apimanagement.TagDescriptionCreateParameters, ifMatch string) (result apimanagement.TagDescriptionContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, tagID string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, apiid string, tagID string) (result apimanagement.TagDescriptionContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, apiid string, tagID string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32) (result apimanagement.TagDescriptionCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32) (result apimanagement.TagDescriptionCollectionIterator, err error)
}

var _ APITagDescriptionClientAPI = (*apimanagement.APITagDescriptionClient)(nil)

// OperationClientAPI contains the set of methods on the OperationClient type.
type OperationClientAPI interface {
	ListByTags(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32, includeNotTaggedOperations *bool) (result apimanagement.TagResourceCollectionPage, err error)
	ListByTagsComplete(ctx context.Context, resourceGroupName string, serviceName string, apiid string, filter string, top *int32, skip *int32, includeNotTaggedOperations *bool) (result apimanagement.TagResourceCollectionIterator, err error)
}

var _ OperationClientAPI = (*apimanagement.OperationClient)(nil)

// APIVersionSetClientAPI contains the set of methods on the APIVersionSetClient type.
type APIVersionSetClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, versionSetID string, parameters apimanagement.APIVersionSetContract, ifMatch string) (result apimanagement.APIVersionSetContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, versionSetID string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, versionSetID string) (result apimanagement.APIVersionSetContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, versionSetID string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.APIVersionSetCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.APIVersionSetCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, versionSetID string, parameters apimanagement.APIVersionSetUpdateParameters, ifMatch string) (result autorest.Response, err error)
}

var _ APIVersionSetClientAPI = (*apimanagement.APIVersionSetClient)(nil)

// AuthorizationServerClientAPI contains the set of methods on the AuthorizationServerClient type.
type AuthorizationServerClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, authsid string, parameters apimanagement.AuthorizationServerContract, ifMatch string) (result apimanagement.AuthorizationServerContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, authsid string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, authsid string) (result apimanagement.AuthorizationServerContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, authsid string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.AuthorizationServerCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.AuthorizationServerCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, authsid string, parameters apimanagement.AuthorizationServerUpdateContract, ifMatch string) (result autorest.Response, err error)
}

var _ AuthorizationServerClientAPI = (*apimanagement.AuthorizationServerClient)(nil)

// BackendClientAPI contains the set of methods on the BackendClient type.
type BackendClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, backendID string, parameters apimanagement.BackendContract, ifMatch string) (result apimanagement.BackendContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, backendID string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, backendID string) (result apimanagement.BackendContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, backendID string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.BackendCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.BackendCollectionIterator, err error)
	Reconnect(ctx context.Context, resourceGroupName string, serviceName string, backendID string, parameters *apimanagement.BackendReconnectContract) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, backendID string, parameters apimanagement.BackendUpdateParameters, ifMatch string) (result autorest.Response, err error)
}

var _ BackendClientAPI = (*apimanagement.BackendClient)(nil)

// CacheClientAPI contains the set of methods on the CacheClient type.
type CacheClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, cacheID string, parameters apimanagement.CacheContract, ifMatch string) (result apimanagement.CacheContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, cacheID string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, cacheID string) (result apimanagement.CacheContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, cacheID string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, top *int32, skip *int32) (result apimanagement.CacheCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, top *int32, skip *int32) (result apimanagement.CacheCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, cacheID string, parameters apimanagement.CacheUpdateParameters, ifMatch string) (result autorest.Response, err error)
}

var _ CacheClientAPI = (*apimanagement.CacheClient)(nil)

// CertificateClientAPI contains the set of methods on the CertificateClient type.
type CertificateClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, certificateID string, parameters apimanagement.CertificateCreateOrUpdateParameters, ifMatch string) (result apimanagement.CertificateContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, certificateID string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, certificateID string) (result apimanagement.CertificateContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, certificateID string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.CertificateCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.CertificateCollectionIterator, err error)
}

var _ CertificateClientAPI = (*apimanagement.CertificateClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result apimanagement.OperationListResultPage, err error)
	ListComplete(ctx context.Context) (result apimanagement.OperationListResultIterator, err error)
}

var _ OperationsClientAPI = (*apimanagement.OperationsClient)(nil)

// ServiceSkusClientAPI contains the set of methods on the ServiceSkusClient type.
type ServiceSkusClientAPI interface {
	ListAvailableServiceSkus(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.ResourceSkuResultsPage, err error)
	ListAvailableServiceSkusComplete(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.ResourceSkuResultsIterator, err error)
}

var _ ServiceSkusClientAPI = (*apimanagement.ServiceSkusClient)(nil)

// ServiceClientAPI contains the set of methods on the ServiceClient type.
type ServiceClientAPI interface {
	ApplyNetworkConfigurationUpdates(ctx context.Context, resourceGroupName string, serviceName string, parameters *apimanagement.ServiceApplyNetworkConfigurationParameters) (result apimanagement.ServiceApplyNetworkConfigurationUpdatesFuture, err error)
	Backup(ctx context.Context, resourceGroupName string, serviceName string, parameters apimanagement.ServiceBackupRestoreParameters) (result apimanagement.ServiceBackupFuture, err error)
	CheckNameAvailability(ctx context.Context, parameters apimanagement.ServiceCheckNameAvailabilityParameters) (result apimanagement.ServiceNameAvailabilityResult, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, parameters apimanagement.ServiceResource) (result apimanagement.ServiceCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.ServiceDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.ServiceResource, err error)
	GetSsoToken(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.ServiceGetSsoTokenResult, err error)
	List(ctx context.Context) (result apimanagement.ServiceListResultPage, err error)
	ListComplete(ctx context.Context) (result apimanagement.ServiceListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result apimanagement.ServiceListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result apimanagement.ServiceListResultIterator, err error)
	Restore(ctx context.Context, resourceGroupName string, serviceName string, parameters apimanagement.ServiceBackupRestoreParameters) (result apimanagement.ServiceRestoreFuture, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, parameters apimanagement.ServiceUpdateParameters) (result apimanagement.ServiceUpdateFuture, err error)
}

var _ ServiceClientAPI = (*apimanagement.ServiceClient)(nil)

// DiagnosticClientAPI contains the set of methods on the DiagnosticClient type.
type DiagnosticClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, diagnosticID string, parameters apimanagement.DiagnosticContract, ifMatch string) (result apimanagement.DiagnosticContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, diagnosticID string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, diagnosticID string) (result apimanagement.DiagnosticContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, diagnosticID string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.DiagnosticCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.DiagnosticCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, diagnosticID string, parameters apimanagement.DiagnosticContract, ifMatch string) (result autorest.Response, err error)
}

var _ DiagnosticClientAPI = (*apimanagement.DiagnosticClient)(nil)

// EmailTemplateClientAPI contains the set of methods on the EmailTemplateClient type.
type EmailTemplateClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, templateName apimanagement.TemplateName, parameters apimanagement.EmailTemplateUpdateParameters, ifMatch string) (result apimanagement.EmailTemplateContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, templateName apimanagement.TemplateName, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, templateName apimanagement.TemplateName) (result apimanagement.EmailTemplateContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, templateName apimanagement.TemplateName) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.EmailTemplateCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.EmailTemplateCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, templateName apimanagement.TemplateName, parameters apimanagement.EmailTemplateUpdateParameters, ifMatch string) (result autorest.Response, err error)
}

var _ EmailTemplateClientAPI = (*apimanagement.EmailTemplateClient)(nil)

// GroupClientAPI contains the set of methods on the GroupClient type.
type GroupClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, groupID string, parameters apimanagement.GroupCreateParameters, ifMatch string) (result apimanagement.GroupContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, groupID string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, groupID string) (result apimanagement.GroupContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, groupID string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.GroupCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.GroupCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, groupID string, parameters apimanagement.GroupUpdateParameters, ifMatch string) (result autorest.Response, err error)
}

var _ GroupClientAPI = (*apimanagement.GroupClient)(nil)

// GroupUserClientAPI contains the set of methods on the GroupUserClient type.
type GroupUserClientAPI interface {
	CheckEntityExists(ctx context.Context, resourceGroupName string, serviceName string, groupID string, userID string) (result autorest.Response, err error)
	Create(ctx context.Context, resourceGroupName string, serviceName string, groupID string, userID string) (result apimanagement.UserContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, groupID string, userID string) (result autorest.Response, err error)
	List(ctx context.Context, resourceGroupName string, serviceName string, groupID string, filter string, top *int32, skip *int32) (result apimanagement.UserCollectionPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, serviceName string, groupID string, filter string, top *int32, skip *int32) (result apimanagement.UserCollectionIterator, err error)
}

var _ GroupUserClientAPI = (*apimanagement.GroupUserClient)(nil)

// IdentityProviderClientAPI contains the set of methods on the IdentityProviderClient type.
type IdentityProviderClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, identityProviderName apimanagement.IdentityProviderType, parameters apimanagement.IdentityProviderContract, ifMatch string) (result apimanagement.IdentityProviderContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, identityProviderName apimanagement.IdentityProviderType, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, identityProviderName apimanagement.IdentityProviderType) (result apimanagement.IdentityProviderContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, identityProviderName apimanagement.IdentityProviderType) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.IdentityProviderListPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.IdentityProviderListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, identityProviderName apimanagement.IdentityProviderType, parameters apimanagement.IdentityProviderUpdateParameters, ifMatch string) (result autorest.Response, err error)
}

var _ IdentityProviderClientAPI = (*apimanagement.IdentityProviderClient)(nil)

// IssueClientAPI contains the set of methods on the IssueClient type.
type IssueClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serviceName string, issueID string) (result apimanagement.IssueContract, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.IssueCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.IssueCollectionIterator, err error)
}

var _ IssueClientAPI = (*apimanagement.IssueClient)(nil)

// LoggerClientAPI contains the set of methods on the LoggerClient type.
type LoggerClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, loggerID string, parameters apimanagement.LoggerContract, ifMatch string) (result apimanagement.LoggerContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, loggerID string, ifMatch string, force *bool) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, loggerID string) (result apimanagement.LoggerContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, loggerID string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.LoggerCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.LoggerCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, loggerID string, parameters apimanagement.LoggerUpdateContract, ifMatch string) (result autorest.Response, err error)
}

var _ LoggerClientAPI = (*apimanagement.LoggerClient)(nil)

// NetworkStatusClientAPI contains the set of methods on the NetworkStatusClient type.
type NetworkStatusClientAPI interface {
	ListByLocation(ctx context.Context, resourceGroupName string, serviceName string, locationName string) (result apimanagement.NetworkStatusContract, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.ListNetworkStatusContractByLocation, err error)
}

var _ NetworkStatusClientAPI = (*apimanagement.NetworkStatusClient)(nil)

// NotificationClientAPI contains the set of methods on the NotificationClient type.
type NotificationClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, notificationName apimanagement.NotificationName, ifMatch string) (result apimanagement.NotificationContract, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, notificationName apimanagement.NotificationName) (result apimanagement.NotificationContract, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, top *int32, skip *int32) (result apimanagement.NotificationCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, top *int32, skip *int32) (result apimanagement.NotificationCollectionIterator, err error)
}

var _ NotificationClientAPI = (*apimanagement.NotificationClient)(nil)

// NotificationRecipientUserClientAPI contains the set of methods on the NotificationRecipientUserClient type.
type NotificationRecipientUserClientAPI interface {
	CheckEntityExists(ctx context.Context, resourceGroupName string, serviceName string, notificationName apimanagement.NotificationName, userID string) (result autorest.Response, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, notificationName apimanagement.NotificationName, userID string) (result apimanagement.RecipientUserContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, notificationName apimanagement.NotificationName, userID string) (result autorest.Response, err error)
	ListByNotification(ctx context.Context, resourceGroupName string, serviceName string, notificationName apimanagement.NotificationName) (result apimanagement.RecipientUserCollection, err error)
}

var _ NotificationRecipientUserClientAPI = (*apimanagement.NotificationRecipientUserClient)(nil)

// NotificationRecipientEmailClientAPI contains the set of methods on the NotificationRecipientEmailClient type.
type NotificationRecipientEmailClientAPI interface {
	CheckEntityExists(ctx context.Context, resourceGroupName string, serviceName string, notificationName apimanagement.NotificationName, email string) (result autorest.Response, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, notificationName apimanagement.NotificationName, email string) (result apimanagement.RecipientEmailContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, notificationName apimanagement.NotificationName, email string) (result autorest.Response, err error)
	ListByNotification(ctx context.Context, resourceGroupName string, serviceName string, notificationName apimanagement.NotificationName) (result apimanagement.RecipientEmailCollection, err error)
}

var _ NotificationRecipientEmailClientAPI = (*apimanagement.NotificationRecipientEmailClient)(nil)

// OpenIDConnectProviderClientAPI contains the set of methods on the OpenIDConnectProviderClient type.
type OpenIDConnectProviderClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, opid string, parameters apimanagement.OpenidConnectProviderContract, ifMatch string) (result apimanagement.OpenidConnectProviderContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, opid string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, opid string) (result apimanagement.OpenidConnectProviderContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, opid string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.OpenIDConnectProviderCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.OpenIDConnectProviderCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, opid string, parameters apimanagement.OpenidConnectProviderUpdateContract, ifMatch string) (result autorest.Response, err error)
}

var _ OpenIDConnectProviderClientAPI = (*apimanagement.OpenIDConnectProviderClient)(nil)

// PolicyClientAPI contains the set of methods on the PolicyClient type.
type PolicyClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, parameters apimanagement.PolicyContract, ifMatch string) (result apimanagement.PolicyContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, formatParameter apimanagement.PolicyExportFormat) (result apimanagement.PolicyContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.PolicyCollection, err error)
}

var _ PolicyClientAPI = (*apimanagement.PolicyClient)(nil)

// PolicySnippetClientAPI contains the set of methods on the PolicySnippetClient type.
type PolicySnippetClientAPI interface {
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, scope apimanagement.PolicyScopeContract) (result apimanagement.PolicySnippetsCollection, err error)
}

var _ PolicySnippetClientAPI = (*apimanagement.PolicySnippetClient)(nil)

// SignInSettingsClientAPI contains the set of methods on the SignInSettingsClient type.
type SignInSettingsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, parameters apimanagement.PortalSigninSettings, ifMatch string) (result apimanagement.PortalSigninSettings, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.PortalSigninSettings, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, parameters apimanagement.PortalSigninSettings, ifMatch string) (result autorest.Response, err error)
}

var _ SignInSettingsClientAPI = (*apimanagement.SignInSettingsClient)(nil)

// SignUpSettingsClientAPI contains the set of methods on the SignUpSettingsClient type.
type SignUpSettingsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, parameters apimanagement.PortalSignupSettings, ifMatch string) (result apimanagement.PortalSignupSettings, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.PortalSignupSettings, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, parameters apimanagement.PortalSignupSettings, ifMatch string) (result autorest.Response, err error)
}

var _ SignUpSettingsClientAPI = (*apimanagement.SignUpSettingsClient)(nil)

// DelegationSettingsClientAPI contains the set of methods on the DelegationSettingsClient type.
type DelegationSettingsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, parameters apimanagement.PortalDelegationSettings, ifMatch string) (result apimanagement.PortalDelegationSettings, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.PortalDelegationSettings, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, parameters apimanagement.PortalDelegationSettings, ifMatch string) (result autorest.Response, err error)
}

var _ DelegationSettingsClientAPI = (*apimanagement.DelegationSettingsClient)(nil)

// ProductClientAPI contains the set of methods on the ProductClient type.
type ProductClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, productID string, parameters apimanagement.ProductContract, ifMatch string) (result apimanagement.ProductContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, productID string, ifMatch string, deleteSubscriptions *bool) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, productID string) (result apimanagement.ProductContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, productID string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, expandGroups *bool, tags string) (result apimanagement.ProductCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, expandGroups *bool, tags string) (result apimanagement.ProductCollectionIterator, err error)
	ListByTags(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, includeNotTaggedProducts *bool) (result apimanagement.TagResourceCollectionPage, err error)
	ListByTagsComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, includeNotTaggedProducts *bool) (result apimanagement.TagResourceCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, productID string, parameters apimanagement.ProductUpdateParameters, ifMatch string) (result autorest.Response, err error)
}

var _ ProductClientAPI = (*apimanagement.ProductClient)(nil)

// ProductAPIClientAPI contains the set of methods on the ProductAPIClient type.
type ProductAPIClientAPI interface {
	CheckEntityExists(ctx context.Context, resourceGroupName string, serviceName string, productID string, apiid string) (result autorest.Response, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, productID string, apiid string) (result apimanagement.APIContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, productID string, apiid string) (result autorest.Response, err error)
	ListByProduct(ctx context.Context, resourceGroupName string, serviceName string, productID string, filter string, top *int32, skip *int32) (result apimanagement.APICollectionPage, err error)
	ListByProductComplete(ctx context.Context, resourceGroupName string, serviceName string, productID string, filter string, top *int32, skip *int32) (result apimanagement.APICollectionIterator, err error)
}

var _ ProductAPIClientAPI = (*apimanagement.ProductAPIClient)(nil)

// ProductGroupClientAPI contains the set of methods on the ProductGroupClient type.
type ProductGroupClientAPI interface {
	CheckEntityExists(ctx context.Context, resourceGroupName string, serviceName string, productID string, groupID string) (result autorest.Response, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, productID string, groupID string) (result apimanagement.GroupContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, productID string, groupID string) (result autorest.Response, err error)
	ListByProduct(ctx context.Context, resourceGroupName string, serviceName string, productID string, filter string, top *int32, skip *int32) (result apimanagement.GroupCollectionPage, err error)
	ListByProductComplete(ctx context.Context, resourceGroupName string, serviceName string, productID string, filter string, top *int32, skip *int32) (result apimanagement.GroupCollectionIterator, err error)
}

var _ ProductGroupClientAPI = (*apimanagement.ProductGroupClient)(nil)

// ProductSubscriptionsClientAPI contains the set of methods on the ProductSubscriptionsClient type.
type ProductSubscriptionsClientAPI interface {
	List(ctx context.Context, resourceGroupName string, serviceName string, productID string, filter string, top *int32, skip *int32) (result apimanagement.SubscriptionCollectionPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, serviceName string, productID string, filter string, top *int32, skip *int32) (result apimanagement.SubscriptionCollectionIterator, err error)
}

var _ ProductSubscriptionsClientAPI = (*apimanagement.ProductSubscriptionsClient)(nil)

// ProductPolicyClientAPI contains the set of methods on the ProductPolicyClient type.
type ProductPolicyClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, productID string, parameters apimanagement.PolicyContract, ifMatch string) (result apimanagement.PolicyContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, productID string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, productID string, formatParameter apimanagement.PolicyExportFormat) (result apimanagement.PolicyContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, productID string) (result autorest.Response, err error)
	ListByProduct(ctx context.Context, resourceGroupName string, serviceName string, productID string) (result apimanagement.PolicyCollection, err error)
}

var _ ProductPolicyClientAPI = (*apimanagement.ProductPolicyClient)(nil)

// PropertyClientAPI contains the set of methods on the PropertyClient type.
type PropertyClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, propID string, parameters apimanagement.PropertyContract, ifMatch string) (result apimanagement.PropertyContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, propID string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, propID string) (result apimanagement.PropertyContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, propID string) (result autorest.Response, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.PropertyCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.PropertyCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, propID string, parameters apimanagement.PropertyUpdateParameters, ifMatch string) (result autorest.Response, err error)
}

var _ PropertyClientAPI = (*apimanagement.PropertyClient)(nil)

// QuotaByCounterKeysClientAPI contains the set of methods on the QuotaByCounterKeysClient type.
type QuotaByCounterKeysClientAPI interface {
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, quotaCounterKey string) (result apimanagement.QuotaCounterCollection, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, quotaCounterKey string, parameters apimanagement.QuotaCounterValueContractProperties) (result autorest.Response, err error)
}

var _ QuotaByCounterKeysClientAPI = (*apimanagement.QuotaByCounterKeysClient)(nil)

// QuotaByPeriodKeysClientAPI contains the set of methods on the QuotaByPeriodKeysClient type.
type QuotaByPeriodKeysClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serviceName string, quotaCounterKey string, quotaPeriodKey string) (result apimanagement.QuotaCounterContract, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, quotaCounterKey string, quotaPeriodKey string, parameters apimanagement.QuotaCounterValueContractProperties) (result autorest.Response, err error)
}

var _ QuotaByPeriodKeysClientAPI = (*apimanagement.QuotaByPeriodKeysClient)(nil)

// RegionClientAPI contains the set of methods on the RegionClient type.
type RegionClientAPI interface {
	ListByService(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.RegionListResultPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.RegionListResultIterator, err error)
}

var _ RegionClientAPI = (*apimanagement.RegionClient)(nil)

// ReportsClientAPI contains the set of methods on the ReportsClient type.
type ReportsClientAPI interface {
	ListByAPI(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, orderby string) (result apimanagement.ReportCollectionPage, err error)
	ListByAPIComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, orderby string) (result apimanagement.ReportCollectionIterator, err error)
	ListByGeo(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.ReportCollectionPage, err error)
	ListByGeoComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.ReportCollectionIterator, err error)
	ListByOperation(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, orderby string) (result apimanagement.ReportCollectionPage, err error)
	ListByOperationComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, orderby string) (result apimanagement.ReportCollectionIterator, err error)
	ListByProduct(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, orderby string) (result apimanagement.ReportCollectionPage, err error)
	ListByProductComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, orderby string) (result apimanagement.ReportCollectionIterator, err error)
	ListByRequest(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.RequestReportCollection, err error)
	ListBySubscription(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, orderby string) (result apimanagement.ReportCollectionPage, err error)
	ListBySubscriptionComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, orderby string) (result apimanagement.ReportCollectionIterator, err error)
	ListByTime(ctx context.Context, resourceGroupName string, serviceName string, filter string, interval string, top *int32, skip *int32, orderby string) (result apimanagement.ReportCollectionPage, err error)
	ListByTimeComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, interval string, top *int32, skip *int32, orderby string) (result apimanagement.ReportCollectionIterator, err error)
	ListByUser(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, orderby string) (result apimanagement.ReportCollectionPage, err error)
	ListByUserComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, orderby string) (result apimanagement.ReportCollectionIterator, err error)
}

var _ ReportsClientAPI = (*apimanagement.ReportsClient)(nil)

// SubscriptionClientAPI contains the set of methods on the SubscriptionClient type.
type SubscriptionClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, sid string, parameters apimanagement.SubscriptionCreateParameters, notify *bool, ifMatch string) (result apimanagement.SubscriptionContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, sid string, ifMatch string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, sid string) (result apimanagement.SubscriptionContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, sid string) (result autorest.Response, err error)
	List(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.SubscriptionCollectionPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.SubscriptionCollectionIterator, err error)
	RegeneratePrimaryKey(ctx context.Context, resourceGroupName string, serviceName string, sid string) (result autorest.Response, err error)
	RegenerateSecondaryKey(ctx context.Context, resourceGroupName string, serviceName string, sid string) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, sid string, parameters apimanagement.SubscriptionUpdateParameters, ifMatch string, notify *bool) (result autorest.Response, err error)
}

var _ SubscriptionClientAPI = (*apimanagement.SubscriptionClient)(nil)

// TagResourceClientAPI contains the set of methods on the TagResourceClient type.
type TagResourceClientAPI interface {
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.TagResourceCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32) (result apimanagement.TagResourceCollectionIterator, err error)
}

var _ TagResourceClientAPI = (*apimanagement.TagResourceClient)(nil)

// TenantAccessClientAPI contains the set of methods on the TenantAccessClient type.
type TenantAccessClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.AccessInformationContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string) (result autorest.Response, err error)
	RegeneratePrimaryKey(ctx context.Context, resourceGroupName string, serviceName string) (result autorest.Response, err error)
	RegenerateSecondaryKey(ctx context.Context, resourceGroupName string, serviceName string) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, parameters apimanagement.AccessInformationUpdateParameters, ifMatch string) (result autorest.Response, err error)
}

var _ TenantAccessClientAPI = (*apimanagement.TenantAccessClient)(nil)

// TenantAccessGitClientAPI contains the set of methods on the TenantAccessGitClient type.
type TenantAccessGitClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.AccessInformationContract, err error)
	RegeneratePrimaryKey(ctx context.Context, resourceGroupName string, serviceName string) (result autorest.Response, err error)
	RegenerateSecondaryKey(ctx context.Context, resourceGroupName string, serviceName string) (result autorest.Response, err error)
}

var _ TenantAccessGitClientAPI = (*apimanagement.TenantAccessGitClient)(nil)

// TenantConfigurationClientAPI contains the set of methods on the TenantConfigurationClient type.
type TenantConfigurationClientAPI interface {
	Deploy(ctx context.Context, resourceGroupName string, serviceName string, parameters apimanagement.DeployConfigurationParameters) (result apimanagement.TenantConfigurationDeployFuture, err error)
	GetSyncState(ctx context.Context, resourceGroupName string, serviceName string) (result apimanagement.TenantConfigurationSyncStateContract, err error)
	Save(ctx context.Context, resourceGroupName string, serviceName string, parameters apimanagement.SaveConfigurationParameter) (result apimanagement.TenantConfigurationSaveFuture, err error)
	Validate(ctx context.Context, resourceGroupName string, serviceName string, parameters apimanagement.DeployConfigurationParameters) (result apimanagement.TenantConfigurationValidateFuture, err error)
}

var _ TenantConfigurationClientAPI = (*apimanagement.TenantConfigurationClient)(nil)

// UserClientAPI contains the set of methods on the UserClient type.
type UserClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, userID string, parameters apimanagement.UserCreateParameters, ifMatch string) (result apimanagement.UserContract, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string, userID string, ifMatch string, deleteSubscriptions *bool, notify *bool) (result autorest.Response, err error)
	GenerateSsoURL(ctx context.Context, resourceGroupName string, serviceName string, userID string) (result apimanagement.GenerateSsoURLResult, err error)
	Get(ctx context.Context, resourceGroupName string, serviceName string, userID string) (result apimanagement.UserContract, err error)
	GetEntityTag(ctx context.Context, resourceGroupName string, serviceName string, userID string) (result autorest.Response, err error)
	GetSharedAccessToken(ctx context.Context, resourceGroupName string, serviceName string, userID string, parameters apimanagement.UserTokenParameters) (result apimanagement.UserTokenResult, err error)
	ListByService(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, expandGroups *bool) (result apimanagement.UserCollectionPage, err error)
	ListByServiceComplete(ctx context.Context, resourceGroupName string, serviceName string, filter string, top *int32, skip *int32, expandGroups *bool) (result apimanagement.UserCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serviceName string, userID string, parameters apimanagement.UserUpdateParameters, ifMatch string) (result autorest.Response, err error)
}

var _ UserClientAPI = (*apimanagement.UserClient)(nil)

// UserGroupClientAPI contains the set of methods on the UserGroupClient type.
type UserGroupClientAPI interface {
	List(ctx context.Context, resourceGroupName string, serviceName string, userID string, filter string, top *int32, skip *int32) (result apimanagement.GroupCollectionPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, serviceName string, userID string, filter string, top *int32, skip *int32) (result apimanagement.GroupCollectionIterator, err error)
}

var _ UserGroupClientAPI = (*apimanagement.UserGroupClient)(nil)

// UserSubscriptionClientAPI contains the set of methods on the UserSubscriptionClient type.
type UserSubscriptionClientAPI interface {
	List(ctx context.Context, resourceGroupName string, serviceName string, userID string, filter string, top *int32, skip *int32) (result apimanagement.SubscriptionCollectionPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, serviceName string, userID string, filter string, top *int32, skip *int32) (result apimanagement.SubscriptionCollectionIterator, err error)
}

var _ UserSubscriptionClientAPI = (*apimanagement.UserSubscriptionClient)(nil)

// UserIdentitiesClientAPI contains the set of methods on the UserIdentitiesClient type.
type UserIdentitiesClientAPI interface {
	List(ctx context.Context, resourceGroupName string, serviceName string, userID string) (result apimanagement.UserIdentityCollectionPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, serviceName string, userID string) (result apimanagement.UserIdentityCollectionIterator, err error)
}

var _ UserIdentitiesClientAPI = (*apimanagement.UserIdentitiesClient)(nil)

// UserConfirmationPasswordClientAPI contains the set of methods on the UserConfirmationPasswordClient type.
type UserConfirmationPasswordClientAPI interface {
	Send(ctx context.Context, resourceGroupName string, serviceName string, userID string) (result autorest.Response, err error)
}

var _ UserConfirmationPasswordClientAPI = (*apimanagement.UserConfirmationPasswordClient)(nil)

// APIExportClientAPI contains the set of methods on the APIExportClient type.
type APIExportClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serviceName string, apiid string, formatParameter apimanagement.ExportFormat) (result apimanagement.APIExportResult, err error)
}

var _ APIExportClientAPI = (*apimanagement.APIExportClient)(nil)
