package containerregistry

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RefreshTokensClient is the metadata API definition for the Azure Container Registry runtime
type RefreshTokensClient struct {
	BaseClient
}

// NewRefreshTokensClient creates an instance of the RefreshTokensClient client.
func NewRefreshTokensClient(loginURI string) RefreshTokensClient {
	return RefreshTokensClient{New(loginURI)}
}

// GetFromExchange exchange AAD tokens for an ACR refresh Token
// Parameters:
// grantType - can take a value of access_token_refresh_token, or access_token, or refresh_token
// service - indicates the name of your Azure container registry.
// tenant - AAD tenant associated to the AAD credentials.
// refreshToken - AAD refresh token, mandatory when grant_type is access_token_refresh_token or refresh_token
// accessToken - AAD access token, mandatory when grant_type is access_token_refresh_token or access_token.
func (client RefreshTokensClient) GetFromExchange(ctx context.Context, grantType string, service string, tenant string, refreshToken string, accessToken string) (result RefreshToken, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RefreshTokensClient.GetFromExchange")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetFromExchangePreparer(ctx, grantType, service, tenant, refreshToken, accessToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RefreshTokensClient", "GetFromExchange", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetFromExchangeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "containerregistry.RefreshTokensClient", "GetFromExchange", resp, "Failure sending request")
		return
	}

	result, err = client.GetFromExchangeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RefreshTokensClient", "GetFromExchange", resp, "Failure responding to request")
	}

	return
}

// GetFromExchangePreparer prepares the GetFromExchange request.
func (client RefreshTokensClient) GetFromExchangePreparer(ctx context.Context, grantType string, service string, tenant string, refreshToken string, accessToken string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.LoginURI,
	}

	formDataParameters := map[string]interface{}{
		"grant_type": grantType,
		"service":    service,
	}
	if len(tenant) > 0 {
		formDataParameters["tenant"] = tenant
	}
	if len(refreshToken) > 0 {
		formDataParameters["refresh_token"] = refreshToken
	}
	if len(accessToken) > 0 {
		formDataParameters["access_token"] = accessToken
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPath("/oauth2/exchange"),
		autorest.WithFormData(autorest.MapToValues(formDataParameters)))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetFromExchangeSender sends the GetFromExchange request. The method will close the
// http.Response Body if it receives an error.
func (client RefreshTokensClient) GetFromExchangeSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetFromExchangeResponder handles the response to the GetFromExchange request. The method always
// closes the http.Response Body.
func (client RefreshTokensClient) GetFromExchangeResponder(resp *http.Response) (result RefreshToken, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
