package billing

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RoleAssignmentsClient is the billing client provides access to billing resources for Azure subscriptions.
type RoleAssignmentsClient struct {
	BaseClient
}

// NewRoleAssignmentsClient creates an instance of the RoleAssignmentsClient client.
func NewRoleAssignmentsClient(subscriptionID string) RoleAssignmentsClient {
	return NewRoleAssignmentsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewRoleAssignmentsClientWithBaseURI creates an instance of the RoleAssignmentsClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewRoleAssignmentsClientWithBaseURI(baseURI string, subscriptionID string) RoleAssignmentsClient {
	return RoleAssignmentsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// AddByBillingAccountName the operation to add a role assignment to a billing account.
// Parameters:
// billingAccountName - billing Account Id.
// parameters - parameters supplied to add a role assignment.
func (client RoleAssignmentsClient) AddByBillingAccountName(ctx context.Context, billingAccountName string, parameters RoleAssignmentPayload) (result RoleAssignmentListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.AddByBillingAccountName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddByBillingAccountNamePreparer(ctx, billingAccountName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "AddByBillingAccountName", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddByBillingAccountNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "AddByBillingAccountName", resp, "Failure sending request")
		return
	}

	result, err = client.AddByBillingAccountNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "AddByBillingAccountName", resp, "Failure responding to request")
	}

	return
}

// AddByBillingAccountNamePreparer prepares the AddByBillingAccountName request.
func (client RoleAssignmentsClient) AddByBillingAccountNamePreparer(ctx context.Context, billingAccountName string, parameters RoleAssignmentPayload) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName": autorest.Encode("path", billingAccountName),
	}

	const APIVersion = "2018-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/providers/Microsoft.Billing/createBillingRoleAssignment", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddByBillingAccountNameSender sends the AddByBillingAccountName request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) AddByBillingAccountNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// AddByBillingAccountNameResponder handles the response to the AddByBillingAccountName request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) AddByBillingAccountNameResponder(resp *http.Response) (result RoleAssignmentListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddByBillingProfileName the operation to add a role assignment to a billing profile.
// Parameters:
// billingAccountName - billing Account Id.
// billingProfileName - billing Profile Id.
// parameters - parameters supplied to add a role assignment.
func (client RoleAssignmentsClient) AddByBillingProfileName(ctx context.Context, billingAccountName string, billingProfileName string, parameters RoleAssignmentPayload) (result RoleAssignmentListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.AddByBillingProfileName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddByBillingProfileNamePreparer(ctx, billingAccountName, billingProfileName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "AddByBillingProfileName", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddByBillingProfileNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "AddByBillingProfileName", resp, "Failure sending request")
		return
	}

	result, err = client.AddByBillingProfileNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "AddByBillingProfileName", resp, "Failure responding to request")
	}

	return
}

// AddByBillingProfileNamePreparer prepares the AddByBillingProfileName request.
func (client RoleAssignmentsClient) AddByBillingProfileNamePreparer(ctx context.Context, billingAccountName string, billingProfileName string, parameters RoleAssignmentPayload) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName": autorest.Encode("path", billingAccountName),
		"billingProfileName": autorest.Encode("path", billingProfileName),
	}

	const APIVersion = "2018-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/providers/Microsoft.Billing/createBillingRoleAssignment", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddByBillingProfileNameSender sends the AddByBillingProfileName request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) AddByBillingProfileNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// AddByBillingProfileNameResponder handles the response to the AddByBillingProfileName request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) AddByBillingProfileNameResponder(resp *http.Response) (result RoleAssignmentListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddByInvoiceSectionName the operation to add a role assignment to a invoice Section.
// Parameters:
// billingAccountName - billing Account Id.
// invoiceSectionName - invoiceSection Id.
// parameters - parameters supplied to add a role assignment.
func (client RoleAssignmentsClient) AddByInvoiceSectionName(ctx context.Context, billingAccountName string, invoiceSectionName string, parameters RoleAssignmentPayload) (result RoleAssignmentListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.AddByInvoiceSectionName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddByInvoiceSectionNamePreparer(ctx, billingAccountName, invoiceSectionName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "AddByInvoiceSectionName", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddByInvoiceSectionNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "AddByInvoiceSectionName", resp, "Failure sending request")
		return
	}

	result, err = client.AddByInvoiceSectionNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "AddByInvoiceSectionName", resp, "Failure responding to request")
	}

	return
}

// AddByInvoiceSectionNamePreparer prepares the AddByInvoiceSectionName request.
func (client RoleAssignmentsClient) AddByInvoiceSectionNamePreparer(ctx context.Context, billingAccountName string, invoiceSectionName string, parameters RoleAssignmentPayload) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName": autorest.Encode("path", billingAccountName),
		"invoiceSectionName": autorest.Encode("path", invoiceSectionName),
	}

	const APIVersion = "2018-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Billing/createBillingRoleAssignment", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddByInvoiceSectionNameSender sends the AddByInvoiceSectionName request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) AddByInvoiceSectionNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// AddByInvoiceSectionNameResponder handles the response to the AddByInvoiceSectionName request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) AddByInvoiceSectionNameResponder(resp *http.Response) (result RoleAssignmentListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteByBillingAccountName delete the role assignment on this billing account
// Parameters:
// billingAccountName - billing Account Id.
// billingRoleAssignmentName - role assignment id.
func (client RoleAssignmentsClient) DeleteByBillingAccountName(ctx context.Context, billingAccountName string, billingRoleAssignmentName string) (result RoleAssignment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.DeleteByBillingAccountName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteByBillingAccountNamePreparer(ctx, billingAccountName, billingRoleAssignmentName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "DeleteByBillingAccountName", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteByBillingAccountNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "DeleteByBillingAccountName", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteByBillingAccountNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "DeleteByBillingAccountName", resp, "Failure responding to request")
	}

	return
}

// DeleteByBillingAccountNamePreparer prepares the DeleteByBillingAccountName request.
func (client RoleAssignmentsClient) DeleteByBillingAccountNamePreparer(ctx context.Context, billingAccountName string, billingRoleAssignmentName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName":        autorest.Encode("path", billingAccountName),
		"billingRoleAssignmentName": autorest.Encode("path", billingRoleAssignmentName),
	}

	const APIVersion = "2018-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/providers/Microsoft.Billing/billingRoleAssignments/{billingRoleAssignmentName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteByBillingAccountNameSender sends the DeleteByBillingAccountName request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) DeleteByBillingAccountNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteByBillingAccountNameResponder handles the response to the DeleteByBillingAccountName request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) DeleteByBillingAccountNameResponder(resp *http.Response) (result RoleAssignment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteByBillingProfileName delete the role assignment on this Billing Profile
// Parameters:
// billingAccountName - billing Account Id.
// billingProfileName - billing Profile Id.
// billingRoleAssignmentName - role assignment id.
func (client RoleAssignmentsClient) DeleteByBillingProfileName(ctx context.Context, billingAccountName string, billingProfileName string, billingRoleAssignmentName string) (result RoleAssignment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.DeleteByBillingProfileName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteByBillingProfileNamePreparer(ctx, billingAccountName, billingProfileName, billingRoleAssignmentName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "DeleteByBillingProfileName", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteByBillingProfileNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "DeleteByBillingProfileName", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteByBillingProfileNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "DeleteByBillingProfileName", resp, "Failure responding to request")
	}

	return
}

// DeleteByBillingProfileNamePreparer prepares the DeleteByBillingProfileName request.
func (client RoleAssignmentsClient) DeleteByBillingProfileNamePreparer(ctx context.Context, billingAccountName string, billingProfileName string, billingRoleAssignmentName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName":        autorest.Encode("path", billingAccountName),
		"billingProfileName":        autorest.Encode("path", billingProfileName),
		"billingRoleAssignmentName": autorest.Encode("path", billingRoleAssignmentName),
	}

	const APIVersion = "2018-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/providers/Microsoft.Billing/billingRoleAssignments/{billingRoleAssignmentName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteByBillingProfileNameSender sends the DeleteByBillingProfileName request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) DeleteByBillingProfileNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteByBillingProfileNameResponder handles the response to the DeleteByBillingProfileName request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) DeleteByBillingProfileNameResponder(resp *http.Response) (result RoleAssignment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteByInvoiceSectionName delete the role assignment on the invoice Section
// Parameters:
// billingAccountName - billing Account Id.
// invoiceSectionName - invoiceSection Id.
// billingRoleAssignmentName - role assignment id.
func (client RoleAssignmentsClient) DeleteByInvoiceSectionName(ctx context.Context, billingAccountName string, invoiceSectionName string, billingRoleAssignmentName string) (result RoleAssignment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.DeleteByInvoiceSectionName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteByInvoiceSectionNamePreparer(ctx, billingAccountName, invoiceSectionName, billingRoleAssignmentName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "DeleteByInvoiceSectionName", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteByInvoiceSectionNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "DeleteByInvoiceSectionName", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteByInvoiceSectionNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "DeleteByInvoiceSectionName", resp, "Failure responding to request")
	}

	return
}

// DeleteByInvoiceSectionNamePreparer prepares the DeleteByInvoiceSectionName request.
func (client RoleAssignmentsClient) DeleteByInvoiceSectionNamePreparer(ctx context.Context, billingAccountName string, invoiceSectionName string, billingRoleAssignmentName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName":        autorest.Encode("path", billingAccountName),
		"billingRoleAssignmentName": autorest.Encode("path", billingRoleAssignmentName),
		"invoiceSectionName":        autorest.Encode("path", invoiceSectionName),
	}

	const APIVersion = "2018-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Billing/billingRoleAssignments/{billingRoleAssignmentName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteByInvoiceSectionNameSender sends the DeleteByInvoiceSectionName request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) DeleteByInvoiceSectionNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteByInvoiceSectionNameResponder handles the response to the DeleteByInvoiceSectionName request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) DeleteByInvoiceSectionNameResponder(resp *http.Response) (result RoleAssignment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByBillingAccount get the role assignment for the caller
// Parameters:
// billingAccountName - billing Account Id.
// billingRoleAssignmentName - role assignment id.
func (client RoleAssignmentsClient) GetByBillingAccount(ctx context.Context, billingAccountName string, billingRoleAssignmentName string) (result RoleAssignment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.GetByBillingAccount")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByBillingAccountPreparer(ctx, billingAccountName, billingRoleAssignmentName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "GetByBillingAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByBillingAccountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "GetByBillingAccount", resp, "Failure sending request")
		return
	}

	result, err = client.GetByBillingAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "GetByBillingAccount", resp, "Failure responding to request")
	}

	return
}

// GetByBillingAccountPreparer prepares the GetByBillingAccount request.
func (client RoleAssignmentsClient) GetByBillingAccountPreparer(ctx context.Context, billingAccountName string, billingRoleAssignmentName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName":        autorest.Encode("path", billingAccountName),
		"billingRoleAssignmentName": autorest.Encode("path", billingRoleAssignmentName),
	}

	const APIVersion = "2018-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/providers/Microsoft.Billing/billingRoleAssignments/{billingRoleAssignmentName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByBillingAccountSender sends the GetByBillingAccount request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) GetByBillingAccountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetByBillingAccountResponder handles the response to the GetByBillingAccount request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) GetByBillingAccountResponder(resp *http.Response) (result RoleAssignment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByBillingProfileName get the role assignment for the caller on the Billing Profile
// Parameters:
// billingAccountName - billing Account Id.
// billingProfileName - billing Profile Id.
// billingRoleAssignmentName - role assignment id.
func (client RoleAssignmentsClient) GetByBillingProfileName(ctx context.Context, billingAccountName string, billingProfileName string, billingRoleAssignmentName string) (result RoleAssignment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.GetByBillingProfileName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByBillingProfileNamePreparer(ctx, billingAccountName, billingProfileName, billingRoleAssignmentName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "GetByBillingProfileName", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByBillingProfileNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "GetByBillingProfileName", resp, "Failure sending request")
		return
	}

	result, err = client.GetByBillingProfileNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "GetByBillingProfileName", resp, "Failure responding to request")
	}

	return
}

// GetByBillingProfileNamePreparer prepares the GetByBillingProfileName request.
func (client RoleAssignmentsClient) GetByBillingProfileNamePreparer(ctx context.Context, billingAccountName string, billingProfileName string, billingRoleAssignmentName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName":        autorest.Encode("path", billingAccountName),
		"billingProfileName":        autorest.Encode("path", billingProfileName),
		"billingRoleAssignmentName": autorest.Encode("path", billingRoleAssignmentName),
	}

	const APIVersion = "2018-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/providers/Microsoft.Billing/billingRoleAssignments/{billingRoleAssignmentName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByBillingProfileNameSender sends the GetByBillingProfileName request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) GetByBillingProfileNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetByBillingProfileNameResponder handles the response to the GetByBillingProfileName request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) GetByBillingProfileNameResponder(resp *http.Response) (result RoleAssignment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByInvoiceSectionName get the role assignment for the caller on the invoice Section
// Parameters:
// billingAccountName - billing Account Id.
// invoiceSectionName - invoiceSection Id.
// billingRoleAssignmentName - role assignment id.
func (client RoleAssignmentsClient) GetByInvoiceSectionName(ctx context.Context, billingAccountName string, invoiceSectionName string, billingRoleAssignmentName string) (result RoleAssignment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.GetByInvoiceSectionName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByInvoiceSectionNamePreparer(ctx, billingAccountName, invoiceSectionName, billingRoleAssignmentName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "GetByInvoiceSectionName", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByInvoiceSectionNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "GetByInvoiceSectionName", resp, "Failure sending request")
		return
	}

	result, err = client.GetByInvoiceSectionNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "GetByInvoiceSectionName", resp, "Failure responding to request")
	}

	return
}

// GetByInvoiceSectionNamePreparer prepares the GetByInvoiceSectionName request.
func (client RoleAssignmentsClient) GetByInvoiceSectionNamePreparer(ctx context.Context, billingAccountName string, invoiceSectionName string, billingRoleAssignmentName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName":        autorest.Encode("path", billingAccountName),
		"billingRoleAssignmentName": autorest.Encode("path", billingRoleAssignmentName),
		"invoiceSectionName":        autorest.Encode("path", invoiceSectionName),
	}

	const APIVersion = "2018-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Billing/billingRoleAssignments/{billingRoleAssignmentName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByInvoiceSectionNameSender sends the GetByInvoiceSectionName request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) GetByInvoiceSectionNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetByInvoiceSectionNameResponder handles the response to the GetByInvoiceSectionName request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) GetByInvoiceSectionNameResponder(resp *http.Response) (result RoleAssignment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByBillingAccountName get the role assignments on the Billing Account
// Parameters:
// billingAccountName - billing Account Id.
func (client RoleAssignmentsClient) ListByBillingAccountName(ctx context.Context, billingAccountName string) (result RoleAssignmentListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.ListByBillingAccountName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListByBillingAccountNamePreparer(ctx, billingAccountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "ListByBillingAccountName", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByBillingAccountNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "ListByBillingAccountName", resp, "Failure sending request")
		return
	}

	result, err = client.ListByBillingAccountNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "ListByBillingAccountName", resp, "Failure responding to request")
	}

	return
}

// ListByBillingAccountNamePreparer prepares the ListByBillingAccountName request.
func (client RoleAssignmentsClient) ListByBillingAccountNamePreparer(ctx context.Context, billingAccountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName": autorest.Encode("path", billingAccountName),
	}

	const APIVersion = "2018-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/providers/Microsoft.Billing/billingRoleAssignments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByBillingAccountNameSender sends the ListByBillingAccountName request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) ListByBillingAccountNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListByBillingAccountNameResponder handles the response to the ListByBillingAccountName request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) ListByBillingAccountNameResponder(resp *http.Response) (result RoleAssignmentListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByBillingProfileName get the role assignments on the Billing Profile
// Parameters:
// billingAccountName - billing Account Id.
// billingProfileName - billing Profile Id.
func (client RoleAssignmentsClient) ListByBillingProfileName(ctx context.Context, billingAccountName string, billingProfileName string) (result RoleAssignmentListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.ListByBillingProfileName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListByBillingProfileNamePreparer(ctx, billingAccountName, billingProfileName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "ListByBillingProfileName", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByBillingProfileNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "ListByBillingProfileName", resp, "Failure sending request")
		return
	}

	result, err = client.ListByBillingProfileNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "ListByBillingProfileName", resp, "Failure responding to request")
	}

	return
}

// ListByBillingProfileNamePreparer prepares the ListByBillingProfileName request.
func (client RoleAssignmentsClient) ListByBillingProfileNamePreparer(ctx context.Context, billingAccountName string, billingProfileName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName": autorest.Encode("path", billingAccountName),
		"billingProfileName": autorest.Encode("path", billingProfileName),
	}

	const APIVersion = "2018-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/providers/Microsoft.Billing/billingRoleAssignments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByBillingProfileNameSender sends the ListByBillingProfileName request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) ListByBillingProfileNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListByBillingProfileNameResponder handles the response to the ListByBillingProfileName request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) ListByBillingProfileNameResponder(resp *http.Response) (result RoleAssignmentListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByInvoiceSectionName get the role assignments on the invoice Section
// Parameters:
// billingAccountName - billing Account Id.
// invoiceSectionName - invoiceSection Id.
func (client RoleAssignmentsClient) ListByInvoiceSectionName(ctx context.Context, billingAccountName string, invoiceSectionName string) (result RoleAssignmentListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.ListByInvoiceSectionName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListByInvoiceSectionNamePreparer(ctx, billingAccountName, invoiceSectionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "ListByInvoiceSectionName", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByInvoiceSectionNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "ListByInvoiceSectionName", resp, "Failure sending request")
		return
	}

	result, err = client.ListByInvoiceSectionNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.RoleAssignmentsClient", "ListByInvoiceSectionName", resp, "Failure responding to request")
	}

	return
}

// ListByInvoiceSectionNamePreparer prepares the ListByInvoiceSectionName request.
func (client RoleAssignmentsClient) ListByInvoiceSectionNamePreparer(ctx context.Context, billingAccountName string, invoiceSectionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountName": autorest.Encode("path", billingAccountName),
		"invoiceSectionName": autorest.Encode("path", invoiceSectionName),
	}

	const APIVersion = "2018-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Billing/billingRoleAssignments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByInvoiceSectionNameSender sends the ListByInvoiceSectionName request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) ListByInvoiceSectionNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListByInvoiceSectionNameResponder handles the response to the ListByInvoiceSectionName request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) ListByInvoiceSectionNameResponder(resp *http.Response) (result RoleAssignmentListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
