// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/resources/campaign.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v2/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A campaign.
type Campaign struct {
	// Immutable. The resource name of the campaign.
	// Campaign resource names have the form:
	//
	// `customers/{customer_id}/campaigns/{campaign_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. The ID of the campaign.
	Id *wrappers.Int64Value `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the campaign.
	//
	// This field is required and should not be empty when creating new
	// campaigns.
	//
	// It must not contain any null (code point 0x0), NL line feed
	// (code point 0xA) or carriage return (code point 0xD) characters.
	Name *wrappers.StringValue `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The status of the campaign.
	//
	// When a new campaign is added, the status defaults to ENABLED.
	Status enums.CampaignStatusEnum_CampaignStatus `protobuf:"varint,5,opt,name=status,proto3,enum=google.ads.googleads.v2.enums.CampaignStatusEnum_CampaignStatus" json:"status,omitempty"`
	// Output only. The ad serving status of the campaign.
	ServingStatus enums.CampaignServingStatusEnum_CampaignServingStatus `protobuf:"varint,21,opt,name=serving_status,json=servingStatus,proto3,enum=google.ads.googleads.v2.enums.CampaignServingStatusEnum_CampaignServingStatus" json:"serving_status,omitempty"`
	// The ad serving optimization status of the campaign.
	AdServingOptimizationStatus enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus `protobuf:"varint,8,opt,name=ad_serving_optimization_status,json=adServingOptimizationStatus,proto3,enum=google.ads.googleads.v2.enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus" json:"ad_serving_optimization_status,omitempty"`
	// Immutable. The primary serving target for ads within the campaign.
	// The targeting options can be refined in `network_settings`.
	//
	// This field is required and should not be empty when creating new
	// campaigns.
	//
	// Can be set only when creating campaigns.
	// After the campaign is created, the field can not be changed.
	AdvertisingChannelType enums.AdvertisingChannelTypeEnum_AdvertisingChannelType `protobuf:"varint,9,opt,name=advertising_channel_type,json=advertisingChannelType,proto3,enum=google.ads.googleads.v2.enums.AdvertisingChannelTypeEnum_AdvertisingChannelType" json:"advertising_channel_type,omitempty"`
	// Immutable. Optional refinement to `advertising_channel_type`.
	// Must be a valid sub-type of the parent channel type.
	//
	// Can be set only when creating campaigns.
	// After campaign is created, the field can not be changed.
	AdvertisingChannelSubType enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType `protobuf:"varint,10,opt,name=advertising_channel_sub_type,json=advertisingChannelSubType,proto3,enum=google.ads.googleads.v2.enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType" json:"advertising_channel_sub_type,omitempty"`
	// The URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,11,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The list of mappings used to substitute custom parameter tags in a
	// `tracking_url_template`, `final_urls`, or `mobile_final_urls`.
	UrlCustomParameters []*common.CustomParameter `protobuf:"bytes,12,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// Settings for Real-Time Bidding, a feature only available for campaigns
	// targeting the Ad Exchange network.
	RealTimeBiddingSetting *common.RealTimeBiddingSetting `protobuf:"bytes,39,opt,name=real_time_bidding_setting,json=realTimeBiddingSetting,proto3" json:"real_time_bidding_setting,omitempty"`
	// The network settings for the campaign.
	NetworkSettings *Campaign_NetworkSettings `protobuf:"bytes,14,opt,name=network_settings,json=networkSettings,proto3" json:"network_settings,omitempty"`
	// Immutable. The hotel setting for the campaign.
	HotelSetting *Campaign_HotelSettingInfo `protobuf:"bytes,32,opt,name=hotel_setting,json=hotelSetting,proto3" json:"hotel_setting,omitempty"`
	// The setting for controlling Dynamic Search Ads (DSA).
	DynamicSearchAdsSetting *Campaign_DynamicSearchAdsSetting `protobuf:"bytes,33,opt,name=dynamic_search_ads_setting,json=dynamicSearchAdsSetting,proto3" json:"dynamic_search_ads_setting,omitempty"`
	// The setting for controlling Shopping campaigns.
	ShoppingSetting *Campaign_ShoppingSetting `protobuf:"bytes,36,opt,name=shopping_setting,json=shoppingSetting,proto3" json:"shopping_setting,omitempty"`
	// Setting for targeting related features.
	TargetingSetting *common.TargetingSetting `protobuf:"bytes,43,opt,name=targeting_setting,json=targetingSetting,proto3" json:"targeting_setting,omitempty"`
	// The setting for ads geotargeting.
	GeoTargetTypeSetting *Campaign_GeoTargetTypeSetting `protobuf:"bytes,47,opt,name=geo_target_type_setting,json=geoTargetTypeSetting,proto3" json:"geo_target_type_setting,omitempty"`
	// The setting related to App Campaign.
	AppCampaignSetting *Campaign_AppCampaignSetting `protobuf:"bytes,51,opt,name=app_campaign_setting,json=appCampaignSetting,proto3" json:"app_campaign_setting,omitempty"`
	// Output only. The resource names of labels attached to this campaign.
	Labels []*wrappers.StringValue `protobuf:"bytes,53,rep,name=labels,proto3" json:"labels,omitempty"`
	// Output only. The type of campaign: normal, draft, or experiment.
	ExperimentType enums.CampaignExperimentTypeEnum_CampaignExperimentType `protobuf:"varint,17,opt,name=experiment_type,json=experimentType,proto3,enum=google.ads.googleads.v2.enums.CampaignExperimentTypeEnum_CampaignExperimentType" json:"experiment_type,omitempty"`
	// Output only. The resource name of the base campaign of a draft or experiment campaign.
	// For base campaigns, this is equal to `resource_name`.
	//
	// This field is read-only.
	BaseCampaign *wrappers.StringValue `protobuf:"bytes,28,opt,name=base_campaign,json=baseCampaign,proto3" json:"base_campaign,omitempty"`
	// The budget of the campaign.
	CampaignBudget *wrappers.StringValue `protobuf:"bytes,6,opt,name=campaign_budget,json=campaignBudget,proto3" json:"campaign_budget,omitempty"`
	// Output only. The type of bidding strategy.
	//
	// A bidding strategy can be created by setting either the bidding scheme to
	// create a standard bidding strategy or the `bidding_strategy` field to
	// create a portfolio bidding strategy.
	//
	// This field is read-only.
	BiddingStrategyType enums.BiddingStrategyTypeEnum_BiddingStrategyType `protobuf:"varint,22,opt,name=bidding_strategy_type,json=biddingStrategyType,proto3,enum=google.ads.googleads.v2.enums.BiddingStrategyTypeEnum_BiddingStrategyType" json:"bidding_strategy_type,omitempty"`
	// The date when campaign started.
	//
	// This field must not be used in WHERE clauses.
	StartDate *wrappers.StringValue `protobuf:"bytes,19,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// The date when campaign ended.
	//
	// This field must not be used in WHERE clauses.
	EndDate *wrappers.StringValue `protobuf:"bytes,20,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// Suffix used to append query parameters to landing pages that are served
	// with parallel tracking.
	FinalUrlSuffix *wrappers.StringValue `protobuf:"bytes,38,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	// A list that limits how often each user will see this campaign's ads.
	FrequencyCaps []*common.FrequencyCapEntry `protobuf:"bytes,40,rep,name=frequency_caps,json=frequencyCaps,proto3" json:"frequency_caps,omitempty"`
	// Output only. 3-Tier Brand Safety setting for the campaign.
	VideoBrandSafetySuitability enums.BrandSafetySuitabilityEnum_BrandSafetySuitability `protobuf:"varint,42,opt,name=video_brand_safety_suitability,json=videoBrandSafetySuitability,proto3,enum=google.ads.googleads.v2.enums.BrandSafetySuitabilityEnum_BrandSafetySuitability" json:"video_brand_safety_suitability,omitempty"`
	// Describes how unbranded pharma ads will be displayed.
	VanityPharma *Campaign_VanityPharma `protobuf:"bytes,44,opt,name=vanity_pharma,json=vanityPharma,proto3" json:"vanity_pharma,omitempty"`
	// Selective optimization setting for this campaign, which includes a set of
	// conversion actions to optimize this campaign towards.
	SelectiveOptimization *Campaign_SelectiveOptimization `protobuf:"bytes,45,opt,name=selective_optimization,json=selectiveOptimization,proto3" json:"selective_optimization,omitempty"`
	// Output only. Campaign-level settings for tracking information.
	TrackingSetting *Campaign_TrackingSetting `protobuf:"bytes,46,opt,name=tracking_setting,json=trackingSetting,proto3" json:"tracking_setting,omitempty"`
	// Payment mode for the campaign.
	PaymentMode enums.PaymentModeEnum_PaymentMode `protobuf:"varint,52,opt,name=payment_mode,json=paymentMode,proto3,enum=google.ads.googleads.v2.enums.PaymentModeEnum_PaymentMode" json:"payment_mode,omitempty"`
	// The bidding strategy for the campaign.
	//
	// Must be either portfolio (created via BiddingStrategy service) or
	// standard, that is embedded into the campaign.
	//
	// Types that are valid to be assigned to CampaignBiddingStrategy:
	//	*Campaign_BiddingStrategy
	//	*Campaign_Commission
	//	*Campaign_ManualCpc
	//	*Campaign_ManualCpm
	//	*Campaign_ManualCpv
	//	*Campaign_MaximizeConversions
	//	*Campaign_MaximizeConversionValue
	//	*Campaign_TargetCpa
	//	*Campaign_TargetImpressionShare
	//	*Campaign_TargetRoas
	//	*Campaign_TargetSpend
	//	*Campaign_PercentCpc
	//	*Campaign_TargetCpm
	CampaignBiddingStrategy isCampaign_CampaignBiddingStrategy `protobuf_oneof:"campaign_bidding_strategy"`
	XXX_NoUnkeyedLiteral    struct{}                           `json:"-"`
	XXX_unrecognized        []byte                             `json:"-"`
	XXX_sizecache           int32                              `json:"-"`
}

func (m *Campaign) Reset()         { *m = Campaign{} }
func (m *Campaign) String() string { return proto.CompactTextString(m) }
func (*Campaign) ProtoMessage()    {}
func (*Campaign) Descriptor() ([]byte, []int) {
	return fileDescriptor_4590562366212c3a, []int{0}
}

func (m *Campaign) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign.Unmarshal(m, b)
}
func (m *Campaign) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign.Marshal(b, m, deterministic)
}
func (m *Campaign) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign.Merge(m, src)
}
func (m *Campaign) XXX_Size() int {
	return xxx_messageInfo_Campaign.Size(m)
}
func (m *Campaign) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign proto.InternalMessageInfo

func (m *Campaign) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *Campaign) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Campaign) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *Campaign) GetStatus() enums.CampaignStatusEnum_CampaignStatus {
	if m != nil {
		return m.Status
	}
	return enums.CampaignStatusEnum_UNSPECIFIED
}

func (m *Campaign) GetServingStatus() enums.CampaignServingStatusEnum_CampaignServingStatus {
	if m != nil {
		return m.ServingStatus
	}
	return enums.CampaignServingStatusEnum_UNSPECIFIED
}

func (m *Campaign) GetAdServingOptimizationStatus() enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus {
	if m != nil {
		return m.AdServingOptimizationStatus
	}
	return enums.AdServingOptimizationStatusEnum_UNSPECIFIED
}

func (m *Campaign) GetAdvertisingChannelType() enums.AdvertisingChannelTypeEnum_AdvertisingChannelType {
	if m != nil {
		return m.AdvertisingChannelType
	}
	return enums.AdvertisingChannelTypeEnum_UNSPECIFIED
}

func (m *Campaign) GetAdvertisingChannelSubType() enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType {
	if m != nil {
		return m.AdvertisingChannelSubType
	}
	return enums.AdvertisingChannelSubTypeEnum_UNSPECIFIED
}

func (m *Campaign) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *Campaign) GetUrlCustomParameters() []*common.CustomParameter {
	if m != nil {
		return m.UrlCustomParameters
	}
	return nil
}

func (m *Campaign) GetRealTimeBiddingSetting() *common.RealTimeBiddingSetting {
	if m != nil {
		return m.RealTimeBiddingSetting
	}
	return nil
}

func (m *Campaign) GetNetworkSettings() *Campaign_NetworkSettings {
	if m != nil {
		return m.NetworkSettings
	}
	return nil
}

func (m *Campaign) GetHotelSetting() *Campaign_HotelSettingInfo {
	if m != nil {
		return m.HotelSetting
	}
	return nil
}

func (m *Campaign) GetDynamicSearchAdsSetting() *Campaign_DynamicSearchAdsSetting {
	if m != nil {
		return m.DynamicSearchAdsSetting
	}
	return nil
}

func (m *Campaign) GetShoppingSetting() *Campaign_ShoppingSetting {
	if m != nil {
		return m.ShoppingSetting
	}
	return nil
}

func (m *Campaign) GetTargetingSetting() *common.TargetingSetting {
	if m != nil {
		return m.TargetingSetting
	}
	return nil
}

func (m *Campaign) GetGeoTargetTypeSetting() *Campaign_GeoTargetTypeSetting {
	if m != nil {
		return m.GeoTargetTypeSetting
	}
	return nil
}

func (m *Campaign) GetAppCampaignSetting() *Campaign_AppCampaignSetting {
	if m != nil {
		return m.AppCampaignSetting
	}
	return nil
}

func (m *Campaign) GetLabels() []*wrappers.StringValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Campaign) GetExperimentType() enums.CampaignExperimentTypeEnum_CampaignExperimentType {
	if m != nil {
		return m.ExperimentType
	}
	return enums.CampaignExperimentTypeEnum_UNSPECIFIED
}

func (m *Campaign) GetBaseCampaign() *wrappers.StringValue {
	if m != nil {
		return m.BaseCampaign
	}
	return nil
}

func (m *Campaign) GetCampaignBudget() *wrappers.StringValue {
	if m != nil {
		return m.CampaignBudget
	}
	return nil
}

func (m *Campaign) GetBiddingStrategyType() enums.BiddingStrategyTypeEnum_BiddingStrategyType {
	if m != nil {
		return m.BiddingStrategyType
	}
	return enums.BiddingStrategyTypeEnum_UNSPECIFIED
}

func (m *Campaign) GetStartDate() *wrappers.StringValue {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *Campaign) GetEndDate() *wrappers.StringValue {
	if m != nil {
		return m.EndDate
	}
	return nil
}

func (m *Campaign) GetFinalUrlSuffix() *wrappers.StringValue {
	if m != nil {
		return m.FinalUrlSuffix
	}
	return nil
}

func (m *Campaign) GetFrequencyCaps() []*common.FrequencyCapEntry {
	if m != nil {
		return m.FrequencyCaps
	}
	return nil
}

func (m *Campaign) GetVideoBrandSafetySuitability() enums.BrandSafetySuitabilityEnum_BrandSafetySuitability {
	if m != nil {
		return m.VideoBrandSafetySuitability
	}
	return enums.BrandSafetySuitabilityEnum_UNSPECIFIED
}

func (m *Campaign) GetVanityPharma() *Campaign_VanityPharma {
	if m != nil {
		return m.VanityPharma
	}
	return nil
}

func (m *Campaign) GetSelectiveOptimization() *Campaign_SelectiveOptimization {
	if m != nil {
		return m.SelectiveOptimization
	}
	return nil
}

func (m *Campaign) GetTrackingSetting() *Campaign_TrackingSetting {
	if m != nil {
		return m.TrackingSetting
	}
	return nil
}

func (m *Campaign) GetPaymentMode() enums.PaymentModeEnum_PaymentMode {
	if m != nil {
		return m.PaymentMode
	}
	return enums.PaymentModeEnum_UNSPECIFIED
}

type isCampaign_CampaignBiddingStrategy interface {
	isCampaign_CampaignBiddingStrategy()
}

type Campaign_BiddingStrategy struct {
	BiddingStrategy *wrappers.StringValue `protobuf:"bytes,23,opt,name=bidding_strategy,json=biddingStrategy,proto3,oneof"`
}

type Campaign_Commission struct {
	Commission *common.Commission `protobuf:"bytes,49,opt,name=commission,proto3,oneof"`
}

type Campaign_ManualCpc struct {
	ManualCpc *common.ManualCpc `protobuf:"bytes,24,opt,name=manual_cpc,json=manualCpc,proto3,oneof"`
}

type Campaign_ManualCpm struct {
	ManualCpm *common.ManualCpm `protobuf:"bytes,25,opt,name=manual_cpm,json=manualCpm,proto3,oneof"`
}

type Campaign_ManualCpv struct {
	ManualCpv *common.ManualCpv `protobuf:"bytes,37,opt,name=manual_cpv,json=manualCpv,proto3,oneof"`
}

type Campaign_MaximizeConversions struct {
	MaximizeConversions *common.MaximizeConversions `protobuf:"bytes,30,opt,name=maximize_conversions,json=maximizeConversions,proto3,oneof"`
}

type Campaign_MaximizeConversionValue struct {
	MaximizeConversionValue *common.MaximizeConversionValue `protobuf:"bytes,31,opt,name=maximize_conversion_value,json=maximizeConversionValue,proto3,oneof"`
}

type Campaign_TargetCpa struct {
	TargetCpa *common.TargetCpa `protobuf:"bytes,26,opt,name=target_cpa,json=targetCpa,proto3,oneof"`
}

type Campaign_TargetImpressionShare struct {
	TargetImpressionShare *common.TargetImpressionShare `protobuf:"bytes,48,opt,name=target_impression_share,json=targetImpressionShare,proto3,oneof"`
}

type Campaign_TargetRoas struct {
	TargetRoas *common.TargetRoas `protobuf:"bytes,29,opt,name=target_roas,json=targetRoas,proto3,oneof"`
}

type Campaign_TargetSpend struct {
	TargetSpend *common.TargetSpend `protobuf:"bytes,27,opt,name=target_spend,json=targetSpend,proto3,oneof"`
}

type Campaign_PercentCpc struct {
	PercentCpc *common.PercentCpc `protobuf:"bytes,34,opt,name=percent_cpc,json=percentCpc,proto3,oneof"`
}

type Campaign_TargetCpm struct {
	TargetCpm *common.TargetCpm `protobuf:"bytes,41,opt,name=target_cpm,json=targetCpm,proto3,oneof"`
}

func (*Campaign_BiddingStrategy) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_Commission) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_ManualCpc) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_ManualCpm) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_ManualCpv) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_MaximizeConversions) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_MaximizeConversionValue) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetCpa) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetImpressionShare) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetRoas) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetSpend) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_PercentCpc) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetCpm) isCampaign_CampaignBiddingStrategy() {}

func (m *Campaign) GetCampaignBiddingStrategy() isCampaign_CampaignBiddingStrategy {
	if m != nil {
		return m.CampaignBiddingStrategy
	}
	return nil
}

func (m *Campaign) GetBiddingStrategy() *wrappers.StringValue {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_BiddingStrategy); ok {
		return x.BiddingStrategy
	}
	return nil
}

func (m *Campaign) GetCommission() *common.Commission {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_Commission); ok {
		return x.Commission
	}
	return nil
}

func (m *Campaign) GetManualCpc() *common.ManualCpc {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_ManualCpc); ok {
		return x.ManualCpc
	}
	return nil
}

func (m *Campaign) GetManualCpm() *common.ManualCpm {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_ManualCpm); ok {
		return x.ManualCpm
	}
	return nil
}

func (m *Campaign) GetManualCpv() *common.ManualCpv {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_ManualCpv); ok {
		return x.ManualCpv
	}
	return nil
}

func (m *Campaign) GetMaximizeConversions() *common.MaximizeConversions {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_MaximizeConversions); ok {
		return x.MaximizeConversions
	}
	return nil
}

func (m *Campaign) GetMaximizeConversionValue() *common.MaximizeConversionValue {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_MaximizeConversionValue); ok {
		return x.MaximizeConversionValue
	}
	return nil
}

func (m *Campaign) GetTargetCpa() *common.TargetCpa {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_TargetCpa); ok {
		return x.TargetCpa
	}
	return nil
}

func (m *Campaign) GetTargetImpressionShare() *common.TargetImpressionShare {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_TargetImpressionShare); ok {
		return x.TargetImpressionShare
	}
	return nil
}

func (m *Campaign) GetTargetRoas() *common.TargetRoas {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_TargetRoas); ok {
		return x.TargetRoas
	}
	return nil
}

func (m *Campaign) GetTargetSpend() *common.TargetSpend {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_TargetSpend); ok {
		return x.TargetSpend
	}
	return nil
}

func (m *Campaign) GetPercentCpc() *common.PercentCpc {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_PercentCpc); ok {
		return x.PercentCpc
	}
	return nil
}

func (m *Campaign) GetTargetCpm() *common.TargetCpm {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_TargetCpm); ok {
		return x.TargetCpm
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Campaign) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Campaign_BiddingStrategy)(nil),
		(*Campaign_Commission)(nil),
		(*Campaign_ManualCpc)(nil),
		(*Campaign_ManualCpm)(nil),
		(*Campaign_ManualCpv)(nil),
		(*Campaign_MaximizeConversions)(nil),
		(*Campaign_MaximizeConversionValue)(nil),
		(*Campaign_TargetCpa)(nil),
		(*Campaign_TargetImpressionShare)(nil),
		(*Campaign_TargetRoas)(nil),
		(*Campaign_TargetSpend)(nil),
		(*Campaign_PercentCpc)(nil),
		(*Campaign_TargetCpm)(nil),
	}
}

// The network settings for the campaign.
type Campaign_NetworkSettings struct {
	// Whether ads will be served with google.com search results.
	TargetGoogleSearch *wrappers.BoolValue `protobuf:"bytes,1,opt,name=target_google_search,json=targetGoogleSearch,proto3" json:"target_google_search,omitempty"`
	// Whether ads will be served on partner sites in the Google Search Network
	// (requires `target_google_search` to also be `true`).
	TargetSearchNetwork *wrappers.BoolValue `protobuf:"bytes,2,opt,name=target_search_network,json=targetSearchNetwork,proto3" json:"target_search_network,omitempty"`
	// Whether ads will be served on specified placements in the Google Display
	// Network. Placements are specified using the Placement criterion.
	TargetContentNetwork *wrappers.BoolValue `protobuf:"bytes,3,opt,name=target_content_network,json=targetContentNetwork,proto3" json:"target_content_network,omitempty"`
	// Whether ads will be served on the Google Partner Network.
	// This is available only to some select Google partner accounts.
	TargetPartnerSearchNetwork *wrappers.BoolValue `protobuf:"bytes,4,opt,name=target_partner_search_network,json=targetPartnerSearchNetwork,proto3" json:"target_partner_search_network,omitempty"`
	XXX_NoUnkeyedLiteral       struct{}            `json:"-"`
	XXX_unrecognized           []byte              `json:"-"`
	XXX_sizecache              int32               `json:"-"`
}

func (m *Campaign_NetworkSettings) Reset()         { *m = Campaign_NetworkSettings{} }
func (m *Campaign_NetworkSettings) String() string { return proto.CompactTextString(m) }
func (*Campaign_NetworkSettings) ProtoMessage()    {}
func (*Campaign_NetworkSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_4590562366212c3a, []int{0, 0}
}

func (m *Campaign_NetworkSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_NetworkSettings.Unmarshal(m, b)
}
func (m *Campaign_NetworkSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_NetworkSettings.Marshal(b, m, deterministic)
}
func (m *Campaign_NetworkSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_NetworkSettings.Merge(m, src)
}
func (m *Campaign_NetworkSettings) XXX_Size() int {
	return xxx_messageInfo_Campaign_NetworkSettings.Size(m)
}
func (m *Campaign_NetworkSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_NetworkSettings.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_NetworkSettings proto.InternalMessageInfo

func (m *Campaign_NetworkSettings) GetTargetGoogleSearch() *wrappers.BoolValue {
	if m != nil {
		return m.TargetGoogleSearch
	}
	return nil
}

func (m *Campaign_NetworkSettings) GetTargetSearchNetwork() *wrappers.BoolValue {
	if m != nil {
		return m.TargetSearchNetwork
	}
	return nil
}

func (m *Campaign_NetworkSettings) GetTargetContentNetwork() *wrappers.BoolValue {
	if m != nil {
		return m.TargetContentNetwork
	}
	return nil
}

func (m *Campaign_NetworkSettings) GetTargetPartnerSearchNetwork() *wrappers.BoolValue {
	if m != nil {
		return m.TargetPartnerSearchNetwork
	}
	return nil
}

// Campaign-level settings for hotel ads.
type Campaign_HotelSettingInfo struct {
	// Immutable. The linked Hotel Center account.
	HotelCenterId        *wrappers.Int64Value `protobuf:"bytes,1,opt,name=hotel_center_id,json=hotelCenterId,proto3" json:"hotel_center_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Campaign_HotelSettingInfo) Reset()         { *m = Campaign_HotelSettingInfo{} }
func (m *Campaign_HotelSettingInfo) String() string { return proto.CompactTextString(m) }
func (*Campaign_HotelSettingInfo) ProtoMessage()    {}
func (*Campaign_HotelSettingInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_4590562366212c3a, []int{0, 1}
}

func (m *Campaign_HotelSettingInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_HotelSettingInfo.Unmarshal(m, b)
}
func (m *Campaign_HotelSettingInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_HotelSettingInfo.Marshal(b, m, deterministic)
}
func (m *Campaign_HotelSettingInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_HotelSettingInfo.Merge(m, src)
}
func (m *Campaign_HotelSettingInfo) XXX_Size() int {
	return xxx_messageInfo_Campaign_HotelSettingInfo.Size(m)
}
func (m *Campaign_HotelSettingInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_HotelSettingInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_HotelSettingInfo proto.InternalMessageInfo

func (m *Campaign_HotelSettingInfo) GetHotelCenterId() *wrappers.Int64Value {
	if m != nil {
		return m.HotelCenterId
	}
	return nil
}

// Describes how unbranded pharma ads will be displayed.
type Campaign_VanityPharma struct {
	// The display mode for vanity pharma URLs.
	VanityPharmaDisplayUrlMode enums.VanityPharmaDisplayUrlModeEnum_VanityPharmaDisplayUrlMode `protobuf:"varint,1,opt,name=vanity_pharma_display_url_mode,json=vanityPharmaDisplayUrlMode,proto3,enum=google.ads.googleads.v2.enums.VanityPharmaDisplayUrlModeEnum_VanityPharmaDisplayUrlMode" json:"vanity_pharma_display_url_mode,omitempty"`
	// The text that will be displayed in display URL of the text ad when
	// website description is the selected display mode for vanity pharma URLs.
	VanityPharmaText     enums.VanityPharmaTextEnum_VanityPharmaText `protobuf:"varint,2,opt,name=vanity_pharma_text,json=vanityPharmaText,proto3,enum=google.ads.googleads.v2.enums.VanityPharmaTextEnum_VanityPharmaText" json:"vanity_pharma_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *Campaign_VanityPharma) Reset()         { *m = Campaign_VanityPharma{} }
func (m *Campaign_VanityPharma) String() string { return proto.CompactTextString(m) }
func (*Campaign_VanityPharma) ProtoMessage()    {}
func (*Campaign_VanityPharma) Descriptor() ([]byte, []int) {
	return fileDescriptor_4590562366212c3a, []int{0, 2}
}

func (m *Campaign_VanityPharma) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_VanityPharma.Unmarshal(m, b)
}
func (m *Campaign_VanityPharma) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_VanityPharma.Marshal(b, m, deterministic)
}
func (m *Campaign_VanityPharma) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_VanityPharma.Merge(m, src)
}
func (m *Campaign_VanityPharma) XXX_Size() int {
	return xxx_messageInfo_Campaign_VanityPharma.Size(m)
}
func (m *Campaign_VanityPharma) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_VanityPharma.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_VanityPharma proto.InternalMessageInfo

func (m *Campaign_VanityPharma) GetVanityPharmaDisplayUrlMode() enums.VanityPharmaDisplayUrlModeEnum_VanityPharmaDisplayUrlMode {
	if m != nil {
		return m.VanityPharmaDisplayUrlMode
	}
	return enums.VanityPharmaDisplayUrlModeEnum_UNSPECIFIED
}

func (m *Campaign_VanityPharma) GetVanityPharmaText() enums.VanityPharmaTextEnum_VanityPharmaText {
	if m != nil {
		return m.VanityPharmaText
	}
	return enums.VanityPharmaTextEnum_UNSPECIFIED
}

// The setting for controlling Dynamic Search Ads (DSA).
type Campaign_DynamicSearchAdsSetting struct {
	// The Internet domain name that this setting represents, e.g., "google.com"
	// or "www.google.com".
	DomainName *wrappers.StringValue `protobuf:"bytes,1,opt,name=domain_name,json=domainName,proto3" json:"domain_name,omitempty"`
	// The language code specifying the language of the domain, e.g., "en".
	LanguageCode *wrappers.StringValue `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Whether the campaign uses advertiser supplied URLs exclusively.
	UseSuppliedUrlsOnly *wrappers.BoolValue `protobuf:"bytes,3,opt,name=use_supplied_urls_only,json=useSuppliedUrlsOnly,proto3" json:"use_supplied_urls_only,omitempty"`
	// Output only. The list of page feeds associated with the campaign.
	Feeds                []*wrappers.StringValue `protobuf:"bytes,5,rep,name=feeds,proto3" json:"feeds,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Campaign_DynamicSearchAdsSetting) Reset()         { *m = Campaign_DynamicSearchAdsSetting{} }
func (m *Campaign_DynamicSearchAdsSetting) String() string { return proto.CompactTextString(m) }
func (*Campaign_DynamicSearchAdsSetting) ProtoMessage()    {}
func (*Campaign_DynamicSearchAdsSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_4590562366212c3a, []int{0, 3}
}

func (m *Campaign_DynamicSearchAdsSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_DynamicSearchAdsSetting.Unmarshal(m, b)
}
func (m *Campaign_DynamicSearchAdsSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_DynamicSearchAdsSetting.Marshal(b, m, deterministic)
}
func (m *Campaign_DynamicSearchAdsSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_DynamicSearchAdsSetting.Merge(m, src)
}
func (m *Campaign_DynamicSearchAdsSetting) XXX_Size() int {
	return xxx_messageInfo_Campaign_DynamicSearchAdsSetting.Size(m)
}
func (m *Campaign_DynamicSearchAdsSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_DynamicSearchAdsSetting.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_DynamicSearchAdsSetting proto.InternalMessageInfo

func (m *Campaign_DynamicSearchAdsSetting) GetDomainName() *wrappers.StringValue {
	if m != nil {
		return m.DomainName
	}
	return nil
}

func (m *Campaign_DynamicSearchAdsSetting) GetLanguageCode() *wrappers.StringValue {
	if m != nil {
		return m.LanguageCode
	}
	return nil
}

func (m *Campaign_DynamicSearchAdsSetting) GetUseSuppliedUrlsOnly() *wrappers.BoolValue {
	if m != nil {
		return m.UseSuppliedUrlsOnly
	}
	return nil
}

func (m *Campaign_DynamicSearchAdsSetting) GetFeeds() []*wrappers.StringValue {
	if m != nil {
		return m.Feeds
	}
	return nil
}

// Selective optimization setting for this campaign, which includes a set of
// conversion actions to optimize this campaign towards.
type Campaign_SelectiveOptimization struct {
	// The selected set of conversion actions for optimizing this campaign.
	ConversionActions    []*wrappers.StringValue `protobuf:"bytes,1,rep,name=conversion_actions,json=conversionActions,proto3" json:"conversion_actions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Campaign_SelectiveOptimization) Reset()         { *m = Campaign_SelectiveOptimization{} }
func (m *Campaign_SelectiveOptimization) String() string { return proto.CompactTextString(m) }
func (*Campaign_SelectiveOptimization) ProtoMessage()    {}
func (*Campaign_SelectiveOptimization) Descriptor() ([]byte, []int) {
	return fileDescriptor_4590562366212c3a, []int{0, 4}
}

func (m *Campaign_SelectiveOptimization) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_SelectiveOptimization.Unmarshal(m, b)
}
func (m *Campaign_SelectiveOptimization) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_SelectiveOptimization.Marshal(b, m, deterministic)
}
func (m *Campaign_SelectiveOptimization) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_SelectiveOptimization.Merge(m, src)
}
func (m *Campaign_SelectiveOptimization) XXX_Size() int {
	return xxx_messageInfo_Campaign_SelectiveOptimization.Size(m)
}
func (m *Campaign_SelectiveOptimization) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_SelectiveOptimization.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_SelectiveOptimization proto.InternalMessageInfo

func (m *Campaign_SelectiveOptimization) GetConversionActions() []*wrappers.StringValue {
	if m != nil {
		return m.ConversionActions
	}
	return nil
}

// The setting for Shopping campaigns. Defines the universe of products that
// can be advertised by the campaign, and how this campaign interacts with
// other Shopping campaigns.
type Campaign_ShoppingSetting struct {
	// Immutable. ID of the Merchant Center account.
	// This field is required for create operations. This field is immutable for
	// Shopping campaigns.
	MerchantId *wrappers.Int64Value `protobuf:"bytes,1,opt,name=merchant_id,json=merchantId,proto3" json:"merchant_id,omitempty"`
	// Immutable. Sales country of products to include in the campaign.
	// This field is required for Shopping campaigns. This field is immutable.
	// This field is optional for non-Shopping campaigns, but it must be equal
	// to 'ZZ' if set.
	SalesCountry *wrappers.StringValue `protobuf:"bytes,2,opt,name=sales_country,json=salesCountry,proto3" json:"sales_country,omitempty"`
	// Priority of the campaign. Campaigns with numerically higher priorities
	// take precedence over those with lower priorities.
	// This field is required for Shopping campaigns, with values between 0 and
	// 2, inclusive.
	// This field is optional for Smart Shopping campaigns, but must be equal to
	// 3 if set.
	CampaignPriority *wrappers.Int32Value `protobuf:"bytes,3,opt,name=campaign_priority,json=campaignPriority,proto3" json:"campaign_priority,omitempty"`
	// Whether to include local products.
	EnableLocal          *wrappers.BoolValue `protobuf:"bytes,4,opt,name=enable_local,json=enableLocal,proto3" json:"enable_local,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Campaign_ShoppingSetting) Reset()         { *m = Campaign_ShoppingSetting{} }
func (m *Campaign_ShoppingSetting) String() string { return proto.CompactTextString(m) }
func (*Campaign_ShoppingSetting) ProtoMessage()    {}
func (*Campaign_ShoppingSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_4590562366212c3a, []int{0, 5}
}

func (m *Campaign_ShoppingSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_ShoppingSetting.Unmarshal(m, b)
}
func (m *Campaign_ShoppingSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_ShoppingSetting.Marshal(b, m, deterministic)
}
func (m *Campaign_ShoppingSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_ShoppingSetting.Merge(m, src)
}
func (m *Campaign_ShoppingSetting) XXX_Size() int {
	return xxx_messageInfo_Campaign_ShoppingSetting.Size(m)
}
func (m *Campaign_ShoppingSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_ShoppingSetting.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_ShoppingSetting proto.InternalMessageInfo

func (m *Campaign_ShoppingSetting) GetMerchantId() *wrappers.Int64Value {
	if m != nil {
		return m.MerchantId
	}
	return nil
}

func (m *Campaign_ShoppingSetting) GetSalesCountry() *wrappers.StringValue {
	if m != nil {
		return m.SalesCountry
	}
	return nil
}

func (m *Campaign_ShoppingSetting) GetCampaignPriority() *wrappers.Int32Value {
	if m != nil {
		return m.CampaignPriority
	}
	return nil
}

func (m *Campaign_ShoppingSetting) GetEnableLocal() *wrappers.BoolValue {
	if m != nil {
		return m.EnableLocal
	}
	return nil
}

// Campaign-level settings for tracking information.
type Campaign_TrackingSetting struct {
	// Output only. The url used for dynamic tracking.
	TrackingUrl          *wrappers.StringValue `protobuf:"bytes,1,opt,name=tracking_url,json=trackingUrl,proto3" json:"tracking_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Campaign_TrackingSetting) Reset()         { *m = Campaign_TrackingSetting{} }
func (m *Campaign_TrackingSetting) String() string { return proto.CompactTextString(m) }
func (*Campaign_TrackingSetting) ProtoMessage()    {}
func (*Campaign_TrackingSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_4590562366212c3a, []int{0, 6}
}

func (m *Campaign_TrackingSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_TrackingSetting.Unmarshal(m, b)
}
func (m *Campaign_TrackingSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_TrackingSetting.Marshal(b, m, deterministic)
}
func (m *Campaign_TrackingSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_TrackingSetting.Merge(m, src)
}
func (m *Campaign_TrackingSetting) XXX_Size() int {
	return xxx_messageInfo_Campaign_TrackingSetting.Size(m)
}
func (m *Campaign_TrackingSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_TrackingSetting.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_TrackingSetting proto.InternalMessageInfo

func (m *Campaign_TrackingSetting) GetTrackingUrl() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrl
	}
	return nil
}

// Campaign-level settings for App Campaigns.
type Campaign_AppCampaignSetting struct {
	// Represents the goal which the bidding strategy of this app campaign
	// should optimize towards.
	BiddingStrategyGoalType enums.AppCampaignBiddingStrategyGoalTypeEnum_AppCampaignBiddingStrategyGoalType `protobuf:"varint,1,opt,name=bidding_strategy_goal_type,json=biddingStrategyGoalType,proto3,enum=google.ads.googleads.v2.enums.AppCampaignBiddingStrategyGoalTypeEnum_AppCampaignBiddingStrategyGoalType" json:"bidding_strategy_goal_type,omitempty"`
	// Immutable. A string that uniquely identifies a mobile application.
	AppId *wrappers.StringValue `protobuf:"bytes,2,opt,name=app_id,json=appId,proto3" json:"app_id,omitempty"`
	// Immutable. The application store that distributes this specific app.
	AppStore             enums.AppCampaignAppStoreEnum_AppCampaignAppStore `protobuf:"varint,3,opt,name=app_store,json=appStore,proto3,enum=google.ads.googleads.v2.enums.AppCampaignAppStoreEnum_AppCampaignAppStore" json:"app_store,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                          `json:"-"`
	XXX_unrecognized     []byte                                            `json:"-"`
	XXX_sizecache        int32                                             `json:"-"`
}

func (m *Campaign_AppCampaignSetting) Reset()         { *m = Campaign_AppCampaignSetting{} }
func (m *Campaign_AppCampaignSetting) String() string { return proto.CompactTextString(m) }
func (*Campaign_AppCampaignSetting) ProtoMessage()    {}
func (*Campaign_AppCampaignSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_4590562366212c3a, []int{0, 7}
}

func (m *Campaign_AppCampaignSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_AppCampaignSetting.Unmarshal(m, b)
}
func (m *Campaign_AppCampaignSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_AppCampaignSetting.Marshal(b, m, deterministic)
}
func (m *Campaign_AppCampaignSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_AppCampaignSetting.Merge(m, src)
}
func (m *Campaign_AppCampaignSetting) XXX_Size() int {
	return xxx_messageInfo_Campaign_AppCampaignSetting.Size(m)
}
func (m *Campaign_AppCampaignSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_AppCampaignSetting.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_AppCampaignSetting proto.InternalMessageInfo

func (m *Campaign_AppCampaignSetting) GetBiddingStrategyGoalType() enums.AppCampaignBiddingStrategyGoalTypeEnum_AppCampaignBiddingStrategyGoalType {
	if m != nil {
		return m.BiddingStrategyGoalType
	}
	return enums.AppCampaignBiddingStrategyGoalTypeEnum_UNSPECIFIED
}

func (m *Campaign_AppCampaignSetting) GetAppId() *wrappers.StringValue {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *Campaign_AppCampaignSetting) GetAppStore() enums.AppCampaignAppStoreEnum_AppCampaignAppStore {
	if m != nil {
		return m.AppStore
	}
	return enums.AppCampaignAppStoreEnum_UNSPECIFIED
}

// Represents a collection of settings related to ads geotargeting.
type Campaign_GeoTargetTypeSetting struct {
	// The setting used for positive geotargeting in this particular campaign.
	PositiveGeoTargetType enums.PositiveGeoTargetTypeEnum_PositiveGeoTargetType `protobuf:"varint,1,opt,name=positive_geo_target_type,json=positiveGeoTargetType,proto3,enum=google.ads.googleads.v2.enums.PositiveGeoTargetTypeEnum_PositiveGeoTargetType" json:"positive_geo_target_type,omitempty"`
	// The setting used for negative geotargeting in this particular campaign.
	NegativeGeoTargetType enums.NegativeGeoTargetTypeEnum_NegativeGeoTargetType `protobuf:"varint,2,opt,name=negative_geo_target_type,json=negativeGeoTargetType,proto3,enum=google.ads.googleads.v2.enums.NegativeGeoTargetTypeEnum_NegativeGeoTargetType" json:"negative_geo_target_type,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}                                              `json:"-"`
	XXX_unrecognized      []byte                                                `json:"-"`
	XXX_sizecache         int32                                                 `json:"-"`
}

func (m *Campaign_GeoTargetTypeSetting) Reset()         { *m = Campaign_GeoTargetTypeSetting{} }
func (m *Campaign_GeoTargetTypeSetting) String() string { return proto.CompactTextString(m) }
func (*Campaign_GeoTargetTypeSetting) ProtoMessage()    {}
func (*Campaign_GeoTargetTypeSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_4590562366212c3a, []int{0, 8}
}

func (m *Campaign_GeoTargetTypeSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_GeoTargetTypeSetting.Unmarshal(m, b)
}
func (m *Campaign_GeoTargetTypeSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_GeoTargetTypeSetting.Marshal(b, m, deterministic)
}
func (m *Campaign_GeoTargetTypeSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_GeoTargetTypeSetting.Merge(m, src)
}
func (m *Campaign_GeoTargetTypeSetting) XXX_Size() int {
	return xxx_messageInfo_Campaign_GeoTargetTypeSetting.Size(m)
}
func (m *Campaign_GeoTargetTypeSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_GeoTargetTypeSetting.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_GeoTargetTypeSetting proto.InternalMessageInfo

func (m *Campaign_GeoTargetTypeSetting) GetPositiveGeoTargetType() enums.PositiveGeoTargetTypeEnum_PositiveGeoTargetType {
	if m != nil {
		return m.PositiveGeoTargetType
	}
	return enums.PositiveGeoTargetTypeEnum_UNSPECIFIED
}

func (m *Campaign_GeoTargetTypeSetting) GetNegativeGeoTargetType() enums.NegativeGeoTargetTypeEnum_NegativeGeoTargetType {
	if m != nil {
		return m.NegativeGeoTargetType
	}
	return enums.NegativeGeoTargetTypeEnum_UNSPECIFIED
}

func init() {
	proto.RegisterType((*Campaign)(nil), "google.ads.googleads.v2.resources.Campaign")
	proto.RegisterType((*Campaign_NetworkSettings)(nil), "google.ads.googleads.v2.resources.Campaign.NetworkSettings")
	proto.RegisterType((*Campaign_HotelSettingInfo)(nil), "google.ads.googleads.v2.resources.Campaign.HotelSettingInfo")
	proto.RegisterType((*Campaign_VanityPharma)(nil), "google.ads.googleads.v2.resources.Campaign.VanityPharma")
	proto.RegisterType((*Campaign_DynamicSearchAdsSetting)(nil), "google.ads.googleads.v2.resources.Campaign.DynamicSearchAdsSetting")
	proto.RegisterType((*Campaign_SelectiveOptimization)(nil), "google.ads.googleads.v2.resources.Campaign.SelectiveOptimization")
	proto.RegisterType((*Campaign_ShoppingSetting)(nil), "google.ads.googleads.v2.resources.Campaign.ShoppingSetting")
	proto.RegisterType((*Campaign_TrackingSetting)(nil), "google.ads.googleads.v2.resources.Campaign.TrackingSetting")
	proto.RegisterType((*Campaign_AppCampaignSetting)(nil), "google.ads.googleads.v2.resources.Campaign.AppCampaignSetting")
	proto.RegisterType((*Campaign_GeoTargetTypeSetting)(nil), "google.ads.googleads.v2.resources.Campaign.GeoTargetTypeSetting")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/resources/campaign.proto", fileDescriptor_4590562366212c3a)
}

var fileDescriptor_4590562366212c3a = []byte{
	// 2408 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x5a, 0x5b, 0x6f, 0x1b, 0xc7,
	0x15, 0x16, 0x29, 0xcb, 0xb5, 0x47, 0x57, 0x8f, 0x6e, 0x2b, 0xfa, 0x9e, 0xd6, 0x89, 0x64, 0x3b,
	0xa4, 0x42, 0xc7, 0x4e, 0x2a, 0x27, 0x81, 0x29, 0xfa, 0x22, 0xb9, 0xb6, 0xcc, 0x2e, 0x65, 0xd5,
	0x0d, 0x6c, 0x2c, 0x86, 0xbb, 0x43, 0x72, 0xe1, 0xbd, 0x4c, 0x76, 0x86, 0xb4, 0x98, 0x20, 0x45,
	0x81, 0x3e, 0xf4, 0xb1, 0x2f, 0xed, 0x4b, 0x11, 0xa0, 0x68, 0x81, 0xbc, 0xe4, 0x8f, 0x14, 0xe8,
	0xaf, 0xf0, 0x43, 0x9f, 0xf2, 0x13, 0xf4, 0x14, 0xcc, 0x65, 0x57, 0x4b, 0x72, 0xc9, 0x5d, 0xbe,
	0xed, 0x9c, 0x99, 0xef, 0x3b, 0x67, 0xce, 0xcc, 0x9c, 0x39, 0x67, 0x48, 0xb0, 0xdd, 0xf2, 0xfd,
	0x96, 0x83, 0x4b, 0xc8, 0xa2, 0x25, 0xf9, 0xc9, 0xbf, 0xba, 0xe5, 0x52, 0x80, 0xa9, 0xdf, 0x09,
	0x4c, 0x4c, 0x4b, 0x26, 0x72, 0x09, 0xb2, 0x5b, 0x5e, 0x91, 0x04, 0x3e, 0xf3, 0xe1, 0x75, 0x39,
	0xac, 0x88, 0x2c, 0x5a, 0x8c, 0x10, 0xc5, 0x6e, 0xb9, 0x18, 0x21, 0x0a, 0xb7, 0x47, 0x91, 0x9a,
	0xbe, 0xeb, 0xfa, 0x5e, 0xa9, 0x61, 0x5b, 0x96, 0xed, 0xb5, 0x24, 0x61, 0xe1, 0x6e, 0xca, 0x68,
	0xb3, 0x43, 0x99, 0xef, 0x1a, 0x04, 0x05, 0xc8, 0xc5, 0x0c, 0x07, 0x0a, 0x56, 0x4e, 0x81, 0x35,
	0x03, 0xfc, 0x4d, 0x07, 0x7b, 0x66, 0xcf, 0x30, 0x11, 0x51, 0x98, 0xaf, 0x52, 0x30, 0x01, 0x46,
	0x8e, 0xc1, 0x6c, 0x17, 0x1b, 0xca, 0x44, 0x83, 0x62, 0xc6, 0x4e, 0x4d, 0xbd, 0x97, 0x82, 0x67,
	0x28, 0x68, 0x61, 0x36, 0x8c, 0xdb, 0x1d, 0x85, 0xc3, 0x5e, 0xc7, 0xa5, 0x25, 0x64, 0x19, 0x14,
	0x07, 0x5d, 0x8e, 0xf3, 0x09, 0xb3, 0x5d, 0xfb, 0x5b, 0xc4, 0x6c, 0xdf, 0x33, 0x28, 0x43, 0xac,
	0x43, 0x15, 0xc7, 0x83, 0x34, 0x8e, 0x2e, 0x0e, 0x98, 0x4d, 0x39, 0x89, 0xd9, 0x46, 0x9e, 0x87,
	0x1d, 0x83, 0x76, 0x1a, 0x06, 0xeb, 0x11, 0xac, 0x18, 0xbe, 0x98, 0x9c, 0x21, 0x86, 0xde, 0x49,
	0x41, 0x13, 0x62, 0x84, 0x3b, 0xc5, 0xe0, 0x0d, 0xca, 0xfc, 0x20, 0xc4, 0xfe, 0x6e, 0x02, 0x6c,
	0xe4, 0x79, 0x16, 0x20, 0x86, 0x5b, 0x3d, 0xa3, 0xe5, 0xa3, 0x3e, 0x43, 0x7e, 0x3b, 0x9e, 0x6c,
	0x08, 0x9f, 0xdd, 0x03, 0x8d, 0x00, 0x79, 0x96, 0x41, 0x51, 0x13, 0xb3, 0x9e, 0x41, 0x3b, 0x36,
	0x43, 0x0d, 0xdb, 0xb1, 0x59, 0x2f, 0x1b, 0x3a, 0x9a, 0x01, 0x3e, 0x26, 0x38, 0xb0, 0x5d, 0xec,
	0xb1, 0xb8, 0xee, 0xfb, 0x19, 0xd1, 0xe1, 0x4e, 0xe8, 0x5b, 0xfc, 0x3b, 0x59, 0xc1, 0x71, 0x50,
	0x8a, 0xbd, 0x1e, 0x6e, 0x21, 0x66, 0x77, 0xb1, 0xd1, 0xc2, 0xbe, 0x21, 0x77, 0x6e, 0xdc, 0xde,
	0xed, 0xf1, 0x68, 0x82, 0x7a, 0x62, 0x86, 0xae, 0x6f, 0x65, 0xf4, 0x2e, 0xf1, 0xa9, 0x3d, 0x46,
	0x5f, 0xca, 0x19, 0xe9, 0x22, 0xcf, 0x66, 0x3d, 0x83, 0xb4, 0x51, 0xe0, 0x22, 0xc3, 0xb2, 0x29,
	0x71, 0x50, 0xcf, 0xe8, 0x04, 0x4e, 0xdc, 0x82, 0x7b, 0x93, 0x70, 0x30, 0x7c, 0xcc, 0x14, 0xee,
	0x6a, 0x88, 0x23, 0x76, 0xa9, 0x69, 0x63, 0xc7, 0x32, 0x1a, 0xb8, 0x8d, 0xba, 0xb6, 0x1f, 0x06,
	0x9b, 0x8d, 0xd8, 0x80, 0x30, 0xce, 0xa9, 0xae, 0x2b, 0xaa, 0x4b, 0xb4, 0x1a, 0x9d, 0x66, 0xe9,
	0x5d, 0x80, 0x08, 0xc1, 0x41, 0xb8, 0x0a, 0x97, 0x62, 0x50, 0xe4, 0x79, 0x3e, 0x13, 0x67, 0x5b,
	0xf5, 0x7e, 0xf0, 0x8f, 0x7b, 0xe0, 0x5c, 0x55, 0xad, 0x1e, 0x3c, 0x00, 0xf3, 0x21, 0xb9, 0xe1,
	0x21, 0x17, 0x6b, 0xb9, 0x6b, 0xb9, 0xcd, 0xf3, 0xbb, 0x5b, 0xef, 0x2b, 0x33, 0x27, 0x95, 0x5f,
	0x83, 0xeb, 0xa7, 0xe1, 0x56, 0x7d, 0x11, 0x9b, 0x16, 0x4d, 0xdf, 0x2d, 0x85, 0x0c, 0xfa, 0x5c,
	0x88, 0x3f, 0x40, 0x2e, 0x86, 0xdb, 0x20, 0x6f, 0x5b, 0xda, 0xf4, 0xb5, 0xdc, 0xe6, 0x6c, 0xf9,
	0xa2, 0xc2, 0x14, 0x43, 0x3b, 0x8b, 0xfb, 0x1e, 0xbb, 0xf7, 0xe9, 0x11, 0x72, 0x3a, 0x78, 0x77,
	0xfa, 0x7d, 0x65, 0x5a, 0xcf, 0xdb, 0x16, 0xdc, 0x06, 0x67, 0x84, 0xe2, 0x33, 0x02, 0x73, 0x69,
	0x08, 0x53, 0x67, 0x81, 0xed, 0xb5, 0x04, 0x48, 0x17, 0x23, 0xe1, 0x2b, 0x70, 0x56, 0x6e, 0x3a,
	0x6d, 0xe6, 0x5a, 0x6e, 0x73, 0xa1, 0xfc, 0xa0, 0x38, 0xea, 0x7e, 0x10, 0x6b, 0x50, 0x0c, 0x4d,
	0xad, 0x0b, 0xd0, 0x23, 0xaf, 0xe3, 0x0e, 0x88, 0x74, 0xc5, 0x07, 0xbf, 0x05, 0x0b, 0xfd, 0x67,
	0x41, 0x5b, 0x15, 0x1a, 0x0e, 0xb2, 0x6a, 0x90, 0xe0, 0x24, 0x45, 0xf1, 0x1e, 0x39, 0xf9, 0x79,
	0x1a, 0x97, 0xc1, 0x7f, 0xe5, 0xc0, 0x95, 0xf1, 0x51, 0x59, 0x3b, 0x27, 0x8c, 0xf9, 0x3a, 0xc5,
	0x98, 0x8a, 0xa5, 0x94, 0xbd, 0x88, 0x51, 0xc4, 0x4c, 0x1a, 0xd3, 0xaf, 0x5f, 0x44, 0xa3, 0x3b,
	0xe1, 0xdf, 0x72, 0x40, 0x1b, 0x15, 0xb1, 0xb5, 0xf3, 0xc2, 0xb6, 0x5a, 0xaa, 0x6d, 0x11, 0xbc,
	0x2a, 0xd1, 0x87, 0x3d, 0x82, 0x95, 0x59, 0x49, 0x5d, 0xdc, 0x55, 0x33, 0xfa, 0x1a, 0x4a, 0xec,
	0x84, 0x3f, 0xe4, 0xc0, 0xa5, 0x71, 0xb7, 0x90, 0x06, 0x84, 0x55, 0x47, 0x13, 0x5b, 0x55, 0xef,
	0x34, 0xc6, 0x18, 0xa6, 0x7a, 0xa5, 0x6d, 0x1b, 0x68, 0x54, 0x3f, 0xac, 0x81, 0x55, 0x16, 0x20,
	0xf3, 0x2d, 0x37, 0x8d, 0x87, 0x0d, 0x86, 0x5d, 0xe2, 0x20, 0x86, 0xb5, 0xd9, 0x0c, 0x7b, 0x7d,
	0x39, 0x84, 0xbe, 0x0c, 0x9c, 0x43, 0x05, 0x84, 0x26, 0x58, 0xe5, 0x44, 0x83, 0xf9, 0x09, 0xd5,
	0xe6, 0xae, 0x4d, 0x6f, 0xce, 0x96, 0x4b, 0x23, 0x27, 0x2a, 0xb3, 0x85, 0x62, 0x55, 0x00, 0x6b,
	0x21, 0x4e, 0x5f, 0xee, 0x04, 0xce, 0x80, 0x8c, 0xc2, 0x6f, 0xc0, 0xc6, 0xc8, 0xac, 0x44, 0xfb,
	0x48, 0x98, 0x7e, 0x2f, 0x4d, 0x91, 0x8e, 0x91, 0x73, 0x68, 0xbb, 0x78, 0x57, 0xc2, 0xeb, 0x12,
	0xad, 0xaf, 0x05, 0x89, 0x72, 0xd8, 0x04, 0x4b, 0x1e, 0x66, 0xef, 0xfc, 0xe0, 0x6d, 0xa8, 0x88,
	0x6a, 0x0b, 0x42, 0xd3, 0xfd, 0x62, 0x6a, 0xf2, 0x17, 0x1d, 0xb2, 0xe2, 0x81, 0xe4, 0x50, 0xac,
	0x54, 0x5f, 0xf4, 0xfa, 0x05, 0xb0, 0x09, 0xe6, 0xdb, 0x3e, 0xe3, 0x3b, 0x44, 0x4d, 0xe7, 0x9a,
	0x50, 0xf2, 0xc5, 0x24, 0x4a, 0xf6, 0x38, 0x81, 0x62, 0xdc, 0xf7, 0x9a, 0xbe, 0xdc, 0x06, 0x73,
	0xed, 0x98, 0x18, 0xfe, 0x39, 0x07, 0x0a, 0x56, 0xcf, 0x43, 0xae, 0x6d, 0x1a, 0x14, 0xa3, 0xc0,
	0x6c, 0x1b, 0xc8, 0xa2, 0x91, 0xd6, 0xeb, 0x42, 0x6b, 0x75, 0x12, 0xad, 0x0f, 0x25, 0x5b, 0x5d,
	0x90, 0x55, 0x2c, 0x1a, 0x7a, 0x74, 0xdd, 0x4a, 0xee, 0xe0, 0x2e, 0xa5, 0x6d, 0x9f, 0x90, 0xf8,
	0xe2, 0xfd, 0x66, 0x72, 0x97, 0xd6, 0x15, 0x47, 0xa8, 0x6f, 0x91, 0xf6, 0x0b, 0xe0, 0x1b, 0x70,
	0x61, 0x28, 0x07, 0xd5, 0x6e, 0x09, 0x45, 0xdb, 0x69, 0xbb, 0xe4, 0x30, 0x04, 0x86, 0xec, 0x4b,
	0x6c, 0x40, 0x02, 0xdf, 0x81, 0xf5, 0x81, 0xcb, 0x3b, 0x52, 0x52, 0x12, 0x4a, 0x1e, 0x4c, 0x32,
	0x9b, 0x27, 0xd8, 0x97, 0x3a, 0xf9, 0xf9, 0x0c, 0x95, 0xae, 0xb4, 0x12, 0xa4, 0x90, 0x80, 0x95,
	0xbe, 0x24, 0x31, 0xd4, 0x7a, 0x47, 0x68, 0xfd, 0x6a, 0x12, 0xad, 0x15, 0x42, 0x4e, 0xef, 0x01,
	0xa9, 0x13, 0xa2, 0x21, 0x19, 0xb4, 0xc0, 0x59, 0x07, 0x35, 0xb0, 0x43, 0xb5, 0xbb, 0xe2, 0x34,
	0x8f, 0x8d, 0x0f, 0xbb, 0xc5, 0xf7, 0x95, 0xe9, 0x93, 0xca, 0x26, 0xf8, 0x30, 0xf5, 0x8a, 0x7e,
	0xc6, 0x49, 0x75, 0xc5, 0x0d, 0xff, 0x04, 0x16, 0x07, 0xb2, 0x45, 0xed, 0x42, 0xa6, 0xd8, 0x1d,
	0xd2, 0x3d, 0x8a, 0xd0, 0x51, 0x88, 0x4c, 0xee, 0x92, 0xd7, 0xdc, 0x02, 0xee, 0x13, 0x42, 0x07,
	0xcc, 0x37, 0x10, 0xc5, 0x91, 0x63, 0xb5, 0x4b, 0xe9, 0xc1, 0x90, 0xe7, 0x23, 0xd3, 0x59, 0xf3,
	0x11, 0xce, 0x1e, 0xe5, 0x37, 0x14, 0x2c, 0x9e, 0xa6, 0xf9, 0x1d, 0xab, 0x85, 0x99, 0x76, 0x36,
	0x83, 0xbe, 0xdb, 0x27, 0x95, 0x2d, 0xf0, 0x51, 0xaa, 0xb2, 0x5d, 0xc1, 0xa8, 0x2f, 0x98, 0x7d,
	0x6d, 0xf8, 0x97, 0x1c, 0x58, 0x4d, 0xac, 0x09, 0xb4, 0x35, 0xe1, 0xe9, 0xa7, 0x29, 0x9e, 0x0e,
	0x83, 0xa3, 0x82, 0x46, 0x6e, 0x4e, 0x90, 0x4b, 0x1f, 0x2f, 0x37, 0x86, 0x7b, 0xe0, 0x7d, 0x00,
	0x28, 0x43, 0x01, 0x33, 0x2c, 0x7e, 0xe5, 0x2c, 0x67, 0xb8, 0x72, 0xce, 0x8b, 0xf1, 0x0f, 0xf9,
	0x45, 0xf3, 0x19, 0x38, 0x87, 0x3d, 0x4b, 0x42, 0x57, 0x32, 0x40, 0x7f, 0x85, 0x3d, 0x4b, 0x00,
	0x1f, 0x83, 0xa5, 0xa6, 0xed, 0x21, 0x47, 0x5c, 0x78, 0xb4, 0xd3, 0x6c, 0xda, 0xc7, 0xda, 0x87,
	0x19, 0x08, 0x16, 0x04, 0xea, 0x65, 0xe0, 0xd4, 0x05, 0x06, 0xbe, 0x02, 0x0b, 0x7d, 0xe5, 0x34,
	0xd5, 0x36, 0xc5, 0xa1, 0xf8, 0x24, 0x2d, 0xa6, 0x3c, 0x0e, 0x51, 0x55, 0x44, 0x1e, 0x79, 0x2c,
	0xe8, 0xe9, 0xf3, 0xcd, 0x98, 0x88, 0xc2, 0x7f, 0xe6, 0xc0, 0x95, 0xae, 0x6d, 0x61, 0xdf, 0x18,
	0x55, 0x7c, 0x69, 0x37, 0x33, 0x1d, 0x88, 0x5d, 0x0e, 0xaf, 0x0b, 0x74, 0xfd, 0x14, 0x2c, 0x57,
	0x2a, 0xb1, 0x4b, 0x2e, 0xd6, 0x45, 0xa1, 0x3c, 0x79, 0x04, 0x7c, 0x03, 0xe6, 0xfb, 0x4a, 0x06,
	0xed, 0xb6, 0xf0, 0xdd, 0xe7, 0x93, 0x84, 0x9b, 0x23, 0x41, 0x50, 0x13, 0x78, 0x7d, 0xae, 0x1b,
	0x6b, 0xc1, 0x63, 0xb0, 0x46, 0xb1, 0x83, 0x4d, 0x51, 0x14, 0xc5, 0x53, 0x4c, 0xed, 0x63, 0xa1,
	0xa7, 0x32, 0xd1, 0xd5, 0x10, 0x32, 0xc5, 0x73, 0x45, 0x7d, 0x95, 0x26, 0x89, 0xe1, 0x5b, 0xb0,
	0x14, 0xe5, 0x42, 0x61, 0x28, 0x2d, 0x4e, 0x7e, 0x1d, 0x1d, 0x2a, 0x0e, 0x15, 0x33, 0xa5, 0x47,
	0x17, 0x59, 0xbf, 0x14, 0xbe, 0x01, 0x73, 0xf1, 0x62, 0x51, 0xfb, 0x54, 0xac, 0xe7, 0x4e, 0xca,
	0x7a, 0xd6, 0x24, 0xe4, 0xb9, 0x6f, 0xc9, 0xe3, 0x16, 0x6b, 0xeb, 0xb3, 0xe4, 0xb4, 0x01, 0x8f,
	0xc1, 0xd2, 0xe0, 0xf1, 0xd6, 0xd6, 0x33, 0x44, 0x95, 0x8f, 0x4f, 0x2a, 0x37, 0xc1, 0xe6, 0xc8,
	0xa8, 0x32, 0x70, 0xbc, 0xf7, 0xa6, 0xf4, 0xc5, 0x81, 0x73, 0x0d, 0x9f, 0x01, 0xc0, 0xb7, 0xb9,
	0x4d, 0x29, 0x5f, 0xb3, 0x4f, 0x84, 0xce, 0x9b, 0xa9, 0x49, 0x5f, 0x84, 0xd8, 0x9b, 0xd2, 0x63,
	0x78, 0xf8, 0x14, 0x00, 0x17, 0x79, 0x1d, 0xe4, 0x18, 0x26, 0x31, 0x35, 0x4d, 0xb0, 0x6d, 0xa5,
	0xb1, 0x3d, 0x17, 0x88, 0x2a, 0x31, 0xf7, 0xa6, 0xf4, 0xf3, 0x6e, 0xd8, 0xe8, 0xe3, 0x72, 0xb5,
	0x8d, 0xc9, 0xb8, 0xdc, 0x38, 0x97, 0x0b, 0x5f, 0xc4, 0xb8, 0xba, 0xda, 0x8d, 0xc9, 0xb8, 0xba,
	0x62, 0x4f, 0xc4, 0x09, 0xbb, 0xb0, 0x0d, 0x56, 0x5c, 0x74, 0xcc, 0x37, 0x23, 0x36, 0x4c, 0xdf,
	0xeb, 0xe2, 0x80, 0xcf, 0x9f, 0x6a, 0x57, 0x04, 0xf5, 0x9d, 0x74, 0x6a, 0x89, 0xad, 0x9e, 0x42,
	0xf7, 0xa6, 0xf4, 0x65, 0x77, 0x58, 0x0c, 0x3b, 0x60, 0x23, 0x41, 0x93, 0xd1, 0xe5, 0xeb, 0xaf,
	0x5d, 0x15, 0xea, 0x3e, 0x9b, 0x5c, 0x9d, 0xd8, 0x3e, 0x7b, 0x53, 0xfa, 0xba, 0x9b, 0xdc, 0xc5,
	0xbd, 0xaf, 0x32, 0x24, 0x93, 0x20, 0xad, 0x90, 0xcd, 0x63, 0x32, 0xe7, 0xa9, 0x12, 0xc4, 0x9d,
	0xc5, 0xc2, 0x06, 0xf4, 0xc1, 0xba, 0xe2, 0xb2, 0x5d, 0x12, 0x60, 0xb1, 0x55, 0x0c, 0xda, 0x46,
	0x01, 0xd6, 0xb6, 0x05, 0xf1, 0xdd, 0x6c, 0xc4, 0xfb, 0x11, 0xba, 0xce, 0xc1, 0x7b, 0x53, 0xfa,
	0x2a, 0x4b, 0xea, 0x80, 0xcf, 0xc1, 0xac, 0x52, 0x18, 0xf8, 0x88, 0x6a, 0x97, 0xb3, 0xed, 0x6a,
	0xa9, 0x44, 0xf7, 0x11, 0x5f, 0x0b, 0x35, 0x7b, 0xde, 0x82, 0x35, 0x30, 0xa7, 0xe8, 0x28, 0xc1,
	0x9e, 0xa5, 0x5d, 0x14, 0x7c, 0xb7, 0xb2, 0xf1, 0xd5, 0x39, 0x64, 0x6f, 0x4a, 0x57, 0x16, 0x89,
	0x26, 0x37, 0x90, 0xe0, 0xc0, 0xe4, 0xe1, 0x84, 0x1f, 0x94, 0x0f, 0xb2, 0x19, 0x58, 0x93, 0x10,
	0x79, 0x52, 0x00, 0x89, 0x5a, 0x7d, 0x8b, 0xe5, 0x6a, 0x5b, 0x93, 0x2d, 0x96, 0x1b, 0x5f, 0x2c,
	0xb7, 0xf0, 0x3e, 0x0f, 0x16, 0x07, 0xaa, 0x1e, 0xf8, 0x0c, 0xac, 0x28, 0x7e, 0x49, 0xa4, 0x2a,
	0x10, 0xf1, 0xb4, 0x33, 0x5b, 0x2e, 0x0c, 0x85, 0xa8, 0x5d, 0xdf, 0x77, 0xe4, 0x25, 0x0c, 0x25,
	0xee, 0x89, 0x18, 0x20, 0x2b, 0x0a, 0x78, 0x00, 0x56, 0x43, 0x77, 0xca, 0x42, 0x46, 0xd5, 0x54,
	0x5a, 0x3e, 0x95, 0x6e, 0x59, 0x39, 0x51, 0xe0, 0x94, 0x95, 0xb0, 0x06, 0xd6, 0xc2, 0xd9, 0xfb,
	0x1e, 0xe3, 0x3e, 0x0d, 0x09, 0xa7, 0x53, 0x09, 0xd5, 0xbc, 0xaa, 0x12, 0x18, 0x32, 0xbe, 0x01,
	0x97, 0x15, 0x23, 0x41, 0x01, 0xf3, 0x70, 0x30, 0x68, 0xe9, 0x99, 0x54, 0xe2, 0x82, 0x24, 0xa8,
	0x49, 0x7c, 0x9f, 0xc1, 0x85, 0xd7, 0x60, 0x69, 0xb0, 0xe4, 0x83, 0x7b, 0x60, 0x51, 0xd6, 0x91,
	0x7c, 0x4d, 0x71, 0x60, 0xd8, 0x96, 0xf2, 0x6e, 0xda, 0x9b, 0xd7, 0x8c, 0x2e, 0x0b, 0xd0, 0xaa,
	0xc0, 0xed, 0x5b, 0x85, 0x7f, 0xe7, 0xc1, 0x5c, 0xfc, 0xc2, 0x86, 0x3f, 0xf0, 0xf4, 0x64, 0xec,
	0xcb, 0xa3, 0x50, 0xb5, 0x50, 0x7e, 0x95, 0x72, 0x9d, 0xc5, 0x59, 0x1f, 0x4a, 0x8a, 0x97, 0x81,
	0x13, 0xdd, 0x6e, 0xa3, 0xbb, 0xf5, 0x42, 0x77, 0x64, 0x1f, 0x0c, 0x00, 0x1c, 0x7e, 0xd3, 0x14,
	0x7b, 0x61, 0xa1, 0xfc, 0x70, 0x02, 0x8b, 0x0e, 0xf1, 0x31, 0x1b, 0xb2, 0x83, 0x0b, 0xf5, 0xa5,
	0xee, 0x80, 0xa4, 0xf0, 0xdf, 0x3c, 0x58, 0x1f, 0x51, 0xff, 0xc2, 0x2f, 0xc1, 0xac, 0xe5, 0xbb,
	0xc8, 0xf6, 0x4e, 0x9f, 0x2f, 0xd3, 0x52, 0x4d, 0x20, 0x01, 0xe2, 0xbd, 0xb2, 0x02, 0xe6, 0x1d,
	0xe4, 0xb5, 0x3a, 0xa8, 0xc5, 0xe3, 0xb5, 0x85, 0xd5, 0xae, 0x1e, 0x4f, 0x30, 0x17, 0x42, 0xaa,
	0xdc, 0x23, 0x2f, 0xc0, 0x5a, 0x87, 0x62, 0x83, 0x76, 0x08, 0x71, 0x6c, 0x6c, 0xf1, 0x65, 0xa2,
	0x86, 0xef, 0x39, 0xbd, 0x0c, 0x1b, 0x7a, 0xb9, 0x43, 0x71, 0x5d, 0x01, 0x5f, 0x06, 0x0e, 0x7d,
	0xe1, 0x39, 0x3d, 0xf8, 0x47, 0x30, 0xd3, 0xc4, 0xd8, 0xa2, 0xda, 0x4c, 0x86, 0x32, 0xf0, 0x86,
	0xa8, 0x8c, 0xae, 0x82, 0xcb, 0x23, 0xd3, 0x8a, 0xc7, 0x18, 0x5b, 0xba, 0x64, 0x2c, 0xfc, 0x3d,
	0x07, 0x56, 0x13, 0xd3, 0x36, 0xf8, 0x1d, 0x80, 0xb1, 0xfb, 0x0a, 0x99, 0xe2, 0xc5, 0x58, 0xcb,
	0x65, 0x29, 0x44, 0x4f, 0x2a, 0xb7, 0xc0, 0xd6, 0xe8, 0x5a, 0x29, 0x62, 0xad, 0x08, 0x52, 0xfd,
	0x82, 0x39, 0x20, 0xa1, 0x85, 0x1f, 0xf3, 0x60, 0x71, 0xe0, 0xa1, 0x01, 0x56, 0xc0, 0xac, 0x8b,
	0x03, 0xb3, 0x8d, 0x3c, 0x36, 0xc9, 0xf1, 0x02, 0x21, 0x68, 0xdf, 0x82, 0x8f, 0xc1, 0x3c, 0x45,
	0x0e, 0xa6, 0x86, 0xe9, 0x77, 0x78, 0x25, 0x90, 0x65, 0x71, 0xd5, 0x6b, 0x8e, 0xc0, 0x55, 0x25,
	0x0c, 0xee, 0x81, 0x0b, 0x51, 0x11, 0x49, 0x02, 0xdb, 0x0f, 0x78, 0x8d, 0x30, 0xe6, 0x8d, 0xfb,
	0x4e, 0x59, 0xae, 0xee, 0x52, 0x88, 0xaa, 0x29, 0x10, 0xfc, 0x12, 0xcc, 0x61, 0x0f, 0x35, 0x1c,
	0x6c, 0x38, 0xbe, 0x89, 0x9c, 0x0c, 0x91, 0x69, 0x56, 0x8e, 0x7f, 0xc6, 0x87, 0x17, 0xfe, 0x00,
	0x16, 0x07, 0x12, 0x60, 0xf8, 0x10, 0xcc, 0xc5, 0xdf, 0x18, 0xb3, 0x1c, 0x00, 0x99, 0x34, 0xcf,
	0xc6, 0xde, 0x17, 0x0b, 0xff, 0xcf, 0x03, 0x38, 0xfc, 0x4a, 0x01, 0x7f, 0xcc, 0x81, 0xc2, 0xe8,
	0x1f, 0xc7, 0x54, 0x1c, 0x6a, 0xa7, 0xbd, 0xae, 0x9e, 0xf2, 0x0e, 0x64, 0xb8, 0x4f, 0x7c, 0x14,
	0x7b, 0xff, 0x4d, 0x1d, 0xa6, 0xaf, 0x37, 0x92, 0x3b, 0xe0, 0xe7, 0xe0, 0x2c, 0x22, 0x84, 0x6f,
	0x93, 0xcc, 0x2b, 0x3c, 0x83, 0x08, 0xd9, 0xb7, 0xa0, 0x03, 0xce, 0x47, 0xbf, 0x1c, 0x8a, 0x25,
	0x4d, 0xaf, 0xce, 0x63, 0x86, 0x56, 0x08, 0xa9, 0x73, 0xe4, 0xe0, 0x04, 0x42, 0xb9, 0x54, 0x75,
	0x0e, 0xa9, 0x66, 0xe1, 0xa7, 0x3c, 0x58, 0x49, 0x7a, 0x82, 0x82, 0x7f, 0xcd, 0x01, 0x6d, 0xd4,
	0x8f, 0x55, 0xca, 0xcd, 0x69, 0xbf, 0x41, 0xd4, 0x14, 0xbc, 0x8f, 0x5f, 0xd6, 0x31, 0x49, 0x3d,
	0xfa, 0x2a, 0x49, 0x12, 0x0b, 0x4b, 0x46, 0xfd, 0x4c, 0xa7, 0xc2, 0x7c, 0x9a, 0x25, 0x07, 0x0a,
	0x3e, 0x6c, 0x49, 0x62, 0x8f, 0xbe, 0xea, 0x25, 0x89, 0x77, 0x7e, 0xff, 0x73, 0xe5, 0x20, 0xc3,
	0x83, 0x0f, 0xdc, 0x92, 0xaf, 0xe1, 0x38, 0xa0, 0xa5, 0xef, 0xc2, 0xcf, 0xef, 0xa3, 0xdf, 0x27,
	0xb9, 0x50, 0x7d, 0x7e, 0xbf, 0x7b, 0x11, 0x6c, 0x8c, 0xfc, 0xd1, 0x77, 0xf7, 0x24, 0x07, 0x6e,
	0x98, 0xbe, 0x9b, 0x5e, 0x8d, 0xee, 0xce, 0x57, 0xa3, 0x73, 0xed, 0x33, 0xbf, 0x96, 0xfb, 0xfa,
	0xa9, 0xc2, 0xb4, 0x7c, 0x7e, 0x33, 0x14, 0xfd, 0xa0, 0x55, 0x6a, 0x61, 0x4f, 0x6c, 0xbe, 0xd2,
	0xa9, 0xd9, 0x63, 0xfe, 0xf1, 0x70, 0x3f, 0xfa, 0xfa, 0x4f, 0x7e, 0xfa, 0x49, 0xa5, 0xf2, 0x53,
	0xfe, 0xba, 0x4c, 0xc2, 0x8a, 0x15, 0x8b, 0x16, 0xe5, 0x27, 0xff, 0x3a, 0x2a, 0x17, 0xf5, 0x70,
	0xe4, 0xff, 0xc2, 0x31, 0xaf, 0x2b, 0x16, 0x7d, 0x1d, 0x8d, 0x79, 0x7d, 0x54, 0x7e, 0x1d, 0x8d,
	0xf9, 0x39, 0x7f, 0x43, 0x76, 0xec, 0xec, 0x54, 0x2c, 0xba, 0xb3, 0x13, 0x8d, 0xda, 0xd9, 0x39,
	0x2a, 0xef, 0xec, 0x44, 0xe3, 0x1a, 0x67, 0x85, 0xb1, 0x77, 0x7e, 0x09, 0x00, 0x00, 0xff, 0xff,
	0xf8, 0xa5, 0x26, 0x8a, 0x9d, 0x21, 0x00, 0x00,
}
