package digitaltwins

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// IoTHubClient is the azure Digital Twins Client for managing DigitalTwinsInstance
type IoTHubClient struct {
	BaseClient
}

// NewIoTHubClient creates an instance of the IoTHubClient client.
func NewIoTHubClient(subscriptionID uuid.UUID) IoTHubClient {
	return NewIoTHubClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewIoTHubClientWithBaseURI creates an instance of the IoTHubClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewIoTHubClientWithBaseURI(baseURI string, subscriptionID uuid.UUID) IoTHubClient {
	return IoTHubClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate creates or Updates an IoTHub Integration with DigitalTwinsInstances.
// Parameters:
// scope - the scope of the Digital Twins Integration. The scope has to be an IoTHub resource. For example,
// /{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IoTHubs/{resourceName}.
// integrationResourceName - name of IoTHub and DigitalTwinsInstance integration instance.
// iotHubDescription - the IoTHub metadata.
func (client IoTHubClient) CreateOrUpdate(ctx context.Context, scope string, integrationResourceName string, iotHubDescription IntegrationResource) (result IntegrationResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IoTHubClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: integrationResourceName,
			Constraints: []validation.Constraint{{Target: "integrationResourceName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "integrationResourceName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("digitaltwins.IoTHubClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, scope, integrationResourceName, iotHubDescription)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.IoTHubClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "digitaltwins.IoTHubClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.IoTHubClient", "CreateOrUpdate", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client IoTHubClient) CreateOrUpdatePreparer(ctx context.Context, scope string, integrationResourceName string, iotHubDescription IntegrationResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"integrationResourceName": autorest.Encode("path", integrationResourceName),
		"scope":                   autorest.Encode("path", scope),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.DigitalTwins/integrationResources/{integrationResourceName}", pathParameters),
		autorest.WithJSON(iotHubDescription))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client IoTHubClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client IoTHubClient) CreateOrUpdateResponder(resp *http.Response) (result IntegrationResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes a DigitalTwinsInstance link with IoTHub.
// Parameters:
// scope - the scope of the Digital Twins Integration. The scope has to be an IoTHub resource. For example,
// /{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IoTHubs/{resourceName}.
// integrationResourceName - name of IoTHub and DigitalTwinsInstance integration instance.
func (client IoTHubClient) Delete(ctx context.Context, scope string, integrationResourceName string) (result IoTHubDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IoTHubClient.Delete")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: integrationResourceName,
			Constraints: []validation.Constraint{{Target: "integrationResourceName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "integrationResourceName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("digitaltwins.IoTHubClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, scope, integrationResourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.IoTHubClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.IoTHubClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client IoTHubClient) DeletePreparer(ctx context.Context, scope string, integrationResourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"integrationResourceName": autorest.Encode("path", integrationResourceName),
		"scope":                   autorest.Encode("path", scope),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.DigitalTwins/integrationResources/{integrationResourceName}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client IoTHubClient) DeleteSender(req *http.Request) (future IoTHubDeleteFuture, err error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req, sd...)
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client IoTHubClient) DeleteResponder(resp *http.Response) (result IntegrationResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get gets properties of an IoTHub Integration.
// Parameters:
// scope - the scope of the Digital Twins Integration. The scope has to be an IoTHub resource. For example,
// /{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IoTHubs/{resourceName}.
// integrationResourceName - name of IoTHub and DigitalTwinsInstance integration instance.
func (client IoTHubClient) Get(ctx context.Context, scope string, integrationResourceName string) (result IntegrationResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IoTHubClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: integrationResourceName,
			Constraints: []validation.Constraint{{Target: "integrationResourceName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "integrationResourceName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("digitaltwins.IoTHubClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, scope, integrationResourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.IoTHubClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "digitaltwins.IoTHubClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.IoTHubClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client IoTHubClient) GetPreparer(ctx context.Context, scope string, integrationResourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"integrationResourceName": autorest.Encode("path", integrationResourceName),
		"scope":                   autorest.Encode("path", scope),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.DigitalTwins/integrationResources/{integrationResourceName}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client IoTHubClient) GetSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client IoTHubClient) GetResponder(resp *http.Response) (result IntegrationResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
