// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListDocumentVersionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The name of the document. You can specify an Amazon Resource Name (ARN).
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDocumentVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDocumentVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDocumentVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListDocumentVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The document versions.
	DocumentVersions []DocumentVersionInfo `min:"1" type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDocumentVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListDocumentVersions = "ListDocumentVersions"

// ListDocumentVersionsRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// List all versions for a document.
//
//    // Example sending a request using ListDocumentVersionsRequest.
//    req := client.ListDocumentVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions
func (c *Client) ListDocumentVersionsRequest(input *ListDocumentVersionsInput) ListDocumentVersionsRequest {
	op := &aws.Operation{
		Name:       opListDocumentVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDocumentVersionsInput{}
	}

	req := c.newRequest(op, input, &ListDocumentVersionsOutput{})
	return ListDocumentVersionsRequest{Request: req, Input: input, Copy: c.ListDocumentVersionsRequest}
}

// ListDocumentVersionsRequest is the request type for the
// ListDocumentVersions API operation.
type ListDocumentVersionsRequest struct {
	*aws.Request
	Input *ListDocumentVersionsInput
	Copy  func(*ListDocumentVersionsInput) ListDocumentVersionsRequest
}

// Send marshals and sends the ListDocumentVersions API request.
func (r ListDocumentVersionsRequest) Send(ctx context.Context) (*ListDocumentVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDocumentVersionsResponse{
		ListDocumentVersionsOutput: r.Request.Data.(*ListDocumentVersionsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListDocumentVersionsResponse is the response type for the
// ListDocumentVersions API operation.
type ListDocumentVersionsResponse struct {
	*ListDocumentVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDocumentVersions request.
func (r *ListDocumentVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
