// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeClusterTracksInput struct {
	_ struct{} `type:"structure"`

	// The name of the maintenance track.
	MaintenanceTrackName *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterTracks request exceed
	// the value specified in MaxRecords, Amazon Redshift returns a value in the
	// Marker field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// An integer value for the maximum number of maintenance tracks to return.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeClusterTracksInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeClusterTracksOutput struct {
	_ struct{} `type:"structure"`

	// A list of maintenance tracks output by the DescribeClusterTracks operation.
	MaintenanceTracks []MaintenanceTrack `locationNameList:"MaintenanceTrack" type:"list"`

	// The starting point to return a set of response tracklist records. You can
	// retrieve the next set of response records by providing the returned marker
	// value in the Marker parameter and retrying the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterTracksOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeClusterTracks = "DescribeClusterTracks"

// DescribeClusterTracksRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Returns a list of all the available maintenance tracks.
//
//    // Example sending a request using DescribeClusterTracksRequest.
//    req := client.DescribeClusterTracksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterTracks
func (c *Client) DescribeClusterTracksRequest(input *DescribeClusterTracksInput) DescribeClusterTracksRequest {
	op := &aws.Operation{
		Name:       opDescribeClusterTracks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClusterTracksInput{}
	}

	req := c.newRequest(op, input, &DescribeClusterTracksOutput{})
	return DescribeClusterTracksRequest{Request: req, Input: input, Copy: c.DescribeClusterTracksRequest}
}

// DescribeClusterTracksRequest is the request type for the
// DescribeClusterTracks API operation.
type DescribeClusterTracksRequest struct {
	*aws.Request
	Input *DescribeClusterTracksInput
	Copy  func(*DescribeClusterTracksInput) DescribeClusterTracksRequest
}

// Send marshals and sends the DescribeClusterTracks API request.
func (r DescribeClusterTracksRequest) Send(ctx context.Context) (*DescribeClusterTracksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeClusterTracksResponse{
		DescribeClusterTracksOutput: r.Request.Data.(*DescribeClusterTracksOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeClusterTracksResponse is the response type for the
// DescribeClusterTracks API operation.
type DescribeClusterTracksResponse struct {
	*DescribeClusterTracksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeClusterTracks request.
func (r *DescribeClusterTracksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
