// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeResourceGroupsInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the resource group that you want to describe.
	//
	// ResourceGroupArns is a required field
	ResourceGroupArns []string `locationName:"resourceGroupArns" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeResourceGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourceGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeResourceGroupsInput"}

	if s.ResourceGroupArns == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceGroupArns"))
	}
	if s.ResourceGroupArns != nil && len(s.ResourceGroupArns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceGroupArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeResourceGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Resource group details that cannot be described. An error code is provided
	// for each failed item.
	//
	// FailedItems is a required field
	FailedItems map[string]FailedItemDetails `locationName:"failedItems" type:"map" required:"true"`

	// Information about a resource group.
	//
	// ResourceGroups is a required field
	ResourceGroups []ResourceGroup `locationName:"resourceGroups" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeResourceGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeResourceGroups = "DescribeResourceGroups"

// DescribeResourceGroupsRequest returns a request value for making API operation for
// Amazon Inspector.
//
// Describes the resource groups that are specified by the ARNs of the resource
// groups.
//
//    // Example sending a request using DescribeResourceGroupsRequest.
//    req := client.DescribeResourceGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeResourceGroups
func (c *Client) DescribeResourceGroupsRequest(input *DescribeResourceGroupsInput) DescribeResourceGroupsRequest {
	op := &aws.Operation{
		Name:       opDescribeResourceGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeResourceGroupsInput{}
	}

	req := c.newRequest(op, input, &DescribeResourceGroupsOutput{})
	return DescribeResourceGroupsRequest{Request: req, Input: input, Copy: c.DescribeResourceGroupsRequest}
}

// DescribeResourceGroupsRequest is the request type for the
// DescribeResourceGroups API operation.
type DescribeResourceGroupsRequest struct {
	*aws.Request
	Input *DescribeResourceGroupsInput
	Copy  func(*DescribeResourceGroupsInput) DescribeResourceGroupsRequest
}

// Send marshals and sends the DescribeResourceGroups API request.
func (r DescribeResourceGroupsRequest) Send(ctx context.Context) (*DescribeResourceGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeResourceGroupsResponse{
		DescribeResourceGroupsOutput: r.Request.Data.(*DescribeResourceGroupsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeResourceGroupsResponse is the response type for the
// DescribeResourceGroups API operation.
type DescribeResourceGroupsResponse struct {
	*DescribeResourceGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeResourceGroups request.
func (r *DescribeResourceGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
