// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListBackupVaultsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return maxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBackupVaultsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBackupVaultsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListBackupVaultsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBackupVaultsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListBackupVaultsOutput struct {
	_ struct{} `type:"structure"`

	// An array of backup vault list members containing vault metadata, including
	// Amazon Resource Name (ARN), display name, creation date, number of saved
	// recovery points, and encryption information if the resources saved in the
	// backup vault are encrypted.
	BackupVaultList []BackupVaultListMember `type:"list"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return maxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListBackupVaultsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBackupVaultsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupVaultList != nil {
		v := s.BackupVaultList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "BackupVaultList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListBackupVaults = "ListBackupVaults"

// ListBackupVaultsRequest returns a request value for making API operation for
// AWS Backup.
//
// Returns a list of recovery point storage containers along with information
// about them.
//
//    // Example sending a request using ListBackupVaultsRequest.
//    req := client.ListBackupVaultsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults
func (c *Client) ListBackupVaultsRequest(input *ListBackupVaultsInput) ListBackupVaultsRequest {
	op := &aws.Operation{
		Name:       opListBackupVaults,
		HTTPMethod: "GET",
		HTTPPath:   "/backup-vaults/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBackupVaultsInput{}
	}

	req := c.newRequest(op, input, &ListBackupVaultsOutput{})
	return ListBackupVaultsRequest{Request: req, Input: input, Copy: c.ListBackupVaultsRequest}
}

// ListBackupVaultsRequest is the request type for the
// ListBackupVaults API operation.
type ListBackupVaultsRequest struct {
	*aws.Request
	Input *ListBackupVaultsInput
	Copy  func(*ListBackupVaultsInput) ListBackupVaultsRequest
}

// Send marshals and sends the ListBackupVaults API request.
func (r ListBackupVaultsRequest) Send(ctx context.Context) (*ListBackupVaultsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListBackupVaultsResponse{
		ListBackupVaultsOutput: r.Request.Data.(*ListBackupVaultsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListBackupVaultsRequestPaginator returns a paginator for ListBackupVaults.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListBackupVaultsRequest(input)
//   p := backup.NewListBackupVaultsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListBackupVaultsPaginator(req ListBackupVaultsRequest) ListBackupVaultsPaginator {
	return ListBackupVaultsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListBackupVaultsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListBackupVaultsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListBackupVaultsPaginator struct {
	aws.Pager
}

func (p *ListBackupVaultsPaginator) CurrentPage() *ListBackupVaultsOutput {
	return p.Pager.CurrentPage().(*ListBackupVaultsOutput)
}

// ListBackupVaultsResponse is the response type for the
// ListBackupVaults API operation.
type ListBackupVaultsResponse struct {
	*ListBackupVaultsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListBackupVaults request.
func (r *ListBackupVaultsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
