// Licensed to the Apache Software Foundation(ASF) under one
// or more contributor license agreements.See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License. You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the License for the
// specific language governing permissions and limitations
// under the License.

#include <thrift/parse/t_program.h>
#include "thrift/common.h"
#include <thrift/generate/t_netcore_generator.h>
#include "t_netcore_generator_functional_tests_helpers.h"

const string TestDataGenerator::DEFAULT_FILE_HEADER = "/**" "\n"
            " * Autogenerated by Thrift Compiler ()" "\n"
            " *" "\n"
            " * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING" "\n"
            " *  @generated" "\n"
            " */";

std::pair<string, t_enum*> TestDataGenerator::get_test_enum_data(t_program* program)
{
    string expected_result = DEFAULT_FILE_HEADER +
        "\n"
        "\n"
        "/// <summary>\n"
        "/// TestDoc\n"
        "/// </summary>\n"
        "public enum TestName\n"
        "{\n"
        "  None = 0,\n"
        "  First = 1,\n"
        "  Second = 2,\n"
        "}\n";

    t_enum* enum_ = new t_enum(program);
    enum_->set_name("TestName");
    enum_->set_doc("TestDoc");
    enum_->append(new t_enum_value("None", 0));
    enum_->append(new t_enum_value("First", 1));
    enum_->append(new t_enum_value("Second", 2));

    return std::pair<string, t_enum*>(expected_result, enum_);
}

std::pair<string, t_const*> TestDataGenerator::get_test_void_const_data(t_netcore_generator* gen)
{
    string expected_result = DEFAULT_FILE_HEADER;

    t_type* type_ = new t_base_type("void", t_base_type::TYPE_VOID);
    type_->set_doc("TestDoc");

    t_const_value* const_value_ = new t_const_value();
    const_value_->set_string("VoidValue");

    t_const* const_ = new t_const(type_, "void", const_value_);
    const_->set_doc("TestDoc");

    return std::pair<string, t_const*>(expected_result, const_);
}

std::pair<string, t_const*> TestDataGenerator::get_test_string_const_data(t_netcore_generator* gen)
{
    string expected_result = DEFAULT_FILE_HEADER + "\n" +gen->netcore_type_usings() + 
        "\n"
        "public static class netcoreConstants\n"
        "{\n"
        "  /// <summary>\n"
        "  /// TestDoc\n"
        "  /// </summary>\n"
        "  public const string @string = \"StringValue\";\n"
        "}\n";

    t_type* type_ = new t_base_type("string", t_base_type::TYPE_STRING);
    type_->set_doc("TestDoc");

    t_const_value* const_value_ = new t_const_value();
    const_value_->set_string("StringValue");

    t_const* const_ = new t_const(type_, "string", const_value_);
    const_->set_doc("TestDoc");

    return std::pair<string, t_const*>(expected_result, const_);
}

std::pair<string, t_const*> TestDataGenerator::get_test_bool_const_data(t_netcore_generator* gen)
{
    string expected_result = DEFAULT_FILE_HEADER + "\n" +gen->netcore_type_usings() +
        "\n"
        "public static class netcoreConstants\n"
        "{\n"
        "  /// <summary>\n"
        "  /// TestDoc\n"
        "  /// </summary>\n"
        "  public const bool @bool = true;\n"
        "}\n";

    t_type* type_ = new t_base_type("bool", t_base_type::TYPE_BOOL);
    type_->set_doc("TestDoc");

    t_const_value* const_value_ = new t_const_value();
    const_value_->set_integer(1);

    t_const* const_ = new t_const(type_, "bool", const_value_);
    const_->set_doc("TestDoc");

    return std::pair<string, t_const*>(expected_result, const_);
}

std::pair<string, t_const*> TestDataGenerator::get_test_i8_const_data(t_netcore_generator* gen)
{
    string expected_result = DEFAULT_FILE_HEADER + "\n" +gen->netcore_type_usings() +
        "\n"
        "public static class netcoreConstants\n"
        "{\n"
        "  /// <summary>\n"
        "  /// TestDoc\n"
        "  /// </summary>\n"
        "  public const sbyte @sbyte = 127;\n"
        "}\n";

    t_type* type_ = new t_base_type("I8", t_base_type::TYPE_I8);
    type_->set_doc("TestDoc");

    t_const_value* const_value_ = new t_const_value();
    const_value_->set_integer(127);

    t_const* const_ = new t_const(type_, "sbyte", const_value_);
    const_->set_doc("TestDoc");

    return std::pair<string, t_const*>(expected_result, const_);
}

std::pair<string, t_const*> TestDataGenerator::get_test_i16_const_data(t_netcore_generator* gen)
{
    string expected_result = DEFAULT_FILE_HEADER + "\n" +gen->netcore_type_usings() +
        "\n"
        "public static class netcoreConstants\n"
        "{\n"
        "  /// <summary>\n"
        "  /// TestDoc\n"
        "  /// </summary>\n"
        "  public const short @short = 32767;\n"
        "}\n";

    t_type* type_ = new t_base_type("i16", t_base_type::TYPE_I16);
    type_->set_doc("TestDoc");

    t_const_value* const_value_ = new t_const_value();
    const_value_->set_integer(32767);

    t_const* const_ = new t_const(type_, "short", const_value_);
    const_->set_doc("TestDoc");

    return std::pair<string, t_const*>(expected_result, const_);
}

std::pair<string, t_const*> TestDataGenerator::get_test_i32_const_data(t_netcore_generator* gen)
{
    string expected_result = DEFAULT_FILE_HEADER + "\n" +gen->netcore_type_usings() +
        "\n"
        "public static class netcoreConstants\n"
        "{\n"
        "  /// <summary>\n"
        "  /// TestDoc\n"
        "  /// </summary>\n"
        "  public const int @int = 2147483647;\n"
        "}\n";

    t_type* type_ = new t_base_type("i32", t_base_type::TYPE_I32);
    type_->set_doc("TestDoc");

    t_const_value* const_value_ = new t_const_value();
    const_value_->set_integer(2147483647);

    t_const* const_ = new t_const(type_, "int", const_value_);
    const_->set_doc("TestDoc");

    return std::pair<string, t_const*>(expected_result, const_);
}

std::pair<string, t_const*> TestDataGenerator::get_test_i64_const_data(t_netcore_generator* gen)
{
    string expected_result = DEFAULT_FILE_HEADER + "\n" +gen->netcore_type_usings() +
        "\n"
        "public static class netcoreConstants\n"
        "{\n"
        "  /// <summary>\n"
        "  /// TestDoc\n"
        "  /// </summary>\n"
        "  public const long @long = 9223372036854775807;\n"
        "}\n";

    t_type* type_ = new t_base_type("i64", t_base_type::TYPE_I64);
    type_->set_doc("TestDoc");

    t_const_value* const_value_ = new t_const_value();
    const_value_->set_integer(9223372036854775807);

    t_const* const_ = new t_const(type_, "long", const_value_);
    const_->set_doc("TestDoc");

    return std::pair<string, t_const*>(expected_result, const_);
}

std::pair<string, t_const*> TestDataGenerator::get_test_double_const_data(t_netcore_generator* gen)
{
    string expected_result = DEFAULT_FILE_HEADER + "\n" +gen->netcore_type_usings() +
        "\n"
        "public static class netcoreConstants\n"
        "{\n"
        "  /// <summary>\n"
        "  /// TestDoc\n"
        "  /// </summary>\n"
        "  public const double @double = 9.22337e+18;\n"
        "}\n";

    t_type* type_ = new t_base_type("double", t_base_type::TYPE_DOUBLE);
    type_->set_doc("TestDoc");

    t_const_value* const_value_ = new t_const_value();
    const_value_->set_double(9223372036854775807.1);

    t_const* const_ = new t_const(type_, "double", const_value_);
    const_->set_doc("TestDoc");

    return std::pair<string, t_const*>(expected_result, const_);
}
