// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package xray

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opBatchGetTraces = "BatchGetTraces"

// BatchGetTracesRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetTraces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetTraces for more information on using the BatchGetTraces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetTracesRequest method.
//    req, resp := client.BatchGetTracesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/BatchGetTraces
func (c *XRay) BatchGetTracesRequest(input *BatchGetTracesInput) (req *request.Request, output *BatchGetTracesOutput) {
	op := &request.Operation{
		Name:       opBatchGetTraces,
		HTTPMethod: "POST",
		HTTPPath:   "/Traces",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &BatchGetTracesInput{}
	}

	output = &BatchGetTracesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetTraces API operation for AWS X-Ray.
//
// Retrieves a list of traces specified by ID. Each trace is a collection of
// segment documents that originates from a single request. Use GetTraceSummaries
// to get a list of trace IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation BatchGetTraces for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is missing required parameters or has invalid parameters.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/BatchGetTraces
func (c *XRay) BatchGetTraces(input *BatchGetTracesInput) (*BatchGetTracesOutput, error) {
	req, out := c.BatchGetTracesRequest(input)
	return out, req.Send()
}

// BatchGetTracesWithContext is the same as BatchGetTraces with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetTraces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) BatchGetTracesWithContext(ctx aws.Context, input *BatchGetTracesInput, opts ...request.Option) (*BatchGetTracesOutput, error) {
	req, out := c.BatchGetTracesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// BatchGetTracesPages iterates over the pages of a BatchGetTraces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See BatchGetTraces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a BatchGetTraces operation.
//    pageNum := 0
//    err := client.BatchGetTracesPages(params,
//        func(page *BatchGetTracesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *XRay) BatchGetTracesPages(input *BatchGetTracesInput, fn func(*BatchGetTracesOutput, bool) bool) error {
	return c.BatchGetTracesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// BatchGetTracesPagesWithContext same as BatchGetTracesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) BatchGetTracesPagesWithContext(ctx aws.Context, input *BatchGetTracesInput, fn func(*BatchGetTracesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *BatchGetTracesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.BatchGetTracesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*BatchGetTracesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetEncryptionConfig = "GetEncryptionConfig"

// GetEncryptionConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetEncryptionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEncryptionConfig for more information on using the GetEncryptionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEncryptionConfigRequest method.
//    req, resp := client.GetEncryptionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetEncryptionConfig
func (c *XRay) GetEncryptionConfigRequest(input *GetEncryptionConfigInput) (req *request.Request, output *GetEncryptionConfigOutput) {
	op := &request.Operation{
		Name:       opGetEncryptionConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/EncryptionConfig",
	}

	if input == nil {
		input = &GetEncryptionConfigInput{}
	}

	output = &GetEncryptionConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEncryptionConfig API operation for AWS X-Ray.
//
// Retrieves the current encryption configuration for X-Ray data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation GetEncryptionConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is missing required parameters or has invalid parameters.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetEncryptionConfig
func (c *XRay) GetEncryptionConfig(input *GetEncryptionConfigInput) (*GetEncryptionConfigOutput, error) {
	req, out := c.GetEncryptionConfigRequest(input)
	return out, req.Send()
}

// GetEncryptionConfigWithContext is the same as GetEncryptionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetEncryptionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetEncryptionConfigWithContext(ctx aws.Context, input *GetEncryptionConfigInput, opts ...request.Option) (*GetEncryptionConfigOutput, error) {
	req, out := c.GetEncryptionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceGraph = "GetServiceGraph"

// GetServiceGraphRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceGraph operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceGraph for more information on using the GetServiceGraph
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServiceGraphRequest method.
//    req, resp := client.GetServiceGraphRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetServiceGraph
func (c *XRay) GetServiceGraphRequest(input *GetServiceGraphInput) (req *request.Request, output *GetServiceGraphOutput) {
	op := &request.Operation{
		Name:       opGetServiceGraph,
		HTTPMethod: "POST",
		HTTPPath:   "/ServiceGraph",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetServiceGraphInput{}
	}

	output = &GetServiceGraphOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceGraph API operation for AWS X-Ray.
//
// Retrieves a document that describes services that process incoming requests,
// and downstream services that they call as a result. Root services process
// incoming requests and make calls to downstream services. Root services are
// applications that use the AWS X-Ray SDK. Downstream services can be other
// applications, AWS resources, HTTP web APIs, or SQL databases.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation GetServiceGraph for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is missing required parameters or has invalid parameters.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetServiceGraph
func (c *XRay) GetServiceGraph(input *GetServiceGraphInput) (*GetServiceGraphOutput, error) {
	req, out := c.GetServiceGraphRequest(input)
	return out, req.Send()
}

// GetServiceGraphWithContext is the same as GetServiceGraph with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceGraph for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetServiceGraphWithContext(ctx aws.Context, input *GetServiceGraphInput, opts ...request.Option) (*GetServiceGraphOutput, error) {
	req, out := c.GetServiceGraphRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetServiceGraphPages iterates over the pages of a GetServiceGraph operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetServiceGraph method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetServiceGraph operation.
//    pageNum := 0
//    err := client.GetServiceGraphPages(params,
//        func(page *GetServiceGraphOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *XRay) GetServiceGraphPages(input *GetServiceGraphInput, fn func(*GetServiceGraphOutput, bool) bool) error {
	return c.GetServiceGraphPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetServiceGraphPagesWithContext same as GetServiceGraphPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetServiceGraphPagesWithContext(ctx aws.Context, input *GetServiceGraphInput, fn func(*GetServiceGraphOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetServiceGraphInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetServiceGraphRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetServiceGraphOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetTraceGraph = "GetTraceGraph"

// GetTraceGraphRequest generates a "aws/request.Request" representing the
// client's request for the GetTraceGraph operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTraceGraph for more information on using the GetTraceGraph
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTraceGraphRequest method.
//    req, resp := client.GetTraceGraphRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTraceGraph
func (c *XRay) GetTraceGraphRequest(input *GetTraceGraphInput) (req *request.Request, output *GetTraceGraphOutput) {
	op := &request.Operation{
		Name:       opGetTraceGraph,
		HTTPMethod: "POST",
		HTTPPath:   "/TraceGraph",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTraceGraphInput{}
	}

	output = &GetTraceGraphOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTraceGraph API operation for AWS X-Ray.
//
// Retrieves a service graph for one or more specific trace IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation GetTraceGraph for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is missing required parameters or has invalid parameters.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTraceGraph
func (c *XRay) GetTraceGraph(input *GetTraceGraphInput) (*GetTraceGraphOutput, error) {
	req, out := c.GetTraceGraphRequest(input)
	return out, req.Send()
}

// GetTraceGraphWithContext is the same as GetTraceGraph with the addition of
// the ability to pass a context and additional request options.
//
// See GetTraceGraph for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetTraceGraphWithContext(ctx aws.Context, input *GetTraceGraphInput, opts ...request.Option) (*GetTraceGraphOutput, error) {
	req, out := c.GetTraceGraphRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTraceGraphPages iterates over the pages of a GetTraceGraph operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTraceGraph method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTraceGraph operation.
//    pageNum := 0
//    err := client.GetTraceGraphPages(params,
//        func(page *GetTraceGraphOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *XRay) GetTraceGraphPages(input *GetTraceGraphInput, fn func(*GetTraceGraphOutput, bool) bool) error {
	return c.GetTraceGraphPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTraceGraphPagesWithContext same as GetTraceGraphPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetTraceGraphPagesWithContext(ctx aws.Context, input *GetTraceGraphInput, fn func(*GetTraceGraphOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTraceGraphInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTraceGraphRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetTraceGraphOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetTraceSummaries = "GetTraceSummaries"

// GetTraceSummariesRequest generates a "aws/request.Request" representing the
// client's request for the GetTraceSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTraceSummaries for more information on using the GetTraceSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTraceSummariesRequest method.
//    req, resp := client.GetTraceSummariesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTraceSummaries
func (c *XRay) GetTraceSummariesRequest(input *GetTraceSummariesInput) (req *request.Request, output *GetTraceSummariesOutput) {
	op := &request.Operation{
		Name:       opGetTraceSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/TraceSummaries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTraceSummariesInput{}
	}

	output = &GetTraceSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTraceSummaries API operation for AWS X-Ray.
//
// Retrieves IDs and metadata for traces available for a specified time frame
// using an optional filter. To get the full traces, pass the trace IDs to BatchGetTraces.
//
// A filter expression can target traced requests that hit specific service
// nodes or edges, have errors, or come from a known user. For example, the
// following filter expression targets traces that pass through api.example.com:
//
// service("api.example.com")
//
// This filter expression finds traces that have an annotation named account
// with the value 12345:
//
// annotation.account = "12345"
//
// For a full list of indexed fields and keywords that you can use in filter
// expressions, see Using Filter Expressions (http://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html)
// in the AWS X-Ray Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation GetTraceSummaries for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is missing required parameters or has invalid parameters.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTraceSummaries
func (c *XRay) GetTraceSummaries(input *GetTraceSummariesInput) (*GetTraceSummariesOutput, error) {
	req, out := c.GetTraceSummariesRequest(input)
	return out, req.Send()
}

// GetTraceSummariesWithContext is the same as GetTraceSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See GetTraceSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetTraceSummariesWithContext(ctx aws.Context, input *GetTraceSummariesInput, opts ...request.Option) (*GetTraceSummariesOutput, error) {
	req, out := c.GetTraceSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTraceSummariesPages iterates over the pages of a GetTraceSummaries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTraceSummaries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTraceSummaries operation.
//    pageNum := 0
//    err := client.GetTraceSummariesPages(params,
//        func(page *GetTraceSummariesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *XRay) GetTraceSummariesPages(input *GetTraceSummariesInput, fn func(*GetTraceSummariesOutput, bool) bool) error {
	return c.GetTraceSummariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTraceSummariesPagesWithContext same as GetTraceSummariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) GetTraceSummariesPagesWithContext(ctx aws.Context, input *GetTraceSummariesInput, fn func(*GetTraceSummariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTraceSummariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTraceSummariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetTraceSummariesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opPutEncryptionConfig = "PutEncryptionConfig"

// PutEncryptionConfigRequest generates a "aws/request.Request" representing the
// client's request for the PutEncryptionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEncryptionConfig for more information on using the PutEncryptionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEncryptionConfigRequest method.
//    req, resp := client.PutEncryptionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutEncryptionConfig
func (c *XRay) PutEncryptionConfigRequest(input *PutEncryptionConfigInput) (req *request.Request, output *PutEncryptionConfigOutput) {
	op := &request.Operation{
		Name:       opPutEncryptionConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/PutEncryptionConfig",
	}

	if input == nil {
		input = &PutEncryptionConfigInput{}
	}

	output = &PutEncryptionConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEncryptionConfig API operation for AWS X-Ray.
//
// Updates the encryption configuration for X-Ray data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation PutEncryptionConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is missing required parameters or has invalid parameters.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutEncryptionConfig
func (c *XRay) PutEncryptionConfig(input *PutEncryptionConfigInput) (*PutEncryptionConfigOutput, error) {
	req, out := c.PutEncryptionConfigRequest(input)
	return out, req.Send()
}

// PutEncryptionConfigWithContext is the same as PutEncryptionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See PutEncryptionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) PutEncryptionConfigWithContext(ctx aws.Context, input *PutEncryptionConfigInput, opts ...request.Option) (*PutEncryptionConfigOutput, error) {
	req, out := c.PutEncryptionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutTelemetryRecords = "PutTelemetryRecords"

// PutTelemetryRecordsRequest generates a "aws/request.Request" representing the
// client's request for the PutTelemetryRecords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutTelemetryRecords for more information on using the PutTelemetryRecords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutTelemetryRecordsRequest method.
//    req, resp := client.PutTelemetryRecordsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutTelemetryRecords
func (c *XRay) PutTelemetryRecordsRequest(input *PutTelemetryRecordsInput) (req *request.Request, output *PutTelemetryRecordsOutput) {
	op := &request.Operation{
		Name:       opPutTelemetryRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/TelemetryRecords",
	}

	if input == nil {
		input = &PutTelemetryRecordsInput{}
	}

	output = &PutTelemetryRecordsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutTelemetryRecords API operation for AWS X-Ray.
//
// Used by the AWS X-Ray daemon to upload telemetry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation PutTelemetryRecords for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is missing required parameters or has invalid parameters.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutTelemetryRecords
func (c *XRay) PutTelemetryRecords(input *PutTelemetryRecordsInput) (*PutTelemetryRecordsOutput, error) {
	req, out := c.PutTelemetryRecordsRequest(input)
	return out, req.Send()
}

// PutTelemetryRecordsWithContext is the same as PutTelemetryRecords with the addition of
// the ability to pass a context and additional request options.
//
// See PutTelemetryRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) PutTelemetryRecordsWithContext(ctx aws.Context, input *PutTelemetryRecordsInput, opts ...request.Option) (*PutTelemetryRecordsOutput, error) {
	req, out := c.PutTelemetryRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutTraceSegments = "PutTraceSegments"

// PutTraceSegmentsRequest generates a "aws/request.Request" representing the
// client's request for the PutTraceSegments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutTraceSegments for more information on using the PutTraceSegments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutTraceSegmentsRequest method.
//    req, resp := client.PutTraceSegmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutTraceSegments
func (c *XRay) PutTraceSegmentsRequest(input *PutTraceSegmentsInput) (req *request.Request, output *PutTraceSegmentsOutput) {
	op := &request.Operation{
		Name:       opPutTraceSegments,
		HTTPMethod: "POST",
		HTTPPath:   "/TraceSegments",
	}

	if input == nil {
		input = &PutTraceSegmentsInput{}
	}

	output = &PutTraceSegmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutTraceSegments API operation for AWS X-Ray.
//
// Uploads segment documents to AWS X-Ray. The X-Ray SDK generates segment documents
// and sends them to the X-Ray daemon, which uploads them in batches. A segment
// document can be a completed segment, an in-progress segment, or an array
// of subsegments.
//
// Segments must include the following fields. For the full segment document
// schema, see AWS X-Ray Segment Documents (https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html)
// in the AWS X-Ray Developer Guide.
//
// Required Segment Document Fields
//
//    * name - The name of the service that handled the request.
//
//    * id - A 64-bit identifier for the segment, unique among segments in the
//    same trace, in 16 hexadecimal digits.
//
//    * trace_id - A unique identifier that connects all segments and subsegments
//    originating from a single client request.
//
//    * start_time - Time the segment or subsegment was created, in floating
//    point seconds in epoch time, accurate to milliseconds. For example, 1480615200.010
//    or 1.480615200010E9.
//
//    * end_time - Time the segment or subsegment was closed. For example, 1480615200.090
//    or 1.480615200090E9. Specify either an end_time or in_progress.
//
//    * in_progress - Set to true instead of specifying an end_time to record
//    that a segment has been started, but is not complete. Send an in progress
//    segment when your application receives a request that will take a long
//    time to serve, to trace the fact that the request was received. When the
//    response is sent, send the complete segment to overwrite the in-progress
//    segment.
//
// A trace_id consists of three numbers separated by hyphens. For example, 1-58406520-a006649127e371903a2de979.
// This includes:
//
// Trace ID Format
//
//    * The version number, i.e. 1.
//
//    * The time of the original request, in Unix epoch time, in 8 hexadecimal
//    digits. For example, 10:00AM December 2nd, 2016 PST in epoch time is 1480615200
//    seconds, or 58406520 in hexadecimal.
//
//    * A 96-bit identifier for the trace, globally unique, in 24 hexadecimal
//    digits.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS X-Ray's
// API operation PutTraceSegments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is missing required parameters or has invalid parameters.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request exceeds the maximum number of requests per second.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutTraceSegments
func (c *XRay) PutTraceSegments(input *PutTraceSegmentsInput) (*PutTraceSegmentsOutput, error) {
	req, out := c.PutTraceSegmentsRequest(input)
	return out, req.Send()
}

// PutTraceSegmentsWithContext is the same as PutTraceSegments with the addition of
// the ability to pass a context and additional request options.
//
// See PutTraceSegments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *XRay) PutTraceSegmentsWithContext(ctx aws.Context, input *PutTraceSegmentsInput, opts ...request.Option) (*PutTraceSegmentsOutput, error) {
	req, out := c.PutTraceSegmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An alias for an edge.
type Alias struct {
	_ struct{} `type:"structure"`

	// The canonical name of the alias.
	Name *string `type:"string"`

	// A list of names for the alias, including the canonical name.
	Names []*string `type:"list"`

	// The type of the alias.
	Type *string `type:"string"`
}

// String returns the string representation
func (s Alias) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Alias) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Alias) SetName(v string) *Alias {
	s.Name = &v
	return s
}

// SetNames sets the Names field's value.
func (s *Alias) SetNames(v []*string) *Alias {
	s.Names = v
	return s
}

// SetType sets the Type field's value.
func (s *Alias) SetType(v string) *Alias {
	s.Type = &v
	return s
}

// Value of a segment annotation. Has one of three value types: Number, Boolean
// or String.
type AnnotationValue struct {
	_ struct{} `type:"structure"`

	// Value for a Boolean annotation.
	BooleanValue *bool `type:"boolean"`

	// Value for a Number annotation.
	NumberValue *float64 `type:"double"`

	// Value for a String annotation.
	StringValue *string `type:"string"`
}

// String returns the string representation
func (s AnnotationValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnnotationValue) GoString() string {
	return s.String()
}

// SetBooleanValue sets the BooleanValue field's value.
func (s *AnnotationValue) SetBooleanValue(v bool) *AnnotationValue {
	s.BooleanValue = &v
	return s
}

// SetNumberValue sets the NumberValue field's value.
func (s *AnnotationValue) SetNumberValue(v float64) *AnnotationValue {
	s.NumberValue = &v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *AnnotationValue) SetStringValue(v string) *AnnotationValue {
	s.StringValue = &v
	return s
}

type BackendConnectionErrors struct {
	_ struct{} `type:"structure"`

	ConnectionRefusedCount *int64 `type:"integer"`

	HTTPCode4XXCount *int64 `type:"integer"`

	HTTPCode5XXCount *int64 `type:"integer"`

	OtherCount *int64 `type:"integer"`

	TimeoutCount *int64 `type:"integer"`

	UnknownHostCount *int64 `type:"integer"`
}

// String returns the string representation
func (s BackendConnectionErrors) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BackendConnectionErrors) GoString() string {
	return s.String()
}

// SetConnectionRefusedCount sets the ConnectionRefusedCount field's value.
func (s *BackendConnectionErrors) SetConnectionRefusedCount(v int64) *BackendConnectionErrors {
	s.ConnectionRefusedCount = &v
	return s
}

// SetHTTPCode4XXCount sets the HTTPCode4XXCount field's value.
func (s *BackendConnectionErrors) SetHTTPCode4XXCount(v int64) *BackendConnectionErrors {
	s.HTTPCode4XXCount = &v
	return s
}

// SetHTTPCode5XXCount sets the HTTPCode5XXCount field's value.
func (s *BackendConnectionErrors) SetHTTPCode5XXCount(v int64) *BackendConnectionErrors {
	s.HTTPCode5XXCount = &v
	return s
}

// SetOtherCount sets the OtherCount field's value.
func (s *BackendConnectionErrors) SetOtherCount(v int64) *BackendConnectionErrors {
	s.OtherCount = &v
	return s
}

// SetTimeoutCount sets the TimeoutCount field's value.
func (s *BackendConnectionErrors) SetTimeoutCount(v int64) *BackendConnectionErrors {
	s.TimeoutCount = &v
	return s
}

// SetUnknownHostCount sets the UnknownHostCount field's value.
func (s *BackendConnectionErrors) SetUnknownHostCount(v int64) *BackendConnectionErrors {
	s.UnknownHostCount = &v
	return s
}

type BatchGetTracesInput struct {
	_ struct{} `type:"structure"`

	// Pagination token. Not used.
	NextToken *string `type:"string"`

	// Specify the trace IDs of requests for which to retrieve segments.
	//
	// TraceIds is a required field
	TraceIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetTracesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetTracesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetTracesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetTracesInput"}
	if s.TraceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("TraceIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *BatchGetTracesInput) SetNextToken(v string) *BatchGetTracesInput {
	s.NextToken = &v
	return s
}

// SetTraceIds sets the TraceIds field's value.
func (s *BatchGetTracesInput) SetTraceIds(v []*string) *BatchGetTracesInput {
	s.TraceIds = v
	return s
}

type BatchGetTracesOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token. Not used.
	NextToken *string `type:"string"`

	// Full traces for the specified requests.
	Traces []*Trace `type:"list"`

	// Trace IDs of requests that haven't been processed.
	UnprocessedTraceIds []*string `type:"list"`
}

// String returns the string representation
func (s BatchGetTracesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetTracesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *BatchGetTracesOutput) SetNextToken(v string) *BatchGetTracesOutput {
	s.NextToken = &v
	return s
}

// SetTraces sets the Traces field's value.
func (s *BatchGetTracesOutput) SetTraces(v []*Trace) *BatchGetTracesOutput {
	s.Traces = v
	return s
}

// SetUnprocessedTraceIds sets the UnprocessedTraceIds field's value.
func (s *BatchGetTracesOutput) SetUnprocessedTraceIds(v []*string) *BatchGetTracesOutput {
	s.UnprocessedTraceIds = v
	return s
}

// Information about a connection between two services.
type Edge struct {
	_ struct{} `type:"structure"`

	// Aliases for the edge.
	Aliases []*Alias `type:"list"`

	// The end time of the last segment on the edge.
	EndTime *time.Time `type:"timestamp"`

	// Identifier of the edge. Unique within a service map.
	ReferenceId *int64 `type:"integer"`

	// A histogram that maps the spread of client response times on an edge.
	ResponseTimeHistogram []*HistogramEntry `type:"list"`

	// The start time of the first segment on the edge.
	StartTime *time.Time `type:"timestamp"`

	// Response statistics for segments on the edge.
	SummaryStatistics *EdgeStatistics `type:"structure"`
}

// String returns the string representation
func (s Edge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Edge) GoString() string {
	return s.String()
}

// SetAliases sets the Aliases field's value.
func (s *Edge) SetAliases(v []*Alias) *Edge {
	s.Aliases = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Edge) SetEndTime(v time.Time) *Edge {
	s.EndTime = &v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *Edge) SetReferenceId(v int64) *Edge {
	s.ReferenceId = &v
	return s
}

// SetResponseTimeHistogram sets the ResponseTimeHistogram field's value.
func (s *Edge) SetResponseTimeHistogram(v []*HistogramEntry) *Edge {
	s.ResponseTimeHistogram = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Edge) SetStartTime(v time.Time) *Edge {
	s.StartTime = &v
	return s
}

// SetSummaryStatistics sets the SummaryStatistics field's value.
func (s *Edge) SetSummaryStatistics(v *EdgeStatistics) *Edge {
	s.SummaryStatistics = v
	return s
}

// Response statistics for an edge.
type EdgeStatistics struct {
	_ struct{} `type:"structure"`

	// Information about requests that failed with a 4xx Client Error status code.
	ErrorStatistics *ErrorStatistics `type:"structure"`

	// Information about requests that failed with a 5xx Server Error status code.
	FaultStatistics *FaultStatistics `type:"structure"`

	// The number of requests that completed with a 2xx Success status code.
	OkCount *int64 `type:"long"`

	// The total number of completed requests.
	TotalCount *int64 `type:"long"`

	// The aggregate response time of completed requests.
	TotalResponseTime *float64 `type:"double"`
}

// String returns the string representation
func (s EdgeStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EdgeStatistics) GoString() string {
	return s.String()
}

// SetErrorStatistics sets the ErrorStatistics field's value.
func (s *EdgeStatistics) SetErrorStatistics(v *ErrorStatistics) *EdgeStatistics {
	s.ErrorStatistics = v
	return s
}

// SetFaultStatistics sets the FaultStatistics field's value.
func (s *EdgeStatistics) SetFaultStatistics(v *FaultStatistics) *EdgeStatistics {
	s.FaultStatistics = v
	return s
}

// SetOkCount sets the OkCount field's value.
func (s *EdgeStatistics) SetOkCount(v int64) *EdgeStatistics {
	s.OkCount = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *EdgeStatistics) SetTotalCount(v int64) *EdgeStatistics {
	s.TotalCount = &v
	return s
}

// SetTotalResponseTime sets the TotalResponseTime field's value.
func (s *EdgeStatistics) SetTotalResponseTime(v float64) *EdgeStatistics {
	s.TotalResponseTime = &v
	return s
}

// A configuration document that specifies encryption configuration settings.
type EncryptionConfig struct {
	_ struct{} `type:"structure"`

	// The ID of the customer master key (CMK) used for encryption, if applicable.
	KeyId *string `type:"string"`

	// The encryption status. After modifying encryption configuration with PutEncryptionConfig,
	// the status can be UPDATING for up to one hour before X-Ray starts encrypting
	// data with the new key.
	Status *string `type:"string" enum:"EncryptionStatus"`

	// The type of encryption. Set to KMS for encryption with CMKs. Set to NONE
	// for default encryption.
	Type *string `type:"string" enum:"EncryptionType"`
}

// String returns the string representation
func (s EncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionConfig) GoString() string {
	return s.String()
}

// SetKeyId sets the KeyId field's value.
func (s *EncryptionConfig) SetKeyId(v string) *EncryptionConfig {
	s.KeyId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EncryptionConfig) SetStatus(v string) *EncryptionConfig {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *EncryptionConfig) SetType(v string) *EncryptionConfig {
	s.Type = &v
	return s
}

// Information about requests that failed with a 4xx Client Error status code.
type ErrorStatistics struct {
	_ struct{} `type:"structure"`

	// The number of requests that failed with untracked 4xx Client Error status
	// codes.
	OtherCount *int64 `type:"long"`

	// The number of requests that failed with a 419 throttling status code.
	ThrottleCount *int64 `type:"long"`

	// The total number of requests that failed with a 4xx Client Error status code.
	TotalCount *int64 `type:"long"`
}

// String returns the string representation
func (s ErrorStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorStatistics) GoString() string {
	return s.String()
}

// SetOtherCount sets the OtherCount field's value.
func (s *ErrorStatistics) SetOtherCount(v int64) *ErrorStatistics {
	s.OtherCount = &v
	return s
}

// SetThrottleCount sets the ThrottleCount field's value.
func (s *ErrorStatistics) SetThrottleCount(v int64) *ErrorStatistics {
	s.ThrottleCount = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ErrorStatistics) SetTotalCount(v int64) *ErrorStatistics {
	s.TotalCount = &v
	return s
}

// Information about requests that failed with a 5xx Server Error status code.
type FaultStatistics struct {
	_ struct{} `type:"structure"`

	// The number of requests that failed with untracked 5xx Server Error status
	// codes.
	OtherCount *int64 `type:"long"`

	// The total number of requests that failed with a 5xx Server Error status code.
	TotalCount *int64 `type:"long"`
}

// String returns the string representation
func (s FaultStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FaultStatistics) GoString() string {
	return s.String()
}

// SetOtherCount sets the OtherCount field's value.
func (s *FaultStatistics) SetOtherCount(v int64) *FaultStatistics {
	s.OtherCount = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *FaultStatistics) SetTotalCount(v int64) *FaultStatistics {
	s.TotalCount = &v
	return s
}

type GetEncryptionConfigInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEncryptionConfigInput) GoString() string {
	return s.String()
}

type GetEncryptionConfigOutput struct {
	_ struct{} `type:"structure"`

	// The encryption configuration document.
	EncryptionConfig *EncryptionConfig `type:"structure"`
}

// String returns the string representation
func (s GetEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEncryptionConfigOutput) GoString() string {
	return s.String()
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *GetEncryptionConfigOutput) SetEncryptionConfig(v *EncryptionConfig) *GetEncryptionConfigOutput {
	s.EncryptionConfig = v
	return s
}

type GetServiceGraphInput struct {
	_ struct{} `type:"structure"`

	// The end of the time frame for which to generate a graph.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// Pagination token. Not used.
	NextToken *string `type:"string"`

	// The start of the time frame for which to generate a graph.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s GetServiceGraphInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceGraphInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceGraphInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceGraphInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetServiceGraphInput) SetEndTime(v time.Time) *GetServiceGraphInput {
	s.EndTime = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetServiceGraphInput) SetNextToken(v string) *GetServiceGraphInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetServiceGraphInput) SetStartTime(v time.Time) *GetServiceGraphInput {
	s.StartTime = &v
	return s
}

type GetServiceGraphOutput struct {
	_ struct{} `type:"structure"`

	// The end of the time frame for which the graph was generated.
	EndTime *time.Time `type:"timestamp"`

	// Pagination token. Not used.
	NextToken *string `type:"string"`

	// The services that have processed a traced request during the specified time
	// frame.
	Services []*Service `type:"list"`

	// The start of the time frame for which the graph was generated.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s GetServiceGraphOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceGraphOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *GetServiceGraphOutput) SetEndTime(v time.Time) *GetServiceGraphOutput {
	s.EndTime = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetServiceGraphOutput) SetNextToken(v string) *GetServiceGraphOutput {
	s.NextToken = &v
	return s
}

// SetServices sets the Services field's value.
func (s *GetServiceGraphOutput) SetServices(v []*Service) *GetServiceGraphOutput {
	s.Services = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetServiceGraphOutput) SetStartTime(v time.Time) *GetServiceGraphOutput {
	s.StartTime = &v
	return s
}

type GetTraceGraphInput struct {
	_ struct{} `type:"structure"`

	// Pagination token. Not used.
	NextToken *string `type:"string"`

	// Trace IDs of requests for which to generate a service graph.
	//
	// TraceIds is a required field
	TraceIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetTraceGraphInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTraceGraphInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTraceGraphInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTraceGraphInput"}
	if s.TraceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("TraceIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *GetTraceGraphInput) SetNextToken(v string) *GetTraceGraphInput {
	s.NextToken = &v
	return s
}

// SetTraceIds sets the TraceIds field's value.
func (s *GetTraceGraphInput) SetTraceIds(v []*string) *GetTraceGraphInput {
	s.TraceIds = v
	return s
}

type GetTraceGraphOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token. Not used.
	NextToken *string `type:"string"`

	// The services that have processed one of the specified requests.
	Services []*Service `type:"list"`
}

// String returns the string representation
func (s GetTraceGraphOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTraceGraphOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetTraceGraphOutput) SetNextToken(v string) *GetTraceGraphOutput {
	s.NextToken = &v
	return s
}

// SetServices sets the Services field's value.
func (s *GetTraceGraphOutput) SetServices(v []*Service) *GetTraceGraphOutput {
	s.Services = v
	return s
}

type GetTraceSummariesInput struct {
	_ struct{} `type:"structure"`

	// The end of the time frame for which to retrieve traces.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// Specify a filter expression to retrieve trace summaries for services or requests
	// that meet certain requirements.
	FilterExpression *string `min:"1" type:"string"`

	// Specify the pagination token returned by a previous request to retrieve the
	// next page of results.
	NextToken *string `type:"string"`

	// Set to true to get summaries for only a subset of available traces.
	Sampling *bool `type:"boolean"`

	// The start of the time frame for which to retrieve traces.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s GetTraceSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTraceSummariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTraceSummariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTraceSummariesInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.FilterExpression != nil && len(*s.FilterExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterExpression", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetTraceSummariesInput) SetEndTime(v time.Time) *GetTraceSummariesInput {
	s.EndTime = &v
	return s
}

// SetFilterExpression sets the FilterExpression field's value.
func (s *GetTraceSummariesInput) SetFilterExpression(v string) *GetTraceSummariesInput {
	s.FilterExpression = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetTraceSummariesInput) SetNextToken(v string) *GetTraceSummariesInput {
	s.NextToken = &v
	return s
}

// SetSampling sets the Sampling field's value.
func (s *GetTraceSummariesInput) SetSampling(v bool) *GetTraceSummariesInput {
	s.Sampling = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetTraceSummariesInput) SetStartTime(v time.Time) *GetTraceSummariesInput {
	s.StartTime = &v
	return s
}

type GetTraceSummariesOutput struct {
	_ struct{} `type:"structure"`

	// The start time of this page of results.
	ApproximateTime *time.Time `type:"timestamp"`

	// If the requested time frame contained more than one page of results, you
	// can use this token to retrieve the next page. The first page contains the
	// most most recent results, closest to the end of the time frame.
	NextToken *string `type:"string"`

	// Trace IDs and metadata for traces that were found in the specified time frame.
	TraceSummaries []*TraceSummary `type:"list"`

	// The total number of traces processed, including traces that did not match
	// the specified filter expression.
	TracesProcessedCount *int64 `type:"long"`
}

// String returns the string representation
func (s GetTraceSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTraceSummariesOutput) GoString() string {
	return s.String()
}

// SetApproximateTime sets the ApproximateTime field's value.
func (s *GetTraceSummariesOutput) SetApproximateTime(v time.Time) *GetTraceSummariesOutput {
	s.ApproximateTime = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetTraceSummariesOutput) SetNextToken(v string) *GetTraceSummariesOutput {
	s.NextToken = &v
	return s
}

// SetTraceSummaries sets the TraceSummaries field's value.
func (s *GetTraceSummariesOutput) SetTraceSummaries(v []*TraceSummary) *GetTraceSummariesOutput {
	s.TraceSummaries = v
	return s
}

// SetTracesProcessedCount sets the TracesProcessedCount field's value.
func (s *GetTraceSummariesOutput) SetTracesProcessedCount(v int64) *GetTraceSummariesOutput {
	s.TracesProcessedCount = &v
	return s
}

// An entry in a histogram for a statistic. A histogram maps the range of observed
// values on the X axis, and the prevalence of each value on the Y axis.
type HistogramEntry struct {
	_ struct{} `type:"structure"`

	// The prevalence of the entry.
	Count *int64 `type:"integer"`

	// The value of the entry.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s HistogramEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HistogramEntry) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *HistogramEntry) SetCount(v int64) *HistogramEntry {
	s.Count = &v
	return s
}

// SetValue sets the Value field's value.
func (s *HistogramEntry) SetValue(v float64) *HistogramEntry {
	s.Value = &v
	return s
}

// Information about an HTTP request.
type Http struct {
	_ struct{} `type:"structure"`

	// The IP address of the requestor.
	ClientIp *string `type:"string"`

	// The request method.
	HttpMethod *string `type:"string"`

	// The response status.
	HttpStatus *int64 `type:"integer"`

	// The request URL.
	HttpURL *string `type:"string"`

	// The request's user agent string.
	UserAgent *string `type:"string"`
}

// String returns the string representation
func (s Http) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Http) GoString() string {
	return s.String()
}

// SetClientIp sets the ClientIp field's value.
func (s *Http) SetClientIp(v string) *Http {
	s.ClientIp = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *Http) SetHttpMethod(v string) *Http {
	s.HttpMethod = &v
	return s
}

// SetHttpStatus sets the HttpStatus field's value.
func (s *Http) SetHttpStatus(v int64) *Http {
	s.HttpStatus = &v
	return s
}

// SetHttpURL sets the HttpURL field's value.
func (s *Http) SetHttpURL(v string) *Http {
	s.HttpURL = &v
	return s
}

// SetUserAgent sets the UserAgent field's value.
func (s *Http) SetUserAgent(v string) *Http {
	s.UserAgent = &v
	return s
}

type PutEncryptionConfigInput struct {
	_ struct{} `type:"structure"`

	// An AWS KMS customer master key (CMK) in one of the following formats:
	//
	//    * Alias - The name of the key. For example, alias/MyKey.
	//
	//    * Key ID - The KMS key ID of the key. For example, ae4aa6d49-a4d8-9df9-a475-4ff6d7898456.
	//
	//    * ARN - The full Amazon Resource Name of the key ID or alias. For example,
	//    arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456.
	//    Use this format to specify a key in a different account.
	//
	// Omit this key if you set Type to NONE.
	KeyId *string `min:"1" type:"string"`

	// The type of encryption. Set to KMS to use your own key for encryption. Set
	// to NONE for default encryption.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"EncryptionType"`
}

// String returns the string representation
func (s PutEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEncryptionConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEncryptionConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEncryptionConfigInput"}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *PutEncryptionConfigInput) SetKeyId(v string) *PutEncryptionConfigInput {
	s.KeyId = &v
	return s
}

// SetType sets the Type field's value.
func (s *PutEncryptionConfigInput) SetType(v string) *PutEncryptionConfigInput {
	s.Type = &v
	return s
}

type PutEncryptionConfigOutput struct {
	_ struct{} `type:"structure"`

	// The new encryption configuration.
	EncryptionConfig *EncryptionConfig `type:"structure"`
}

// String returns the string representation
func (s PutEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEncryptionConfigOutput) GoString() string {
	return s.String()
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *PutEncryptionConfigOutput) SetEncryptionConfig(v *EncryptionConfig) *PutEncryptionConfigOutput {
	s.EncryptionConfig = v
	return s
}

type PutTelemetryRecordsInput struct {
	_ struct{} `type:"structure"`

	EC2InstanceId *string `type:"string"`

	Hostname *string `type:"string"`

	ResourceARN *string `type:"string"`

	// TelemetryRecords is a required field
	TelemetryRecords []*TelemetryRecord `type:"list" required:"true"`
}

// String returns the string representation
func (s PutTelemetryRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTelemetryRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutTelemetryRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutTelemetryRecordsInput"}
	if s.TelemetryRecords == nil {
		invalidParams.Add(request.NewErrParamRequired("TelemetryRecords"))
	}
	if s.TelemetryRecords != nil {
		for i, v := range s.TelemetryRecords {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TelemetryRecords", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEC2InstanceId sets the EC2InstanceId field's value.
func (s *PutTelemetryRecordsInput) SetEC2InstanceId(v string) *PutTelemetryRecordsInput {
	s.EC2InstanceId = &v
	return s
}

// SetHostname sets the Hostname field's value.
func (s *PutTelemetryRecordsInput) SetHostname(v string) *PutTelemetryRecordsInput {
	s.Hostname = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *PutTelemetryRecordsInput) SetResourceARN(v string) *PutTelemetryRecordsInput {
	s.ResourceARN = &v
	return s
}

// SetTelemetryRecords sets the TelemetryRecords field's value.
func (s *PutTelemetryRecordsInput) SetTelemetryRecords(v []*TelemetryRecord) *PutTelemetryRecordsInput {
	s.TelemetryRecords = v
	return s
}

type PutTelemetryRecordsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutTelemetryRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTelemetryRecordsOutput) GoString() string {
	return s.String()
}

type PutTraceSegmentsInput struct {
	_ struct{} `type:"structure"`

	// A string containing a JSON document defining one or more segments or subsegments.
	//
	// TraceSegmentDocuments is a required field
	TraceSegmentDocuments []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s PutTraceSegmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTraceSegmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutTraceSegmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutTraceSegmentsInput"}
	if s.TraceSegmentDocuments == nil {
		invalidParams.Add(request.NewErrParamRequired("TraceSegmentDocuments"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTraceSegmentDocuments sets the TraceSegmentDocuments field's value.
func (s *PutTraceSegmentsInput) SetTraceSegmentDocuments(v []*string) *PutTraceSegmentsInput {
	s.TraceSegmentDocuments = v
	return s
}

type PutTraceSegmentsOutput struct {
	_ struct{} `type:"structure"`

	// Segments that failed processing.
	UnprocessedTraceSegments []*UnprocessedTraceSegment `type:"list"`
}

// String returns the string representation
func (s PutTraceSegmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTraceSegmentsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedTraceSegments sets the UnprocessedTraceSegments field's value.
func (s *PutTraceSegmentsOutput) SetUnprocessedTraceSegments(v []*UnprocessedTraceSegment) *PutTraceSegmentsOutput {
	s.UnprocessedTraceSegments = v
	return s
}

// A segment from a trace that has been ingested by the X-Ray service. The segment
// can be compiled from documents uploaded with PutTraceSegments, or an inferred
// segment for a downstream service, generated from a subsegment sent by the
// service that called it.
//
// For the full segment document schema, see AWS X-Ray Segment Documents (https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html)
// in the AWS X-Ray Developer Guide.
type Segment struct {
	_ struct{} `type:"structure"`

	// The segment document.
	Document *string `min:"1" type:"string"`

	// The segment's ID.
	Id *string `type:"string"`
}

// String returns the string representation
func (s Segment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Segment) GoString() string {
	return s.String()
}

// SetDocument sets the Document field's value.
func (s *Segment) SetDocument(v string) *Segment {
	s.Document = &v
	return s
}

// SetId sets the Id field's value.
func (s *Segment) SetId(v string) *Segment {
	s.Id = &v
	return s
}

// Information about an application that processed requests, users that made
// requests, or downstream services, resources and applications that an application
// used.
type Service struct {
	_ struct{} `type:"structure"`

	// Identifier of the AWS account in which the service runs.
	AccountId *string `type:"string"`

	// A histogram that maps the spread of service durations.
	DurationHistogram []*HistogramEntry `type:"list"`

	// Connections to downstream services.
	Edges []*Edge `type:"list"`

	// The end time of the last segment that the service generated.
	EndTime *time.Time `type:"timestamp"`

	// The canonical name of the service.
	Name *string `type:"string"`

	// A list of names for the service, including the canonical name.
	Names []*string `type:"list"`

	// Identifier for the service. Unique within the service map.
	ReferenceId *int64 `type:"integer"`

	// A histogram that maps the spread of service response times.
	ResponseTimeHistogram []*HistogramEntry `type:"list"`

	// Indicates that the service was the first service to process a request.
	Root *bool `type:"boolean"`

	// The start time of the first segment that the service generated.
	StartTime *time.Time `type:"timestamp"`

	// The service's state.
	State *string `type:"string"`

	// Aggregated statistics for the service.
	SummaryStatistics *ServiceStatistics `type:"structure"`

	// The type of service.
	//
	//    * AWS Resource - The type of an AWS resource. For example, AWS::EC2::Instance
	//    for a application running on Amazon EC2 or AWS::DynamoDB::Table for an
	//    Amazon DynamoDB table that the application used.
	//
	//    * AWS Service - The type of an AWS service. For example, AWS::DynamoDB
	//    for downstream calls to Amazon DynamoDB that didn't target a specific
	//    table.
	//
	//    * client - Represents the clients that sent requests to a root service.
	//
	//    * remote - A downstream service of indeterminate type.
	Type *string `type:"string"`
}

// String returns the string representation
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Service) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Service) SetAccountId(v string) *Service {
	s.AccountId = &v
	return s
}

// SetDurationHistogram sets the DurationHistogram field's value.
func (s *Service) SetDurationHistogram(v []*HistogramEntry) *Service {
	s.DurationHistogram = v
	return s
}

// SetEdges sets the Edges field's value.
func (s *Service) SetEdges(v []*Edge) *Service {
	s.Edges = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Service) SetEndTime(v time.Time) *Service {
	s.EndTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Service) SetName(v string) *Service {
	s.Name = &v
	return s
}

// SetNames sets the Names field's value.
func (s *Service) SetNames(v []*string) *Service {
	s.Names = v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *Service) SetReferenceId(v int64) *Service {
	s.ReferenceId = &v
	return s
}

// SetResponseTimeHistogram sets the ResponseTimeHistogram field's value.
func (s *Service) SetResponseTimeHistogram(v []*HistogramEntry) *Service {
	s.ResponseTimeHistogram = v
	return s
}

// SetRoot sets the Root field's value.
func (s *Service) SetRoot(v bool) *Service {
	s.Root = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Service) SetStartTime(v time.Time) *Service {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *Service) SetState(v string) *Service {
	s.State = &v
	return s
}

// SetSummaryStatistics sets the SummaryStatistics field's value.
func (s *Service) SetSummaryStatistics(v *ServiceStatistics) *Service {
	s.SummaryStatistics = v
	return s
}

// SetType sets the Type field's value.
func (s *Service) SetType(v string) *Service {
	s.Type = &v
	return s
}

type ServiceId struct {
	_ struct{} `type:"structure"`

	AccountId *string `type:"string"`

	Name *string `type:"string"`

	Names []*string `type:"list"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s ServiceId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceId) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ServiceId) SetAccountId(v string) *ServiceId {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceId) SetName(v string) *ServiceId {
	s.Name = &v
	return s
}

// SetNames sets the Names field's value.
func (s *ServiceId) SetNames(v []*string) *ServiceId {
	s.Names = v
	return s
}

// SetType sets the Type field's value.
func (s *ServiceId) SetType(v string) *ServiceId {
	s.Type = &v
	return s
}

// Response statistics for a service.
type ServiceStatistics struct {
	_ struct{} `type:"structure"`

	// Information about requests that failed with a 4xx Client Error status code.
	ErrorStatistics *ErrorStatistics `type:"structure"`

	// Information about requests that failed with a 5xx Server Error status code.
	FaultStatistics *FaultStatistics `type:"structure"`

	// The number of requests that completed with a 2xx Success status code.
	OkCount *int64 `type:"long"`

	// The total number of completed requests.
	TotalCount *int64 `type:"long"`

	// The aggregate response time of completed requests.
	TotalResponseTime *float64 `type:"double"`
}

// String returns the string representation
func (s ServiceStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceStatistics) GoString() string {
	return s.String()
}

// SetErrorStatistics sets the ErrorStatistics field's value.
func (s *ServiceStatistics) SetErrorStatistics(v *ErrorStatistics) *ServiceStatistics {
	s.ErrorStatistics = v
	return s
}

// SetFaultStatistics sets the FaultStatistics field's value.
func (s *ServiceStatistics) SetFaultStatistics(v *FaultStatistics) *ServiceStatistics {
	s.FaultStatistics = v
	return s
}

// SetOkCount sets the OkCount field's value.
func (s *ServiceStatistics) SetOkCount(v int64) *ServiceStatistics {
	s.OkCount = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ServiceStatistics) SetTotalCount(v int64) *ServiceStatistics {
	s.TotalCount = &v
	return s
}

// SetTotalResponseTime sets the TotalResponseTime field's value.
func (s *ServiceStatistics) SetTotalResponseTime(v float64) *ServiceStatistics {
	s.TotalResponseTime = &v
	return s
}

type TelemetryRecord struct {
	_ struct{} `type:"structure"`

	BackendConnectionErrors *BackendConnectionErrors `type:"structure"`

	SegmentsReceivedCount *int64 `type:"integer"`

	SegmentsRejectedCount *int64 `type:"integer"`

	SegmentsSentCount *int64 `type:"integer"`

	SegmentsSpilloverCount *int64 `type:"integer"`

	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s TelemetryRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TelemetryRecord) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TelemetryRecord) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TelemetryRecord"}
	if s.Timestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("Timestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackendConnectionErrors sets the BackendConnectionErrors field's value.
func (s *TelemetryRecord) SetBackendConnectionErrors(v *BackendConnectionErrors) *TelemetryRecord {
	s.BackendConnectionErrors = v
	return s
}

// SetSegmentsReceivedCount sets the SegmentsReceivedCount field's value.
func (s *TelemetryRecord) SetSegmentsReceivedCount(v int64) *TelemetryRecord {
	s.SegmentsReceivedCount = &v
	return s
}

// SetSegmentsRejectedCount sets the SegmentsRejectedCount field's value.
func (s *TelemetryRecord) SetSegmentsRejectedCount(v int64) *TelemetryRecord {
	s.SegmentsRejectedCount = &v
	return s
}

// SetSegmentsSentCount sets the SegmentsSentCount field's value.
func (s *TelemetryRecord) SetSegmentsSentCount(v int64) *TelemetryRecord {
	s.SegmentsSentCount = &v
	return s
}

// SetSegmentsSpilloverCount sets the SegmentsSpilloverCount field's value.
func (s *TelemetryRecord) SetSegmentsSpilloverCount(v int64) *TelemetryRecord {
	s.SegmentsSpilloverCount = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *TelemetryRecord) SetTimestamp(v time.Time) *TelemetryRecord {
	s.Timestamp = &v
	return s
}

// A collection of segment documents with matching trace IDs.
type Trace struct {
	_ struct{} `type:"structure"`

	// The length of time in seconds between the start time of the root segment
	// and the end time of the last segment that completed.
	Duration *float64 `type:"double"`

	// The unique identifier for the request that generated the trace's segments
	// and subsegments.
	Id *string `min:"1" type:"string"`

	// Segment documents for the segments and subsegments that comprise the trace.
	Segments []*Segment `type:"list"`
}

// String returns the string representation
func (s Trace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Trace) GoString() string {
	return s.String()
}

// SetDuration sets the Duration field's value.
func (s *Trace) SetDuration(v float64) *Trace {
	s.Duration = &v
	return s
}

// SetId sets the Id field's value.
func (s *Trace) SetId(v string) *Trace {
	s.Id = &v
	return s
}

// SetSegments sets the Segments field's value.
func (s *Trace) SetSegments(v []*Segment) *Trace {
	s.Segments = v
	return s
}

// Metadata generated from the segment documents in a trace.
type TraceSummary struct {
	_ struct{} `type:"structure"`

	// Annotations from the trace's segment documents.
	Annotations map[string][]*ValueWithServiceIds `type:"map"`

	// The length of time in seconds between the start time of the root segment
	// and the end time of the last segment that completed.
	Duration *float64 `type:"double"`

	// One or more of the segment documents has a 400 series error.
	HasError *bool `type:"boolean"`

	// One or more of the segment documents has a 500 series error.
	HasFault *bool `type:"boolean"`

	// One or more of the segment documents has a 429 throttling error.
	HasThrottle *bool `type:"boolean"`

	// Information about the HTTP request served by the trace.
	Http *Http `type:"structure"`

	// The unique identifier for the request that generated the trace's segments
	// and subsegments.
	Id *string `min:"1" type:"string"`

	// One or more of the segment documents is in progress.
	IsPartial *bool `type:"boolean"`

	// The length of time in seconds between the start and end times of the root
	// segment. If the service performs work asynchronously, the response time measures
	// the time before the response is sent to the user, while the duration measures
	// the amount of time before the last traced activity completes.
	ResponseTime *float64 `type:"double"`

	// Service IDs from the trace's segment documents.
	ServiceIds []*ServiceId `type:"list"`

	// Users from the trace's segment documents.
	Users []*TraceUser `type:"list"`
}

// String returns the string representation
func (s TraceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TraceSummary) GoString() string {
	return s.String()
}

// SetAnnotations sets the Annotations field's value.
func (s *TraceSummary) SetAnnotations(v map[string][]*ValueWithServiceIds) *TraceSummary {
	s.Annotations = v
	return s
}

// SetDuration sets the Duration field's value.
func (s *TraceSummary) SetDuration(v float64) *TraceSummary {
	s.Duration = &v
	return s
}

// SetHasError sets the HasError field's value.
func (s *TraceSummary) SetHasError(v bool) *TraceSummary {
	s.HasError = &v
	return s
}

// SetHasFault sets the HasFault field's value.
func (s *TraceSummary) SetHasFault(v bool) *TraceSummary {
	s.HasFault = &v
	return s
}

// SetHasThrottle sets the HasThrottle field's value.
func (s *TraceSummary) SetHasThrottle(v bool) *TraceSummary {
	s.HasThrottle = &v
	return s
}

// SetHttp sets the Http field's value.
func (s *TraceSummary) SetHttp(v *Http) *TraceSummary {
	s.Http = v
	return s
}

// SetId sets the Id field's value.
func (s *TraceSummary) SetId(v string) *TraceSummary {
	s.Id = &v
	return s
}

// SetIsPartial sets the IsPartial field's value.
func (s *TraceSummary) SetIsPartial(v bool) *TraceSummary {
	s.IsPartial = &v
	return s
}

// SetResponseTime sets the ResponseTime field's value.
func (s *TraceSummary) SetResponseTime(v float64) *TraceSummary {
	s.ResponseTime = &v
	return s
}

// SetServiceIds sets the ServiceIds field's value.
func (s *TraceSummary) SetServiceIds(v []*ServiceId) *TraceSummary {
	s.ServiceIds = v
	return s
}

// SetUsers sets the Users field's value.
func (s *TraceSummary) SetUsers(v []*TraceUser) *TraceSummary {
	s.Users = v
	return s
}

// Information about a user recorded in segment documents.
type TraceUser struct {
	_ struct{} `type:"structure"`

	// Services that the user's request hit.
	ServiceIds []*ServiceId `type:"list"`

	// The user's name.
	UserName *string `type:"string"`
}

// String returns the string representation
func (s TraceUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TraceUser) GoString() string {
	return s.String()
}

// SetServiceIds sets the ServiceIds field's value.
func (s *TraceUser) SetServiceIds(v []*ServiceId) *TraceUser {
	s.ServiceIds = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *TraceUser) SetUserName(v string) *TraceUser {
	s.UserName = &v
	return s
}

// Information about a segment that failed processing.
type UnprocessedTraceSegment struct {
	_ struct{} `type:"structure"`

	// The error that caused processing to fail.
	ErrorCode *string `type:"string"`

	// The segment's ID.
	Id *string `type:"string"`

	// The error message.
	Message *string `type:"string"`
}

// String returns the string representation
func (s UnprocessedTraceSegment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessedTraceSegment) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UnprocessedTraceSegment) SetErrorCode(v string) *UnprocessedTraceSegment {
	s.ErrorCode = &v
	return s
}

// SetId sets the Id field's value.
func (s *UnprocessedTraceSegment) SetId(v string) *UnprocessedTraceSegment {
	s.Id = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *UnprocessedTraceSegment) SetMessage(v string) *UnprocessedTraceSegment {
	s.Message = &v
	return s
}

// Information about a segment annotation.
type ValueWithServiceIds struct {
	_ struct{} `type:"structure"`

	// Values of the annotation.
	AnnotationValue *AnnotationValue `type:"structure"`

	// Services to which the annotation applies.
	ServiceIds []*ServiceId `type:"list"`
}

// String returns the string representation
func (s ValueWithServiceIds) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValueWithServiceIds) GoString() string {
	return s.String()
}

// SetAnnotationValue sets the AnnotationValue field's value.
func (s *ValueWithServiceIds) SetAnnotationValue(v *AnnotationValue) *ValueWithServiceIds {
	s.AnnotationValue = v
	return s
}

// SetServiceIds sets the ServiceIds field's value.
func (s *ValueWithServiceIds) SetServiceIds(v []*ServiceId) *ValueWithServiceIds {
	s.ServiceIds = v
	return s
}

const (
	// EncryptionStatusUpdating is a EncryptionStatus enum value
	EncryptionStatusUpdating = "UPDATING"

	// EncryptionStatusActive is a EncryptionStatus enum value
	EncryptionStatusActive = "ACTIVE"
)

const (
	// EncryptionTypeNone is a EncryptionType enum value
	EncryptionTypeNone = "NONE"

	// EncryptionTypeKms is a EncryptionType enum value
	EncryptionTypeKms = "KMS"
)
