// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationdiscoveryservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAssociateConfigurationItemsToApplication = "AssociateConfigurationItemsToApplication"

// AssociateConfigurationItemsToApplicationRequest generates a "aws/request.Request" representing the
// client's request for the AssociateConfigurationItemsToApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateConfigurationItemsToApplication for more information on using the AssociateConfigurationItemsToApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateConfigurationItemsToApplicationRequest method.
//    req, resp := client.AssociateConfigurationItemsToApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/AssociateConfigurationItemsToApplication
func (c *ApplicationDiscoveryService) AssociateConfigurationItemsToApplicationRequest(input *AssociateConfigurationItemsToApplicationInput) (req *request.Request, output *AssociateConfigurationItemsToApplicationOutput) {
	op := &request.Operation{
		Name:       opAssociateConfigurationItemsToApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateConfigurationItemsToApplicationInput{}
	}

	output = &AssociateConfigurationItemsToApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateConfigurationItemsToApplication API operation for AWS Application Discovery Service.
//
// Associates one or more configuration items with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation AssociateConfigurationItemsToApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/AssociateConfigurationItemsToApplication
func (c *ApplicationDiscoveryService) AssociateConfigurationItemsToApplication(input *AssociateConfigurationItemsToApplicationInput) (*AssociateConfigurationItemsToApplicationOutput, error) {
	req, out := c.AssociateConfigurationItemsToApplicationRequest(input)
	return out, req.Send()
}

// AssociateConfigurationItemsToApplicationWithContext is the same as AssociateConfigurationItemsToApplication with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateConfigurationItemsToApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) AssociateConfigurationItemsToApplicationWithContext(ctx aws.Context, input *AssociateConfigurationItemsToApplicationInput, opts ...request.Option) (*AssociateConfigurationItemsToApplicationOutput, error) {
	req, out := c.AssociateConfigurationItemsToApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationRequest method.
//    req, resp := client.CreateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/CreateApplication
func (c *ApplicationDiscoveryService) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for AWS Application Discovery Service.
//
// Creates an application with the given name and description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation CreateApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/CreateApplication
func (c *ApplicationDiscoveryService) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTags for more information on using the CreateTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTagsRequest method.
//    req, resp := client.CreateTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/CreateTags
func (c *ApplicationDiscoveryService) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	output = &CreateTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTags API operation for AWS Application Discovery Service.
//
// Creates one or more tags for configuration items. Tags are metadata that
// help you categorize IT assets. This API accepts a list of multiple configuration
// items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation CreateTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/CreateTags
func (c *ApplicationDiscoveryService) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	return out, req.Send()
}

// CreateTagsWithContext is the same as CreateTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) CreateTagsWithContext(ctx aws.Context, input *CreateTagsInput, opts ...request.Option) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplications = "DeleteApplications"

// DeleteApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplications for more information on using the DeleteApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationsRequest method.
//    req, resp := client.DeleteApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DeleteApplications
func (c *ApplicationDiscoveryService) DeleteApplicationsRequest(input *DeleteApplicationsInput) (req *request.Request, output *DeleteApplicationsOutput) {
	op := &request.Operation{
		Name:       opDeleteApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationsInput{}
	}

	output = &DeleteApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApplications API operation for AWS Application Discovery Service.
//
// Deletes a list of applications and their associations with configuration
// items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DeleteApplications for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DeleteApplications
func (c *ApplicationDiscoveryService) DeleteApplications(input *DeleteApplicationsInput) (*DeleteApplicationsOutput, error) {
	req, out := c.DeleteApplicationsRequest(input)
	return out, req.Send()
}

// DeleteApplicationsWithContext is the same as DeleteApplications with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DeleteApplicationsWithContext(ctx aws.Context, input *DeleteApplicationsInput, opts ...request.Option) (*DeleteApplicationsOutput, error) {
	req, out := c.DeleteApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DeleteTags
func (c *ApplicationDiscoveryService) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTags API operation for AWS Application Discovery Service.
//
// Deletes the association between configuration items and one or more tags.
// This API accepts a list of multiple configuration items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DeleteTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DeleteTags
func (c *ApplicationDiscoveryService) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAgents = "DescribeAgents"

// DescribeAgentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAgents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAgents for more information on using the DescribeAgents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAgentsRequest method.
//    req, resp := client.DescribeAgentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeAgents
func (c *ApplicationDiscoveryService) DescribeAgentsRequest(input *DescribeAgentsInput) (req *request.Request, output *DescribeAgentsOutput) {
	op := &request.Operation{
		Name:       opDescribeAgents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAgentsInput{}
	}

	output = &DescribeAgentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAgents API operation for AWS Application Discovery Service.
//
// Lists agents or the Connector by ID or lists all agents/Connectors associated
// with your user account if you did not specify an ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DescribeAgents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeAgents
func (c *ApplicationDiscoveryService) DescribeAgents(input *DescribeAgentsInput) (*DescribeAgentsOutput, error) {
	req, out := c.DescribeAgentsRequest(input)
	return out, req.Send()
}

// DescribeAgentsWithContext is the same as DescribeAgents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAgents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DescribeAgentsWithContext(ctx aws.Context, input *DescribeAgentsInput, opts ...request.Option) (*DescribeAgentsOutput, error) {
	req, out := c.DescribeAgentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurations = "DescribeConfigurations"

// DescribeConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurations for more information on using the DescribeConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationsRequest method.
//    req, resp := client.DescribeConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeConfigurations
func (c *ApplicationDiscoveryService) DescribeConfigurationsRequest(input *DescribeConfigurationsInput) (req *request.Request, output *DescribeConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationsInput{}
	}

	output = &DescribeConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurations API operation for AWS Application Discovery Service.
//
// Retrieves attributes for a list of configuration item IDs. All of the supplied
// IDs must be for the same asset type (server, application, process, or connection).
// Output fields are specific to the asset type selected. For example, the output
// for a server configuration item includes a list of attributes about the server,
// such as host name, operating system, and number of network cards.
//
// For a complete list of outputs for each asset type, see Using the DescribeConfigurations
// Action (http://docs.aws.amazon.com/application-discovery/latest/APIReference/discovery-api-queries.html#DescribeConfigurations).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DescribeConfigurations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeConfigurations
func (c *ApplicationDiscoveryService) DescribeConfigurations(input *DescribeConfigurationsInput) (*DescribeConfigurationsOutput, error) {
	req, out := c.DescribeConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeConfigurationsWithContext is the same as DescribeConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DescribeConfigurationsWithContext(ctx aws.Context, input *DescribeConfigurationsInput, opts ...request.Option) (*DescribeConfigurationsOutput, error) {
	req, out := c.DescribeConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeExportConfigurations = "DescribeExportConfigurations"

// DescribeExportConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExportConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExportConfigurations for more information on using the DescribeExportConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeExportConfigurationsRequest method.
//    req, resp := client.DescribeExportConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeExportConfigurations
func (c *ApplicationDiscoveryService) DescribeExportConfigurationsRequest(input *DescribeExportConfigurationsInput) (req *request.Request, output *DescribeExportConfigurationsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeExportConfigurations, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeExportConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExportConfigurationsInput{}
	}

	output = &DescribeExportConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExportConfigurations API operation for AWS Application Discovery Service.
//
// Deprecated. Use DescribeExportTasks instead.
//
// Retrieves the status of a given export process. You can retrieve status from
// a maximum of 100 processes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DescribeExportConfigurations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeExportConfigurations
func (c *ApplicationDiscoveryService) DescribeExportConfigurations(input *DescribeExportConfigurationsInput) (*DescribeExportConfigurationsOutput, error) {
	req, out := c.DescribeExportConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeExportConfigurationsWithContext is the same as DescribeExportConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExportConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DescribeExportConfigurationsWithContext(ctx aws.Context, input *DescribeExportConfigurationsInput, opts ...request.Option) (*DescribeExportConfigurationsOutput, error) {
	req, out := c.DescribeExportConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeExportTasks = "DescribeExportTasks"

// DescribeExportTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExportTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExportTasks for more information on using the DescribeExportTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeExportTasksRequest method.
//    req, resp := client.DescribeExportTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeExportTasks
func (c *ApplicationDiscoveryService) DescribeExportTasksRequest(input *DescribeExportTasksInput) (req *request.Request, output *DescribeExportTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeExportTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExportTasksInput{}
	}

	output = &DescribeExportTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExportTasks API operation for AWS Application Discovery Service.
//
// Retrieve status of one or more export tasks. You can retrieve the status
// of up to 100 export tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DescribeExportTasks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeExportTasks
func (c *ApplicationDiscoveryService) DescribeExportTasks(input *DescribeExportTasksInput) (*DescribeExportTasksOutput, error) {
	req, out := c.DescribeExportTasksRequest(input)
	return out, req.Send()
}

// DescribeExportTasksWithContext is the same as DescribeExportTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExportTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DescribeExportTasksWithContext(ctx aws.Context, input *DescribeExportTasksInput, opts ...request.Option) (*DescribeExportTasksOutput, error) {
	req, out := c.DescribeExportTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTags for more information on using the DescribeTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeTags
func (c *ApplicationDiscoveryService) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	output = &DescribeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTags API operation for AWS Application Discovery Service.
//
// Retrieves a list of configuration items that are tagged with a specific tag.
// Or retrieves a list of all tags assigned to a specific configuration item.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DescribeTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeTags
func (c *ApplicationDiscoveryService) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	return out, req.Send()
}

// DescribeTagsWithContext is the same as DescribeTags with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DescribeTagsWithContext(ctx aws.Context, input *DescribeTagsInput, opts ...request.Option) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateConfigurationItemsFromApplication = "DisassociateConfigurationItemsFromApplication"

// DisassociateConfigurationItemsFromApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateConfigurationItemsFromApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateConfigurationItemsFromApplication for more information on using the DisassociateConfigurationItemsFromApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateConfigurationItemsFromApplicationRequest method.
//    req, resp := client.DisassociateConfigurationItemsFromApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DisassociateConfigurationItemsFromApplication
func (c *ApplicationDiscoveryService) DisassociateConfigurationItemsFromApplicationRequest(input *DisassociateConfigurationItemsFromApplicationInput) (req *request.Request, output *DisassociateConfigurationItemsFromApplicationOutput) {
	op := &request.Operation{
		Name:       opDisassociateConfigurationItemsFromApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateConfigurationItemsFromApplicationInput{}
	}

	output = &DisassociateConfigurationItemsFromApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateConfigurationItemsFromApplication API operation for AWS Application Discovery Service.
//
// Disassociates one or more configuration items from an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DisassociateConfigurationItemsFromApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DisassociateConfigurationItemsFromApplication
func (c *ApplicationDiscoveryService) DisassociateConfigurationItemsFromApplication(input *DisassociateConfigurationItemsFromApplicationInput) (*DisassociateConfigurationItemsFromApplicationOutput, error) {
	req, out := c.DisassociateConfigurationItemsFromApplicationRequest(input)
	return out, req.Send()
}

// DisassociateConfigurationItemsFromApplicationWithContext is the same as DisassociateConfigurationItemsFromApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateConfigurationItemsFromApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DisassociateConfigurationItemsFromApplicationWithContext(ctx aws.Context, input *DisassociateConfigurationItemsFromApplicationInput, opts ...request.Option) (*DisassociateConfigurationItemsFromApplicationOutput, error) {
	req, out := c.DisassociateConfigurationItemsFromApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportConfigurations = "ExportConfigurations"

// ExportConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ExportConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportConfigurations for more information on using the ExportConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExportConfigurationsRequest method.
//    req, resp := client.ExportConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/ExportConfigurations
func (c *ApplicationDiscoveryService) ExportConfigurationsRequest(input *ExportConfigurationsInput) (req *request.Request, output *ExportConfigurationsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ExportConfigurations, has been deprecated")
	}
	op := &request.Operation{
		Name:       opExportConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExportConfigurationsInput{}
	}

	output = &ExportConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportConfigurations API operation for AWS Application Discovery Service.
//
// Deprecated. Use StartExportTask instead.
//
// Exports all discovered configuration data to an Amazon S3 bucket or an application
// that enables you to view and evaluate the data. Data includes tags and tag
// associations, processes, connections, servers, and system performance. This
// API returns an export ID that you can query using the DescribeExportConfigurations
// API. The system imposes a limit of two configuration exports in six hours.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation ExportConfigurations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   This operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/ExportConfigurations
func (c *ApplicationDiscoveryService) ExportConfigurations(input *ExportConfigurationsInput) (*ExportConfigurationsOutput, error) {
	req, out := c.ExportConfigurationsRequest(input)
	return out, req.Send()
}

// ExportConfigurationsWithContext is the same as ExportConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ExportConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) ExportConfigurationsWithContext(ctx aws.Context, input *ExportConfigurationsInput, opts ...request.Option) (*ExportConfigurationsOutput, error) {
	req, out := c.ExportConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDiscoverySummary = "GetDiscoverySummary"

// GetDiscoverySummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetDiscoverySummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDiscoverySummary for more information on using the GetDiscoverySummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDiscoverySummaryRequest method.
//    req, resp := client.GetDiscoverySummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/GetDiscoverySummary
func (c *ApplicationDiscoveryService) GetDiscoverySummaryRequest(input *GetDiscoverySummaryInput) (req *request.Request, output *GetDiscoverySummaryOutput) {
	op := &request.Operation{
		Name:       opGetDiscoverySummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDiscoverySummaryInput{}
	}

	output = &GetDiscoverySummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDiscoverySummary API operation for AWS Application Discovery Service.
//
// Retrieves a short summary of discovered assets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation GetDiscoverySummary for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/GetDiscoverySummary
func (c *ApplicationDiscoveryService) GetDiscoverySummary(input *GetDiscoverySummaryInput) (*GetDiscoverySummaryOutput, error) {
	req, out := c.GetDiscoverySummaryRequest(input)
	return out, req.Send()
}

// GetDiscoverySummaryWithContext is the same as GetDiscoverySummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetDiscoverySummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) GetDiscoverySummaryWithContext(ctx aws.Context, input *GetDiscoverySummaryInput, opts ...request.Option) (*GetDiscoverySummaryOutput, error) {
	req, out := c.GetDiscoverySummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListConfigurations = "ListConfigurations"

// ListConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfigurations for more information on using the ListConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConfigurationsRequest method.
//    req, resp := client.ListConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/ListConfigurations
func (c *ApplicationDiscoveryService) ListConfigurationsRequest(input *ListConfigurationsInput) (req *request.Request, output *ListConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListConfigurationsInput{}
	}

	output = &ListConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfigurations API operation for AWS Application Discovery Service.
//
// Retrieves a list of configuration items according to criteria that you specify
// in a filter. The filter criteria identifies the relationship requirements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation ListConfigurations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/ListConfigurations
func (c *ApplicationDiscoveryService) ListConfigurations(input *ListConfigurationsInput) (*ListConfigurationsOutput, error) {
	req, out := c.ListConfigurationsRequest(input)
	return out, req.Send()
}

// ListConfigurationsWithContext is the same as ListConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) ListConfigurationsWithContext(ctx aws.Context, input *ListConfigurationsInput, opts ...request.Option) (*ListConfigurationsOutput, error) {
	req, out := c.ListConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListServerNeighbors = "ListServerNeighbors"

// ListServerNeighborsRequest generates a "aws/request.Request" representing the
// client's request for the ListServerNeighbors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServerNeighbors for more information on using the ListServerNeighbors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListServerNeighborsRequest method.
//    req, resp := client.ListServerNeighborsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/ListServerNeighbors
func (c *ApplicationDiscoveryService) ListServerNeighborsRequest(input *ListServerNeighborsInput) (req *request.Request, output *ListServerNeighborsOutput) {
	op := &request.Operation{
		Name:       opListServerNeighbors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListServerNeighborsInput{}
	}

	output = &ListServerNeighborsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServerNeighbors API operation for AWS Application Discovery Service.
//
// Retrieves a list of servers that are one network hop away from a specified
// server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation ListServerNeighbors for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/ListServerNeighbors
func (c *ApplicationDiscoveryService) ListServerNeighbors(input *ListServerNeighborsInput) (*ListServerNeighborsOutput, error) {
	req, out := c.ListServerNeighborsRequest(input)
	return out, req.Send()
}

// ListServerNeighborsWithContext is the same as ListServerNeighbors with the addition of
// the ability to pass a context and additional request options.
//
// See ListServerNeighbors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) ListServerNeighborsWithContext(ctx aws.Context, input *ListServerNeighborsInput, opts ...request.Option) (*ListServerNeighborsOutput, error) {
	req, out := c.ListServerNeighborsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDataCollectionByAgentIds = "StartDataCollectionByAgentIds"

// StartDataCollectionByAgentIdsRequest generates a "aws/request.Request" representing the
// client's request for the StartDataCollectionByAgentIds operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDataCollectionByAgentIds for more information on using the StartDataCollectionByAgentIds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDataCollectionByAgentIdsRequest method.
//    req, resp := client.StartDataCollectionByAgentIdsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StartDataCollectionByAgentIds
func (c *ApplicationDiscoveryService) StartDataCollectionByAgentIdsRequest(input *StartDataCollectionByAgentIdsInput) (req *request.Request, output *StartDataCollectionByAgentIdsOutput) {
	op := &request.Operation{
		Name:       opStartDataCollectionByAgentIds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDataCollectionByAgentIdsInput{}
	}

	output = &StartDataCollectionByAgentIdsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDataCollectionByAgentIds API operation for AWS Application Discovery Service.
//
// Instructs the specified agents or connectors to start collecting data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation StartDataCollectionByAgentIds for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StartDataCollectionByAgentIds
func (c *ApplicationDiscoveryService) StartDataCollectionByAgentIds(input *StartDataCollectionByAgentIdsInput) (*StartDataCollectionByAgentIdsOutput, error) {
	req, out := c.StartDataCollectionByAgentIdsRequest(input)
	return out, req.Send()
}

// StartDataCollectionByAgentIdsWithContext is the same as StartDataCollectionByAgentIds with the addition of
// the ability to pass a context and additional request options.
//
// See StartDataCollectionByAgentIds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) StartDataCollectionByAgentIdsWithContext(ctx aws.Context, input *StartDataCollectionByAgentIdsInput, opts ...request.Option) (*StartDataCollectionByAgentIdsOutput, error) {
	req, out := c.StartDataCollectionByAgentIdsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartExportTask = "StartExportTask"

// StartExportTaskRequest generates a "aws/request.Request" representing the
// client's request for the StartExportTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartExportTask for more information on using the StartExportTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartExportTaskRequest method.
//    req, resp := client.StartExportTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StartExportTask
func (c *ApplicationDiscoveryService) StartExportTaskRequest(input *StartExportTaskInput) (req *request.Request, output *StartExportTaskOutput) {
	op := &request.Operation{
		Name:       opStartExportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartExportTaskInput{}
	}

	output = &StartExportTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartExportTask API operation for AWS Application Discovery Service.
//
// Begins the export of discovered data to an S3 bucket.
//
// If you specify agentIds in a filter, the task exports up to 72 hours of detailed
// data collected by the identified Application Discovery Agent, including network,
// process, and performance details. A time range for exported agent data may
// be set by using startTime and endTime. Export of detailed agent data is limited
// to five concurrently running exports.
//
// If you do not include an agentIds filter, summary data is exported that includes
// both AWS Agentless Discovery Connector data and summary data from AWS Discovery
// Agents. Export of summary data is limited to two exports per day.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation StartExportTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   This operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StartExportTask
func (c *ApplicationDiscoveryService) StartExportTask(input *StartExportTaskInput) (*StartExportTaskOutput, error) {
	req, out := c.StartExportTaskRequest(input)
	return out, req.Send()
}

// StartExportTaskWithContext is the same as StartExportTask with the addition of
// the ability to pass a context and additional request options.
//
// See StartExportTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) StartExportTaskWithContext(ctx aws.Context, input *StartExportTaskInput, opts ...request.Option) (*StartExportTaskOutput, error) {
	req, out := c.StartExportTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDataCollectionByAgentIds = "StopDataCollectionByAgentIds"

// StopDataCollectionByAgentIdsRequest generates a "aws/request.Request" representing the
// client's request for the StopDataCollectionByAgentIds operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDataCollectionByAgentIds for more information on using the StopDataCollectionByAgentIds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopDataCollectionByAgentIdsRequest method.
//    req, resp := client.StopDataCollectionByAgentIdsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StopDataCollectionByAgentIds
func (c *ApplicationDiscoveryService) StopDataCollectionByAgentIdsRequest(input *StopDataCollectionByAgentIdsInput) (req *request.Request, output *StopDataCollectionByAgentIdsOutput) {
	op := &request.Operation{
		Name:       opStopDataCollectionByAgentIds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDataCollectionByAgentIdsInput{}
	}

	output = &StopDataCollectionByAgentIdsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopDataCollectionByAgentIds API operation for AWS Application Discovery Service.
//
// Instructs the specified agents or connectors to stop collecting data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation StopDataCollectionByAgentIds for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StopDataCollectionByAgentIds
func (c *ApplicationDiscoveryService) StopDataCollectionByAgentIds(input *StopDataCollectionByAgentIdsInput) (*StopDataCollectionByAgentIdsOutput, error) {
	req, out := c.StopDataCollectionByAgentIdsRequest(input)
	return out, req.Send()
}

// StopDataCollectionByAgentIdsWithContext is the same as StopDataCollectionByAgentIds with the addition of
// the ability to pass a context and additional request options.
//
// See StopDataCollectionByAgentIds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) StopDataCollectionByAgentIdsWithContext(ctx aws.Context, input *StopDataCollectionByAgentIdsInput, opts ...request.Option) (*StopDataCollectionByAgentIdsOutput, error) {
	req, out := c.StopDataCollectionByAgentIdsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplication for more information on using the UpdateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApplicationRequest method.
//    req, resp := client.UpdateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/UpdateApplication
func (c *ApplicationDiscoveryService) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	output = &UpdateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplication API operation for AWS Application Discovery Service.
//
// Updates metadata about an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation UpdateApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/UpdateApplication
func (c *ApplicationDiscoveryService) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	return out, req.Send()
}

// UpdateApplicationWithContext is the same as UpdateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) UpdateApplicationWithContext(ctx aws.Context, input *UpdateApplicationInput, opts ...request.Option) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Information about agents or connectors that were instructed to start collecting
// data. Information includes the agent/connector ID, a description of the operation,
// and whether the agent/connector configuration was updated.
type AgentConfigurationStatus struct {
	_ struct{} `type:"structure"`

	// The agent/connector ID.
	AgentId *string `locationName:"agentId" type:"string"`

	// A description of the operation performed.
	Description *string `locationName:"description" type:"string"`

	// Information about the status of the StartDataCollection and StopDataCollection
	// operations. The system has recorded the data collection operation. The agent/connector
	// receives this command the next time it polls for a new command.
	OperationSucceeded *bool `locationName:"operationSucceeded" type:"boolean"`
}

// String returns the string representation
func (s AgentConfigurationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentConfigurationStatus) GoString() string {
	return s.String()
}

// SetAgentId sets the AgentId field's value.
func (s *AgentConfigurationStatus) SetAgentId(v string) *AgentConfigurationStatus {
	s.AgentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentConfigurationStatus) SetDescription(v string) *AgentConfigurationStatus {
	s.Description = &v
	return s
}

// SetOperationSucceeded sets the OperationSucceeded field's value.
func (s *AgentConfigurationStatus) SetOperationSucceeded(v bool) *AgentConfigurationStatus {
	s.OperationSucceeded = &v
	return s
}

// Information about agents or connectors associated with the user’s AWS account.
// Information includes agent or connector IDs, IP addresses, media access control
// (MAC) addresses, agent or connector health, hostname where the agent or connector
// resides, and agent version for each agent.
type AgentInfo struct {
	_ struct{} `type:"structure"`

	// The agent or connector ID.
	AgentId *string `locationName:"agentId" type:"string"`

	// Network details about the host where the agent or connector resides.
	AgentNetworkInfoList []*AgentNetworkInfo `locationName:"agentNetworkInfoList" type:"list"`

	// Type of agent.
	AgentType *string `locationName:"agentType" type:"string"`

	// Status of the collection process for an agent or connector.
	CollectionStatus *string `locationName:"collectionStatus" type:"string"`

	// The ID of the connector.
	ConnectorId *string `locationName:"connectorId" type:"string"`

	// The health of the agent or connector.
	Health *string `locationName:"health" type:"string" enum:"AgentStatus"`

	// The name of the host where the agent or connector resides. The host can be
	// a server or virtual machine.
	HostName *string `locationName:"hostName" type:"string"`

	// Time since agent or connector health was reported.
	LastHealthPingTime *string `locationName:"lastHealthPingTime" type:"string"`

	// Agent's first registration timestamp in UTC.
	RegisteredTime *string `locationName:"registeredTime" type:"string"`

	// The agent or connector version.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s AgentInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentInfo) GoString() string {
	return s.String()
}

// SetAgentId sets the AgentId field's value.
func (s *AgentInfo) SetAgentId(v string) *AgentInfo {
	s.AgentId = &v
	return s
}

// SetAgentNetworkInfoList sets the AgentNetworkInfoList field's value.
func (s *AgentInfo) SetAgentNetworkInfoList(v []*AgentNetworkInfo) *AgentInfo {
	s.AgentNetworkInfoList = v
	return s
}

// SetAgentType sets the AgentType field's value.
func (s *AgentInfo) SetAgentType(v string) *AgentInfo {
	s.AgentType = &v
	return s
}

// SetCollectionStatus sets the CollectionStatus field's value.
func (s *AgentInfo) SetCollectionStatus(v string) *AgentInfo {
	s.CollectionStatus = &v
	return s
}

// SetConnectorId sets the ConnectorId field's value.
func (s *AgentInfo) SetConnectorId(v string) *AgentInfo {
	s.ConnectorId = &v
	return s
}

// SetHealth sets the Health field's value.
func (s *AgentInfo) SetHealth(v string) *AgentInfo {
	s.Health = &v
	return s
}

// SetHostName sets the HostName field's value.
func (s *AgentInfo) SetHostName(v string) *AgentInfo {
	s.HostName = &v
	return s
}

// SetLastHealthPingTime sets the LastHealthPingTime field's value.
func (s *AgentInfo) SetLastHealthPingTime(v string) *AgentInfo {
	s.LastHealthPingTime = &v
	return s
}

// SetRegisteredTime sets the RegisteredTime field's value.
func (s *AgentInfo) SetRegisteredTime(v string) *AgentInfo {
	s.RegisteredTime = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AgentInfo) SetVersion(v string) *AgentInfo {
	s.Version = &v
	return s
}

// Network details about the host where the agent/connector resides.
type AgentNetworkInfo struct {
	_ struct{} `type:"structure"`

	// The IP address for the host where the agent/connector resides.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// The MAC address for the host where the agent/connector resides.
	MacAddress *string `locationName:"macAddress" type:"string"`
}

// String returns the string representation
func (s AgentNetworkInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentNetworkInfo) GoString() string {
	return s.String()
}

// SetIpAddress sets the IpAddress field's value.
func (s *AgentNetworkInfo) SetIpAddress(v string) *AgentNetworkInfo {
	s.IpAddress = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *AgentNetworkInfo) SetMacAddress(v string) *AgentNetworkInfo {
	s.MacAddress = &v
	return s
}

type AssociateConfigurationItemsToApplicationInput struct {
	_ struct{} `type:"structure"`

	// The configuration ID of an application with which items are to be associated.
	//
	// ApplicationConfigurationId is a required field
	ApplicationConfigurationId *string `locationName:"applicationConfigurationId" type:"string" required:"true"`

	// The ID of each configuration item to be associated with an application.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []*string `locationName:"configurationIds" type:"list" required:"true"`
}

// String returns the string representation
func (s AssociateConfigurationItemsToApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateConfigurationItemsToApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateConfigurationItemsToApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateConfigurationItemsToApplicationInput"}
	if s.ApplicationConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationConfigurationId"))
	}
	if s.ConfigurationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationConfigurationId sets the ApplicationConfigurationId field's value.
func (s *AssociateConfigurationItemsToApplicationInput) SetApplicationConfigurationId(v string) *AssociateConfigurationItemsToApplicationInput {
	s.ApplicationConfigurationId = &v
	return s
}

// SetConfigurationIds sets the ConfigurationIds field's value.
func (s *AssociateConfigurationItemsToApplicationInput) SetConfigurationIds(v []*string) *AssociateConfigurationItemsToApplicationInput {
	s.ConfigurationIds = v
	return s
}

type AssociateConfigurationItemsToApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateConfigurationItemsToApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateConfigurationItemsToApplicationOutput) GoString() string {
	return s.String()
}

// Tags for a configuration item. Tags are metadata that help you categorize
// IT assets.
type ConfigurationTag struct {
	_ struct{} `type:"structure"`

	// The configuration ID for the item to tag. You can specify a list of keys
	// and values.
	ConfigurationId *string `locationName:"configurationId" type:"string"`

	// A type of IT asset to tag.
	ConfigurationType *string `locationName:"configurationType" type:"string" enum:"ConfigurationItemType"`

	// A type of tag on which to filter. For example, serverType.
	Key *string `locationName:"key" type:"string"`

	// The time the configuration tag was created in Coordinated Universal Time
	// (UTC).
	TimeOfCreation *time.Time `locationName:"timeOfCreation" type:"timestamp"`

	// A value on which to filter. For example key = serverType and value = web
	// server.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s ConfigurationTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationTag) GoString() string {
	return s.String()
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *ConfigurationTag) SetConfigurationId(v string) *ConfigurationTag {
	s.ConfigurationId = &v
	return s
}

// SetConfigurationType sets the ConfigurationType field's value.
func (s *ConfigurationTag) SetConfigurationType(v string) *ConfigurationTag {
	s.ConfigurationType = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ConfigurationTag) SetKey(v string) *ConfigurationTag {
	s.Key = &v
	return s
}

// SetTimeOfCreation sets the TimeOfCreation field's value.
func (s *ConfigurationTag) SetTimeOfCreation(v time.Time) *ConfigurationTag {
	s.TimeOfCreation = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConfigurationTag) SetValue(v string) *ConfigurationTag {
	s.Value = &v
	return s
}

type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// Description of the application to be created.
	Description *string `locationName:"description" type:"string"`

	// Name of the application to be created.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateApplicationInput) SetDescription(v string) *CreateApplicationInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApplicationInput) SetName(v string) *CreateApplicationInput {
	s.Name = &v
	return s
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Configuration ID of an application to be created.
	ConfigurationId *string `locationName:"configurationId" type:"string"`
}

// String returns the string representation
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *CreateApplicationOutput) SetConfigurationId(v string) *CreateApplicationOutput {
	s.ConfigurationId = &v
	return s
}

type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// A list of configuration items that you want to tag.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []*string `locationName:"configurationIds" type:"list" required:"true"`

	// Tags that you want to associate with one or more configuration items. Specify
	// the tags that you want to create in a key-value format. For example:
	//
	// {"key": "serverType", "value": "webServer"}
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTagsInput"}
	if s.ConfigurationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationIds"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationIds sets the ConfigurationIds field's value.
func (s *CreateTagsInput) SetConfigurationIds(v []*string) *CreateTagsInput {
	s.ConfigurationIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTagsInput) SetTags(v []*Tag) *CreateTagsInput {
	s.Tags = v
	return s
}

type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

// Inventory data for installed discovery agents.
type CustomerAgentInfo struct {
	_ struct{} `type:"structure"`

	// Number of active discovery agents.
	//
	// ActiveAgents is a required field
	ActiveAgents *int64 `locationName:"activeAgents" type:"integer" required:"true"`

	// Number of blacklisted discovery agents.
	//
	// BlackListedAgents is a required field
	BlackListedAgents *int64 `locationName:"blackListedAgents" type:"integer" required:"true"`

	// Number of healthy discovery agents
	//
	// HealthyAgents is a required field
	HealthyAgents *int64 `locationName:"healthyAgents" type:"integer" required:"true"`

	// Number of discovery agents with status SHUTDOWN.
	//
	// ShutdownAgents is a required field
	ShutdownAgents *int64 `locationName:"shutdownAgents" type:"integer" required:"true"`

	// Total number of discovery agents.
	//
	// TotalAgents is a required field
	TotalAgents *int64 `locationName:"totalAgents" type:"integer" required:"true"`

	// Number of unhealthy discovery agents.
	//
	// UnhealthyAgents is a required field
	UnhealthyAgents *int64 `locationName:"unhealthyAgents" type:"integer" required:"true"`

	// Number of unknown discovery agents.
	//
	// UnknownAgents is a required field
	UnknownAgents *int64 `locationName:"unknownAgents" type:"integer" required:"true"`
}

// String returns the string representation
func (s CustomerAgentInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomerAgentInfo) GoString() string {
	return s.String()
}

// SetActiveAgents sets the ActiveAgents field's value.
func (s *CustomerAgentInfo) SetActiveAgents(v int64) *CustomerAgentInfo {
	s.ActiveAgents = &v
	return s
}

// SetBlackListedAgents sets the BlackListedAgents field's value.
func (s *CustomerAgentInfo) SetBlackListedAgents(v int64) *CustomerAgentInfo {
	s.BlackListedAgents = &v
	return s
}

// SetHealthyAgents sets the HealthyAgents field's value.
func (s *CustomerAgentInfo) SetHealthyAgents(v int64) *CustomerAgentInfo {
	s.HealthyAgents = &v
	return s
}

// SetShutdownAgents sets the ShutdownAgents field's value.
func (s *CustomerAgentInfo) SetShutdownAgents(v int64) *CustomerAgentInfo {
	s.ShutdownAgents = &v
	return s
}

// SetTotalAgents sets the TotalAgents field's value.
func (s *CustomerAgentInfo) SetTotalAgents(v int64) *CustomerAgentInfo {
	s.TotalAgents = &v
	return s
}

// SetUnhealthyAgents sets the UnhealthyAgents field's value.
func (s *CustomerAgentInfo) SetUnhealthyAgents(v int64) *CustomerAgentInfo {
	s.UnhealthyAgents = &v
	return s
}

// SetUnknownAgents sets the UnknownAgents field's value.
func (s *CustomerAgentInfo) SetUnknownAgents(v int64) *CustomerAgentInfo {
	s.UnknownAgents = &v
	return s
}

// Inventory data for installed discovery connectors.
type CustomerConnectorInfo struct {
	_ struct{} `type:"structure"`

	// Number of active discovery connectors.
	//
	// ActiveConnectors is a required field
	ActiveConnectors *int64 `locationName:"activeConnectors" type:"integer" required:"true"`

	// Number of blacklisted discovery connectors.
	//
	// BlackListedConnectors is a required field
	BlackListedConnectors *int64 `locationName:"blackListedConnectors" type:"integer" required:"true"`

	// Number of healthy discovery connectors.
	//
	// HealthyConnectors is a required field
	HealthyConnectors *int64 `locationName:"healthyConnectors" type:"integer" required:"true"`

	// Number of discovery connectors with status SHUTDOWN,
	//
	// ShutdownConnectors is a required field
	ShutdownConnectors *int64 `locationName:"shutdownConnectors" type:"integer" required:"true"`

	// Total number of discovery connectors.
	//
	// TotalConnectors is a required field
	TotalConnectors *int64 `locationName:"totalConnectors" type:"integer" required:"true"`

	// Number of unhealthy discovery connectors.
	//
	// UnhealthyConnectors is a required field
	UnhealthyConnectors *int64 `locationName:"unhealthyConnectors" type:"integer" required:"true"`

	// Number of unknown discovery connectors.
	//
	// UnknownConnectors is a required field
	UnknownConnectors *int64 `locationName:"unknownConnectors" type:"integer" required:"true"`
}

// String returns the string representation
func (s CustomerConnectorInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomerConnectorInfo) GoString() string {
	return s.String()
}

// SetActiveConnectors sets the ActiveConnectors field's value.
func (s *CustomerConnectorInfo) SetActiveConnectors(v int64) *CustomerConnectorInfo {
	s.ActiveConnectors = &v
	return s
}

// SetBlackListedConnectors sets the BlackListedConnectors field's value.
func (s *CustomerConnectorInfo) SetBlackListedConnectors(v int64) *CustomerConnectorInfo {
	s.BlackListedConnectors = &v
	return s
}

// SetHealthyConnectors sets the HealthyConnectors field's value.
func (s *CustomerConnectorInfo) SetHealthyConnectors(v int64) *CustomerConnectorInfo {
	s.HealthyConnectors = &v
	return s
}

// SetShutdownConnectors sets the ShutdownConnectors field's value.
func (s *CustomerConnectorInfo) SetShutdownConnectors(v int64) *CustomerConnectorInfo {
	s.ShutdownConnectors = &v
	return s
}

// SetTotalConnectors sets the TotalConnectors field's value.
func (s *CustomerConnectorInfo) SetTotalConnectors(v int64) *CustomerConnectorInfo {
	s.TotalConnectors = &v
	return s
}

// SetUnhealthyConnectors sets the UnhealthyConnectors field's value.
func (s *CustomerConnectorInfo) SetUnhealthyConnectors(v int64) *CustomerConnectorInfo {
	s.UnhealthyConnectors = &v
	return s
}

// SetUnknownConnectors sets the UnknownConnectors field's value.
func (s *CustomerConnectorInfo) SetUnknownConnectors(v int64) *CustomerConnectorInfo {
	s.UnknownConnectors = &v
	return s
}

type DeleteApplicationsInput struct {
	_ struct{} `type:"structure"`

	// Configuration ID of an application to be deleted.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []*string `locationName:"configurationIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationsInput"}
	if s.ConfigurationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationIds sets the ConfigurationIds field's value.
func (s *DeleteApplicationsInput) SetConfigurationIds(v []*string) *DeleteApplicationsInput {
	s.ConfigurationIds = v
	return s
}

type DeleteApplicationsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationsOutput) GoString() string {
	return s.String()
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// A list of configuration items with tags that you want to delete.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []*string `locationName:"configurationIds" type:"list" required:"true"`

	// Tags that you want to delete from one or more configuration items. Specify
	// the tags that you want to delete in a key-value format. For example:
	//
	// {"key": "serverType", "value": "webServer"}
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.ConfigurationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationIds"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationIds sets the ConfigurationIds field's value.
func (s *DeleteTagsInput) SetConfigurationIds(v []*string) *DeleteTagsInput {
	s.ConfigurationIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DeleteTagsInput) SetTags(v []*Tag) *DeleteTagsInput {
	s.Tags = v
	return s
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DescribeAgentsInput struct {
	_ struct{} `type:"structure"`

	// The agent or the Connector IDs for which you want information. If you specify
	// no IDs, the system returns information about all agents/Connectors associated
	// with your AWS user account.
	AgentIds []*string `locationName:"agentIds" type:"list"`

	// You can filter the request using various logical operators and a key-value
	// format. For example:
	//
	// {"key": "collectionStatus", "value": "STARTED"}
	Filters []*Filter `locationName:"filters" type:"list"`

	// The total number of agents/Connectors to return in a single page of output.
	// The maximum value is 100.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// Token to retrieve the next set of results. For example, if you previously
	// specified 100 IDs for DescribeAgentsRequest$agentIds but set DescribeAgentsRequest$maxResults
	// to 10, you received a set of 10 results along with a token. Use that token
	// in this query to get the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeAgentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAgentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAgentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAgentsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentIds sets the AgentIds field's value.
func (s *DescribeAgentsInput) SetAgentIds(v []*string) *DescribeAgentsInput {
	s.AgentIds = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeAgentsInput) SetFilters(v []*Filter) *DescribeAgentsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAgentsInput) SetMaxResults(v int64) *DescribeAgentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAgentsInput) SetNextToken(v string) *DescribeAgentsInput {
	s.NextToken = &v
	return s
}

type DescribeAgentsOutput struct {
	_ struct{} `type:"structure"`

	// Lists agents or the Connector by ID or lists all agents/Connectors associated
	// with your user account if you did not specify an agent/Connector ID. The
	// output includes agent/Connector IDs, IP addresses, media access control (MAC)
	// addresses, agent/Connector health, host name where the agent/Connector resides,
	// and the version number of each agent/Connector.
	AgentsInfo []*AgentInfo `locationName:"agentsInfo" type:"list"`

	// Token to retrieve the next set of results. For example, if you specified
	// 100 IDs for DescribeAgentsRequest$agentIds but set DescribeAgentsRequest$maxResults
	// to 10, you received a set of 10 results along with this token. Use this token
	// in the next query to retrieve the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeAgentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAgentsOutput) GoString() string {
	return s.String()
}

// SetAgentsInfo sets the AgentsInfo field's value.
func (s *DescribeAgentsOutput) SetAgentsInfo(v []*AgentInfo) *DescribeAgentsOutput {
	s.AgentsInfo = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAgentsOutput) SetNextToken(v string) *DescribeAgentsOutput {
	s.NextToken = &v
	return s
}

type DescribeConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// One or more configuration IDs.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []*string `locationName:"configurationIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationsInput"}
	if s.ConfigurationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationIds sets the ConfigurationIds field's value.
func (s *DescribeConfigurationsInput) SetConfigurationIds(v []*string) *DescribeConfigurationsInput {
	s.ConfigurationIds = v
	return s
}

type DescribeConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A key in the response map. The value is an array of data.
	Configurations []map[string]*string `locationName:"configurations" type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationsOutput) GoString() string {
	return s.String()
}

// SetConfigurations sets the Configurations field's value.
func (s *DescribeConfigurationsOutput) SetConfigurations(v []map[string]*string) *DescribeConfigurationsOutput {
	s.Configurations = v
	return s
}

type DescribeExportConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that you can use to query the export status.
	ExportIds []*string `locationName:"exportIds" type:"list"`

	// The maximum number of results that you want to display as a part of the query.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// A token to get the next set of results. For example, if you specify 100 IDs
	// for DescribeExportConfigurationsRequest$exportIds but set DescribeExportConfigurationsRequest$maxResults
	// to 10, you get results in a set of 10. Use the token in the query to get
	// the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeExportConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExportConfigurationsInput) GoString() string {
	return s.String()
}

// SetExportIds sets the ExportIds field's value.
func (s *DescribeExportConfigurationsInput) SetExportIds(v []*string) *DescribeExportConfigurationsInput {
	s.ExportIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeExportConfigurationsInput) SetMaxResults(v int64) *DescribeExportConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeExportConfigurationsInput) SetNextToken(v string) *DescribeExportConfigurationsInput {
	s.NextToken = &v
	return s
}

type DescribeExportConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// Returns export details. When the status is complete, the response includes
	// a URL for an Amazon S3 bucket where you can view the data in a CSV file.
	ExportsInfo []*ExportInfo `locationName:"exportsInfo" type:"list"`

	// A token to get the next set of results. For example, if you specify 100 IDs
	// for DescribeExportConfigurationsRequest$exportIds but set DescribeExportConfigurationsRequest$maxResults
	// to 10, you get results in a set of 10. Use the token in the query to get
	// the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeExportConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExportConfigurationsOutput) GoString() string {
	return s.String()
}

// SetExportsInfo sets the ExportsInfo field's value.
func (s *DescribeExportConfigurationsOutput) SetExportsInfo(v []*ExportInfo) *DescribeExportConfigurationsOutput {
	s.ExportsInfo = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeExportConfigurationsOutput) SetNextToken(v string) *DescribeExportConfigurationsOutput {
	s.NextToken = &v
	return s
}

type DescribeExportTasksInput struct {
	_ struct{} `type:"structure"`

	// One or more unique identifiers used to query the status of an export request.
	ExportIds []*string `locationName:"exportIds" type:"list"`

	// One or more filters.
	//
	//    * AgentId - ID of the agent whose collected data will be exported
	Filters []*ExportFilter `locationName:"filters" type:"list"`

	// The maximum number of volume results returned by DescribeExportTasks in paginated
	// output. When this parameter is used, DescribeExportTasks only returns maxResults
	// results in a single page along with a nextToken response element.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a previous paginated DescribeExportTasks
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. This value is null when there are no more results
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeExportTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExportTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExportTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeExportTasksInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportIds sets the ExportIds field's value.
func (s *DescribeExportTasksInput) SetExportIds(v []*string) *DescribeExportTasksInput {
	s.ExportIds = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeExportTasksInput) SetFilters(v []*ExportFilter) *DescribeExportTasksInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeExportTasksInput) SetMaxResults(v int64) *DescribeExportTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeExportTasksInput) SetNextToken(v string) *DescribeExportTasksInput {
	s.NextToken = &v
	return s
}

type DescribeExportTasksOutput struct {
	_ struct{} `type:"structure"`

	// Contains one or more sets of export request details. When the status of a
	// request is SUCCEEDED, the response includes a URL for an Amazon S3 bucket
	// where you can view the data in a CSV file.
	ExportsInfo []*ExportInfo `locationName:"exportsInfo" type:"list"`

	// The nextToken value to include in a future DescribeExportTasks request. When
	// the results of a DescribeExportTasks request exceed maxResults, this value
	// can be used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeExportTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExportTasksOutput) GoString() string {
	return s.String()
}

// SetExportsInfo sets the ExportsInfo field's value.
func (s *DescribeExportTasksOutput) SetExportsInfo(v []*ExportInfo) *DescribeExportTasksOutput {
	s.ExportsInfo = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeExportTasksOutput) SetNextToken(v string) *DescribeExportTasksOutput {
	s.NextToken = &v
	return s
}

type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// You can filter the list using a key-value format. You can separate these
	// items by using logical operators. Allowed filters include tagKey, tagValue,
	// and configurationId.
	Filters []*TagFilter `locationName:"filters" type:"list"`

	// The total number of items to return in a single page of output. The maximum
	// value is 100.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTagsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeTagsInput) SetFilters(v []*TagFilter) *DescribeTagsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeTagsInput) SetMaxResults(v int64) *DescribeTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeTagsInput) SetNextToken(v string) *DescribeTagsInput {
	s.NextToken = &v
	return s
}

type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// The call returns a token. Use this token to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Depending on the input, this is a list of configuration items tagged with
	// a specific tag, or a list of tags for a specific configuration item.
	Tags []*ConfigurationTag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeTagsOutput) SetNextToken(v string) *DescribeTagsOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeTagsOutput) SetTags(v []*ConfigurationTag) *DescribeTagsOutput {
	s.Tags = v
	return s
}

type DisassociateConfigurationItemsFromApplicationInput struct {
	_ struct{} `type:"structure"`

	// Configuration ID of an application from which each item is disassociated.
	//
	// ApplicationConfigurationId is a required field
	ApplicationConfigurationId *string `locationName:"applicationConfigurationId" type:"string" required:"true"`

	// Configuration ID of each item to be disassociated from an application.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []*string `locationName:"configurationIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DisassociateConfigurationItemsFromApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateConfigurationItemsFromApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateConfigurationItemsFromApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateConfigurationItemsFromApplicationInput"}
	if s.ApplicationConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationConfigurationId"))
	}
	if s.ConfigurationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationConfigurationId sets the ApplicationConfigurationId field's value.
func (s *DisassociateConfigurationItemsFromApplicationInput) SetApplicationConfigurationId(v string) *DisassociateConfigurationItemsFromApplicationInput {
	s.ApplicationConfigurationId = &v
	return s
}

// SetConfigurationIds sets the ConfigurationIds field's value.
func (s *DisassociateConfigurationItemsFromApplicationInput) SetConfigurationIds(v []*string) *DisassociateConfigurationItemsFromApplicationInput {
	s.ConfigurationIds = v
	return s
}

type DisassociateConfigurationItemsFromApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateConfigurationItemsFromApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateConfigurationItemsFromApplicationOutput) GoString() string {
	return s.String()
}

type ExportConfigurationsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ExportConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportConfigurationsInput) GoString() string {
	return s.String()
}

type ExportConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that you can use to query the export status.
	ExportId *string `locationName:"exportId" type:"string"`
}

// String returns the string representation
func (s ExportConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportConfigurationsOutput) GoString() string {
	return s.String()
}

// SetExportId sets the ExportId field's value.
func (s *ExportConfigurationsOutput) SetExportId(v string) *ExportConfigurationsOutput {
	s.ExportId = &v
	return s
}

// Used to select which agent's data is to be exported. A single agent ID may
// be selected for export using the StartExportTask (http://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html)
// action.
type ExportFilter struct {
	_ struct{} `type:"structure"`

	// Supported condition: EQUALS
	//
	// Condition is a required field
	Condition *string `locationName:"condition" type:"string" required:"true"`

	// A single ExportFilter name. Supported filters: agentId.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A single agentId for a Discovery Agent. An agentId can be found using the
	// DescribeAgents (http://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html)
	// action. Typically an ADS agentId is in the form o-0123456789abcdef0.
	//
	// Values is a required field
	Values []*string `locationName:"values" type:"list" required:"true"`
}

// String returns the string representation
func (s ExportFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportFilter"}
	if s.Condition == nil {
		invalidParams.Add(request.NewErrParamRequired("Condition"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *ExportFilter) SetCondition(v string) *ExportFilter {
	s.Condition = &v
	return s
}

// SetName sets the Name field's value.
func (s *ExportFilter) SetName(v string) *ExportFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ExportFilter) SetValues(v []*string) *ExportFilter {
	s.Values = v
	return s
}

// Information regarding the export status of discovered data. The value is
// an array of objects.
type ExportInfo struct {
	_ struct{} `type:"structure"`

	// A URL for an Amazon S3 bucket where you can review the exported data. The
	// URL is displayed only if the export succeeded.
	ConfigurationsDownloadUrl *string `locationName:"configurationsDownloadUrl" type:"string"`

	// A unique identifier used to query an export.
	//
	// ExportId is a required field
	ExportId *string `locationName:"exportId" type:"string" required:"true"`

	// The time that the data export was initiated.
	//
	// ExportRequestTime is a required field
	ExportRequestTime *time.Time `locationName:"exportRequestTime" type:"timestamp" required:"true"`

	// The status of the data export job.
	//
	// ExportStatus is a required field
	ExportStatus *string `locationName:"exportStatus" type:"string" required:"true" enum:"ExportStatus"`

	// If true, the export of agent information exceeded the size limit for a single
	// export and the exported data is incomplete for the requested time range.
	// To address this, select a smaller time range for the export by using startDate
	// and endDate.
	IsTruncated *bool `locationName:"isTruncated" type:"boolean"`

	// The endTime used in the StartExportTask request. If no endTime was requested,
	// this result does not appear in ExportInfo.
	RequestedEndTime *time.Time `locationName:"requestedEndTime" type:"timestamp"`

	// The value of startTime parameter in the StartExportTask request. If no startTime
	// was requested, this result does not appear in ExportInfo.
	RequestedStartTime *time.Time `locationName:"requestedStartTime" type:"timestamp"`

	// A status message provided for API callers.
	//
	// StatusMessage is a required field
	StatusMessage *string `locationName:"statusMessage" type:"string" required:"true"`
}

// String returns the string representation
func (s ExportInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportInfo) GoString() string {
	return s.String()
}

// SetConfigurationsDownloadUrl sets the ConfigurationsDownloadUrl field's value.
func (s *ExportInfo) SetConfigurationsDownloadUrl(v string) *ExportInfo {
	s.ConfigurationsDownloadUrl = &v
	return s
}

// SetExportId sets the ExportId field's value.
func (s *ExportInfo) SetExportId(v string) *ExportInfo {
	s.ExportId = &v
	return s
}

// SetExportRequestTime sets the ExportRequestTime field's value.
func (s *ExportInfo) SetExportRequestTime(v time.Time) *ExportInfo {
	s.ExportRequestTime = &v
	return s
}

// SetExportStatus sets the ExportStatus field's value.
func (s *ExportInfo) SetExportStatus(v string) *ExportInfo {
	s.ExportStatus = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ExportInfo) SetIsTruncated(v bool) *ExportInfo {
	s.IsTruncated = &v
	return s
}

// SetRequestedEndTime sets the RequestedEndTime field's value.
func (s *ExportInfo) SetRequestedEndTime(v time.Time) *ExportInfo {
	s.RequestedEndTime = &v
	return s
}

// SetRequestedStartTime sets the RequestedStartTime field's value.
func (s *ExportInfo) SetRequestedStartTime(v time.Time) *ExportInfo {
	s.RequestedStartTime = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ExportInfo) SetStatusMessage(v string) *ExportInfo {
	s.StatusMessage = &v
	return s
}

// A filter that can use conditional operators.
//
// For more information about filters, see Querying Discovered Configuration
// Items (http://docs.aws.amazon.com/application-discovery/latest/APIReference/discovery-api-queries.html).
type Filter struct {
	_ struct{} `type:"structure"`

	// A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS,
	// CONTAINS, NOT_CONTAINS. If you specify multiple filters, the system utilizes
	// all filters as though concatenated by AND. If you specify multiple values
	// for a particular filter, the system differentiates the values using OR. Calling
	// either DescribeConfigurations or ListConfigurations returns attributes of
	// matching configuration items.
	//
	// Condition is a required field
	Condition *string `locationName:"condition" type:"string" required:"true"`

	// The name of the filter.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A string value on which to filter. For example, if you choose the destinationServer.osVersion
	// filter name, you could specify Ubuntu for the value.
	//
	// Values is a required field
	Values []*string `locationName:"values" type:"list" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Condition == nil {
		invalidParams.Add(request.NewErrParamRequired("Condition"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *Filter) SetCondition(v string) *Filter {
	s.Condition = &v
	return s
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

type GetDiscoverySummaryInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetDiscoverySummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDiscoverySummaryInput) GoString() string {
	return s.String()
}

type GetDiscoverySummaryOutput struct {
	_ struct{} `type:"structure"`

	// Details about discovered agents, including agent status and health.
	AgentSummary *CustomerAgentInfo `locationName:"agentSummary" type:"structure"`

	// The number of applications discovered.
	Applications *int64 `locationName:"applications" type:"long"`

	// Details about discovered connectors, including connector status and health.
	ConnectorSummary *CustomerConnectorInfo `locationName:"connectorSummary" type:"structure"`

	// The number of servers discovered.
	Servers *int64 `locationName:"servers" type:"long"`

	// The number of servers mapped to applications.
	ServersMappedToApplications *int64 `locationName:"serversMappedToApplications" type:"long"`

	// The number of servers mapped to tags.
	ServersMappedtoTags *int64 `locationName:"serversMappedtoTags" type:"long"`
}

// String returns the string representation
func (s GetDiscoverySummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDiscoverySummaryOutput) GoString() string {
	return s.String()
}

// SetAgentSummary sets the AgentSummary field's value.
func (s *GetDiscoverySummaryOutput) SetAgentSummary(v *CustomerAgentInfo) *GetDiscoverySummaryOutput {
	s.AgentSummary = v
	return s
}

// SetApplications sets the Applications field's value.
func (s *GetDiscoverySummaryOutput) SetApplications(v int64) *GetDiscoverySummaryOutput {
	s.Applications = &v
	return s
}

// SetConnectorSummary sets the ConnectorSummary field's value.
func (s *GetDiscoverySummaryOutput) SetConnectorSummary(v *CustomerConnectorInfo) *GetDiscoverySummaryOutput {
	s.ConnectorSummary = v
	return s
}

// SetServers sets the Servers field's value.
func (s *GetDiscoverySummaryOutput) SetServers(v int64) *GetDiscoverySummaryOutput {
	s.Servers = &v
	return s
}

// SetServersMappedToApplications sets the ServersMappedToApplications field's value.
func (s *GetDiscoverySummaryOutput) SetServersMappedToApplications(v int64) *GetDiscoverySummaryOutput {
	s.ServersMappedToApplications = &v
	return s
}

// SetServersMappedtoTags sets the ServersMappedtoTags field's value.
func (s *GetDiscoverySummaryOutput) SetServersMappedtoTags(v int64) *GetDiscoverySummaryOutput {
	s.ServersMappedtoTags = &v
	return s
}

type ListConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// A valid configuration identified by Application Discovery Service.
	//
	// ConfigurationType is a required field
	ConfigurationType *string `locationName:"configurationType" type:"string" required:"true" enum:"ConfigurationItemType"`

	// You can filter the request using various logical operators and a key-value
	// format. For example:
	//
	// {"key": "serverType", "value": "webServer"}
	//
	// For a complete list of filter options and guidance about using them with
	// this action, see Querying Discovered Configuration Items (http://docs.aws.amazon.com/application-discovery/latest/APIReference/discovery-api-queries.html#ListConfigurations).
	Filters []*Filter `locationName:"filters" type:"list"`

	// The total number of items to return. The maximum value is 100.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// Token to retrieve the next set of results. For example, if a previous call
	// to ListConfigurations returned 100 items, but you set ListConfigurationsRequest$maxResults
	// to 10, you received a set of 10 results along with a token. Use that token
	// in this query to get the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Certain filter criteria return output that can be sorted in ascending or
	// descending order. For a list of output characteristics for each filter, see
	// Using the ListConfigurations Action (http://docs.aws.amazon.com/application-discovery/latest/APIReference/discovery-api-queries.html#ListConfigurations).
	OrderBy []*OrderByElement `locationName:"orderBy" type:"list"`
}

// String returns the string representation
func (s ListConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConfigurationsInput"}
	if s.ConfigurationType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationType"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OrderBy != nil {
		for i, v := range s.OrderBy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OrderBy", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationType sets the ConfigurationType field's value.
func (s *ListConfigurationsInput) SetConfigurationType(v string) *ListConfigurationsInput {
	s.ConfigurationType = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListConfigurationsInput) SetFilters(v []*Filter) *ListConfigurationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfigurationsInput) SetMaxResults(v int64) *ListConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationsInput) SetNextToken(v string) *ListConfigurationsInput {
	s.NextToken = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *ListConfigurationsInput) SetOrderBy(v []*OrderByElement) *ListConfigurationsInput {
	s.OrderBy = v
	return s
}

type ListConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// Returns configuration details, including the configuration ID, attribute
	// names, and attribute values.
	Configurations []map[string]*string `locationName:"configurations" type:"list"`

	// Token to retrieve the next set of results. For example, if your call to ListConfigurations
	// returned 100 items, but you set ListConfigurationsRequest$maxResults to 10,
	// you received a set of 10 results along with this token. Use this token in
	// the next query to retrieve the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationsOutput) GoString() string {
	return s.String()
}

// SetConfigurations sets the Configurations field's value.
func (s *ListConfigurationsOutput) SetConfigurations(v []map[string]*string) *ListConfigurationsOutput {
	s.Configurations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationsOutput) SetNextToken(v string) *ListConfigurationsOutput {
	s.NextToken = &v
	return s
}

type ListServerNeighborsInput struct {
	_ struct{} `type:"structure"`

	// Configuration ID of the server for which neighbors are being listed.
	//
	// ConfigurationId is a required field
	ConfigurationId *string `locationName:"configurationId" type:"string" required:"true"`

	// Maximum number of results to return in a single page of output.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// List of configuration IDs to test for one-hop-away.
	NeighborConfigurationIds []*string `locationName:"neighborConfigurationIds" type:"list"`

	// Token to retrieve the next set of results. For example, if you previously
	// specified 100 IDs for ListServerNeighborsRequest$neighborConfigurationIds
	// but set ListServerNeighborsRequest$maxResults to 10, you received a set of
	// 10 results along with a token. Use that token in this query to get the next
	// set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Flag to indicate if port and protocol information is needed as part of the
	// response.
	PortInformationNeeded *bool `locationName:"portInformationNeeded" type:"boolean"`
}

// String returns the string representation
func (s ListServerNeighborsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServerNeighborsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServerNeighborsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServerNeighborsInput"}
	if s.ConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *ListServerNeighborsInput) SetConfigurationId(v string) *ListServerNeighborsInput {
	s.ConfigurationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServerNeighborsInput) SetMaxResults(v int64) *ListServerNeighborsInput {
	s.MaxResults = &v
	return s
}

// SetNeighborConfigurationIds sets the NeighborConfigurationIds field's value.
func (s *ListServerNeighborsInput) SetNeighborConfigurationIds(v []*string) *ListServerNeighborsInput {
	s.NeighborConfigurationIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServerNeighborsInput) SetNextToken(v string) *ListServerNeighborsInput {
	s.NextToken = &v
	return s
}

// SetPortInformationNeeded sets the PortInformationNeeded field's value.
func (s *ListServerNeighborsInput) SetPortInformationNeeded(v bool) *ListServerNeighborsInput {
	s.PortInformationNeeded = &v
	return s
}

type ListServerNeighborsOutput struct {
	_ struct{} `type:"structure"`

	// Count of distinct servers that are one hop away from the given server.
	KnownDependencyCount *int64 `locationName:"knownDependencyCount" type:"long"`

	// List of distinct servers that are one hop away from the given server.
	//
	// Neighbors is a required field
	Neighbors []*NeighborConnectionDetail `locationName:"neighbors" type:"list" required:"true"`

	// Token to retrieve the next set of results. For example, if you specified
	// 100 IDs for ListServerNeighborsRequest$neighborConfigurationIds but set ListServerNeighborsRequest$maxResults
	// to 10, you received a set of 10 results along with this token. Use this token
	// in the next query to retrieve the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListServerNeighborsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServerNeighborsOutput) GoString() string {
	return s.String()
}

// SetKnownDependencyCount sets the KnownDependencyCount field's value.
func (s *ListServerNeighborsOutput) SetKnownDependencyCount(v int64) *ListServerNeighborsOutput {
	s.KnownDependencyCount = &v
	return s
}

// SetNeighbors sets the Neighbors field's value.
func (s *ListServerNeighborsOutput) SetNeighbors(v []*NeighborConnectionDetail) *ListServerNeighborsOutput {
	s.Neighbors = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServerNeighborsOutput) SetNextToken(v string) *ListServerNeighborsOutput {
	s.NextToken = &v
	return s
}

// Details about neighboring servers.
type NeighborConnectionDetail struct {
	_ struct{} `type:"structure"`

	// The number of open network connections with the neighboring server.
	//
	// ConnectionsCount is a required field
	ConnectionsCount *int64 `locationName:"connectionsCount" type:"long" required:"true"`

	// The destination network port for the connection.
	DestinationPort *int64 `locationName:"destinationPort" type:"integer"`

	// The ID of the server that accepted the network connection.
	//
	// DestinationServerId is a required field
	DestinationServerId *string `locationName:"destinationServerId" type:"string" required:"true"`

	// The ID of the server that opened the network connection.
	//
	// SourceServerId is a required field
	SourceServerId *string `locationName:"sourceServerId" type:"string" required:"true"`

	// The network protocol used for the connection.
	TransportProtocol *string `locationName:"transportProtocol" type:"string"`
}

// String returns the string representation
func (s NeighborConnectionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NeighborConnectionDetail) GoString() string {
	return s.String()
}

// SetConnectionsCount sets the ConnectionsCount field's value.
func (s *NeighborConnectionDetail) SetConnectionsCount(v int64) *NeighborConnectionDetail {
	s.ConnectionsCount = &v
	return s
}

// SetDestinationPort sets the DestinationPort field's value.
func (s *NeighborConnectionDetail) SetDestinationPort(v int64) *NeighborConnectionDetail {
	s.DestinationPort = &v
	return s
}

// SetDestinationServerId sets the DestinationServerId field's value.
func (s *NeighborConnectionDetail) SetDestinationServerId(v string) *NeighborConnectionDetail {
	s.DestinationServerId = &v
	return s
}

// SetSourceServerId sets the SourceServerId field's value.
func (s *NeighborConnectionDetail) SetSourceServerId(v string) *NeighborConnectionDetail {
	s.SourceServerId = &v
	return s
}

// SetTransportProtocol sets the TransportProtocol field's value.
func (s *NeighborConnectionDetail) SetTransportProtocol(v string) *NeighborConnectionDetail {
	s.TransportProtocol = &v
	return s
}

// A field and direction for ordered output.
type OrderByElement struct {
	_ struct{} `type:"structure"`

	// The field on which to order.
	//
	// FieldName is a required field
	FieldName *string `locationName:"fieldName" type:"string" required:"true"`

	// Ordering direction.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"orderString"`
}

// String returns the string representation
func (s OrderByElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrderByElement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OrderByElement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OrderByElement"}
	if s.FieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldName sets the FieldName field's value.
func (s *OrderByElement) SetFieldName(v string) *OrderByElement {
	s.FieldName = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *OrderByElement) SetSortOrder(v string) *OrderByElement {
	s.SortOrder = &v
	return s
}

type StartDataCollectionByAgentIdsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the agents or connectors from which to start collecting data.
	// If you send a request to an agent/connector ID that you do not have permission
	// to contact, according to your AWS account, the service does not throw an
	// exception. Instead, it returns the error in the Description field. If you
	// send a request to multiple agents/connectors and you do not have permission
	// to contact some of those agents/connectors, the system does not throw an
	// exception. Instead, the system shows Failed in the Description field.
	//
	// AgentIds is a required field
	AgentIds []*string `locationName:"agentIds" type:"list" required:"true"`
}

// String returns the string representation
func (s StartDataCollectionByAgentIdsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDataCollectionByAgentIdsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDataCollectionByAgentIdsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDataCollectionByAgentIdsInput"}
	if s.AgentIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentIds sets the AgentIds field's value.
func (s *StartDataCollectionByAgentIdsInput) SetAgentIds(v []*string) *StartDataCollectionByAgentIdsInput {
	s.AgentIds = v
	return s
}

type StartDataCollectionByAgentIdsOutput struct {
	_ struct{} `type:"structure"`

	// Information about agents or the connector that were instructed to start collecting
	// data. Information includes the agent/connector ID, a description of the operation
	// performed, and whether the agent/connector configuration was updated.
	AgentsConfigurationStatus []*AgentConfigurationStatus `locationName:"agentsConfigurationStatus" type:"list"`
}

// String returns the string representation
func (s StartDataCollectionByAgentIdsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDataCollectionByAgentIdsOutput) GoString() string {
	return s.String()
}

// SetAgentsConfigurationStatus sets the AgentsConfigurationStatus field's value.
func (s *StartDataCollectionByAgentIdsOutput) SetAgentsConfigurationStatus(v []*AgentConfigurationStatus) *StartDataCollectionByAgentIdsOutput {
	s.AgentsConfigurationStatus = v
	return s
}

type StartExportTaskInput struct {
	_ struct{} `type:"structure"`

	// The end timestamp for exported data from the single Application Discovery
	// Agent selected in the filters. If no value is specified, exported data includes
	// the most recent data collected by the agent.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The file format for the returned export data. Default value is CSV. Note:TheGRAPHMLoption
	// has been deprecated.
	ExportDataFormat []*string `locationName:"exportDataFormat" type:"list"`

	// If a filter is present, it selects the single agentId of the Application
	// Discovery Agent for which data is exported. The agentId can be found in the
	// results of the DescribeAgents API or CLI. If no filter is present, startTime
	// and endTime are ignored and exported data includes both Agentless Discovery
	// Connector data and summary data from Application Discovery agents.
	Filters []*ExportFilter `locationName:"filters" type:"list"`

	// The start timestamp for exported data from the single Application Discovery
	// Agent selected in the filters. If no value is specified, data is exported
	// starting from the first data collected by the agent.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`
}

// String returns the string representation
func (s StartExportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartExportTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartExportTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartExportTaskInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *StartExportTaskInput) SetEndTime(v time.Time) *StartExportTaskInput {
	s.EndTime = &v
	return s
}

// SetExportDataFormat sets the ExportDataFormat field's value.
func (s *StartExportTaskInput) SetExportDataFormat(v []*string) *StartExportTaskInput {
	s.ExportDataFormat = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *StartExportTaskInput) SetFilters(v []*ExportFilter) *StartExportTaskInput {
	s.Filters = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StartExportTaskInput) SetStartTime(v time.Time) *StartExportTaskInput {
	s.StartTime = &v
	return s
}

type StartExportTaskOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier used to query the status of an export request.
	ExportId *string `locationName:"exportId" type:"string"`
}

// String returns the string representation
func (s StartExportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartExportTaskOutput) GoString() string {
	return s.String()
}

// SetExportId sets the ExportId field's value.
func (s *StartExportTaskOutput) SetExportId(v string) *StartExportTaskOutput {
	s.ExportId = &v
	return s
}

type StopDataCollectionByAgentIdsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the agents or connectors from which to stop collecting data.
	//
	// AgentIds is a required field
	AgentIds []*string `locationName:"agentIds" type:"list" required:"true"`
}

// String returns the string representation
func (s StopDataCollectionByAgentIdsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDataCollectionByAgentIdsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDataCollectionByAgentIdsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopDataCollectionByAgentIdsInput"}
	if s.AgentIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentIds sets the AgentIds field's value.
func (s *StopDataCollectionByAgentIdsInput) SetAgentIds(v []*string) *StopDataCollectionByAgentIdsInput {
	s.AgentIds = v
	return s
}

type StopDataCollectionByAgentIdsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the agents or connector that were instructed to stop collecting
	// data. Information includes the agent/connector ID, a description of the operation
	// performed, and whether the agent/connector configuration was updated.
	AgentsConfigurationStatus []*AgentConfigurationStatus `locationName:"agentsConfigurationStatus" type:"list"`
}

// String returns the string representation
func (s StopDataCollectionByAgentIdsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDataCollectionByAgentIdsOutput) GoString() string {
	return s.String()
}

// SetAgentsConfigurationStatus sets the AgentsConfigurationStatus field's value.
func (s *StopDataCollectionByAgentIdsOutput) SetAgentsConfigurationStatus(v []*AgentConfigurationStatus) *StopDataCollectionByAgentIdsOutput {
	s.AgentsConfigurationStatus = v
	return s
}

// Metadata that help you categorize IT assets.
type Tag struct {
	_ struct{} `type:"structure"`

	// The type of tag on which to filter.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true"`

	// A value for a tag key on which to filter.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The tag filter. Valid names are: tagKey, tagValue, configurationId.
type TagFilter struct {
	_ struct{} `type:"structure"`

	// A name of the tag filter.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Values for the tag filter.
	//
	// Values is a required field
	Values []*string `locationName:"values" type:"list" required:"true"`
}

// String returns the string representation
func (s TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *TagFilter) SetName(v string) *TagFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagFilter) SetValues(v []*string) *TagFilter {
	s.Values = v
	return s
}

type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// Configuration ID of the application to be updated.
	//
	// ConfigurationId is a required field
	ConfigurationId *string `locationName:"configurationId" type:"string" required:"true"`

	// New description of the application to be updated.
	Description *string `locationName:"description" type:"string"`

	// New name of the application to be updated.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationInput"}
	if s.ConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *UpdateApplicationInput) SetConfigurationId(v string) *UpdateApplicationInput {
	s.ConfigurationId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateApplicationInput) SetDescription(v string) *UpdateApplicationInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateApplicationInput) SetName(v string) *UpdateApplicationInput {
	s.Name = &v
	return s
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

const (
	// AgentStatusHealthy is a AgentStatus enum value
	AgentStatusHealthy = "HEALTHY"

	// AgentStatusUnhealthy is a AgentStatus enum value
	AgentStatusUnhealthy = "UNHEALTHY"

	// AgentStatusRunning is a AgentStatus enum value
	AgentStatusRunning = "RUNNING"

	// AgentStatusUnknown is a AgentStatus enum value
	AgentStatusUnknown = "UNKNOWN"

	// AgentStatusBlacklisted is a AgentStatus enum value
	AgentStatusBlacklisted = "BLACKLISTED"

	// AgentStatusShutdown is a AgentStatus enum value
	AgentStatusShutdown = "SHUTDOWN"
)

const (
	// ConfigurationItemTypeServer is a ConfigurationItemType enum value
	ConfigurationItemTypeServer = "SERVER"

	// ConfigurationItemTypeProcess is a ConfigurationItemType enum value
	ConfigurationItemTypeProcess = "PROCESS"

	// ConfigurationItemTypeConnection is a ConfigurationItemType enum value
	ConfigurationItemTypeConnection = "CONNECTION"

	// ConfigurationItemTypeApplication is a ConfigurationItemType enum value
	ConfigurationItemTypeApplication = "APPLICATION"
)

const (
	// ExportDataFormatCsv is a ExportDataFormat enum value
	ExportDataFormatCsv = "CSV"

	// ExportDataFormatGraphml is a ExportDataFormat enum value
	ExportDataFormatGraphml = "GRAPHML"
)

const (
	// ExportStatusFailed is a ExportStatus enum value
	ExportStatusFailed = "FAILED"

	// ExportStatusSucceeded is a ExportStatus enum value
	ExportStatusSucceeded = "SUCCEEDED"

	// ExportStatusInProgress is a ExportStatus enum value
	ExportStatusInProgress = "IN_PROGRESS"
)

const (
	// OrderStringAsc is a orderString enum value
	OrderStringAsc = "ASC"

	// OrderStringDesc is a orderString enum value
	OrderStringDesc = "DESC"
)
