package programmatic

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/satori/go.uuid"
	"net/http"
)

// ModelClient is the client for the Model methods of the Programmatic service.
type ModelClient struct {
	BaseClient
}

// NewModelClient creates an instance of the ModelClient client.
func NewModelClient(azureRegion AzureRegions) ModelClient {
	return ModelClient{New(azureRegion)}
}

// AddClosedList adds a closed list model to the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// closedListModelCreateObject - a model containing the name and words for the new closed list entity
// extractor.
func (client ModelClient) AddClosedList(ctx context.Context, appID uuid.UUID, versionID string, closedListModelCreateObject ClosedListModelCreateObject) (result UUID, err error) {
	req, err := client.AddClosedListPreparer(ctx, appID, versionID, closedListModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddClosedList", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddClosedListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddClosedList", resp, "Failure sending request")
		return
	}

	result, err = client.AddClosedListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddClosedList", resp, "Failure responding to request")
	}

	return
}

// AddClosedListPreparer prepares the AddClosedList request.
func (client ModelClient) AddClosedListPreparer(ctx context.Context, appID uuid.UUID, versionID string, closedListModelCreateObject ClosedListModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists", pathParameters),
		autorest.WithJSON(closedListModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddClosedListSender sends the AddClosedList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddClosedListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddClosedListResponder handles the response to the AddClosedList request. The method always
// closes the http.Response Body.
func (client ModelClient) AddClosedListResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddCompositeEntity adds a composite entity extractor to the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// compositeModelCreateObject - a model containing the name and children of the new entity extractor.
func (client ModelClient) AddCompositeEntity(ctx context.Context, appID uuid.UUID, versionID string, compositeModelCreateObject CompositeEntityModel) (result UUID, err error) {
	req, err := client.AddCompositeEntityPreparer(ctx, appID, versionID, compositeModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCompositeEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddCompositeEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCompositeEntity", resp, "Failure sending request")
		return
	}

	result, err = client.AddCompositeEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCompositeEntity", resp, "Failure responding to request")
	}

	return
}

// AddCompositeEntityPreparer prepares the AddCompositeEntity request.
func (client ModelClient) AddCompositeEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, compositeModelCreateObject CompositeEntityModel) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities", pathParameters),
		autorest.WithJSON(compositeModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddCompositeEntitySender sends the AddCompositeEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddCompositeEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddCompositeEntityResponder handles the response to the AddCompositeEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) AddCompositeEntityResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddCompositeEntityChild creates a single child in an existing composite entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// compositeChildModelCreateObject - a model object containing the name of the new composite child model.
func (client ModelClient) AddCompositeEntityChild(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, compositeChildModelCreateObject CompositeChildModelCreateObject) (result UUID, err error) {
	req, err := client.AddCompositeEntityChildPreparer(ctx, appID, versionID, cEntityID, compositeChildModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCompositeEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddCompositeEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCompositeEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.AddCompositeEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCompositeEntityChild", resp, "Failure responding to request")
	}

	return
}

// AddCompositeEntityChildPreparer prepares the AddCompositeEntityChild request.
func (client ModelClient) AddCompositeEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, compositeChildModelCreateObject CompositeChildModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/children", pathParameters),
		autorest.WithJSON(compositeChildModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddCompositeEntityChildSender sends the AddCompositeEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddCompositeEntityChildSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddCompositeEntityChildResponder handles the response to the AddCompositeEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) AddCompositeEntityChildResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddCustomPrebuiltDomain adds a customizable prebuilt domain along with all of its models to this application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltDomainObject - a prebuilt domain create object containing the name of the domain.
func (client ModelClient) AddCustomPrebuiltDomain(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainObject PrebuiltDomainCreateBaseObject) (result ListUUID, err error) {
	req, err := client.AddCustomPrebuiltDomainPreparer(ctx, appID, versionID, prebuiltDomainObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltDomain", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddCustomPrebuiltDomainSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltDomain", resp, "Failure sending request")
		return
	}

	result, err = client.AddCustomPrebuiltDomainResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltDomain", resp, "Failure responding to request")
	}

	return
}

// AddCustomPrebuiltDomainPreparer prepares the AddCustomPrebuiltDomain request.
func (client ModelClient) AddCustomPrebuiltDomainPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainObject PrebuiltDomainCreateBaseObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltdomains", pathParameters),
		autorest.WithJSON(prebuiltDomainObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddCustomPrebuiltDomainSender sends the AddCustomPrebuiltDomain request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddCustomPrebuiltDomainSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddCustomPrebuiltDomainResponder handles the response to the AddCustomPrebuiltDomain request. The method always
// closes the http.Response Body.
func (client ModelClient) AddCustomPrebuiltDomainResponder(resp *http.Response) (result ListUUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddCustomPrebuiltEntity adds a custom prebuilt entity model to the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltDomainModelCreateObject - a model object containing the name of the custom prebuilt entity and the
// name of the domain to which this model belongs.
func (client ModelClient) AddCustomPrebuiltEntity(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainModelCreateObject PrebuiltDomainModelCreateObject) (result UUID, err error) {
	req, err := client.AddCustomPrebuiltEntityPreparer(ctx, appID, versionID, prebuiltDomainModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddCustomPrebuiltEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltEntity", resp, "Failure sending request")
		return
	}

	result, err = client.AddCustomPrebuiltEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltEntity", resp, "Failure responding to request")
	}

	return
}

// AddCustomPrebuiltEntityPreparer prepares the AddCustomPrebuiltEntity request.
func (client ModelClient) AddCustomPrebuiltEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainModelCreateObject PrebuiltDomainModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltentities", pathParameters),
		autorest.WithJSON(prebuiltDomainModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddCustomPrebuiltEntitySender sends the AddCustomPrebuiltEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddCustomPrebuiltEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddCustomPrebuiltEntityResponder handles the response to the AddCustomPrebuiltEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) AddCustomPrebuiltEntityResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddCustomPrebuiltIntent adds a custom prebuilt intent model to the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltDomainModelCreateObject - a model object containing the name of the custom prebuilt intent and the
// name of the domain to which this model belongs.
func (client ModelClient) AddCustomPrebuiltIntent(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainModelCreateObject PrebuiltDomainModelCreateObject) (result UUID, err error) {
	req, err := client.AddCustomPrebuiltIntentPreparer(ctx, appID, versionID, prebuiltDomainModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltIntent", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddCustomPrebuiltIntentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltIntent", resp, "Failure sending request")
		return
	}

	result, err = client.AddCustomPrebuiltIntentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddCustomPrebuiltIntent", resp, "Failure responding to request")
	}

	return
}

// AddCustomPrebuiltIntentPreparer prepares the AddCustomPrebuiltIntent request.
func (client ModelClient) AddCustomPrebuiltIntentPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainModelCreateObject PrebuiltDomainModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltintents", pathParameters),
		autorest.WithJSON(prebuiltDomainModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddCustomPrebuiltIntentSender sends the AddCustomPrebuiltIntent request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddCustomPrebuiltIntentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddCustomPrebuiltIntentResponder handles the response to the AddCustomPrebuiltIntent request. The method always
// closes the http.Response Body.
func (client ModelClient) AddCustomPrebuiltIntentResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddEntity adds an entity extractor to the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// modelCreateObject - a model object containing the name for the new entity extractor.
func (client ModelClient) AddEntity(ctx context.Context, appID uuid.UUID, versionID string, modelCreateObject ModelCreateObject) (result UUID, err error) {
	req, err := client.AddEntityPreparer(ctx, appID, versionID, modelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddEntity", resp, "Failure sending request")
		return
	}

	result, err = client.AddEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddEntity", resp, "Failure responding to request")
	}

	return
}

// AddEntityPreparer prepares the AddEntity request.
func (client ModelClient) AddEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, modelCreateObject ModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities", pathParameters),
		autorest.WithJSON(modelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddEntitySender sends the AddEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddEntityResponder handles the response to the AddEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) AddEntityResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddHierarchicalEntity adds a hierarchical entity extractor to the application version.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hierarchicalModelCreateObject - a model containing the name and children of the new entity extractor.
func (client ModelClient) AddHierarchicalEntity(ctx context.Context, appID uuid.UUID, versionID string, hierarchicalModelCreateObject HierarchicalEntityModel) (result UUID, err error) {
	req, err := client.AddHierarchicalEntityPreparer(ctx, appID, versionID, hierarchicalModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddHierarchicalEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddHierarchicalEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddHierarchicalEntity", resp, "Failure sending request")
		return
	}

	result, err = client.AddHierarchicalEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddHierarchicalEntity", resp, "Failure responding to request")
	}

	return
}

// AddHierarchicalEntityPreparer prepares the AddHierarchicalEntity request.
func (client ModelClient) AddHierarchicalEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, hierarchicalModelCreateObject HierarchicalEntityModel) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities", pathParameters),
		autorest.WithJSON(hierarchicalModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddHierarchicalEntitySender sends the AddHierarchicalEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddHierarchicalEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddHierarchicalEntityResponder handles the response to the AddHierarchicalEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) AddHierarchicalEntityResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddHierarchicalEntityChild creates a single child in an existing hierarchical entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// hierarchicalChildModelCreateObject - a model object containing the name of the new hierarchical child model.
func (client ModelClient) AddHierarchicalEntityChild(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hierarchicalChildModelCreateObject HierarchicalChildModelCreateObject) (result UUID, err error) {
	req, err := client.AddHierarchicalEntityChildPreparer(ctx, appID, versionID, hEntityID, hierarchicalChildModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddHierarchicalEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddHierarchicalEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddHierarchicalEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.AddHierarchicalEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddHierarchicalEntityChild", resp, "Failure responding to request")
	}

	return
}

// AddHierarchicalEntityChildPreparer prepares the AddHierarchicalEntityChild request.
func (client ModelClient) AddHierarchicalEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hierarchicalChildModelCreateObject HierarchicalChildModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/children", pathParameters),
		autorest.WithJSON(hierarchicalChildModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddHierarchicalEntityChildSender sends the AddHierarchicalEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddHierarchicalEntityChildSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddHierarchicalEntityChildResponder handles the response to the AddHierarchicalEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) AddHierarchicalEntityChildResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddIntent adds an intent classifier to the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentCreateObject - a model object containing the name of the new intent classifier.
func (client ModelClient) AddIntent(ctx context.Context, appID uuid.UUID, versionID string, intentCreateObject ModelCreateObject) (result UUID, err error) {
	req, err := client.AddIntentPreparer(ctx, appID, versionID, intentCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddIntent", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddIntentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddIntent", resp, "Failure sending request")
		return
	}

	result, err = client.AddIntentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddIntent", resp, "Failure responding to request")
	}

	return
}

// AddIntentPreparer prepares the AddIntent request.
func (client ModelClient) AddIntentPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentCreateObject ModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents", pathParameters),
		autorest.WithJSON(intentCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddIntentSender sends the AddIntent request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddIntentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddIntentResponder handles the response to the AddIntent request. The method always
// closes the http.Response Body.
func (client ModelClient) AddIntentResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddPrebuilt adds a list of prebuilt entity extractors to the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltExtractorNames - an array of prebuilt entity extractor names.
func (client ModelClient) AddPrebuilt(ctx context.Context, appID uuid.UUID, versionID string, prebuiltExtractorNames []string) (result ListPrebuiltEntityExtractor, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: prebuiltExtractorNames,
			Constraints: []validation.Constraint{{Target: "prebuiltExtractorNames", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "AddPrebuilt", err.Error())
	}

	req, err := client.AddPrebuiltPreparer(ctx, appID, versionID, prebuiltExtractorNames)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddPrebuilt", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddPrebuiltSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddPrebuilt", resp, "Failure sending request")
		return
	}

	result, err = client.AddPrebuiltResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddPrebuilt", resp, "Failure responding to request")
	}

	return
}

// AddPrebuiltPreparer prepares the AddPrebuilt request.
func (client ModelClient) AddPrebuiltPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltExtractorNames []string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts", pathParameters),
		autorest.WithJSON(prebuiltExtractorNames))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddPrebuiltSender sends the AddPrebuilt request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddPrebuiltSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddPrebuiltResponder handles the response to the AddPrebuilt request. The method always
// closes the http.Response Body.
func (client ModelClient) AddPrebuiltResponder(resp *http.Response) (result ListPrebuiltEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddSubList adds a list to an existing closed list.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the closed list entity extractor ID.
// wordListCreateObject - words list.
func (client ModelClient) AddSubList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, wordListCreateObject WordListObject) (result Int32, err error) {
	req, err := client.AddSubListPreparer(ctx, appID, versionID, clEntityID, wordListCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddSubList", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddSubListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddSubList", resp, "Failure sending request")
		return
	}

	result, err = client.AddSubListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "AddSubList", resp, "Failure responding to request")
	}

	return
}

// AddSubListPreparer prepares the AddSubList request.
func (client ModelClient) AddSubListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, wordListCreateObject WordListObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}/sublists", pathParameters),
		autorest.WithJSON(wordListCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddSubListSender sends the AddSubList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddSubListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddSubListResponder handles the response to the AddSubList request. The method always
// closes the http.Response Body.
func (client ModelClient) AddSubListResponder(resp *http.Response) (result Int32, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteClosedList deletes a closed list model from the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the closed list model ID.
func (client ModelClient) DeleteClosedList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteClosedListPreparer(ctx, appID, versionID, clEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteClosedList", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteClosedListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteClosedList", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteClosedListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteClosedList", resp, "Failure responding to request")
	}

	return
}

// DeleteClosedListPreparer prepares the DeleteClosedList request.
func (client ModelClient) DeleteClosedListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteClosedListSender sends the DeleteClosedList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteClosedListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteClosedListResponder handles the response to the DeleteClosedList request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteClosedListResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCompositeEntity deletes a composite entity extractor from the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
func (client ModelClient) DeleteCompositeEntity(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteCompositeEntityPreparer(ctx, appID, versionID, cEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCompositeEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteCompositeEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCompositeEntity", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteCompositeEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCompositeEntity", resp, "Failure responding to request")
	}

	return
}

// DeleteCompositeEntityPreparer prepares the DeleteCompositeEntity request.
func (client ModelClient) DeleteCompositeEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCompositeEntitySender sends the DeleteCompositeEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteCompositeEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteCompositeEntityResponder handles the response to the DeleteCompositeEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteCompositeEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCompositeEntityChild deletes a composite entity extractor child from the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// cChildID - the hierarchical entity extractor child ID.
func (client ModelClient) DeleteCompositeEntityChild(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, cChildID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteCompositeEntityChildPreparer(ctx, appID, versionID, cEntityID, cChildID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCompositeEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteCompositeEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCompositeEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteCompositeEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCompositeEntityChild", resp, "Failure responding to request")
	}

	return
}

// DeleteCompositeEntityChildPreparer prepares the DeleteCompositeEntityChild request.
func (client ModelClient) DeleteCompositeEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, cChildID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cChildId":  autorest.Encode("path", cChildID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/children/{cChildId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCompositeEntityChildSender sends the DeleteCompositeEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteCompositeEntityChildSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteCompositeEntityChildResponder handles the response to the DeleteCompositeEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteCompositeEntityChildResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCustomPrebuiltDomain deletes a prebuilt domain's models from the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// domainName - domain name.
func (client ModelClient) DeleteCustomPrebuiltDomain(ctx context.Context, appID uuid.UUID, versionID string, domainName string) (result OperationStatus, err error) {
	req, err := client.DeleteCustomPrebuiltDomainPreparer(ctx, appID, versionID, domainName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCustomPrebuiltDomain", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteCustomPrebuiltDomainSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCustomPrebuiltDomain", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteCustomPrebuiltDomainResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteCustomPrebuiltDomain", resp, "Failure responding to request")
	}

	return
}

// DeleteCustomPrebuiltDomainPreparer prepares the DeleteCustomPrebuiltDomain request.
func (client ModelClient) DeleteCustomPrebuiltDomainPreparer(ctx context.Context, appID uuid.UUID, versionID string, domainName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"domainName": autorest.Encode("path", domainName),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltdomains/{domainName}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCustomPrebuiltDomainSender sends the DeleteCustomPrebuiltDomain request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteCustomPrebuiltDomainSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteCustomPrebuiltDomainResponder handles the response to the DeleteCustomPrebuiltDomain request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteCustomPrebuiltDomainResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteEntity deletes an entity extractor from the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity extractor ID.
func (client ModelClient) DeleteEntity(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteEntityPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteEntity", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteEntity", resp, "Failure responding to request")
	}

	return
}

// DeleteEntityPreparer prepares the DeleteEntity request.
func (client ModelClient) DeleteEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteEntitySender sends the DeleteEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteEntityResponder handles the response to the DeleteEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteHierarchicalEntity deletes a hierarchical entity extractor from the application version.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
func (client ModelClient) DeleteHierarchicalEntity(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteHierarchicalEntityPreparer(ctx, appID, versionID, hEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteHierarchicalEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHierarchicalEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteHierarchicalEntity", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHierarchicalEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteHierarchicalEntity", resp, "Failure responding to request")
	}

	return
}

// DeleteHierarchicalEntityPreparer prepares the DeleteHierarchicalEntity request.
func (client ModelClient) DeleteHierarchicalEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteHierarchicalEntitySender sends the DeleteHierarchicalEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteHierarchicalEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteHierarchicalEntityResponder handles the response to the DeleteHierarchicalEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteHierarchicalEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteHierarchicalEntityChild deletes a hierarchical entity extractor child from the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// hChildID - the hierarchical entity extractor child ID.
func (client ModelClient) DeleteHierarchicalEntityChild(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeleteHierarchicalEntityChildPreparer(ctx, appID, versionID, hEntityID, hChildID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteHierarchicalEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHierarchicalEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteHierarchicalEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHierarchicalEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteHierarchicalEntityChild", resp, "Failure responding to request")
	}

	return
}

// DeleteHierarchicalEntityChildPreparer prepares the DeleteHierarchicalEntityChild request.
func (client ModelClient) DeleteHierarchicalEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hChildId":  autorest.Encode("path", hChildID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/children/{hChildId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteHierarchicalEntityChildSender sends the DeleteHierarchicalEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteHierarchicalEntityChildSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteHierarchicalEntityChildResponder handles the response to the DeleteHierarchicalEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteHierarchicalEntityChildResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteIntent deletes an intent classifier from the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentID - the intent classifier ID.
// deleteUtterances - also delete the intent's utterances (true). Or move the utterances to the None intent
// (false - the default value).
func (client ModelClient) DeleteIntent(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, deleteUtterances *bool) (result OperationStatus, err error) {
	req, err := client.DeleteIntentPreparer(ctx, appID, versionID, intentID, deleteUtterances)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteIntent", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteIntentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteIntent", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteIntentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteIntent", resp, "Failure responding to request")
	}

	return
}

// DeleteIntentPreparer prepares the DeleteIntent request.
func (client ModelClient) DeleteIntentPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, deleteUtterances *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"intentId":  autorest.Encode("path", intentID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if deleteUtterances != nil {
		queryParameters["deleteUtterances"] = autorest.Encode("query", *deleteUtterances)
	} else {
		queryParameters["deleteUtterances"] = autorest.Encode("query", false)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents/{intentId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteIntentSender sends the DeleteIntent request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteIntentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteIntentResponder handles the response to the DeleteIntent request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteIntentResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeletePrebuilt deletes a prebuilt entity extractor from the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltID - the prebuilt entity extractor ID.
func (client ModelClient) DeletePrebuilt(ctx context.Context, appID uuid.UUID, versionID string, prebuiltID uuid.UUID) (result OperationStatus, err error) {
	req, err := client.DeletePrebuiltPreparer(ctx, appID, versionID, prebuiltID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeletePrebuilt", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePrebuiltSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeletePrebuilt", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePrebuiltResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeletePrebuilt", resp, "Failure responding to request")
	}

	return
}

// DeletePrebuiltPreparer prepares the DeletePrebuilt request.
func (client ModelClient) DeletePrebuiltPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"prebuiltId": autorest.Encode("path", prebuiltID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts/{prebuiltId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePrebuiltSender sends the DeletePrebuilt request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeletePrebuiltSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeletePrebuiltResponder handles the response to the DeletePrebuilt request. The method always
// closes the http.Response Body.
func (client ModelClient) DeletePrebuiltResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSubList deletes a sublist of a specific closed list model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the closed list entity extractor ID.
// subListID - the sublist ID.
func (client ModelClient) DeleteSubList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, subListID int32) (result OperationStatus, err error) {
	req, err := client.DeleteSubListPreparer(ctx, appID, versionID, clEntityID, subListID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteSubList", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSubListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteSubList", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSubListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "DeleteSubList", resp, "Failure responding to request")
	}

	return
}

// DeleteSubListPreparer prepares the DeleteSubList request.
func (client ModelClient) DeleteSubListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, subListID int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"subListId":  autorest.Encode("path", subListID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}/sublists/{subListId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSubListSender sends the DeleteSubList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteSubListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteSubListResponder handles the response to the DeleteSubList request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteSubListResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetClosedList gets information of a closed list model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the closed list model ID.
func (client ModelClient) GetClosedList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID) (result ClosedListEntityExtractor, err error) {
	req, err := client.GetClosedListPreparer(ctx, appID, versionID, clEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetClosedList", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetClosedListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetClosedList", resp, "Failure sending request")
		return
	}

	result, err = client.GetClosedListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetClosedList", resp, "Failure responding to request")
	}

	return
}

// GetClosedListPreparer prepares the GetClosedList request.
func (client ModelClient) GetClosedListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetClosedListSender sends the GetClosedList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetClosedListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetClosedListResponder handles the response to the GetClosedList request. The method always
// closes the http.Response Body.
func (client ModelClient) GetClosedListResponder(resp *http.Response) (result ClosedListEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCompositeEntity gets information about the composite entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
func (client ModelClient) GetCompositeEntity(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID) (result CompositeEntityExtractor, err error) {
	req, err := client.GetCompositeEntityPreparer(ctx, appID, versionID, cEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCompositeEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCompositeEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCompositeEntity", resp, "Failure sending request")
		return
	}

	result, err = client.GetCompositeEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetCompositeEntity", resp, "Failure responding to request")
	}

	return
}

// GetCompositeEntityPreparer prepares the GetCompositeEntity request.
func (client ModelClient) GetCompositeEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCompositeEntitySender sends the GetCompositeEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetCompositeEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetCompositeEntityResponder handles the response to the GetCompositeEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) GetCompositeEntityResponder(resp *http.Response) (result CompositeEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetEntity gets information about the entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity extractor ID.
func (client ModelClient) GetEntity(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result EntityExtractor, err error) {
	req, err := client.GetEntityPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntity", resp, "Failure sending request")
		return
	}

	result, err = client.GetEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntity", resp, "Failure responding to request")
	}

	return
}

// GetEntityPreparer prepares the GetEntity request.
func (client ModelClient) GetEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetEntitySender sends the GetEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetEntityResponder handles the response to the GetEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) GetEntityResponder(resp *http.Response) (result EntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetEntitySuggestions get suggestion examples that would improve the accuracy of the entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the target entity extractor model to enhance.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) GetEntitySuggestions(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, take *int32) (result ListEntitiesSuggestionExample, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "GetEntitySuggestions", err.Error())
	}

	req, err := client.GetEntitySuggestionsPreparer(ctx, appID, versionID, entityID, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntitySuggestions", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetEntitySuggestionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntitySuggestions", resp, "Failure sending request")
		return
	}

	result, err = client.GetEntitySuggestionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetEntitySuggestions", resp, "Failure responding to request")
	}

	return
}

// GetEntitySuggestionsPreparer prepares the GetEntitySuggestions request.
func (client ModelClient) GetEntitySuggestionsPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/suggest", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetEntitySuggestionsSender sends the GetEntitySuggestions request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetEntitySuggestionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetEntitySuggestionsResponder handles the response to the GetEntitySuggestions request. The method always
// closes the http.Response Body.
func (client ModelClient) GetEntitySuggestionsResponder(resp *http.Response) (result ListEntitiesSuggestionExample, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHierarchicalEntity gets information about the hierarchical entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
func (client ModelClient) GetHierarchicalEntity(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID) (result HierarchicalEntityExtractor, err error) {
	req, err := client.GetHierarchicalEntityPreparer(ctx, appID, versionID, hEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHierarchicalEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntity", resp, "Failure sending request")
		return
	}

	result, err = client.GetHierarchicalEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntity", resp, "Failure responding to request")
	}

	return
}

// GetHierarchicalEntityPreparer prepares the GetHierarchicalEntity request.
func (client ModelClient) GetHierarchicalEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHierarchicalEntitySender sends the GetHierarchicalEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetHierarchicalEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetHierarchicalEntityResponder handles the response to the GetHierarchicalEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) GetHierarchicalEntityResponder(resp *http.Response) (result HierarchicalEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHierarchicalEntityChild gets information about the hierarchical entity child model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// hChildID - the hierarchical entity extractor child ID.
func (client ModelClient) GetHierarchicalEntityChild(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID) (result HierarchicalChildEntity, err error) {
	req, err := client.GetHierarchicalEntityChildPreparer(ctx, appID, versionID, hEntityID, hChildID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHierarchicalEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.GetHierarchicalEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetHierarchicalEntityChild", resp, "Failure responding to request")
	}

	return
}

// GetHierarchicalEntityChildPreparer prepares the GetHierarchicalEntityChild request.
func (client ModelClient) GetHierarchicalEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hChildId":  autorest.Encode("path", hChildID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/children/{hChildId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHierarchicalEntityChildSender sends the GetHierarchicalEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetHierarchicalEntityChildSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetHierarchicalEntityChildResponder handles the response to the GetHierarchicalEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) GetHierarchicalEntityChildResponder(resp *http.Response) (result HierarchicalChildEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetIntent gets information about the intent model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentID - the intent classifier ID.
func (client ModelClient) GetIntent(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID) (result IntentClassifier, err error) {
	req, err := client.GetIntentPreparer(ctx, appID, versionID, intentID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetIntent", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetIntentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetIntent", resp, "Failure sending request")
		return
	}

	result, err = client.GetIntentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetIntent", resp, "Failure responding to request")
	}

	return
}

// GetIntentPreparer prepares the GetIntent request.
func (client ModelClient) GetIntentPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"intentId":  autorest.Encode("path", intentID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents/{intentId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetIntentSender sends the GetIntent request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetIntentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetIntentResponder handles the response to the GetIntent request. The method always
// closes the http.Response Body.
func (client ModelClient) GetIntentResponder(resp *http.Response) (result IntentClassifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetIntentSuggestions suggests examples that would improve the accuracy of the intent model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentID - the intent classifier ID.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) GetIntentSuggestions(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, take *int32) (result ListIntentsSuggestionExample, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "GetIntentSuggestions", err.Error())
	}

	req, err := client.GetIntentSuggestionsPreparer(ctx, appID, versionID, intentID, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetIntentSuggestions", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetIntentSuggestionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetIntentSuggestions", resp, "Failure sending request")
		return
	}

	result, err = client.GetIntentSuggestionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetIntentSuggestions", resp, "Failure responding to request")
	}

	return
}

// GetIntentSuggestionsPreparer prepares the GetIntentSuggestions request.
func (client ModelClient) GetIntentSuggestionsPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"intentId":  autorest.Encode("path", intentID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents/{intentId}/suggest", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetIntentSuggestionsSender sends the GetIntentSuggestions request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetIntentSuggestionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetIntentSuggestionsResponder handles the response to the GetIntentSuggestions request. The method always
// closes the http.Response Body.
func (client ModelClient) GetIntentSuggestionsResponder(resp *http.Response) (result ListIntentsSuggestionExample, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPrebuilt gets information about the prebuilt entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltID - the prebuilt entity extractor ID.
func (client ModelClient) GetPrebuilt(ctx context.Context, appID uuid.UUID, versionID string, prebuiltID uuid.UUID) (result PrebuiltEntityExtractor, err error) {
	req, err := client.GetPrebuiltPreparer(ctx, appID, versionID, prebuiltID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPrebuilt", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPrebuiltSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPrebuilt", resp, "Failure sending request")
		return
	}

	result, err = client.GetPrebuiltResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "GetPrebuilt", resp, "Failure responding to request")
	}

	return
}

// GetPrebuiltPreparer prepares the GetPrebuilt request.
func (client ModelClient) GetPrebuiltPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"prebuiltId": autorest.Encode("path", prebuiltID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts/{prebuiltId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPrebuiltSender sends the GetPrebuilt request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetPrebuiltSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetPrebuiltResponder handles the response to the GetPrebuilt request. The method always
// closes the http.Response Body.
func (client ModelClient) GetPrebuiltResponder(resp *http.Response) (result PrebuiltEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListClosedLists gets information about the closedlist models.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListClosedLists(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListClosedListEntityExtractor, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "ListClosedLists", err.Error())
	}

	req, err := client.ListClosedListsPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListClosedLists", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListClosedListsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListClosedLists", resp, "Failure sending request")
		return
	}

	result, err = client.ListClosedListsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListClosedLists", resp, "Failure responding to request")
	}

	return
}

// ListClosedListsPreparer prepares the ListClosedLists request.
func (client ModelClient) ListClosedListsPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListClosedListsSender sends the ListClosedLists request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListClosedListsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListClosedListsResponder handles the response to the ListClosedLists request. The method always
// closes the http.Response Body.
func (client ModelClient) ListClosedListsResponder(resp *http.Response) (result ListClosedListEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCompositeEntities gets information about the composite entity models.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListCompositeEntities(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListCompositeEntityExtractor, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "ListCompositeEntities", err.Error())
	}

	req, err := client.ListCompositeEntitiesPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCompositeEntities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCompositeEntitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCompositeEntities", resp, "Failure sending request")
		return
	}

	result, err = client.ListCompositeEntitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCompositeEntities", resp, "Failure responding to request")
	}

	return
}

// ListCompositeEntitiesPreparer prepares the ListCompositeEntities request.
func (client ModelClient) ListCompositeEntitiesPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCompositeEntitiesSender sends the ListCompositeEntities request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListCompositeEntitiesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListCompositeEntitiesResponder handles the response to the ListCompositeEntities request. The method always
// closes the http.Response Body.
func (client ModelClient) ListCompositeEntitiesResponder(resp *http.Response) (result ListCompositeEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCustomPrebuiltEntities gets all custom prebuilt entities information of this application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
func (client ModelClient) ListCustomPrebuiltEntities(ctx context.Context, appID uuid.UUID, versionID string) (result ListEntityExtractor, err error) {
	req, err := client.ListCustomPrebuiltEntitiesPreparer(ctx, appID, versionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltEntities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCustomPrebuiltEntitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltEntities", resp, "Failure sending request")
		return
	}

	result, err = client.ListCustomPrebuiltEntitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltEntities", resp, "Failure responding to request")
	}

	return
}

// ListCustomPrebuiltEntitiesPreparer prepares the ListCustomPrebuiltEntities request.
func (client ModelClient) ListCustomPrebuiltEntitiesPreparer(ctx context.Context, appID uuid.UUID, versionID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltentities", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCustomPrebuiltEntitiesSender sends the ListCustomPrebuiltEntities request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListCustomPrebuiltEntitiesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListCustomPrebuiltEntitiesResponder handles the response to the ListCustomPrebuiltEntities request. The method always
// closes the http.Response Body.
func (client ModelClient) ListCustomPrebuiltEntitiesResponder(resp *http.Response) (result ListEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCustomPrebuiltIntents gets custom prebuilt intents information of this application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
func (client ModelClient) ListCustomPrebuiltIntents(ctx context.Context, appID uuid.UUID, versionID string) (result ListIntentClassifier, err error) {
	req, err := client.ListCustomPrebuiltIntentsPreparer(ctx, appID, versionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltIntents", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCustomPrebuiltIntentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltIntents", resp, "Failure sending request")
		return
	}

	result, err = client.ListCustomPrebuiltIntentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltIntents", resp, "Failure responding to request")
	}

	return
}

// ListCustomPrebuiltIntentsPreparer prepares the ListCustomPrebuiltIntents request.
func (client ModelClient) ListCustomPrebuiltIntentsPreparer(ctx context.Context, appID uuid.UUID, versionID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltintents", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCustomPrebuiltIntentsSender sends the ListCustomPrebuiltIntents request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListCustomPrebuiltIntentsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListCustomPrebuiltIntentsResponder handles the response to the ListCustomPrebuiltIntents request. The method always
// closes the http.Response Body.
func (client ModelClient) ListCustomPrebuiltIntentsResponder(resp *http.Response) (result ListIntentClassifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCustomPrebuiltModels gets all custom prebuilt models information of this application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
func (client ModelClient) ListCustomPrebuiltModels(ctx context.Context, appID uuid.UUID, versionID string) (result ListCustomPrebuiltModel, err error) {
	req, err := client.ListCustomPrebuiltModelsPreparer(ctx, appID, versionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltModels", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCustomPrebuiltModelsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltModels", resp, "Failure sending request")
		return
	}

	result, err = client.ListCustomPrebuiltModelsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListCustomPrebuiltModels", resp, "Failure responding to request")
	}

	return
}

// ListCustomPrebuiltModelsPreparer prepares the ListCustomPrebuiltModels request.
func (client ModelClient) ListCustomPrebuiltModelsPreparer(ctx context.Context, appID uuid.UUID, versionID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltmodels", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCustomPrebuiltModelsSender sends the ListCustomPrebuiltModels request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListCustomPrebuiltModelsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListCustomPrebuiltModelsResponder handles the response to the ListCustomPrebuiltModels request. The method always
// closes the http.Response Body.
func (client ModelClient) ListCustomPrebuiltModelsResponder(resp *http.Response) (result ListCustomPrebuiltModel, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListEntities gets information about the entity models.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListEntities(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListEntityExtractor, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "ListEntities", err.Error())
	}

	req, err := client.ListEntitiesPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListEntities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListEntitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListEntities", resp, "Failure sending request")
		return
	}

	result, err = client.ListEntitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListEntities", resp, "Failure responding to request")
	}

	return
}

// ListEntitiesPreparer prepares the ListEntities request.
func (client ModelClient) ListEntitiesPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListEntitiesSender sends the ListEntities request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListEntitiesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListEntitiesResponder handles the response to the ListEntities request. The method always
// closes the http.Response Body.
func (client ModelClient) ListEntitiesResponder(resp *http.Response) (result ListEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHierarchicalEntities gets information about the hierarchical entity models.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListHierarchicalEntities(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListHierarchicalEntityExtractor, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "ListHierarchicalEntities", err.Error())
	}

	req, err := client.ListHierarchicalEntitiesPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListHierarchicalEntities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHierarchicalEntitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListHierarchicalEntities", resp, "Failure sending request")
		return
	}

	result, err = client.ListHierarchicalEntitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListHierarchicalEntities", resp, "Failure responding to request")
	}

	return
}

// ListHierarchicalEntitiesPreparer prepares the ListHierarchicalEntities request.
func (client ModelClient) ListHierarchicalEntitiesPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListHierarchicalEntitiesSender sends the ListHierarchicalEntities request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListHierarchicalEntitiesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListHierarchicalEntitiesResponder handles the response to the ListHierarchicalEntities request. The method always
// closes the http.Response Body.
func (client ModelClient) ListHierarchicalEntitiesResponder(resp *http.Response) (result ListHierarchicalEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListIntents gets information about the intent models.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListIntents(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListIntentClassifier, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "ListIntents", err.Error())
	}

	req, err := client.ListIntentsPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListIntents", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListIntentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListIntents", resp, "Failure sending request")
		return
	}

	result, err = client.ListIntentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListIntents", resp, "Failure responding to request")
	}

	return
}

// ListIntentsPreparer prepares the ListIntents request.
func (client ModelClient) ListIntentsPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListIntentsSender sends the ListIntents request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListIntentsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListIntentsResponder handles the response to the ListIntents request. The method always
// closes the http.Response Body.
func (client ModelClient) ListIntentsResponder(resp *http.Response) (result ListIntentClassifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListModels gets information about the application version models.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListModels(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListModelInfoResponse, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "ListModels", err.Error())
	}

	req, err := client.ListModelsPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListModels", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListModelsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListModels", resp, "Failure sending request")
		return
	}

	result, err = client.ListModelsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListModels", resp, "Failure responding to request")
	}

	return
}

// ListModelsPreparer prepares the ListModels request.
func (client ModelClient) ListModelsPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/models", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListModelsSender sends the ListModels request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListModelsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListModelsResponder handles the response to the ListModels request. The method always
// closes the http.Response Body.
func (client ModelClient) ListModelsResponder(resp *http.Response) (result ListModelInfoResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPrebuiltEntities gets all the available prebuilt entity extractors for the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
func (client ModelClient) ListPrebuiltEntities(ctx context.Context, appID uuid.UUID, versionID string) (result ListAvailablePrebuiltEntityModel, err error) {
	req, err := client.ListPrebuiltEntitiesPreparer(ctx, appID, versionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListPrebuiltEntities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPrebuiltEntitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListPrebuiltEntities", resp, "Failure sending request")
		return
	}

	result, err = client.ListPrebuiltEntitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListPrebuiltEntities", resp, "Failure responding to request")
	}

	return
}

// ListPrebuiltEntitiesPreparer prepares the ListPrebuiltEntities request.
func (client ModelClient) ListPrebuiltEntitiesPreparer(ctx context.Context, appID uuid.UUID, versionID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/listprebuilts", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPrebuiltEntitiesSender sends the ListPrebuiltEntities request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListPrebuiltEntitiesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListPrebuiltEntitiesResponder handles the response to the ListPrebuiltEntities request. The method always
// closes the http.Response Body.
func (client ModelClient) ListPrebuiltEntitiesResponder(resp *http.Response) (result ListAvailablePrebuiltEntityModel, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPrebuilts gets information about the prebuilt entity models.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListPrebuilts(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListPrebuiltEntityExtractor, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: 500, Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("programmatic.ModelClient", "ListPrebuilts", err.Error())
	}

	req, err := client.ListPrebuiltsPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListPrebuilts", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPrebuiltsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListPrebuilts", resp, "Failure sending request")
		return
	}

	result, err = client.ListPrebuiltsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "ListPrebuilts", resp, "Failure responding to request")
	}

	return
}

// ListPrebuiltsPreparer prepares the ListPrebuilts request.
func (client ModelClient) ListPrebuiltsPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPrebuiltsSender sends the ListPrebuilts request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListPrebuiltsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListPrebuiltsResponder handles the response to the ListPrebuilts request. The method always
// closes the http.Response Body.
func (client ModelClient) ListPrebuiltsResponder(resp *http.Response) (result ListPrebuiltEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// PatchClosedList adds a batch of sublists to an existing closedlist.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the closed list model ID.
// closedListModelPatchObject - a words list batch.
func (client ModelClient) PatchClosedList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, closedListModelPatchObject ClosedListModelPatchObject) (result OperationStatus, err error) {
	req, err := client.PatchClosedListPreparer(ctx, appID, versionID, clEntityID, closedListModelPatchObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "PatchClosedList", nil, "Failure preparing request")
		return
	}

	resp, err := client.PatchClosedListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "PatchClosedList", resp, "Failure sending request")
		return
	}

	result, err = client.PatchClosedListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "PatchClosedList", resp, "Failure responding to request")
	}

	return
}

// PatchClosedListPreparer prepares the PatchClosedList request.
func (client ModelClient) PatchClosedListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, closedListModelPatchObject ClosedListModelPatchObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}", pathParameters),
		autorest.WithJSON(closedListModelPatchObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PatchClosedListSender sends the PatchClosedList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) PatchClosedListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// PatchClosedListResponder handles the response to the PatchClosedList request. The method always
// closes the http.Response Body.
func (client ModelClient) PatchClosedListResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateClosedList updates the closed list model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the closed list model ID.
// closedListModelUpdateObject - the new entity name and words list.
func (client ModelClient) UpdateClosedList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, closedListModelUpdateObject ClosedListModelUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateClosedListPreparer(ctx, appID, versionID, clEntityID, closedListModelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateClosedList", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateClosedListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateClosedList", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateClosedListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateClosedList", resp, "Failure responding to request")
	}

	return
}

// UpdateClosedListPreparer prepares the UpdateClosedList request.
func (client ModelClient) UpdateClosedListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, closedListModelUpdateObject ClosedListModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}", pathParameters),
		autorest.WithJSON(closedListModelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateClosedListSender sends the UpdateClosedList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateClosedListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateClosedListResponder handles the response to the UpdateClosedList request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateClosedListResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateCompositeEntity updates the composite entity extractor.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// compositeModelUpdateObject - a model object containing the new entity extractor name and children.
func (client ModelClient) UpdateCompositeEntity(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, compositeModelUpdateObject CompositeEntityModel) (result OperationStatus, err error) {
	req, err := client.UpdateCompositeEntityPreparer(ctx, appID, versionID, cEntityID, compositeModelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateCompositeEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateCompositeEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateCompositeEntity", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateCompositeEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateCompositeEntity", resp, "Failure responding to request")
	}

	return
}

// UpdateCompositeEntityPreparer prepares the UpdateCompositeEntity request.
func (client ModelClient) UpdateCompositeEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, compositeModelUpdateObject CompositeEntityModel) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}", pathParameters),
		autorest.WithJSON(compositeModelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateCompositeEntitySender sends the UpdateCompositeEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateCompositeEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateCompositeEntityResponder handles the response to the UpdateCompositeEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateCompositeEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateEntity updates the name of an entity extractor.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity extractor ID.
// modelUpdateObject - a model object containing the new entity extractor name.
func (client ModelClient) UpdateEntity(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, modelUpdateObject ModelUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateEntityPreparer(ctx, appID, versionID, entityID, modelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateEntity", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateEntity", resp, "Failure responding to request")
	}

	return
}

// UpdateEntityPreparer prepares the UpdateEntity request.
func (client ModelClient) UpdateEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, modelUpdateObject ModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}", pathParameters),
		autorest.WithJSON(modelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateEntitySender sends the UpdateEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateEntityResponder handles the response to the UpdateEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateHierarchicalEntity updates the name and children of a hierarchical entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// hierarchicalModelUpdateObject - model containing names of the children of the hierarchical entity.
func (client ModelClient) UpdateHierarchicalEntity(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hierarchicalModelUpdateObject HierarchicalEntityModel) (result OperationStatus, err error) {
	req, err := client.UpdateHierarchicalEntityPreparer(ctx, appID, versionID, hEntityID, hierarchicalModelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateHierarchicalEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateHierarchicalEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateHierarchicalEntity", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateHierarchicalEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateHierarchicalEntity", resp, "Failure responding to request")
	}

	return
}

// UpdateHierarchicalEntityPreparer prepares the UpdateHierarchicalEntity request.
func (client ModelClient) UpdateHierarchicalEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hierarchicalModelUpdateObject HierarchicalEntityModel) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}", pathParameters),
		autorest.WithJSON(hierarchicalModelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateHierarchicalEntitySender sends the UpdateHierarchicalEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateHierarchicalEntitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateHierarchicalEntityResponder handles the response to the UpdateHierarchicalEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateHierarchicalEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateHierarchicalEntityChild renames a single child in an existing hierarchical entity model.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// hChildID - the hierarchical entity extractor child ID.
// hierarchicalChildModelUpdateObject - model object containing new name of the hierarchical entity child.
func (client ModelClient) UpdateHierarchicalEntityChild(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID, hierarchicalChildModelUpdateObject HierarchicalChildModelUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateHierarchicalEntityChildPreparer(ctx, appID, versionID, hEntityID, hChildID, hierarchicalChildModelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateHierarchicalEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateHierarchicalEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateHierarchicalEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateHierarchicalEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateHierarchicalEntityChild", resp, "Failure responding to request")
	}

	return
}

// UpdateHierarchicalEntityChildPreparer prepares the UpdateHierarchicalEntityChild request.
func (client ModelClient) UpdateHierarchicalEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID, hierarchicalChildModelUpdateObject HierarchicalChildModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hChildId":  autorest.Encode("path", hChildID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/children/{hChildId}", pathParameters),
		autorest.WithJSON(hierarchicalChildModelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateHierarchicalEntityChildSender sends the UpdateHierarchicalEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateHierarchicalEntityChildSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateHierarchicalEntityChildResponder handles the response to the UpdateHierarchicalEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateHierarchicalEntityChildResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateIntent updates the name of an intent classifier.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentID - the intent classifier ID.
// modelUpdateObject - a model object containing the new intent classifier name.
func (client ModelClient) UpdateIntent(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, modelUpdateObject ModelUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateIntentPreparer(ctx, appID, versionID, intentID, modelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateIntent", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateIntentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateIntent", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateIntentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateIntent", resp, "Failure responding to request")
	}

	return
}

// UpdateIntentPreparer prepares the UpdateIntent request.
func (client ModelClient) UpdateIntentPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, modelUpdateObject ModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"intentId":  autorest.Encode("path", intentID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents/{intentId}", pathParameters),
		autorest.WithJSON(modelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateIntentSender sends the UpdateIntent request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateIntentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateIntentResponder handles the response to the UpdateIntent request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateIntentResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSubList updates one of the closed list's sublists.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the closed list entity extractor ID.
// subListID - the sublist ID.
// wordListBaseUpdateObject - a sublist update object containing the new canonical form and the list of words.
func (client ModelClient) UpdateSubList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, subListID int32, wordListBaseUpdateObject WordListBaseUpdateObject) (result OperationStatus, err error) {
	req, err := client.UpdateSubListPreparer(ctx, appID, versionID, clEntityID, subListID, wordListBaseUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateSubList", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSubListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateSubList", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSubListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "programmatic.ModelClient", "UpdateSubList", resp, "Failure responding to request")
	}

	return
}

// UpdateSubListPreparer prepares the UpdateSubList request.
func (client ModelClient) UpdateSubListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, subListID int32, wordListBaseUpdateObject WordListBaseUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"subListId":  autorest.Encode("path", subListID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}/sublists/{subListId}", pathParameters),
		autorest.WithJSON(wordListBaseUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSubListSender sends the UpdateSubList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateSubListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateSubListResponder handles the response to the UpdateSubList request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateSubListResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
