package fabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// NetworkFabricOperationsClient is the fabric Admin Client
type NetworkFabricOperationsClient struct {
	BaseClient
}

// NewNetworkFabricOperationsClient creates an instance of the NetworkFabricOperationsClient client.
func NewNetworkFabricOperationsClient(subscriptionID string) NetworkFabricOperationsClient {
	return NewNetworkFabricOperationsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewNetworkFabricOperationsClientWithBaseURI creates an instance of the NetworkFabricOperationsClient client.
func NewNetworkFabricOperationsClientWithBaseURI(baseURI string, subscriptionID string) NetworkFabricOperationsClient {
	return NetworkFabricOperationsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get the status of a network fabric operation.
//
// location is location of the resource. provider is name of the provider. networkOperationResult is id of a
// network fabric operation.
func (client NetworkFabricOperationsClient) Get(ctx context.Context, location string, provider string, networkOperationResult string) (result OperationStatus, err error) {
	req, err := client.GetPreparer(ctx, location, provider, networkOperationResult)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.NetworkFabricOperationsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "fabric.NetworkFabricOperationsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.NetworkFabricOperationsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client NetworkFabricOperationsClient) GetPreparer(ctx context.Context, location string, provider string, networkOperationResult string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":               autorest.Encode("path", location),
		"networkOperationResult": autorest.Encode("path", networkOperationResult),
		"provider":               autorest.Encode("path", provider),
		"subscriptionId":         autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/System.{location}/providers/{provider}/fabricLocations/{location}/networkOperationResults/{networkOperationResult}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client NetworkFabricOperationsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client NetworkFabricOperationsClient) GetResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
