// Copyright (C) MongoDB, Inc. 2019-present.
//
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0

// Code generated by operationgen. DO NOT EDIT.

package operation

import (
	"context"
	"errors"
	"fmt"

	"go.mongodb.org/mongo-driver/event"
	"go.mongodb.org/mongo-driver/mongo/writeconcern"
	"go.mongodb.org/mongo-driver/x/bsonx/bsoncore"
	"go.mongodb.org/mongo-driver/x/mongo/driver"
	"go.mongodb.org/mongo-driver/x/mongo/driver/description"
	"go.mongodb.org/mongo-driver/x/mongo/driver/session"
)

// DropCollection performs a drop operation.
type DropCollection struct {
	session      *session.Client
	clock        *session.ClusterClock
	collection   string
	monitor      *event.CommandMonitor
	database     string
	deployment   driver.Deployment
	selector     description.ServerSelector
	writeConcern *writeconcern.WriteConcern
	result       DropCollectionResult
}

type DropCollectionResult struct {
	// The number of indexes in the dropped collection.
	NIndexesWas int32
	// The namespace of the dropped collection.
	Ns string
}

func buildDropCollectionResult(response bsoncore.Document, srvr driver.Server) (DropCollectionResult, error) {
	elements, err := response.Elements()
	if err != nil {
		return DropCollectionResult{}, err
	}
	dcr := DropCollectionResult{}
	for _, element := range elements {
		switch element.Key() {
		case "nIndexesWas":
			var ok bool
			dcr.NIndexesWas, ok = element.Value().AsInt32OK()
			if !ok {
				err = fmt.Errorf("response field 'nIndexesWas' is type int32, but received BSON type %s", element.Value().Type)
			}
		case "ns":
			var ok bool
			dcr.Ns, ok = element.Value().StringValueOK()
			if !ok {
				err = fmt.Errorf("response field 'ns' is type string, but received BSON type %s", element.Value().Type)
			}
		}
	}
	return dcr, nil
}

// NewDropCollection constructs and returns a new DropCollection.
func NewDropCollection() *DropCollection {
	return &DropCollection{}
}

// Result returns the result of executing this operation.
func (dc *DropCollection) Result() DropCollectionResult { return dc.result }

func (dc *DropCollection) processResponse(response bsoncore.Document, srvr driver.Server, desc description.Server) error {
	var err error
	dc.result, err = buildDropCollectionResult(response, srvr)
	return err
}

// Execute runs this operations and returns an error if the operaiton did not execute successfully.
func (dc *DropCollection) Execute(ctx context.Context) error {
	if dc.deployment == nil {
		return errors.New("the DropCollection operation must have a Deployment set before Execute can be called")
	}

	return driver.Operation{
		CommandFn:         dc.command,
		ProcessResponseFn: dc.processResponse,
		Client:            dc.session,
		Clock:             dc.clock,
		CommandMonitor:    dc.monitor,
		Database:          dc.database,
		Deployment:        dc.deployment,
		Selector:          dc.selector,
		WriteConcern:      dc.writeConcern,
	}.Execute(ctx, nil)

}

func (dc *DropCollection) command(dst []byte, desc description.SelectedServer) ([]byte, error) {
	dst = bsoncore.AppendStringElement(dst, "drop", dc.collection)
	return dst, nil
}

// Session sets the session for this operation.
func (dc *DropCollection) Session(session *session.Client) *DropCollection {
	if dc == nil {
		dc = new(DropCollection)
	}

	dc.session = session
	return dc
}

// ClusterClock sets the cluster clock for this operation.
func (dc *DropCollection) ClusterClock(clock *session.ClusterClock) *DropCollection {
	if dc == nil {
		dc = new(DropCollection)
	}

	dc.clock = clock
	return dc
}

// Collection sets the collection that this command will run against.
func (dc *DropCollection) Collection(collection string) *DropCollection {
	if dc == nil {
		dc = new(DropCollection)
	}

	dc.collection = collection
	return dc
}

// CommandMonitor sets the monitor to use for APM events.
func (dc *DropCollection) CommandMonitor(monitor *event.CommandMonitor) *DropCollection {
	if dc == nil {
		dc = new(DropCollection)
	}

	dc.monitor = monitor
	return dc
}

// Database sets the database to run this operation against.
func (dc *DropCollection) Database(database string) *DropCollection {
	if dc == nil {
		dc = new(DropCollection)
	}

	dc.database = database
	return dc
}

// Deployment sets the deployment to use for this operation.
func (dc *DropCollection) Deployment(deployment driver.Deployment) *DropCollection {
	if dc == nil {
		dc = new(DropCollection)
	}

	dc.deployment = deployment
	return dc
}

// ServerSelector sets the selector used to retrieve a server.
func (dc *DropCollection) ServerSelector(selector description.ServerSelector) *DropCollection {
	if dc == nil {
		dc = new(DropCollection)
	}

	dc.selector = selector
	return dc
}

// WriteConcern sets the write concern for this operation.
func (dc *DropCollection) WriteConcern(writeConcern *writeconcern.WriteConcern) *DropCollection {
	if dc == nil {
		dc = new(DropCollection)
	}

	dc.writeConcern = writeConcern
	return dc
}
