// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/servicemanagement/v1/servicemanager.proto

package servicemanagement

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	any "github.com/golang/protobuf/ptypes/any"
	_ "github.com/golang/protobuf/ptypes/struct"
	context "golang.org/x/net/context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	serviceconfig "google.golang.org/genproto/googleapis/api/serviceconfig"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	_ "google.golang.org/genproto/googleapis/rpc/status"
	_ "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type GetServiceConfigRequest_ConfigView int32

const (
	// Server response includes all fields except SourceInfo.
	GetServiceConfigRequest_BASIC GetServiceConfigRequest_ConfigView = 0
	// Server response includes all fields including SourceInfo.
	// SourceFiles are of type 'google.api.servicemanagement.v1.ConfigFile'
	// and are only available for configs created using the
	// SubmitConfigSource method.
	GetServiceConfigRequest_FULL GetServiceConfigRequest_ConfigView = 1
)

var GetServiceConfigRequest_ConfigView_name = map[int32]string{
	0: "BASIC",
	1: "FULL",
}

var GetServiceConfigRequest_ConfigView_value = map[string]int32{
	"BASIC": 0,
	"FULL":  1,
}

func (x GetServiceConfigRequest_ConfigView) String() string {
	return proto.EnumName(GetServiceConfigRequest_ConfigView_name, int32(x))
}

func (GetServiceConfigRequest_ConfigView) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{7, 0}
}

// Request message for `ListServices` method.
type ListServicesRequest struct {
	// Include services produced by the specified project.
	ProducerProjectId string `protobuf:"bytes,1,opt,name=producer_project_id,json=producerProjectId,proto3" json:"producer_project_id,omitempty"`
	// Requested size of the next page of data.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token identifying which result to start with; returned by a previous list
	// call.
	PageToken string `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Include services consumed by the specified consumer.
	//
	// The Google Service Management implementation accepts the following
	// forms:
	// - project:<project_id>
	ConsumerId           string   `protobuf:"bytes,7,opt,name=consumer_id,json=consumerId,proto3" json:"consumer_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServicesRequest) Reset()         { *m = ListServicesRequest{} }
func (m *ListServicesRequest) String() string { return proto.CompactTextString(m) }
func (*ListServicesRequest) ProtoMessage()    {}
func (*ListServicesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{0}
}

func (m *ListServicesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServicesRequest.Unmarshal(m, b)
}
func (m *ListServicesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServicesRequest.Marshal(b, m, deterministic)
}
func (m *ListServicesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServicesRequest.Merge(m, src)
}
func (m *ListServicesRequest) XXX_Size() int {
	return xxx_messageInfo_ListServicesRequest.Size(m)
}
func (m *ListServicesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServicesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListServicesRequest proto.InternalMessageInfo

func (m *ListServicesRequest) GetProducerProjectId() string {
	if m != nil {
		return m.ProducerProjectId
	}
	return ""
}

func (m *ListServicesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListServicesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListServicesRequest) GetConsumerId() string {
	if m != nil {
		return m.ConsumerId
	}
	return ""
}

// Response message for `ListServices` method.
type ListServicesResponse struct {
	// The returned services will only have the name field set.
	Services []*ManagedService `protobuf:"bytes,1,rep,name=services,proto3" json:"services,omitempty"`
	// Token that can be passed to `ListServices` to resume a paginated query.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServicesResponse) Reset()         { *m = ListServicesResponse{} }
func (m *ListServicesResponse) String() string { return proto.CompactTextString(m) }
func (*ListServicesResponse) ProtoMessage()    {}
func (*ListServicesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{1}
}

func (m *ListServicesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServicesResponse.Unmarshal(m, b)
}
func (m *ListServicesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServicesResponse.Marshal(b, m, deterministic)
}
func (m *ListServicesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServicesResponse.Merge(m, src)
}
func (m *ListServicesResponse) XXX_Size() int {
	return xxx_messageInfo_ListServicesResponse.Size(m)
}
func (m *ListServicesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServicesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListServicesResponse proto.InternalMessageInfo

func (m *ListServicesResponse) GetServices() []*ManagedService {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *ListServicesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for `GetService` method.
type GetServiceRequest struct {
	// The name of the service.  See the `ServiceManager` overview for naming
	// requirements.  For example: `example.googleapis.com`.
	ServiceName          string   `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServiceRequest) Reset()         { *m = GetServiceRequest{} }
func (m *GetServiceRequest) String() string { return proto.CompactTextString(m) }
func (*GetServiceRequest) ProtoMessage()    {}
func (*GetServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{2}
}

func (m *GetServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServiceRequest.Unmarshal(m, b)
}
func (m *GetServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServiceRequest.Marshal(b, m, deterministic)
}
func (m *GetServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServiceRequest.Merge(m, src)
}
func (m *GetServiceRequest) XXX_Size() int {
	return xxx_messageInfo_GetServiceRequest.Size(m)
}
func (m *GetServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServiceRequest proto.InternalMessageInfo

func (m *GetServiceRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

// Request message for CreateService method.
type CreateServiceRequest struct {
	// Initial values for the service resource.
	Service              *ManagedService `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *CreateServiceRequest) Reset()         { *m = CreateServiceRequest{} }
func (m *CreateServiceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateServiceRequest) ProtoMessage()    {}
func (*CreateServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{3}
}

func (m *CreateServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateServiceRequest.Unmarshal(m, b)
}
func (m *CreateServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateServiceRequest.Marshal(b, m, deterministic)
}
func (m *CreateServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateServiceRequest.Merge(m, src)
}
func (m *CreateServiceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateServiceRequest.Size(m)
}
func (m *CreateServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateServiceRequest proto.InternalMessageInfo

func (m *CreateServiceRequest) GetService() *ManagedService {
	if m != nil {
		return m.Service
	}
	return nil
}

// Request message for DeleteService method.
type DeleteServiceRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName          string   `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteServiceRequest) Reset()         { *m = DeleteServiceRequest{} }
func (m *DeleteServiceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteServiceRequest) ProtoMessage()    {}
func (*DeleteServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{4}
}

func (m *DeleteServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteServiceRequest.Unmarshal(m, b)
}
func (m *DeleteServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteServiceRequest.Marshal(b, m, deterministic)
}
func (m *DeleteServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteServiceRequest.Merge(m, src)
}
func (m *DeleteServiceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteServiceRequest.Size(m)
}
func (m *DeleteServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteServiceRequest proto.InternalMessageInfo

func (m *DeleteServiceRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

// Request message for UndeleteService method.
type UndeleteServiceRequest struct {
	// The name of the service. See the [overview](/service-management/overview)
	// for naming requirements. For example: `example.googleapis.com`.
	ServiceName          string   `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UndeleteServiceRequest) Reset()         { *m = UndeleteServiceRequest{} }
func (m *UndeleteServiceRequest) String() string { return proto.CompactTextString(m) }
func (*UndeleteServiceRequest) ProtoMessage()    {}
func (*UndeleteServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{5}
}

func (m *UndeleteServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UndeleteServiceRequest.Unmarshal(m, b)
}
func (m *UndeleteServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UndeleteServiceRequest.Marshal(b, m, deterministic)
}
func (m *UndeleteServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UndeleteServiceRequest.Merge(m, src)
}
func (m *UndeleteServiceRequest) XXX_Size() int {
	return xxx_messageInfo_UndeleteServiceRequest.Size(m)
}
func (m *UndeleteServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UndeleteServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UndeleteServiceRequest proto.InternalMessageInfo

func (m *UndeleteServiceRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

// Response message for UndeleteService method.
type UndeleteServiceResponse struct {
	// Revived service resource.
	Service              *ManagedService `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *UndeleteServiceResponse) Reset()         { *m = UndeleteServiceResponse{} }
func (m *UndeleteServiceResponse) String() string { return proto.CompactTextString(m) }
func (*UndeleteServiceResponse) ProtoMessage()    {}
func (*UndeleteServiceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{6}
}

func (m *UndeleteServiceResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UndeleteServiceResponse.Unmarshal(m, b)
}
func (m *UndeleteServiceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UndeleteServiceResponse.Marshal(b, m, deterministic)
}
func (m *UndeleteServiceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UndeleteServiceResponse.Merge(m, src)
}
func (m *UndeleteServiceResponse) XXX_Size() int {
	return xxx_messageInfo_UndeleteServiceResponse.Size(m)
}
func (m *UndeleteServiceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UndeleteServiceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UndeleteServiceResponse proto.InternalMessageInfo

func (m *UndeleteServiceResponse) GetService() *ManagedService {
	if m != nil {
		return m.Service
	}
	return nil
}

// Request message for GetServiceConfig method.
type GetServiceConfigRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// The id of the service configuration resource.
	ConfigId string `protobuf:"bytes,2,opt,name=config_id,json=configId,proto3" json:"config_id,omitempty"`
	// Specifies which parts of the Service Config should be returned in the
	// response.
	View                 GetServiceConfigRequest_ConfigView `protobuf:"varint,3,opt,name=view,proto3,enum=google.api.servicemanagement.v1.GetServiceConfigRequest_ConfigView" json:"view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *GetServiceConfigRequest) Reset()         { *m = GetServiceConfigRequest{} }
func (m *GetServiceConfigRequest) String() string { return proto.CompactTextString(m) }
func (*GetServiceConfigRequest) ProtoMessage()    {}
func (*GetServiceConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{7}
}

func (m *GetServiceConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServiceConfigRequest.Unmarshal(m, b)
}
func (m *GetServiceConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServiceConfigRequest.Marshal(b, m, deterministic)
}
func (m *GetServiceConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServiceConfigRequest.Merge(m, src)
}
func (m *GetServiceConfigRequest) XXX_Size() int {
	return xxx_messageInfo_GetServiceConfigRequest.Size(m)
}
func (m *GetServiceConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServiceConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServiceConfigRequest proto.InternalMessageInfo

func (m *GetServiceConfigRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *GetServiceConfigRequest) GetConfigId() string {
	if m != nil {
		return m.ConfigId
	}
	return ""
}

func (m *GetServiceConfigRequest) GetView() GetServiceConfigRequest_ConfigView {
	if m != nil {
		return m.View
	}
	return GetServiceConfigRequest_BASIC
}

// Request message for ListServiceConfigs method.
type ListServiceConfigsRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// The token of the page to retrieve.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The max number of items to include in the response list.
	PageSize             int32    `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServiceConfigsRequest) Reset()         { *m = ListServiceConfigsRequest{} }
func (m *ListServiceConfigsRequest) String() string { return proto.CompactTextString(m) }
func (*ListServiceConfigsRequest) ProtoMessage()    {}
func (*ListServiceConfigsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{8}
}

func (m *ListServiceConfigsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceConfigsRequest.Unmarshal(m, b)
}
func (m *ListServiceConfigsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceConfigsRequest.Marshal(b, m, deterministic)
}
func (m *ListServiceConfigsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceConfigsRequest.Merge(m, src)
}
func (m *ListServiceConfigsRequest) XXX_Size() int {
	return xxx_messageInfo_ListServiceConfigsRequest.Size(m)
}
func (m *ListServiceConfigsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceConfigsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceConfigsRequest proto.InternalMessageInfo

func (m *ListServiceConfigsRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *ListServiceConfigsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListServiceConfigsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for ListServiceConfigs method.
type ListServiceConfigsResponse struct {
	// The list of service configuration resources.
	ServiceConfigs []*serviceconfig.Service `protobuf:"bytes,1,rep,name=service_configs,json=serviceConfigs,proto3" json:"service_configs,omitempty"`
	// The token of the next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServiceConfigsResponse) Reset()         { *m = ListServiceConfigsResponse{} }
func (m *ListServiceConfigsResponse) String() string { return proto.CompactTextString(m) }
func (*ListServiceConfigsResponse) ProtoMessage()    {}
func (*ListServiceConfigsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{9}
}

func (m *ListServiceConfigsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceConfigsResponse.Unmarshal(m, b)
}
func (m *ListServiceConfigsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceConfigsResponse.Marshal(b, m, deterministic)
}
func (m *ListServiceConfigsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceConfigsResponse.Merge(m, src)
}
func (m *ListServiceConfigsResponse) XXX_Size() int {
	return xxx_messageInfo_ListServiceConfigsResponse.Size(m)
}
func (m *ListServiceConfigsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceConfigsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceConfigsResponse proto.InternalMessageInfo

func (m *ListServiceConfigsResponse) GetServiceConfigs() []*serviceconfig.Service {
	if m != nil {
		return m.ServiceConfigs
	}
	return nil
}

func (m *ListServiceConfigsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for CreateServiceConfig method.
type CreateServiceConfigRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// The service configuration resource.
	ServiceConfig        *serviceconfig.Service `protobuf:"bytes,2,opt,name=service_config,json=serviceConfig,proto3" json:"service_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *CreateServiceConfigRequest) Reset()         { *m = CreateServiceConfigRequest{} }
func (m *CreateServiceConfigRequest) String() string { return proto.CompactTextString(m) }
func (*CreateServiceConfigRequest) ProtoMessage()    {}
func (*CreateServiceConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{10}
}

func (m *CreateServiceConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateServiceConfigRequest.Unmarshal(m, b)
}
func (m *CreateServiceConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateServiceConfigRequest.Marshal(b, m, deterministic)
}
func (m *CreateServiceConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateServiceConfigRequest.Merge(m, src)
}
func (m *CreateServiceConfigRequest) XXX_Size() int {
	return xxx_messageInfo_CreateServiceConfigRequest.Size(m)
}
func (m *CreateServiceConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateServiceConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateServiceConfigRequest proto.InternalMessageInfo

func (m *CreateServiceConfigRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *CreateServiceConfigRequest) GetServiceConfig() *serviceconfig.Service {
	if m != nil {
		return m.ServiceConfig
	}
	return nil
}

// Request message for SubmitConfigSource method.
type SubmitConfigSourceRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// The source configuration for the service.
	ConfigSource *ConfigSource `protobuf:"bytes,2,opt,name=config_source,json=configSource,proto3" json:"config_source,omitempty"`
	// Optional. If set, this will result in the generation of a
	// `google.api.Service` configuration based on the `ConfigSource` provided,
	// but the generated config and the sources will NOT be persisted.
	ValidateOnly         bool     `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SubmitConfigSourceRequest) Reset()         { *m = SubmitConfigSourceRequest{} }
func (m *SubmitConfigSourceRequest) String() string { return proto.CompactTextString(m) }
func (*SubmitConfigSourceRequest) ProtoMessage()    {}
func (*SubmitConfigSourceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{11}
}

func (m *SubmitConfigSourceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SubmitConfigSourceRequest.Unmarshal(m, b)
}
func (m *SubmitConfigSourceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SubmitConfigSourceRequest.Marshal(b, m, deterministic)
}
func (m *SubmitConfigSourceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SubmitConfigSourceRequest.Merge(m, src)
}
func (m *SubmitConfigSourceRequest) XXX_Size() int {
	return xxx_messageInfo_SubmitConfigSourceRequest.Size(m)
}
func (m *SubmitConfigSourceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SubmitConfigSourceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SubmitConfigSourceRequest proto.InternalMessageInfo

func (m *SubmitConfigSourceRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *SubmitConfigSourceRequest) GetConfigSource() *ConfigSource {
	if m != nil {
		return m.ConfigSource
	}
	return nil
}

func (m *SubmitConfigSourceRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// Response message for SubmitConfigSource method.
type SubmitConfigSourceResponse struct {
	// The generated service configuration.
	ServiceConfig        *serviceconfig.Service `protobuf:"bytes,1,opt,name=service_config,json=serviceConfig,proto3" json:"service_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *SubmitConfigSourceResponse) Reset()         { *m = SubmitConfigSourceResponse{} }
func (m *SubmitConfigSourceResponse) String() string { return proto.CompactTextString(m) }
func (*SubmitConfigSourceResponse) ProtoMessage()    {}
func (*SubmitConfigSourceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{12}
}

func (m *SubmitConfigSourceResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SubmitConfigSourceResponse.Unmarshal(m, b)
}
func (m *SubmitConfigSourceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SubmitConfigSourceResponse.Marshal(b, m, deterministic)
}
func (m *SubmitConfigSourceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SubmitConfigSourceResponse.Merge(m, src)
}
func (m *SubmitConfigSourceResponse) XXX_Size() int {
	return xxx_messageInfo_SubmitConfigSourceResponse.Size(m)
}
func (m *SubmitConfigSourceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SubmitConfigSourceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SubmitConfigSourceResponse proto.InternalMessageInfo

func (m *SubmitConfigSourceResponse) GetServiceConfig() *serviceconfig.Service {
	if m != nil {
		return m.ServiceConfig
	}
	return nil
}

// Request message for 'CreateServiceRollout'
type CreateServiceRolloutRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// The rollout resource. The `service_name` field is output only.
	Rollout              *Rollout `protobuf:"bytes,2,opt,name=rollout,proto3" json:"rollout,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateServiceRolloutRequest) Reset()         { *m = CreateServiceRolloutRequest{} }
func (m *CreateServiceRolloutRequest) String() string { return proto.CompactTextString(m) }
func (*CreateServiceRolloutRequest) ProtoMessage()    {}
func (*CreateServiceRolloutRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{13}
}

func (m *CreateServiceRolloutRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateServiceRolloutRequest.Unmarshal(m, b)
}
func (m *CreateServiceRolloutRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateServiceRolloutRequest.Marshal(b, m, deterministic)
}
func (m *CreateServiceRolloutRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateServiceRolloutRequest.Merge(m, src)
}
func (m *CreateServiceRolloutRequest) XXX_Size() int {
	return xxx_messageInfo_CreateServiceRolloutRequest.Size(m)
}
func (m *CreateServiceRolloutRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateServiceRolloutRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateServiceRolloutRequest proto.InternalMessageInfo

func (m *CreateServiceRolloutRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *CreateServiceRolloutRequest) GetRollout() *Rollout {
	if m != nil {
		return m.Rollout
	}
	return nil
}

// Request message for 'ListServiceRollouts'
type ListServiceRolloutsRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// The token of the page to retrieve.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The max number of items to include in the response list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Use `filter` to return subset of rollouts.
	// The following filters are supported:
	//   -- To limit the results to only those in
	//      [status](google.api.servicemanagement.v1.RolloutStatus) 'SUCCESS',
	//      use filter='status=SUCCESS'
	//   -- To limit the results to those in
	//      [status](google.api.servicemanagement.v1.RolloutStatus) 'CANCELLED'
	//      or 'FAILED', use filter='status=CANCELLED OR status=FAILED'
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServiceRolloutsRequest) Reset()         { *m = ListServiceRolloutsRequest{} }
func (m *ListServiceRolloutsRequest) String() string { return proto.CompactTextString(m) }
func (*ListServiceRolloutsRequest) ProtoMessage()    {}
func (*ListServiceRolloutsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{14}
}

func (m *ListServiceRolloutsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceRolloutsRequest.Unmarshal(m, b)
}
func (m *ListServiceRolloutsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceRolloutsRequest.Marshal(b, m, deterministic)
}
func (m *ListServiceRolloutsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceRolloutsRequest.Merge(m, src)
}
func (m *ListServiceRolloutsRequest) XXX_Size() int {
	return xxx_messageInfo_ListServiceRolloutsRequest.Size(m)
}
func (m *ListServiceRolloutsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceRolloutsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceRolloutsRequest proto.InternalMessageInfo

func (m *ListServiceRolloutsRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *ListServiceRolloutsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListServiceRolloutsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListServiceRolloutsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Response message for ListServiceRollouts method.
type ListServiceRolloutsResponse struct {
	// The list of rollout resources.
	Rollouts []*Rollout `protobuf:"bytes,1,rep,name=rollouts,proto3" json:"rollouts,omitempty"`
	// The token of the next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServiceRolloutsResponse) Reset()         { *m = ListServiceRolloutsResponse{} }
func (m *ListServiceRolloutsResponse) String() string { return proto.CompactTextString(m) }
func (*ListServiceRolloutsResponse) ProtoMessage()    {}
func (*ListServiceRolloutsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{15}
}

func (m *ListServiceRolloutsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceRolloutsResponse.Unmarshal(m, b)
}
func (m *ListServiceRolloutsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceRolloutsResponse.Marshal(b, m, deterministic)
}
func (m *ListServiceRolloutsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceRolloutsResponse.Merge(m, src)
}
func (m *ListServiceRolloutsResponse) XXX_Size() int {
	return xxx_messageInfo_ListServiceRolloutsResponse.Size(m)
}
func (m *ListServiceRolloutsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceRolloutsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceRolloutsResponse proto.InternalMessageInfo

func (m *ListServiceRolloutsResponse) GetRollouts() []*Rollout {
	if m != nil {
		return m.Rollouts
	}
	return nil
}

func (m *ListServiceRolloutsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for GetServiceRollout method.
type GetServiceRolloutRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// The id of the rollout resource.
	RolloutId            string   `protobuf:"bytes,2,opt,name=rollout_id,json=rolloutId,proto3" json:"rollout_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServiceRolloutRequest) Reset()         { *m = GetServiceRolloutRequest{} }
func (m *GetServiceRolloutRequest) String() string { return proto.CompactTextString(m) }
func (*GetServiceRolloutRequest) ProtoMessage()    {}
func (*GetServiceRolloutRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{16}
}

func (m *GetServiceRolloutRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServiceRolloutRequest.Unmarshal(m, b)
}
func (m *GetServiceRolloutRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServiceRolloutRequest.Marshal(b, m, deterministic)
}
func (m *GetServiceRolloutRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServiceRolloutRequest.Merge(m, src)
}
func (m *GetServiceRolloutRequest) XXX_Size() int {
	return xxx_messageInfo_GetServiceRolloutRequest.Size(m)
}
func (m *GetServiceRolloutRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServiceRolloutRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServiceRolloutRequest proto.InternalMessageInfo

func (m *GetServiceRolloutRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *GetServiceRolloutRequest) GetRolloutId() string {
	if m != nil {
		return m.RolloutId
	}
	return ""
}

// Request message for EnableService method.
type EnableServiceRequest struct {
	// Name of the service to enable. Specifying an unknown service name will
	// cause the request to fail.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// The identity of consumer resource which service enablement will be
	// applied to.
	//
	// The Google Service Management implementation accepts the following
	// forms:
	// - "project:<project_id>"
	//
	// Note: this is made compatible with
	// google.api.servicecontrol.v1.Operation.consumer_id.
	ConsumerId           string   `protobuf:"bytes,2,opt,name=consumer_id,json=consumerId,proto3" json:"consumer_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnableServiceRequest) Reset()         { *m = EnableServiceRequest{} }
func (m *EnableServiceRequest) String() string { return proto.CompactTextString(m) }
func (*EnableServiceRequest) ProtoMessage()    {}
func (*EnableServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{17}
}

func (m *EnableServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EnableServiceRequest.Unmarshal(m, b)
}
func (m *EnableServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EnableServiceRequest.Marshal(b, m, deterministic)
}
func (m *EnableServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnableServiceRequest.Merge(m, src)
}
func (m *EnableServiceRequest) XXX_Size() int {
	return xxx_messageInfo_EnableServiceRequest.Size(m)
}
func (m *EnableServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EnableServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EnableServiceRequest proto.InternalMessageInfo

func (m *EnableServiceRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *EnableServiceRequest) GetConsumerId() string {
	if m != nil {
		return m.ConsumerId
	}
	return ""
}

// Request message for DisableService method.
type DisableServiceRequest struct {
	// Name of the service to disable. Specifying an unknown service name
	// will cause the request to fail.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// The identity of consumer resource which service disablement will be
	// applied to.
	//
	// The Google Service Management implementation accepts the following
	// forms:
	// - "project:<project_id>"
	//
	// Note: this is made compatible with
	// google.api.servicecontrol.v1.Operation.consumer_id.
	ConsumerId           string   `protobuf:"bytes,2,opt,name=consumer_id,json=consumerId,proto3" json:"consumer_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DisableServiceRequest) Reset()         { *m = DisableServiceRequest{} }
func (m *DisableServiceRequest) String() string { return proto.CompactTextString(m) }
func (*DisableServiceRequest) ProtoMessage()    {}
func (*DisableServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{18}
}

func (m *DisableServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DisableServiceRequest.Unmarshal(m, b)
}
func (m *DisableServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DisableServiceRequest.Marshal(b, m, deterministic)
}
func (m *DisableServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisableServiceRequest.Merge(m, src)
}
func (m *DisableServiceRequest) XXX_Size() int {
	return xxx_messageInfo_DisableServiceRequest.Size(m)
}
func (m *DisableServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DisableServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DisableServiceRequest proto.InternalMessageInfo

func (m *DisableServiceRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *DisableServiceRequest) GetConsumerId() string {
	if m != nil {
		return m.ConsumerId
	}
	return ""
}

// Request message for GenerateConfigReport method.
type GenerateConfigReportRequest struct {
	// Service configuration for which we want to generate the report.
	// For this version of API, the supported types are
	// [google.api.servicemanagement.v1.ConfigRef][google.api.servicemanagement.v1.ConfigRef],
	// [google.api.servicemanagement.v1.ConfigSource][google.api.servicemanagement.v1.ConfigSource],
	// and [google.api.Service][google.api.Service]
	NewConfig *any.Any `protobuf:"bytes,1,opt,name=new_config,json=newConfig,proto3" json:"new_config,omitempty"`
	// Service configuration against which the comparison will be done.
	// For this version of API, the supported types are
	// [google.api.servicemanagement.v1.ConfigRef][google.api.servicemanagement.v1.ConfigRef],
	// [google.api.servicemanagement.v1.ConfigSource][google.api.servicemanagement.v1.ConfigSource],
	// and [google.api.Service][google.api.Service]
	OldConfig            *any.Any `protobuf:"bytes,2,opt,name=old_config,json=oldConfig,proto3" json:"old_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GenerateConfigReportRequest) Reset()         { *m = GenerateConfigReportRequest{} }
func (m *GenerateConfigReportRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateConfigReportRequest) ProtoMessage()    {}
func (*GenerateConfigReportRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{19}
}

func (m *GenerateConfigReportRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateConfigReportRequest.Unmarshal(m, b)
}
func (m *GenerateConfigReportRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateConfigReportRequest.Marshal(b, m, deterministic)
}
func (m *GenerateConfigReportRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateConfigReportRequest.Merge(m, src)
}
func (m *GenerateConfigReportRequest) XXX_Size() int {
	return xxx_messageInfo_GenerateConfigReportRequest.Size(m)
}
func (m *GenerateConfigReportRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateConfigReportRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateConfigReportRequest proto.InternalMessageInfo

func (m *GenerateConfigReportRequest) GetNewConfig() *any.Any {
	if m != nil {
		return m.NewConfig
	}
	return nil
}

func (m *GenerateConfigReportRequest) GetOldConfig() *any.Any {
	if m != nil {
		return m.OldConfig
	}
	return nil
}

// Response message for GenerateConfigReport method.
type GenerateConfigReportResponse struct {
	// Name of the service this report belongs to.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// ID of the service configuration this report belongs to.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// list of ChangeReport, each corresponding to comparison between two
	// service configurations.
	ChangeReports []*ChangeReport `protobuf:"bytes,3,rep,name=change_reports,json=changeReports,proto3" json:"change_reports,omitempty"`
	// Errors / Linter warnings associated with the service definition this
	// report
	// belongs to.
	Diagnostics          []*Diagnostic `protobuf:"bytes,4,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *GenerateConfigReportResponse) Reset()         { *m = GenerateConfigReportResponse{} }
func (m *GenerateConfigReportResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateConfigReportResponse) ProtoMessage()    {}
func (*GenerateConfigReportResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7934ed1b66ee227, []int{20}
}

func (m *GenerateConfigReportResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateConfigReportResponse.Unmarshal(m, b)
}
func (m *GenerateConfigReportResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateConfigReportResponse.Marshal(b, m, deterministic)
}
func (m *GenerateConfigReportResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateConfigReportResponse.Merge(m, src)
}
func (m *GenerateConfigReportResponse) XXX_Size() int {
	return xxx_messageInfo_GenerateConfigReportResponse.Size(m)
}
func (m *GenerateConfigReportResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateConfigReportResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateConfigReportResponse proto.InternalMessageInfo

func (m *GenerateConfigReportResponse) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *GenerateConfigReportResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *GenerateConfigReportResponse) GetChangeReports() []*ChangeReport {
	if m != nil {
		return m.ChangeReports
	}
	return nil
}

func (m *GenerateConfigReportResponse) GetDiagnostics() []*Diagnostic {
	if m != nil {
		return m.Diagnostics
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.api.servicemanagement.v1.GetServiceConfigRequest_ConfigView", GetServiceConfigRequest_ConfigView_name, GetServiceConfigRequest_ConfigView_value)
	proto.RegisterType((*ListServicesRequest)(nil), "google.api.servicemanagement.v1.ListServicesRequest")
	proto.RegisterType((*ListServicesResponse)(nil), "google.api.servicemanagement.v1.ListServicesResponse")
	proto.RegisterType((*GetServiceRequest)(nil), "google.api.servicemanagement.v1.GetServiceRequest")
	proto.RegisterType((*CreateServiceRequest)(nil), "google.api.servicemanagement.v1.CreateServiceRequest")
	proto.RegisterType((*DeleteServiceRequest)(nil), "google.api.servicemanagement.v1.DeleteServiceRequest")
	proto.RegisterType((*UndeleteServiceRequest)(nil), "google.api.servicemanagement.v1.UndeleteServiceRequest")
	proto.RegisterType((*UndeleteServiceResponse)(nil), "google.api.servicemanagement.v1.UndeleteServiceResponse")
	proto.RegisterType((*GetServiceConfigRequest)(nil), "google.api.servicemanagement.v1.GetServiceConfigRequest")
	proto.RegisterType((*ListServiceConfigsRequest)(nil), "google.api.servicemanagement.v1.ListServiceConfigsRequest")
	proto.RegisterType((*ListServiceConfigsResponse)(nil), "google.api.servicemanagement.v1.ListServiceConfigsResponse")
	proto.RegisterType((*CreateServiceConfigRequest)(nil), "google.api.servicemanagement.v1.CreateServiceConfigRequest")
	proto.RegisterType((*SubmitConfigSourceRequest)(nil), "google.api.servicemanagement.v1.SubmitConfigSourceRequest")
	proto.RegisterType((*SubmitConfigSourceResponse)(nil), "google.api.servicemanagement.v1.SubmitConfigSourceResponse")
	proto.RegisterType((*CreateServiceRolloutRequest)(nil), "google.api.servicemanagement.v1.CreateServiceRolloutRequest")
	proto.RegisterType((*ListServiceRolloutsRequest)(nil), "google.api.servicemanagement.v1.ListServiceRolloutsRequest")
	proto.RegisterType((*ListServiceRolloutsResponse)(nil), "google.api.servicemanagement.v1.ListServiceRolloutsResponse")
	proto.RegisterType((*GetServiceRolloutRequest)(nil), "google.api.servicemanagement.v1.GetServiceRolloutRequest")
	proto.RegisterType((*EnableServiceRequest)(nil), "google.api.servicemanagement.v1.EnableServiceRequest")
	proto.RegisterType((*DisableServiceRequest)(nil), "google.api.servicemanagement.v1.DisableServiceRequest")
	proto.RegisterType((*GenerateConfigReportRequest)(nil), "google.api.servicemanagement.v1.GenerateConfigReportRequest")
	proto.RegisterType((*GenerateConfigReportResponse)(nil), "google.api.servicemanagement.v1.GenerateConfigReportResponse")
}

func init() {
	proto.RegisterFile("google/api/servicemanagement/v1/servicemanager.proto", fileDescriptor_e7934ed1b66ee227)
}

var fileDescriptor_e7934ed1b66ee227 = []byte{
	// 1447 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xcf, 0x6f, 0xdc, 0x44,
	0x14, 0x66, 0x36, 0x69, 0x9b, 0xbc, 0x64, 0xb7, 0xed, 0x64, 0x69, 0xb6, 0x9b, 0x46, 0x4d, 0x9c,
	0x52, 0xa2, 0x94, 0xda, 0x4a, 0xfa, 0x03, 0xba, 0x29, 0x87, 0x26, 0x81, 0x28, 0xa2, 0xa5, 0xd1,
	0xa6, 0x3f, 0x50, 0x09, 0x5a, 0x39, 0xf6, 0xc4, 0x98, 0x7a, 0x67, 0x16, 0xdb, 0x9b, 0x90, 0x46,
	0xbd, 0x54, 0x95, 0x90, 0xe0, 0x84, 0x8a, 0xe8, 0xbd, 0x42, 0x1c, 0x7a, 0xe5, 0x80, 0xc4, 0x01,
	0xc1, 0x95, 0x2b, 0x70, 0xe4, 0xc6, 0xdf, 0xc0, 0x19, 0xed, 0x78, 0xbc, 0xf1, 0xec, 0x3a, 0x6b,
	0x7b, 0x05, 0x1c, 0xe7, 0xcd, 0x7c, 0xef, 0x7d, 0xf3, 0xe6, 0xbd, 0x99, 0xcf, 0x86, 0xcb, 0x16,
	0x63, 0x96, 0x43, 0x34, 0xbd, 0x61, 0x6b, 0x1e, 0x71, 0x77, 0x6c, 0x83, 0xd4, 0x75, 0xaa, 0x5b,
	0xa4, 0x4e, 0xa8, 0xaf, 0xed, 0xcc, 0xcb, 0x46, 0x57, 0x6d, 0xb8, 0xcc, 0x67, 0xf8, 0x6c, 0x80,
	0x52, 0xf5, 0x86, 0xad, 0x76, 0xa1, 0xd4, 0x9d, 0xf9, 0xf2, 0x99, 0x88, 0x5b, 0x9d, 0x52, 0xe6,
	0xeb, 0xbe, 0xcd, 0xa8, 0x17, 0xc0, 0xcb, 0xa5, 0xee, 0xa0, 0x62, 0x46, 0x4b, 0xa2, 0xe3, 0x12,
	0x8f, 0x35, 0x5d, 0x83, 0x84, 0xae, 0x66, 0x04, 0xc0, 0x61, 0xd4, 0x72, 0x9b, 0x94, 0xda, 0xd4,
	0xd2, 0x58, 0x83, 0xb8, 0x52, 0xbc, 0xd3, 0x62, 0x11, 0x1f, 0x6d, 0x35, 0xb7, 0x35, 0x9d, 0xee,
	0x89, 0xa9, 0xa9, 0xce, 0xa9, 0x6d, 0x9b, 0x38, 0x66, 0xad, 0xae, 0x7b, 0x0f, 0xc5, 0x8a, 0x33,
	0x9d, 0x2b, 0x3c, 0xdf, 0x6d, 0x1a, 0xbe, 0x98, 0x1d, 0x17, 0xb3, 0x6e, 0xc3, 0xd0, 0x3c, 0x5f,
	0xf7, 0x9b, 0x22, 0xa6, 0xf2, 0x02, 0xc1, 0xd8, 0x4d, 0xdb, 0xf3, 0x37, 0x82, 0x5d, 0x78, 0x55,
	0xf2, 0x69, 0x93, 0x78, 0x3e, 0x56, 0x61, 0xac, 0xe1, 0x32, 0xb3, 0x69, 0x10, 0xb7, 0xd6, 0x70,
	0xd9, 0x27, 0xc4, 0xf0, 0x6b, 0xb6, 0x59, 0x42, 0x53, 0x68, 0x76, 0xb8, 0x7a, 0x32, 0x9c, 0x5a,
	0x0f, 0x66, 0xd6, 0x4c, 0x3c, 0x01, 0xc3, 0x0d, 0xdd, 0x22, 0x35, 0xcf, 0x7e, 0x44, 0x4a, 0x47,
	0xa6, 0xd0, 0xec, 0x91, 0xea, 0x50, 0xcb, 0xb0, 0x61, 0x3f, 0x22, 0x78, 0x12, 0x80, 0x4f, 0xfa,
	0xec, 0x21, 0xa1, 0xa5, 0xa3, 0xdc, 0x07, 0x5f, 0x7e, 0xa7, 0x65, 0xc0, 0x67, 0x61, 0xc4, 0x60,
	0xd4, 0x6b, 0xd6, 0x89, 0xdb, 0x8a, 0x71, 0x8c, 0xcf, 0x43, 0x68, 0x5a, 0x33, 0x95, 0x2f, 0x11,
	0x14, 0x65, 0x92, 0x5e, 0x83, 0x51, 0x8f, 0xe0, 0xf7, 0x60, 0x48, 0xa4, 0xdf, 0x2b, 0xa1, 0xa9,
	0x81, 0xd9, 0x91, 0x05, 0x4d, 0x4d, 0x38, 0x73, 0xf5, 0x16, 0x1f, 0x99, 0xc2, 0x57, 0xb5, 0xed,
	0x00, 0x9f, 0x87, 0xe3, 0x94, 0x7c, 0xe6, 0xd7, 0x22, 0x54, 0x73, 0x9c, 0x4a, 0xbe, 0x65, 0x5e,
	0x0f, 0xe9, 0x2a, 0x57, 0xe1, 0xe4, 0x2a, 0x09, 0xb9, 0x84, 0xf9, 0x9a, 0x86, 0x51, 0xe1, 0xa8,
	0x46, 0xf5, 0x3a, 0x11, 0x89, 0x1a, 0x11, 0xb6, 0xf7, 0xf5, 0x3a, 0x51, 0x74, 0x28, 0x2e, 0xbb,
	0x44, 0xf7, 0x49, 0x07, 0x74, 0x0d, 0x8e, 0x89, 0x65, 0x1c, 0xd5, 0xc7, 0x1e, 0x42, 0xbc, 0x72,
	0x0d, 0x8a, 0x2b, 0xc4, 0x21, 0x5d, 0x21, 0x52, 0xb0, 0x5b, 0x84, 0x53, 0x77, 0xa9, 0xd9, 0x27,
	0xd8, 0x84, 0xf1, 0x2e, 0xb0, 0x38, 0xa2, 0x7f, 0x71, 0x77, 0x7f, 0x20, 0x18, 0x3f, 0xc8, 0xfc,
	0x32, 0xa3, 0xdb, 0xb6, 0x95, 0x9e, 0x64, 0xab, 0x44, 0x0d, 0x8e, 0x69, 0x15, 0x59, 0x70, 0xb2,
	0x43, 0x81, 0x61, 0xcd, 0xc4, 0xf7, 0x61, 0x70, 0xc7, 0x26, 0xbb, 0xa5, 0x81, 0x29, 0x34, 0x5b,
	0x58, 0x58, 0x4e, 0xe4, 0x78, 0x08, 0x0f, 0x35, 0x18, 0xdd, 0xb3, 0xc9, 0x6e, 0x95, 0x3b, 0x54,
	0xa6, 0x01, 0x0e, 0x6c, 0x78, 0x18, 0x8e, 0x2c, 0xdd, 0xd8, 0x58, 0x5b, 0x3e, 0xf1, 0x0a, 0x1e,
	0x82, 0xc1, 0x77, 0xef, 0xde, 0xbc, 0x79, 0x02, 0x29, 0x8f, 0xe0, 0x74, 0xa4, 0xba, 0x83, 0xd5,
	0x5e, 0x86, 0x8d, 0xc9, 0xed, 0x95, 0xeb, 0x6c, 0x2f, 0xa9, 0x35, 0x07, 0xe4, 0xd6, 0x54, 0x9e,
	0x20, 0x28, 0xc7, 0x05, 0x17, 0xa7, 0x77, 0x1d, 0x8e, 0x87, 0xd1, 0x83, 0x54, 0x85, 0x7d, 0x36,
	0x16, 0xcd, 0x50, 0x78, 0x52, 0x05, 0x4f, 0xf2, 0x92, 0xba, 0xa3, 0xf6, 0xa1, 0x2c, 0x75, 0x46,
	0xe6, 0xa3, 0xad, 0x40, 0x41, 0xa6, 0xc9, 0xe3, 0x1c, 0xc2, 0x32, 0x2f, 0xb1, 0x54, 0x7e, 0x40,
	0x70, 0x7a, 0xa3, 0xb9, 0x55, 0xb7, 0xfd, 0xc0, 0xb0, 0xc1, 0x2f, 0xee, 0x0c, 0xc1, 0xab, 0x90,
	0x17, 0x75, 0x15, 0xdc, 0xf9, 0x22, 0xf6, 0xc5, 0xc4, 0x1a, 0x92, 0xe2, 0x8d, 0x1a, 0x91, 0x11,
	0x9e, 0x81, 0xfc, 0x8e, 0xee, 0xd8, 0xa6, 0xee, 0x93, 0x1a, 0xa3, 0xce, 0x1e, 0x3f, 0xb7, 0xa1,
	0xea, 0x68, 0x68, 0xbc, 0x4d, 0x9d, 0x3d, 0xe5, 0x03, 0x28, 0xc7, 0x11, 0x17, 0x47, 0xd7, 0x9d,
	0x13, 0x94, 0x3a, 0x27, 0x4f, 0x11, 0x4c, 0xc8, 0x77, 0x15, 0x73, 0x1c, 0xd6, 0xf4, 0x33, 0x64,
	0x65, 0x09, 0x8e, 0xb9, 0x01, 0x48, 0xe4, 0x63, 0x36, 0x31, 0x1f, 0x61, 0x90, 0x10, 0xa8, 0x3c,
	0x93, 0x8b, 0x53, 0xcc, 0xff, 0x4f, 0xad, 0x81, 0x4f, 0xc1, 0xd1, 0x6d, 0xdb, 0xf1, 0x89, 0x5b,
	0x1a, 0xe4, 0x38, 0x31, 0x6a, 0xbd, 0x46, 0x13, 0xb1, 0xac, 0x44, 0xe2, 0x57, 0x60, 0x48, 0x6c,
	0x20, 0x6c, 0x96, 0xf4, 0x5b, 0x6f, 0x23, 0x53, 0xf7, 0xce, 0x26, 0x94, 0x22, 0xaf, 0x51, 0xe6,
	0x63, 0x9a, 0x04, 0x10, 0x21, 0x0f, 0x6e, 0xc5, 0x61, 0x61, 0x59, 0x33, 0x95, 0x07, 0x50, 0x7c,
	0x87, 0xea, 0x5b, 0x4e, 0xf6, 0x37, 0xa1, 0xf3, 0x55, 0xcf, 0x75, 0xbd, 0xea, 0x1f, 0xc2, 0xab,
	0x2b, 0xb6, 0xf7, 0x1f, 0x39, 0xff, 0x1c, 0xc1, 0xc4, 0x2a, 0xa1, 0x2d, 0x85, 0xd5, 0xbe, 0x4e,
	0x1a, 0xcc, 0x6d, 0xa7, 0xe6, 0x12, 0x00, 0x25, 0xbb, 0x72, 0x67, 0x14, 0xc3, 0x63, 0x0a, 0x35,
	0x94, 0x7a, 0x83, 0xee, 0x55, 0x87, 0x29, 0xd9, 0x0d, 0x3c, 0xb4, 0x40, 0xcc, 0x31, 0xe5, 0x2b,
	0xe6, 0x10, 0x10, 0x73, 0x4c, 0xd1, 0x4b, 0x7f, 0x23, 0x38, 0x13, 0xcf, 0x44, 0xd4, 0x4b, 0x8a,
	0xed, 0x16, 0x20, 0xd7, 0xde, 0x65, 0xce, 0x36, 0xf1, 0x1d, 0x28, 0x18, 0x1f, 0xeb, 0xd4, 0x22,
	0x35, 0x97, 0xfb, 0xf2, 0x4a, 0x03, 0xbc, 0xd0, 0x52, 0xdc, 0x39, 0x1c, 0x26, 0x18, 0xe4, 0x8d,
	0xc8, 0xc8, 0xc3, 0xb7, 0x60, 0xc4, 0xb4, 0x75, 0x8b, 0x32, 0xcf, 0xb7, 0x0d, 0xaf, 0x34, 0xc8,
	0x5d, 0x5e, 0x48, 0x74, 0xb9, 0xd2, 0xc6, 0x54, 0xa3, 0xf8, 0x85, 0xdf, 0xc7, 0xa0, 0x20, 0x4e,
	0x36, 0x78, 0xd1, 0x5d, 0xfc, 0x15, 0x82, 0xd1, 0xa8, 0x90, 0xc3, 0x97, 0x13, 0xbd, 0xc7, 0x88,
	0xd3, 0xf2, 0x95, 0x8c, 0xa8, 0x20, 0xd1, 0x4a, 0xf1, 0xc9, 0x6f, 0x7f, 0x3d, 0xcb, 0x15, 0xf0,
	0x68, 0xe4, 0x83, 0xc1, 0xc3, 0xdf, 0x20, 0x80, 0x83, 0x0e, 0xc2, 0x0b, 0x19, 0x9e, 0xfe, 0x90,
	0x4f, 0x56, 0x49, 0xa3, 0xcc, 0x70, 0x26, 0x93, 0x78, 0x22, 0xca, 0x44, 0xdb, 0x8f, 0x96, 0xc1,
	0x63, 0xfc, 0x14, 0x41, 0x5e, 0xba, 0x84, 0x71, 0xf2, 0xbe, 0xe3, 0x04, 0x66, 0x79, 0x32, 0x84,
	0x45, 0xbe, 0x3e, 0xd4, 0xdb, 0xe1, 0xd7, 0x87, 0x32, 0xc9, 0xc9, 0x8c, 0x2b, 0x52, 0x5a, 0x2a,
	0xa1, 0xea, 0xc2, 0x5f, 0x20, 0xc8, 0x4b, 0xa2, 0x32, 0x05, 0x8d, 0x38, 0x11, 0x9a, 0x44, 0x43,
	0xe4, 0x64, 0xae, 0x67, 0x4e, 0x9e, 0x23, 0x38, 0xde, 0xa1, 0x34, 0xf1, 0x9b, 0x89, 0x74, 0xe2,
	0x85, 0x6d, 0x12, 0xa1, 0x37, 0x38, 0xa1, 0xf3, 0xca, 0xb9, 0x1e, 0x84, 0x2a, 0x4d, 0xe1, 0x1a,
	0xff, 0x88, 0x00, 0x77, 0x0b, 0x29, 0x5c, 0xc9, 0x52, 0xaa, 0xb2, 0xf4, 0x2b, 0x2f, 0xf6, 0x85,
	0x15, 0xc5, 0x7e, 0x81, 0xb3, 0x7f, 0x0d, 0xcf, 0xf4, 0x60, 0xaf, 0x09, 0x4d, 0x87, 0x7f, 0x46,
	0x70, 0xa2, 0x53, 0xd1, 0xe2, 0xb7, 0xfa, 0x15, 0xc1, 0xe5, 0x38, 0x89, 0xa1, 0x7c, 0xc4, 0x09,
	0xdd, 0xc7, 0x5a, 0x0a, 0x42, 0xda, 0x7e, 0x5b, 0xa9, 0x3f, 0x7e, 0x70, 0x0e, 0x2b, 0xc9, 0x10,
	0xfc, 0x2d, 0x82, 0xb1, 0x18, 0x11, 0x89, 0x17, 0xb3, 0xf5, 0x4c, 0x8a, 0x8d, 0x2c, 0xf2, 0x8d,
	0x5c, 0x51, 0xd2, 0x64, 0xb6, 0xd2, 0xa1, 0xc1, 0xf0, 0x77, 0x08, 0x70, 0xb7, 0x68, 0x4b, 0x51,
	0x26, 0x87, 0x4a, 0xd4, 0xa4, 0x32, 0xbe, 0xc2, 0xe9, 0x6a, 0xca, 0x5c, 0x1a, 0xba, 0x1e, 0x8f,
	0x52, 0x41, 0x73, 0xf8, 0x27, 0xf9, 0xc7, 0x40, 0xa8, 0x72, 0x70, 0xa6, 0xa2, 0xec, 0x50, 0x6c,
	0xe5, 0xeb, 0xfd, 0x81, 0x45, 0x49, 0x8b, 0x86, 0xc4, 0xbd, 0x1a, 0x52, 0x6b, 0x0b, 0xa8, 0xef,
	0x91, 0xf4, 0x9d, 0x1e, 0x98, 0xf1, 0xb5, 0x2c, 0xd7, 0xbb, 0xa4, 0xa6, 0xca, 0xa9, 0x55, 0x9c,
	0x72, 0x8d, 0x13, 0xbd, 0x84, 0xe7, 0xd3, 0x10, 0xd5, 0xf6, 0x0f, 0x04, 0xd8, 0x63, 0xfc, 0x12,
	0x75, 0xfe, 0x25, 0x10, 0xc4, 0xaf, 0x67, 0xbc, 0xfb, 0x65, 0xee, 0x29, 0x6b, 0x24, 0x55, 0x66,
	0x2b, 0xa1, 0x3e, 0xc7, 0xbf, 0x20, 0x28, 0xc6, 0x49, 0x9b, 0x14, 0x64, 0x7b, 0x68, 0xb3, 0xf2,
	0xdb, 0x7d, 0xa2, 0xe5, 0x32, 0x51, 0xa6, 0xa5, 0xf7, 0xcc, 0x8a, 0x81, 0xb4, 0xea, 0xfc, 0x6b,
	0x04, 0x79, 0x49, 0xe2, 0xa6, 0x78, 0xde, 0xe2, 0x24, 0x71, 0x52, 0x8a, 0x2f, 0x72, 0x56, 0xaf,
	0x2b, 0xbd, 0xee, 0xb2, 0x0a, 0xe1, 0x8e, 0x5b, 0xb4, 0x9e, 0x23, 0x28, 0xc8, 0xea, 0x18, 0x5f,
	0x4d, 0xa1, 0xc4, 0xbc, 0xec, 0xc4, 0x54, 0x4e, 0x6c, 0xb6, 0xe7, 0x75, 0x56, 0x31, 0x03, 0xcf,
	0x15, 0x34, 0xb7, 0xf4, 0x27, 0x82, 0x19, 0x83, 0xd5, 0x93, 0xc8, 0x2c, 0x8d, 0xc9, 0xda, 0x6f,
	0xbd, 0x25, 0x8f, 0xd7, 0xd1, 0x83, 0x75, 0x81, 0xb3, 0x98, 0xa3, 0x53, 0x4b, 0x65, 0xae, 0xa5,
	0x59, 0x84, 0x72, 0xf1, 0x2c, 0xfe, 0xaa, 0xea, 0x0d, 0xdb, 0x3b, 0xf4, 0xcf, 0xea, 0x62, 0x97,
	0xf1, 0x45, 0x6e, 0x70, 0xf5, 0xc6, 0xc6, 0xad, 0x97, 0xb9, 0xe9, 0xd5, 0xc0, 0xf3, 0xb2, 0xc3,
	0x9a, 0xa6, 0x2a, 0x45, 0xe7, 0x9c, 0xee, 0xcd, 0xff, 0x1a, 0xae, 0xd9, 0xe4, 0x6b, 0x36, 0xbb,
	0xd6, 0x6c, 0xde, 0x9b, 0xdf, 0x3a, 0xca, 0xb9, 0x5c, 0xfa, 0x27, 0x00, 0x00, 0xff, 0xff, 0x0e,
	0x92, 0xfd, 0x90, 0x73, 0x16, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ServiceManagerClient is the client API for ServiceManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ServiceManagerClient interface {
	// Lists managed services.
	//
	// Returns all public services. For authenticated users, also returns all
	// services the calling user has "servicemanagement.services.get" permission
	// for.
	//
	// **BETA:** If the caller specifies the `consumer_id`, it returns only the
	// services enabled on the consumer. The `consumer_id` must have the format
	// of "project:{PROJECT-ID}".
	ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error)
	// Gets a managed service. Authentication is required unless the service is
	// public.
	GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*ManagedService, error)
	// Creates a new managed service.
	// Please note one producer project can own no more than 20 services.
	//
	// Operation<response: ManagedService>
	CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a managed service. This method will change the service to the
	// `Soft-Delete` state for 30 days. Within this period, service producers may
	// call [UndeleteService][google.api.servicemanagement.v1.ServiceManager.UndeleteService] to restore the service.
	// After 30 days, the service will be permanently deleted.
	//
	// Operation<response: google.protobuf.Empty>
	DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Revives a previously deleted managed service. The method restores the
	// service using the configuration at the time the service was deleted.
	// The target service must exist and must have been deleted within the
	// last 30 days.
	//
	// Operation<response: UndeleteServiceResponse>
	UndeleteService(ctx context.Context, in *UndeleteServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists the history of the service configuration for a managed service,
	// from the newest to the oldest.
	ListServiceConfigs(ctx context.Context, in *ListServiceConfigsRequest, opts ...grpc.CallOption) (*ListServiceConfigsResponse, error)
	// Gets a service configuration (version) for a managed service.
	GetServiceConfig(ctx context.Context, in *GetServiceConfigRequest, opts ...grpc.CallOption) (*serviceconfig.Service, error)
	// Creates a new service configuration (version) for a managed service.
	// This method only stores the service configuration. To roll out the service
	// configuration to backend systems please call
	// [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
	//
	// Only the 100 most recent service configurations and ones referenced by
	// existing rollouts are kept for each service. The rest will be deleted
	// eventually.
	CreateServiceConfig(ctx context.Context, in *CreateServiceConfigRequest, opts ...grpc.CallOption) (*serviceconfig.Service, error)
	// Creates a new service configuration (version) for a managed service based
	// on
	// user-supplied configuration source files (for example: OpenAPI
	// Specification). This method stores the source configurations as well as the
	// generated service configuration. To rollout the service configuration to
	// other services,
	// please call [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
	//
	// Only the 100 most recent configuration sources and ones referenced by
	// existing service configurtions are kept for each service. The rest will be
	// deleted eventually.
	//
	// Operation<response: SubmitConfigSourceResponse>
	SubmitConfigSource(ctx context.Context, in *SubmitConfigSourceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists the history of the service configuration rollouts for a managed
	// service, from the newest to the oldest.
	ListServiceRollouts(ctx context.Context, in *ListServiceRolloutsRequest, opts ...grpc.CallOption) (*ListServiceRolloutsResponse, error)
	// Gets a service configuration [rollout][google.api.servicemanagement.v1.Rollout].
	GetServiceRollout(ctx context.Context, in *GetServiceRolloutRequest, opts ...grpc.CallOption) (*Rollout, error)
	// Creates a new service configuration rollout. Based on rollout, the
	// Google Service Management will roll out the service configurations to
	// different backend services. For example, the logging configuration will be
	// pushed to Google Cloud Logging.
	//
	// Please note that any previous pending and running Rollouts and associated
	// Operations will be automatically cancelled so that the latest Rollout will
	// not be blocked by previous Rollouts.
	//
	// Only the 100 most recent (in any state) and the last 10 successful (if not
	// already part of the set of 100 most recent) rollouts are kept for each
	// service. The rest will be deleted eventually.
	//
	// Operation<response: Rollout>
	CreateServiceRollout(ctx context.Context, in *CreateServiceRolloutRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Generates and returns a report (errors, warnings and changes from
	// existing configurations) associated with
	// GenerateConfigReportRequest.new_value
	//
	// If GenerateConfigReportRequest.old_value is specified,
	// GenerateConfigReportRequest will contain a single ChangeReport based on the
	// comparison between GenerateConfigReportRequest.new_value and
	// GenerateConfigReportRequest.old_value.
	// If GenerateConfigReportRequest.old_value is not specified, this method
	// will compare GenerateConfigReportRequest.new_value with the last pushed
	// service configuration.
	GenerateConfigReport(ctx context.Context, in *GenerateConfigReportRequest, opts ...grpc.CallOption) (*GenerateConfigReportResponse, error)
	// Enables a [service][google.api.servicemanagement.v1.ManagedService] for a project, so it can be used
	// for the project. See
	// [Cloud Auth Guide](https://cloud.google.com/docs/authentication) for
	// more information.
	//
	// Operation<response: EnableServiceResponse>
	EnableService(ctx context.Context, in *EnableServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Disables a [service][google.api.servicemanagement.v1.ManagedService] for a project, so it can no longer be
	// be used for the project. It prevents accidental usage that may cause
	// unexpected billing charges or security leaks.
	//
	// Operation<response: DisableServiceResponse>
	DisableService(ctx context.Context, in *DisableServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type serviceManagerClient struct {
	cc *grpc.ClientConn
}

func NewServiceManagerClient(cc *grpc.ClientConn) ServiceManagerClient {
	return &serviceManagerClient{cc}
}

func (c *serviceManagerClient) ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error) {
	out := new(ListServicesResponse)
	err := c.cc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/ListServices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*ManagedService, error) {
	out := new(ManagedService)
	err := c.cc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/GetService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/CreateService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/DeleteService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) UndeleteService(ctx context.Context, in *UndeleteServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/UndeleteService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) ListServiceConfigs(ctx context.Context, in *ListServiceConfigsRequest, opts ...grpc.CallOption) (*ListServiceConfigsResponse, error) {
	out := new(ListServiceConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/ListServiceConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) GetServiceConfig(ctx context.Context, in *GetServiceConfigRequest, opts ...grpc.CallOption) (*serviceconfig.Service, error) {
	out := new(serviceconfig.Service)
	err := c.cc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/GetServiceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) CreateServiceConfig(ctx context.Context, in *CreateServiceConfigRequest, opts ...grpc.CallOption) (*serviceconfig.Service, error) {
	out := new(serviceconfig.Service)
	err := c.cc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/CreateServiceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) SubmitConfigSource(ctx context.Context, in *SubmitConfigSourceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/SubmitConfigSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) ListServiceRollouts(ctx context.Context, in *ListServiceRolloutsRequest, opts ...grpc.CallOption) (*ListServiceRolloutsResponse, error) {
	out := new(ListServiceRolloutsResponse)
	err := c.cc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/ListServiceRollouts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) GetServiceRollout(ctx context.Context, in *GetServiceRolloutRequest, opts ...grpc.CallOption) (*Rollout, error) {
	out := new(Rollout)
	err := c.cc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/GetServiceRollout", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) CreateServiceRollout(ctx context.Context, in *CreateServiceRolloutRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/CreateServiceRollout", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) GenerateConfigReport(ctx context.Context, in *GenerateConfigReportRequest, opts ...grpc.CallOption) (*GenerateConfigReportResponse, error) {
	out := new(GenerateConfigReportResponse)
	err := c.cc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/GenerateConfigReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) EnableService(ctx context.Context, in *EnableServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/EnableService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) DisableService(ctx context.Context, in *DisableServiceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/DisableService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServiceManagerServer is the server API for ServiceManager service.
type ServiceManagerServer interface {
	// Lists managed services.
	//
	// Returns all public services. For authenticated users, also returns all
	// services the calling user has "servicemanagement.services.get" permission
	// for.
	//
	// **BETA:** If the caller specifies the `consumer_id`, it returns only the
	// services enabled on the consumer. The `consumer_id` must have the format
	// of "project:{PROJECT-ID}".
	ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error)
	// Gets a managed service. Authentication is required unless the service is
	// public.
	GetService(context.Context, *GetServiceRequest) (*ManagedService, error)
	// Creates a new managed service.
	// Please note one producer project can own no more than 20 services.
	//
	// Operation<response: ManagedService>
	CreateService(context.Context, *CreateServiceRequest) (*longrunning.Operation, error)
	// Deletes a managed service. This method will change the service to the
	// `Soft-Delete` state for 30 days. Within this period, service producers may
	// call [UndeleteService][google.api.servicemanagement.v1.ServiceManager.UndeleteService] to restore the service.
	// After 30 days, the service will be permanently deleted.
	//
	// Operation<response: google.protobuf.Empty>
	DeleteService(context.Context, *DeleteServiceRequest) (*longrunning.Operation, error)
	// Revives a previously deleted managed service. The method restores the
	// service using the configuration at the time the service was deleted.
	// The target service must exist and must have been deleted within the
	// last 30 days.
	//
	// Operation<response: UndeleteServiceResponse>
	UndeleteService(context.Context, *UndeleteServiceRequest) (*longrunning.Operation, error)
	// Lists the history of the service configuration for a managed service,
	// from the newest to the oldest.
	ListServiceConfigs(context.Context, *ListServiceConfigsRequest) (*ListServiceConfigsResponse, error)
	// Gets a service configuration (version) for a managed service.
	GetServiceConfig(context.Context, *GetServiceConfigRequest) (*serviceconfig.Service, error)
	// Creates a new service configuration (version) for a managed service.
	// This method only stores the service configuration. To roll out the service
	// configuration to backend systems please call
	// [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
	//
	// Only the 100 most recent service configurations and ones referenced by
	// existing rollouts are kept for each service. The rest will be deleted
	// eventually.
	CreateServiceConfig(context.Context, *CreateServiceConfigRequest) (*serviceconfig.Service, error)
	// Creates a new service configuration (version) for a managed service based
	// on
	// user-supplied configuration source files (for example: OpenAPI
	// Specification). This method stores the source configurations as well as the
	// generated service configuration. To rollout the service configuration to
	// other services,
	// please call [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
	//
	// Only the 100 most recent configuration sources and ones referenced by
	// existing service configurtions are kept for each service. The rest will be
	// deleted eventually.
	//
	// Operation<response: SubmitConfigSourceResponse>
	SubmitConfigSource(context.Context, *SubmitConfigSourceRequest) (*longrunning.Operation, error)
	// Lists the history of the service configuration rollouts for a managed
	// service, from the newest to the oldest.
	ListServiceRollouts(context.Context, *ListServiceRolloutsRequest) (*ListServiceRolloutsResponse, error)
	// Gets a service configuration [rollout][google.api.servicemanagement.v1.Rollout].
	GetServiceRollout(context.Context, *GetServiceRolloutRequest) (*Rollout, error)
	// Creates a new service configuration rollout. Based on rollout, the
	// Google Service Management will roll out the service configurations to
	// different backend services. For example, the logging configuration will be
	// pushed to Google Cloud Logging.
	//
	// Please note that any previous pending and running Rollouts and associated
	// Operations will be automatically cancelled so that the latest Rollout will
	// not be blocked by previous Rollouts.
	//
	// Only the 100 most recent (in any state) and the last 10 successful (if not
	// already part of the set of 100 most recent) rollouts are kept for each
	// service. The rest will be deleted eventually.
	//
	// Operation<response: Rollout>
	CreateServiceRollout(context.Context, *CreateServiceRolloutRequest) (*longrunning.Operation, error)
	// Generates and returns a report (errors, warnings and changes from
	// existing configurations) associated with
	// GenerateConfigReportRequest.new_value
	//
	// If GenerateConfigReportRequest.old_value is specified,
	// GenerateConfigReportRequest will contain a single ChangeReport based on the
	// comparison between GenerateConfigReportRequest.new_value and
	// GenerateConfigReportRequest.old_value.
	// If GenerateConfigReportRequest.old_value is not specified, this method
	// will compare GenerateConfigReportRequest.new_value with the last pushed
	// service configuration.
	GenerateConfigReport(context.Context, *GenerateConfigReportRequest) (*GenerateConfigReportResponse, error)
	// Enables a [service][google.api.servicemanagement.v1.ManagedService] for a project, so it can be used
	// for the project. See
	// [Cloud Auth Guide](https://cloud.google.com/docs/authentication) for
	// more information.
	//
	// Operation<response: EnableServiceResponse>
	EnableService(context.Context, *EnableServiceRequest) (*longrunning.Operation, error)
	// Disables a [service][google.api.servicemanagement.v1.ManagedService] for a project, so it can no longer be
	// be used for the project. It prevents accidental usage that may cause
	// unexpected billing charges or security leaks.
	//
	// Operation<response: DisableServiceResponse>
	DisableService(context.Context, *DisableServiceRequest) (*longrunning.Operation, error)
}

func RegisterServiceManagerServer(s *grpc.Server, srv ServiceManagerServer) {
	s.RegisterService(&_ServiceManager_serviceDesc, srv)
}

func _ServiceManager_ListServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).ListServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/ListServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).ListServices(ctx, req.(*ListServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_GetService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).GetService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/GetService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).GetService(ctx, req.(*GetServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_CreateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).CreateService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/CreateService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).CreateService(ctx, req.(*CreateServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_DeleteService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).DeleteService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/DeleteService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).DeleteService(ctx, req.(*DeleteServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_UndeleteService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).UndeleteService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/UndeleteService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).UndeleteService(ctx, req.(*UndeleteServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_ListServiceConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).ListServiceConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/ListServiceConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).ListServiceConfigs(ctx, req.(*ListServiceConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_GetServiceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).GetServiceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/GetServiceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).GetServiceConfig(ctx, req.(*GetServiceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_CreateServiceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).CreateServiceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/CreateServiceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).CreateServiceConfig(ctx, req.(*CreateServiceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_SubmitConfigSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubmitConfigSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).SubmitConfigSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/SubmitConfigSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).SubmitConfigSource(ctx, req.(*SubmitConfigSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_ListServiceRollouts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceRolloutsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).ListServiceRollouts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/ListServiceRollouts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).ListServiceRollouts(ctx, req.(*ListServiceRolloutsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_GetServiceRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).GetServiceRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/GetServiceRollout",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).GetServiceRollout(ctx, req.(*GetServiceRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_CreateServiceRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).CreateServiceRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/CreateServiceRollout",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).CreateServiceRollout(ctx, req.(*CreateServiceRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_GenerateConfigReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateConfigReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).GenerateConfigReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/GenerateConfigReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).GenerateConfigReport(ctx, req.(*GenerateConfigReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_EnableService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).EnableService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/EnableService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).EnableService(ctx, req.(*EnableServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_DisableService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).DisableService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/DisableService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).DisableService(ctx, req.(*DisableServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.api.servicemanagement.v1.ServiceManager",
	HandlerType: (*ServiceManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListServices",
			Handler:    _ServiceManager_ListServices_Handler,
		},
		{
			MethodName: "GetService",
			Handler:    _ServiceManager_GetService_Handler,
		},
		{
			MethodName: "CreateService",
			Handler:    _ServiceManager_CreateService_Handler,
		},
		{
			MethodName: "DeleteService",
			Handler:    _ServiceManager_DeleteService_Handler,
		},
		{
			MethodName: "UndeleteService",
			Handler:    _ServiceManager_UndeleteService_Handler,
		},
		{
			MethodName: "ListServiceConfigs",
			Handler:    _ServiceManager_ListServiceConfigs_Handler,
		},
		{
			MethodName: "GetServiceConfig",
			Handler:    _ServiceManager_GetServiceConfig_Handler,
		},
		{
			MethodName: "CreateServiceConfig",
			Handler:    _ServiceManager_CreateServiceConfig_Handler,
		},
		{
			MethodName: "SubmitConfigSource",
			Handler:    _ServiceManager_SubmitConfigSource_Handler,
		},
		{
			MethodName: "ListServiceRollouts",
			Handler:    _ServiceManager_ListServiceRollouts_Handler,
		},
		{
			MethodName: "GetServiceRollout",
			Handler:    _ServiceManager_GetServiceRollout_Handler,
		},
		{
			MethodName: "CreateServiceRollout",
			Handler:    _ServiceManager_CreateServiceRollout_Handler,
		},
		{
			MethodName: "GenerateConfigReport",
			Handler:    _ServiceManager_GenerateConfigReport_Handler,
		},
		{
			MethodName: "EnableService",
			Handler:    _ServiceManager_EnableService_Handler,
		},
		{
			MethodName: "DisableService",
			Handler:    _ServiceManager_DisableService_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/api/servicemanagement/v1/servicemanager.proto",
}
