// +build go1.9

// Copyright 2019 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package dtl

import original "github.com/Azure/azure-sdk-for-go/services/preview/devtestlabs/mgmt/2015-05-21-preview/dtl"

type ArtifactClient = original.ArtifactClient
type ArtifactSourceClient = original.ArtifactSourceClient

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type CostClient = original.CostClient
type CostInsightClient = original.CostInsightClient
type CustomImageClient = original.CustomImageClient
type FormulaClient = original.FormulaClient
type GalleryImageClient = original.GalleryImageClient
type LabClient = original.LabClient
type CostPropertyType = original.CostPropertyType

const (
	Projected   CostPropertyType = original.Projected
	Reported    CostPropertyType = original.Reported
	Unavailable CostPropertyType = original.Unavailable
)

type CustomImageOsType = original.CustomImageOsType

const (
	Linux   CustomImageOsType = original.Linux
	None    CustomImageOsType = original.None
	Windows CustomImageOsType = original.Windows
)

type EnableStatus = original.EnableStatus

const (
	Disabled EnableStatus = original.Disabled
	Enabled  EnableStatus = original.Enabled
)

type LabStorageType = original.LabStorageType

const (
	Premium  LabStorageType = original.Premium
	Standard LabStorageType = original.Standard
)

type LinuxOsState = original.LinuxOsState

const (
	DeprovisionApplied   LinuxOsState = original.DeprovisionApplied
	DeprovisionRequested LinuxOsState = original.DeprovisionRequested
	NonDeprovisioned     LinuxOsState = original.NonDeprovisioned
)

type PolicyEvaluatorType = original.PolicyEvaluatorType

const (
	AllowedValuesPolicy PolicyEvaluatorType = original.AllowedValuesPolicy
	MaxValuePolicy      PolicyEvaluatorType = original.MaxValuePolicy
)

type PolicyFactName = original.PolicyFactName

const (
	PolicyFactNameGalleryImage                PolicyFactName = original.PolicyFactNameGalleryImage
	PolicyFactNameLabVMCount                  PolicyFactName = original.PolicyFactNameLabVMCount
	PolicyFactNameLabVMSize                   PolicyFactName = original.PolicyFactNameLabVMSize
	PolicyFactNameUserOwnedLabVMCount         PolicyFactName = original.PolicyFactNameUserOwnedLabVMCount
	PolicyFactNameUserOwnedLabVMCountInSubnet PolicyFactName = original.PolicyFactNameUserOwnedLabVMCountInSubnet
)

type PolicyStatus = original.PolicyStatus

const (
	PolicyStatusDisabled PolicyStatus = original.PolicyStatusDisabled
	PolicyStatusEnabled  PolicyStatus = original.PolicyStatusEnabled
)

type SourceControlType = original.SourceControlType

const (
	GitHub SourceControlType = original.GitHub
	VsoGit SourceControlType = original.VsoGit
)

type SubscriptionNotificationState = original.SubscriptionNotificationState

const (
	Deleted      SubscriptionNotificationState = original.Deleted
	NotDefined   SubscriptionNotificationState = original.NotDefined
	Registered   SubscriptionNotificationState = original.Registered
	Suspended    SubscriptionNotificationState = original.Suspended
	Unregistered SubscriptionNotificationState = original.Unregistered
	Warned       SubscriptionNotificationState = original.Warned
)

type TaskType = original.TaskType

const (
	LabBillingTask     TaskType = original.LabBillingTask
	LabVmsShutdownTask TaskType = original.LabVmsShutdownTask
	LabVmsStartupTask  TaskType = original.LabVmsStartupTask
)

type UsagePermissionType = original.UsagePermissionType

const (
	Allow   UsagePermissionType = original.Allow
	Default UsagePermissionType = original.Default
	Deny    UsagePermissionType = original.Deny
)

type WindowsOsState = original.WindowsOsState

const (
	NonSysprepped    WindowsOsState = original.NonSysprepped
	SysprepApplied   WindowsOsState = original.SysprepApplied
	SysprepRequested WindowsOsState = original.SysprepRequested
)

type ApplyArtifactsRequest = original.ApplyArtifactsRequest
type ArmTemplateInfo = original.ArmTemplateInfo
type Artifact = original.Artifact
type ArtifactDeploymentStatusProperties = original.ArtifactDeploymentStatusProperties
type ArtifactInstallProperties = original.ArtifactInstallProperties
type ArtifactParameterProperties = original.ArtifactParameterProperties
type ArtifactProperties = original.ArtifactProperties
type ArtifactSource = original.ArtifactSource
type ArtifactSourceProperties = original.ArtifactSourceProperties
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type Cost = original.Cost
type CostInsight = original.CostInsight
type CostInsightProperties = original.CostInsightProperties
type CostInsightRefreshDataFuture = original.CostInsightRefreshDataFuture
type CostPerDayProperties = original.CostPerDayProperties
type CostProperties = original.CostProperties
type CostRefreshDataFuture = original.CostRefreshDataFuture
type CustomImage = original.CustomImage
type CustomImageCreateOrUpdateResourceFuture = original.CustomImageCreateOrUpdateResourceFuture
type CustomImageDeleteResourceFuture = original.CustomImageDeleteResourceFuture
type CustomImageProperties = original.CustomImageProperties
type CustomImagePropertiesCustom = original.CustomImagePropertiesCustom
type CustomImagePropertiesFromVM = original.CustomImagePropertiesFromVM
type DayDetails = original.DayDetails
type EvaluatePoliciesProperties = original.EvaluatePoliciesProperties
type EvaluatePoliciesRequest = original.EvaluatePoliciesRequest
type EvaluatePoliciesResponse = original.EvaluatePoliciesResponse
type Formula = original.Formula
type FormulaCreateOrUpdateResourceFuture = original.FormulaCreateOrUpdateResourceFuture
type FormulaProperties = original.FormulaProperties
type FormulaPropertiesFromVM = original.FormulaPropertiesFromVM
type GalleryImage = original.GalleryImage
type GalleryImageProperties = original.GalleryImageProperties
type GalleryImageReference = original.GalleryImageReference
type GenerateArmTemplateRequest = original.GenerateArmTemplateRequest
type GenerateUploadURIParameter = original.GenerateUploadURIParameter
type GenerateUploadURIResponse = original.GenerateUploadURIResponse
type HourDetails = original.HourDetails
type Lab = original.Lab
type LabCreateEnvironmentFuture = original.LabCreateEnvironmentFuture
type LabCreateOrUpdateResourceFuture = original.LabCreateOrUpdateResourceFuture
type LabDeleteResourceFuture = original.LabDeleteResourceFuture
type LabProperties = original.LabProperties
type LabVhd = original.LabVhd
type LabVirtualMachine = original.LabVirtualMachine
type LabVirtualMachineProperties = original.LabVirtualMachineProperties
type LinuxOsInfo = original.LinuxOsInfo
type ParameterInfo = original.ParameterInfo
type Policy = original.Policy
type PolicyProperties = original.PolicyProperties
type PolicySetResult = original.PolicySetResult
type PolicyViolation = original.PolicyViolation
type ResponseWithContinuationArtifact = original.ResponseWithContinuationArtifact
type ResponseWithContinuationArtifactIterator = original.ResponseWithContinuationArtifactIterator
type ResponseWithContinuationArtifactPage = original.ResponseWithContinuationArtifactPage
type ResponseWithContinuationArtifactSource = original.ResponseWithContinuationArtifactSource
type ResponseWithContinuationArtifactSourceIterator = original.ResponseWithContinuationArtifactSourceIterator
type ResponseWithContinuationArtifactSourcePage = original.ResponseWithContinuationArtifactSourcePage
type ResponseWithContinuationCost = original.ResponseWithContinuationCost
type ResponseWithContinuationCostInsight = original.ResponseWithContinuationCostInsight
type ResponseWithContinuationCostInsightIterator = original.ResponseWithContinuationCostInsightIterator
type ResponseWithContinuationCostInsightPage = original.ResponseWithContinuationCostInsightPage
type ResponseWithContinuationCostIterator = original.ResponseWithContinuationCostIterator
type ResponseWithContinuationCostPage = original.ResponseWithContinuationCostPage
type ResponseWithContinuationCustomImage = original.ResponseWithContinuationCustomImage
type ResponseWithContinuationCustomImageIterator = original.ResponseWithContinuationCustomImageIterator
type ResponseWithContinuationCustomImagePage = original.ResponseWithContinuationCustomImagePage
type ResponseWithContinuationFormula = original.ResponseWithContinuationFormula
type ResponseWithContinuationFormulaIterator = original.ResponseWithContinuationFormulaIterator
type ResponseWithContinuationFormulaPage = original.ResponseWithContinuationFormulaPage
type ResponseWithContinuationGalleryImage = original.ResponseWithContinuationGalleryImage
type ResponseWithContinuationGalleryImageIterator = original.ResponseWithContinuationGalleryImageIterator
type ResponseWithContinuationGalleryImagePage = original.ResponseWithContinuationGalleryImagePage
type ResponseWithContinuationLab = original.ResponseWithContinuationLab
type ResponseWithContinuationLabIterator = original.ResponseWithContinuationLabIterator
type ResponseWithContinuationLabPage = original.ResponseWithContinuationLabPage
type ResponseWithContinuationLabVhd = original.ResponseWithContinuationLabVhd
type ResponseWithContinuationLabVhdIterator = original.ResponseWithContinuationLabVhdIterator
type ResponseWithContinuationLabVhdPage = original.ResponseWithContinuationLabVhdPage
type ResponseWithContinuationLabVirtualMachine = original.ResponseWithContinuationLabVirtualMachine
type ResponseWithContinuationLabVirtualMachineIterator = original.ResponseWithContinuationLabVirtualMachineIterator
type ResponseWithContinuationLabVirtualMachinePage = original.ResponseWithContinuationLabVirtualMachinePage
type ResponseWithContinuationPolicy = original.ResponseWithContinuationPolicy
type ResponseWithContinuationPolicyIterator = original.ResponseWithContinuationPolicyIterator
type ResponseWithContinuationPolicyPage = original.ResponseWithContinuationPolicyPage
type ResponseWithContinuationSchedule = original.ResponseWithContinuationSchedule
type ResponseWithContinuationScheduleIterator = original.ResponseWithContinuationScheduleIterator
type ResponseWithContinuationSchedulePage = original.ResponseWithContinuationSchedulePage
type ResponseWithContinuationVirtualNetwork = original.ResponseWithContinuationVirtualNetwork
type ResponseWithContinuationVirtualNetworkIterator = original.ResponseWithContinuationVirtualNetworkIterator
type ResponseWithContinuationVirtualNetworkPage = original.ResponseWithContinuationVirtualNetworkPage
type Schedule = original.Schedule
type ScheduleCreateOrUpdateResourceFuture = original.ScheduleCreateOrUpdateResourceFuture
type ScheduleDeleteResourceFuture = original.ScheduleDeleteResourceFuture
type ScheduleExecuteFuture = original.ScheduleExecuteFuture
type ScheduleProperties = original.ScheduleProperties
type Subnet = original.Subnet
type SubnetOverride = original.SubnetOverride
type SubscriptionNotification = original.SubscriptionNotification
type SubscriptionNotificationProperties = original.SubscriptionNotificationProperties
type VirtualMachineApplyArtifactsFuture = original.VirtualMachineApplyArtifactsFuture
type VirtualMachineCreateOrUpdateResourceFuture = original.VirtualMachineCreateOrUpdateResourceFuture
type VirtualMachineDeleteResourceFuture = original.VirtualMachineDeleteResourceFuture
type VirtualMachineStartFuture = original.VirtualMachineStartFuture
type VirtualMachineStopFuture = original.VirtualMachineStopFuture
type VirtualNetwork = original.VirtualNetwork
type VirtualNetworkCreateOrUpdateResourceFuture = original.VirtualNetworkCreateOrUpdateResourceFuture
type VirtualNetworkDeleteResourceFuture = original.VirtualNetworkDeleteResourceFuture
type VirtualNetworkProperties = original.VirtualNetworkProperties
type VMCostProperties = original.VMCostProperties
type WeekDetails = original.WeekDetails
type WindowsOsInfo = original.WindowsOsInfo
type PolicyClient = original.PolicyClient
type PolicySetClient = original.PolicySetClient
type ScheduleClient = original.ScheduleClient
type VirtualMachineClient = original.VirtualMachineClient
type VirtualNetworkClient = original.VirtualNetworkClient

func NewArtifactClient(subscriptionID string) ArtifactClient {
	return original.NewArtifactClient(subscriptionID)
}
func NewArtifactClientWithBaseURI(baseURI string, subscriptionID string) ArtifactClient {
	return original.NewArtifactClientWithBaseURI(baseURI, subscriptionID)
}
func NewArtifactSourceClient(subscriptionID string) ArtifactSourceClient {
	return original.NewArtifactSourceClient(subscriptionID)
}
func NewArtifactSourceClientWithBaseURI(baseURI string, subscriptionID string) ArtifactSourceClient {
	return original.NewArtifactSourceClientWithBaseURI(baseURI, subscriptionID)
}
func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewCostClient(subscriptionID string) CostClient {
	return original.NewCostClient(subscriptionID)
}
func NewCostClientWithBaseURI(baseURI string, subscriptionID string) CostClient {
	return original.NewCostClientWithBaseURI(baseURI, subscriptionID)
}
func NewCostInsightClient(subscriptionID string) CostInsightClient {
	return original.NewCostInsightClient(subscriptionID)
}
func NewCostInsightClientWithBaseURI(baseURI string, subscriptionID string) CostInsightClient {
	return original.NewCostInsightClientWithBaseURI(baseURI, subscriptionID)
}
func NewCustomImageClient(subscriptionID string) CustomImageClient {
	return original.NewCustomImageClient(subscriptionID)
}
func NewCustomImageClientWithBaseURI(baseURI string, subscriptionID string) CustomImageClient {
	return original.NewCustomImageClientWithBaseURI(baseURI, subscriptionID)
}
func NewFormulaClient(subscriptionID string) FormulaClient {
	return original.NewFormulaClient(subscriptionID)
}
func NewFormulaClientWithBaseURI(baseURI string, subscriptionID string) FormulaClient {
	return original.NewFormulaClientWithBaseURI(baseURI, subscriptionID)
}
func NewGalleryImageClient(subscriptionID string) GalleryImageClient {
	return original.NewGalleryImageClient(subscriptionID)
}
func NewGalleryImageClientWithBaseURI(baseURI string, subscriptionID string) GalleryImageClient {
	return original.NewGalleryImageClientWithBaseURI(baseURI, subscriptionID)
}
func NewLabClient(subscriptionID string) LabClient {
	return original.NewLabClient(subscriptionID)
}
func NewLabClientWithBaseURI(baseURI string, subscriptionID string) LabClient {
	return original.NewLabClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleCostPropertyTypeValues() []CostPropertyType {
	return original.PossibleCostPropertyTypeValues()
}
func PossibleCustomImageOsTypeValues() []CustomImageOsType {
	return original.PossibleCustomImageOsTypeValues()
}
func PossibleEnableStatusValues() []EnableStatus {
	return original.PossibleEnableStatusValues()
}
func PossibleLabStorageTypeValues() []LabStorageType {
	return original.PossibleLabStorageTypeValues()
}
func PossibleLinuxOsStateValues() []LinuxOsState {
	return original.PossibleLinuxOsStateValues()
}
func PossiblePolicyEvaluatorTypeValues() []PolicyEvaluatorType {
	return original.PossiblePolicyEvaluatorTypeValues()
}
func PossiblePolicyFactNameValues() []PolicyFactName {
	return original.PossiblePolicyFactNameValues()
}
func PossiblePolicyStatusValues() []PolicyStatus {
	return original.PossiblePolicyStatusValues()
}
func PossibleSourceControlTypeValues() []SourceControlType {
	return original.PossibleSourceControlTypeValues()
}
func PossibleSubscriptionNotificationStateValues() []SubscriptionNotificationState {
	return original.PossibleSubscriptionNotificationStateValues()
}
func PossibleTaskTypeValues() []TaskType {
	return original.PossibleTaskTypeValues()
}
func PossibleUsagePermissionTypeValues() []UsagePermissionType {
	return original.PossibleUsagePermissionTypeValues()
}
func PossibleWindowsOsStateValues() []WindowsOsState {
	return original.PossibleWindowsOsStateValues()
}
func NewPolicyClient(subscriptionID string) PolicyClient {
	return original.NewPolicyClient(subscriptionID)
}
func NewPolicyClientWithBaseURI(baseURI string, subscriptionID string) PolicyClient {
	return original.NewPolicyClientWithBaseURI(baseURI, subscriptionID)
}
func NewPolicySetClient(subscriptionID string) PolicySetClient {
	return original.NewPolicySetClient(subscriptionID)
}
func NewPolicySetClientWithBaseURI(baseURI string, subscriptionID string) PolicySetClient {
	return original.NewPolicySetClientWithBaseURI(baseURI, subscriptionID)
}
func NewScheduleClient(subscriptionID string) ScheduleClient {
	return original.NewScheduleClient(subscriptionID)
}
func NewScheduleClientWithBaseURI(baseURI string, subscriptionID string) ScheduleClient {
	return original.NewScheduleClientWithBaseURI(baseURI, subscriptionID)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
func NewVirtualMachineClient(subscriptionID string) VirtualMachineClient {
	return original.NewVirtualMachineClient(subscriptionID)
}
func NewVirtualMachineClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineClient {
	return original.NewVirtualMachineClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworkClient(subscriptionID string) VirtualNetworkClient {
	return original.NewVirtualNetworkClient(subscriptionID)
}
func NewVirtualNetworkClientWithBaseURI(baseURI string, subscriptionID string) VirtualNetworkClient {
	return original.NewVirtualNetworkClientWithBaseURI(baseURI, subscriptionID)
}
