## helm search

Search for a keyword in charts

### Synopsis


Search reads through all of the repositories configured on the system, and
looks for matches.

Repositories are managed with 'helm repo' commands.

To look for charts with a particular name (such as stable/mysql), try
searching using vertical tabs (\v). Vertical tabs are used as the delimiter
between search fields. For example:

    helm search --regexp '\vstable/mysql\v'

To search for charts using common keywords (such as "database" or
"key-value store"), use

    helm search database

or

    helm search key-value store


```
helm search [keyword] [flags]
```

### Options

```
      --col-width uint   Specifies the max column width of output (default 60)
  -h, --help             help for search
  -o, --output string    Prints the output in the specified format. Allowed values: table, json, yaml (default "table")
  -r, --regexp           Use regular expressions for searching
  -v, --version string   Search using semantic versioning constraints
  -l, --versions         Show the long listing, with each version of each chart on its own line
```

### Options inherited from parent commands

```
      --debug                           Enable verbose output
      --home string                     Location of your Helm config. Overrides $HELM_HOME (default "~/.helm")
      --host string                     Address of Tiller. Overrides $HELM_HOST
      --kube-context string             Name of the kubeconfig context to use
      --kubeconfig string               Absolute path of the kubeconfig file to be used
      --tiller-connection-timeout int   The duration (in seconds) Helm will wait to establish a connection to Tiller (default 300)
      --tiller-namespace string         Namespace of Tiller (default "kube-system")
```

### SEE ALSO

* [helm](helm.md)	 - The Helm package manager for Kubernetes.

###### Auto generated by spf13/cobra on 24-Sep-2019
