/*
Copyright 2019 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	operators "github.com/operator-framework/operator-lifecycle-manager/pkg/api/apis/operators"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCatalogSources implements CatalogSourceInterface
type FakeCatalogSources struct {
	Fake *FakeOperators
	ns   string
}

var catalogsourcesResource = schema.GroupVersionResource{Group: "operators.coreos.com", Version: "", Resource: "catalogsources"}

var catalogsourcesKind = schema.GroupVersionKind{Group: "operators.coreos.com", Version: "", Kind: "CatalogSource"}

// Get takes name of the catalogSource, and returns the corresponding catalogSource object, and an error if there is any.
func (c *FakeCatalogSources) Get(name string, options v1.GetOptions) (result *operators.CatalogSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(catalogsourcesResource, c.ns, name), &operators.CatalogSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*operators.CatalogSource), err
}

// List takes label and field selectors, and returns the list of CatalogSources that match those selectors.
func (c *FakeCatalogSources) List(opts v1.ListOptions) (result *operators.CatalogSourceList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(catalogsourcesResource, catalogsourcesKind, c.ns, opts), &operators.CatalogSourceList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &operators.CatalogSourceList{ListMeta: obj.(*operators.CatalogSourceList).ListMeta}
	for _, item := range obj.(*operators.CatalogSourceList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested catalogSources.
func (c *FakeCatalogSources) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(catalogsourcesResource, c.ns, opts))

}

// Create takes the representation of a catalogSource and creates it.  Returns the server's representation of the catalogSource, and an error, if there is any.
func (c *FakeCatalogSources) Create(catalogSource *operators.CatalogSource) (result *operators.CatalogSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(catalogsourcesResource, c.ns, catalogSource), &operators.CatalogSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*operators.CatalogSource), err
}

// Update takes the representation of a catalogSource and updates it. Returns the server's representation of the catalogSource, and an error, if there is any.
func (c *FakeCatalogSources) Update(catalogSource *operators.CatalogSource) (result *operators.CatalogSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(catalogsourcesResource, c.ns, catalogSource), &operators.CatalogSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*operators.CatalogSource), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeCatalogSources) UpdateStatus(catalogSource *operators.CatalogSource) (*operators.CatalogSource, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(catalogsourcesResource, "status", c.ns, catalogSource), &operators.CatalogSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*operators.CatalogSource), err
}

// Delete takes name of the catalogSource and deletes it. Returns an error if one occurs.
func (c *FakeCatalogSources) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(catalogsourcesResource, c.ns, name), &operators.CatalogSource{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCatalogSources) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(catalogsourcesResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &operators.CatalogSourceList{})
	return err
}

// Patch applies the patch and returns the patched catalogSource.
func (c *FakeCatalogSources) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *operators.CatalogSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(catalogsourcesResource, c.ns, name, data, subresources...), &operators.CatalogSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*operators.CatalogSource), err
}
