// +build !ignore_autogenerated

/*
Copyright 2016 The Kubernetes Authors All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was autogenerated by deepcopy-gen. Do not edit it manually!

package meta

import (
	unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	conversion "k8s.io/kubernetes/pkg/conversion"
	runtime "k8s.io/kubernetes/pkg/runtime"
)

func DeepCopy_meta_DefaultRESTMapper(in DefaultRESTMapper, out *DefaultRESTMapper, c *conversion.Cloner) error {
	if in.defaultGroupVersions != nil {
		in, out := in.defaultGroupVersions, &out.defaultGroupVersions
		*out = make([]unversioned.GroupVersion, len(in))
		for i := range in {
			if err := unversioned.DeepCopy_unversioned_GroupVersion(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.defaultGroupVersions = nil
	}
	if in.resourceToKind != nil {
		in, out := in.resourceToKind, &out.resourceToKind
		*out = make(map[unversioned.GroupVersionResource]unversioned.GroupVersionKind)
		for range in {
			// FIXME: Copying unassignable keys unsupported unversioned.GroupVersionResource
		}
	} else {
		out.resourceToKind = nil
	}
	if in.kindToPluralResource != nil {
		in, out := in.kindToPluralResource, &out.kindToPluralResource
		*out = make(map[unversioned.GroupVersionKind]unversioned.GroupVersionResource)
		for range in {
			// FIXME: Copying unassignable keys unsupported unversioned.GroupVersionKind
		}
	} else {
		out.kindToPluralResource = nil
	}
	if in.kindToScope != nil {
		in, out := in.kindToScope, &out.kindToScope
		*out = make(map[unversioned.GroupVersionKind]RESTScope)
		for range in {
			// FIXME: Copying unassignable keys unsupported unversioned.GroupVersionKind
		}
	} else {
		out.kindToScope = nil
	}
	if in.singularToPlural != nil {
		in, out := in.singularToPlural, &out.singularToPlural
		*out = make(map[unversioned.GroupVersionResource]unversioned.GroupVersionResource)
		for range in {
			// FIXME: Copying unassignable keys unsupported unversioned.GroupVersionResource
		}
	} else {
		out.singularToPlural = nil
	}
	if in.pluralToSingular != nil {
		in, out := in.pluralToSingular, &out.pluralToSingular
		*out = make(map[unversioned.GroupVersionResource]unversioned.GroupVersionResource)
		for range in {
			// FIXME: Copying unassignable keys unsupported unversioned.GroupVersionResource
		}
	} else {
		out.pluralToSingular = nil
	}
	if in.interfacesFunc == nil {
		out.interfacesFunc = nil
	} else if newVal, err := c.DeepCopy(in.interfacesFunc); err != nil {
		return err
	} else {
		out.interfacesFunc = newVal.(VersionInterfacesFunc)
	}
	if in.aliasToResource != nil {
		in, out := in.aliasToResource, &out.aliasToResource
		*out = make(map[string][]string)
		for key, val := range in {
			if newVal, err := c.DeepCopy(val); err != nil {
				return err
			} else {
				(*out)[key] = newVal.([]string)
			}
		}
	} else {
		out.aliasToResource = nil
	}
	return nil
}

func DeepCopy_meta_RESTMapping(in RESTMapping, out *RESTMapping, c *conversion.Cloner) error {
	out.Resource = in.Resource
	if err := unversioned.DeepCopy_unversioned_GroupVersionKind(in.GroupVersionKind, &out.GroupVersionKind, c); err != nil {
		return err
	}
	if in.Scope == nil {
		out.Scope = nil
	} else if newVal, err := c.DeepCopy(in.Scope); err != nil {
		return err
	} else {
		out.Scope = newVal.(RESTScope)
	}
	if in.ObjectConvertor == nil {
		out.ObjectConvertor = nil
	} else if newVal, err := c.DeepCopy(in.ObjectConvertor); err != nil {
		return err
	} else {
		out.ObjectConvertor = newVal.(runtime.ObjectConvertor)
	}
	if in.MetadataAccessor == nil {
		out.MetadataAccessor = nil
	} else if newVal, err := c.DeepCopy(in.MetadataAccessor); err != nil {
		return err
	} else {
		out.MetadataAccessor = newVal.(MetadataAccessor)
	}
	return nil
}

func DeepCopy_meta_VersionInterfaces(in VersionInterfaces, out *VersionInterfaces, c *conversion.Cloner) error {
	if in.ObjectConvertor == nil {
		out.ObjectConvertor = nil
	} else if newVal, err := c.DeepCopy(in.ObjectConvertor); err != nil {
		return err
	} else {
		out.ObjectConvertor = newVal.(runtime.ObjectConvertor)
	}
	if in.MetadataAccessor == nil {
		out.MetadataAccessor = nil
	} else if newVal, err := c.DeepCopy(in.MetadataAccessor); err != nil {
		return err
	} else {
		out.MetadataAccessor = newVal.(MetadataAccessor)
	}
	return nil
}
