/*
Copyright 2018 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was generated by "go run gen/main.go -mode test > gen_test.go". Do not edit
// directly.

package cloud

import (
	"context"
	"reflect"
	"testing"

	alpha "google.golang.org/api/compute/v0.alpha"
	beta "google.golang.org/api/compute/v0.beta"
	ga "google.golang.org/api/compute/v1"

	"github.com/GoogleCloudPlatform/k8s-cloud-provider/pkg/cloud/filter"
	"github.com/GoogleCloudPlatform/k8s-cloud-provider/pkg/cloud/meta"
)

const location = "location"

func TestAddressesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.RegionalKey("key-alpha", "location")
	key = keyAlpha
	keyBeta := meta.RegionalKey("key-beta", "location")
	key = keyBeta
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaAddresses().Get(ctx, key); err == nil {
		t.Errorf("AlphaAddresses().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaAddresses().Get(ctx, key); err == nil {
		t.Errorf("BetaAddresses().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.Addresses().Get(ctx, key); err == nil {
		t.Errorf("Addresses().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &alpha.Address{}
		if err := mock.AlphaAddresses().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaAddresses().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &beta.Address{}
		if err := mock.BetaAddresses().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaAddresses().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &ga.Address{}
		if err := mock.Addresses().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("Addresses().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaAddresses().Get(ctx, key); err != nil {
		t.Errorf("AlphaAddresses().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaAddresses().Get(ctx, key); err != nil {
		t.Errorf("BetaAddresses().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.Addresses().Get(ctx, key); err != nil {
		t.Errorf("Addresses().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaAddresses.Objects[*keyAlpha] = mock.MockAlphaAddresses.Obj(&alpha.Address{Name: keyAlpha.Name})
	mock.MockBetaAddresses.Objects[*keyBeta] = mock.MockBetaAddresses.Obj(&beta.Address{Name: keyBeta.Name})
	mock.MockAddresses.Objects[*keyGA] = mock.MockAddresses.Obj(&ga.Address{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaAddresses().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaAddresses().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaAddresses().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaAddresses().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("BetaAddresses().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaAddresses().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.Addresses().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("Addresses().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Addresses().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaAddresses().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaAddresses().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaAddresses().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaAddresses().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.Addresses().Delete(ctx, keyGA); err != nil {
		t.Errorf("Addresses().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaAddresses().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaAddresses().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaAddresses().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaAddresses().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.Addresses().Delete(ctx, keyGA); err == nil {
		t.Errorf("Addresses().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestBackendServicesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.GlobalKey("key-alpha")
	key = keyAlpha
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaBackendServices().Get(ctx, key); err == nil {
		t.Errorf("AlphaBackendServices().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaBackendServices().Get(ctx, key); err == nil {
		t.Errorf("BetaBackendServices().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BackendServices().Get(ctx, key); err == nil {
		t.Errorf("BackendServices().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &alpha.BackendService{}
		if err := mock.AlphaBackendServices().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaBackendServices().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &beta.BackendService{}
		if err := mock.BetaBackendServices().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaBackendServices().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &ga.BackendService{}
		if err := mock.BackendServices().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("BackendServices().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaBackendServices().Get(ctx, key); err != nil {
		t.Errorf("AlphaBackendServices().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaBackendServices().Get(ctx, key); err != nil {
		t.Errorf("BetaBackendServices().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BackendServices().Get(ctx, key); err != nil {
		t.Errorf("BackendServices().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaBackendServices.Objects[*keyAlpha] = mock.MockAlphaBackendServices.Obj(&alpha.BackendService{Name: keyAlpha.Name})
	mock.MockBetaBackendServices.Objects[*keyBeta] = mock.MockBetaBackendServices.Obj(&beta.BackendService{Name: keyBeta.Name})
	mock.MockBackendServices.Objects[*keyGA] = mock.MockBackendServices.Obj(&ga.BackendService{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaBackendServices().List(ctx, filter.None)
		if err != nil {
			t.Errorf("AlphaBackendServices().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaBackendServices().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaBackendServices().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaBackendServices().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaBackendServices().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BackendServices().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BackendServices().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BackendServices().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaBackendServices().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaBackendServices().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaBackendServices().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaBackendServices().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.BackendServices().Delete(ctx, keyGA); err != nil {
		t.Errorf("BackendServices().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaBackendServices().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaBackendServices().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaBackendServices().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaBackendServices().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.BackendServices().Delete(ctx, keyGA); err == nil {
		t.Errorf("BackendServices().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestDisksGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.ZonalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.Disks().Get(ctx, key); err == nil {
		t.Errorf("Disks().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &ga.Disk{}
		if err := mock.Disks().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("Disks().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.Disks().Get(ctx, key); err != nil {
		t.Errorf("Disks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockDisks.Objects[*keyGA] = mock.MockDisks.Obj(&ga.Disk{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.Disks().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("Disks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Disks().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.Disks().Delete(ctx, keyGA); err != nil {
		t.Errorf("Disks().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.Disks().Delete(ctx, keyGA); err == nil {
		t.Errorf("Disks().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestFirewallsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.Firewalls().Get(ctx, key); err == nil {
		t.Errorf("Firewalls().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &ga.Firewall{}
		if err := mock.Firewalls().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("Firewalls().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.Firewalls().Get(ctx, key); err != nil {
		t.Errorf("Firewalls().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockFirewalls.Objects[*keyGA] = mock.MockFirewalls.Obj(&ga.Firewall{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.Firewalls().List(ctx, filter.None)
		if err != nil {
			t.Errorf("Firewalls().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Firewalls().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.Firewalls().Delete(ctx, keyGA); err != nil {
		t.Errorf("Firewalls().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.Firewalls().Delete(ctx, keyGA); err == nil {
		t.Errorf("Firewalls().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestForwardingRulesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.RegionalKey("key-alpha", "location")
	key = keyAlpha
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaForwardingRules().Get(ctx, key); err == nil {
		t.Errorf("AlphaForwardingRules().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.ForwardingRules().Get(ctx, key); err == nil {
		t.Errorf("ForwardingRules().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &alpha.ForwardingRule{}
		if err := mock.AlphaForwardingRules().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaForwardingRules().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &ga.ForwardingRule{}
		if err := mock.ForwardingRules().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("ForwardingRules().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaForwardingRules().Get(ctx, key); err != nil {
		t.Errorf("AlphaForwardingRules().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.ForwardingRules().Get(ctx, key); err != nil {
		t.Errorf("ForwardingRules().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaForwardingRules.Objects[*keyAlpha] = mock.MockAlphaForwardingRules.Obj(&alpha.ForwardingRule{Name: keyAlpha.Name})
	mock.MockForwardingRules.Objects[*keyGA] = mock.MockForwardingRules.Obj(&ga.ForwardingRule{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaForwardingRules().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaForwardingRules().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaForwardingRules().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.ForwardingRules().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("ForwardingRules().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("ForwardingRules().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaForwardingRules().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaForwardingRules().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.ForwardingRules().Delete(ctx, keyGA); err != nil {
		t.Errorf("ForwardingRules().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaForwardingRules().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaForwardingRules().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.ForwardingRules().Delete(ctx, keyGA); err == nil {
		t.Errorf("ForwardingRules().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestGlobalAddressesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.GlobalAddresses().Get(ctx, key); err == nil {
		t.Errorf("GlobalAddresses().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &ga.Address{}
		if err := mock.GlobalAddresses().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("GlobalAddresses().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.GlobalAddresses().Get(ctx, key); err != nil {
		t.Errorf("GlobalAddresses().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockGlobalAddresses.Objects[*keyGA] = mock.MockGlobalAddresses.Obj(&ga.Address{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.GlobalAddresses().List(ctx, filter.None)
		if err != nil {
			t.Errorf("GlobalAddresses().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("GlobalAddresses().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.GlobalAddresses().Delete(ctx, keyGA); err != nil {
		t.Errorf("GlobalAddresses().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.GlobalAddresses().Delete(ctx, keyGA); err == nil {
		t.Errorf("GlobalAddresses().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestGlobalForwardingRulesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.GlobalForwardingRules().Get(ctx, key); err == nil {
		t.Errorf("GlobalForwardingRules().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &ga.ForwardingRule{}
		if err := mock.GlobalForwardingRules().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("GlobalForwardingRules().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.GlobalForwardingRules().Get(ctx, key); err != nil {
		t.Errorf("GlobalForwardingRules().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockGlobalForwardingRules.Objects[*keyGA] = mock.MockGlobalForwardingRules.Obj(&ga.ForwardingRule{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.GlobalForwardingRules().List(ctx, filter.None)
		if err != nil {
			t.Errorf("GlobalForwardingRules().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("GlobalForwardingRules().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.GlobalForwardingRules().Delete(ctx, keyGA); err != nil {
		t.Errorf("GlobalForwardingRules().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.GlobalForwardingRules().Delete(ctx, keyGA); err == nil {
		t.Errorf("GlobalForwardingRules().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestHealthChecksGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.GlobalKey("key-alpha")
	key = keyAlpha
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaHealthChecks().Get(ctx, key); err == nil {
		t.Errorf("AlphaHealthChecks().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaHealthChecks().Get(ctx, key); err == nil {
		t.Errorf("BetaHealthChecks().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.HealthChecks().Get(ctx, key); err == nil {
		t.Errorf("HealthChecks().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &alpha.HealthCheck{}
		if err := mock.AlphaHealthChecks().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaHealthChecks().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &beta.HealthCheck{}
		if err := mock.BetaHealthChecks().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaHealthChecks().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &ga.HealthCheck{}
		if err := mock.HealthChecks().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("HealthChecks().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaHealthChecks().Get(ctx, key); err != nil {
		t.Errorf("AlphaHealthChecks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaHealthChecks().Get(ctx, key); err != nil {
		t.Errorf("BetaHealthChecks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.HealthChecks().Get(ctx, key); err != nil {
		t.Errorf("HealthChecks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaHealthChecks.Objects[*keyAlpha] = mock.MockAlphaHealthChecks.Obj(&alpha.HealthCheck{Name: keyAlpha.Name})
	mock.MockBetaHealthChecks.Objects[*keyBeta] = mock.MockBetaHealthChecks.Obj(&beta.HealthCheck{Name: keyBeta.Name})
	mock.MockHealthChecks.Objects[*keyGA] = mock.MockHealthChecks.Obj(&ga.HealthCheck{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaHealthChecks().List(ctx, filter.None)
		if err != nil {
			t.Errorf("AlphaHealthChecks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaHealthChecks().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaHealthChecks().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaHealthChecks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaHealthChecks().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.HealthChecks().List(ctx, filter.None)
		if err != nil {
			t.Errorf("HealthChecks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("HealthChecks().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaHealthChecks().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaHealthChecks().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaHealthChecks().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaHealthChecks().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.HealthChecks().Delete(ctx, keyGA); err != nil {
		t.Errorf("HealthChecks().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaHealthChecks().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaHealthChecks().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaHealthChecks().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaHealthChecks().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.HealthChecks().Delete(ctx, keyGA); err == nil {
		t.Errorf("HealthChecks().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestHttpHealthChecksGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.HttpHealthChecks().Get(ctx, key); err == nil {
		t.Errorf("HttpHealthChecks().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &ga.HttpHealthCheck{}
		if err := mock.HttpHealthChecks().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("HttpHealthChecks().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.HttpHealthChecks().Get(ctx, key); err != nil {
		t.Errorf("HttpHealthChecks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockHttpHealthChecks.Objects[*keyGA] = mock.MockHttpHealthChecks.Obj(&ga.HttpHealthCheck{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.HttpHealthChecks().List(ctx, filter.None)
		if err != nil {
			t.Errorf("HttpHealthChecks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("HttpHealthChecks().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.HttpHealthChecks().Delete(ctx, keyGA); err != nil {
		t.Errorf("HttpHealthChecks().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.HttpHealthChecks().Delete(ctx, keyGA); err == nil {
		t.Errorf("HttpHealthChecks().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestHttpsHealthChecksGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.HttpsHealthChecks().Get(ctx, key); err == nil {
		t.Errorf("HttpsHealthChecks().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &ga.HttpsHealthCheck{}
		if err := mock.HttpsHealthChecks().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("HttpsHealthChecks().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.HttpsHealthChecks().Get(ctx, key); err != nil {
		t.Errorf("HttpsHealthChecks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockHttpsHealthChecks.Objects[*keyGA] = mock.MockHttpsHealthChecks.Obj(&ga.HttpsHealthCheck{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.HttpsHealthChecks().List(ctx, filter.None)
		if err != nil {
			t.Errorf("HttpsHealthChecks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("HttpsHealthChecks().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.HttpsHealthChecks().Delete(ctx, keyGA); err != nil {
		t.Errorf("HttpsHealthChecks().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.HttpsHealthChecks().Delete(ctx, keyGA); err == nil {
		t.Errorf("HttpsHealthChecks().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestInstanceGroupsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.ZonalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.InstanceGroups().Get(ctx, key); err == nil {
		t.Errorf("InstanceGroups().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &ga.InstanceGroup{}
		if err := mock.InstanceGroups().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("InstanceGroups().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.InstanceGroups().Get(ctx, key); err != nil {
		t.Errorf("InstanceGroups().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockInstanceGroups.Objects[*keyGA] = mock.MockInstanceGroups.Obj(&ga.InstanceGroup{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.InstanceGroups().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("InstanceGroups().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("InstanceGroups().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.InstanceGroups().Delete(ctx, keyGA); err != nil {
		t.Errorf("InstanceGroups().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.InstanceGroups().Delete(ctx, keyGA); err == nil {
		t.Errorf("InstanceGroups().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestInstancesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.ZonalKey("key-alpha", "location")
	key = keyAlpha
	keyBeta := meta.ZonalKey("key-beta", "location")
	key = keyBeta
	keyGA := meta.ZonalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaInstances().Get(ctx, key); err == nil {
		t.Errorf("AlphaInstances().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaInstances().Get(ctx, key); err == nil {
		t.Errorf("BetaInstances().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.Instances().Get(ctx, key); err == nil {
		t.Errorf("Instances().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &alpha.Instance{}
		if err := mock.AlphaInstances().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaInstances().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &beta.Instance{}
		if err := mock.BetaInstances().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaInstances().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}
	{
		obj := &ga.Instance{}
		if err := mock.Instances().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("Instances().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaInstances().Get(ctx, key); err != nil {
		t.Errorf("AlphaInstances().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaInstances().Get(ctx, key); err != nil {
		t.Errorf("BetaInstances().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.Instances().Get(ctx, key); err != nil {
		t.Errorf("Instances().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaInstances.Objects[*keyAlpha] = mock.MockAlphaInstances.Obj(&alpha.Instance{Name: keyAlpha.Name})
	mock.MockBetaInstances.Objects[*keyBeta] = mock.MockBetaInstances.Obj(&beta.Instance{Name: keyBeta.Name})
	mock.MockInstances.Objects[*keyGA] = mock.MockInstances.Obj(&ga.Instance{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaInstances().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaInstances().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaInstances().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaInstances().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("BetaInstances().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaInstances().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.Instances().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("Instances().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Instances().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaInstances().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaInstances().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaInstances().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaInstances().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}
	if err := mock.Instances().Delete(ctx, keyGA); err != nil {
		t.Errorf("Instances().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaInstances().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaInstances().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaInstances().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaInstances().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
	if err := mock.Instances().Delete(ctx, keyGA); err == nil {
		t.Errorf("Instances().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestNetworkEndpointGroupsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.ZonalKey("key-alpha", "location")
	key = keyAlpha
	keyBeta := meta.ZonalKey("key-beta", "location")
	key = keyBeta
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaNetworkEndpointGroups().Get(ctx, key); err == nil {
		t.Errorf("AlphaNetworkEndpointGroups().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.BetaNetworkEndpointGroups().Get(ctx, key); err == nil {
		t.Errorf("BetaNetworkEndpointGroups().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &alpha.NetworkEndpointGroup{}
		if err := mock.AlphaNetworkEndpointGroups().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaNetworkEndpointGroups().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &beta.NetworkEndpointGroup{}
		if err := mock.BetaNetworkEndpointGroups().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaNetworkEndpointGroups().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaNetworkEndpointGroups().Get(ctx, key); err != nil {
		t.Errorf("AlphaNetworkEndpointGroups().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.BetaNetworkEndpointGroups().Get(ctx, key); err != nil {
		t.Errorf("BetaNetworkEndpointGroups().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaNetworkEndpointGroups.Objects[*keyAlpha] = mock.MockAlphaNetworkEndpointGroups.Obj(&alpha.NetworkEndpointGroup{Name: keyAlpha.Name})
	mock.MockBetaNetworkEndpointGroups.Objects[*keyBeta] = mock.MockBetaNetworkEndpointGroups.Obj(&beta.NetworkEndpointGroup{Name: keyBeta.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-beta":  true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaNetworkEndpointGroups().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaNetworkEndpointGroups().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaNetworkEndpointGroups().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.BetaNetworkEndpointGroups().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("BetaNetworkEndpointGroups().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaNetworkEndpointGroups().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaNetworkEndpointGroups().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaNetworkEndpointGroups().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.BetaNetworkEndpointGroups().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaNetworkEndpointGroups().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}

	// Delete not found.
	if err := mock.AlphaNetworkEndpointGroups().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaNetworkEndpointGroups().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.BetaNetworkEndpointGroups().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaNetworkEndpointGroups().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
}

func TestProjectsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.

	// Insert.

	// Get across versions.

	// List.
	mock.MockProjects.Objects[*keyGA] = mock.MockProjects.Obj(&ga.Project{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.

	// Delete across versions.

	// Delete not found.
}

func TestRegionBackendServicesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyAlpha := meta.RegionalKey("key-alpha", "location")
	key = keyAlpha
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.AlphaRegionBackendServices().Get(ctx, key); err == nil {
		t.Errorf("AlphaRegionBackendServices().Get(%v, %v) = _, nil; want error", ctx, key)
	}
	if _, err := mock.RegionBackendServices().Get(ctx, key); err == nil {
		t.Errorf("RegionBackendServices().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &alpha.BackendService{}
		if err := mock.AlphaRegionBackendServices().Insert(ctx, keyAlpha, obj); err != nil {
			t.Errorf("AlphaRegionBackendServices().Insert(%v, %v, %v) = %v; want nil", ctx, keyAlpha, obj, err)
		}
	}
	{
		obj := &ga.BackendService{}
		if err := mock.RegionBackendServices().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("RegionBackendServices().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.AlphaRegionBackendServices().Get(ctx, key); err != nil {
		t.Errorf("AlphaRegionBackendServices().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}
	if obj, err := mock.RegionBackendServices().Get(ctx, key); err != nil {
		t.Errorf("RegionBackendServices().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockAlphaRegionBackendServices.Objects[*keyAlpha] = mock.MockAlphaRegionBackendServices.Obj(&alpha.BackendService{Name: keyAlpha.Name})
	mock.MockRegionBackendServices.Objects[*keyGA] = mock.MockRegionBackendServices.Obj(&ga.BackendService{Name: keyGA.Name})
	want := map[string]bool{
		"key-alpha": true,
		"key-ga":    true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.AlphaRegionBackendServices().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("AlphaRegionBackendServices().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("AlphaRegionBackendServices().List(); got %+v, want %+v", got, want)
			}
		}
	}
	{
		objs, err := mock.RegionBackendServices().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("RegionBackendServices().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("RegionBackendServices().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.AlphaRegionBackendServices().Delete(ctx, keyAlpha); err != nil {
		t.Errorf("AlphaRegionBackendServices().Delete(%v, %v) = %v; want nil", ctx, keyAlpha, err)
	}
	if err := mock.RegionBackendServices().Delete(ctx, keyGA); err != nil {
		t.Errorf("RegionBackendServices().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.AlphaRegionBackendServices().Delete(ctx, keyAlpha); err == nil {
		t.Errorf("AlphaRegionBackendServices().Delete(%v, %v) = nil; want error", ctx, keyAlpha)
	}
	if err := mock.RegionBackendServices().Delete(ctx, keyGA); err == nil {
		t.Errorf("RegionBackendServices().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestRegionDisksGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.RegionDisks().Get(ctx, key); err == nil {
		t.Errorf("RegionDisks().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &ga.Disk{}
		if err := mock.RegionDisks().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("RegionDisks().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.RegionDisks().Get(ctx, key); err != nil {
		t.Errorf("RegionDisks().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockRegionDisks.Objects[*keyGA] = mock.MockRegionDisks.Obj(&ga.Disk{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.RegionDisks().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("RegionDisks().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("RegionDisks().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.RegionDisks().Delete(ctx, keyGA); err != nil {
		t.Errorf("RegionDisks().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.RegionDisks().Delete(ctx, keyGA); err == nil {
		t.Errorf("RegionDisks().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestRegionsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.Regions().Get(ctx, key); err == nil {
		t.Errorf("Regions().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.

	// Get across versions.

	// List.
	mock.MockRegions.Objects[*keyGA] = mock.MockRegions.Obj(&ga.Region{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.Regions().List(ctx, filter.None)
		if err != nil {
			t.Errorf("Regions().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Regions().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.

	// Delete not found.
}

func TestRoutesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.Routes().Get(ctx, key); err == nil {
		t.Errorf("Routes().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &ga.Route{}
		if err := mock.Routes().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("Routes().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.Routes().Get(ctx, key); err != nil {
		t.Errorf("Routes().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockRoutes.Objects[*keyGA] = mock.MockRoutes.Obj(&ga.Route{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.Routes().List(ctx, filter.None)
		if err != nil {
			t.Errorf("Routes().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Routes().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.Routes().Delete(ctx, keyGA); err != nil {
		t.Errorf("Routes().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.Routes().Delete(ctx, keyGA); err == nil {
		t.Errorf("Routes().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestSecurityPoliciesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyBeta := meta.GlobalKey("key-beta")
	key = keyBeta
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.BetaSecurityPolicies().Get(ctx, key); err == nil {
		t.Errorf("BetaSecurityPolicies().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &beta.SecurityPolicy{}
		if err := mock.BetaSecurityPolicies().Insert(ctx, keyBeta, obj); err != nil {
			t.Errorf("BetaSecurityPolicies().Insert(%v, %v, %v) = %v; want nil", ctx, keyBeta, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.BetaSecurityPolicies().Get(ctx, key); err != nil {
		t.Errorf("BetaSecurityPolicies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockBetaSecurityPolicies.Objects[*keyBeta] = mock.MockBetaSecurityPolicies.Obj(&beta.SecurityPolicy{Name: keyBeta.Name})
	want := map[string]bool{
		"key-beta": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.BetaSecurityPolicies().List(ctx, filter.None)
		if err != nil {
			t.Errorf("BetaSecurityPolicies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("BetaSecurityPolicies().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.BetaSecurityPolicies().Delete(ctx, keyBeta); err != nil {
		t.Errorf("BetaSecurityPolicies().Delete(%v, %v) = %v; want nil", ctx, keyBeta, err)
	}

	// Delete not found.
	if err := mock.BetaSecurityPolicies().Delete(ctx, keyBeta); err == nil {
		t.Errorf("BetaSecurityPolicies().Delete(%v, %v) = nil; want error", ctx, keyBeta)
	}
}

func TestSslCertificatesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.SslCertificates().Get(ctx, key); err == nil {
		t.Errorf("SslCertificates().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &ga.SslCertificate{}
		if err := mock.SslCertificates().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("SslCertificates().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.SslCertificates().Get(ctx, key); err != nil {
		t.Errorf("SslCertificates().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockSslCertificates.Objects[*keyGA] = mock.MockSslCertificates.Obj(&ga.SslCertificate{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.SslCertificates().List(ctx, filter.None)
		if err != nil {
			t.Errorf("SslCertificates().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("SslCertificates().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.SslCertificates().Delete(ctx, keyGA); err != nil {
		t.Errorf("SslCertificates().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.SslCertificates().Delete(ctx, keyGA); err == nil {
		t.Errorf("SslCertificates().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestTargetHttpProxiesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.TargetHttpProxies().Get(ctx, key); err == nil {
		t.Errorf("TargetHttpProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &ga.TargetHttpProxy{}
		if err := mock.TargetHttpProxies().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("TargetHttpProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.TargetHttpProxies().Get(ctx, key); err != nil {
		t.Errorf("TargetHttpProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockTargetHttpProxies.Objects[*keyGA] = mock.MockTargetHttpProxies.Obj(&ga.TargetHttpProxy{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.TargetHttpProxies().List(ctx, filter.None)
		if err != nil {
			t.Errorf("TargetHttpProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("TargetHttpProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.TargetHttpProxies().Delete(ctx, keyGA); err != nil {
		t.Errorf("TargetHttpProxies().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.TargetHttpProxies().Delete(ctx, keyGA); err == nil {
		t.Errorf("TargetHttpProxies().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestTargetHttpsProxiesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.TargetHttpsProxies().Get(ctx, key); err == nil {
		t.Errorf("TargetHttpsProxies().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &ga.TargetHttpsProxy{}
		if err := mock.TargetHttpsProxies().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("TargetHttpsProxies().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.TargetHttpsProxies().Get(ctx, key); err != nil {
		t.Errorf("TargetHttpsProxies().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockTargetHttpsProxies.Objects[*keyGA] = mock.MockTargetHttpsProxies.Obj(&ga.TargetHttpsProxy{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.TargetHttpsProxies().List(ctx, filter.None)
		if err != nil {
			t.Errorf("TargetHttpsProxies().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("TargetHttpsProxies().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.TargetHttpsProxies().Delete(ctx, keyGA); err != nil {
		t.Errorf("TargetHttpsProxies().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.TargetHttpsProxies().Delete(ctx, keyGA); err == nil {
		t.Errorf("TargetHttpsProxies().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestTargetPoolsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.RegionalKey("key-ga", "location")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.TargetPools().Get(ctx, key); err == nil {
		t.Errorf("TargetPools().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &ga.TargetPool{}
		if err := mock.TargetPools().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("TargetPools().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.TargetPools().Get(ctx, key); err != nil {
		t.Errorf("TargetPools().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockTargetPools.Objects[*keyGA] = mock.MockTargetPools.Obj(&ga.TargetPool{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.TargetPools().List(ctx, location, filter.None)
		if err != nil {
			t.Errorf("TargetPools().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("TargetPools().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.TargetPools().Delete(ctx, keyGA); err != nil {
		t.Errorf("TargetPools().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.TargetPools().Delete(ctx, keyGA); err == nil {
		t.Errorf("TargetPools().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestUrlMapsGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.UrlMaps().Get(ctx, key); err == nil {
		t.Errorf("UrlMaps().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.
	{
		obj := &ga.UrlMap{}
		if err := mock.UrlMaps().Insert(ctx, keyGA, obj); err != nil {
			t.Errorf("UrlMaps().Insert(%v, %v, %v) = %v; want nil", ctx, keyGA, obj, err)
		}
	}

	// Get across versions.
	if obj, err := mock.UrlMaps().Get(ctx, key); err != nil {
		t.Errorf("UrlMaps().Get(%v, %v) = %v, %v; want nil", ctx, key, obj, err)
	}

	// List.
	mock.MockUrlMaps.Objects[*keyGA] = mock.MockUrlMaps.Obj(&ga.UrlMap{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.UrlMaps().List(ctx, filter.None)
		if err != nil {
			t.Errorf("UrlMaps().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("UrlMaps().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.
	if err := mock.UrlMaps().Delete(ctx, keyGA); err != nil {
		t.Errorf("UrlMaps().Delete(%v, %v) = %v; want nil", ctx, keyGA, err)
	}

	// Delete not found.
	if err := mock.UrlMaps().Delete(ctx, keyGA); err == nil {
		t.Errorf("UrlMaps().Delete(%v, %v) = nil; want error", ctx, keyGA)
	}
}

func TestZonesGroup(t *testing.T) {
	t.Parallel()

	ctx := context.Background()
	pr := &SingleProjectRouter{"mock-project"}
	mock := NewMockGCE(pr)

	var key *meta.Key
	keyGA := meta.GlobalKey("key-ga")
	key = keyGA
	// Ignore unused variables.
	_, _, _ = ctx, mock, key

	// Get not found.
	if _, err := mock.Zones().Get(ctx, key); err == nil {
		t.Errorf("Zones().Get(%v, %v) = _, nil; want error", ctx, key)
	}

	// Insert.

	// Get across versions.

	// List.
	mock.MockZones.Objects[*keyGA] = mock.MockZones.Obj(&ga.Zone{Name: keyGA.Name})
	want := map[string]bool{
		"key-ga": true,
	}
	_ = want // ignore unused variables.
	{
		objs, err := mock.Zones().List(ctx, filter.None)
		if err != nil {
			t.Errorf("Zones().List(%v, %v, %v) = %v, %v; want _, nil", ctx, location, filter.None, objs, err)
		} else {
			got := map[string]bool{}
			for _, obj := range objs {
				got[obj.Name] = true
			}
			if !reflect.DeepEqual(got, want) {
				t.Errorf("Zones().List(); got %+v, want %+v", got, want)
			}
		}
	}

	// Delete across versions.

	// Delete not found.
}

func TestResourceIDConversion(t *testing.T) {
	t.Parallel()

	for _, id := range []*ResourceID{
		NewAddressesResourceID("some-project", "us-central1", "my-addresses-resource"),
		NewBackendServicesResourceID("some-project", "my-backendServices-resource"),
		NewDisksResourceID("some-project", "us-east1-b", "my-disks-resource"),
		NewFirewallsResourceID("some-project", "my-firewalls-resource"),
		NewForwardingRulesResourceID("some-project", "us-central1", "my-forwardingRules-resource"),
		NewGlobalAddressesResourceID("some-project", "my-addresses-resource"),
		NewGlobalForwardingRulesResourceID("some-project", "my-forwardingRules-resource"),
		NewHealthChecksResourceID("some-project", "my-healthChecks-resource"),
		NewHttpHealthChecksResourceID("some-project", "my-httpHealthChecks-resource"),
		NewHttpsHealthChecksResourceID("some-project", "my-httpsHealthChecks-resource"),
		NewInstanceGroupsResourceID("some-project", "us-east1-b", "my-instanceGroups-resource"),
		NewInstancesResourceID("some-project", "us-east1-b", "my-instances-resource"),
		NewNetworkEndpointGroupsResourceID("some-project", "us-east1-b", "my-networkEndpointGroups-resource"),
		NewProjectsResourceID("my-projects-resource"),
		NewRegionBackendServicesResourceID("some-project", "us-central1", "my-backendServices-resource"),
		NewRegionDisksResourceID("some-project", "us-central1", "my-disks-resource"),
		NewRegionsResourceID("some-project", "my-regions-resource"),
		NewRoutesResourceID("some-project", "my-routes-resource"),
		NewSecurityPoliciesResourceID("some-project", "my-securityPolicies-resource"),
		NewSslCertificatesResourceID("some-project", "my-sslCertificates-resource"),
		NewTargetHttpProxiesResourceID("some-project", "my-targetHttpProxies-resource"),
		NewTargetHttpsProxiesResourceID("some-project", "my-targetHttpsProxies-resource"),
		NewTargetPoolsResourceID("some-project", "us-central1", "my-targetPools-resource"),
		NewUrlMapsResourceID("some-project", "my-urlMaps-resource"),
		NewZonesResourceID("some-project", "my-zones-resource"),
	} {
		t.Run(id.Resource, func(t *testing.T) {
			// Test conversion to and from full URL.
			fullURL := id.SelfLink(meta.VersionGA)
			parsedID, err := ParseResourceURL(fullURL)
			if err != nil {
				t.Errorf("ParseResourceURL(%s) = _, %v, want nil", fullURL, err)
			}
			if !reflect.DeepEqual(id, parsedID) {
				t.Errorf("SelfLink(%+v) -> ParseResourceURL(%s) = %+v, want original ID", id, fullURL, parsedID)
			}

			// Test conversion to and from relative resource name.
			relativeName := id.RelativeResourceName()
			parsedID, err = ParseResourceURL(relativeName)
			if err != nil {
				t.Errorf("ParseResourceURL(%s) = _, %v, want nil", relativeName, err)
			}
			if !reflect.DeepEqual(id, parsedID) {
				t.Errorf("RelativeResourceName(%+v) -> ParseResourceURL(%s) = %+v, want original ID", id, relativeName, parsedID)
			}

			// Do not test ResourcePath for projects.
			if id.Resource == "projects" {
				return
			}

			// Test conversion to and from resource path.
			resourcePath := id.ResourcePath()
			parsedID, err = ParseResourceURL(resourcePath)
			if err != nil {
				t.Errorf("ParseResourceURL(%s) = _, %v, want nil", resourcePath, err)
			}
			id.ProjectID = ""
			if !reflect.DeepEqual(id, parsedID) {
				t.Errorf("ResourcePath(%+v) -> ParseResourceURL(%s) = %+v, want %+v", id, resourcePath, parsedID, id)
			}
		})
	}
}
