// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/open-cluster-management/api/cluster/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// PlacementLister helps list Placements.
// All objects returned here must be treated as read-only.
type PlacementLister interface {
	// List lists all Placements in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.Placement, err error)
	// Placements returns an object that can list and get Placements.
	Placements(namespace string) PlacementNamespaceLister
	PlacementListerExpansion
}

// placementLister implements the PlacementLister interface.
type placementLister struct {
	indexer cache.Indexer
}

// NewPlacementLister returns a new PlacementLister.
func NewPlacementLister(indexer cache.Indexer) PlacementLister {
	return &placementLister{indexer: indexer}
}

// List lists all Placements in the indexer.
func (s *placementLister) List(selector labels.Selector) (ret []*v1alpha1.Placement, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Placement))
	})
	return ret, err
}

// Placements returns an object that can list and get Placements.
func (s *placementLister) Placements(namespace string) PlacementNamespaceLister {
	return placementNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// PlacementNamespaceLister helps list and get Placements.
// All objects returned here must be treated as read-only.
type PlacementNamespaceLister interface {
	// List lists all Placements in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.Placement, err error)
	// Get retrieves the Placement from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.Placement, error)
	PlacementNamespaceListerExpansion
}

// placementNamespaceLister implements the PlacementNamespaceLister
// interface.
type placementNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Placements in the indexer for a given namespace.
func (s placementNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.Placement, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Placement))
	})
	return ret, err
}

// Get retrieves the Placement from the indexer for a given namespace and name.
func (s placementNamespaceLister) Get(name string) (*v1alpha1.Placement, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("placement"), name)
	}
	return obj.(*v1alpha1.Placement), nil
}
