// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/api/servicecontrol/v1/service_controller.proto

package servicecontrol

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The type of the consumer as defined in
// [Google Resource Manager](https://cloud.google.com/resource-manager/).
type CheckResponse_ConsumerInfo_ConsumerType int32

const (
	// This is never used.
	CheckResponse_ConsumerInfo_CONSUMER_TYPE_UNSPECIFIED CheckResponse_ConsumerInfo_ConsumerType = 0
	// The consumer is a Google Cloud Project.
	CheckResponse_ConsumerInfo_PROJECT CheckResponse_ConsumerInfo_ConsumerType = 1
	// The consumer is a Google Cloud Folder.
	CheckResponse_ConsumerInfo_FOLDER CheckResponse_ConsumerInfo_ConsumerType = 2
	// The consumer is a Google Cloud Organization.
	CheckResponse_ConsumerInfo_ORGANIZATION CheckResponse_ConsumerInfo_ConsumerType = 3
	// Service-specific resource container which is defined by the service
	// producer to offer their users the ability to manage service control
	// functionalities at a finer level of granularity than the PROJECT.
	CheckResponse_ConsumerInfo_SERVICE_SPECIFIC CheckResponse_ConsumerInfo_ConsumerType = 4
)

// Enum value maps for CheckResponse_ConsumerInfo_ConsumerType.
var (
	CheckResponse_ConsumerInfo_ConsumerType_name = map[int32]string{
		0: "CONSUMER_TYPE_UNSPECIFIED",
		1: "PROJECT",
		2: "FOLDER",
		3: "ORGANIZATION",
		4: "SERVICE_SPECIFIC",
	}
	CheckResponse_ConsumerInfo_ConsumerType_value = map[string]int32{
		"CONSUMER_TYPE_UNSPECIFIED": 0,
		"PROJECT":                   1,
		"FOLDER":                    2,
		"ORGANIZATION":              3,
		"SERVICE_SPECIFIC":          4,
	}
)

func (x CheckResponse_ConsumerInfo_ConsumerType) Enum() *CheckResponse_ConsumerInfo_ConsumerType {
	p := new(CheckResponse_ConsumerInfo_ConsumerType)
	*p = x
	return p
}

func (x CheckResponse_ConsumerInfo_ConsumerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CheckResponse_ConsumerInfo_ConsumerType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_servicecontrol_v1_service_controller_proto_enumTypes[0].Descriptor()
}

func (CheckResponse_ConsumerInfo_ConsumerType) Type() protoreflect.EnumType {
	return &file_google_api_servicecontrol_v1_service_controller_proto_enumTypes[0]
}

func (x CheckResponse_ConsumerInfo_ConsumerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CheckResponse_ConsumerInfo_ConsumerType.Descriptor instead.
func (CheckResponse_ConsumerInfo_ConsumerType) EnumDescriptor() ([]byte, []int) {
	return file_google_api_servicecontrol_v1_service_controller_proto_rawDescGZIP(), []int{1, 1, 0}
}

// Request message for the Check method.
type CheckRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The service name as specified in its service configuration. For example,
	// `"pubsub.googleapis.com"`.
	//
	// See
	// [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
	// for the definition of a service name.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// The operation to be checked.
	Operation *Operation `protobuf:"bytes,2,opt,name=operation,proto3" json:"operation,omitempty"`
	// Specifies which version of service configuration should be used to process
	// the request.
	//
	// If unspecified or no matching version can be found, the
	// latest one will be used.
	ServiceConfigId string `protobuf:"bytes,4,opt,name=service_config_id,json=serviceConfigId,proto3" json:"service_config_id,omitempty"`
}

func (x *CheckRequest) Reset() {
	*x = CheckRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckRequest) ProtoMessage() {}

func (x *CheckRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckRequest.ProtoReflect.Descriptor instead.
func (*CheckRequest) Descriptor() ([]byte, []int) {
	return file_google_api_servicecontrol_v1_service_controller_proto_rawDescGZIP(), []int{0}
}

func (x *CheckRequest) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *CheckRequest) GetOperation() *Operation {
	if x != nil {
		return x.Operation
	}
	return nil
}

func (x *CheckRequest) GetServiceConfigId() string {
	if x != nil {
		return x.ServiceConfigId
	}
	return ""
}

// Response message for the Check method.
type CheckResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The same operation_id value used in the [CheckRequest][google.api.servicecontrol.v1.CheckRequest].
	// Used for logging and diagnostics purposes.
	OperationId string `protobuf:"bytes,1,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// Indicate the decision of the check.
	//
	// If no check errors are present, the service should process the operation.
	// Otherwise the service should use the list of errors to determine the
	// appropriate action.
	CheckErrors []*CheckError `protobuf:"bytes,2,rep,name=check_errors,json=checkErrors,proto3" json:"check_errors,omitempty"`
	// The actual config id used to process the request.
	ServiceConfigId string `protobuf:"bytes,5,opt,name=service_config_id,json=serviceConfigId,proto3" json:"service_config_id,omitempty"`
	// The current service rollout id used to process the request.
	ServiceRolloutId string `protobuf:"bytes,11,opt,name=service_rollout_id,json=serviceRolloutId,proto3" json:"service_rollout_id,omitempty"`
	// Feedback data returned from the server during processing a Check request.
	CheckInfo *CheckResponse_CheckInfo `protobuf:"bytes,6,opt,name=check_info,json=checkInfo,proto3" json:"check_info,omitempty"`
}

func (x *CheckResponse) Reset() {
	*x = CheckResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckResponse) ProtoMessage() {}

func (x *CheckResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckResponse.ProtoReflect.Descriptor instead.
func (*CheckResponse) Descriptor() ([]byte, []int) {
	return file_google_api_servicecontrol_v1_service_controller_proto_rawDescGZIP(), []int{1}
}

func (x *CheckResponse) GetOperationId() string {
	if x != nil {
		return x.OperationId
	}
	return ""
}

func (x *CheckResponse) GetCheckErrors() []*CheckError {
	if x != nil {
		return x.CheckErrors
	}
	return nil
}

func (x *CheckResponse) GetServiceConfigId() string {
	if x != nil {
		return x.ServiceConfigId
	}
	return ""
}

func (x *CheckResponse) GetServiceRolloutId() string {
	if x != nil {
		return x.ServiceRolloutId
	}
	return ""
}

func (x *CheckResponse) GetCheckInfo() *CheckResponse_CheckInfo {
	if x != nil {
		return x.CheckInfo
	}
	return nil
}

// Request message for the Report method.
type ReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The service name as specified in its service configuration. For example,
	// `"pubsub.googleapis.com"`.
	//
	// See
	// [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
	// for the definition of a service name.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// Operations to be reported.
	//
	// Typically the service should report one operation per request.
	// Putting multiple operations into a single request is allowed, but should
	// be used only when multiple operations are natually available at the time
	// of the report.
	//
	// There is no limit on the number of operations in the same ReportRequest,
	// however the ReportRequest size should be no larger than 1MB. See
	// [ReportResponse.report_errors][google.api.servicecontrol.v1.ReportResponse.report_errors] for partial failure behavior.
	Operations []*Operation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// Specifies which version of service config should be used to process the
	// request.
	//
	// If unspecified or no matching version can be found, the
	// latest one will be used.
	ServiceConfigId string `protobuf:"bytes,3,opt,name=service_config_id,json=serviceConfigId,proto3" json:"service_config_id,omitempty"`
}

func (x *ReportRequest) Reset() {
	*x = ReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportRequest) ProtoMessage() {}

func (x *ReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportRequest.ProtoReflect.Descriptor instead.
func (*ReportRequest) Descriptor() ([]byte, []int) {
	return file_google_api_servicecontrol_v1_service_controller_proto_rawDescGZIP(), []int{2}
}

func (x *ReportRequest) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *ReportRequest) GetOperations() []*Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ReportRequest) GetServiceConfigId() string {
	if x != nil {
		return x.ServiceConfigId
	}
	return ""
}

// Response message for the Report method.
type ReportResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Partial failures, one for each `Operation` in the request that failed
	// processing. There are three possible combinations of the RPC status:
	//
	// 1. The combination of a successful RPC status and an empty `report_errors`
	//    list indicates a complete success where all `Operations` in the
	//    request are processed successfully.
	// 2. The combination of a successful RPC status and a non-empty
	//    `report_errors` list indicates a partial success where some
	//    `Operations` in the request succeeded. Each
	//    `Operation` that failed processing has a corresponding item
	//    in this list.
	// 3. A failed RPC status indicates a general non-deterministic failure.
	//    When this happens, it's impossible to know which of the
	//    'Operations' in the request succeeded or failed.
	ReportErrors []*ReportResponse_ReportError `protobuf:"bytes,1,rep,name=report_errors,json=reportErrors,proto3" json:"report_errors,omitempty"`
	// The actual config id used to process the request.
	ServiceConfigId string `protobuf:"bytes,2,opt,name=service_config_id,json=serviceConfigId,proto3" json:"service_config_id,omitempty"`
	// The current service rollout id used to process the request.
	ServiceRolloutId string `protobuf:"bytes,4,opt,name=service_rollout_id,json=serviceRolloutId,proto3" json:"service_rollout_id,omitempty"`
}

func (x *ReportResponse) Reset() {
	*x = ReportResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportResponse) ProtoMessage() {}

func (x *ReportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportResponse.ProtoReflect.Descriptor instead.
func (*ReportResponse) Descriptor() ([]byte, []int) {
	return file_google_api_servicecontrol_v1_service_controller_proto_rawDescGZIP(), []int{3}
}

func (x *ReportResponse) GetReportErrors() []*ReportResponse_ReportError {
	if x != nil {
		return x.ReportErrors
	}
	return nil
}

func (x *ReportResponse) GetServiceConfigId() string {
	if x != nil {
		return x.ServiceConfigId
	}
	return ""
}

func (x *ReportResponse) GetServiceRolloutId() string {
	if x != nil {
		return x.ServiceRolloutId
	}
	return ""
}

// Contains additional information about the check operation.
type CheckResponse_CheckInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of fields and label keys that are ignored by the server.
	// The client doesn't need to send them for following requests to improve
	// performance and allow better aggregation.
	UnusedArguments []string `protobuf:"bytes,1,rep,name=unused_arguments,json=unusedArguments,proto3" json:"unused_arguments,omitempty"`
	// Consumer info of this check.
	ConsumerInfo *CheckResponse_ConsumerInfo `protobuf:"bytes,2,opt,name=consumer_info,json=consumerInfo,proto3" json:"consumer_info,omitempty"`
}

func (x *CheckResponse_CheckInfo) Reset() {
	*x = CheckResponse_CheckInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckResponse_CheckInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckResponse_CheckInfo) ProtoMessage() {}

func (x *CheckResponse_CheckInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckResponse_CheckInfo.ProtoReflect.Descriptor instead.
func (*CheckResponse_CheckInfo) Descriptor() ([]byte, []int) {
	return file_google_api_servicecontrol_v1_service_controller_proto_rawDescGZIP(), []int{1, 0}
}

func (x *CheckResponse_CheckInfo) GetUnusedArguments() []string {
	if x != nil {
		return x.UnusedArguments
	}
	return nil
}

func (x *CheckResponse_CheckInfo) GetConsumerInfo() *CheckResponse_ConsumerInfo {
	if x != nil {
		return x.ConsumerInfo
	}
	return nil
}

// `ConsumerInfo` provides information about the consumer.
type CheckResponse_ConsumerInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Google cloud project number, e.g. 1234567890. A value of 0 indicates
	// no project number is found.
	//
	// NOTE: This field is deprecated after we support flexible consumer
	// id. New code should not depend on this field anymore.
	ProjectNumber int64 `protobuf:"varint,1,opt,name=project_number,json=projectNumber,proto3" json:"project_number,omitempty"`
	// The type of the consumer which should have been defined in
	// [Google Resource Manager](https://cloud.google.com/resource-manager/).
	Type CheckResponse_ConsumerInfo_ConsumerType `protobuf:"varint,2,opt,name=type,proto3,enum=google.api.servicecontrol.v1.CheckResponse_ConsumerInfo_ConsumerType" json:"type,omitempty"`
	// The consumer identity number, can be Google cloud project number, folder
	// number or organization number e.g. 1234567890. A value of 0 indicates no
	// consumer number is found.
	ConsumerNumber int64 `protobuf:"varint,3,opt,name=consumer_number,json=consumerNumber,proto3" json:"consumer_number,omitempty"`
}

func (x *CheckResponse_ConsumerInfo) Reset() {
	*x = CheckResponse_ConsumerInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckResponse_ConsumerInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckResponse_ConsumerInfo) ProtoMessage() {}

func (x *CheckResponse_ConsumerInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckResponse_ConsumerInfo.ProtoReflect.Descriptor instead.
func (*CheckResponse_ConsumerInfo) Descriptor() ([]byte, []int) {
	return file_google_api_servicecontrol_v1_service_controller_proto_rawDescGZIP(), []int{1, 1}
}

func (x *CheckResponse_ConsumerInfo) GetProjectNumber() int64 {
	if x != nil {
		return x.ProjectNumber
	}
	return 0
}

func (x *CheckResponse_ConsumerInfo) GetType() CheckResponse_ConsumerInfo_ConsumerType {
	if x != nil {
		return x.Type
	}
	return CheckResponse_ConsumerInfo_CONSUMER_TYPE_UNSPECIFIED
}

func (x *CheckResponse_ConsumerInfo) GetConsumerNumber() int64 {
	if x != nil {
		return x.ConsumerNumber
	}
	return 0
}

// Represents the processing error of one [Operation][google.api.servicecontrol.v1.Operation] in the request.
type ReportResponse_ReportError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [Operation.operation_id][google.api.servicecontrol.v1.Operation.operation_id] value from the request.
	OperationId string `protobuf:"bytes,1,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// Details of the error when processing the [Operation][google.api.servicecontrol.v1.Operation].
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *ReportResponse_ReportError) Reset() {
	*x = ReportResponse_ReportError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportResponse_ReportError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportResponse_ReportError) ProtoMessage() {}

func (x *ReportResponse_ReportError) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportResponse_ReportError.ProtoReflect.Descriptor instead.
func (*ReportResponse_ReportError) Descriptor() ([]byte, []int) {
	return file_google_api_servicecontrol_v1_service_controller_proto_rawDescGZIP(), []int{3, 0}
}

func (x *ReportResponse_ReportError) GetOperationId() string {
	if x != nil {
		return x.OperationId
	}
	return ""
}

func (x *ReportResponse_ReportError) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

var File_google_api_servicecontrol_v1_service_controller_proto protoreflect.FileDescriptor

var file_google_api_servicecontrol_v1_service_controller_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2f, 0x76,
	0x31, 0x2f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2f, 0x76,
	0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa4, 0x01, 0x0a, 0x0c, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x2a, 0x0a, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x22, 0xf3, 0x05, 0x0a, 0x0d,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x12, 0x4b, 0x0a, 0x0c, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x52, 0x0b, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x2a, 0x0a,
	0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x49, 0x64, 0x12, 0x54, 0x0a, 0x0a, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x09, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0x95, 0x01,
	0x0a, 0x09, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x29, 0x0a, 0x10, 0x75,
	0x6e, 0x75, 0x73, 0x65, 0x64, 0x5f, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x75, 0x6e, 0x75, 0x73, 0x65, 0x64, 0x41, 0x72, 0x67,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x5d, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0xa9, 0x02, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x59, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6d, 0x65, 0x72, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x22, 0x6e, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1d, 0x0a, 0x19, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x52, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x46, 0x4f, 0x4c, 0x44, 0x45, 0x52, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x4f, 0x52, 0x47,
	0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x53,
	0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x43, 0x10,
	0x04, 0x22, 0xa7, 0x01, 0x0a, 0x0d, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x2a, 0x0a, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x22, 0xa7, 0x02, 0x0a, 0x0e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d,
	0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52,
	0x0c, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x2a, 0x0a,
	0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x49, 0x64, 0x1a, 0x5c, 0x0a, 0x0b, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x32, 0xbc, 0x03, 0x0a, 0x11, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x12, 0x8e, 0x01, 0x0a, 0x05,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2c,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x22, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x7d, 0x3a, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x3a, 0x01, 0x2a, 0x12, 0x92, 0x01, 0x0a,
	0x06, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x2d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x27, 0x22, 0x22, 0x2f, 0x76, 0x31, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x3a, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01,
	0x2a, 0x1a, 0x80, 0x01, 0xca, 0x41, 0x1d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x5d, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x42, 0x92, 0x01, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x31, 0x42, 0x16, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2f, 0x76, 0x31,
	0x3b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0xf8,
	0x01, 0x01, 0xa2, 0x02, 0x04, 0x47, 0x41, 0x53, 0x43, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_api_servicecontrol_v1_service_controller_proto_rawDescOnce sync.Once
	file_google_api_servicecontrol_v1_service_controller_proto_rawDescData = file_google_api_servicecontrol_v1_service_controller_proto_rawDesc
)

func file_google_api_servicecontrol_v1_service_controller_proto_rawDescGZIP() []byte {
	file_google_api_servicecontrol_v1_service_controller_proto_rawDescOnce.Do(func() {
		file_google_api_servicecontrol_v1_service_controller_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_api_servicecontrol_v1_service_controller_proto_rawDescData)
	})
	return file_google_api_servicecontrol_v1_service_controller_proto_rawDescData
}

var file_google_api_servicecontrol_v1_service_controller_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_api_servicecontrol_v1_service_controller_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_api_servicecontrol_v1_service_controller_proto_goTypes = []interface{}{
	(CheckResponse_ConsumerInfo_ConsumerType)(0), // 0: google.api.servicecontrol.v1.CheckResponse.ConsumerInfo.ConsumerType
	(*CheckRequest)(nil),                         // 1: google.api.servicecontrol.v1.CheckRequest
	(*CheckResponse)(nil),                        // 2: google.api.servicecontrol.v1.CheckResponse
	(*ReportRequest)(nil),                        // 3: google.api.servicecontrol.v1.ReportRequest
	(*ReportResponse)(nil),                       // 4: google.api.servicecontrol.v1.ReportResponse
	(*CheckResponse_CheckInfo)(nil),              // 5: google.api.servicecontrol.v1.CheckResponse.CheckInfo
	(*CheckResponse_ConsumerInfo)(nil),           // 6: google.api.servicecontrol.v1.CheckResponse.ConsumerInfo
	(*ReportResponse_ReportError)(nil),           // 7: google.api.servicecontrol.v1.ReportResponse.ReportError
	(*Operation)(nil),                            // 8: google.api.servicecontrol.v1.Operation
	(*CheckError)(nil),                           // 9: google.api.servicecontrol.v1.CheckError
	(*status.Status)(nil),                        // 10: google.rpc.Status
}
var file_google_api_servicecontrol_v1_service_controller_proto_depIdxs = []int32{
	8,  // 0: google.api.servicecontrol.v1.CheckRequest.operation:type_name -> google.api.servicecontrol.v1.Operation
	9,  // 1: google.api.servicecontrol.v1.CheckResponse.check_errors:type_name -> google.api.servicecontrol.v1.CheckError
	5,  // 2: google.api.servicecontrol.v1.CheckResponse.check_info:type_name -> google.api.servicecontrol.v1.CheckResponse.CheckInfo
	8,  // 3: google.api.servicecontrol.v1.ReportRequest.operations:type_name -> google.api.servicecontrol.v1.Operation
	7,  // 4: google.api.servicecontrol.v1.ReportResponse.report_errors:type_name -> google.api.servicecontrol.v1.ReportResponse.ReportError
	6,  // 5: google.api.servicecontrol.v1.CheckResponse.CheckInfo.consumer_info:type_name -> google.api.servicecontrol.v1.CheckResponse.ConsumerInfo
	0,  // 6: google.api.servicecontrol.v1.CheckResponse.ConsumerInfo.type:type_name -> google.api.servicecontrol.v1.CheckResponse.ConsumerInfo.ConsumerType
	10, // 7: google.api.servicecontrol.v1.ReportResponse.ReportError.status:type_name -> google.rpc.Status
	1,  // 8: google.api.servicecontrol.v1.ServiceController.Check:input_type -> google.api.servicecontrol.v1.CheckRequest
	3,  // 9: google.api.servicecontrol.v1.ServiceController.Report:input_type -> google.api.servicecontrol.v1.ReportRequest
	2,  // 10: google.api.servicecontrol.v1.ServiceController.Check:output_type -> google.api.servicecontrol.v1.CheckResponse
	4,  // 11: google.api.servicecontrol.v1.ServiceController.Report:output_type -> google.api.servicecontrol.v1.ReportResponse
	10, // [10:12] is the sub-list for method output_type
	8,  // [8:10] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_google_api_servicecontrol_v1_service_controller_proto_init() }
func file_google_api_servicecontrol_v1_service_controller_proto_init() {
	if File_google_api_servicecontrol_v1_service_controller_proto != nil {
		return
	}
	file_google_api_servicecontrol_v1_check_error_proto_init()
	file_google_api_servicecontrol_v1_operation_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckResponse_CheckInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckResponse_ConsumerInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_servicecontrol_v1_service_controller_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportResponse_ReportError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_api_servicecontrol_v1_service_controller_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_api_servicecontrol_v1_service_controller_proto_goTypes,
		DependencyIndexes: file_google_api_servicecontrol_v1_service_controller_proto_depIdxs,
		EnumInfos:         file_google_api_servicecontrol_v1_service_controller_proto_enumTypes,
		MessageInfos:      file_google_api_servicecontrol_v1_service_controller_proto_msgTypes,
	}.Build()
	File_google_api_servicecontrol_v1_service_controller_proto = out.File
	file_google_api_servicecontrol_v1_service_controller_proto_rawDesc = nil
	file_google_api_servicecontrol_v1_service_controller_proto_goTypes = nil
	file_google_api_servicecontrol_v1_service_controller_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ServiceControllerClient is the client API for ServiceController service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ServiceControllerClient interface {
	// Checks whether an operation on a service should be allowed to proceed
	// based on the configuration of the service and related policies. It must be
	// called before the operation is executed.
	//
	// If feasible, the client should cache the check results and reuse them for
	// 60 seconds. In case of any server errors, the client should rely on the
	// cached results for much longer time to avoid outage.
	// WARNING: There is general 60s delay for the configuration and policy
	// propagation, therefore callers MUST NOT depend on the `Check` method having
	// the latest policy information.
	//
	// NOTE: the [CheckRequest][google.api.servicecontrol.v1.CheckRequest] has the size limit of 64KB.
	//
	// This method requires the `servicemanagement.services.check` permission
	// on the specified service. For more information, see
	// [Cloud IAM](https://cloud.google.com/iam).
	Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error)
	// Reports operation results to Google Service Control, such as logs and
	// metrics. It should be called after an operation is completed.
	//
	// If feasible, the client should aggregate reporting data for up to 5
	// seconds to reduce API traffic. Limiting aggregation to 5 seconds is to
	// reduce data loss during client crashes. Clients should carefully choose
	// the aggregation time window to avoid data loss risk more than 0.01%
	// for business and compliance reasons.
	//
	// NOTE: the [ReportRequest][google.api.servicecontrol.v1.ReportRequest] has the size limit (wire-format byte size) of
	// 1MB.
	//
	// This method requires the `servicemanagement.services.report` permission
	// on the specified service. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	Report(ctx context.Context, in *ReportRequest, opts ...grpc.CallOption) (*ReportResponse, error)
}

type serviceControllerClient struct {
	cc grpc.ClientConnInterface
}

func NewServiceControllerClient(cc grpc.ClientConnInterface) ServiceControllerClient {
	return &serviceControllerClient{cc}
}

func (c *serviceControllerClient) Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error) {
	out := new(CheckResponse)
	err := c.cc.Invoke(ctx, "/google.api.servicecontrol.v1.ServiceController/Check", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceControllerClient) Report(ctx context.Context, in *ReportRequest, opts ...grpc.CallOption) (*ReportResponse, error) {
	out := new(ReportResponse)
	err := c.cc.Invoke(ctx, "/google.api.servicecontrol.v1.ServiceController/Report", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServiceControllerServer is the server API for ServiceController service.
type ServiceControllerServer interface {
	// Checks whether an operation on a service should be allowed to proceed
	// based on the configuration of the service and related policies. It must be
	// called before the operation is executed.
	//
	// If feasible, the client should cache the check results and reuse them for
	// 60 seconds. In case of any server errors, the client should rely on the
	// cached results for much longer time to avoid outage.
	// WARNING: There is general 60s delay for the configuration and policy
	// propagation, therefore callers MUST NOT depend on the `Check` method having
	// the latest policy information.
	//
	// NOTE: the [CheckRequest][google.api.servicecontrol.v1.CheckRequest] has the size limit of 64KB.
	//
	// This method requires the `servicemanagement.services.check` permission
	// on the specified service. For more information, see
	// [Cloud IAM](https://cloud.google.com/iam).
	Check(context.Context, *CheckRequest) (*CheckResponse, error)
	// Reports operation results to Google Service Control, such as logs and
	// metrics. It should be called after an operation is completed.
	//
	// If feasible, the client should aggregate reporting data for up to 5
	// seconds to reduce API traffic. Limiting aggregation to 5 seconds is to
	// reduce data loss during client crashes. Clients should carefully choose
	// the aggregation time window to avoid data loss risk more than 0.01%
	// for business and compliance reasons.
	//
	// NOTE: the [ReportRequest][google.api.servicecontrol.v1.ReportRequest] has the size limit (wire-format byte size) of
	// 1MB.
	//
	// This method requires the `servicemanagement.services.report` permission
	// on the specified service. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	Report(context.Context, *ReportRequest) (*ReportResponse, error)
}

// UnimplementedServiceControllerServer can be embedded to have forward compatible implementations.
type UnimplementedServiceControllerServer struct {
}

func (*UnimplementedServiceControllerServer) Check(context.Context, *CheckRequest) (*CheckResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Check not implemented")
}
func (*UnimplementedServiceControllerServer) Report(context.Context, *ReportRequest) (*ReportResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Report not implemented")
}

func RegisterServiceControllerServer(s *grpc.Server, srv ServiceControllerServer) {
	s.RegisterService(&_ServiceController_serviceDesc, srv)
}

func _ServiceController_Check_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceControllerServer).Check(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicecontrol.v1.ServiceController/Check",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceControllerServer).Check(ctx, req.(*CheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceController_Report_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceControllerServer).Report(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicecontrol.v1.ServiceController/Report",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceControllerServer).Report(ctx, req.(*ReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.api.servicecontrol.v1.ServiceController",
	HandlerType: (*ServiceControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Check",
			Handler:    _ServiceController_Check_Handler,
		},
		{
			MethodName: "Report",
			Handler:    _ServiceController_Report_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/api/servicecontrol/v1/service_controller.proto",
}
