// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/open-cluster-management/api/operator/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// KlusterletLister helps list Klusterlets.
// All objects returned here must be treated as read-only.
type KlusterletLister interface {
	// List lists all Klusterlets in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Klusterlet, err error)
	// Get retrieves the Klusterlet from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.Klusterlet, error)
	KlusterletListerExpansion
}

// klusterletLister implements the KlusterletLister interface.
type klusterletLister struct {
	indexer cache.Indexer
}

// NewKlusterletLister returns a new KlusterletLister.
func NewKlusterletLister(indexer cache.Indexer) KlusterletLister {
	return &klusterletLister{indexer: indexer}
}

// List lists all Klusterlets in the indexer.
func (s *klusterletLister) List(selector labels.Selector) (ret []*v1.Klusterlet, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Klusterlet))
	})
	return ret, err
}

// Get retrieves the Klusterlet from the index for a given name.
func (s *klusterletLister) Get(name string) (*v1.Klusterlet, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("klusterlet"), name)
	}
	return obj.(*v1.Klusterlet), nil
}
