## helm package

Package a chart directory into a chart archive

### Synopsis


This command packages a chart into a versioned chart archive file. If a path
is given, this will look at that path for a chart (which must contain a
Chart.yaml file) and then package that directory.

If no path is given, this will look in the present working directory for a
Chart.yaml file, and (if found) build the current directory into a chart.

Versioned chart archives are used by Helm package repositories.


```
helm package [flags] [CHART_PATH] [...]
```

### Options

```
      --app-version string   Set the appVersion on the chart to this version
  -u, --dependency-update    Update dependencies from "requirements.yaml" to dir "charts/" before packaging
  -d, --destination string   Location to write the chart. (default ".")
  -h, --help                 help for package
      --key string           Name of the key to use when signing. Used if --sign is true
      --keyring string       Location of a public keyring (default "~/.gnupg/pubring.gpg")
      --save                 Save packaged chart to local chart repository (default true)
      --sign                 Use a PGP private key to sign this package
      --version string       Set the version on the chart to this semver version
```

### Options inherited from parent commands

```
      --debug                           Enable verbose output
      --home string                     Location of your Helm config. Overrides $HELM_HOME (default "~/.helm")
      --host string                     Address of Tiller. Overrides $HELM_HOST
      --kube-context string             Name of the kubeconfig context to use
      --kubeconfig string               Absolute path of the kubeconfig file to be used
      --tiller-connection-timeout int   The duration (in seconds) Helm will wait to establish a connection to Tiller (default 300)
      --tiller-namespace string         Namespace of Tiller (default "kube-system")
```

### SEE ALSO

* [helm](helm.md)	 - The Helm package manager for Kubernetes.

###### Auto generated by spf13/cobra on 16-May-2019
