// Code generated by protoc-gen-go. DO NOT EDIT.
// source: hapi/services/tiller.proto

package services

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import chart "k8s.io/helm/pkg/proto/hapi/chart"
import release "k8s.io/helm/pkg/proto/hapi/release"
import version "k8s.io/helm/pkg/proto/hapi/version"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// SortBy defines sort operations.
type ListSort_SortBy int32

const (
	ListSort_UNKNOWN       ListSort_SortBy = 0
	ListSort_NAME          ListSort_SortBy = 1
	ListSort_LAST_RELEASED ListSort_SortBy = 2
	ListSort_CHART_NAME    ListSort_SortBy = 3
)

var ListSort_SortBy_name = map[int32]string{
	0: "UNKNOWN",
	1: "NAME",
	2: "LAST_RELEASED",
	3: "CHART_NAME",
}
var ListSort_SortBy_value = map[string]int32{
	"UNKNOWN":       0,
	"NAME":          1,
	"LAST_RELEASED": 2,
	"CHART_NAME":    3,
}

func (x ListSort_SortBy) String() string {
	return proto.EnumName(ListSort_SortBy_name, int32(x))
}
func (ListSort_SortBy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{1, 0}
}

// SortOrder defines sort orders to augment sorting operations.
type ListSort_SortOrder int32

const (
	ListSort_ASC  ListSort_SortOrder = 0
	ListSort_DESC ListSort_SortOrder = 1
)

var ListSort_SortOrder_name = map[int32]string{
	0: "ASC",
	1: "DESC",
}
var ListSort_SortOrder_value = map[string]int32{
	"ASC":  0,
	"DESC": 1,
}

func (x ListSort_SortOrder) String() string {
	return proto.EnumName(ListSort_SortOrder_name, int32(x))
}
func (ListSort_SortOrder) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{1, 1}
}

// ListReleasesRequest requests a list of releases.
//
// Releases can be retrieved in chunks by setting limit and offset.
//
// Releases can be sorted according to a few pre-determined sort strategies.
type ListReleasesRequest struct {
	// Limit is the maximum number of releases to be returned.
	Limit int64 `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	// Offset is the last release name that was seen. The next listing
	// operation will start with the name after this one.
	// Example: If list one returns albert, bernie, carl, and sets 'next: dennis'.
	// dennis is the offset. Supplying 'dennis' for the next request should
	// cause the next batch to return a set of results starting with 'dennis'.
	Offset string `protobuf:"bytes,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// SortBy is the sort field that the ListReleases server should sort data before returning.
	SortBy ListSort_SortBy `protobuf:"varint,3,opt,name=sort_by,json=sortBy,proto3,enum=hapi.services.tiller.ListSort_SortBy" json:"sort_by,omitempty"`
	// Filter is a regular expression used to filter which releases should be listed.
	//
	// Anything that matches the regexp will be included in the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// SortOrder is the ordering directive used for sorting.
	SortOrder   ListSort_SortOrder    `protobuf:"varint,5,opt,name=sort_order,json=sortOrder,proto3,enum=hapi.services.tiller.ListSort_SortOrder" json:"sort_order,omitempty"`
	StatusCodes []release.Status_Code `protobuf:"varint,6,rep,packed,name=status_codes,json=statusCodes,proto3,enum=hapi.release.Status_Code" json:"status_codes,omitempty"`
	// Namespace is the filter to select releases only from a specific namespace.
	Namespace            string   `protobuf:"bytes,7,opt,name=namespace,proto3" json:"namespace,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListReleasesRequest) Reset()         { *m = ListReleasesRequest{} }
func (m *ListReleasesRequest) String() string { return proto.CompactTextString(m) }
func (*ListReleasesRequest) ProtoMessage()    {}
func (*ListReleasesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{0}
}
func (m *ListReleasesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListReleasesRequest.Unmarshal(m, b)
}
func (m *ListReleasesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListReleasesRequest.Marshal(b, m, deterministic)
}
func (dst *ListReleasesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListReleasesRequest.Merge(dst, src)
}
func (m *ListReleasesRequest) XXX_Size() int {
	return xxx_messageInfo_ListReleasesRequest.Size(m)
}
func (m *ListReleasesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListReleasesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListReleasesRequest proto.InternalMessageInfo

func (m *ListReleasesRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListReleasesRequest) GetOffset() string {
	if m != nil {
		return m.Offset
	}
	return ""
}

func (m *ListReleasesRequest) GetSortBy() ListSort_SortBy {
	if m != nil {
		return m.SortBy
	}
	return ListSort_UNKNOWN
}

func (m *ListReleasesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListReleasesRequest) GetSortOrder() ListSort_SortOrder {
	if m != nil {
		return m.SortOrder
	}
	return ListSort_ASC
}

func (m *ListReleasesRequest) GetStatusCodes() []release.Status_Code {
	if m != nil {
		return m.StatusCodes
	}
	return nil
}

func (m *ListReleasesRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

// ListSort defines sorting fields on a release list.
type ListSort struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSort) Reset()         { *m = ListSort{} }
func (m *ListSort) String() string { return proto.CompactTextString(m) }
func (*ListSort) ProtoMessage()    {}
func (*ListSort) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{1}
}
func (m *ListSort) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSort.Unmarshal(m, b)
}
func (m *ListSort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSort.Marshal(b, m, deterministic)
}
func (dst *ListSort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSort.Merge(dst, src)
}
func (m *ListSort) XXX_Size() int {
	return xxx_messageInfo_ListSort.Size(m)
}
func (m *ListSort) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSort.DiscardUnknown(m)
}

var xxx_messageInfo_ListSort proto.InternalMessageInfo

// ListReleasesResponse is a list of releases.
type ListReleasesResponse struct {
	// Count is the expected total number of releases to be returned.
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// Next is the name of the next release. If this is other than an empty
	// string, it means there are more results.
	Next string `protobuf:"bytes,2,opt,name=next,proto3" json:"next,omitempty"`
	// Total is the total number of queryable releases.
	Total int64 `protobuf:"varint,3,opt,name=total,proto3" json:"total,omitempty"`
	// Releases is the list of found release objects.
	Releases             []*release.Release `protobuf:"bytes,4,rep,name=releases,proto3" json:"releases,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ListReleasesResponse) Reset()         { *m = ListReleasesResponse{} }
func (m *ListReleasesResponse) String() string { return proto.CompactTextString(m) }
func (*ListReleasesResponse) ProtoMessage()    {}
func (*ListReleasesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{2}
}
func (m *ListReleasesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListReleasesResponse.Unmarshal(m, b)
}
func (m *ListReleasesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListReleasesResponse.Marshal(b, m, deterministic)
}
func (dst *ListReleasesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListReleasesResponse.Merge(dst, src)
}
func (m *ListReleasesResponse) XXX_Size() int {
	return xxx_messageInfo_ListReleasesResponse.Size(m)
}
func (m *ListReleasesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListReleasesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListReleasesResponse proto.InternalMessageInfo

func (m *ListReleasesResponse) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *ListReleasesResponse) GetNext() string {
	if m != nil {
		return m.Next
	}
	return ""
}

func (m *ListReleasesResponse) GetTotal() int64 {
	if m != nil {
		return m.Total
	}
	return 0
}

func (m *ListReleasesResponse) GetReleases() []*release.Release {
	if m != nil {
		return m.Releases
	}
	return nil
}

// GetReleaseStatusRequest is a request to get the status of a release.
type GetReleaseStatusRequest struct {
	// Name is the name of the release
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Version is the version of the release
	Version              int32    `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetReleaseStatusRequest) Reset()         { *m = GetReleaseStatusRequest{} }
func (m *GetReleaseStatusRequest) String() string { return proto.CompactTextString(m) }
func (*GetReleaseStatusRequest) ProtoMessage()    {}
func (*GetReleaseStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{3}
}
func (m *GetReleaseStatusRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetReleaseStatusRequest.Unmarshal(m, b)
}
func (m *GetReleaseStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetReleaseStatusRequest.Marshal(b, m, deterministic)
}
func (dst *GetReleaseStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReleaseStatusRequest.Merge(dst, src)
}
func (m *GetReleaseStatusRequest) XXX_Size() int {
	return xxx_messageInfo_GetReleaseStatusRequest.Size(m)
}
func (m *GetReleaseStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReleaseStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetReleaseStatusRequest proto.InternalMessageInfo

func (m *GetReleaseStatusRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetReleaseStatusRequest) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

// GetReleaseStatusResponse is the response indicating the status of the named release.
type GetReleaseStatusResponse struct {
	// Name is the name of the release.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Info contains information about the release.
	Info *release.Info `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
	// Namespace the release was released into
	Namespace            string   `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetReleaseStatusResponse) Reset()         { *m = GetReleaseStatusResponse{} }
func (m *GetReleaseStatusResponse) String() string { return proto.CompactTextString(m) }
func (*GetReleaseStatusResponse) ProtoMessage()    {}
func (*GetReleaseStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{4}
}
func (m *GetReleaseStatusResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetReleaseStatusResponse.Unmarshal(m, b)
}
func (m *GetReleaseStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetReleaseStatusResponse.Marshal(b, m, deterministic)
}
func (dst *GetReleaseStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReleaseStatusResponse.Merge(dst, src)
}
func (m *GetReleaseStatusResponse) XXX_Size() int {
	return xxx_messageInfo_GetReleaseStatusResponse.Size(m)
}
func (m *GetReleaseStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReleaseStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetReleaseStatusResponse proto.InternalMessageInfo

func (m *GetReleaseStatusResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetReleaseStatusResponse) GetInfo() *release.Info {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *GetReleaseStatusResponse) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

// GetReleaseContentRequest is a request to get the contents of a release.
type GetReleaseContentRequest struct {
	// The name of the release
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Version is the version of the release
	Version              int32    `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetReleaseContentRequest) Reset()         { *m = GetReleaseContentRequest{} }
func (m *GetReleaseContentRequest) String() string { return proto.CompactTextString(m) }
func (*GetReleaseContentRequest) ProtoMessage()    {}
func (*GetReleaseContentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{5}
}
func (m *GetReleaseContentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetReleaseContentRequest.Unmarshal(m, b)
}
func (m *GetReleaseContentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetReleaseContentRequest.Marshal(b, m, deterministic)
}
func (dst *GetReleaseContentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReleaseContentRequest.Merge(dst, src)
}
func (m *GetReleaseContentRequest) XXX_Size() int {
	return xxx_messageInfo_GetReleaseContentRequest.Size(m)
}
func (m *GetReleaseContentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReleaseContentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetReleaseContentRequest proto.InternalMessageInfo

func (m *GetReleaseContentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetReleaseContentRequest) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

// GetReleaseContentResponse is a response containing the contents of a release.
type GetReleaseContentResponse struct {
	// The release content
	Release              *release.Release `protobuf:"bytes,1,opt,name=release,proto3" json:"release,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *GetReleaseContentResponse) Reset()         { *m = GetReleaseContentResponse{} }
func (m *GetReleaseContentResponse) String() string { return proto.CompactTextString(m) }
func (*GetReleaseContentResponse) ProtoMessage()    {}
func (*GetReleaseContentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{6}
}
func (m *GetReleaseContentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetReleaseContentResponse.Unmarshal(m, b)
}
func (m *GetReleaseContentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetReleaseContentResponse.Marshal(b, m, deterministic)
}
func (dst *GetReleaseContentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReleaseContentResponse.Merge(dst, src)
}
func (m *GetReleaseContentResponse) XXX_Size() int {
	return xxx_messageInfo_GetReleaseContentResponse.Size(m)
}
func (m *GetReleaseContentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReleaseContentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetReleaseContentResponse proto.InternalMessageInfo

func (m *GetReleaseContentResponse) GetRelease() *release.Release {
	if m != nil {
		return m.Release
	}
	return nil
}

// UpdateReleaseRequest updates a release.
type UpdateReleaseRequest struct {
	// The name of the release
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Chart is the protobuf representation of a chart.
	Chart *chart.Chart `protobuf:"bytes,2,opt,name=chart,proto3" json:"chart,omitempty"`
	// Values is a string containing (unparsed) YAML values.
	Values *chart.Config `protobuf:"bytes,3,opt,name=values,proto3" json:"values,omitempty"`
	// dry_run, if true, will run through the release logic, but neither create
	DryRun bool `protobuf:"varint,4,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// DisableHooks causes the server to skip running any hooks for the upgrade.
	DisableHooks bool `protobuf:"varint,5,opt,name=disable_hooks,json=disableHooks,proto3" json:"disable_hooks,omitempty"`
	// Performs pods restart for resources if applicable
	Recreate bool `protobuf:"varint,6,opt,name=recreate,proto3" json:"recreate,omitempty"`
	// timeout specifies the max amount of time any kubernetes client command can run.
	Timeout int64 `protobuf:"varint,7,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// ResetValues will cause Tiller to ignore stored values, resetting to default values.
	ResetValues bool `protobuf:"varint,8,opt,name=reset_values,json=resetValues,proto3" json:"reset_values,omitempty"`
	// wait, if true, will wait until all Pods, PVCs, and Services are in a ready state
	// before marking the release as successful. It will wait for as long as timeout
	Wait bool `protobuf:"varint,9,opt,name=wait,proto3" json:"wait,omitempty"`
	// ReuseValues will cause Tiller to reuse the values from the last release.
	// This is ignored if reset_values is set.
	ReuseValues bool `protobuf:"varint,10,opt,name=reuse_values,json=reuseValues,proto3" json:"reuse_values,omitempty"`
	// Force resource update through delete/recreate if needed.
	Force bool `protobuf:"varint,11,opt,name=force,proto3" json:"force,omitempty"`
	// Description, if set, will set the description for the updated release
	Description string `protobuf:"bytes,12,opt,name=description,proto3" json:"description,omitempty"`
	// Render subchart notes if enabled
	SubNotes bool `protobuf:"varint,13,opt,name=subNotes,proto3" json:"subNotes,omitempty"`
	// Allow deletion of new resources created in this update when update failed
	CleanupOnFail        bool     `protobuf:"varint,14,opt,name=cleanup_on_fail,json=cleanupOnFail,proto3" json:"cleanup_on_fail,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateReleaseRequest) Reset()         { *m = UpdateReleaseRequest{} }
func (m *UpdateReleaseRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateReleaseRequest) ProtoMessage()    {}
func (*UpdateReleaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{7}
}
func (m *UpdateReleaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateReleaseRequest.Unmarshal(m, b)
}
func (m *UpdateReleaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateReleaseRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateReleaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateReleaseRequest.Merge(dst, src)
}
func (m *UpdateReleaseRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateReleaseRequest.Size(m)
}
func (m *UpdateReleaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateReleaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateReleaseRequest proto.InternalMessageInfo

func (m *UpdateReleaseRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateReleaseRequest) GetChart() *chart.Chart {
	if m != nil {
		return m.Chart
	}
	return nil
}

func (m *UpdateReleaseRequest) GetValues() *chart.Config {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *UpdateReleaseRequest) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *UpdateReleaseRequest) GetDisableHooks() bool {
	if m != nil {
		return m.DisableHooks
	}
	return false
}

func (m *UpdateReleaseRequest) GetRecreate() bool {
	if m != nil {
		return m.Recreate
	}
	return false
}

func (m *UpdateReleaseRequest) GetTimeout() int64 {
	if m != nil {
		return m.Timeout
	}
	return 0
}

func (m *UpdateReleaseRequest) GetResetValues() bool {
	if m != nil {
		return m.ResetValues
	}
	return false
}

func (m *UpdateReleaseRequest) GetWait() bool {
	if m != nil {
		return m.Wait
	}
	return false
}

func (m *UpdateReleaseRequest) GetReuseValues() bool {
	if m != nil {
		return m.ReuseValues
	}
	return false
}

func (m *UpdateReleaseRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

func (m *UpdateReleaseRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateReleaseRequest) GetSubNotes() bool {
	if m != nil {
		return m.SubNotes
	}
	return false
}

func (m *UpdateReleaseRequest) GetCleanupOnFail() bool {
	if m != nil {
		return m.CleanupOnFail
	}
	return false
}

// UpdateReleaseResponse is the response to an update request.
type UpdateReleaseResponse struct {
	Release              *release.Release `protobuf:"bytes,1,opt,name=release,proto3" json:"release,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *UpdateReleaseResponse) Reset()         { *m = UpdateReleaseResponse{} }
func (m *UpdateReleaseResponse) String() string { return proto.CompactTextString(m) }
func (*UpdateReleaseResponse) ProtoMessage()    {}
func (*UpdateReleaseResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{8}
}
func (m *UpdateReleaseResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateReleaseResponse.Unmarshal(m, b)
}
func (m *UpdateReleaseResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateReleaseResponse.Marshal(b, m, deterministic)
}
func (dst *UpdateReleaseResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateReleaseResponse.Merge(dst, src)
}
func (m *UpdateReleaseResponse) XXX_Size() int {
	return xxx_messageInfo_UpdateReleaseResponse.Size(m)
}
func (m *UpdateReleaseResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateReleaseResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateReleaseResponse proto.InternalMessageInfo

func (m *UpdateReleaseResponse) GetRelease() *release.Release {
	if m != nil {
		return m.Release
	}
	return nil
}

type RollbackReleaseRequest struct {
	// The name of the release
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// dry_run, if true, will run through the release logic but no create
	DryRun bool `protobuf:"varint,2,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// DisableHooks causes the server to skip running any hooks for the rollback
	DisableHooks bool `protobuf:"varint,3,opt,name=disable_hooks,json=disableHooks,proto3" json:"disable_hooks,omitempty"`
	// Version is the version of the release to deploy.
	Version int32 `protobuf:"varint,4,opt,name=version,proto3" json:"version,omitempty"`
	// Performs pods restart for resources if applicable
	Recreate bool `protobuf:"varint,5,opt,name=recreate,proto3" json:"recreate,omitempty"`
	// timeout specifies the max amount of time any kubernetes client command can run.
	Timeout int64 `protobuf:"varint,6,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// wait, if true, will wait until all Pods, PVCs, and Services are in a ready state
	// before marking the release as successful. It will wait for as long as timeout
	Wait bool `protobuf:"varint,7,opt,name=wait,proto3" json:"wait,omitempty"`
	// Force resource update through delete/recreate if needed.
	Force bool `protobuf:"varint,8,opt,name=force,proto3" json:"force,omitempty"`
	// Description, if set, will set the description for the rollback
	Description string `protobuf:"bytes,9,opt,name=description,proto3" json:"description,omitempty"`
	// Allow deletion of new resources created in this rollback when rollback failed
	CleanupOnFail        bool     `protobuf:"varint,10,opt,name=cleanup_on_fail,json=cleanupOnFail,proto3" json:"cleanup_on_fail,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RollbackReleaseRequest) Reset()         { *m = RollbackReleaseRequest{} }
func (m *RollbackReleaseRequest) String() string { return proto.CompactTextString(m) }
func (*RollbackReleaseRequest) ProtoMessage()    {}
func (*RollbackReleaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{9}
}
func (m *RollbackReleaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollbackReleaseRequest.Unmarshal(m, b)
}
func (m *RollbackReleaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollbackReleaseRequest.Marshal(b, m, deterministic)
}
func (dst *RollbackReleaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollbackReleaseRequest.Merge(dst, src)
}
func (m *RollbackReleaseRequest) XXX_Size() int {
	return xxx_messageInfo_RollbackReleaseRequest.Size(m)
}
func (m *RollbackReleaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RollbackReleaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RollbackReleaseRequest proto.InternalMessageInfo

func (m *RollbackReleaseRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RollbackReleaseRequest) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *RollbackReleaseRequest) GetDisableHooks() bool {
	if m != nil {
		return m.DisableHooks
	}
	return false
}

func (m *RollbackReleaseRequest) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *RollbackReleaseRequest) GetRecreate() bool {
	if m != nil {
		return m.Recreate
	}
	return false
}

func (m *RollbackReleaseRequest) GetTimeout() int64 {
	if m != nil {
		return m.Timeout
	}
	return 0
}

func (m *RollbackReleaseRequest) GetWait() bool {
	if m != nil {
		return m.Wait
	}
	return false
}

func (m *RollbackReleaseRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

func (m *RollbackReleaseRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *RollbackReleaseRequest) GetCleanupOnFail() bool {
	if m != nil {
		return m.CleanupOnFail
	}
	return false
}

// RollbackReleaseResponse is the response to an update request.
type RollbackReleaseResponse struct {
	Release              *release.Release `protobuf:"bytes,1,opt,name=release,proto3" json:"release,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *RollbackReleaseResponse) Reset()         { *m = RollbackReleaseResponse{} }
func (m *RollbackReleaseResponse) String() string { return proto.CompactTextString(m) }
func (*RollbackReleaseResponse) ProtoMessage()    {}
func (*RollbackReleaseResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{10}
}
func (m *RollbackReleaseResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollbackReleaseResponse.Unmarshal(m, b)
}
func (m *RollbackReleaseResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollbackReleaseResponse.Marshal(b, m, deterministic)
}
func (dst *RollbackReleaseResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollbackReleaseResponse.Merge(dst, src)
}
func (m *RollbackReleaseResponse) XXX_Size() int {
	return xxx_messageInfo_RollbackReleaseResponse.Size(m)
}
func (m *RollbackReleaseResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RollbackReleaseResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RollbackReleaseResponse proto.InternalMessageInfo

func (m *RollbackReleaseResponse) GetRelease() *release.Release {
	if m != nil {
		return m.Release
	}
	return nil
}

// InstallReleaseRequest is the request for an installation of a chart.
type InstallReleaseRequest struct {
	// Chart is the protobuf representation of a chart.
	Chart *chart.Chart `protobuf:"bytes,1,opt,name=chart,proto3" json:"chart,omitempty"`
	// Values is a string containing (unparsed) YAML values.
	Values *chart.Config `protobuf:"bytes,2,opt,name=values,proto3" json:"values,omitempty"`
	// DryRun, if true, will run through the release logic, but neither create
	// a release object nor deploy to Kubernetes. The release object returned
	// in the response will be fake.
	DryRun bool `protobuf:"varint,3,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// Name is the candidate release name. This must be unique to the
	// namespace, otherwise the server will return an error. If it is not
	// supplied, the server will autogenerate one.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// DisableHooks causes the server to skip running any hooks for the install.
	DisableHooks bool `protobuf:"varint,5,opt,name=disable_hooks,json=disableHooks,proto3" json:"disable_hooks,omitempty"`
	// Namespace is the kubernetes namespace of the release.
	Namespace string `protobuf:"bytes,6,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Reuse_name requests that Tiller re-uses a name, instead of erroring out.
	ReuseName bool `protobuf:"varint,7,opt,name=reuse_name,json=reuseName,proto3" json:"reuse_name,omitempty"`
	// timeout specifies the max amount of time any kubernetes client command can run.
	Timeout int64 `protobuf:"varint,8,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// wait, if true, will wait until all Pods, PVCs, and Services are in a ready state
	// before marking the release as successful. It will wait for as long as timeout
	Wait           bool `protobuf:"varint,9,opt,name=wait,proto3" json:"wait,omitempty"`
	DisableCrdHook bool `protobuf:"varint,10,opt,name=disable_crd_hook,json=disableCrdHook,proto3" json:"disable_crd_hook,omitempty"`
	// Description, if set, will set the description for the installed release
	Description          string   `protobuf:"bytes,11,opt,name=description,proto3" json:"description,omitempty"`
	SubNotes             bool     `protobuf:"varint,12,opt,name=subNotes,proto3" json:"subNotes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstallReleaseRequest) Reset()         { *m = InstallReleaseRequest{} }
func (m *InstallReleaseRequest) String() string { return proto.CompactTextString(m) }
func (*InstallReleaseRequest) ProtoMessage()    {}
func (*InstallReleaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{11}
}
func (m *InstallReleaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstallReleaseRequest.Unmarshal(m, b)
}
func (m *InstallReleaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstallReleaseRequest.Marshal(b, m, deterministic)
}
func (dst *InstallReleaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstallReleaseRequest.Merge(dst, src)
}
func (m *InstallReleaseRequest) XXX_Size() int {
	return xxx_messageInfo_InstallReleaseRequest.Size(m)
}
func (m *InstallReleaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InstallReleaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InstallReleaseRequest proto.InternalMessageInfo

func (m *InstallReleaseRequest) GetChart() *chart.Chart {
	if m != nil {
		return m.Chart
	}
	return nil
}

func (m *InstallReleaseRequest) GetValues() *chart.Config {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *InstallReleaseRequest) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *InstallReleaseRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *InstallReleaseRequest) GetDisableHooks() bool {
	if m != nil {
		return m.DisableHooks
	}
	return false
}

func (m *InstallReleaseRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *InstallReleaseRequest) GetReuseName() bool {
	if m != nil {
		return m.ReuseName
	}
	return false
}

func (m *InstallReleaseRequest) GetTimeout() int64 {
	if m != nil {
		return m.Timeout
	}
	return 0
}

func (m *InstallReleaseRequest) GetWait() bool {
	if m != nil {
		return m.Wait
	}
	return false
}

func (m *InstallReleaseRequest) GetDisableCrdHook() bool {
	if m != nil {
		return m.DisableCrdHook
	}
	return false
}

func (m *InstallReleaseRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *InstallReleaseRequest) GetSubNotes() bool {
	if m != nil {
		return m.SubNotes
	}
	return false
}

// InstallReleaseResponse is the response from a release installation.
type InstallReleaseResponse struct {
	Release              *release.Release `protobuf:"bytes,1,opt,name=release,proto3" json:"release,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *InstallReleaseResponse) Reset()         { *m = InstallReleaseResponse{} }
func (m *InstallReleaseResponse) String() string { return proto.CompactTextString(m) }
func (*InstallReleaseResponse) ProtoMessage()    {}
func (*InstallReleaseResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{12}
}
func (m *InstallReleaseResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstallReleaseResponse.Unmarshal(m, b)
}
func (m *InstallReleaseResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstallReleaseResponse.Marshal(b, m, deterministic)
}
func (dst *InstallReleaseResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstallReleaseResponse.Merge(dst, src)
}
func (m *InstallReleaseResponse) XXX_Size() int {
	return xxx_messageInfo_InstallReleaseResponse.Size(m)
}
func (m *InstallReleaseResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_InstallReleaseResponse.DiscardUnknown(m)
}

var xxx_messageInfo_InstallReleaseResponse proto.InternalMessageInfo

func (m *InstallReleaseResponse) GetRelease() *release.Release {
	if m != nil {
		return m.Release
	}
	return nil
}

// UninstallReleaseRequest represents a request to uninstall a named release.
type UninstallReleaseRequest struct {
	// Name is the name of the release to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// DisableHooks causes the server to skip running any hooks for the uninstall.
	DisableHooks bool `protobuf:"varint,2,opt,name=disable_hooks,json=disableHooks,proto3" json:"disable_hooks,omitempty"`
	// Purge removes the release from the store and make its name free for later use.
	Purge bool `protobuf:"varint,3,opt,name=purge,proto3" json:"purge,omitempty"`
	// timeout specifies the max amount of time any kubernetes client command can run.
	Timeout int64 `protobuf:"varint,4,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Description, if set, will set the description for the uninstalled release
	Description          string   `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UninstallReleaseRequest) Reset()         { *m = UninstallReleaseRequest{} }
func (m *UninstallReleaseRequest) String() string { return proto.CompactTextString(m) }
func (*UninstallReleaseRequest) ProtoMessage()    {}
func (*UninstallReleaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{13}
}
func (m *UninstallReleaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UninstallReleaseRequest.Unmarshal(m, b)
}
func (m *UninstallReleaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UninstallReleaseRequest.Marshal(b, m, deterministic)
}
func (dst *UninstallReleaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UninstallReleaseRequest.Merge(dst, src)
}
func (m *UninstallReleaseRequest) XXX_Size() int {
	return xxx_messageInfo_UninstallReleaseRequest.Size(m)
}
func (m *UninstallReleaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UninstallReleaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UninstallReleaseRequest proto.InternalMessageInfo

func (m *UninstallReleaseRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UninstallReleaseRequest) GetDisableHooks() bool {
	if m != nil {
		return m.DisableHooks
	}
	return false
}

func (m *UninstallReleaseRequest) GetPurge() bool {
	if m != nil {
		return m.Purge
	}
	return false
}

func (m *UninstallReleaseRequest) GetTimeout() int64 {
	if m != nil {
		return m.Timeout
	}
	return 0
}

func (m *UninstallReleaseRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// UninstallReleaseResponse represents a successful response to an uninstall request.
type UninstallReleaseResponse struct {
	// Release is the release that was marked deleted.
	Release *release.Release `protobuf:"bytes,1,opt,name=release,proto3" json:"release,omitempty"`
	// Info is an uninstall message
	Info                 string   `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UninstallReleaseResponse) Reset()         { *m = UninstallReleaseResponse{} }
func (m *UninstallReleaseResponse) String() string { return proto.CompactTextString(m) }
func (*UninstallReleaseResponse) ProtoMessage()    {}
func (*UninstallReleaseResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{14}
}
func (m *UninstallReleaseResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UninstallReleaseResponse.Unmarshal(m, b)
}
func (m *UninstallReleaseResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UninstallReleaseResponse.Marshal(b, m, deterministic)
}
func (dst *UninstallReleaseResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UninstallReleaseResponse.Merge(dst, src)
}
func (m *UninstallReleaseResponse) XXX_Size() int {
	return xxx_messageInfo_UninstallReleaseResponse.Size(m)
}
func (m *UninstallReleaseResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UninstallReleaseResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UninstallReleaseResponse proto.InternalMessageInfo

func (m *UninstallReleaseResponse) GetRelease() *release.Release {
	if m != nil {
		return m.Release
	}
	return nil
}

func (m *UninstallReleaseResponse) GetInfo() string {
	if m != nil {
		return m.Info
	}
	return ""
}

// GetVersionRequest requests for version information.
type GetVersionRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetVersionRequest) Reset()         { *m = GetVersionRequest{} }
func (m *GetVersionRequest) String() string { return proto.CompactTextString(m) }
func (*GetVersionRequest) ProtoMessage()    {}
func (*GetVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{15}
}
func (m *GetVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetVersionRequest.Unmarshal(m, b)
}
func (m *GetVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetVersionRequest.Marshal(b, m, deterministic)
}
func (dst *GetVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetVersionRequest.Merge(dst, src)
}
func (m *GetVersionRequest) XXX_Size() int {
	return xxx_messageInfo_GetVersionRequest.Size(m)
}
func (m *GetVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetVersionRequest proto.InternalMessageInfo

type GetVersionResponse struct {
	Version              *version.Version `protobuf:"bytes,1,opt,name=Version,proto3" json:"Version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *GetVersionResponse) Reset()         { *m = GetVersionResponse{} }
func (m *GetVersionResponse) String() string { return proto.CompactTextString(m) }
func (*GetVersionResponse) ProtoMessage()    {}
func (*GetVersionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{16}
}
func (m *GetVersionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetVersionResponse.Unmarshal(m, b)
}
func (m *GetVersionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetVersionResponse.Marshal(b, m, deterministic)
}
func (dst *GetVersionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetVersionResponse.Merge(dst, src)
}
func (m *GetVersionResponse) XXX_Size() int {
	return xxx_messageInfo_GetVersionResponse.Size(m)
}
func (m *GetVersionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetVersionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetVersionResponse proto.InternalMessageInfo

func (m *GetVersionResponse) GetVersion() *version.Version {
	if m != nil {
		return m.Version
	}
	return nil
}

// GetHistoryRequest requests a release's history.
type GetHistoryRequest struct {
	// The name of the release.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The maximum number of releases to include.
	Max                  int32    `protobuf:"varint,2,opt,name=max,proto3" json:"max,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetHistoryRequest) Reset()         { *m = GetHistoryRequest{} }
func (m *GetHistoryRequest) String() string { return proto.CompactTextString(m) }
func (*GetHistoryRequest) ProtoMessage()    {}
func (*GetHistoryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{17}
}
func (m *GetHistoryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetHistoryRequest.Unmarshal(m, b)
}
func (m *GetHistoryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetHistoryRequest.Marshal(b, m, deterministic)
}
func (dst *GetHistoryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetHistoryRequest.Merge(dst, src)
}
func (m *GetHistoryRequest) XXX_Size() int {
	return xxx_messageInfo_GetHistoryRequest.Size(m)
}
func (m *GetHistoryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetHistoryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetHistoryRequest proto.InternalMessageInfo

func (m *GetHistoryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetHistoryRequest) GetMax() int32 {
	if m != nil {
		return m.Max
	}
	return 0
}

// GetHistoryResponse is received in response to a GetHistory rpc.
type GetHistoryResponse struct {
	Releases             []*release.Release `protobuf:"bytes,1,rep,name=releases,proto3" json:"releases,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *GetHistoryResponse) Reset()         { *m = GetHistoryResponse{} }
func (m *GetHistoryResponse) String() string { return proto.CompactTextString(m) }
func (*GetHistoryResponse) ProtoMessage()    {}
func (*GetHistoryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{18}
}
func (m *GetHistoryResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetHistoryResponse.Unmarshal(m, b)
}
func (m *GetHistoryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetHistoryResponse.Marshal(b, m, deterministic)
}
func (dst *GetHistoryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetHistoryResponse.Merge(dst, src)
}
func (m *GetHistoryResponse) XXX_Size() int {
	return xxx_messageInfo_GetHistoryResponse.Size(m)
}
func (m *GetHistoryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetHistoryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetHistoryResponse proto.InternalMessageInfo

func (m *GetHistoryResponse) GetReleases() []*release.Release {
	if m != nil {
		return m.Releases
	}
	return nil
}

// TestReleaseRequest is a request to get the status of a release.
type TestReleaseRequest struct {
	// Name is the name of the release
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// timeout specifies the max amount of time any kubernetes client command can run.
	Timeout int64 `protobuf:"varint,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// cleanup specifies whether or not to attempt pod deletion after test completes
	Cleanup bool `protobuf:"varint,3,opt,name=cleanup,proto3" json:"cleanup,omitempty"`
	// parallel specifies whether or not to run test pods in parallel
	Parallel bool `protobuf:"varint,4,opt,name=parallel,proto3" json:"parallel,omitempty"`
	// maximum number of test pods to run in parallel
	MaxParallel uint32 `protobuf:"varint,5,opt,name=max_parallel,json=maxParallel,proto3" json:"max_parallel,omitempty"`
	// logs specifies whether or not to dump the logs from the test pods
	Logs                 bool     `protobuf:"varint,6,opt,name=logs,proto3" json:"logs,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestReleaseRequest) Reset()         { *m = TestReleaseRequest{} }
func (m *TestReleaseRequest) String() string { return proto.CompactTextString(m) }
func (*TestReleaseRequest) ProtoMessage()    {}
func (*TestReleaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{19}
}
func (m *TestReleaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestReleaseRequest.Unmarshal(m, b)
}
func (m *TestReleaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestReleaseRequest.Marshal(b, m, deterministic)
}
func (dst *TestReleaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestReleaseRequest.Merge(dst, src)
}
func (m *TestReleaseRequest) XXX_Size() int {
	return xxx_messageInfo_TestReleaseRequest.Size(m)
}
func (m *TestReleaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TestReleaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TestReleaseRequest proto.InternalMessageInfo

func (m *TestReleaseRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TestReleaseRequest) GetTimeout() int64 {
	if m != nil {
		return m.Timeout
	}
	return 0
}

func (m *TestReleaseRequest) GetCleanup() bool {
	if m != nil {
		return m.Cleanup
	}
	return false
}

func (m *TestReleaseRequest) GetParallel() bool {
	if m != nil {
		return m.Parallel
	}
	return false
}

func (m *TestReleaseRequest) GetMaxParallel() uint32 {
	if m != nil {
		return m.MaxParallel
	}
	return 0
}

func (m *TestReleaseRequest) GetLogs() bool {
	if m != nil {
		return m.Logs
	}
	return false
}

// TestReleaseResponse represents a message from executing a test
type TestReleaseResponse struct {
	Msg                  string                 `protobuf:"bytes,1,opt,name=msg,proto3" json:"msg,omitempty"`
	Status               release.TestRun_Status `protobuf:"varint,2,opt,name=status,proto3,enum=hapi.release.TestRun_Status" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *TestReleaseResponse) Reset()         { *m = TestReleaseResponse{} }
func (m *TestReleaseResponse) String() string { return proto.CompactTextString(m) }
func (*TestReleaseResponse) ProtoMessage()    {}
func (*TestReleaseResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_tiller_0094511522f6b040, []int{20}
}
func (m *TestReleaseResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestReleaseResponse.Unmarshal(m, b)
}
func (m *TestReleaseResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestReleaseResponse.Marshal(b, m, deterministic)
}
func (dst *TestReleaseResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestReleaseResponse.Merge(dst, src)
}
func (m *TestReleaseResponse) XXX_Size() int {
	return xxx_messageInfo_TestReleaseResponse.Size(m)
}
func (m *TestReleaseResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TestReleaseResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TestReleaseResponse proto.InternalMessageInfo

func (m *TestReleaseResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

func (m *TestReleaseResponse) GetStatus() release.TestRun_Status {
	if m != nil {
		return m.Status
	}
	return release.TestRun_UNKNOWN
}

func init() {
	proto.RegisterType((*ListReleasesRequest)(nil), "hapi.services.tiller.ListReleasesRequest")
	proto.RegisterType((*ListSort)(nil), "hapi.services.tiller.ListSort")
	proto.RegisterType((*ListReleasesResponse)(nil), "hapi.services.tiller.ListReleasesResponse")
	proto.RegisterType((*GetReleaseStatusRequest)(nil), "hapi.services.tiller.GetReleaseStatusRequest")
	proto.RegisterType((*GetReleaseStatusResponse)(nil), "hapi.services.tiller.GetReleaseStatusResponse")
	proto.RegisterType((*GetReleaseContentRequest)(nil), "hapi.services.tiller.GetReleaseContentRequest")
	proto.RegisterType((*GetReleaseContentResponse)(nil), "hapi.services.tiller.GetReleaseContentResponse")
	proto.RegisterType((*UpdateReleaseRequest)(nil), "hapi.services.tiller.UpdateReleaseRequest")
	proto.RegisterType((*UpdateReleaseResponse)(nil), "hapi.services.tiller.UpdateReleaseResponse")
	proto.RegisterType((*RollbackReleaseRequest)(nil), "hapi.services.tiller.RollbackReleaseRequest")
	proto.RegisterType((*RollbackReleaseResponse)(nil), "hapi.services.tiller.RollbackReleaseResponse")
	proto.RegisterType((*InstallReleaseRequest)(nil), "hapi.services.tiller.InstallReleaseRequest")
	proto.RegisterType((*InstallReleaseResponse)(nil), "hapi.services.tiller.InstallReleaseResponse")
	proto.RegisterType((*UninstallReleaseRequest)(nil), "hapi.services.tiller.UninstallReleaseRequest")
	proto.RegisterType((*UninstallReleaseResponse)(nil), "hapi.services.tiller.UninstallReleaseResponse")
	proto.RegisterType((*GetVersionRequest)(nil), "hapi.services.tiller.GetVersionRequest")
	proto.RegisterType((*GetVersionResponse)(nil), "hapi.services.tiller.GetVersionResponse")
	proto.RegisterType((*GetHistoryRequest)(nil), "hapi.services.tiller.GetHistoryRequest")
	proto.RegisterType((*GetHistoryResponse)(nil), "hapi.services.tiller.GetHistoryResponse")
	proto.RegisterType((*TestReleaseRequest)(nil), "hapi.services.tiller.TestReleaseRequest")
	proto.RegisterType((*TestReleaseResponse)(nil), "hapi.services.tiller.TestReleaseResponse")
	proto.RegisterEnum("hapi.services.tiller.ListSort_SortBy", ListSort_SortBy_name, ListSort_SortBy_value)
	proto.RegisterEnum("hapi.services.tiller.ListSort_SortOrder", ListSort_SortOrder_name, ListSort_SortOrder_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ReleaseServiceClient is the client API for ReleaseService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ReleaseServiceClient interface {
	// ListReleases retrieves release history.
	// TODO: Allow filtering the set of releases by
	// release status. By default, ListAllReleases returns the releases who
	// current status is "Active".
	ListReleases(ctx context.Context, in *ListReleasesRequest, opts ...grpc.CallOption) (ReleaseService_ListReleasesClient, error)
	// GetReleasesStatus retrieves status information for the specified release.
	GetReleaseStatus(ctx context.Context, in *GetReleaseStatusRequest, opts ...grpc.CallOption) (*GetReleaseStatusResponse, error)
	// GetReleaseContent retrieves the release content (chart + value) for the specified release.
	GetReleaseContent(ctx context.Context, in *GetReleaseContentRequest, opts ...grpc.CallOption) (*GetReleaseContentResponse, error)
	// UpdateRelease updates release content.
	UpdateRelease(ctx context.Context, in *UpdateReleaseRequest, opts ...grpc.CallOption) (*UpdateReleaseResponse, error)
	// InstallRelease requests installation of a chart as a new release.
	InstallRelease(ctx context.Context, in *InstallReleaseRequest, opts ...grpc.CallOption) (*InstallReleaseResponse, error)
	// UninstallRelease requests deletion of a named release.
	UninstallRelease(ctx context.Context, in *UninstallReleaseRequest, opts ...grpc.CallOption) (*UninstallReleaseResponse, error)
	// GetVersion returns the current version of the server.
	GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*GetVersionResponse, error)
	// RollbackRelease rolls back a release to a previous version.
	RollbackRelease(ctx context.Context, in *RollbackReleaseRequest, opts ...grpc.CallOption) (*RollbackReleaseResponse, error)
	// ReleaseHistory retrieves a release's history.
	GetHistory(ctx context.Context, in *GetHistoryRequest, opts ...grpc.CallOption) (*GetHistoryResponse, error)
	// RunReleaseTest executes the tests defined of a named release
	RunReleaseTest(ctx context.Context, in *TestReleaseRequest, opts ...grpc.CallOption) (ReleaseService_RunReleaseTestClient, error)
}

type releaseServiceClient struct {
	cc *grpc.ClientConn
}

func NewReleaseServiceClient(cc *grpc.ClientConn) ReleaseServiceClient {
	return &releaseServiceClient{cc}
}

func (c *releaseServiceClient) ListReleases(ctx context.Context, in *ListReleasesRequest, opts ...grpc.CallOption) (ReleaseService_ListReleasesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ReleaseService_serviceDesc.Streams[0], "/hapi.services.tiller.ReleaseService/ListReleases", opts...)
	if err != nil {
		return nil, err
	}
	x := &releaseServiceListReleasesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ReleaseService_ListReleasesClient interface {
	Recv() (*ListReleasesResponse, error)
	grpc.ClientStream
}

type releaseServiceListReleasesClient struct {
	grpc.ClientStream
}

func (x *releaseServiceListReleasesClient) Recv() (*ListReleasesResponse, error) {
	m := new(ListReleasesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *releaseServiceClient) GetReleaseStatus(ctx context.Context, in *GetReleaseStatusRequest, opts ...grpc.CallOption) (*GetReleaseStatusResponse, error) {
	out := new(GetReleaseStatusResponse)
	err := c.cc.Invoke(ctx, "/hapi.services.tiller.ReleaseService/GetReleaseStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *releaseServiceClient) GetReleaseContent(ctx context.Context, in *GetReleaseContentRequest, opts ...grpc.CallOption) (*GetReleaseContentResponse, error) {
	out := new(GetReleaseContentResponse)
	err := c.cc.Invoke(ctx, "/hapi.services.tiller.ReleaseService/GetReleaseContent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *releaseServiceClient) UpdateRelease(ctx context.Context, in *UpdateReleaseRequest, opts ...grpc.CallOption) (*UpdateReleaseResponse, error) {
	out := new(UpdateReleaseResponse)
	err := c.cc.Invoke(ctx, "/hapi.services.tiller.ReleaseService/UpdateRelease", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *releaseServiceClient) InstallRelease(ctx context.Context, in *InstallReleaseRequest, opts ...grpc.CallOption) (*InstallReleaseResponse, error) {
	out := new(InstallReleaseResponse)
	err := c.cc.Invoke(ctx, "/hapi.services.tiller.ReleaseService/InstallRelease", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *releaseServiceClient) UninstallRelease(ctx context.Context, in *UninstallReleaseRequest, opts ...grpc.CallOption) (*UninstallReleaseResponse, error) {
	out := new(UninstallReleaseResponse)
	err := c.cc.Invoke(ctx, "/hapi.services.tiller.ReleaseService/UninstallRelease", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *releaseServiceClient) GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*GetVersionResponse, error) {
	out := new(GetVersionResponse)
	err := c.cc.Invoke(ctx, "/hapi.services.tiller.ReleaseService/GetVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *releaseServiceClient) RollbackRelease(ctx context.Context, in *RollbackReleaseRequest, opts ...grpc.CallOption) (*RollbackReleaseResponse, error) {
	out := new(RollbackReleaseResponse)
	err := c.cc.Invoke(ctx, "/hapi.services.tiller.ReleaseService/RollbackRelease", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *releaseServiceClient) GetHistory(ctx context.Context, in *GetHistoryRequest, opts ...grpc.CallOption) (*GetHistoryResponse, error) {
	out := new(GetHistoryResponse)
	err := c.cc.Invoke(ctx, "/hapi.services.tiller.ReleaseService/GetHistory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *releaseServiceClient) RunReleaseTest(ctx context.Context, in *TestReleaseRequest, opts ...grpc.CallOption) (ReleaseService_RunReleaseTestClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ReleaseService_serviceDesc.Streams[1], "/hapi.services.tiller.ReleaseService/RunReleaseTest", opts...)
	if err != nil {
		return nil, err
	}
	x := &releaseServiceRunReleaseTestClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ReleaseService_RunReleaseTestClient interface {
	Recv() (*TestReleaseResponse, error)
	grpc.ClientStream
}

type releaseServiceRunReleaseTestClient struct {
	grpc.ClientStream
}

func (x *releaseServiceRunReleaseTestClient) Recv() (*TestReleaseResponse, error) {
	m := new(TestReleaseResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ReleaseServiceServer is the server API for ReleaseService service.
type ReleaseServiceServer interface {
	// ListReleases retrieves release history.
	// TODO: Allow filtering the set of releases by
	// release status. By default, ListAllReleases returns the releases who
	// current status is "Active".
	ListReleases(*ListReleasesRequest, ReleaseService_ListReleasesServer) error
	// GetReleasesStatus retrieves status information for the specified release.
	GetReleaseStatus(context.Context, *GetReleaseStatusRequest) (*GetReleaseStatusResponse, error)
	// GetReleaseContent retrieves the release content (chart + value) for the specified release.
	GetReleaseContent(context.Context, *GetReleaseContentRequest) (*GetReleaseContentResponse, error)
	// UpdateRelease updates release content.
	UpdateRelease(context.Context, *UpdateReleaseRequest) (*UpdateReleaseResponse, error)
	// InstallRelease requests installation of a chart as a new release.
	InstallRelease(context.Context, *InstallReleaseRequest) (*InstallReleaseResponse, error)
	// UninstallRelease requests deletion of a named release.
	UninstallRelease(context.Context, *UninstallReleaseRequest) (*UninstallReleaseResponse, error)
	// GetVersion returns the current version of the server.
	GetVersion(context.Context, *GetVersionRequest) (*GetVersionResponse, error)
	// RollbackRelease rolls back a release to a previous version.
	RollbackRelease(context.Context, *RollbackReleaseRequest) (*RollbackReleaseResponse, error)
	// ReleaseHistory retrieves a release's history.
	GetHistory(context.Context, *GetHistoryRequest) (*GetHistoryResponse, error)
	// RunReleaseTest executes the tests defined of a named release
	RunReleaseTest(*TestReleaseRequest, ReleaseService_RunReleaseTestServer) error
}

func RegisterReleaseServiceServer(s *grpc.Server, srv ReleaseServiceServer) {
	s.RegisterService(&_ReleaseService_serviceDesc, srv)
}

func _ReleaseService_ListReleases_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListReleasesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ReleaseServiceServer).ListReleases(m, &releaseServiceListReleasesServer{stream})
}

type ReleaseService_ListReleasesServer interface {
	Send(*ListReleasesResponse) error
	grpc.ServerStream
}

type releaseServiceListReleasesServer struct {
	grpc.ServerStream
}

func (x *releaseServiceListReleasesServer) Send(m *ListReleasesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ReleaseService_GetReleaseStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReleaseStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReleaseServiceServer).GetReleaseStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hapi.services.tiller.ReleaseService/GetReleaseStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReleaseServiceServer).GetReleaseStatus(ctx, req.(*GetReleaseStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReleaseService_GetReleaseContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReleaseContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReleaseServiceServer).GetReleaseContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hapi.services.tiller.ReleaseService/GetReleaseContent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReleaseServiceServer).GetReleaseContent(ctx, req.(*GetReleaseContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReleaseService_UpdateRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReleaseServiceServer).UpdateRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hapi.services.tiller.ReleaseService/UpdateRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReleaseServiceServer).UpdateRelease(ctx, req.(*UpdateReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReleaseService_InstallRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InstallReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReleaseServiceServer).InstallRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hapi.services.tiller.ReleaseService/InstallRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReleaseServiceServer).InstallRelease(ctx, req.(*InstallReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReleaseService_UninstallRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UninstallReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReleaseServiceServer).UninstallRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hapi.services.tiller.ReleaseService/UninstallRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReleaseServiceServer).UninstallRelease(ctx, req.(*UninstallReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReleaseService_GetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReleaseServiceServer).GetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hapi.services.tiller.ReleaseService/GetVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReleaseServiceServer).GetVersion(ctx, req.(*GetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReleaseService_RollbackRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReleaseServiceServer).RollbackRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hapi.services.tiller.ReleaseService/RollbackRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReleaseServiceServer).RollbackRelease(ctx, req.(*RollbackReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReleaseService_GetHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReleaseServiceServer).GetHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hapi.services.tiller.ReleaseService/GetHistory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReleaseServiceServer).GetHistory(ctx, req.(*GetHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReleaseService_RunReleaseTest_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(TestReleaseRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ReleaseServiceServer).RunReleaseTest(m, &releaseServiceRunReleaseTestServer{stream})
}

type ReleaseService_RunReleaseTestServer interface {
	Send(*TestReleaseResponse) error
	grpc.ServerStream
}

type releaseServiceRunReleaseTestServer struct {
	grpc.ServerStream
}

func (x *releaseServiceRunReleaseTestServer) Send(m *TestReleaseResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _ReleaseService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "hapi.services.tiller.ReleaseService",
	HandlerType: (*ReleaseServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetReleaseStatus",
			Handler:    _ReleaseService_GetReleaseStatus_Handler,
		},
		{
			MethodName: "GetReleaseContent",
			Handler:    _ReleaseService_GetReleaseContent_Handler,
		},
		{
			MethodName: "UpdateRelease",
			Handler:    _ReleaseService_UpdateRelease_Handler,
		},
		{
			MethodName: "InstallRelease",
			Handler:    _ReleaseService_InstallRelease_Handler,
		},
		{
			MethodName: "UninstallRelease",
			Handler:    _ReleaseService_UninstallRelease_Handler,
		},
		{
			MethodName: "GetVersion",
			Handler:    _ReleaseService_GetVersion_Handler,
		},
		{
			MethodName: "RollbackRelease",
			Handler:    _ReleaseService_RollbackRelease_Handler,
		},
		{
			MethodName: "GetHistory",
			Handler:    _ReleaseService_GetHistory_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ListReleases",
			Handler:       _ReleaseService_ListReleases_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RunReleaseTest",
			Handler:       _ReleaseService_RunReleaseTest_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "hapi/services/tiller.proto",
}

func init() { proto.RegisterFile("hapi/services/tiller.proto", fileDescriptor_tiller_0094511522f6b040) }

var fileDescriptor_tiller_0094511522f6b040 = []byte{
	// 1369 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x58, 0xdd, 0x72, 0x1b, 0xc5,
	0x12, 0xb6, 0xb4, 0xfa, 0x6d, 0xd9, 0x8a, 0x32, 0x71, 0xec, 0x8d, 0x4e, 0xce, 0x29, 0x9f, 0xa5,
	0x48, 0x94, 0x40, 0x64, 0x30, 0xdc, 0x50, 0x45, 0x51, 0xe5, 0x28, 0xc6, 0x0e, 0x18, 0x87, 0x5a,
	0x27, 0xa1, 0x8a, 0x2a, 0x4a, 0x35, 0x96, 0x46, 0xce, 0x92, 0xd5, 0x8e, 0xd8, 0x99, 0x35, 0xf6,
	0x23, 0x70, 0xc9, 0x3b, 0x70, 0x0d, 0xaf, 0xc0, 0x2d, 0xcf, 0xc0, 0xcb, 0x50, 0xf3, 0xb7, 0xd6,
	0xac, 0x76, 0x15, 0xe1, 0x1b, 0xed, 0xcc, 0x74, 0x4f, 0x77, 0xcf, 0xf7, 0x4d, 0xf7, 0xb4, 0x0d,
	0xdd, 0x37, 0x78, 0x16, 0xec, 0x32, 0x12, 0x5f, 0x04, 0x23, 0xc2, 0x76, 0x79, 0x10, 0x86, 0x24,
	0xee, 0xcf, 0x62, 0xca, 0x29, 0xda, 0x14, 0xb2, 0xbe, 0x91, 0xf5, 0x95, 0xac, 0xbb, 0x25, 0x77,
	0x8c, 0xde, 0xe0, 0x98, 0xab, 0x5f, 0xa5, 0xdd, 0xdd, 0x9e, 0x5f, 0xa7, 0xd1, 0x24, 0x38, 0xd7,
	0x02, 0xe5, 0x22, 0x26, 0x21, 0xc1, 0x8c, 0x98, 0xaf, 0xb5, 0xc9, 0xc8, 0x82, 0x68, 0x42, 0xb5,
	0xe0, 0x3f, 0x96, 0x80, 0x13, 0xc6, 0x87, 0x71, 0x12, 0x69, 0xe1, 0x3d, 0x4b, 0xc8, 0x38, 0xe6,
	0x09, 0xb3, 0x9c, 0x5d, 0x90, 0x98, 0x05, 0x34, 0x32, 0x5f, 0x25, 0xf3, 0xfe, 0x2c, 0xc3, 0x9d,
	0xe3, 0x80, 0x71, 0x5f, 0x6d, 0x64, 0x3e, 0xf9, 0x29, 0x21, 0x8c, 0xa3, 0x4d, 0xa8, 0x86, 0xc1,
	0x34, 0xe0, 0x6e, 0x69, 0xa7, 0xd4, 0x73, 0x7c, 0x35, 0x41, 0x5b, 0x50, 0xa3, 0x93, 0x09, 0x23,
	0xdc, 0x2d, 0xef, 0x94, 0x7a, 0x4d, 0x5f, 0xcf, 0xd0, 0x17, 0x50, 0x67, 0x34, 0xe6, 0xc3, 0xb3,
	0x2b, 0xd7, 0xd9, 0x29, 0xf5, 0xda, 0x7b, 0xef, 0xf7, 0xf3, 0x70, 0xea, 0x0b, 0x4f, 0xa7, 0x34,
	0xe6, 0x7d, 0xf1, 0xf3, 0xf4, 0xca, 0xaf, 0x31, 0xf9, 0x15, 0x76, 0x27, 0x41, 0xc8, 0x49, 0xec,
	0x56, 0x94, 0x5d, 0x35, 0x43, 0x87, 0x00, 0xd2, 0x2e, 0x8d, 0xc7, 0x24, 0x76, 0xab, 0xd2, 0x74,
	0x6f, 0x05, 0xd3, 0x2f, 0x84, 0xbe, 0xdf, 0x64, 0x66, 0x88, 0x3e, 0x87, 0x75, 0x05, 0xc9, 0x70,
	0x44, 0xc7, 0x84, 0xb9, 0xb5, 0x1d, 0xa7, 0xd7, 0xde, 0xbb, 0xa7, 0x4c, 0x19, 0xf8, 0x4f, 0x15,
	0x68, 0x03, 0x3a, 0x26, 0x7e, 0x4b, 0xa9, 0x8b, 0x31, 0x43, 0xf7, 0xa1, 0x19, 0xe1, 0x29, 0x61,
	0x33, 0x3c, 0x22, 0x6e, 0x5d, 0x46, 0x78, 0xbd, 0xe0, 0x45, 0xd0, 0x30, 0xce, 0xbd, 0xa7, 0x50,
	0x53, 0x47, 0x43, 0x2d, 0xa8, 0xbf, 0x3a, 0xf9, 0xfa, 0xe4, 0xc5, 0x77, 0x27, 0x9d, 0x35, 0xd4,
	0x80, 0xca, 0xc9, 0xfe, 0x37, 0x07, 0x9d, 0x12, 0xba, 0x0d, 0x1b, 0xc7, 0xfb, 0xa7, 0x2f, 0x87,
	0xfe, 0xc1, 0xf1, 0xc1, 0xfe, 0xe9, 0xc1, 0xb3, 0x4e, 0x19, 0xb5, 0x01, 0x06, 0x47, 0xfb, 0xfe,
	0xcb, 0xa1, 0x54, 0x71, 0xbc, 0xff, 0x41, 0x33, 0x3d, 0x03, 0xaa, 0x83, 0xb3, 0x7f, 0x3a, 0x50,
	0x26, 0x9e, 0x1d, 0x9c, 0x0e, 0x3a, 0x25, 0xef, 0x97, 0x12, 0x6c, 0xda, 0x94, 0xb1, 0x19, 0x8d,
	0x18, 0x11, 0x9c, 0x8d, 0x68, 0x12, 0xa5, 0x9c, 0xc9, 0x09, 0x42, 0x50, 0x89, 0xc8, 0xa5, 0x61,
	0x4c, 0x8e, 0x85, 0x26, 0xa7, 0x1c, 0x87, 0x92, 0x2d, 0xc7, 0x57, 0x13, 0xf4, 0x31, 0x34, 0x34,
	0x14, 0xcc, 0xad, 0xec, 0x38, 0xbd, 0xd6, 0xde, 0x5d, 0x1b, 0x20, 0xed, 0xd1, 0x4f, 0xd5, 0xbc,
	0x43, 0xd8, 0x3e, 0x24, 0x26, 0x12, 0x85, 0x9f, 0xb9, 0x41, 0xc2, 0x2f, 0x9e, 0x12, 0x19, 0x8c,
	0xf0, 0x8b, 0xa7, 0x04, 0xb9, 0x50, 0xd7, 0xd7, 0x4f, 0x86, 0x53, 0xf5, 0xcd, 0xd4, 0xe3, 0xe0,
	0x2e, 0x1a, 0xd2, 0xe7, 0xca, 0xb3, 0xf4, 0x00, 0x2a, 0x22, 0x33, 0xa4, 0x99, 0xd6, 0x1e, 0xb2,
	0xe3, 0x7c, 0x1e, 0x4d, 0xa8, 0x2f, 0xe5, 0x36, 0x75, 0x4e, 0x96, 0xba, 0xa3, 0x79, 0xaf, 0x03,
	0x1a, 0x71, 0x12, 0xf1, 0x9b, 0xc5, 0x7f, 0x0c, 0xf7, 0x72, 0x2c, 0xe9, 0x03, 0xec, 0x42, 0x5d,
	0x87, 0x26, 0xad, 0x15, 0xe2, 0x6a, 0xb4, 0xbc, 0xbf, 0x1c, 0xd8, 0x7c, 0x35, 0x1b, 0x63, 0x4e,
	0x8c, 0x68, 0x49, 0x50, 0x0f, 0xa1, 0x2a, 0x2b, 0x8c, 0xc6, 0xe2, 0xb6, 0xb2, 0xad, 0xca, 0xd0,
	0x40, 0xfc, 0xfa, 0x4a, 0x8e, 0x1e, 0x43, 0xed, 0x02, 0x87, 0x09, 0x61, 0x12, 0x88, 0x14, 0x35,
	0xad, 0x29, 0xcb, 0x93, 0xaf, 0x35, 0xd0, 0x36, 0xd4, 0xc7, 0xf1, 0x95, 0xa8, 0x2f, 0x32, 0x25,
	0x1b, 0x7e, 0x6d, 0x1c, 0x5f, 0xf9, 0x49, 0x84, 0xde, 0x83, 0x8d, 0x71, 0xc0, 0xf0, 0x59, 0x48,
	0x86, 0x6f, 0x28, 0x7d, 0xcb, 0x64, 0x56, 0x36, 0xfc, 0x75, 0xbd, 0x78, 0x24, 0xd6, 0x50, 0x57,
	0xdc, 0xa4, 0x51, 0x4c, 0x30, 0x27, 0x6e, 0x4d, 0xca, 0xd3, 0xb9, 0xc0, 0x90, 0x07, 0x53, 0x42,
	0x13, 0x2e, 0x53, 0xc9, 0xf1, 0xcd, 0x14, 0xfd, 0x1f, 0xd6, 0x63, 0xc2, 0x08, 0x1f, 0xea, 0x28,
	0x1b, 0x72, 0x67, 0x4b, 0xae, 0xbd, 0x56, 0x61, 0x21, 0xa8, 0xfc, 0x8c, 0x03, 0xee, 0x36, 0xa5,
	0x48, 0x8e, 0xd5, 0xb6, 0x84, 0x11, 0xb3, 0x0d, 0xcc, 0xb6, 0x84, 0x11, 0xbd, 0x6d, 0x13, 0xaa,
	0x13, 0x1a, 0x8f, 0x88, 0xdb, 0x92, 0x32, 0x35, 0x41, 0x3b, 0xd0, 0x1a, 0x13, 0x36, 0x8a, 0x83,
	0x19, 0x17, 0x8c, 0xae, 0x4b, 0x4c, 0xe7, 0x97, 0xc4, 0x39, 0x58, 0x72, 0x76, 0x42, 0x39, 0x61,
	0xee, 0x86, 0x3a, 0x87, 0x99, 0xa3, 0x07, 0x70, 0x6b, 0x14, 0x12, 0x1c, 0x25, 0xb3, 0x21, 0x8d,
	0x86, 0x13, 0x1c, 0x84, 0x6e, 0x5b, 0xaa, 0x6c, 0xe8, 0xe5, 0x17, 0xd1, 0x97, 0x38, 0x08, 0xbd,
	0x23, 0xb8, 0x9b, 0xa1, 0xf2, 0xa6, 0xb7, 0xe2, 0xf7, 0x32, 0x6c, 0xf9, 0x34, 0x0c, 0xcf, 0xf0,
	0xe8, 0xed, 0x0a, 0xf7, 0x62, 0x8e, 0xc2, 0xf2, 0x72, 0x0a, 0x9d, 0x1c, 0x0a, 0xe7, 0xae, 0x7a,
	0xc5, 0xba, 0xea, 0x16, 0xb9, 0xd5, 0x62, 0x72, 0x6b, 0x36, 0xb9, 0x86, 0xb9, 0xfa, 0x1c, 0x73,
	0x29, 0x2d, 0x8d, 0x25, 0xb4, 0x34, 0x17, 0x69, 0xc9, 0x81, 0x1e, 0xf2, 0xa0, 0xff, 0x0a, 0xb6,
	0x17, 0xf0, 0xba, 0x29, 0xf8, 0xbf, 0x3a, 0x70, 0xf7, 0x79, 0xc4, 0x38, 0x0e, 0xc3, 0x0c, 0xf6,
	0x69, 0xfe, 0x95, 0x56, 0xce, 0xbf, 0xf2, 0xbf, 0xc9, 0x3f, 0xc7, 0x22, 0xcf, 0x30, 0x5d, 0x99,
	0x63, 0x7a, 0xa5, 0x9c, 0xb4, 0x2a, 0x61, 0x2d, 0x53, 0x09, 0xd1, 0x7f, 0x01, 0x54, 0x12, 0x49,
	0xe3, 0x8a, 0xa4, 0xa6, 0x5c, 0x39, 0xd1, 0x85, 0xcf, 0xf0, 0xda, 0xc8, 0xe7, 0x75, 0x3e, 0x23,
	0x7b, 0xd0, 0x31, 0xf1, 0x8c, 0xe2, 0xb1, 0x8c, 0x49, 0x13, 0xd4, 0xd6, 0xeb, 0x83, 0x78, 0x2c,
	0xa2, 0xca, 0x72, 0xdd, 0x5a, 0x9e, 0x82, 0xeb, 0x76, 0x0a, 0x7a, 0xcf, 0x61, 0x2b, 0x4b, 0xc9,
	0x4d, 0xe9, 0xfd, 0xad, 0x04, 0xdb, 0xaf, 0xa2, 0x20, 0x97, 0xe0, 0xbc, 0xe4, 0x5a, 0x80, 0xbc,
	0x9c, 0x03, 0xf9, 0x26, 0x54, 0x67, 0x49, 0x7c, 0x4e, 0x34, 0x85, 0x6a, 0x32, 0x8f, 0x65, 0xc5,
	0xc6, 0x32, 0x83, 0x46, 0x75, 0x01, 0x0d, 0x6f, 0x08, 0xee, 0x62, 0x94, 0x37, 0x3c, 0xb3, 0x38,
	0x57, 0xfa, 0x86, 0x36, 0xd5, 0x7b, 0xe9, 0xdd, 0x81, 0xdb, 0x87, 0x84, 0xbf, 0x56, 0xa9, 0xae,
	0x01, 0xf0, 0x0e, 0x00, 0xcd, 0x2f, 0x5e, 0xfb, 0xd3, 0x4b, 0xb6, 0x3f, 0xd3, 0x60, 0x1a, 0x7d,
	0xa3, 0xe5, 0x7d, 0x26, 0x6d, 0x1f, 0x05, 0x8c, 0xd3, 0xf8, 0x6a, 0x19, 0xb8, 0x1d, 0x70, 0xa6,
	0xf8, 0x52, 0x3f, 0xb1, 0x62, 0xe8, 0x1d, 0xca, 0x08, 0xd2, 0xad, 0x3a, 0x82, 0xf9, 0x86, 0xa5,
	0xb4, 0x5a, 0xc3, 0xf2, 0x47, 0x09, 0xd0, 0x4b, 0x92, 0x36, 0x4f, 0xef, 0x78, 0xec, 0x0d, 0x4f,
	0x65, 0x9b, 0x27, 0x17, 0xea, 0xba, 0xd0, 0x68, 0x66, 0xcd, 0x54, 0xdc, 0xd6, 0x19, 0x8e, 0x71,
	0x18, 0x92, 0x50, 0xbf, 0x9b, 0xe9, 0x5c, 0xbc, 0x53, 0x53, 0x7c, 0x39, 0x4c, 0xe5, 0x82, 0xde,
	0x0d, 0xbf, 0x35, 0xc5, 0x97, 0xdf, 0x1a, 0x15, 0x04, 0x95, 0x90, 0x9e, 0x33, 0xfd, 0x66, 0xca,
	0xb1, 0xf7, 0x03, 0xdc, 0xb1, 0x02, 0xd6, 0x67, 0x17, 0x18, 0xb1, 0x73, 0x1d, 0xb0, 0x18, 0xa2,
	0x4f, 0xa1, 0xa6, 0x9a, 0x56, 0x19, 0x6e, 0x7b, 0xef, 0xbe, 0x8d, 0x85, 0x34, 0x92, 0x44, 0xba,
	0xcb, 0xf5, 0xb5, 0xee, 0xde, 0xdf, 0x0d, 0x68, 0x9b, 0xb6, 0x4b, 0xb5, 0xd4, 0x28, 0x80, 0xf5,
	0xf9, 0xfe, 0x12, 0x3d, 0x2a, 0xee, 0xb8, 0x33, 0x7f, 0x36, 0x74, 0x1f, 0xaf, 0xa2, 0xaa, 0x4e,
	0xe0, 0xad, 0x7d, 0x54, 0x42, 0x0c, 0x3a, 0xd9, 0xb6, 0x0f, 0x3d, 0xc9, 0xb7, 0x51, 0xd0, 0x67,
	0x76, 0xfb, 0xab, 0xaa, 0x1b, 0xb7, 0xe8, 0x42, 0xde, 0x43, 0xbb, 0x57, 0x43, 0xef, 0x34, 0x63,
	0xb7, 0x87, 0xdd, 0xdd, 0x95, 0xf5, 0x53, 0xbf, 0x3f, 0xc2, 0x86, 0xd5, 0x09, 0xa0, 0x02, 0xb4,
	0xf2, 0x3a, 0xbf, 0xee, 0x07, 0x2b, 0xe9, 0xa6, 0xbe, 0xa6, 0xd0, 0xb6, 0x4b, 0x23, 0x2a, 0x30,
	0x90, 0xfb, 0xa6, 0x75, 0x3f, 0x5c, 0x4d, 0x39, 0x75, 0xc7, 0xa0, 0x93, 0xad, 0x4b, 0x45, 0x3c,
	0x16, 0x54, 0xd9, 0x22, 0x1e, 0x8b, 0xca, 0x9d, 0xb7, 0x86, 0x30, 0xc0, 0x75, 0x59, 0x42, 0x0f,
	0x0b, 0x09, 0xb1, 0xab, 0x59, 0xb7, 0xf7, 0x6e, 0xc5, 0xd4, 0xc5, 0x0c, 0x6e, 0x65, 0x3a, 0x08,
	0x54, 0x00, 0x4d, 0x7e, 0x63, 0xd6, 0x7d, 0xb2, 0xa2, 0x76, 0xe6, 0x50, 0xba, 0xd2, 0x2d, 0x39,
	0x94, 0x5d, 0x46, 0x97, 0x1c, 0x2a, 0x53, 0x34, 0xbd, 0x35, 0x14, 0x40, 0xdb, 0x4f, 0x22, 0xed,
	0x5a, 0x94, 0x05, 0x54, 0xb0, 0x7b, 0xb1, 0x50, 0x76, 0x1f, 0xad, 0xa0, 0x79, 0x9d, 0xdf, 0x4f,
	0xe1, 0xfb, 0x86, 0x51, 0x3d, 0xab, 0xc9, 0xff, 0x38, 0x7c, 0xf2, 0x4f, 0x00, 0x00, 0x00, 0xff,
	0xff, 0x8a, 0x23, 0x76, 0x0d, 0x5f, 0x11, 0x00, 0x00,
}
