## helm get

Download a named release

### Synopsis


This command shows the details of a named release.

It can be used to get extended information about the release, including:

  - The values used to generate the release
  - The chart used to generate the release
  - The generated manifest file

By default, this prints a human readable collection of information about the
chart, the supplied values, and the generated manifest file.


```
helm get [flags] RELEASE_NAME
```

### Options

```
  -h, --help                  help for get
      --revision int32        Get the named release with revision
      --template string       Go template for formatting the output, eg: {{.Release.Name}}
      --tls                   Enable TLS for request
      --tls-ca-cert string    Path to TLS CA certificate file (default "$HELM_HOME/ca.pem")
      --tls-cert string       Path to TLS certificate file (default "$HELM_HOME/cert.pem")
      --tls-hostname string   The server name used to verify the hostname on the returned certificates from the server
      --tls-key string        Path to TLS key file (default "$HELM_HOME/key.pem")
      --tls-verify            Enable TLS for request and verify remote
```

### Options inherited from parent commands

```
      --debug                           Enable verbose output
      --home string                     Location of your Helm config. Overrides $HELM_HOME (default "~/.helm")
      --host string                     Address of Tiller. Overrides $HELM_HOST
      --kube-context string             Name of the kubeconfig context to use
      --kubeconfig string               Absolute path of the kubeconfig file to be used
      --tiller-connection-timeout int   The duration (in seconds) Helm will wait to establish a connection to Tiller (default 300)
      --tiller-namespace string         Namespace of Tiller (default "kube-system")
```

### SEE ALSO

* [helm](helm.md)	 - The Helm package manager for Kubernetes.
* [helm get hooks](helm_get_hooks.md)	 - Download all hooks for a named release
* [helm get manifest](helm_get_manifest.md)	 - Download the manifest for a named release
* [helm get notes](helm_get_notes.md)	 - Displays the notes of the named release
* [helm get values](helm_get_values.md)	 - Download the values file for a named release

###### Auto generated by spf13/cobra on 16-May-2019
