// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/open-cluster-management/api/addon/v1alpha1"
	scheme "github.com/open-cluster-management/api/client/addon/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ClusterManagementAddOnsGetter has a method to return a ClusterManagementAddOnInterface.
// A group's client should implement this interface.
type ClusterManagementAddOnsGetter interface {
	ClusterManagementAddOns() ClusterManagementAddOnInterface
}

// ClusterManagementAddOnInterface has methods to work with ClusterManagementAddOn resources.
type ClusterManagementAddOnInterface interface {
	Create(ctx context.Context, clusterManagementAddOn *v1alpha1.ClusterManagementAddOn, opts v1.CreateOptions) (*v1alpha1.ClusterManagementAddOn, error)
	Update(ctx context.Context, clusterManagementAddOn *v1alpha1.ClusterManagementAddOn, opts v1.UpdateOptions) (*v1alpha1.ClusterManagementAddOn, error)
	UpdateStatus(ctx context.Context, clusterManagementAddOn *v1alpha1.ClusterManagementAddOn, opts v1.UpdateOptions) (*v1alpha1.ClusterManagementAddOn, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ClusterManagementAddOn, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ClusterManagementAddOnList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ClusterManagementAddOn, err error)
	ClusterManagementAddOnExpansion
}

// clusterManagementAddOns implements ClusterManagementAddOnInterface
type clusterManagementAddOns struct {
	client rest.Interface
}

// newClusterManagementAddOns returns a ClusterManagementAddOns
func newClusterManagementAddOns(c *AddonV1alpha1Client) *clusterManagementAddOns {
	return &clusterManagementAddOns{
		client: c.RESTClient(),
	}
}

// Get takes name of the clusterManagementAddOn, and returns the corresponding clusterManagementAddOn object, and an error if there is any.
func (c *clusterManagementAddOns) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.ClusterManagementAddOn, err error) {
	result = &v1alpha1.ClusterManagementAddOn{}
	err = c.client.Get().
		Resource("clustermanagementaddons").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ClusterManagementAddOns that match those selectors.
func (c *clusterManagementAddOns) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.ClusterManagementAddOnList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ClusterManagementAddOnList{}
	err = c.client.Get().
		Resource("clustermanagementaddons").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested clusterManagementAddOns.
func (c *clusterManagementAddOns) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("clustermanagementaddons").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a clusterManagementAddOn and creates it.  Returns the server's representation of the clusterManagementAddOn, and an error, if there is any.
func (c *clusterManagementAddOns) Create(ctx context.Context, clusterManagementAddOn *v1alpha1.ClusterManagementAddOn, opts v1.CreateOptions) (result *v1alpha1.ClusterManagementAddOn, err error) {
	result = &v1alpha1.ClusterManagementAddOn{}
	err = c.client.Post().
		Resource("clustermanagementaddons").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterManagementAddOn).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a clusterManagementAddOn and updates it. Returns the server's representation of the clusterManagementAddOn, and an error, if there is any.
func (c *clusterManagementAddOns) Update(ctx context.Context, clusterManagementAddOn *v1alpha1.ClusterManagementAddOn, opts v1.UpdateOptions) (result *v1alpha1.ClusterManagementAddOn, err error) {
	result = &v1alpha1.ClusterManagementAddOn{}
	err = c.client.Put().
		Resource("clustermanagementaddons").
		Name(clusterManagementAddOn.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterManagementAddOn).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *clusterManagementAddOns) UpdateStatus(ctx context.Context, clusterManagementAddOn *v1alpha1.ClusterManagementAddOn, opts v1.UpdateOptions) (result *v1alpha1.ClusterManagementAddOn, err error) {
	result = &v1alpha1.ClusterManagementAddOn{}
	err = c.client.Put().
		Resource("clustermanagementaddons").
		Name(clusterManagementAddOn.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterManagementAddOn).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the clusterManagementAddOn and deletes it. Returns an error if one occurs.
func (c *clusterManagementAddOns) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("clustermanagementaddons").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *clusterManagementAddOns) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("clustermanagementaddons").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched clusterManagementAddOn.
func (c *clusterManagementAddOns) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ClusterManagementAddOn, err error) {
	result = &v1alpha1.ClusterManagementAddOn{}
	err = c.client.Patch(pt).
		Resource("clustermanagementaddons").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
