// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/data/cluster/v3alpha/outlier_detection_event.proto

package envoy_data_cluster_v3alpha

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/golang/protobuf/ptypes"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = ptypes.DynamicAny{}
)

// define the regex for a UUID once up-front
var _outlier_detection_event_uuidPattern = regexp.MustCompile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")

// Validate checks the field values on OutlierDetectionEvent with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *OutlierDetectionEvent) Validate() error {
	if m == nil {
		return nil
	}

	if _, ok := OutlierEjectionType_name[int32(m.GetType())]; !ok {
		return OutlierDetectionEventValidationError{
			field:  "Type",
			reason: "value must be one of the defined enum values",
		}
	}

	if v, ok := interface{}(m.GetTimestamp()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OutlierDetectionEventValidationError{
				field:  "Timestamp",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetSecsSinceLastAction()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OutlierDetectionEventValidationError{
				field:  "SecsSinceLastAction",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetClusterName()) < 1 {
		return OutlierDetectionEventValidationError{
			field:  "ClusterName",
			reason: "value length must be at least 1 bytes",
		}
	}

	if len(m.GetUpstreamUrl()) < 1 {
		return OutlierDetectionEventValidationError{
			field:  "UpstreamUrl",
			reason: "value length must be at least 1 bytes",
		}
	}

	if _, ok := Action_name[int32(m.GetAction())]; !ok {
		return OutlierDetectionEventValidationError{
			field:  "Action",
			reason: "value must be one of the defined enum values",
		}
	}

	// no validation rules for NumEjections

	// no validation rules for Enforced

	switch m.Event.(type) {

	case *OutlierDetectionEvent_EjectSuccessRateEvent:

		if v, ok := interface{}(m.GetEjectSuccessRateEvent()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return OutlierDetectionEventValidationError{
					field:  "EjectSuccessRateEvent",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *OutlierDetectionEvent_EjectConsecutiveEvent:

		if v, ok := interface{}(m.GetEjectConsecutiveEvent()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return OutlierDetectionEventValidationError{
					field:  "EjectConsecutiveEvent",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		return OutlierDetectionEventValidationError{
			field:  "Event",
			reason: "value is required",
		}

	}

	return nil
}

// OutlierDetectionEventValidationError is the validation error returned by
// OutlierDetectionEvent.Validate if the designated constraints aren't met.
type OutlierDetectionEventValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e OutlierDetectionEventValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e OutlierDetectionEventValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e OutlierDetectionEventValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e OutlierDetectionEventValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e OutlierDetectionEventValidationError) ErrorName() string {
	return "OutlierDetectionEventValidationError"
}

// Error satisfies the builtin error interface
func (e OutlierDetectionEventValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOutlierDetectionEvent.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = OutlierDetectionEventValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = OutlierDetectionEventValidationError{}

// Validate checks the field values on OutlierEjectSuccessRate with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *OutlierEjectSuccessRate) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetHostSuccessRate() > 100 {
		return OutlierEjectSuccessRateValidationError{
			field:  "HostSuccessRate",
			reason: "value must be less than or equal to 100",
		}
	}

	if m.GetClusterAverageSuccessRate() > 100 {
		return OutlierEjectSuccessRateValidationError{
			field:  "ClusterAverageSuccessRate",
			reason: "value must be less than or equal to 100",
		}
	}

	if m.GetClusterSuccessRateEjectionThreshold() > 100 {
		return OutlierEjectSuccessRateValidationError{
			field:  "ClusterSuccessRateEjectionThreshold",
			reason: "value must be less than or equal to 100",
		}
	}

	return nil
}

// OutlierEjectSuccessRateValidationError is the validation error returned by
// OutlierEjectSuccessRate.Validate if the designated constraints aren't met.
type OutlierEjectSuccessRateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e OutlierEjectSuccessRateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e OutlierEjectSuccessRateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e OutlierEjectSuccessRateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e OutlierEjectSuccessRateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e OutlierEjectSuccessRateValidationError) ErrorName() string {
	return "OutlierEjectSuccessRateValidationError"
}

// Error satisfies the builtin error interface
func (e OutlierEjectSuccessRateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOutlierEjectSuccessRate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = OutlierEjectSuccessRateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = OutlierEjectSuccessRateValidationError{}

// Validate checks the field values on OutlierEjectConsecutive with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *OutlierEjectConsecutive) Validate() error {
	if m == nil {
		return nil
	}

	return nil
}

// OutlierEjectConsecutiveValidationError is the validation error returned by
// OutlierEjectConsecutive.Validate if the designated constraints aren't met.
type OutlierEjectConsecutiveValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e OutlierEjectConsecutiveValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e OutlierEjectConsecutiveValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e OutlierEjectConsecutiveValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e OutlierEjectConsecutiveValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e OutlierEjectConsecutiveValidationError) ErrorName() string {
	return "OutlierEjectConsecutiveValidationError"
}

// Error satisfies the builtin error interface
func (e OutlierEjectConsecutiveValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOutlierEjectConsecutive.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = OutlierEjectConsecutiveValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = OutlierEjectConsecutiveValidationError{}
