// Code generated by protoc-gen-gogo.
// source: cockroach/pkg/storage/api.proto
// DO NOT EDIT!

/*
	Package storage is a generated protocol buffer package.

	It is generated from these files:
		cockroach/pkg/storage/api.proto
		cockroach/pkg/storage/liveness.proto
		cockroach/pkg/storage/log.proto
		cockroach/pkg/storage/raft.proto

	It has these top-level messages:
		StoreRequestHeader
		CollectChecksumRequest
		CollectChecksumResponse
		Liveness
		RangeLogEvent
		RaftHeartbeat
		RaftMessageRequest
		RaftMessageRequestBatch
		RaftMessageResponseUnion
		RaftMessageResponse
		SnapshotRequest
		SnapshotResponse
		ConfChangeContext
*/
package storage

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_roachpb1 "github.com/cockroachdb/cockroach/pkg/roachpb"

import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"
import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// StoreRequestHeader locates a Store on a Node.
type StoreRequestHeader struct {
	NodeID  github_com_cockroachdb_cockroach_pkg_roachpb.NodeID  `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	StoreID github_com_cockroachdb_cockroach_pkg_roachpb.StoreID `protobuf:"varint,2,opt,name=store_id,json=storeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.StoreID" json:"store_id,omitempty"`
}

func (m *StoreRequestHeader) Reset()                    { *m = StoreRequestHeader{} }
func (m *StoreRequestHeader) String() string            { return proto.CompactTextString(m) }
func (*StoreRequestHeader) ProtoMessage()               {}
func (*StoreRequestHeader) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{0} }

// A CollectChecksumRequest asks the addressed replica for the result of a
// roachpb.ComputeChecksumRequest.
type CollectChecksumRequest struct {
	StoreRequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	RangeID            github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,2,opt,name=range_id,json=rangeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_id,omitempty"`
	// checksum_id identifies the corresponding roachpb.ComputeChecksumRequest.
	ChecksumID github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,3,opt,name=checksum_id,json=checksumId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"checksum_id"`
	Checksum   []byte                                              `protobuf:"bytes,4,opt,name=checksum,proto3" json:"checksum,omitempty"`
}

func (m *CollectChecksumRequest) Reset()                    { *m = CollectChecksumRequest{} }
func (m *CollectChecksumRequest) String() string            { return proto.CompactTextString(m) }
func (*CollectChecksumRequest) ProtoMessage()               {}
func (*CollectChecksumRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{1} }

type CollectChecksumResponse struct {
	Checksum []byte `protobuf:"bytes,1,opt,name=checksum,proto3" json:"checksum,omitempty"`
	// snapshot is set if the roachpb.ComputeChecksumRequest had snapshot = true
	// and the response checksum is different from the request checksum.
	Snapshot *cockroach_roachpb1.RaftSnapshotData `protobuf:"bytes,2,opt,name=snapshot" json:"snapshot,omitempty"`
}

func (m *CollectChecksumResponse) Reset()                    { *m = CollectChecksumResponse{} }
func (m *CollectChecksumResponse) String() string            { return proto.CompactTextString(m) }
func (*CollectChecksumResponse) ProtoMessage()               {}
func (*CollectChecksumResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{2} }

func init() {
	proto.RegisterType((*StoreRequestHeader)(nil), "cockroach.storage.StoreRequestHeader")
	proto.RegisterType((*CollectChecksumRequest)(nil), "cockroach.storage.CollectChecksumRequest")
	proto.RegisterType((*CollectChecksumResponse)(nil), "cockroach.storage.CollectChecksumResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Consistency service

type ConsistencyClient interface {
	CollectChecksum(ctx context.Context, in *CollectChecksumRequest, opts ...grpc.CallOption) (*CollectChecksumResponse, error)
}

type consistencyClient struct {
	cc *grpc.ClientConn
}

func NewConsistencyClient(cc *grpc.ClientConn) ConsistencyClient {
	return &consistencyClient{cc}
}

func (c *consistencyClient) CollectChecksum(ctx context.Context, in *CollectChecksumRequest, opts ...grpc.CallOption) (*CollectChecksumResponse, error) {
	out := new(CollectChecksumResponse)
	err := grpc.Invoke(ctx, "/cockroach.storage.Consistency/CollectChecksum", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Consistency service

type ConsistencyServer interface {
	CollectChecksum(context.Context, *CollectChecksumRequest) (*CollectChecksumResponse, error)
}

func RegisterConsistencyServer(s *grpc.Server, srv ConsistencyServer) {
	s.RegisterService(&_Consistency_serviceDesc, srv)
}

func _Consistency_CollectChecksum_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CollectChecksumRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConsistencyServer).CollectChecksum(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.storage.Consistency/CollectChecksum",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConsistencyServer).CollectChecksum(ctx, req.(*CollectChecksumRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Consistency_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cockroach.storage.Consistency",
	HandlerType: (*ConsistencyServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CollectChecksum",
			Handler:    _Consistency_CollectChecksum_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "cockroach/pkg/storage/api.proto",
}

func (m *StoreRequestHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreRequestHeader) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.NodeID))
	}
	if m.StoreID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.StoreID))
	}
	return i, nil
}

func (m *CollectChecksumRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectChecksumRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.StoreRequestHeader.Size()))
	n1, err := m.StoreRequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if m.RangeID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RangeID))
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ChecksumID.Size()))
	n2, err := m.ChecksumID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if len(m.Checksum) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Checksum)))
		i += copy(dAtA[i:], m.Checksum)
	}
	return i, nil
}

func (m *CollectChecksumResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectChecksumResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Checksum) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Checksum)))
		i += copy(dAtA[i:], m.Checksum)
	}
	if m.Snapshot != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Snapshot.Size()))
		n3, err := m.Snapshot.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}

func encodeFixed64Api(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Api(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintApi(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *StoreRequestHeader) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovApi(uint64(m.NodeID))
	}
	if m.StoreID != 0 {
		n += 1 + sovApi(uint64(m.StoreID))
	}
	return n
}

func (m *CollectChecksumRequest) Size() (n int) {
	var l int
	_ = l
	l = m.StoreRequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.RangeID != 0 {
		n += 1 + sovApi(uint64(m.RangeID))
	}
	l = m.ChecksumID.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Checksum)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *CollectChecksumResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.Checksum)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Snapshot != nil {
		l = m.Snapshot.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func sovApi(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozApi(x uint64) (n int) {
	return sovApi(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *StoreRequestHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreRequestHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreRequestHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (github_com_cockroachdb_cockroach_pkg_roachpb.StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CollectChecksumRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CollectChecksumRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CollectChecksumRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreRequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.StoreRequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChecksumID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ChecksumID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checksum", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Checksum = append(m.Checksum[:0], dAtA[iNdEx:postIndex]...)
			if m.Checksum == nil {
				m.Checksum = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CollectChecksumResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CollectChecksumResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CollectChecksumResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checksum", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Checksum = append(m.Checksum[:0], dAtA[iNdEx:postIndex]...)
			if m.Checksum == nil {
				m.Checksum = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Snapshot", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Snapshot == nil {
				m.Snapshot = &cockroach_roachpb1.RaftSnapshotData{}
			}
			if err := m.Snapshot.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipApi(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowApi
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApi
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApi
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthApi
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowApi
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipApi(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthApi = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowApi   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("cockroach/pkg/storage/api.proto", fileDescriptorApi) }

var fileDescriptorApi = []byte{
	// 476 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x93, 0x41, 0x6f, 0xd3, 0x30,
	0x14, 0xc7, 0xeb, 0x0d, 0x9a, 0xca, 0x45, 0x42, 0x58, 0x08, 0xa6, 0x1e, 0x92, 0x51, 0x40, 0xda,
	0x38, 0x24, 0x52, 0xc7, 0x1d, 0xd1, 0x56, 0x82, 0x5c, 0x38, 0x78, 0xda, 0x65, 0x07, 0x26, 0x37,
	0xf6, 0x92, 0xac, 0x6d, 0x1c, 0x6c, 0x07, 0x69, 0xdf, 0x82, 0x8f, 0x55, 0x6e, 0x3d, 0x22, 0x0e,
	0x11, 0x84, 0x6f, 0xc1, 0x09, 0xd9, 0x71, 0x03, 0xa5, 0x39, 0x14, 0x6e, 0xcf, 0xce, 0xfb, 0xff,
	0xdf, 0xfb, 0xfd, 0xad, 0x40, 0x2f, 0xe2, 0xd1, 0x5c, 0x70, 0x12, 0x25, 0x41, 0x3e, 0x8f, 0x03,
	0xa9, 0xb8, 0x20, 0x31, 0x0b, 0x48, 0x9e, 0xfa, 0xb9, 0xe0, 0x8a, 0xa3, 0x07, 0x4d, 0x83, 0x6f,
	0x3f, 0x0e, 0x4e, 0xb7, 0x35, 0xa6, 0xca, 0x67, 0x41, 0x9a, 0x29, 0x26, 0x32, 0xb2, 0xb8, 0x12,
	0xe4, 0x5a, 0xd5, 0xea, 0xc1, 0xb3, 0xf6, 0xd6, 0x25, 0x53, 0x84, 0x12, 0x45, 0x6c, 0xd7, 0xc3,
	0x98, 0xc7, 0xdc, 0x94, 0x81, 0xae, 0xea, 0xdb, 0xe1, 0x1a, 0x40, 0x74, 0xae, 0xb8, 0x60, 0x98,
	0x7d, 0x28, 0x98, 0x54, 0x6f, 0x19, 0xa1, 0x4c, 0xa0, 0x4b, 0xe8, 0x64, 0x9c, 0xb2, 0xab, 0x94,
	0x1e, 0x81, 0x63, 0x70, 0x72, 0x77, 0xfc, 0xba, 0x2a, 0xbd, 0xee, 0x3b, 0x4e, 0x59, 0x38, 0xfd,
	0x59, 0x7a, 0x67, 0x71, 0xaa, 0x92, 0x62, 0xe6, 0x47, 0x7c, 0x19, 0x34, 0xc3, 0xe9, 0x2c, 0x68,
	0x5d, 0xc4, 0xaf, 0x65, 0xb8, 0xab, 0x1d, 0x43, 0x8a, 0xde, 0xc3, 0x9e, 0x86, 0x34, 0xe6, 0x07,
	0xc6, 0x7c, 0x52, 0x95, 0x9e, 0x63, 0xb6, 0x30, 0xee, 0x2f, 0xff, 0xc9, 0xdd, 0xea, 0xb0, 0x63,
	0x4c, 0x43, 0x3a, 0xfc, 0x7c, 0x00, 0x1f, 0x4d, 0xf8, 0x62, 0xc1, 0x22, 0x35, 0x49, 0x58, 0x34,
	0x97, 0xc5, 0xd2, 0xc2, 0xa1, 0x37, 0xb0, 0x9b, 0x18, 0x40, 0x43, 0xd5, 0x1f, 0x3d, 0xf7, 0x77,
	0x82, 0xf7, 0x77, 0xd3, 0x18, 0xf7, 0x56, 0xa5, 0xd7, 0x59, 0x97, 0x1e, 0xc0, 0x56, 0xae, 0x19,
	0x04, 0xc9, 0xe2, 0x86, 0xe1, 0xb0, 0x66, 0xc0, 0xfa, 0xee, 0x3f, 0x18, 0xac, 0x0e, 0x3b, 0xc6,
	0x34, 0xa4, 0xe8, 0x06, 0xf6, 0x23, 0xbb, 0xbb, 0x1e, 0x71, 0x78, 0x0c, 0x4e, 0xee, 0x8d, 0x43,
	0xbd, 0xc6, 0xd7, 0x7d, 0xd3, 0x2f, 0x54, 0xba, 0x08, 0x8a, 0x22, 0xa5, 0xfe, 0xc5, 0x45, 0x38,
	0xad, 0x4a, 0x0f, 0x6e, 0xd2, 0x08, 0xa7, 0x18, 0x6e, 0xdc, 0x43, 0x8a, 0x06, 0xb0, 0xb7, 0x39,
	0x1d, 0xdd, 0xd1, 0x83, 0x70, 0x73, 0x1e, 0x7e, 0x84, 0x8f, 0x77, 0xa2, 0x94, 0x39, 0xcf, 0x24,
	0xdb, 0x92, 0x81, 0x6d, 0x19, 0x7a, 0x05, 0x7b, 0x32, 0x23, 0xb9, 0x4c, 0xb8, 0x32, 0xf1, 0xf4,
	0x47, 0x4f, 0xff, 0x48, 0xfa, 0x37, 0xf5, 0xb5, 0x3a, 0xb7, 0x6d, 0x53, 0xa2, 0x08, 0x6e, 0x44,
	0xa3, 0x5b, 0xd8, 0x9f, 0xf0, 0x4c, 0xa6, 0x52, 0xb1, 0x2c, 0xba, 0x45, 0x37, 0xf0, 0xfe, 0x5f,
	0x6b, 0xa0, 0xd3, 0x96, 0xa7, 0x6b, 0x7f, 0xf5, 0xc1, 0x8b, 0x7d, 0x5a, 0x6b, 0xaa, 0x61, 0x67,
	0xfc, 0x64, 0xf5, 0xdd, 0xed, 0xac, 0x2a, 0x17, 0xac, 0x2b, 0x17, 0x7c, 0xa9, 0x5c, 0xf0, 0xad,
	0x72, 0xc1, 0xa7, 0x1f, 0x6e, 0xe7, 0xd2, 0xb1, 0xe2, 0x59, 0xd7, 0xfc, 0x3b, 0x67, 0xbf, 0x02,
	0x00, 0x00, 0xff, 0xff, 0xc1, 0xfa, 0x14, 0xf4, 0xd8, 0x03, 0x00, 0x00,
}
