// Code generated by goyacc.
// GENERATED FILE DO NOT EDIT
//line sql.y:20
package parser

import __yyfmt__ "fmt"

//line sql.y:20
import (
	"fmt"

	"go/constant"
	"go/token"

	"github.com/cockroachdb/cockroach/pkg/sql/privilege"
)

// MaxUint is the maximum value of an uint.
const MaxUint = ^uint(0)

// MaxInt is the maximum value of an int.
const MaxInt = int(MaxUint >> 1)

func unimplemented(sqllex sqlLexer, feature string) int {
	sqllex.(*Scanner).Unimplemented(feature)
	return 1
}

func unimplementedWithIssue(sqllex sqlLexer, issue int) int {
	sqllex.(*Scanner).UnimplementedWithIssue(issue)
	return 1
}

//line sql.y:48

// sqlSymUnion represents a union of types, providing accessor methods
// to retrieve the underlying type stored in the union's empty interface.
// The purpose of the sqlSymUnion struct is to reduce the memory footprint of
// the sqlSymType because only one value (of a variety of types) is ever needed
// to be stored in the union field at a time.
//
// By using an empty interface, we lose the type checking previously provided
// by yacc and the Go compiler when dealing with union values. Instead, runtime
// type assertions must be relied upon in the methods below, and as such, the
// parser should be thoroughly tested whenever new syntax is added.
//
// It is important to note that when assigning values to sqlSymUnion.val, all
// nil values should be typed so that they are stored as nil instances in the
// empty interface, instead of setting the empty interface to nil. This means
// that:
//     $$ = []String(nil)
// should be used, instead of:
//     $$ = nil
// to assign a nil string slice to the union.
type sqlSymUnion struct {
	val interface{}
}

// The following accessor methods come in three forms, depending on the
// type of the value being accessed and whether a nil value is admissible
// for the corresponding grammar rule.
// - Values and pointers are directly type asserted from the empty
//   interface, regardless of whether a nil value is admissible or
//   not. A panic occurs if the type assertion is incorrect; no panic occurs
//   if a nil is not expected but present. (TODO(knz): split this category of
//   accessor in two; with one checking for unexpected nils.)
//   Examples: bool(), tableWithIdx().
//
// - Interfaces where a nil is admissible are handled differently
//   because a nil instance of an interface inserted into the empty interface
//   becomes a nil instance of the empty interface and therefore will fail a
//   direct type assertion. Instead, a guarded type assertion must be used,
//   which returns nil if the type assertion fails.
//   Examples: expr(), stmt().
//
// - Interfaces where a nil is not admissible are implemented as a direct
//   type assertion, which causes a panic to occur if an unexpected nil
//   is encountered.
//   Examples: namePart(), tblDef().
//
func (u *sqlSymUnion) numVal() *NumVal {
	return u.val.(*NumVal)
}
func (u *sqlSymUnion) strVal() *StrVal {
	if stmt, ok := u.val.(*StrVal); ok {
		return stmt
	}
	return nil
}
func (u *sqlSymUnion) bool() bool {
	return u.val.(bool)
}
func (u *sqlSymUnion) strPtr() *string {
	return u.val.(*string)
}
func (u *sqlSymUnion) strs() []string {
	return u.val.([]string)
}
func (u *sqlSymUnion) tableWithIdx() *TableNameWithIndex {
	return u.val.(*TableNameWithIndex)
}
func (u *sqlSymUnion) tableWithIdxList() TableNameWithIndexList {
	return u.val.(TableNameWithIndexList)
}
func (u *sqlSymUnion) namePart() NamePart {
	return u.val.(NamePart)
}
func (u *sqlSymUnion) nameList() NameList {
	return u.val.(NameList)
}
func (u *sqlSymUnion) unresolvedName() UnresolvedName {
	return u.val.(UnresolvedName)
}
func (u *sqlSymUnion) unresolvedNames() UnresolvedNames {
	return u.val.(UnresolvedNames)
}
func (u *sqlSymUnion) functionReference() FunctionReference {
	return u.val.(FunctionReference)
}
func (u *sqlSymUnion) resolvableFunctionReference() ResolvableFunctionReference {
	return ResolvableFunctionReference{u.val.(FunctionReference)}
}
func (u *sqlSymUnion) normalizableTableName() NormalizableTableName {
	return NormalizableTableName{u.val.(TableNameReference)}
}
func (u *sqlSymUnion) newNormalizableTableName() *NormalizableTableName {
	return &NormalizableTableName{u.val.(TableNameReference)}
}
func (u *sqlSymUnion) tablePatterns() TablePatterns {
	return u.val.(TablePatterns)
}
func (u *sqlSymUnion) tableNameReferences() TableNameReferences {
	return u.val.(TableNameReferences)
}
func (u *sqlSymUnion) indexHints() *IndexHints {
	return u.val.(*IndexHints)
}
func (u *sqlSymUnion) arraySubscript() *ArraySubscript {
	return u.val.(*ArraySubscript)
}
func (u *sqlSymUnion) arraySubscripts() ArraySubscripts {
	if as, ok := u.val.(ArraySubscripts); ok {
		return as
	}
	return nil
}
func (u *sqlSymUnion) stmt() Statement {
	if stmt, ok := u.val.(Statement); ok {
		return stmt
	}
	return nil
}
func (u *sqlSymUnion) stmts() []Statement {
	return u.val.([]Statement)
}
func (u *sqlSymUnion) slct() *Select {
	return u.val.(*Select)
}
func (u *sqlSymUnion) selectStmt() SelectStatement {
	return u.val.(SelectStatement)
}
func (u *sqlSymUnion) colDef() *ColumnTableDef {
	return u.val.(*ColumnTableDef)
}
func (u *sqlSymUnion) constraintDef() ConstraintTableDef {
	return u.val.(ConstraintTableDef)
}
func (u *sqlSymUnion) tblDef() TableDef {
	return u.val.(TableDef)
}
func (u *sqlSymUnion) tblDefs() TableDefs {
	return u.val.(TableDefs)
}
func (u *sqlSymUnion) colQual() NamedColumnQualification {
	return u.val.(NamedColumnQualification)
}
func (u *sqlSymUnion) colQualElem() ColumnQualification {
	return u.val.(ColumnQualification)
}
func (u *sqlSymUnion) colQuals() []NamedColumnQualification {
	return u.val.([]NamedColumnQualification)
}
func (u *sqlSymUnion) colType() ColumnType {
	if colType, ok := u.val.(ColumnType); ok {
		return colType
	}
	return nil
}
func (u *sqlSymUnion) tableRefCols() []ColumnID {
	if refCols, ok := u.val.([]ColumnID); ok {
		return refCols
	}
	return nil
}
func (u *sqlSymUnion) castTargetType() CastTargetType {
	return u.val.(CastTargetType)
}
func (u *sqlSymUnion) colTypes() []ColumnType {
	return u.val.([]ColumnType)
}
func (u *sqlSymUnion) expr() Expr {
	if expr, ok := u.val.(Expr); ok {
		return expr
	}
	return nil
}
func (u *sqlSymUnion) exprs() Exprs {
	return u.val.(Exprs)
}
func (u *sqlSymUnion) selExpr() SelectExpr {
	return u.val.(SelectExpr)
}
func (u *sqlSymUnion) selExprs() SelectExprs {
	return u.val.(SelectExprs)
}
func (u *sqlSymUnion) retClause() ReturningClause {
	return u.val.(ReturningClause)
}
func (u *sqlSymUnion) aliasClause() AliasClause {
	return u.val.(AliasClause)
}
func (u *sqlSymUnion) asOfClause() AsOfClause {
	return u.val.(AsOfClause)
}
func (u *sqlSymUnion) tblExpr() TableExpr {
	return u.val.(TableExpr)
}
func (u *sqlSymUnion) tblExprs() TableExprs {
	return u.val.(TableExprs)
}
func (u *sqlSymUnion) from() *From {
	return u.val.(*From)
}
func (u *sqlSymUnion) joinCond() JoinCond {
	return u.val.(JoinCond)
}
func (u *sqlSymUnion) when() *When {
	return u.val.(*When)
}
func (u *sqlSymUnion) whens() []*When {
	return u.val.([]*When)
}
func (u *sqlSymUnion) updateExpr() *UpdateExpr {
	return u.val.(*UpdateExpr)
}
func (u *sqlSymUnion) updateExprs() UpdateExprs {
	return u.val.(UpdateExprs)
}
func (u *sqlSymUnion) limit() *Limit {
	return u.val.(*Limit)
}
func (u *sqlSymUnion) targetList() TargetList {
	return u.val.(TargetList)
}
func (u *sqlSymUnion) targetListPtr() *TargetList {
	return u.val.(*TargetList)
}
func (u *sqlSymUnion) privilegeType() privilege.Kind {
	return u.val.(privilege.Kind)
}
func (u *sqlSymUnion) privilegeList() privilege.List {
	return u.val.(privilege.List)
}
func (u *sqlSymUnion) onConflict() *OnConflict {
	return u.val.(*OnConflict)
}
func (u *sqlSymUnion) orderBy() OrderBy {
	return u.val.(OrderBy)
}
func (u *sqlSymUnion) order() *Order {
	return u.val.(*Order)
}
func (u *sqlSymUnion) orders() []*Order {
	return u.val.([]*Order)
}
func (u *sqlSymUnion) groupBy() GroupBy {
	return u.val.(GroupBy)
}
func (u *sqlSymUnion) dir() Direction {
	return u.val.(Direction)
}
func (u *sqlSymUnion) alterTableCmd() AlterTableCmd {
	return u.val.(AlterTableCmd)
}
func (u *sqlSymUnion) alterTableCmds() AlterTableCmds {
	return u.val.(AlterTableCmds)
}
func (u *sqlSymUnion) isoLevel() IsolationLevel {
	return u.val.(IsolationLevel)
}
func (u *sqlSymUnion) userPriority() UserPriority {
	return u.val.(UserPriority)
}
func (u *sqlSymUnion) readWriteMode() ReadWriteMode {
	return u.val.(ReadWriteMode)
}
func (u *sqlSymUnion) idxElem() IndexElem {
	return u.val.(IndexElem)
}
func (u *sqlSymUnion) idxElems() IndexElemList {
	return u.val.(IndexElemList)
}
func (u *sqlSymUnion) dropBehavior() DropBehavior {
	return u.val.(DropBehavior)
}
func (u *sqlSymUnion) validationBehavior() ValidationBehavior {
	return u.val.(ValidationBehavior)
}
func (u *sqlSymUnion) interleave() *InterleaveDef {
	return u.val.(*InterleaveDef)
}
func (u *sqlSymUnion) windowDef() *WindowDef {
	return u.val.(*WindowDef)
}
func (u *sqlSymUnion) window() Window {
	return u.val.(Window)
}
func (u *sqlSymUnion) op() operator {
	return u.val.(operator)
}
func (u *sqlSymUnion) cmpOp() ComparisonOperator {
	return u.val.(ComparisonOperator)
}
func (u *sqlSymUnion) durationField() durationField {
	return u.val.(durationField)
}
func (u *sqlSymUnion) kvOption() KVOption {
	return u.val.(KVOption)
}
func (u *sqlSymUnion) kvOptions() []KVOption {
	if colType, ok := u.val.([]KVOption); ok {
		return colType
	}
	return nil
}
func (u *sqlSymUnion) transactionModes() TransactionModes {
	return u.val.(TransactionModes)
}

//line sql.y:466
type sqlSymType struct {
	yys   int
	id    int
	pos   int
	empty struct{}
	str   string
	union sqlSymUnion
}

const IDENT = 57346
const SCONST = 57347
const BCONST = 57348
const ICONST = 57349
const FCONST = 57350
const PLACEHOLDER = 57351
const TYPECAST = 57352
const TYPEANNOTATE = 57353
const DOT_DOT = 57354
const LESS_EQUALS = 57355
const GREATER_EQUALS = 57356
const NOT_EQUALS = 57357
const NOT_REGMATCH = 57358
const REGIMATCH = 57359
const NOT_REGIMATCH = 57360
const ERROR = 57361
const ACTION = 57362
const ADD = 57363
const ALL = 57364
const ALTER = 57365
const ANALYSE = 57366
const ANALYZE = 57367
const AND = 57368
const ANY = 57369
const ANNOTATE_TYPE = 57370
const ARRAY = 57371
const AS = 57372
const ASC = 57373
const ASYMMETRIC = 57374
const AT = 57375
const BACKUP = 57376
const BEGIN = 57377
const BETWEEN = 57378
const BIGINT = 57379
const BIGSERIAL = 57380
const BIT = 57381
const BLOB = 57382
const BOOL = 57383
const BOOLEAN = 57384
const BOTH = 57385
const BY = 57386
const BYTEA = 57387
const BYTES = 57388
const CASCADE = 57389
const CASE = 57390
const CAST = 57391
const CHAR = 57392
const CHARACTER = 57393
const CHARACTERISTICS = 57394
const CHECK = 57395
const CLUSTER = 57396
const COALESCE = 57397
const COLLATE = 57398
const COLLATION = 57399
const COLUMN = 57400
const COLUMNS = 57401
const COMMIT = 57402
const COMMITTED = 57403
const CONCAT = 57404
const CONFLICT = 57405
const CONSTRAINT = 57406
const CONSTRAINTS = 57407
const COPY = 57408
const COVERING = 57409
const CREATE = 57410
const CROSS = 57411
const CUBE = 57412
const CURRENT = 57413
const CURRENT_CATALOG = 57414
const CURRENT_DATE = 57415
const CURRENT_ROLE = 57416
const CURRENT_TIME = 57417
const CURRENT_TIMESTAMP = 57418
const CURRENT_USER = 57419
const CYCLE = 57420
const DATA = 57421
const DATABASE = 57422
const DATABASES = 57423
const DATE = 57424
const DAY = 57425
const DEC = 57426
const DECIMAL = 57427
const DEFAULT = 57428
const DEALLOCATE = 57429
const DEFERRABLE = 57430
const DELETE = 57431
const DESC = 57432
const DISTINCT = 57433
const DO = 57434
const DOUBLE = 57435
const DROP = 57436
const ELSE = 57437
const ENCODING = 57438
const END = 57439
const ESCAPE = 57440
const EXCEPT = 57441
const EXISTS = 57442
const EXECUTE = 57443
const EXPERIMENTAL_FINGERPRINTS = 57444
const EXPLAIN = 57445
const EXTRACT = 57446
const EXTRACT_DURATION = 57447
const FALSE = 57448
const FAMILY = 57449
const FETCH = 57450
const FILTER = 57451
const FIRST = 57452
const FLOAT = 57453
const FLOORDIV = 57454
const FOLLOWING = 57455
const FOR = 57456
const FORCE_INDEX = 57457
const FOREIGN = 57458
const FROM = 57459
const FULL = 57460
const GRANT = 57461
const GRANTS = 57462
const GREATEST = 57463
const GROUP = 57464
const GROUPING = 57465
const HAVING = 57466
const HELP = 57467
const HIGH = 57468
const HOUR = 57469
const INCREMENTAL = 57470
const IF = 57471
const IFNULL = 57472
const ILIKE = 57473
const IN = 57474
const INTERLEAVE = 57475
const INDEX = 57476
const INDEXES = 57477
const INITIALLY = 57478
const INNER = 57479
const INSERT = 57480
const INT = 57481
const INT2VECTOR = 57482
const INT8 = 57483
const INT64 = 57484
const INTEGER = 57485
const INTERSECT = 57486
const INTERVAL = 57487
const INTO = 57488
const IS = 57489
const ISOLATION = 57490
const JOIN = 57491
const KEY = 57492
const KEYS = 57493
const LATERAL = 57494
const LC_CTYPE = 57495
const LC_COLLATE = 57496
const LEADING = 57497
const LEAST = 57498
const LEFT = 57499
const LEVEL = 57500
const LIKE = 57501
const LIMIT = 57502
const LOCAL = 57503
const LOCALTIME = 57504
const LOCALTIMESTAMP = 57505
const LOW = 57506
const LSHIFT = 57507
const MATCH = 57508
const MINUTE = 57509
const MONTH = 57510
const NAN = 57511
const NAME = 57512
const NAMES = 57513
const NATURAL = 57514
const NEXT = 57515
const NO = 57516
const NO_INDEX_JOIN = 57517
const NORMAL = 57518
const NOT = 57519
const NOTHING = 57520
const NULL = 57521
const NULLIF = 57522
const NULLS = 57523
const NUMERIC = 57524
const OF = 57525
const OFF = 57526
const OFFSET = 57527
const OID = 57528
const ON = 57529
const ONLY = 57530
const OPTIONS = 57531
const OR = 57532
const ORDER = 57533
const ORDINALITY = 57534
const OUT = 57535
const OUTER = 57536
const OVER = 57537
const OVERLAPS = 57538
const OVERLAY = 57539
const PARENT = 57540
const PARTIAL = 57541
const PARTITION = 57542
const PASSWORD = 57543
const PLACING = 57544
const POSITION = 57545
const PRECEDING = 57546
const PRECISION = 57547
const PREPARE = 57548
const PRIMARY = 57549
const PRIORITY = 57550
const QUERIES = 57551
const RANGE = 57552
const READ = 57553
const REAL = 57554
const RECURSIVE = 57555
const REF = 57556
const REFERENCES = 57557
const REGCLASS = 57558
const REGPROC = 57559
const REGPROCEDURE = 57560
const REGNAMESPACE = 57561
const REGTYPE = 57562
const RENAME = 57563
const REPEATABLE = 57564
const RELEASE = 57565
const RESET = 57566
const RESTORE = 57567
const RESTRICT = 57568
const RETURNING = 57569
const REVOKE = 57570
const RIGHT = 57571
const ROLLBACK = 57572
const ROLLUP = 57573
const ROW = 57574
const ROWS = 57575
const RSHIFT = 57576
const SAVEPOINT = 57577
const SCATTER = 57578
const SEARCH = 57579
const SECOND = 57580
const SELECT = 57581
const SERIAL = 57582
const SERIALIZABLE = 57583
const SESSION = 57584
const SESSIONS = 57585
const SESSION_USER = 57586
const SET = 57587
const SETTING = 57588
const SETTINGS = 57589
const SHOW = 57590
const SIMILAR = 57591
const SIMPLE = 57592
const SMALLINT = 57593
const SMALLSERIAL = 57594
const SNAPSHOT = 57595
const SOME = 57596
const SPLIT = 57597
const SQL = 57598
const START = 57599
const STATUS = 57600
const STDIN = 57601
const STRICT = 57602
const STRING = 57603
const STORING = 57604
const SUBSTRING = 57605
const SYMMETRIC = 57606
const SYSTEM = 57607
const TABLE = 57608
const TABLES = 57609
const TEMPLATE = 57610
const TESTING_RANGES = 57611
const TESTING_RELOCATE = 57612
const TEXT = 57613
const THEN = 57614
const TIME = 57615
const TIMESTAMP = 57616
const TIMESTAMPTZ = 57617
const TO = 57618
const TRAILING = 57619
const TRANSACTION = 57620
const TREAT = 57621
const TRIM = 57622
const TRUE = 57623
const TRUNCATE = 57624
const TYPE = 57625
const UNBOUNDED = 57626
const UNCOMMITTED = 57627
const UNION = 57628
const UNIQUE = 57629
const UNKNOWN = 57630
const UPDATE = 57631
const UPSERT = 57632
const USE = 57633
const USER = 57634
const USERS = 57635
const USING = 57636
const UUID = 57637
const VALID = 57638
const VALIDATE = 57639
const VALUE = 57640
const VALUES = 57641
const VARCHAR = 57642
const VARIADIC = 57643
const VIEW = 57644
const VARYING = 57645
const WHEN = 57646
const WHERE = 57647
const WINDOW = 57648
const WITH = 57649
const WITHIN = 57650
const WITHOUT = 57651
const WRITE = 57652
const YEAR = 57653
const ZONE = 57654
const NOT_LA = 57655
const WITH_LA = 57656
const AS_LA = 57657
const POSTFIXOP = 57658
const UMINUS = 57659

var sqlToknames = [...]string{
	"$end",
	"error",
	"$unk",
	"IDENT",
	"SCONST",
	"BCONST",
	"ICONST",
	"FCONST",
	"PLACEHOLDER",
	"TYPECAST",
	"TYPEANNOTATE",
	"DOT_DOT",
	"LESS_EQUALS",
	"GREATER_EQUALS",
	"NOT_EQUALS",
	"NOT_REGMATCH",
	"REGIMATCH",
	"NOT_REGIMATCH",
	"ERROR",
	"ACTION",
	"ADD",
	"ALL",
	"ALTER",
	"ANALYSE",
	"ANALYZE",
	"AND",
	"ANY",
	"ANNOTATE_TYPE",
	"ARRAY",
	"AS",
	"ASC",
	"ASYMMETRIC",
	"AT",
	"BACKUP",
	"BEGIN",
	"BETWEEN",
	"BIGINT",
	"BIGSERIAL",
	"BIT",
	"BLOB",
	"BOOL",
	"BOOLEAN",
	"BOTH",
	"BY",
	"BYTEA",
	"BYTES",
	"CASCADE",
	"CASE",
	"CAST",
	"CHAR",
	"CHARACTER",
	"CHARACTERISTICS",
	"CHECK",
	"CLUSTER",
	"COALESCE",
	"COLLATE",
	"COLLATION",
	"COLUMN",
	"COLUMNS",
	"COMMIT",
	"COMMITTED",
	"CONCAT",
	"CONFLICT",
	"CONSTRAINT",
	"CONSTRAINTS",
	"COPY",
	"COVERING",
	"CREATE",
	"CROSS",
	"CUBE",
	"CURRENT",
	"CURRENT_CATALOG",
	"CURRENT_DATE",
	"CURRENT_ROLE",
	"CURRENT_TIME",
	"CURRENT_TIMESTAMP",
	"CURRENT_USER",
	"CYCLE",
	"DATA",
	"DATABASE",
	"DATABASES",
	"DATE",
	"DAY",
	"DEC",
	"DECIMAL",
	"DEFAULT",
	"DEALLOCATE",
	"DEFERRABLE",
	"DELETE",
	"DESC",
	"DISTINCT",
	"DO",
	"DOUBLE",
	"DROP",
	"ELSE",
	"ENCODING",
	"END",
	"ESCAPE",
	"EXCEPT",
	"EXISTS",
	"EXECUTE",
	"EXPERIMENTAL_FINGERPRINTS",
	"EXPLAIN",
	"EXTRACT",
	"EXTRACT_DURATION",
	"FALSE",
	"FAMILY",
	"FETCH",
	"FILTER",
	"FIRST",
	"FLOAT",
	"FLOORDIV",
	"FOLLOWING",
	"FOR",
	"FORCE_INDEX",
	"FOREIGN",
	"FROM",
	"FULL",
	"GRANT",
	"GRANTS",
	"GREATEST",
	"GROUP",
	"GROUPING",
	"HAVING",
	"HELP",
	"HIGH",
	"HOUR",
	"INCREMENTAL",
	"IF",
	"IFNULL",
	"ILIKE",
	"IN",
	"INTERLEAVE",
	"INDEX",
	"INDEXES",
	"INITIALLY",
	"INNER",
	"INSERT",
	"INT",
	"INT2VECTOR",
	"INT8",
	"INT64",
	"INTEGER",
	"INTERSECT",
	"INTERVAL",
	"INTO",
	"IS",
	"ISOLATION",
	"JOIN",
	"KEY",
	"KEYS",
	"LATERAL",
	"LC_CTYPE",
	"LC_COLLATE",
	"LEADING",
	"LEAST",
	"LEFT",
	"LEVEL",
	"LIKE",
	"LIMIT",
	"LOCAL",
	"LOCALTIME",
	"LOCALTIMESTAMP",
	"LOW",
	"LSHIFT",
	"MATCH",
	"MINUTE",
	"MONTH",
	"NAN",
	"NAME",
	"NAMES",
	"NATURAL",
	"NEXT",
	"NO",
	"NO_INDEX_JOIN",
	"NORMAL",
	"NOT",
	"NOTHING",
	"NULL",
	"NULLIF",
	"NULLS",
	"NUMERIC",
	"OF",
	"OFF",
	"OFFSET",
	"OID",
	"ON",
	"ONLY",
	"OPTIONS",
	"OR",
	"ORDER",
	"ORDINALITY",
	"OUT",
	"OUTER",
	"OVER",
	"OVERLAPS",
	"OVERLAY",
	"PARENT",
	"PARTIAL",
	"PARTITION",
	"PASSWORD",
	"PLACING",
	"POSITION",
	"PRECEDING",
	"PRECISION",
	"PREPARE",
	"PRIMARY",
	"PRIORITY",
	"QUERIES",
	"RANGE",
	"READ",
	"REAL",
	"RECURSIVE",
	"REF",
	"REFERENCES",
	"REGCLASS",
	"REGPROC",
	"REGPROCEDURE",
	"REGNAMESPACE",
	"REGTYPE",
	"RENAME",
	"REPEATABLE",
	"RELEASE",
	"RESET",
	"RESTORE",
	"RESTRICT",
	"RETURNING",
	"REVOKE",
	"RIGHT",
	"ROLLBACK",
	"ROLLUP",
	"ROW",
	"ROWS",
	"RSHIFT",
	"SAVEPOINT",
	"SCATTER",
	"SEARCH",
	"SECOND",
	"SELECT",
	"SERIAL",
	"SERIALIZABLE",
	"SESSION",
	"SESSIONS",
	"SESSION_USER",
	"SET",
	"SETTING",
	"SETTINGS",
	"SHOW",
	"SIMILAR",
	"SIMPLE",
	"SMALLINT",
	"SMALLSERIAL",
	"SNAPSHOT",
	"SOME",
	"SPLIT",
	"SQL",
	"START",
	"STATUS",
	"STDIN",
	"STRICT",
	"STRING",
	"STORING",
	"SUBSTRING",
	"SYMMETRIC",
	"SYSTEM",
	"TABLE",
	"TABLES",
	"TEMPLATE",
	"TESTING_RANGES",
	"TESTING_RELOCATE",
	"TEXT",
	"THEN",
	"TIME",
	"TIMESTAMP",
	"TIMESTAMPTZ",
	"TO",
	"TRAILING",
	"TRANSACTION",
	"TREAT",
	"TRIM",
	"TRUE",
	"TRUNCATE",
	"TYPE",
	"UNBOUNDED",
	"UNCOMMITTED",
	"UNION",
	"UNIQUE",
	"UNKNOWN",
	"UPDATE",
	"UPSERT",
	"USE",
	"USER",
	"USERS",
	"USING",
	"UUID",
	"VALID",
	"VALIDATE",
	"VALUE",
	"VALUES",
	"VARCHAR",
	"VARIADIC",
	"VIEW",
	"VARYING",
	"WHEN",
	"WHERE",
	"WINDOW",
	"WITH",
	"WITHIN",
	"WITHOUT",
	"WRITE",
	"YEAR",
	"ZONE",
	"NOT_LA",
	"WITH_LA",
	"AS_LA",
	"'<'",
	"'>'",
	"'='",
	"'~'",
	"POSTFIXOP",
	"'|'",
	"'#'",
	"'&'",
	"'+'",
	"'-'",
	"'*'",
	"'/'",
	"'%'",
	"'^'",
	"UMINUS",
	"'['",
	"']'",
	"'('",
	"')'",
	"'.'",
	"';'",
	"','",
	"'@'",
	"'{'",
	"'}'",
	"':'",
}
var sqlStatenames = [...]string{}

const sqlEofCode = 1
const sqlErrCode = 2
const sqlInitialStackSize = 16

//line sql.y:5585

//line yacctab:1
var sqlExca = [...]int{
	-1, 0,
	1, 32,
	336, 32,
	-2, 445,
	-1, 1,
	1, -1,
	-2, 0,
	-1, 53,
	1, 418,
	187, 418,
	227, 418,
	332, 418,
	334, 418,
	336, 418,
	-2, 428,
	-1, 68,
	1, 421,
	187, 421,
	227, 421,
	332, 421,
	334, 421,
	336, 421,
	-2, 427,
	-1, 77,
	1, 32,
	336, 32,
	-2, 445,
	-1, 445,
	1, 177,
	336, 177,
	-2, 1020,
	-1, 512,
	108, 455,
	160, 455,
	185, 455,
	-2, 424,
	-1, 515,
	108, 454,
	160, 454,
	185, 454,
	-2, 422,
	-1, 660,
	108, 454,
	160, 454,
	185, 454,
	-2, 425,
	-1, 720,
	333, 952,
	-2, 945,
	-1, 721,
	333, 953,
	-2, 946,
	-1, 727,
	5, 621,
	333, 621,
	-2, 1133,
	-1, 751,
	5, 582,
	-2, 1107,
	-1, 752,
	5, 615,
	333, 615,
	-2, 1109,
	-1, 753,
	5, 590,
	-2, 1110,
	-1, 754,
	5, 589,
	-2, 1111,
	-1, 755,
	5, 615,
	333, 615,
	-2, 1114,
	-1, 756,
	5, 615,
	333, 615,
	-2, 1115,
	-1, 757,
	5, 616,
	-2, 1118,
	-1, 758,
	5, 576,
	-2, 1119,
	-1, 759,
	5, 576,
	-2, 1120,
	-1, 760,
	5, 597,
	-2, 1124,
	-1, 761,
	5, 577,
	-2, 1129,
	-1, 762,
	5, 578,
	-2, 1130,
	-1, 763,
	5, 579,
	-2, 1131,
	-1, 764,
	5, 580,
	-2, 1132,
	-1, 765,
	5, 576,
	-2, 1137,
	-1, 766,
	5, 583,
	-2, 1142,
	-1, 767,
	5, 581,
	-2, 1145,
	-1, 768,
	5, 613,
	333, 613,
	-2, 1147,
	-1, 769,
	5, 617,
	-2, 1150,
	-1, 770,
	5, 619,
	-2, 1151,
	-1, 771,
	5, 612,
	333, 612,
	-2, 1156,
	-1, 1030,
	99, 428,
	108, 428,
	144, 428,
	160, 428,
	185, 428,
	191, 428,
	286, 428,
	-2, 740,
	-1, 1039,
	333, 929,
	-2, 917,
	-1, 1252,
	13, 0,
	14, 0,
	15, 0,
	316, 0,
	317, 0,
	318, 0,
	-2, 656,
	-1, 1253,
	13, 0,
	14, 0,
	15, 0,
	316, 0,
	317, 0,
	318, 0,
	-2, 657,
	-1, 1254,
	13, 0,
	14, 0,
	15, 0,
	316, 0,
	317, 0,
	318, 0,
	-2, 658,
	-1, 1258,
	13, 0,
	14, 0,
	15, 0,
	316, 0,
	317, 0,
	318, 0,
	-2, 662,
	-1, 1259,
	13, 0,
	14, 0,
	15, 0,
	316, 0,
	317, 0,
	318, 0,
	-2, 663,
	-1, 1260,
	13, 0,
	14, 0,
	15, 0,
	316, 0,
	317, 0,
	318, 0,
	-2, 664,
	-1, 1263,
	16, 0,
	17, 0,
	18, 0,
	36, 0,
	131, 0,
	132, 0,
	159, 0,
	249, 0,
	313, 0,
	319, 0,
	-2, 669,
	-1, 1269,
	16, 0,
	17, 0,
	18, 0,
	36, 0,
	131, 0,
	132, 0,
	159, 0,
	249, 0,
	313, 0,
	319, 0,
	-2, 671,
	-1, 1271,
	16, 0,
	17, 0,
	18, 0,
	36, 0,
	131, 0,
	132, 0,
	159, 0,
	249, 0,
	313, 0,
	319, 0,
	-2, 675,
	-1, 1272,
	16, 0,
	17, 0,
	18, 0,
	36, 0,
	131, 0,
	132, 0,
	159, 0,
	249, 0,
	313, 0,
	319, 0,
	-2, 676,
	-1, 1273,
	16, 0,
	17, 0,
	18, 0,
	36, 0,
	131, 0,
	132, 0,
	159, 0,
	249, 0,
	313, 0,
	319, 0,
	-2, 677,
	-1, 1274,
	16, 0,
	17, 0,
	18, 0,
	36, 0,
	131, 0,
	132, 0,
	159, 0,
	249, 0,
	313, 0,
	319, 0,
	-2, 678,
	-1, 1301,
	196, 811,
	-2, 814,
	-1, 1330,
	117, 851,
	333, 952,
	-2, 945,
	-1, 1331,
	117, 852,
	-2, 1103,
	-1, 1332,
	117, 853,
	-2, 1019,
	-1, 1333,
	117, 854,
	-2, 987,
	-1, 1334,
	117, 855,
	-2, 1003,
	-1, 1335,
	117, 856,
	-2, 1018,
	-1, 1336,
	117, 857,
	-2, 1066,
	-1, 1496,
	99, 428,
	108, 428,
	144, 428,
	160, 428,
	185, 428,
	191, 428,
	286, 428,
	-2, 511,
	-1, 1500,
	16, 0,
	17, 0,
	18, 0,
	36, 0,
	131, 0,
	132, 0,
	159, 0,
	249, 0,
	313, 0,
	319, 0,
	-2, 670,
	-1, 1501,
	16, 0,
	17, 0,
	18, 0,
	36, 0,
	131, 0,
	132, 0,
	159, 0,
	249, 0,
	313, 0,
	319, 0,
	-2, 672,
	-1, 1506,
	16, 0,
	17, 0,
	18, 0,
	36, 0,
	131, 0,
	132, 0,
	159, 0,
	249, 0,
	313, 0,
	319, 0,
	-2, 673,
	-1, 1524,
	196, 810,
	-2, 813,
	-1, 1716,
	1, 512,
	69, 512,
	99, 512,
	108, 512,
	118, 512,
	122, 512,
	124, 512,
	137, 512,
	144, 512,
	149, 512,
	157, 512,
	160, 512,
	172, 512,
	185, 512,
	187, 512,
	191, 512,
	227, 512,
	229, 512,
	286, 512,
	294, 512,
	305, 512,
	306, 512,
	315, 512,
	332, 512,
	334, 512,
	336, 512,
	337, 512,
	-2, 511,
	-1, 1718,
	16, 0,
	17, 0,
	18, 0,
	36, 0,
	131, 0,
	132, 0,
	159, 0,
	249, 0,
	313, 0,
	319, 0,
	-2, 674,
	-1, 1723,
	147, 0,
	-2, 690,
	-1, 1733,
	196, 812,
	-2, 815,
	-1, 1767,
	13, 0,
	14, 0,
	15, 0,
	316, 0,
	317, 0,
	318, 0,
	-2, 717,
	-1, 1768,
	13, 0,
	14, 0,
	15, 0,
	316, 0,
	317, 0,
	318, 0,
	-2, 718,
	-1, 1769,
	13, 0,
	14, 0,
	15, 0,
	316, 0,
	317, 0,
	318, 0,
	-2, 719,
	-1, 1773,
	13, 0,
	14, 0,
	15, 0,
	316, 0,
	317, 0,
	318, 0,
	-2, 723,
	-1, 1774,
	13, 0,
	14, 0,
	15, 0,
	316, 0,
	317, 0,
	318, 0,
	-2, 724,
	-1, 1775,
	13, 0,
	14, 0,
	15, 0,
	316, 0,
	317, 0,
	318, 0,
	-2, 725,
	-1, 1896,
	147, 0,
	-2, 691,
	-1, 1899,
	16, 0,
	17, 0,
	18, 0,
	36, 0,
	131, 0,
	132, 0,
	159, 0,
	249, 0,
	313, 0,
	319, 0,
	-2, 694,
	-1, 1900,
	16, 0,
	17, 0,
	18, 0,
	36, 0,
	131, 0,
	132, 0,
	159, 0,
	249, 0,
	313, 0,
	319, 0,
	-2, 696,
	-1, 2006,
	16, 0,
	17, 0,
	18, 0,
	36, 0,
	131, 0,
	132, 0,
	159, 0,
	249, 0,
	313, 0,
	319, 0,
	-2, 695,
	-1, 2007,
	16, 0,
	17, 0,
	18, 0,
	36, 0,
	131, 0,
	132, 0,
	159, 0,
	249, 0,
	313, 0,
	319, 0,
	-2, 697,
	-1, 2014,
	147, 0,
	-2, 726,
	-1, 2070,
	147, 0,
	-2, 727,
	-1, 2135,
	36, 0,
	131, 0,
	159, 0,
	249, 0,
	313, 0,
	319, 0,
	-2, 1106,
}

const sqlPrivate = 57344

const sqlLast = 30431

var sqlAct = [...]int{

	721, 2134, 1670, 2112, 1711, 2159, 2076, 2113, 2133, 1124,
	2114, 1940, 1132, 945, 1712, 1494, 1187, 516, 1744, 1216,
	1986, 719, 1861, 1966, 1887, 718, 523, 67, 1680, 1491,
	843, 951, 1804, 296, 90, 90, 90, 52, 1872, 711,
	1469, 537, 1818, 697, 498, 1617, 314, 90, 90, 90,
	1191, 1467, 90, 1618, 312, 90, 298, 20, 561, 579,
	1866, 1205, 1224, 90, 1688, 1299, 503, 1186, 494, 1584,
	1417, 67, 90, 90, 1585, 1535, 90, 1231, 1481, 90,
	90, 90, 90, 1697, 1164, 90, 90, 812, 1035, 787,
	1190, 947, 1223, 784, 1411, 1084, 1093, 1356, 1476, 691,
	1133, 696, 552, 1309, 67, 1286, 827, 1283, 521, 1229,
	305, 22, 971, 680, 1116, 303, 30, 302, 16, 304,
	8, 1148, 1212, 816, 908, 1180, 602, 1327, 1157, 1226,
	789, 1026, 681, 813, 20, 690, 601, 285, 1065, 573,
	571, 497, 580, 444, 1126, 515, 1069, 1194, 526, 68,
	976, 663, 574, 1819, 82, 664, 489, 713, 1359, 430,
	906, 662, 440, 421, 820, 567, 86, 524, 668, 644,
	643, 433, 1523, 69, 829, 311, 1999, 535, 829, 2000,
	542, 545, 1125, 535, 1161, 311, 979, 980, 22, 284,
	487, 829, 520, 30, 520, 16, 2150, 8, 1129, 809,
	2129, 2124, 1492, 1817, 1167, 534, 803, 2123, 540, 982,
	1167, 547, 2120, 2110, 1428, 809, 1154, 513, 2105, 543,
	66, 809, 480, 2101, 2072, 844, 809, 1154, 1162, 1167,
	66, 2066, 981, 2048, 809, 2044, 1817, 73, 809, 2039,
	528, 512, 2038, 2054, 2008, 1996, 43, 1154, 838, 1993,
	1429, 1980, 1994, 714, 1817, 44, 43, 1977, 1975, 1951,
	809, 1817, 809, 1950, 75, 44, 1817, 1922, 1163, 1160,
	1167, 1901, 32, 1898, 1167, 1890, 1154, 45, 1167, 1838,
	1527, 1120, 1167, 33, 57, 1528, 1837, 45, 987, 1167,
	1479, 977, 90, 90, 90, 90, 90, 76, 503, 1816,
	1727, 1656, 1817, 1167, 1123, 71, 1117, 1651, 1602, 59,
	1123, 1603, 72, 1600, 978, 35, 1167, 66, 1599, 1598,
	1526, 1167, 1167, 1524, 1456, 1167, 1167, 809, 1479, 1220,
	1171, 70, 809, 1167, 1166, 521, 48, 1167, 1167, 1165,
	1534, 1153, 581, 43, 1154, 1122, 60, 1117, 1123, 1780,
	47, 73, 44, 830, 1730, 1081, 837, 830, 1080, 838,
	1453, 1082, 1457, 1303, 1215, 1178, 676, 898, 49, 1120,
	830, 809, 550, 592, 45, 533, 1820, 73, 75, 77,
	556, 920, 1880, 1495, 616, 2148, 2132, 2119, 2081, 1555,
	1556, 73, 2067, 535, 500, 545, 1978, 91, 441, 1927,
	56, 73, 1923, 675, 75, 1915, 1914, 1913, 1909, 1908,
	56, 76, 1159, 1907, 1852, 1846, 1795, 90, 75, 71,
	1790, 568, 1555, 1556, 1789, 1788, 72, 1738, 75, 1716,
	1687, 1660, 90, 1607, 1158, 90, 90, 76, 576, 576,
	560, 1604, 1592, 315, 772, 1128, 503, 1583, 577, 1554,
	1551, 76, 1550, 503, 1548, 46, 1540, 1555, 1556, 71,
	1539, 76, 1455, 504, 833, 1459, 72, 1295, 828, 71,
	1428, 70, 62, 63, 34, 311, 72, 50, 950, 61,
	90, 943, 780, 1373, 51, 70, 90, 1324, 73, 1493,
	316, 1561, 1323, 675, 54, 1704, 1036, 56, 70, 558,
	983, 984, 985, 986, 988, 989, 58, 90, 90, 90,
	505, 90, 674, 1746, 2093, 75, 1043, 2051, 2037, 2036,
	66, 619, 2035, 2027, 1561, 2025, 90, 2016, 2003, 1989,
	661, 64, 1973, 1937, 977, 1920, 1892, 90, 1855, 1843,
	65, 1823, 1722, 1702, 1571, 1678, 43, 1676, 76, 1675,
	503, 90, 1673, 1658, 1626, 44, 71, 314, 503, 1561,
	90, 1845, 1625, 72, 1582, 90, 90, 90, 1296, 90,
	612, 1544, 1543, 1520, 1515, 779, 1288, 45, 1444, 1402,
	1400, 1387, 70, 1386, 90, 90, 618, 535, 660, 1366,
	1322, 1219, 90, 1070, 90, 1073, 1077, 979, 980, 90,
	979, 980, 1063, 1062, 1061, 1060, 595, 597, 600, 503,
	503, 810, 1059, 1572, 1058, 649, 1057, 314, 619, 818,
	982, 1056, 90, 982, 1055, 90, 619, 90, 90, 90,
	90, 90, 90, 1054, 1053, 90, 1052, 1051, 781, 647,
	90, 90, 1050, 981, 778, 645, 981, 90, 1049, 1048,
	653, 1047, 656, 1036, 1040, 556, 1029, 70, 90, 944,
	538, 817, 679, 599, 1387, 588, 535, 821, 821, 774,
	949, 921, 586, 513, 2131, 2103, 1998, 90, 1903, 1881,
	90, 832, 1877, 807, 835, 542, 545, 671, 672, 1851,
	1850, 73, 1705, 677, 568, 504, 975, 512, 1438, 987,
	56, 1564, 1565, 1557, 1558, 1559, 1560, 1562, 1563, 1878,
	797, 501, 1211, 839, 1437, 559, 1027, 808, 75, 780,
	1210, 610, 608, 2041, 841, 1555, 1556, 2001, 1470, 795,
	819, 822, 1849, 521, 1430, 1117, 1557, 1558, 1559, 1560,
	1562, 1563, 505, 1495, 796, 1606, 891, 889, 893, 1075,
	954, 76, 904, 1605, 1076, 942, 892, 1499, 897, 71,
	635, 895, 611, 1045, 609, 923, 72, 948, 916, 915,
	909, 1412, 1867, 1559, 1560, 1562, 1563, 1125, 1747, 1531,
	1310, 928, 1066, 90, 639, 297, 790, 1424, 791, 1613,
	2084, 90, 2146, 2145, 2043, 90, 1831, 510, 684, 790,
	780, 791, 1170, 90, 90, 473, 941, 90, 1450, 479,
	90, 478, 292, 790, 474, 791, 958, 1961, 513, 957,
	640, 513, 513, 956, 90, 973, 90, 90, 519, 90,
	1086, 1960, 90, 1959, 90, 90, 1637, 90, 1958, 503,
	850, 1087, 967, 504, 1042, 968, 969, 80, 1641, 288,
	504, 1640, 1086, 1105, 1032, 1610, 1108, 1609, 1085, 792,
	1039, 1502, 1443, 1206, 67, 919, 293, 1442, 1441, 67,
	1440, 1145, 792, 518, 905, 1270, 1168, 1127, 1657, 1127,
	608, 1114, 1113, 581, 1079, 1110, 792, 1098, 1100, 1094,
	505, 646, 1842, 549, 1067, 1068, 535, 505, 289, 1149,
	1370, 79, 1369, 1241, 545, 2042, 1071, 940, 535, 486,
	1644, 1285, 1074, 985, 986, 988, 989, 1942, 1646, 989,
	520, 314, 609, 939, 1103, 1136, 1161, 1119, 90, 1078,
	545, 1285, 1414, 545, 584, 801, 1115, 800, 1090, 90,
	90, 90, 1111, 1292, 90, 90, 814, 504, 1290, 922,
	800, 90, 1097, 598, 315, 504, 798, 2091, 1151, 1165,
	1150, 823, 1152, 1174, 1267, 1628, 1665, 1131, 1140, 798,
	1162, 799, 1141, 2156, 1176, 1179, 2116, 1142, 576, 90,
	576, 1146, 314, 506, 799, 1418, 1221, 1143, 1310, 1144,
	1342, 1422, 2145, 1177, 505, 1555, 1556, 896, 294, 1398,
	1488, 316, 505, 1407, 511, 1175, 504, 504, 636, 507,
	1163, 1160, 632, 788, 315, 517, 1662, 314, 1071, 508,
	1074, 2030, 2167, 925, 1068, 1067, 929, 930, 931, 932,
	933, 1418, 1449, 78, 295, 1172, 1240, 1165, 936, 937,
	1182, 545, 1184, 1096, 1563, 535, 633, 829, 1635, 291,
	290, 2107, 1404, 505, 505, 938, 1663, 2117, 622, 1265,
	1268, 316, 793, 1281, 1480, 1451, 583, 805, 637, 81,
	1083, 1293, 804, 1185, 2108, 793, 1213, 1214, 1279, 1183,
	1227, 1165, 979, 980, 90, 90, 90, 1264, 1372, 793,
	90, 1064, 623, 90, 1201, 621, 1489, 1561, 818, 90,
	90, 90, 90, 90, 1209, 982, 2012, 1974, 2118, 1024,
	1222, 90, 1943, 1484, 90, 90, 1629, 2162, 638, 1542,
	1698, 503, 1715, 1095, 90, 1307, 2155, 1165, 981, 90,
	520, 90, 1487, 481, 996, 1645, 1685, 2115, 90, 2144,
	1380, 1275, 2142, 1504, 1482, 1860, 1203, 626, 90, 1276,
	1571, 1277, 1485, 593, 1159, 1282, 591, 1297, 667, 1410,
	1294, 1399, 1953, 1284, 1401, 1918, 521, 1483, 1952, 90,
	90, 2173, 1318, 1935, 1374, 1291, 1830, 1266, 2022, 503,
	1337, 1612, 1874, 1829, 987, 1376, 1776, 1383, 1300, 619,
	903, 1379, 1204, 1397, 1827, 1304, 90, 1420, 90, 1312,
	90, 2168, 1426, 955, 90, 1232, 1239, 605, 90, 482,
	1329, 1329, 1340, 1375, 1351, 946, 1406, 2154, 1661, 1572,
	1363, 1364, 1365, 963, 1486, 1416, 830, 1458, 901, 1460,
	817, 90, 773, 850, 850, 2077, 504, 997, 935, 817,
	902, 56, 899, 1681, 2160, 1862, 67, 1888, 1432, 535,
	1433, 1434, 1423, 1278, 1413, 1461, 877, 1919, 1875, 1464,
	1280, 1431, 914, 913, 2172, 500, 495, 606, 521, 666,
	607, 666, 1777, 1936, 1828, 1389, 1149, 1435, 1778, 605,
	1388, 979, 980, 505, 1693, 1826, 964, 1692, 566, 1873,
	1555, 1556, 726, 1498, 1446, 1447, 2161, 1448, 422, 1454,
	484, 565, 1480, 1452, 982, 1465, 998, 1889, 1565, 1557,
	1558, 1559, 1560, 1562, 1563, 2163, 518, 1384, 315, 427,
	657, 665, 1671, 665, 423, 1853, 521, 981, 1474, 1409,
	1533, 1472, 1227, 1484, 1933, 1151, 1490, 1150, 1478, 1152,
	1497, 1475, 1570, 1462, 917, 850, 667, 1512, 776, 424,
	1689, 1484, 1487, 1477, 1321, 2015, 1934, 1917, 1586, 1721,
	1643, 1549, 1510, 1514, 1696, 316, 1415, 1169, 426, 1121,
	1487, 1109, 1485, 483, 1505, 1503, 1106, 642, 641, 315,
	1436, 634, 1482, 987, 631, 521, 630, 1812, 1320, 1519,
	1485, 629, 1561, 992, 990, 991, 983, 984, 985, 986,
	988, 989, 628, 883, 627, 1483, 624, 564, 850, 1623,
	557, 1587, 1530, 1622, 315, 1384, 1046, 927, 2111, 918,
	1813, 2074, 1801, 1633, 1631, 1507, 316, 1624, 1611, 90,
	90, 1466, 1207, 1199, 1735, 1508, 997, 1652, 1147, 1513,
	836, 834, 831, 850, 1486, 1571, 826, 1518, 806, 802,
	794, 1589, 1590, 1591, 90, 1521, 1468, 1968, 90, 2146,
	90, 316, 1486, 563, 669, 531, 966, 90, 83, 425,
	503, 1608, 562, 1537, 1538, 911, 1677, 1217, 1086, 3,
	90, 1970, 1615, 90, 1101, 1102, 309, 25, 308, 24,
	1650, 1674, 1649, 314, 1636, 90, 307, 23, 1086, 418,
	1632, 2032, 1634, 1642, 1099, 998, 1581, 1706, 1820, 1682,
	617, 1808, 472, 1809, 1572, 2069, 67, 1594, 504, 428,
	1690, 673, 1654, 1703, 1655, 1397, 1664, 1666, 1667, 1653,
	1136, 1227, 1647, 670, 532, 1107, 1218, 1509, 1683, 979,
	980, 1811, 1691, 90, 1511, 1694, 1724, 1707, 1672, 1814,
	429, 554, 1104, 551, 1740, 1741, 1742, 539, 2055, 1638,
	555, 1639, 1695, 1684, 25, 505, 24, 306, 11, 1699,
	1700, 1858, 475, 476, 23, 1202, 504, 1198, 310, 10,
	1130, 1227, 501, 496, 1227, 981, 300, 9, 974, 1731,
	299, 7, 992, 990, 991, 983, 984, 985, 986, 988,
	989, 1566, 1564, 1565, 1557, 1558, 1559, 1560, 1562, 1563,
	90, 90, 90, 301, 4, 894, 842, 1734, 1156, 2170,
	1748, 1810, 1753, 505, 1750, 2171, 2104, 90, 1555, 1556,
	979, 980, 90, 1755, 90, 775, 90, 90, 90, 651,
	650, 90, 90, 1825, 503, 11, 2058, 1623, 1885, 877,
	877, 1622, 1710, 1796, 706, 1784, 10, 1668, 1659, 1783,
	1601, 651, 1800, 1821, 9, 1624, 1439, 1371, 7, 1368,
	1367, 1824, 1317, 1797, 1033, 652, 90, 90, 1905, 1728,
	2090, 1967, 1743, 503, 1463, 1043, 1041, 485, 87, 87,
	286, 4, 1856, 90, 90, 1623, 1941, 90, 420, 1622,
	1623, 413, 414, 415, 1622, 503, 432, 90, 1847, 446,
	926, 1884, 619, 1624, 90, 625, 1879, 432, 1624, 1854,
	1701, 1883, 1863, 1848, 1859, 2106, 527, 527, 723, 1910,
	286, 1841, 1893, 286, 286, 546, 286, 1834, 1541, 87,
	553, 1781, 521, 1840, 1857, 1985, 1865, 90, 2011, 581,
	1319, 1864, 1791, 1897, 1044, 1870, 1871, 979, 980, 1876,
	42, 877, 1620, 700, 1882, 1802, 1614, 1193, 1192, 850,
	317, 912, 1232, 1751, 722, 488, 1328, 1233, 777, 724,
	982, 1232, 1756, 847, 725, 848, 1072, 712, 845, 1134,
	1289, 1308, 1529, 1037, 1227, 1227, 692, 704, 1227, 703,
	850, 850, 90, 981, 90, 1305, 314, 90, 585, 850,
	850, 1886, 443, 55, 1787, 90, 439, 1421, 1844, 876,
	962, 314, 1208, 959, 877, 1630, 509, 1552, 1916, 587,
	1349, 1341, 1338, 648, 783, 1025, 1135, 615, 1945, 1623,
	1427, 1947, 850, 1622, 1155, 678, 90, 970, 530, 1869,
	529, 1188, 1929, 1343, 613, 900, 1173, 1624, 1928, 877,
	1931, 90, 1969, 1018, 503, 1015, 477, 504, 90, 2024,
	604, 1944, 603, 1200, 1382, 1946, 90, 1623, 818, 849,
	2166, 1622, 1963, 2031, 90, 1627, 1962, 2083, 1997, 74,
	315, 1971, 2040, 90, 90, 1624, 1965, 1995, 1408, 31,
	29, 1976, 26, 1982, 21, 19, 2002, 1992, 2005, 2004,
	1988, 18, 28, 17, 505, 1979, 1939, 1984, 27, 15,
	14, 13, 12, 41, 2010, 40, 39, 38, 37, 36,
	6, 5, 1983, 2, 90, 879, 1, 316, 1991, 1956,
	1957, 1812, 0, 2026, 1805, 0, 286, 569, 286, 446,
	446, 2017, 1803, 0, 0, 0, 1807, 0, 0, 90,
	90, 0, 1981, 2020, 0, 2021, 0, 2029, 0, 0,
	0, 90, 0, 0, 1813, 90, 850, 1227, 0, 0,
	0, 2049, 1949, 503, 0, 0, 0, 2047, 0, 890,
	90, 2028, 2050, 0, 0, 1806, 90, 0, 0, 0,
	2059, 0, 314, 90, 90, 0, 2056, 2064, 2057, 0,
	0, 521, 0, 2053, 0, 0, 0, 0, 0, 0,
	2065, 0, 0, 67, 2061, 0, 90, 0, 90, 2068,
	2060, 90, 0, 314, 0, 0, 0, 0, 0, 0,
	0, 504, 0, 0, 2079, 0, 0, 2071, 2080, 0,
	2094, 2052, 0, 2096, 2092, 90, 2062, 1955, 90, 0,
	2095, 0, 2089, 0, 0, 1808, 0, 1809, 0, 0,
	0, 589, 2102, 1623, 2100, 2099, 2098, 1622, 0, 0,
	504, 0, 1343, 1343, 0, 850, 594, 2085, 505, 446,
	446, 1624, 90, 0, 90, 1811, 2121, 2097, 2128, 0,
	0, 0, 504, 1814, 2126, 0, 2125, 0, 0, 0,
	2127, 0, 90, 0, 0, 0, 0, 2139, 0, 2130,
	0, 0, 2143, 0, 2141, 0, 0, 505, 2147, 0,
	0, 90, 2082, 0, 432, 2152, 2149, 2153, 0, 0,
	286, 2151, 0, 1343, 1343, 1343, 0, 0, 0, 505,
	0, 2165, 2164, 0, 2169, 979, 980, 0, 0, 0,
	0, 446, 655, 446, 0, 658, 0, 0, 0, 0,
	0, 0, 2174, 0, 850, 1810, 0, 0, 982, 0,
	527, 0, 0, 0, 0, 877, 0, 0, 0, 0,
	0, 286, 0, 1136, 2086, 2087, 2088, 1555, 1556, 0,
	0, 981, 0, 315, 0, 87, 0, 0, 0, 0,
	0, 0, 876, 876, 286, 0, 877, 877, 315, 286,
	286, 286, 878, 824, 0, 877, 877, 0, 2109, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 286, 286,
	0, 0, 0, 0, 0, 0, 87, 0, 87, 0,
	316, 0, 0, 446, 0, 0, 0, 987, 877, 0,
	0, 504, 0, 0, 0, 316, 0, 0, 0, 0,
	850, 0, 849, 849, 1516, 1517, 446, 0, 0, 446,
	0, 87, 446, 446, 446, 446, 446, 0, 0, 934,
	0, 0, 0, 0, 446, 446, 0, 0, 0, 1561,
	0, 432, 1343, 1343, 0, 1555, 1556, 0, 505, 0,
	997, 0, 953, 0, 0, 846, 0, 0, 0, 0,
	0, 0, 0, 0, 876, 0, 0, 0, 879, 879,
	0, 527, 0, 0, 553, 1578, 1579, 1580, 0, 0,
	0, 701, 53, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1571, 0, 0, 0, 1343, 1343, 1343, 1343,
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343,
	1343, 1343, 1343, 1343, 1343, 0, 1343, 0, 0, 998,
	504, 0, 979, 980, 849, 0, 53, 876, 0, 0,
	0, 0, 877, 0, 0, 0, 0, 0, 0, 315,
	0, 0, 0, 0, 0, 982, 0, 1561, 0, 514,
	0, 0, 522, 0, 0, 0, 0, 0, 0, 53,
	419, 1572, 876, 0, 0, 0, 0, 505, 981, 0,
	315, 0, 0, 0, 0, 0, 0, 286, 0, 0,
	879, 0, 0, 0, 0, 1091, 316, 849, 0, 286,
	0, 0, 0, 0, 0, 0, 0, 286, 1112, 0,
	1571, 286, 0, 0, 1118, 0, 422, 990, 991, 983,
	984, 985, 986, 988, 989, 0, 0, 316, 286, 0,
	1138, 1139, 849, 286, 987, 0, 286, 427, 446, 446,
	0, 446, 423, 0, 1719, 1720, 0, 0, 0, 0,
	0, 877, 0, 879, 0, 0, 0, 0, 1566, 1564,
	1565, 1557, 1558, 1559, 1560, 1562, 1563, 424, 0, 682,
	682, 0, 0, 0, 0, 0, 0, 0, 785, 1572,
	0, 0, 0, 0, 0, 0, 426, 997, 879, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 1757, 1758,
	1759, 1760, 1761, 1762, 1763, 1764, 1765, 1766, 1767, 1768,
	1769, 1770, 1771, 1772, 1773, 1774, 1775, 0, 1779, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1181, 0, 0, 0, 0, 0, 0, 0,
	877, 0, 0, 286, 286, 286, 0, 0, 286, 1189,
	0, 0, 0, 0, 0, 553, 998, 0, 979, 980,
	0, 0, 1343, 0, 0, 878, 878, 0, 0, 1557,
	1558, 1559, 1560, 1562, 1563, 0, 0, 0, 0, 0,
	0, 982, 0, 286, 0, 0, 0, 425, 0, 522,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 981, 960, 0, 965, 0, 0,
	0, 0, 0, 972, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1019, 1020, 1021, 1022, 1023,
	0, 0, 0, 0, 0, 1031, 877, 428, 0, 0,
	0, 0, 0, 0, 0, 1038, 983, 984, 985, 986,
	988, 989, 0, 0, 0, 0, 0, 0, 846, 846,
	987, 0, 0, 0, 1555, 1556, 1343, 1573, 1574, 1575,
	0, 0, 0, 0, 0, 0, 0, 878, 0, 0,
	1895, 0, 0, 0, 0, 0, 0, 0, 286, 1377,
	1378, 0, 0, 0, 1091, 0, 0, 1385, 876, 0,
	0, 0, 0, 1390, 1391, 1393, 1395, 1396, 0, 0,
	0, 0, 0, 997, 0, 1403, 1570, 0, 1405, 286,
	0, 0, 0, 0, 0, 0, 0, 0, 286, 876,
	876, 0, 0, 286, 0, 1425, 0, 0, 876, 876,
	878, 0, 286, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 286, 0, 1938, 0, 0, 0, 849, 0,
	0, 0, 0, 0, 1343, 0, 1561, 0, 0, 0,
	846, 876, 0, 1181, 1181, 878, 0, 0, 0, 0,
	0, 0, 998, 0, 0, 0, 0, 0, 0, 849,
	849, 0, 0, 0, 0, 0, 0, 0, 849, 849,
	953, 1576, 953, 0, 446, 0, 0, 0, 286, 0,
	0, 0, 1471, 0, 879, 514, 0, 0, 0, 1571,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 849, 0, 846, 0, 286, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 879, 879, 0, 0, 0,
	0, 0, 0, 0, 879, 879, 0, 0, 2014, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 846, 0,
	0, 991, 983, 984, 985, 986, 988, 989, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 879, 1572, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 876, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 682, 0, 0,
	0, 0, 0, 1242, 1243, 1244, 1245, 1246, 1247, 1248,
	1249, 1250, 1251, 1252, 1253, 1254, 1255, 1256, 1257, 1258,
	1259, 1260, 1261, 1262, 1263, 0, 1269, 0, 1271, 1272,
	1273, 1274, 0, 0, 0, 0, 2070, 0, 0, 0,
	514, 0, 0, 514, 514, 849, 0, 1298, 0, 0,
	1567, 1568, 1569, 0, 0, 1566, 1564, 1565, 1557, 1558,
	1559, 1560, 1562, 1563, 0, 1028, 0, 1030, 0, 1325,
	1326, 0, 1619, 1339, 1034, 1350, 1352, 1357, 1360, 1361,
	1362, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 876, 0, 0, 0, 0, 0,
	785, 879, 0, 0, 979, 980, 0, 999, 1000, 1001,
	1009, 1010, 1011, 286, 286, 0, 0, 0, 0, 0,
	1002, 0, 0, 0, 0, 0, 0, 982, 0, 0,
	1013, 0, 0, 0, 0, 0, 0, 0, 1669, 0,
	447, 0, 1091, 0, 953, 1419, 0, 0, 0, 0,
	981, 1679, 0, 0, 849, 0, 996, 0, 451, 0,
	0, 0, 0, 0, 286, 0, 0, 286, 53, 0,
	452, 53, 0, 0, 0, 0, 0, 0, 0, 1714,
	0, 878, 0, 876, 0, 0, 0, 1445, 0, 0,
	453, 0, 53, 0, 53, 454, 0, 0, 0, 0,
	459, 460, 0, 0, 468, 0, 987, 0, 0, 53,
	879, 0, 878, 878, 53, 0, 450, 455, 0, 0,
	0, 878, 878, 0, 0, 1006, 1014, 1745, 0, 0,
	1473, 0, 0, 0, 0, 972, 0, 0, 471, 0,
	0, 1012, 0, 849, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1004, 878, 0, 456, 0, 0, 997,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	457, 458, 0, 0, 846, 0, 0, 0, 0, 876,
	0, 0, 0, 0, 1500, 1501, 0, 461, 0, 0,
	1506, 0, 0, 0, 1798, 1799, 1091, 463, 0, 879,
	0, 0, 0, 0, 0, 846, 846, 448, 0, 0,
	1619, 553, 0, 0, 846, 846, 1832, 0, 1833, 0,
	286, 1835, 1836, 1525, 0, 1839, 286, 0, 998, 0,
	1532, 0, 0, 1536, 0, 0, 0, 0, 0, 849,
	0, 0, 1545, 1007, 0, 462, 0, 846, 0, 0,
	1228, 0, 0, 0, 0, 0, 0, 0, 1619, 0,
	553, 1189, 0, 1619, 0, 0, 0, 1031, 0, 0,
	0, 0, 0, 1357, 1357, 1357, 0, 286, 286, 464,
	449, 286, 0, 0, 0, 0, 1287, 0, 878, 0,
	0, 1714, 0, 0, 0, 879, 0, 0, 1891, 0,
	0, 0, 0, 465, 0, 470, 1616, 1005, 0, 466,
	993, 994, 995, 1008, 467, 992, 990, 991, 983, 984,
	985, 986, 988, 989, 0, 0, 0, 0, 0, 469,
	0, 1911, 0, 0, 0, 0, 0, 0, 682, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	785, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 53, 0, 0, 53,
	0, 846, 0, 0, 0, 0, 1091, 0, 1930, 0,
	0, 1932, 0, 0, 0, 0, 0, 878, 0, 286,
	522, 0, 1619, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 1717,
	0, 0, 1718, 0, 0, 0, 0, 1964, 0, 0,
	553, 0, 0, 0, 1723, 0, 0, 0, 0, 0,
	1619, 0, 0, 1732, 0, 286, 0, 0, 0, 0,
	0, 1736, 1987, 0, 1445, 0, 0, 0, 0, 0,
	286, 0, 0, 0, 0, 0, 0, 0, 1714, 1752,
	53, 0, 0, 1754, 53, 0, 0, 553, 1714, 0,
	0, 0, 0, 0, 0, 0, 878, 0, 0, 0,
	846, 53, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1496, 0, 0, 0, 1785, 1786, 0, 0,
	0, 0, 0, 0, 0, 1792, 1793, 1794, 953, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	1287, 1822, 0, 2033, 2034, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 2045, 0, 0, 0, 2046,
	1030, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 553, 0, 0, 0, 0, 846,
	1714, 0, 878, 0, 0, 0, 0, 1714, 553, 0,
	0, 0, 0, 0, 0, 0, 0, 979, 980, 0,
	999, 1000, 1001, 1009, 1010, 1011, 0, 0, 0, 1868,
	2078, 0, 553, 1002, 0, 286, 0, 0, 0, 1030,
	982, 0, 0, 1013, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1619, 0, 0, 1987,
	0, 1896, 1714, 981, 0, 1899, 1900, 0, 0, 996,
	1902, 0, 0, 0, 0, 0, 0, 1904, 0, 1906,
	0, 0, 0, 0, 0, 0, 0, 1912, 0, 0,
	0, 0, 0, 0, 0, 846, 286, 0, 553, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 2140, 0, 0, 987,
	1921, 1228, 0, 0, 979, 980, 0, 999, 1000, 1001,
	1009, 1010, 1011, 0, 0, 1714, 0, 0, 1006, 1014,
	1002, 0, 0, 0, 0, 0, 0, 982, 0, 0,
	1013, 0, 0, 0, 1012, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1004, 0, 0, 1954,
	981, 1228, 997, 0, 1228, 0, 996, 0, 0, 0,
	0, 53, 0, 0, 0, 1555, 1556, 0, 1573, 1574,
	1575, 0, 0, 0, 0, 0, 0, 1003, 0, 0,
	0, 1894, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1990, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 987, 0, 0, 0,
	0, 0, 0, 0, 2006, 2007, 0, 1570, 0, 0,
	0, 998, 0, 979, 980, 1006, 1014, 0, 0, 1009,
	1010, 1011, 0, 0, 0, 0, 1007, 0, 0, 0,
	0, 1012, 0, 0, 2019, 0, 982, 0, 0, 1013,
	0, 0, 0, 1004, 0, 0, 0, 2023, 0, 997,
	0, 0, 0, 0, 0, 0, 0, 1561, 0, 981,
	0, 0, 0, 0, 0, 996, 0, 1555, 1556, 0,
	1573, 1574, 1575, 0, 1003, 0, 0, 0, 0, 0,
	0, 0, 0, 785, 1555, 1556, 0, 1573, 1574, 1575,
	1005, 0, 1576, 993, 994, 995, 1008, 0, 992, 990,
	991, 983, 984, 985, 986, 988, 989, 0, 0, 0,
	1571, 0, 0, 53, 1924, 987, 0, 0, 998, 1570,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1007, 1006, 1014, 1570, 0, 979, 980,
	0, 999, 1000, 1001, 1009, 1010, 1011, 0, 0, 0,
	0, 0, 0, 0, 1228, 1228, 0, 0, 1228, 0,
	0, 982, 1004, 0, 1013, 0, 522, 0, 997, 1561,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 1572,
	0, 0, 0, 0, 981, 0, 1561, 0, 0, 1577,
	996, 0, 0, 0, 2122, 0, 0, 1005, 0, 0,
	993, 994, 995, 1008, 1576, 992, 990, 991, 983, 984,
	985, 986, 988, 989, 0, 0, 0, 2138, 2138, 0,
	0, 1597, 1571, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 998, 0, 1571,
	987, 0, 0, 0, 0, 2138, 0, 0, 0, 0,
	0, 0, 1007, 0, 0, 0, 0, 0, 0, 1006,
	1014, 1567, 1568, 1569, 0, 0, 1566, 1564, 1565, 1557,
	1558, 1559, 1560, 1562, 1563, 1012, 0, 0, 0, 0,
	2138, 0, 0, 0, 0, 0, 0, 1004, 0, 0,
	0, 1572, 0, 997, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 1572, 0,
	0, 1972, 0, 0, 0, 0, 1005, 0, 0, 0,
	53, 0, 1008, 0, 992, 990, 991, 983, 984, 985,
	986, 988, 989, 0, 0, 0, 0, 1228, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 998, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1567, 1568, 1569, 0, 1007, 1566, 1564,
	1565, 1557, 1558, 1559, 1560, 1562, 1563, 0, 0, 0,
	1567, 1568, 1569, 0, 0, 1566, 1564, 1565, 1557, 1558,
	1559, 1560, 1562, 1563, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1030, 0, 0, 0, 0,
	0, 1005, 0, 313, 993, 994, 995, 1008, 0, 992,
	990, 991, 983, 984, 985, 986, 988, 989, 53, 92,
	93, 332, 94, 333, 334, 335, 336, 232, 337, 338,
	339, 340, 95, 96, 97, 233, 234, 235, 236, 98,
	237, 238, 341, 99, 239, 240, 100, 342, 343, 241,
	242, 243, 344, 101, 244, 345, 318, 346, 102, 103,
	104, 0, 105, 347, 106, 107, 108, 348, 319, 109,
	110, 349, 350, 351, 352, 353, 354, 111, 112, 287,
	113, 245, 114, 246, 247, 355, 115, 356, 116, 357,
	358, 359, 117, 118, 360, 119, 361, 0, 362, 248,
	120, 121, 122, 249, 250, 363, 364, 365, 123, 124,
	251, 0, 125, 366, 126, 367, 368, 320, 369, 127,
	252, 370, 253, 371, 128, 129, 130, 131, 254, 255,
	322, 372, 135, 373, 132, 374, 321, 133, 256, 134,
	257, 258, 259, 375, 260, 376, 323, 136, 324, 137,
	138, 377, 140, 139, 378, 261, 325, 141, 326, 379,
	142, 380, 381, 143, 0, 144, 145, 146, 148, 262,
	147, 327, 149, 150, 152, 151, 382, 383, 384, 263,
	153, 264, 154, 155, 385, 156, 386, 387, 157, 388,
	389, 158, 265, 328, 159, 329, 266, 160, 161, 162,
	163, 390, 267, 164, 268, 165, 391, 166, 167, 168,
	169, 269, 170, 171, 392, 172, 173, 174, 175, 176,
	178, 179, 177, 180, 181, 182, 393, 183, 330, 184,
	185, 270, 186, 0, 190, 191, 192, 193, 394, 271,
	194, 195, 196, 395, 197, 187, 188, 198, 331, 199,
	272, 273, 200, 396, 206, 201, 202, 189, 203, 205,
	274, 204, 275, 397, 207, 398, 208, 209, 210, 211,
	212, 399, 276, 277, 278, 400, 401, 213, 279, 280,
	402, 214, 215, 216, 217, 403, 404, 218, 219, 220,
	221, 405, 222, 406, 281, 223, 224, 225, 282, 283,
	407, 408, 226, 409, 410, 411, 412, 227, 228, 229,
	230, 231, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 313, 0, 0, 0, 0, 0, 0,
	1708, 0, 0, 0, 0, 0, 0, 0, 1709, 92,
	93, 332, 94, 333, 334, 335, 336, 232, 337, 338,
	339, 340, 95, 96, 97, 233, 234, 235, 236, 98,
	237, 238, 341, 99, 239, 240, 100, 342, 343, 241,
	242, 243, 344, 101, 244, 345, 318, 346, 102, 103,
	104, 0, 105, 347, 106, 107, 108, 348, 319, 109,
	110, 349, 350, 351, 352, 353, 354, 111, 112, 287,
	113, 245, 114, 246, 247, 355, 115, 356, 116, 357,
	358, 359, 117, 118, 360, 119, 361, 0, 362, 248,
	120, 121, 122, 249, 250, 363, 364, 365, 123, 124,
	251, 0, 125, 366, 126, 367, 368, 320, 369, 127,
	252, 370, 253, 371, 128, 129, 130, 131, 254, 255,
	322, 372, 135, 373, 132, 374, 321, 133, 256, 134,
	257, 258, 259, 375, 260, 376, 323, 136, 324, 137,
	138, 377, 140, 139, 378, 261, 325, 141, 326, 379,
	142, 380, 381, 143, 0, 144, 145, 146, 148, 262,
	147, 327, 149, 150, 152, 151, 382, 383, 384, 263,
	153, 264, 154, 155, 385, 156, 386, 387, 157, 388,
	389, 158, 265, 328, 159, 329, 266, 160, 161, 162,
	163, 390, 267, 164, 268, 165, 391, 166, 167, 168,
	169, 269, 170, 171, 392, 172, 173, 174, 175, 176,
	178, 179, 177, 180, 181, 182, 393, 183, 330, 184,
	185, 270, 186, 0, 190, 191, 192, 193, 394, 271,
	194, 195, 196, 395, 197, 187, 188, 198, 331, 199,
	272, 273, 200, 396, 206, 201, 202, 189, 203, 205,
	274, 204, 275, 397, 207, 398, 208, 209, 210, 211,
	212, 399, 276, 277, 278, 400, 401, 213, 279, 280,
	402, 214, 215, 216, 217, 403, 404, 218, 219, 220,
	221, 405, 222, 406, 281, 223, 224, 225, 282, 283,
	407, 408, 226, 409, 410, 411, 412, 227, 228, 229,
	230, 231, 0, 0, 0, 313, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	2063, 92, 93, 332, 94, 333, 334, 335, 336, 232,
	337, 338, 339, 340, 95, 96, 97, 233, 234, 235,
	236, 98, 237, 238, 341, 99, 239, 240, 100, 342,
	343, 241, 242, 243, 344, 101, 244, 345, 318, 346,
	102, 103, 104, 0, 105, 347, 106, 107, 108, 348,
	319, 109, 110, 349, 350, 351, 352, 353, 354, 111,
	112, 287, 113, 245, 114, 246, 247, 355, 115, 356,
	116, 357, 358, 359, 117, 118, 360, 119, 361, 0,
	362, 248, 120, 121, 122, 249, 250, 363, 364, 365,
	123, 124, 251, 0, 125, 366, 126, 367, 368, 320,
	369, 127, 252, 370, 253, 371, 128, 129, 130, 131,
	254, 255, 322, 372, 135, 373, 132, 374, 321, 133,
	256, 134, 257, 258, 259, 375, 260, 376, 323, 136,
	324, 137, 138, 377, 140, 139, 378, 261, 325, 141,
	326, 379, 142, 380, 381, 143, 0, 144, 145, 146,
	148, 262, 147, 327, 149, 150, 152, 151, 382, 383,
	384, 263, 153, 264, 154, 155, 385, 156, 386, 387,
	157, 388, 389, 158, 265, 328, 159, 329, 266, 160,
	161, 162, 163, 390, 267, 164, 268, 165, 391, 166,
	167, 168, 169, 269, 170, 171, 392, 172, 173, 174,
	175, 176, 178, 179, 177, 180, 181, 182, 393, 183,
	330, 184, 185, 270, 186, 0, 190, 191, 192, 193,
	394, 271, 194, 195, 196, 395, 197, 187, 188, 198,
	331, 199, 272, 273, 200, 396, 206, 201, 202, 189,
	203, 205, 274, 204, 275, 397, 207, 398, 208, 209,
	210, 211, 212, 399, 276, 277, 278, 400, 401, 213,
	279, 280, 402, 214, 215, 216, 217, 403, 404, 218,
	219, 220, 221, 405, 222, 406, 281, 223, 224, 225,
	282, 283, 407, 408, 226, 409, 410, 411, 412, 227,
	228, 229, 230, 231, 313, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 811, 0, 0,
	92, 93, 332, 94, 333, 334, 335, 336, 232, 337,
	338, 339, 340, 95, 96, 97, 233, 234, 235, 236,
	98, 237, 238, 341, 99, 239, 240, 100, 342, 343,
	241, 242, 243, 344, 101, 244, 345, 318, 346, 102,
	103, 104, 0, 105, 347, 106, 107, 108, 348, 319,
	109, 110, 349, 350, 351, 352, 353, 354, 111, 112,
	287, 113, 245, 114, 246, 247, 355, 115, 356, 116,
	357, 358, 359, 117, 118, 360, 119, 361, 0, 362,
	248, 120, 121, 122, 249, 250, 363, 364, 365, 123,
	124, 251, 0, 125, 366, 126, 367, 368, 320, 369,
	127, 252, 370, 253, 371, 128, 129, 130, 131, 254,
	255, 322, 372, 135, 373, 132, 374, 321, 133, 256,
	134, 257, 258, 259, 375, 260, 376, 323, 136, 324,
	137, 138, 377, 140, 139, 378, 261, 325, 141, 326,
	379, 142, 380, 381, 143, 0, 144, 145, 146, 148,
	262, 147, 327, 149, 150, 152, 151, 382, 383, 384,
	263, 153, 264, 154, 155, 385, 156, 386, 387, 157,
	388, 389, 158, 265, 328, 159, 329, 266, 160, 161,
	162, 163, 390, 267, 164, 268, 165, 391, 166, 167,
	168, 169, 269, 170, 171, 392, 172, 173, 174, 175,
	176, 178, 179, 177, 180, 181, 182, 393, 183, 330,
	184, 185, 270, 186, 0, 190, 191, 192, 193, 394,
	271, 194, 195, 196, 395, 197, 187, 188, 198, 331,
	199, 272, 273, 200, 396, 206, 201, 202, 189, 203,
	205, 274, 204, 275, 397, 207, 398, 208, 209, 210,
	211, 212, 399, 276, 277, 278, 400, 401, 213, 279,
	280, 402, 214, 215, 216, 217, 403, 404, 218, 219,
	220, 221, 405, 222, 406, 281, 223, 224, 225, 282,
	283, 407, 408, 226, 409, 410, 411, 412, 227, 228,
	229, 230, 231, 720, 709, 710, 707, 708, 699, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 92,
	93, 0, 94, 0, 0, 0, 0, 736, 702, 0,
	0, 0, 95, 96, 97, 233, 751, 235, 752, 98,
	753, 754, 0, 99, 239, 240, 100, 705, 735, 755,
	756, 243, 0, 101, 747, 0, 728, 0, 102, 103,
	104, 0, 105, 0, 106, 107, 108, 0, 319, 109,
	110, 0, 729, 731, 0, 730, 732, 111, 112, 287,
	113, 757, 114, 758, 759, 786, 115, 0, 116, 0,
	0, 0, 750, 118, 0, 119, 0, 0, 0, 693,
	120, 121, 122, 737, 738, 716, 0, 0, 123, 124,
	760, 0, 125, 0, 126, 0, 0, 320, 0, 127,
	748, 0, 253, 0, 128, 129, 130, 131, 744, 746,
	322, 0, 135, 0, 132, 0, 321, 133, 761, 134,
	762, 763, 764, 0, 727, 0, 323, 136, 324, 137,
	138, 0, 140, 139, 0, 749, 325, 141, 326, 0,
	142, 0, 0, 143, 0, 144, 145, 146, 148, 262,
	147, 327, 149, 150, 152, 151, 688, 0, 717, 745,
	153, 765, 154, 155, 0, 156, 0, 0, 157, 0,
	0, 158, 265, 328, 159, 329, 739, 160, 161, 162,
	163, 0, 740, 164, 268, 165, 0, 166, 167, 168,
	169, 766, 170, 171, 0, 172, 173, 174, 175, 176,
	178, 179, 177, 180, 181, 182, 0, 183, 330, 184,
	185, 694, 186, 0, 190, 191, 192, 193, 73, 271,
	194, 195, 196, 733, 197, 187, 188, 198, 331, 199,
	767, 273, 200, 0, 206, 201, 202, 189, 203, 205,
	768, 204, 741, 0, 207, 75, 208, 209, 210, 211,
	212, 0, 276, 769, 770, 0, 0, 213, 742, 743,
	715, 214, 215, 216, 217, 0, 0, 218, 219, 220,
	221, 734, 222, 0, 281, 223, 224, 225, 582, 771,
	0, 0, 226, 0, 0, 0, 71, 227, 228, 229,
	230, 231, 689, 72, 0, 0, 0, 0, 687, 0,
	0, 0, 0, 685, 686, 720, 709, 710, 707, 708,
	699, 0, 695, 0, 0, 0, 0, 698, 0, 0,
	0, 92, 93, 1314, 94, 0, 0, 0, 0, 736,
	702, 0, 0, 0, 95, 96, 97, 233, 751, 235,
	752, 98, 753, 754, 0, 99, 239, 240, 100, 705,
	735, 755, 756, 243, 0, 101, 747, 0, 728, 0,
	102, 103, 104, 0, 105, 0, 106, 107, 108, 0,
	319, 109, 110, 0, 729, 731, 0, 730, 732, 111,
	112, 287, 113, 757, 114, 758, 759, 0, 115, 0,
	116, 0, 1315, 0, 750, 118, 0, 119, 0, 0,
	0, 693, 120, 121, 122, 737, 738, 716, 0, 0,
	123, 124, 760, 0, 125, 0, 126, 0, 0, 320,
	0, 127, 748, 0, 253, 0, 128, 129, 130, 131,
	744, 746, 322, 0, 135, 0, 132, 0, 321, 133,
	761, 134, 762, 763, 764, 0, 727, 0, 323, 136,
	324, 137, 138, 0, 140, 139, 0, 749, 325, 141,
	326, 0, 142, 0, 0, 143, 0, 144, 145, 146,
	148, 262, 147, 327, 149, 150, 152, 151, 688, 0,
	717, 745, 153, 765, 154, 155, 0, 156, 0, 0,
	157, 0, 0, 158, 265, 328, 159, 329, 739, 160,
	161, 162, 163, 0, 740, 164, 268, 165, 0, 166,
	167, 168, 169, 766, 170, 171, 0, 172, 173, 174,
	175, 176, 178, 179, 177, 180, 181, 182, 0, 183,
	330, 184, 185, 694, 186, 0, 190, 191, 192, 193,
	0, 271, 194, 195, 196, 733, 197, 187, 188, 198,
	331, 199, 767, 273, 200, 0, 206, 201, 202, 189,
	203, 205, 768, 204, 741, 0, 207, 0, 208, 209,
	210, 211, 212, 0, 276, 769, 770, 0, 0, 213,
	742, 743, 715, 214, 215, 216, 217, 0, 0, 218,
	219, 220, 221, 734, 222, 0, 281, 223, 224, 225,
	282, 771, 1313, 0, 226, 0, 0, 0, 0, 227,
	228, 229, 230, 231, 689, 0, 0, 0, 0, 0,
	687, 0, 0, 0, 0, 685, 686, 1316, 720, 709,
	710, 707, 708, 699, 695, 1311, 0, 0, 0, 698,
	0, 0, 0, 0, 92, 93, 0, 94, 0, 0,
	0, 0, 736, 702, 0, 0, 0, 95, 96, 97,
	233, 751, 235, 752, 98, 753, 754, 0, 99, 239,
	240, 100, 705, 735, 755, 756, 243, 0, 101, 747,
	0, 728, 0, 102, 103, 104, 0, 105, 0, 106,
	107, 108, 0, 319, 109, 110, 0, 729, 731, 0,
	730, 732, 111, 112, 287, 113, 757, 114, 758, 759,
	0, 115, 0, 116, 0, 0, 0, 750, 118, 0,
	119, 0, 0, 0, 693, 120, 121, 122, 737, 738,
	716, 0, 0, 123, 124, 760, 0, 125, 0, 126,
	0, 0, 320, 0, 127, 748, 0, 253, 0, 128,
	129, 130, 131, 744, 746, 322, 0, 135, 0, 132,
	0, 321, 133, 761, 134, 762, 763, 764, 0, 727,
	0, 323, 136, 324, 137, 138, 0, 140, 139, 0,
	749, 325, 141, 326, 0, 142, 0, 0, 143, 0,
	144, 145, 146, 148, 262, 147, 327, 149, 150, 152,
	151, 688, 0, 717, 745, 153, 765, 154, 155, 0,
	156, 0, 0, 157, 0, 0, 158, 265, 328, 159,
	329, 739, 160, 161, 162, 163, 0, 740, 164, 268,
	165, 0, 166, 167, 168, 169, 766, 170, 171, 0,
	172, 173, 174, 175, 176, 178, 179, 177, 180, 181,
	182, 0, 183, 330, 184, 185, 694, 186, 0, 190,
	191, 192, 193, 73, 271, 194, 195, 196, 733, 197,
	187, 188, 198, 331, 199, 767, 273, 200, 0, 206,
	201, 202, 189, 203, 205, 768, 204, 741, 0, 207,
	75, 208, 209, 210, 211, 212, 0, 276, 769, 770,
	0, 0, 213, 742, 743, 715, 214, 215, 216, 217,
	0, 0, 218, 219, 220, 221, 734, 222, 0, 281,
	223, 224, 225, 582, 771, 0, 0, 226, 0, 0,
	0, 71, 227, 228, 229, 230, 231, 689, 72, 0,
	0, 0, 0, 687, 0, 0, 0, 0, 685, 686,
	720, 709, 710, 707, 708, 699, 0, 695, 0, 0,
	0, 0, 698, 0, 0, 0, 92, 93, 0, 94,
	0, 0, 0, 0, 736, 702, 0, 0, 0, 95,
	96, 97, 233, 751, 235, 752, 98, 753, 754, 1353,
	99, 239, 240, 100, 705, 735, 755, 756, 243, 0,
	101, 747, 0, 728, 0, 102, 103, 104, 0, 105,
	0, 106, 107, 108, 0, 319, 109, 110, 0, 729,
	731, 0, 730, 732, 111, 112, 287, 113, 757, 114,
	758, 759, 0, 115, 0, 116, 0, 0, 0, 750,
	118, 0, 119, 0, 0, 0, 693, 120, 121, 122,
	737, 738, 716, 0, 0, 123, 124, 760, 0, 125,
	0, 126, 0, 1358, 320, 0, 127, 748, 0, 253,
	0, 128, 129, 130, 131, 744, 746, 322, 0, 135,
	0, 132, 0, 321, 133, 761, 134, 762, 763, 764,
	0, 727, 0, 323, 136, 324, 137, 138, 0, 140,
	139, 1354, 749, 325, 141, 326, 0, 142, 0, 0,
	143, 0, 144, 145, 146, 148, 262, 147, 327, 149,
	150, 152, 151, 688, 0, 717, 745, 153, 765, 154,
	155, 0, 156, 0, 0, 157, 0, 0, 158, 265,
	328, 159, 329, 739, 160, 161, 162, 163, 0, 740,
	164, 268, 165, 0, 166, 167, 168, 169, 766, 170,
	171, 0, 172, 173, 174, 175, 176, 178, 179, 177,
	180, 181, 182, 0, 183, 330, 184, 185, 694, 186,
	0, 190, 191, 192, 193, 0, 271, 194, 195, 196,
	733, 197, 187, 188, 198, 331, 199, 767, 273, 200,
	0, 206, 201, 202, 189, 203, 205, 768, 204, 741,
	0, 207, 0, 208, 209, 210, 211, 212, 0, 276,
	769, 770, 0, 1355, 213, 742, 743, 715, 214, 215,
	216, 217, 0, 0, 218, 219, 220, 221, 734, 222,
	0, 281, 223, 224, 225, 282, 771, 0, 0, 226,
	0, 0, 0, 0, 227, 228, 229, 230, 231, 689,
	0, 0, 0, 0, 0, 687, 0, 0, 0, 0,
	685, 686, 720, 709, 710, 707, 708, 699, 0, 695,
	0, 0, 0, 0, 698, 0, 0, 0, 92, 93,
	0, 94, 0, 0, 0, 0, 736, 702, 0, 0,
	0, 95, 96, 97, 233, 751, 235, 752, 98, 753,
	754, 0, 99, 239, 240, 100, 705, 735, 755, 756,
	243, 0, 101, 747, 0, 728, 0, 102, 103, 104,
	0, 105, 0, 106, 107, 108, 0, 319, 109, 110,
	0, 729, 731, 0, 730, 732, 111, 112, 287, 113,
	757, 114, 758, 759, 0, 115, 0, 116, 0, 0,
	0, 750, 118, 0, 119, 0, 0, 0, 693, 120,
	121, 122, 737, 738, 716, 0, 0, 123, 124, 760,
	0, 125, 0, 126, 0, 0, 320, 0, 127, 748,
	0, 253, 0, 128, 129, 130, 131, 744, 746, 322,
	0, 135, 0, 132, 0, 321, 133, 761, 134, 762,
	763, 764, 0, 727, 0, 323, 136, 324, 137, 138,
	0, 140, 139, 0, 749, 325, 141, 326, 0, 142,
	0, 0, 143, 0, 144, 145, 146, 148, 262, 147,
	327, 149, 150, 152, 151, 688, 1648, 717, 745, 153,
	765, 154, 155, 0, 156, 0, 0, 157, 0, 0,
	158, 265, 328, 159, 329, 739, 160, 161, 162, 163,
	0, 740, 164, 268, 165, 0, 166, 167, 168, 169,
	766, 170, 171, 0, 172, 173, 174, 175, 176, 178,
	179, 177, 180, 181, 182, 0, 183, 330, 184, 185,
	694, 186, 0, 190, 191, 192, 193, 0, 271, 194,
	195, 196, 733, 197, 187, 188, 198, 331, 199, 767,
	273, 200, 0, 206, 201, 202, 189, 203, 205, 768,
	204, 741, 0, 207, 0, 208, 209, 210, 211, 212,
	0, 276, 769, 770, 0, 0, 213, 742, 743, 715,
	214, 215, 216, 217, 0, 0, 218, 219, 220, 221,
	734, 222, 0, 281, 223, 224, 225, 282, 771, 0,
	0, 226, 0, 0, 0, 0, 227, 228, 229, 230,
	231, 689, 0, 0, 0, 0, 0, 687, 0, 0,
	0, 0, 685, 686, 683, 720, 709, 710, 707, 708,
	699, 695, 0, 0, 0, 0, 698, 0, 0, 0,
	0, 92, 93, 0, 94, 0, 0, 0, 0, 736,
	702, 0, 0, 0, 95, 96, 97, 233, 751, 235,
	752, 98, 753, 754, 0, 99, 239, 240, 100, 705,
	735, 755, 756, 243, 0, 101, 747, 0, 728, 0,
	102, 103, 104, 0, 105, 0, 106, 107, 108, 0,
	319, 109, 110, 0, 729, 731, 0, 730, 732, 111,
	112, 287, 113, 757, 114, 758, 759, 0, 115, 0,
	116, 0, 0, 0, 750, 118, 0, 119, 0, 0,
	0, 693, 120, 121, 122, 737, 738, 716, 0, 0,
	123, 124, 760, 0, 125, 0, 126, 0, 0, 320,
	0, 127, 748, 0, 253, 0, 128, 129, 130, 131,
	744, 746, 322, 0, 135, 0, 132, 0, 321, 133,
	761, 134, 762, 763, 764, 0, 727, 0, 323, 136,
	324, 137, 138, 0, 140, 139, 0, 749, 325, 141,
	326, 0, 142, 0, 0, 143, 0, 144, 145, 146,
	148, 262, 147, 327, 149, 150, 152, 151, 688, 0,
	717, 745, 153, 765, 154, 155, 0, 156, 0, 0,
	157, 0, 0, 158, 265, 328, 159, 329, 739, 160,
	161, 162, 163, 0, 740, 164, 268, 165, 0, 166,
	167, 168, 169, 766, 170, 171, 0, 172, 173, 174,
	175, 176, 178, 179, 177, 180, 181, 182, 0, 183,
	330, 184, 185, 694, 186, 0, 190, 191, 192, 193,
	0, 271, 194, 195, 196, 733, 197, 187, 188, 198,
	331, 199, 767, 273, 200, 0, 206, 201, 202, 189,
	203, 205, 768, 204, 741, 0, 207, 0, 208, 209,
	210, 211, 212, 0, 276, 769, 770, 0, 0, 213,
	742, 743, 715, 214, 215, 216, 217, 0, 0, 218,
	219, 220, 221, 734, 222, 0, 281, 223, 224, 225,
	282, 771, 0, 0, 226, 0, 0, 0, 0, 227,
	228, 229, 230, 231, 689, 0, 0, 0, 0, 0,
	687, 0, 0, 0, 0, 685, 686, 0, 0, 0,
	0, 0, 1036, 1306, 695, 0, 0, 0, 0, 698,
	720, 709, 710, 707, 708, 699, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 92, 93, 0, 94,
	0, 0, 0, 0, 736, 702, 0, 0, 0, 95,
	96, 97, 233, 751, 235, 752, 98, 753, 754, 0,
	99, 239, 240, 100, 705, 735, 755, 756, 243, 0,
	101, 747, 0, 728, 0, 102, 103, 104, 0, 105,
	0, 106, 107, 108, 0, 319, 109, 110, 0, 729,
	731, 0, 730, 732, 111, 112, 287, 113, 757, 114,
	758, 759, 0, 115, 0, 116, 0, 0, 0, 750,
	118, 0, 119, 0, 0, 0, 693, 120, 121, 122,
	737, 738, 716, 0, 0, 123, 124, 760, 0, 125,
	0, 126, 0, 0, 320, 0, 127, 748, 0, 253,
	0, 128, 129, 130, 131, 744, 746, 322, 0, 135,
	0, 132, 0, 321, 133, 761, 134, 762, 763, 764,
	0, 727, 0, 323, 136, 324, 137, 138, 0, 140,
	139, 0, 749, 325, 141, 326, 0, 142, 0, 0,
	143, 0, 144, 145, 146, 148, 262, 147, 327, 149,
	150, 152, 151, 688, 0, 717, 745, 153, 765, 154,
	155, 0, 156, 0, 0, 157, 0, 0, 158, 265,
	328, 159, 329, 739, 160, 161, 162, 163, 0, 740,
	164, 268, 165, 0, 166, 167, 168, 169, 766, 170,
	171, 0, 172, 173, 174, 175, 176, 178, 179, 177,
	180, 181, 182, 0, 183, 330, 184, 185, 694, 186,
	0, 190, 191, 192, 193, 0, 271, 194, 195, 196,
	733, 197, 187, 188, 198, 331, 199, 767, 273, 200,
	0, 206, 201, 202, 189, 203, 205, 768, 204, 741,
	0, 207, 0, 208, 209, 210, 211, 212, 0, 276,
	769, 770, 0, 0, 213, 742, 743, 715, 214, 215,
	216, 217, 0, 0, 218, 219, 220, 221, 734, 222,
	0, 281, 223, 224, 225, 282, 771, 0, 0, 226,
	0, 0, 0, 0, 227, 228, 229, 230, 231, 689,
	0, 0, 0, 0, 0, 687, 0, 0, 0, 0,
	685, 686, 720, 709, 710, 707, 708, 699, 0, 695,
	1782, 0, 0, 0, 698, 0, 0, 0, 92, 93,
	0, 94, 0, 0, 0, 0, 736, 702, 0, 0,
	0, 95, 96, 97, 233, 751, 235, 752, 98, 753,
	754, 0, 99, 239, 240, 100, 705, 735, 755, 756,
	243, 0, 101, 747, 0, 728, 0, 102, 103, 104,
	0, 105, 0, 106, 107, 108, 0, 319, 109, 110,
	0, 729, 731, 0, 730, 732, 111, 112, 287, 113,
	757, 114, 758, 759, 0, 115, 0, 116, 0, 0,
	0, 750, 118, 0, 119, 0, 0, 0, 693, 120,
	121, 122, 737, 738, 716, 0, 0, 123, 124, 760,
	0, 125, 0, 126, 0, 0, 320, 0, 127, 748,
	0, 253, 0, 128, 129, 130, 131, 744, 746, 322,
	0, 135, 0, 132, 0, 321, 133, 761, 134, 762,
	763, 764, 0, 727, 0, 323, 136, 324, 137, 138,
	0, 140, 139, 0, 749, 325, 141, 326, 0, 142,
	0, 0, 143, 0, 144, 145, 146, 148, 262, 147,
	327, 149, 150, 152, 151, 688, 0, 717, 745, 153,
	765, 154, 155, 0, 156, 0, 0, 157, 0, 0,
	158, 265, 328, 159, 329, 739, 160, 161, 162, 163,
	0, 740, 164, 268, 165, 0, 166, 167, 168, 169,
	766, 170, 171, 0, 172, 173, 174, 175, 176, 178,
	179, 177, 180, 181, 182, 0, 183, 330, 184, 185,
	694, 186, 0, 190, 191, 192, 193, 0, 271, 194,
	195, 196, 733, 197, 187, 188, 198, 331, 199, 767,
	273, 200, 0, 206, 201, 202, 189, 203, 205, 768,
	204, 741, 0, 207, 0, 208, 209, 210, 211, 212,
	0, 276, 769, 770, 0, 0, 213, 742, 743, 715,
	214, 215, 216, 217, 0, 0, 218, 219, 220, 221,
	734, 222, 0, 281, 223, 224, 225, 282, 771, 1739,
	0, 226, 0, 0, 0, 0, 227, 228, 229, 230,
	231, 689, 0, 0, 0, 0, 0, 687, 0, 0,
	0, 0, 685, 686, 720, 709, 710, 707, 708, 699,
	0, 695, 0, 0, 0, 0, 698, 0, 0, 0,
	92, 93, 0, 94, 0, 0, 0, 0, 736, 702,
	0, 0, 0, 95, 96, 97, 233, 751, 235, 752,
	98, 753, 754, 0, 99, 239, 240, 100, 705, 735,
	755, 756, 243, 0, 101, 747, 0, 728, 0, 102,
	103, 104, 0, 105, 0, 106, 107, 108, 0, 319,
	109, 110, 0, 729, 731, 0, 730, 732, 111, 112,
	287, 113, 757, 114, 758, 759, 0, 115, 0, 116,
	0, 0, 0, 750, 118, 0, 119, 0, 0, 0,
	693, 120, 121, 122, 737, 738, 716, 0, 0, 123,
	124, 760, 0, 125, 0, 126, 0, 0, 320, 0,
	127, 748, 0, 253, 0, 128, 129, 130, 131, 744,
	746, 322, 0, 135, 0, 132, 0, 321, 133, 761,
	134, 762, 763, 764, 0, 727, 0, 323, 136, 324,
	137, 138, 0, 140, 139, 0, 749, 325, 141, 326,
	0, 142, 0, 0, 143, 0, 144, 145, 146, 148,
	262, 147, 327, 149, 150, 152, 151, 688, 0, 717,
	745, 153, 765, 154, 155, 0, 156, 0, 0, 157,
	0, 0, 158, 265, 328, 159, 329, 739, 160, 161,
	162, 163, 0, 740, 164, 268, 165, 0, 166, 167,
	168, 169, 766, 170, 171, 0, 172, 173, 174, 175,
	176, 178, 179, 177, 180, 181, 182, 0, 183, 330,
	184, 185, 694, 186, 0, 190, 191, 192, 193, 0,
	271, 194, 195, 196, 733, 197, 187, 188, 198, 331,
	199, 767, 273, 200, 0, 206, 201, 202, 189, 203,
	205, 768, 204, 741, 0, 207, 0, 208, 209, 210,
	211, 212, 0, 276, 769, 770, 0, 0, 213, 742,
	743, 715, 214, 215, 216, 217, 0, 0, 218, 219,
	220, 221, 734, 222, 0, 281, 223, 224, 225, 282,
	771, 0, 0, 226, 0, 0, 0, 0, 227, 228,
	229, 230, 231, 689, 0, 0, 0, 0, 0, 687,
	0, 0, 0, 0, 685, 686, 720, 709, 710, 707,
	708, 699, 0, 695, 1729, 0, 0, 0, 698, 0,
	0, 0, 92, 93, 0, 94, 0, 0, 0, 0,
	736, 702, 0, 0, 0, 95, 96, 97, 233, 751,
	235, 752, 98, 753, 754, 0, 99, 239, 240, 100,
	705, 735, 755, 756, 243, 0, 101, 747, 0, 728,
	0, 102, 103, 104, 0, 105, 0, 106, 107, 108,
	0, 319, 109, 110, 0, 729, 731, 0, 730, 732,
	111, 112, 287, 113, 757, 114, 758, 759, 786, 115,
	0, 116, 0, 0, 0, 750, 118, 0, 119, 0,
	0, 0, 693, 120, 121, 122, 737, 738, 716, 0,
	0, 123, 124, 760, 0, 125, 0, 126, 0, 0,
	320, 0, 127, 748, 0, 253, 0, 128, 129, 130,
	131, 744, 746, 322, 0, 135, 0, 132, 0, 321,
	133, 761, 134, 762, 763, 764, 0, 727, 0, 323,
	136, 324, 137, 138, 0, 140, 139, 0, 749, 325,
	141, 326, 0, 142, 0, 0, 143, 0, 144, 145,
	146, 148, 262, 147, 327, 149, 150, 152, 151, 688,
	0, 717, 745, 153, 765, 154, 155, 0, 156, 0,
	0, 157, 0, 0, 158, 265, 328, 159, 329, 739,
	160, 161, 162, 163, 0, 740, 164, 268, 165, 0,
	166, 167, 168, 169, 766, 170, 171, 0, 172, 173,
	174, 175, 176, 178, 179, 177, 180, 181, 182, 0,
	183, 330, 184, 185, 694, 186, 0, 190, 191, 192,
	193, 0, 271, 194, 195, 196, 733, 197, 187, 188,
	198, 331, 199, 767, 273, 200, 0, 206, 201, 202,
	189, 203, 205, 768, 204, 741, 0, 207, 0, 208,
	209, 210, 211, 212, 0, 276, 769, 770, 0, 0,
	213, 742, 743, 715, 214, 215, 216, 217, 0, 0,
	218, 219, 220, 221, 734, 222, 0, 281, 223, 224,
	225, 282, 771, 0, 0, 226, 0, 0, 0, 0,
	227, 228, 229, 230, 231, 689, 0, 0, 0, 0,
	0, 687, 0, 0, 0, 0, 685, 686, 720, 709,
	710, 707, 708, 699, 0, 695, 0, 0, 0, 0,
	698, 0, 0, 0, 92, 93, 0, 94, 0, 0,
	0, 0, 736, 702, 0, 0, 0, 95, 96, 97,
	233, 751, 235, 752, 98, 753, 754, 0, 99, 239,
	240, 100, 705, 735, 755, 756, 243, 0, 101, 747,
	0, 728, 0, 102, 103, 104, 0, 105, 0, 106,
	107, 108, 0, 319, 109, 110, 0, 729, 731, 0,
	730, 732, 111, 112, 287, 113, 757, 114, 758, 759,
	0, 115, 0, 116, 0, 0, 0, 750, 118, 0,
	119, 0, 0, 0, 693, 120, 121, 122, 737, 738,
	716, 0, 0, 123, 124, 760, 0, 125, 0, 126,
	0, 1358, 320, 0, 127, 748, 0, 253, 0, 128,
	129, 130, 131, 744, 746, 322, 0, 135, 0, 132,
	0, 321, 133, 761, 134, 762, 763, 764, 0, 727,
	0, 323, 136, 324, 137, 138, 0, 140, 139, 0,
	749, 325, 141, 326, 0, 142, 0, 0, 143, 0,
	144, 145, 146, 148, 262, 147, 327, 149, 150, 152,
	151, 688, 0, 717, 745, 153, 765, 154, 155, 0,
	156, 0, 0, 157, 0, 0, 158, 265, 328, 159,
	329, 739, 160, 161, 162, 163, 0, 740, 164, 268,
	165, 0, 166, 167, 168, 169, 766, 170, 171, 0,
	172, 173, 174, 175, 176, 178, 179, 177, 180, 181,
	182, 0, 183, 330, 184, 185, 694, 186, 0, 190,
	191, 192, 193, 0, 271, 194, 195, 196, 733, 197,
	187, 188, 198, 331, 199, 767, 273, 200, 0, 206,
	201, 202, 189, 203, 205, 768, 204, 741, 0, 207,
	0, 208, 209, 210, 211, 212, 0, 276, 769, 770,
	0, 0, 213, 742, 743, 715, 214, 215, 216, 217,
	0, 0, 218, 219, 220, 221, 734, 222, 0, 281,
	223, 224, 225, 282, 771, 0, 0, 226, 0, 0,
	0, 0, 227, 228, 229, 230, 231, 689, 0, 0,
	0, 0, 0, 687, 0, 0, 0, 0, 685, 686,
	720, 709, 710, 707, 708, 699, 0, 695, 0, 0,
	0, 0, 698, 0, 0, 0, 92, 93, 0, 94,
	0, 0, 0, 0, 736, 702, 0, 0, 0, 95,
	96, 97, 233, 751, 235, 752, 98, 753, 754, 0,
	99, 239, 240, 100, 705, 735, 755, 756, 243, 0,
	101, 747, 0, 728, 0, 102, 103, 104, 0, 105,
	0, 106, 107, 108, 0, 319, 109, 110, 0, 729,
	731, 0, 730, 732, 111, 112, 287, 113, 757, 114,
	758, 759, 0, 115, 0, 116, 0, 0, 0, 750,
	118, 0, 119, 0, 0, 0, 693, 120, 121, 122,
	737, 738, 716, 0, 0, 123, 124, 760, 0, 125,
	0, 126, 0, 0, 320, 0, 127, 748, 0, 253,
	0, 128, 129, 130, 131, 744, 746, 322, 0, 135,
	0, 132, 0, 321, 133, 761, 134, 762, 763, 764,
	0, 727, 0, 323, 136, 324, 137, 138, 0, 140,
	139, 0, 749, 325, 141, 326, 0, 142, 0, 0,
	143, 0, 144, 145, 146, 148, 262, 147, 327, 149,
	150, 152, 151, 688, 0, 717, 745, 153, 765, 154,
	155, 0, 156, 0, 0, 157, 0, 0, 158, 265,
	328, 159, 329, 739, 160, 161, 162, 163, 0, 740,
	164, 268, 165, 0, 166, 167, 168, 169, 766, 170,
	171, 0, 172, 173, 174, 175, 176, 178, 179, 177,
	180, 181, 182, 0, 183, 330, 184, 185, 694, 186,
	0, 190, 191, 192, 193, 0, 271, 194, 195, 196,
	733, 197, 187, 188, 198, 331, 199, 767, 273, 200,
	0, 206, 201, 202, 189, 203, 205, 768, 204, 741,
	0, 207, 0, 208, 209, 210, 211, 212, 0, 276,
	769, 770, 0, 0, 213, 742, 743, 715, 214, 215,
	216, 217, 0, 0, 218, 219, 220, 221, 734, 222,
	0, 281, 223, 224, 225, 282, 771, 0, 0, 226,
	0, 0, 0, 0, 227, 228, 229, 230, 231, 689,
	0, 0, 0, 0, 0, 687, 0, 0, 0, 0,
	685, 686, 720, 709, 710, 707, 708, 699, 0, 695,
	1301, 0, 0, 0, 698, 0, 0, 0, 92, 93,
	0, 94, 0, 0, 0, 0, 736, 702, 0, 0,
	0, 95, 96, 97, 233, 751, 235, 752, 98, 753,
	754, 0, 99, 239, 240, 100, 705, 735, 755, 756,
	243, 0, 101, 747, 0, 728, 0, 102, 103, 104,
	0, 105, 0, 106, 107, 108, 0, 319, 109, 110,
	0, 729, 731, 0, 730, 732, 111, 112, 287, 113,
	757, 114, 758, 759, 0, 115, 0, 116, 0, 0,
	0, 750, 118, 0, 119, 0, 0, 0, 693, 120,
	121, 122, 737, 738, 716, 0, 0, 123, 124, 760,
	0, 125, 0, 126, 0, 0, 320, 0, 127, 748,
	0, 253, 0, 128, 129, 130, 131, 744, 746, 322,
	0, 135, 0, 132, 0, 321, 133, 761, 134, 762,
	763, 764, 0, 727, 0, 323, 136, 324, 137, 138,
	0, 140, 139, 0, 749, 325, 141, 326, 0, 142,
	0, 0, 143, 0, 144, 145, 146, 148, 262, 147,
	327, 149, 150, 152, 151, 688, 0, 717, 745, 153,
	765, 154, 155, 0, 156, 0, 0, 157, 0, 0,
	158, 265, 328, 159, 329, 739, 160, 161, 162, 163,
	0, 740, 164, 268, 165, 0, 166, 167, 168, 169,
	766, 170, 171, 0, 172, 173, 174, 175, 176, 178,
	179, 177, 180, 181, 182, 0, 183, 330, 184, 185,
	694, 186, 0, 190, 191, 192, 193, 0, 271, 194,
	195, 196, 733, 197, 187, 188, 198, 331, 199, 767,
	273, 200, 0, 206, 201, 202, 189, 203, 205, 768,
	204, 741, 0, 207, 0, 208, 209, 210, 211, 212,
	0, 276, 769, 770, 0, 0, 213, 742, 743, 715,
	214, 215, 216, 217, 0, 0, 218, 219, 220, 221,
	734, 222, 0, 281, 223, 224, 225, 282, 771, 0,
	0, 226, 0, 0, 0, 0, 227, 228, 229, 230,
	231, 689, 0, 0, 0, 0, 0, 687, 0, 0,
	0, 0, 685, 686, 683, 720, 709, 710, 707, 708,
	699, 695, 0, 0, 0, 0, 698, 0, 0, 0,
	0, 92, 93, 961, 94, 0, 0, 0, 0, 736,
	702, 0, 0, 0, 95, 96, 97, 233, 751, 235,
	752, 98, 753, 754, 0, 99, 239, 240, 100, 705,
	735, 755, 756, 243, 0, 101, 747, 0, 728, 0,
	102, 103, 104, 0, 105, 0, 106, 107, 108, 0,
	319, 109, 110, 0, 729, 731, 0, 730, 732, 111,
	112, 287, 113, 757, 114, 758, 759, 0, 115, 0,
	116, 0, 0, 0, 750, 118, 0, 119, 0, 0,
	0, 693, 120, 121, 122, 737, 738, 716, 0, 0,
	123, 124, 760, 0, 125, 0, 126, 0, 0, 320,
	0, 127, 748, 0, 253, 0, 128, 129, 130, 131,
	744, 746, 322, 0, 135, 0, 132, 0, 321, 133,
	761, 134, 762, 763, 764, 0, 727, 0, 323, 136,
	324, 137, 138, 0, 140, 139, 0, 749, 325, 141,
	326, 0, 142, 0, 0, 143, 0, 144, 145, 146,
	148, 262, 147, 327, 149, 150, 152, 151, 688, 0,
	717, 745, 153, 765, 154, 155, 0, 156, 0, 0,
	157, 0, 0, 158, 265, 328, 159, 329, 739, 160,
	161, 162, 163, 0, 740, 164, 268, 165, 0, 166,
	167, 168, 169, 766, 170, 171, 0, 172, 173, 174,
	175, 176, 178, 179, 177, 180, 181, 182, 0, 183,
	330, 184, 185, 694, 186, 0, 190, 191, 192, 193,
	0, 271, 194, 195, 196, 733, 197, 187, 188, 198,
	331, 199, 767, 273, 200, 0, 206, 201, 202, 189,
	203, 205, 768, 204, 741, 0, 207, 0, 208, 209,
	210, 211, 212, 0, 276, 769, 770, 0, 0, 213,
	742, 743, 715, 214, 215, 216, 217, 0, 0, 218,
	219, 220, 221, 734, 222, 0, 281, 223, 224, 225,
	282, 771, 0, 0, 226, 0, 0, 0, 0, 227,
	228, 229, 230, 231, 689, 0, 0, 0, 0, 0,
	687, 0, 0, 0, 0, 685, 686, 720, 709, 710,
	707, 708, 699, 0, 695, 0, 0, 0, 0, 698,
	0, 0, 0, 92, 93, 0, 94, 0, 0, 0,
	0, 736, 702, 0, 0, 0, 95, 96, 97, 233,
	751, 235, 752, 98, 753, 754, 0, 99, 239, 240,
	100, 705, 735, 755, 756, 243, 0, 101, 747, 0,
	728, 0, 102, 103, 104, 0, 105, 0, 106, 107,
	108, 0, 319, 109, 2137, 0, 729, 731, 0, 730,
	732, 111, 112, 287, 113, 757, 114, 758, 759, 0,
	115, 0, 116, 0, 0, 0, 750, 118, 0, 119,
	0, 0, 0, 693, 120, 121, 122, 737, 738, 716,
	0, 0, 123, 124, 760, 0, 125, 0, 126, 0,
	0, 320, 0, 127, 748, 0, 253, 0, 128, 129,
	130, 131, 744, 746, 322, 0, 135, 0, 132, 0,
	321, 133, 761, 134, 762, 763, 764, 0, 727, 0,
	323, 136, 324, 137, 138, 0, 140, 139, 0, 749,
	325, 141, 326, 0, 142, 0, 0, 143, 0, 144,
	145, 146, 148, 262, 147, 327, 149, 150, 152, 151,
	688, 0, 717, 745, 153, 765, 154, 155, 0, 156,
	0, 0, 157, 0, 0, 158, 265, 328, 159, 329,
	739, 160, 161, 162, 163, 0, 740, 164, 268, 165,
	0, 166, 167, 168, 169, 766, 170, 171, 0, 172,
	173, 174, 175, 176, 178, 179, 177, 180, 181, 182,
	0, 183, 330, 184, 185, 694, 186, 0, 190, 191,
	192, 193, 0, 271, 194, 195, 196, 733, 197, 187,
	188, 198, 331, 199, 767, 273, 200, 0, 206, 201,
	202, 189, 203, 205, 768, 204, 741, 0, 207, 0,
	208, 209, 210, 211, 212, 0, 276, 769, 770, 0,
	0, 213, 742, 743, 715, 214, 215, 2136, 217, 0,
	0, 218, 219, 220, 221, 734, 222, 0, 281, 223,
	224, 225, 282, 771, 0, 0, 226, 0, 0, 0,
	0, 227, 228, 229, 230, 231, 689, 0, 0, 0,
	0, 0, 687, 0, 0, 0, 0, 685, 686, 720,
	709, 710, 707, 708, 699, 0, 695, 0, 0, 0,
	0, 698, 0, 0, 0, 92, 93, 0, 94, 0,
	0, 0, 0, 736, 702, 0, 0, 0, 95, 96,
	97, 2135, 751, 235, 752, 98, 753, 754, 0, 99,
	239, 240, 100, 705, 735, 755, 756, 243, 0, 101,
	747, 0, 728, 0, 102, 103, 104, 0, 105, 0,
	106, 107, 108, 0, 319, 109, 2137, 0, 729, 731,
	0, 730, 732, 111, 112, 287, 113, 757, 114, 758,
	759, 0, 115, 0, 116, 0, 0, 0, 750, 118,
	0, 119, 0, 0, 0, 693, 120, 121, 122, 737,
	738, 716, 0, 0, 123, 124, 760, 0, 125, 0,
	126, 0, 0, 320, 0, 127, 748, 0, 253, 0,
	128, 129, 130, 131, 744, 746, 322, 0, 135, 0,
	132, 0, 321, 133, 761, 134, 762, 763, 764, 0,
	727, 0, 323, 136, 324, 137, 138, 0, 140, 139,
	0, 749, 325, 141, 326, 0, 142, 0, 0, 143,
	0, 144, 145, 146, 148, 262, 147, 327, 149, 150,
	152, 151, 688, 0, 717, 745, 153, 765, 154, 155,
	0, 156, 0, 0, 157, 0, 0, 158, 265, 328,
	159, 329, 739, 160, 161, 162, 163, 0, 740, 164,
	268, 165, 0, 166, 167, 168, 169, 766, 170, 171,
	0, 172, 173, 174, 175, 176, 178, 179, 177, 180,
	181, 182, 0, 183, 330, 184, 185, 694, 186, 0,
	190, 191, 192, 193, 0, 271, 194, 195, 196, 733,
	197, 187, 188, 198, 331, 199, 767, 273, 200, 0,
	206, 201, 202, 189, 203, 205, 768, 204, 741, 0,
	207, 0, 208, 209, 210, 211, 212, 0, 276, 769,
	770, 0, 0, 213, 742, 743, 715, 214, 215, 2136,
	217, 0, 0, 218, 219, 220, 221, 734, 222, 0,
	281, 223, 224, 225, 282, 771, 0, 0, 226, 0,
	0, 0, 0, 227, 228, 229, 230, 231, 689, 0,
	0, 0, 0, 0, 687, 0, 0, 0, 0, 685,
	686, 720, 709, 710, 707, 708, 699, 0, 695, 0,
	0, 0, 0, 698, 0, 0, 0, 92, 93, 0,
	94, 0, 0, 0, 0, 736, 702, 0, 0, 0,
	95, 96, 97, 233, 751, 235, 752, 98, 753, 754,
	0, 99, 239, 240, 100, 705, 735, 755, 756, 243,
	0, 101, 747, 0, 728, 0, 102, 103, 104, 0,
	105, 0, 106, 107, 108, 0, 319, 109, 110, 0,
	729, 731, 0, 730, 732, 111, 112, 287, 113, 757,
	114, 758, 759, 0, 115, 0, 116, 0, 0, 0,
	750, 118, 0, 119, 0, 0, 0, 693, 120, 121,
	122, 737, 738, 716, 0, 0, 123, 124, 760, 0,
	125, 0, 126, 0, 0, 320, 0, 127, 748, 0,
	253, 0, 128, 129, 130, 131, 744, 746, 322, 0,
	135, 0, 132, 0, 321, 133, 761, 134, 762, 763,
	764, 0, 727, 0, 323, 136, 324, 137, 138, 0,
	140, 139, 0, 749, 325, 141, 326, 0, 142, 0,
	0, 143, 0, 144, 145, 146, 148, 262, 147, 327,
	149, 150, 152, 151, 688, 0, 717, 745, 153, 765,
	154, 155, 0, 156, 0, 0, 157, 0, 0, 158,
	265, 328, 159, 329, 739, 160, 161, 162, 163, 0,
	740, 164, 268, 165, 0, 166, 167, 168, 169, 766,
	170, 171, 0, 172, 173, 174, 175, 176, 178, 179,
	177, 180, 181, 182, 0, 183, 330, 184, 185, 694,
	186, 0, 190, 191, 192, 193, 0, 271, 194, 195,
	196, 733, 197, 187, 188, 198, 331, 199, 767, 273,
	200, 0, 206, 201, 202, 189, 203, 205, 768, 204,
	741, 0, 207, 0, 208, 209, 210, 211, 212, 0,
	276, 769, 770, 0, 0, 213, 742, 743, 715, 214,
	215, 216, 217, 0, 0, 218, 219, 220, 221, 734,
	222, 0, 281, 223, 224, 225, 282, 771, 0, 0,
	226, 0, 0, 0, 0, 227, 228, 229, 230, 231,
	689, 0, 0, 0, 0, 0, 687, 0, 0, 0,
	0, 685, 686, 1330, 709, 710, 707, 708, 699, 0,
	695, 0, 0, 0, 0, 698, 0, 0, 0, 92,
	93, 0, 94, 0, 0, 0, 0, 736, 702, 0,
	0, 0, 95, 96, 97, 233, 751, 235, 752, 98,
	753, 754, 0, 99, 239, 240, 100, 705, 735, 755,
	756, 243, 0, 101, 747, 0, 728, 0, 102, 103,
	104, 0, 105, 0, 106, 107, 108, 0, 319, 109,
	110, 0, 729, 731, 0, 730, 732, 111, 112, 287,
	113, 757, 1333, 758, 759, 0, 115, 0, 116, 0,
	0, 0, 750, 118, 0, 119, 0, 0, 0, 693,
	120, 121, 122, 737, 738, 716, 0, 0, 123, 124,
	760, 0, 125, 0, 126, 0, 0, 320, 0, 127,
	748, 0, 253, 0, 128, 129, 1334, 131, 744, 746,
	322, 0, 135, 0, 132, 0, 321, 133, 761, 134,
	762, 763, 764, 0, 727, 0, 323, 136, 324, 137,
	138, 0, 140, 139, 0, 749, 325, 141, 326, 0,
	142, 0, 0, 143, 0, 144, 1335, 1332, 148, 262,
	147, 327, 149, 150, 152, 151, 688, 0, 717, 745,
	153, 765, 154, 155, 0, 156, 0, 0, 157, 0,
	0, 158, 265, 328, 159, 329, 739, 160, 161, 162,
	163, 0, 740, 164, 268, 165, 0, 166, 167, 168,
	169, 766, 170, 171, 0, 172, 173, 174, 175, 176,
	178, 179, 177, 180, 181, 182, 0, 183, 330, 184,
	185, 694, 186, 0, 190, 191, 192, 1336, 0, 271,
	194, 195, 196, 733, 197, 187, 188, 198, 331, 199,
	767, 273, 200, 0, 206, 201, 202, 189, 203, 205,
	768, 204, 741, 0, 207, 0, 208, 209, 210, 211,
	212, 0, 276, 769, 770, 0, 0, 213, 742, 743,
	715, 214, 215, 216, 217, 0, 0, 218, 219, 220,
	221, 734, 222, 0, 281, 223, 224, 225, 282, 771,
	0, 0, 226, 0, 0, 0, 0, 227, 228, 229,
	1331, 231, 689, 0, 0, 0, 0, 0, 687, 0,
	0, 0, 0, 685, 686, 720, 709, 710, 707, 708,
	699, 0, 695, 0, 0, 0, 0, 698, 0, 0,
	0, 92, 93, 0, 94, 0, 0, 0, 0, 736,
	702, 0, 0, 0, 95, 96, 97, 233, 751, 235,
	752, 98, 753, 754, 0, 99, 239, 240, 100, 705,
	735, 755, 756, 243, 0, 101, 747, 0, 728, 0,
	102, 103, 104, 0, 105, 0, 106, 107, 108, 0,
	319, 109, 110, 0, 729, 731, 0, 730, 732, 111,
	112, 287, 113, 757, 114, 758, 759, 0, 115, 0,
	116, 0, 0, 0, 750, 118, 0, 119, 0, 0,
	0, 693, 120, 121, 122, 737, 738, 716, 0, 0,
	123, 124, 760, 0, 125, 0, 126, 0, 0, 320,
	0, 127, 748, 0, 253, 0, 128, 129, 130, 131,
	744, 746, 322, 0, 135, 0, 132, 0, 321, 133,
	761, 134, 762, 763, 764, 0, 727, 0, 323, 136,
	324, 137, 138, 0, 140, 139, 0, 749, 325, 141,
	326, 0, 142, 0, 0, 143, 0, 144, 145, 146,
	148, 262, 147, 327, 149, 150, 152, 151, 0, 0,
	717, 745, 153, 765, 154, 155, 0, 156, 0, 0,
	157, 0, 0, 158, 265, 328, 159, 329, 739, 160,
	161, 162, 163, 0, 740, 164, 268, 165, 0, 166,
	167, 168, 169, 766, 170, 171, 0, 172, 173, 174,
	175, 176, 178, 179, 177, 180, 181, 182, 0, 183,
	330, 184, 185, 1348, 186, 0, 190, 191, 192, 193,
	0, 271, 194, 195, 196, 733, 197, 187, 188, 198,
	331, 199, 767, 273, 200, 0, 206, 201, 202, 189,
	203, 205, 768, 204, 741, 0, 207, 0, 208, 209,
	210, 211, 212, 0, 276, 769, 770, 0, 0, 213,
	742, 743, 715, 214, 215, 216, 217, 0, 0, 218,
	219, 220, 221, 734, 222, 0, 281, 223, 224, 225,
	282, 771, 0, 0, 226, 0, 0, 0, 0, 227,
	228, 229, 230, 231, 0, 0, 0, 0, 0, 0,
	1346, 0, 0, 0, 0, 1344, 1345, 720, 709, 710,
	707, 708, 699, 0, 1347, 0, 0, 0, 0, 698,
	0, 0, 0, 92, 93, 0, 94, 0, 0, 0,
	0, 736, 702, 0, 0, 0, 95, 96, 97, 233,
	751, 235, 752, 98, 753, 754, 0, 99, 239, 240,
	100, 0, 735, 755, 756, 243, 0, 101, 747, 0,
	728, 0, 102, 103, 104, 0, 105, 0, 106, 107,
	108, 0, 319, 109, 110, 0, 729, 731, 0, 730,
	732, 111, 112, 287, 113, 757, 114, 758, 759, 0,
	115, 0, 116, 0, 0, 0, 750, 118, 0, 119,
	0, 0, 0, 248, 120, 121, 122, 737, 738, 716,
	0, 0, 123, 124, 760, 0, 125, 0, 126, 0,
	0, 320, 0, 127, 748, 0, 253, 0, 128, 129,
	130, 131, 744, 746, 322, 0, 135, 0, 132, 0,
	321, 133, 761, 134, 762, 763, 764, 0, 727, 0,
	323, 136, 324, 137, 138, 0, 140, 139, 0, 749,
	325, 141, 326, 0, 142, 0, 0, 143, 0, 144,
	145, 146, 148, 262, 147, 327, 149, 150, 152, 151,
	0, 0, 717, 745, 153, 765, 154, 155, 0, 156,
	0, 0, 157, 0, 0, 158, 265, 328, 159, 329,
	739, 160, 161, 162, 163, 0, 740, 164, 268, 165,
	0, 166, 167, 168, 169, 766, 170, 171, 0, 172,
	173, 174, 175, 176, 178, 179, 177, 180, 181, 182,
	0, 183, 330, 184, 185, 1348, 186, 0, 190, 191,
	192, 193, 0, 271, 194, 195, 196, 733, 197, 187,
	188, 198, 331, 199, 767, 273, 200, 0, 206, 201,
	202, 189, 203, 205, 768, 204, 741, 0, 207, 0,
	208, 209, 210, 211, 212, 0, 276, 769, 770, 0,
	0, 213, 742, 743, 715, 214, 215, 216, 217, 0,
	0, 218, 219, 220, 221, 734, 222, 0, 281, 223,
	224, 225, 282, 771, 0, 0, 226, 0, 0, 0,
	0, 227, 228, 229, 230, 231, 0, 0, 720, 709,
	710, 707, 708, 699, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 92, 93, 1347, 94, 0, 0,
	0, 698, 736, 702, 0, 0, 0, 95, 96, 97,
	0, 751, 235, 752, 98, 753, 754, 0, 99, 239,
	240, 100, 705, 735, 755, 756, 243, 0, 101, 747,
	0, 728, 0, 102, 103, 104, 0, 105, 0, 106,
	107, 108, 0, 319, 109, 2137, 0, 729, 731, 0,
	730, 732, 111, 112, 287, 113, 757, 114, 758, 759,
	0, 115, 0, 116, 0, 0, 0, 750, 118, 0,
	119, 0, 0, 0, 693, 120, 121, 122, 737, 738,
	716, 0, 0, 123, 124, 760, 0, 125, 0, 126,
	0, 0, 320, 0, 127, 748, 0, 253, 0, 128,
	129, 130, 131, 744, 746, 0, 0, 135, 0, 132,
	0, 321, 133, 761, 134, 762, 763, 764, 0, 727,
	0, 0, 136, 324, 137, 138, 0, 140, 139, 0,
	749, 325, 141, 0, 0, 142, 0, 0, 143, 0,
	144, 145, 146, 148, 262, 147, 327, 149, 150, 152,
	151, 688, 0, 717, 745, 153, 765, 154, 155, 0,
	156, 0, 0, 157, 0, 0, 158, 265, 328, 159,
	329, 739, 160, 161, 162, 163, 0, 740, 164, 268,
	165, 0, 166, 167, 168, 169, 766, 170, 171, 0,
	172, 173, 174, 175, 176, 178, 179, 177, 180, 181,
	182, 0, 183, 330, 184, 185, 694, 186, 0, 190,
	191, 192, 193, 0, 271, 194, 195, 196, 733, 197,
	187, 188, 198, 0, 199, 767, 273, 200, 0, 206,
	201, 202, 189, 203, 205, 768, 204, 741, 0, 207,
	0, 208, 209, 210, 211, 212, 0, 276, 769, 770,
	0, 0, 213, 742, 743, 715, 214, 215, 2136, 217,
	0, 0, 218, 219, 220, 221, 734, 222, 0, 281,
	223, 224, 225, 282, 771, 0, 0, 226, 0, 0,
	0, 0, 227, 228, 229, 230, 231, 720, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 685, 686,
	0, 0, 0, 92, 93, 0, 94, 695, 0, 0,
	0, 736, 698, 0, 0, 0, 95, 96, 97, 233,
	234, 235, 236, 98, 237, 238, 0, 99, 239, 240,
	100, 0, 735, 241, 242, 243, 0, 101, 747, 0,
	728, 0, 102, 103, 104, 0, 105, 0, 106, 107,
	108, 0, 319, 109, 110, 0, 729, 731, 0, 730,
	732, 111, 112, 287, 113, 245, 114, 246, 247, 0,
	115, 0, 116, 0, 0, 0, 117, 118, 0, 119,
	0, 0, 0, 248, 120, 121, 122, 737, 738, 0,
	0, 0, 123, 124, 251, 0, 125, 0, 126, 0,
	0, 320, 0, 127, 748, 0, 253, 0, 128, 129,
	130, 131, 744, 746, 322, 0, 135, 0, 132, 0,
	321, 133, 256, 134, 257, 258, 259, 0, 260, 0,
	323, 136, 324, 137, 138, 0, 140, 139, 0, 749,
	325, 141, 326, 0, 142, 0, 0, 143, 0, 144,
	145, 146, 148, 262, 147, 327, 149, 150, 152, 151,
	0, 0, 0, 745, 153, 264, 154, 155, 0, 156,
	0, 0, 157, 0, 0, 158, 265, 328, 159, 329,
	739, 160, 161, 162, 163, 0, 740, 164, 268, 165,
	0, 166, 167, 168, 169, 269, 170, 171, 0, 172,
	173, 174, 175, 176, 178, 179, 177, 180, 181, 182,
	0, 183, 330, 184, 185, 270, 186, 0, 190, 191,
	192, 193, 0, 271, 194, 195, 196, 733, 197, 187,
	188, 198, 331, 199, 272, 273, 200, 0, 206, 201,
	202, 189, 203, 205, 274, 204, 741, 0, 207, 0,
	208, 209, 210, 211, 212, 0, 276, 277, 278, 0,
	0, 213, 742, 743, 0, 214, 215, 216, 217, 0,
	0, 218, 219, 220, 221, 734, 222, 0, 281, 223,
	224, 225, 282, 283, 0, 0, 226, 0, 502, 0,
	0, 227, 228, 229, 230, 231, 0, 0, 0, 0,
	0, 0, 0, 0, 92, 93, 0, 94, 0, 0,
	0, 0, 232, 0, 0, 0, 1621, 95, 96, 97,
	233, 234, 235, 236, 98, 237, 238, 0, 99, 239,
	240, 100, 0, 0, 241, 242, 243, 0, 101, 244,
	0, 318, 0, 102, 103, 104, 0, 105, 0, 106,
	107, 108, 0, 319, 109, 110, 0, 0, 0, 0,
	0, 0, 111, 112, 287, 113, 245, 114, 246, 247,
	0, 115, 0, 116, 0, 0, 0, 117, 118, 0,
	119, 0, 0, 0, 248, 120, 121, 122, 249, 250,
	0, 0, 0, 123, 124, 251, 0, 125, 0, 126,
	0, 0, 320, 0, 127, 252, 0, 253, 0, 128,
	129, 130, 131, 254, 255, 322, 0, 135, 0, 132,
	0, 321, 133, 256, 134, 257, 258, 259, 0, 260,
	0, 323, 136, 324, 137, 138, 0, 140, 139, 0,
	261, 325, 141, 326, 0, 142, 0, 0, 143, 0,
	144, 145, 146, 148, 262, 147, 327, 149, 150, 152,
	151, 0, 0, 0, 263, 153, 264, 154, 155, 0,
	156, 0, 0, 157, 0, 0, 158, 265, 328, 159,
	329, 266, 160, 161, 162, 163, 0, 267, 164, 268,
	165, 0, 166, 167, 168, 169, 269, 170, 171, 0,
	172, 173, 174, 175, 176, 178, 179, 177, 180, 181,
	182, 0, 183, 330, 184, 185, 270, 186, 0, 190,
	191, 192, 193, 73, 271, 194, 195, 196, 0, 197,
	187, 188, 198, 331, 199, 272, 273, 200, 0, 206,
	201, 202, 189, 203, 205, 274, 204, 275, 0, 207,
	75, 208, 209, 210, 211, 212, 0, 276, 277, 278,
	0, 0, 213, 279, 280, 0, 214, 215, 216, 217,
	0, 0, 218, 219, 220, 221, 0, 222, 0, 281,
	223, 224, 225, 582, 283, 0, 0, 226, 0, 0,
	0, 71, 227, 228, 229, 230, 231, 0, 72, 502,
	499, 0, 500, 495, 490, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 92, 93, 70, 94, 0,
	0, 0, 0, 232, 0, 0, 0, 0, 95, 96,
	97, 233, 234, 235, 236, 98, 237, 238, 0, 99,
	239, 240, 100, 0, 0, 241, 242, 243, 0, 101,
	244, 0, 318, 0, 102, 103, 104, 0, 105, 0,
	106, 107, 108, 0, 319, 109, 110, 0, 0, 0,
	0, 0, 0, 111, 112, 287, 113, 245, 114, 246,
	247, 910, 115, 0, 116, 0, 0, 0, 117, 118,
	0, 119, 0, 0, 0, 248, 120, 121, 122, 249,
	250, 492, 0, 0, 123, 124, 251, 0, 125, 0,
	126, 0, 0, 320, 0, 127, 252, 0, 253, 0,
	128, 129, 130, 131, 254, 255, 322, 0, 135, 0,
	132, 0, 321, 133, 256, 134, 257, 258, 259, 0,
	260, 0, 323, 136, 324, 137, 138, 0, 140, 139,
	0, 261, 325, 141, 326, 0, 142, 0, 0, 143,
	0, 144, 145, 146, 148, 262, 147, 327, 149, 150,
	152, 151, 0, 0, 0, 263, 153, 264, 154, 155,
	0, 156, 493, 0, 157, 0, 0, 158, 265, 328,
	159, 329, 266, 160, 161, 162, 163, 0, 267, 164,
	268, 165, 0, 166, 167, 168, 169, 269, 170, 171,
	0, 172, 173, 174, 175, 176, 178, 179, 177, 180,
	181, 182, 0, 183, 330, 184, 185, 270, 186, 0,
	190, 191, 192, 193, 0, 271, 194, 195, 196, 0,
	197, 187, 188, 198, 331, 199, 272, 273, 200, 0,
	206, 201, 202, 189, 203, 205, 274, 204, 275, 0,
	207, 0, 208, 209, 210, 211, 212, 0, 276, 277,
	278, 0, 0, 213, 279, 280, 491, 214, 215, 216,
	217, 0, 0, 218, 219, 220, 221, 0, 222, 0,
	281, 223, 224, 225, 282, 283, 0, 0, 226, 0,
	0, 0, 0, 227, 228, 229, 230, 231, 502, 499,
	0, 500, 495, 490, 0, 0, 0, 0, 0, 501,
	496, 0, 0, 0, 92, 93, 0, 94, 0, 0,
	0, 0, 232, 0, 0, 0, 0, 95, 96, 97,
	233, 234, 235, 236, 98, 237, 238, 0, 99, 239,
	240, 100, 0, 0, 241, 242, 243, 0, 101, 244,
	0, 318, 0, 102, 103, 104, 0, 105, 0, 106,
	107, 108, 0, 319, 109, 110, 0, 0, 0, 0,
	0, 0, 111, 112, 287, 113, 245, 114, 246, 247,
	907, 115, 0, 116, 0, 0, 0, 117, 118, 0,
	119, 0, 0, 0, 248, 120, 121, 122, 249, 250,
	492, 0, 0, 123, 124, 251, 0, 125, 0, 126,
	0, 0, 320, 0, 127, 252, 0, 253, 0, 128,
	129, 130, 131, 254, 255, 322, 0, 135, 0, 132,
	0, 321, 133, 256, 134, 257, 258, 259, 0, 260,
	0, 323, 136, 324, 137, 138, 0, 140, 139, 0,
	261, 325, 141, 326, 0, 142, 0, 0, 143, 0,
	144, 145, 146, 148, 262, 147, 327, 149, 150, 152,
	151, 0, 0, 0, 263, 153, 264, 154, 155, 0,
	156, 493, 0, 157, 0, 0, 158, 265, 328, 159,
	329, 266, 160, 161, 162, 163, 0, 267, 164, 268,
	165, 0, 166, 167, 168, 169, 269, 170, 171, 0,
	172, 173, 174, 175, 176, 178, 179, 177, 180, 181,
	182, 0, 183, 330, 184, 185, 270, 186, 0, 190,
	191, 192, 193, 0, 271, 194, 195, 196, 0, 197,
	187, 188, 198, 331, 199, 272, 273, 200, 0, 206,
	201, 202, 189, 203, 205, 274, 204, 275, 0, 207,
	0, 208, 209, 210, 211, 212, 0, 276, 277, 278,
	0, 0, 213, 279, 280, 491, 214, 215, 216, 217,
	0, 0, 218, 219, 220, 221, 0, 222, 0, 281,
	223, 224, 225, 282, 283, 0, 0, 226, 0, 0,
	0, 0, 227, 228, 229, 230, 231, 502, 499, 0,
	500, 495, 490, 0, 0, 0, 0, 0, 501, 496,
	0, 0, 0, 92, 93, 0, 94, 0, 0, 0,
	0, 232, 0, 0, 0, 0, 95, 96, 97, 233,
	234, 235, 236, 98, 237, 238, 0, 99, 239, 240,
	100, 0, 0, 241, 242, 243, 0, 101, 244, 0,
	318, 0, 102, 103, 104, 0, 105, 0, 106, 107,
	108, 0, 319, 109, 110, 0, 0, 0, 0, 0,
	0, 111, 112, 287, 113, 245, 114, 246, 247, 614,
	115, 0, 116, 0, 0, 0, 117, 118, 0, 119,
	0, 0, 0, 248, 120, 121, 122, 249, 250, 492,
	0, 0, 123, 124, 251, 0, 125, 0, 126, 0,
	0, 320, 0, 127, 252, 0, 253, 0, 128, 129,
	130, 131, 254, 255, 322, 0, 135, 0, 132, 0,
	321, 133, 256, 134, 257, 258, 259, 0, 260, 0,
	323, 136, 324, 137, 138, 0, 140, 139, 0, 261,
	325, 141, 326, 0, 142, 0, 0, 143, 0, 144,
	145, 146, 148, 262, 147, 327, 149, 150, 152, 151,
	0, 0, 0, 263, 153, 264, 154, 155, 0, 156,
	493, 0, 157, 0, 0, 158, 265, 328, 159, 329,
	266, 160, 161, 162, 163, 0, 267, 164, 268, 165,
	0, 166, 167, 168, 169, 269, 170, 171, 0, 172,
	173, 174, 175, 176, 178, 179, 177, 180, 181, 182,
	0, 183, 330, 184, 185, 270, 186, 0, 190, 191,
	192, 193, 0, 271, 194, 195, 196, 0, 197, 187,
	188, 198, 331, 199, 272, 273, 200, 0, 206, 201,
	202, 189, 203, 205, 274, 204, 275, 0, 207, 0,
	208, 209, 210, 211, 212, 0, 276, 277, 278, 0,
	0, 213, 279, 280, 491, 214, 215, 216, 217, 0,
	0, 218, 219, 220, 221, 0, 222, 0, 281, 223,
	224, 225, 282, 283, 0, 0, 226, 0, 0, 0,
	0, 227, 228, 229, 230, 231, 502, 499, 0, 500,
	495, 490, 0, 0, 0, 0, 0, 501, 496, 0,
	0, 0, 92, 93, 0, 94, 0, 0, 0, 0,
	232, 0, 0, 0, 0, 95, 96, 97, 233, 234,
	235, 236, 98, 237, 238, 0, 99, 239, 240, 100,
	0, 0, 241, 242, 243, 0, 101, 244, 0, 318,
	0, 102, 103, 104, 0, 105, 0, 106, 107, 108,
	0, 319, 109, 110, 0, 0, 0, 0, 0, 0,
	111, 112, 287, 113, 245, 114, 246, 247, 0, 115,
	0, 116, 0, 0, 0, 117, 118, 0, 119, 0,
	0, 0, 248, 120, 121, 122, 249, 250, 492, 0,
	0, 123, 124, 251, 0, 125, 0, 126, 0, 0,
	320, 0, 127, 252, 0, 253, 0, 128, 129, 130,
	131, 254, 255, 322, 0, 135, 0, 132, 0, 321,
	133, 256, 134, 257, 258, 259, 0, 260, 0, 323,
	136, 324, 137, 138, 0, 140, 139, 0, 261, 325,
	141, 326, 0, 142, 0, 0, 143, 0, 144, 145,
	146, 148, 262, 147, 327, 149, 150, 152, 151, 0,
	0, 0, 263, 153, 264, 154, 155, 0, 156, 493,
	0, 157, 0, 0, 158, 265, 328, 159, 329, 266,
	160, 161, 162, 163, 0, 267, 164, 268, 165, 0,
	166, 167, 168, 169, 269, 170, 171, 0, 172, 173,
	174, 175, 176, 178, 179, 177, 180, 181, 182, 0,
	183, 330, 184, 185, 270, 186, 0, 190, 191, 192,
	193, 0, 271, 194, 195, 196, 0, 197, 187, 188,
	198, 331, 199, 272, 273, 200, 0, 206, 201, 202,
	189, 203, 205, 274, 204, 275, 0, 207, 0, 208,
	209, 210, 211, 212, 0, 276, 277, 278, 0, 0,
	213, 279, 280, 491, 214, 215, 216, 217, 0, 0,
	218, 219, 220, 221, 0, 222, 0, 281, 223, 224,
	225, 282, 283, 0, 89, 226, 0, 0, 0, 0,
	227, 228, 229, 230, 231, 0, 0, 0, 0, 0,
	92, 93, 0, 94, 0, 0, 501, 496, 232, 0,
	0, 0, 0, 95, 96, 97, 233, 234, 235, 236,
	98, 237, 238, 0, 99, 239, 240, 100, 0, 0,
	241, 242, 243, 0, 101, 244, 0, 0, 0, 102,
	103, 104, 0, 105, 0, 106, 107, 108, 0, 0,
	109, 110, 0, 0, 0, 0, 0, 0, 111, 112,
	287, 113, 245, 114, 246, 247, 0, 115, 0, 116,
	0, 0, 0, 117, 118, 0, 119, 0, 0, 0,
	248, 120, 121, 122, 249, 250, 0, 0, 0, 123,
	124, 251, 0, 125, 0, 126, 0, 0, 0, 0,
	127, 252, 0, 253, 0, 128, 129, 130, 131, 254,
	255, 0, 0, 135, 0, 132, 0, 0, 133, 256,
	134, 257, 258, 259, 0, 260, 0, 0, 136, 0,
	137, 138, 0, 140, 139, 0, 261, 0, 141, 0,
	0, 142, 0, 0, 143, 0, 144, 145, 146, 148,
	262, 147, 0, 149, 150, 152, 151, 0, 0, 0,
	263, 153, 264, 154, 155, 0, 156, 0, 536, 157,
	0, 0, 158, 265, 0, 159, 0, 266, 160, 161,
	162, 163, 0, 267, 164, 268, 165, 0, 166, 167,
	168, 169, 269, 170, 171, 0, 172, 173, 174, 175,
	176, 178, 179, 177, 180, 181, 182, 0, 183, 0,
	184, 185, 270, 186, 0, 190, 191, 192, 193, 73,
	271, 194, 195, 196, 0, 197, 187, 188, 198, 0,
	199, 272, 273, 200, 0, 206, 201, 202, 189, 203,
	205, 274, 204, 275, 0, 207, 75, 208, 209, 210,
	211, 212, 0, 276, 277, 278, 0, 0, 213, 279,
	280, 0, 214, 215, 216, 217, 0, 0, 218, 219,
	220, 221, 0, 222, 0, 281, 223, 224, 225, 582,
	283, 0, 0, 226, 0, 89, 0, 71, 227, 228,
	229, 230, 231, 0, 72, 0, 0, 0, 0, 0,
	0, 92, 93, 0, 94, 0, 0, 0, 0, 232,
	0, 1225, 0, 1230, 95, 96, 97, 233, 234, 235,
	236, 98, 237, 238, 0, 99, 239, 240, 100, 0,
	0, 241, 242, 243, 0, 101, 244, 0, 0, 0,
	102, 103, 104, 0, 105, 0, 106, 107, 108, 0,
	0, 109, 110, 0, 0, 0, 0, 0, 0, 111,
	112, 287, 113, 245, 114, 246, 247, 0, 115, 0,
	116, 0, 0, 0, 117, 118, 0, 119, 0, 0,
	0, 248, 120, 121, 122, 249, 250, 0, 0, 0,
	123, 124, 251, 0, 125, 0, 126, 0, 0, 0,
	0, 127, 252, 0, 253, 0, 128, 129, 130, 131,
	254, 255, 0, 0, 135, 0, 132, 0, 0, 133,
	256, 134, 257, 258, 259, 0, 260, 0, 0, 136,
	0, 137, 138, 0, 140, 139, 0, 261, 0, 141,
	0, 0, 142, 0, 0, 143, 0, 144, 145, 146,
	148, 262, 147, 0, 149, 150, 152, 151, 0, 0,
	0, 263, 153, 264, 154, 155, 0, 156, 0, 0,
	157, 0, 0, 158, 265, 0, 159, 0, 266, 160,
	161, 162, 163, 0, 267, 164, 268, 165, 0, 166,
	167, 168, 169, 269, 170, 171, 0, 172, 173, 174,
	175, 176, 178, 179, 177, 180, 181, 182, 0, 183,
	0, 184, 185, 270, 186, 0, 190, 191, 192, 193,
	73, 271, 194, 195, 196, 0, 197, 187, 188, 198,
	0, 199, 272, 273, 200, 0, 206, 201, 202, 189,
	203, 205, 274, 204, 275, 0, 207, 75, 208, 209,
	210, 211, 212, 0, 276, 277, 278, 0, 0, 213,
	279, 280, 0, 214, 215, 216, 217, 0, 0, 218,
	219, 220, 221, 0, 222, 0, 281, 223, 224, 225,
	582, 283, 0, 0, 226, 0, 89, 0, 71, 227,
	228, 229, 230, 231, 0, 72, 0, 0, 0, 0,
	0, 0, 92, 93, 0, 94, 0, 0, 0, 0,
	232, 0, 0, 0, 70, 95, 96, 97, 233, 234,
	235, 236, 98, 237, 238, 0, 99, 239, 240, 100,
	0, 0, 241, 242, 243, 0, 101, 244, 0, 0,
	0, 102, 103, 104, 0, 105, 0, 106, 107, 108,
	0, 0, 109, 110, 0, 0, 0, 0, 0, 0,
	111, 112, 287, 113, 245, 114, 246, 247, 0, 115,
	0, 116, 0, 0, 0, 117, 118, 0, 119, 0,
	0, 0, 248, 120, 121, 122, 249, 250, 0, 0,
	0, 123, 124, 251, 0, 125, 0, 126, 0, 0,
	0, 0, 127, 252, 0, 253, 0, 128, 129, 130,
	131, 254, 255, 0, 0, 135, 0, 132, 0, 0,
	133, 256, 134, 257, 258, 259, 0, 260, 0, 0,
	136, 0, 137, 138, 0, 140, 139, 0, 261, 0,
	141, 0, 0, 142, 0, 0, 143, 0, 144, 145,
	146, 148, 262, 147, 0, 149, 150, 152, 151, 0,
	0, 0, 263, 153, 264, 154, 155, 0, 156, 0,
	536, 157, 0, 0, 158, 265, 0, 159, 0, 266,
	160, 161, 162, 163, 0, 267, 164, 268, 165, 0,
	166, 167, 168, 169, 269, 170, 171, 0, 172, 173,
	174, 175, 176, 178, 179, 177, 180, 181, 182, 0,
	183, 0, 184, 185, 270, 186, 0, 190, 191, 192,
	193, 0, 271, 194, 195, 196, 0, 197, 187, 188,
	198, 0, 199, 272, 273, 200, 0, 206, 201, 202,
	189, 203, 205, 274, 204, 275, 0, 207, 0, 208,
	209, 210, 211, 212, 0, 276, 277, 278, 0, 0,
	213, 279, 280, 0, 214, 215, 216, 217, 0, 0,
	218, 219, 220, 221, 0, 222, 0, 281, 223, 224,
	225, 282, 283, 0, 0, 226, 0, 89, 0, 0,
	227, 228, 229, 230, 231, 0, 0, 0, 0, 0,
	0, 0, 0, 92, 93, 0, 94, 0, 0, 0,
	0, 232, 0, 1225, 0, 1230, 95, 96, 97, 233,
	234, 235, 236, 98, 237, 238, 0, 99, 239, 240,
	100, 0, 0, 241, 242, 243, 0, 101, 244, 0,
	0, 0, 102, 103, 104, 0, 105, 0, 106, 107,
	108, 0, 0, 109, 110, 0, 0, 0, 0, 0,
	0, 111, 112, 287, 113, 245, 114, 246, 247, 0,
	115, 0, 116, 0, 0, 0, 117, 118, 0, 119,
	0, 0, 0, 248, 120, 121, 122, 249, 250, 0,
	0, 0, 123, 124, 251, 0, 125, 0, 126, 0,
	0, 0, 0, 127, 252, 0, 253, 0, 128, 129,
	130, 131, 254, 255, 0, 0, 135, 0, 132, 0,
	0, 133, 256, 134, 257, 258, 259, 0, 260, 0,
	0, 136, 0, 137, 138, 0, 140, 139, 0, 261,
	0, 141, 0, 0, 142, 0, 0, 143, 0, 144,
	145, 146, 148, 262, 147, 0, 149, 150, 152, 151,
	0, 0, 0, 263, 153, 264, 154, 155, 0, 156,
	0, 0, 157, 0, 0, 158, 265, 0, 159, 0,
	266, 160, 161, 162, 163, 0, 267, 164, 268, 165,
	0, 166, 167, 168, 169, 269, 170, 171, 0, 172,
	173, 174, 175, 176, 178, 179, 177, 180, 181, 182,
	0, 183, 0, 184, 185, 270, 186, 0, 190, 191,
	192, 193, 0, 271, 194, 195, 196, 0, 197, 187,
	188, 198, 0, 199, 272, 273, 200, 0, 206, 201,
	202, 189, 203, 205, 274, 204, 275, 0, 207, 0,
	208, 209, 210, 211, 212, 0, 276, 277, 278, 0,
	0, 213, 279, 280, 0, 214, 215, 216, 217, 0,
	0, 218, 219, 220, 221, 0, 222, 0, 281, 223,
	224, 225, 282, 283, 0, 0, 226, 0, 0, 89,
	0, 227, 228, 229, 230, 231, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 92, 93, 0, 94, 0,
	0, 0, 0, 232, 0, 0, 0, 815, 95, 96,
	97, 233, 234, 235, 236, 98, 237, 238, 0, 99,
	239, 240, 100, 0, 0, 241, 242, 243, 0, 101,
	244, 0, 0, 0, 102, 103, 104, 0, 105, 0,
	106, 107, 108, 0, 0, 109, 110, 0, 0, 0,
	0, 0, 0, 111, 112, 287, 113, 245, 114, 246,
	247, 0, 115, 0, 116, 0, 0, 0, 117, 118,
	0, 119, 0, 0, 0, 248, 120, 121, 122, 249,
	250, 0, 0, 0, 123, 124, 251, 0, 125, 0,
	126, 0, 0, 0, 0, 127, 252, 0, 253, 0,
	128, 129, 130, 131, 254, 255, 0, 0, 135, 0,
	132, 0, 0, 133, 256, 134, 257, 258, 259, 0,
	260, 0, 0, 136, 0, 137, 138, 0, 140, 139,
	0, 261, 0, 141, 0, 0, 142, 0, 0, 143,
	0, 144, 145, 146, 148, 262, 147, 0, 149, 150,
	152, 151, 0, 0, 0, 263, 153, 264, 154, 155,
	0, 156, 0, 0, 157, 0, 0, 158, 265, 0,
	159, 0, 266, 160, 161, 162, 163, 0, 267, 164,
	268, 165, 0, 166, 167, 168, 169, 269, 170, 171,
	0, 172, 173, 174, 175, 176, 178, 179, 177, 180,
	181, 182, 0, 183, 0, 184, 185, 270, 186, 0,
	190, 191, 192, 193, 0, 271, 194, 195, 196, 0,
	197, 187, 188, 198, 0, 199, 272, 273, 200, 0,
	206, 201, 202, 189, 203, 205, 274, 204, 275, 0,
	207, 0, 208, 209, 210, 211, 212, 0, 276, 277,
	278, 0, 0, 213, 279, 280, 0, 214, 215, 216,
	217, 0, 0, 218, 219, 220, 221, 0, 222, 0,
	281, 223, 224, 225, 282, 283, 0, 0, 226, 0,
	89, 0, 0, 227, 228, 229, 230, 231, 0, 0,
	0, 0, 0, 0, 0, 0, 92, 93, 0, 94,
	0, 0, 0, 0, 232, 0, 0, 0, 1137, 95,
	96, 97, 233, 234, 235, 236, 98, 237, 238, 0,
	99, 239, 240, 100, 0, 0, 241, 242, 243, 0,
	101, 244, 0, 0, 0, 102, 103, 104, 0, 105,
	0, 106, 107, 108, 0, 0, 109, 110, 0, 0,
	0, 0, 0, 0, 111, 112, 287, 113, 245, 114,
	246, 247, 0, 115, 0, 116, 0, 0, 0, 117,
	118, 0, 119, 0, 0, 0, 248, 120, 121, 122,
	249, 250, 0, 0, 0, 123, 124, 251, 0, 125,
	0, 126, 0, 0, 0, 0, 127, 252, 0, 253,
	0, 128, 129, 130, 131, 254, 255, 0, 0, 135,
	0, 132, 0, 0, 133, 256, 134, 257, 258, 259,
	0, 260, 0, 0, 136, 0, 137, 138, 0, 140,
	139, 0, 261, 0, 141, 0, 0, 142, 0, 0,
	143, 0, 144, 145, 146, 148, 262, 147, 0, 149,
	150, 152, 151, 0, 0, 0, 263, 153, 264, 154,
	155, 0, 156, 0, 0, 157, 0, 0, 158, 265,
	0, 159, 0, 266, 160, 161, 162, 163, 0, 267,
	164, 268, 165, 0, 166, 167, 168, 169, 269, 170,
	171, 0, 172, 173, 174, 175, 176, 178, 179, 177,
	180, 181, 182, 0, 183, 0, 184, 185, 270, 186,
	0, 190, 191, 192, 193, 0, 271, 194, 195, 196,
	0, 197, 187, 188, 198, 0, 199, 272, 273, 200,
	0, 206, 201, 202, 189, 203, 205, 274, 204, 275,
	0, 207, 0, 208, 209, 210, 211, 212, 0, 276,
	277, 278, 0, 0, 213, 279, 280, 0, 214, 215,
	216, 217, 0, 0, 218, 219, 220, 221, 0, 222,
	0, 281, 223, 224, 225, 282, 283, 0, 0, 226,
	0, 89, 0, 0, 227, 228, 229, 230, 231, 0,
	0, 0, 0, 0, 0, 0, 0, 92, 93, 0,
	94, 0, 0, 0, 0, 232, 0, 0, 0, 1746,
	95, 96, 97, 233, 234, 235, 236, 98, 237, 238,
	0, 99, 239, 240, 100, 0, 0, 241, 242, 243,
	0, 101, 244, 0, 0, 0, 102, 103, 104, 0,
	105, 0, 106, 107, 108, 0, 0, 109, 110, 0,
	0, 0, 0, 0, 0, 111, 112, 287, 113, 245,
	114, 246, 247, 0, 115, 0, 116, 0, 0, 0,
	117, 118, 0, 119, 0, 0, 0, 248, 120, 121,
	122, 249, 250, 0, 0, 0, 123, 124, 251, 0,
	125, 0, 126, 0, 0, 0, 0, 127, 252, 0,
	253, 0, 128, 129, 130, 131, 254, 255, 0, 0,
	135, 0, 132, 0, 0, 133, 256, 134, 257, 258,
	259, 0, 260, 0, 0, 136, 0, 137, 138, 0,
	140, 139, 0, 261, 0, 141, 0, 0, 142, 0,
	0, 143, 0, 144, 145, 146, 148, 262, 147, 0,
	149, 150, 152, 151, 0, 0, 0, 263, 153, 264,
	154, 155, 0, 156, 0, 0, 157, 0, 0, 158,
	265, 0, 159, 0, 266, 160, 161, 162, 163, 0,
	267, 164, 268, 165, 0, 166, 167, 168, 169, 269,
	170, 171, 0, 172, 173, 174, 175, 176, 178, 179,
	177, 180, 181, 182, 0, 183, 0, 184, 185, 270,
	186, 0, 190, 191, 192, 193, 0, 271, 194, 195,
	196, 0, 197, 187, 188, 198, 0, 199, 272, 273,
	200, 0, 206, 201, 202, 189, 203, 205, 274, 204,
	275, 0, 207, 0, 208, 209, 210, 211, 212, 0,
	276, 277, 278, 0, 0, 213, 279, 280, 0, 214,
	215, 216, 217, 0, 0, 218, 219, 220, 221, 0,
	222, 0, 281, 223, 224, 225, 282, 283, 0, 0,
	226, 0, 0, 0, 0, 227, 228, 229, 230, 231,
	720, 709, 710, 707, 708, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 92, 93, 0, 94,
	782, 0, 0, 0, 232, 0, 0, 0, 0, 95,
	96, 97, 233, 751, 235, 752, 98, 753, 754, 0,
	99, 239, 240, 100, 0, 0, 755, 756, 243, 0,
	101, 244, 0, 318, 0, 102, 103, 104, 0, 105,
	0, 106, 107, 108, 0, 319, 109, 110, 0, 0,
	0, 0, 0, 0, 111, 112, 287, 113, 757, 114,
	758, 759, 0, 115, 0, 116, 0, 0, 0, 750,
	118, 0, 119, 0, 0, 0, 248, 120, 121, 122,
	249, 250, 716, 0, 0, 123, 124, 760, 0, 125,
	0, 126, 0, 0, 320, 0, 127, 252, 0, 253,
	0, 128, 129, 130, 131, 254, 255, 322, 0, 135,
	0, 132, 0, 321, 133, 761, 134, 762, 763, 764,
	0, 727, 0, 323, 136, 324, 137, 138, 0, 140,
	139, 0, 261, 325, 141, 326, 0, 142, 0, 0,
	143, 0, 144, 145, 146, 148, 262, 147, 327, 149,
	150, 152, 151, 0, 0, 717, 263, 153, 765, 154,
	155, 0, 156, 0, 0, 157, 0, 0, 158, 265,
	328, 159, 329, 266, 160, 161, 162, 163, 0, 267,
	164, 268, 165, 0, 166, 167, 168, 169, 766, 170,
	171, 0, 172, 173, 174, 175, 176, 178, 179, 177,
	180, 181, 182, 0, 183, 330, 184, 185, 270, 186,
	0, 190, 191, 192, 193, 0, 271, 194, 195, 196,
	0, 197, 187, 188, 198, 331, 199, 767, 273, 200,
	0, 206, 201, 202, 189, 203, 205, 768, 204, 275,
	0, 207, 0, 208, 209, 210, 211, 212, 0, 276,
	769, 770, 0, 0, 213, 279, 280, 715, 214, 215,
	216, 217, 0, 0, 218, 219, 220, 221, 0, 222,
	0, 281, 223, 224, 225, 282, 771, 502, 499, 226,
	0, 0, 620, 0, 227, 228, 229, 230, 231, 0,
	0, 0, 0, 92, 93, 0, 94, 0, 0, 0,
	0, 232, 0, 0, 0, 0, 95, 96, 97, 233,
	234, 235, 236, 98, 237, 238, 0, 99, 239, 240,
	100, 0, 0, 241, 242, 243, 0, 101, 244, 0,
	318, 0, 102, 103, 104, 0, 105, 0, 106, 107,
	108, 0, 319, 109, 110, 0, 0, 0, 0, 0,
	0, 111, 112, 287, 113, 245, 114, 246, 247, 0,
	115, 0, 116, 0, 0, 0, 117, 118, 0, 119,
	0, 0, 0, 248, 120, 121, 122, 249, 250, 0,
	0, 0, 123, 124, 251, 0, 125, 0, 126, 0,
	0, 320, 0, 127, 252, 0, 253, 0, 128, 129,
	130, 131, 254, 255, 322, 0, 135, 0, 132, 0,
	321, 133, 256, 134, 257, 258, 259, 0, 260, 0,
	323, 136, 324, 137, 138, 0, 140, 139, 0, 261,
	325, 141, 326, 0, 142, 0, 0, 143, 0, 144,
	145, 146, 148, 262, 147, 327, 149, 150, 152, 151,
	0, 0, 0, 263, 153, 264, 154, 155, 0, 156,
	0, 0, 157, 0, 0, 158, 265, 328, 159, 329,
	266, 160, 161, 162, 163, 0, 267, 164, 268, 165,
	0, 166, 167, 168, 169, 269, 170, 171, 0, 172,
	173, 174, 175, 176, 178, 179, 177, 180, 181, 182,
	0, 183, 330, 184, 185, 270, 186, 0, 190, 191,
	192, 193, 0, 271, 194, 195, 196, 0, 197, 187,
	188, 198, 331, 199, 272, 273, 200, 0, 206, 201,
	202, 189, 203, 205, 274, 204, 275, 0, 207, 0,
	208, 209, 210, 211, 212, 0, 276, 277, 278, 0,
	0, 213, 279, 280, 0, 214, 215, 216, 217, 0,
	0, 218, 219, 220, 221, 0, 222, 0, 281, 223,
	224, 225, 282, 283, 89, 0, 226, 0, 0, 0,
	0, 227, 228, 229, 230, 231, 0, 0, 0, 0,
	92, 93, 0, 94, 0, 0, 0, 0, 232, 0,
	0, 0, 0, 95, 96, 97, 233, 234, 235, 236,
	98, 237, 238, 0, 99, 239, 240, 100, 0, 0,
	241, 242, 243, 0, 101, 244, 0, 0, 0, 102,
	103, 104, 0, 105, 0, 106, 107, 108, 0, 0,
	109, 110, 0, 0, 0, 0, 0, 0, 111, 112,
	85, 113, 245, 114, 246, 247, 0, 115, 0, 116,
	0, 0, 0, 117, 118, 0, 119, 0, 0, 0,
	248, 120, 121, 122, 249, 250, 0, 0, 0, 123,
	124, 251, 0, 125, 0, 126, 0, 0, 0, 0,
	127, 252, 0, 253, 0, 128, 129, 130, 131, 254,
	255, 0, 0, 135, 0, 132, 0, 0, 133, 256,
	134, 257, 258, 259, 0, 260, 0, 0, 136, 0,
	137, 138, 0, 140, 139, 0, 261, 0, 141, 0,
	0, 142, 0, 0, 143, 0, 144, 145, 146, 148,
	262, 147, 0, 149, 150, 152, 151, 0, 0, 0,
	263, 153, 264, 154, 155, 0, 156, 0, 0, 157,
	0, 0, 158, 265, 0, 159, 0, 266, 160, 161,
	162, 163, 0, 267, 164, 268, 165, 0, 166, 167,
	168, 169, 269, 170, 171, 0, 172, 173, 174, 175,
	176, 178, 179, 177, 180, 181, 182, 0, 183, 0,
	184, 185, 270, 186, 0, 190, 191, 192, 193, 0,
	271, 194, 195, 196, 0, 197, 187, 188, 198, 0,
	199, 272, 273, 200, 0, 206, 201, 202, 189, 203,
	205, 274, 204, 275, 0, 207, 84, 208, 209, 210,
	211, 212, 0, 276, 277, 278, 0, 0, 213, 279,
	280, 0, 214, 215, 216, 217, 0, 0, 218, 219,
	220, 221, 0, 222, 0, 281, 223, 224, 225, 282,
	283, 502, 499, 226, 0, 0, 0, 0, 227, 228,
	229, 230, 231, 0, 0, 0, 0, 92, 93, 0,
	94, 0, 0, 0, 0, 232, 88, 0, 0, 0,
	95, 96, 97, 233, 234, 235, 236, 98, 237, 238,
	0, 99, 239, 240, 100, 0, 0, 241, 242, 243,
	0, 101, 244, 0, 318, 0, 102, 103, 104, 0,
	105, 0, 106, 107, 108, 0, 319, 109, 110, 0,
	0, 0, 0, 0, 0, 111, 112, 287, 113, 245,
	114, 246, 247, 0, 115, 0, 116, 0, 0, 0,
	117, 118, 0, 119, 0, 0, 0, 248, 120, 121,
	122, 249, 250, 0, 0, 0, 123, 124, 251, 0,
	125, 0, 126, 0, 0, 320, 0, 127, 252, 0,
	253, 0, 128, 129, 130, 131, 254, 255, 322, 0,
	135, 0, 132, 0, 321, 133, 256, 134, 257, 258,
	259, 0, 260, 0, 323, 136, 324, 137, 138, 0,
	140, 139, 0, 261, 325, 141, 326, 0, 142, 0,
	0, 143, 0, 144, 145, 146, 148, 262, 147, 327,
	149, 150, 152, 151, 0, 0, 0, 263, 153, 264,
	154, 155, 0, 156, 0, 0, 157, 0, 0, 158,
	265, 328, 159, 329, 266, 160, 161, 162, 163, 0,
	267, 164, 268, 165, 0, 166, 167, 168, 169, 269,
	170, 171, 0, 172, 173, 174, 175, 176, 178, 179,
	177, 180, 181, 182, 0, 183, 330, 184, 185, 270,
	186, 0, 190, 191, 192, 193, 0, 271, 194, 195,
	196, 0, 197, 187, 188, 198, 331, 199, 272, 273,
	200, 0, 206, 201, 202, 189, 203, 205, 274, 204,
	275, 0, 207, 0, 208, 209, 210, 211, 212, 0,
	276, 277, 278, 0, 0, 213, 279, 280, 0, 214,
	215, 216, 217, 0, 0, 218, 219, 220, 221, 0,
	222, 0, 281, 223, 224, 225, 282, 283, 89, 0,
	226, 0, 0, 0, 0, 227, 228, 229, 230, 231,
	0, 0, 0, 0, 92, 93, 0, 94, 0, 0,
	0, 0, 232, 0, 0, 0, 0, 95, 96, 97,
	233, 234, 235, 236, 98, 237, 238, 0, 99, 239,
	240, 100, 0, 0, 241, 242, 243, 0, 101, 244,
	0, 0, 0, 102, 103, 104, 0, 105, 0, 106,
	107, 108, 0, 0, 109, 110, 0, 0, 0, 0,
	0, 0, 111, 112, 287, 113, 245, 114, 246, 247,
	0, 115, 0, 116, 0, 0, 0, 117, 118, 0,
	119, 0, 0, 0, 248, 120, 121, 122, 249, 250,
	0, 0, 0, 123, 124, 251, 0, 125, 0, 126,
	0, 0, 0, 0, 127, 252, 0, 253, 0, 128,
	129, 130, 131, 254, 255, 0, 0, 135, 0, 132,
	0, 0, 133, 256, 134, 257, 258, 259, 0, 260,
	0, 0, 136, 0, 137, 138, 0, 140, 139, 0,
	261, 0, 141, 0, 0, 142, 0, 0, 143, 0,
	144, 145, 146, 148, 262, 147, 0, 149, 150, 152,
	151, 0, 0, 0, 263, 153, 264, 154, 155, 0,
	156, 0, 0, 157, 0, 0, 158, 265, 0, 159,
	0, 266, 160, 161, 162, 163, 0, 267, 164, 268,
	165, 0, 166, 167, 168, 169, 269, 170, 171, 0,
	172, 173, 174, 175, 176, 178, 179, 177, 180, 181,
	182, 0, 183, 0, 184, 185, 270, 186, 0, 190,
	191, 192, 193, 0, 271, 194, 195, 196, 0, 197,
	187, 188, 198, 0, 199, 272, 273, 200, 0, 206,
	201, 202, 189, 203, 205, 274, 204, 275, 0, 207,
	0, 208, 209, 210, 211, 212, 0, 276, 277, 278,
	0, 0, 213, 279, 280, 0, 214, 215, 216, 217,
	0, 0, 218, 219, 220, 221, 0, 222, 0, 281,
	223, 224, 225, 282, 283, 502, 0, 226, 0, 0,
	0, 0, 227, 228, 229, 230, 231, 0, 0, 0,
	0, 92, 93, 0, 94, 0, 0, 0, 0, 232,
	88, 0, 0, 0, 95, 96, 97, 233, 234, 235,
	236, 98, 237, 238, 0, 99, 239, 240, 100, 0,
	0, 241, 242, 243, 0, 101, 244, 0, 318, 0,
	102, 103, 104, 0, 105, 0, 106, 107, 108, 0,
	319, 109, 110, 0, 0, 0, 0, 0, 0, 111,
	112, 287, 113, 245, 114, 246, 247, 0, 115, 0,
	116, 0, 0, 0, 117, 118, 0, 119, 0, 0,
	0, 248, 120, 121, 122, 249, 250, 0, 0, 0,
	123, 124, 251, 0, 125, 0, 126, 0, 0, 320,
	0, 127, 252, 0, 253, 0, 128, 129, 130, 131,
	254, 255, 322, 0, 135, 0, 132, 0, 321, 133,
	256, 134, 257, 258, 259, 0, 260, 0, 323, 136,
	324, 137, 138, 0, 140, 139, 0, 261, 325, 141,
	326, 0, 142, 0, 0, 143, 0, 144, 145, 146,
	148, 262, 147, 327, 149, 150, 152, 151, 0, 0,
	0, 263, 153, 264, 154, 155, 0, 156, 0, 0,
	157, 0, 0, 158, 265, 328, 159, 329, 266, 160,
	161, 162, 163, 0, 267, 164, 268, 165, 0, 166,
	167, 168, 169, 269, 170, 171, 0, 172, 173, 174,
	175, 176, 178, 179, 177, 180, 181, 182, 0, 183,
	330, 184, 185, 270, 186, 0, 190, 191, 192, 193,
	0, 271, 194, 195, 196, 0, 197, 187, 188, 198,
	331, 199, 272, 273, 200, 0, 206, 201, 202, 189,
	203, 205, 274, 204, 275, 0, 207, 0, 208, 209,
	210, 211, 212, 0, 276, 277, 278, 0, 0, 213,
	279, 280, 0, 214, 215, 216, 217, 0, 0, 218,
	219, 220, 221, 0, 222, 0, 281, 223, 224, 225,
	282, 283, 89, 0, 226, 0, 0, 0, 0, 227,
	228, 229, 230, 231, 0, 0, 0, 0, 92, 93,
	0, 94, 0, 0, 0, 0, 232, 0, 0, 0,
	0, 95, 96, 97, 233, 234, 235, 236, 98, 237,
	238, 0, 99, 239, 240, 100, 0, 0, 241, 242,
	243, 1094, 101, 244, 0, 0, 0, 102, 103, 104,
	0, 105, 1092, 106, 107, 108, 0, 0, 109, 110,
	0, 0, 0, 0, 0, 0, 111, 112, 287, 113,
	245, 114, 246, 247, 0, 115, 0, 116, 0, 0,
	0, 117, 118, 0, 119, 0, 0, 0, 248, 120,
	121, 122, 249, 250, 0, 1197, 0, 123, 124, 251,
	0, 125, 0, 126, 1097, 0, 0, 0, 127, 252,
	0, 253, 0, 128, 129, 130, 131, 254, 255, 0,
	0, 135, 1195, 132, 0, 0, 133, 256, 134, 257,
	258, 259, 0, 260, 0, 0, 136, 0, 137, 138,
	0, 140, 139, 0, 261, 0, 141, 0, 0, 142,
	0, 0, 143, 0, 144, 145, 146, 148, 262, 147,
	0, 149, 150, 152, 151, 0, 0, 0, 263, 153,
	264, 154, 155, 0, 156, 0, 0, 157, 0, 0,
	158, 265, 0, 159, 0, 266, 160, 161, 162, 163,
	0, 267, 164, 268, 165, 1096, 166, 167, 168, 169,
	269, 170, 171, 0, 172, 173, 174, 175, 176, 178,
	179, 177, 180, 181, 182, 0, 183, 0, 184, 185,
	270, 186, 0, 190, 191, 192, 193, 0, 271, 194,
	195, 196, 0, 197, 187, 188, 198, 0, 199, 272,
	273, 200, 0, 206, 201, 202, 189, 203, 205, 274,
	204, 275, 0, 207, 0, 208, 209, 210, 211, 212,
	0, 276, 277, 278, 0, 0, 213, 279, 280, 0,
	214, 215, 216, 217, 0, 1196, 218, 219, 220, 221,
	0, 222, 0, 281, 223, 224, 225, 282, 283, 89,
	0, 226, 0, 0, 0, 0, 227, 228, 229, 230,
	231, 0, 0, 0, 0, 92, 93, 0, 94, 0,
	0, 0, 0, 232, 0, 0, 0, 0, 95, 96,
	97, 233, 234, 235, 236, 98, 237, 238, 0, 99,
	239, 240, 100, 0, 0, 241, 242, 243, 1094, 101,
	244, 0, 0, 1089, 102, 103, 104, 0, 105, 1092,
	106, 107, 108, 0, 0, 109, 110, 0, 0, 0,
	0, 0, 0, 111, 112, 287, 113, 245, 114, 246,
	247, 0, 115, 0, 116, 0, 0, 0, 117, 118,
	0, 119, 0, 0, 0, 248, 120, 121, 122, 249,
	250, 0, 0, 0, 123, 124, 251, 0, 125, 0,
	126, 1097, 0, 0, 0, 127, 252, 0, 253, 0,
	128, 129, 130, 131, 1088, 255, 0, 0, 135, 0,
	132, 0, 0, 133, 256, 134, 257, 258, 259, 0,
	260, 0, 0, 136, 0, 137, 138, 0, 140, 139,
	0, 261, 0, 141, 0, 0, 142, 0, 0, 143,
	0, 144, 145, 146, 148, 262, 147, 0, 149, 150,
	152, 151, 0, 0, 0, 263, 153, 264, 154, 155,
	0, 156, 0, 0, 157, 0, 0, 158, 265, 0,
	159, 0, 266, 160, 161, 162, 163, 0, 267, 164,
	268, 165, 1096, 166, 167, 168, 169, 269, 170, 171,
	0, 172, 173, 174, 175, 176, 178, 179, 177, 180,
	181, 182, 0, 183, 0, 184, 185, 270, 186, 0,
	190, 191, 192, 193, 0, 271, 194, 195, 196, 0,
	197, 187, 188, 198, 0, 199, 272, 273, 200, 0,
	206, 201, 202, 189, 203, 205, 274, 204, 275, 0,
	207, 0, 208, 209, 210, 211, 212, 0, 276, 277,
	278, 0, 0, 213, 279, 280, 0, 214, 215, 216,
	217, 0, 1095, 218, 219, 220, 221, 0, 222, 0,
	281, 223, 224, 225, 282, 283, 89, 0, 226, 0,
	0, 0, 0, 227, 228, 229, 230, 231, 0, 0,
	0, 0, 92, 93, 0, 94, 0, 0, 0, 0,
	232, 0, 1713, 0, 0, 95, 96, 97, 233, 234,
	235, 236, 98, 237, 238, 0, 99, 239, 240, 100,
	0, 0, 241, 242, 243, 0, 101, 244, 0, 0,
	0, 102, 103, 104, 0, 105, 0, 106, 107, 108,
	0, 0, 109, 110, 0, 0, 0, 0, 0, 0,
	111, 112, 287, 113, 245, 114, 246, 247, 0, 115,
	0, 116, 0, 0, 0, 117, 118, 0, 119, 0,
	0, 0, 248, 120, 121, 122, 249, 250, 0, 0,
	0, 123, 124, 251, 0, 125, 0, 126, 0, 0,
	0, 0, 127, 252, 0, 253, 0, 128, 129, 130,
	131, 254, 255, 0, 0, 135, 0, 132, 0, 0,
	133, 256, 134, 257, 258, 259, 0, 260, 0, 0,
	136, 0, 137, 138, 0, 140, 139, 0, 261, 0,
	141, 0, 0, 142, 0, 0, 143, 0, 144, 145,
	146, 148, 262, 147, 0, 149, 150, 152, 151, 0,
	0, 0, 263, 153, 264, 154, 155, 0, 156, 0,
	0, 157, 0, 0, 158, 265, 0, 159, 0, 266,
	160, 161, 162, 163, 0, 267, 164, 268, 165, 0,
	166, 167, 168, 169, 269, 170, 171, 0, 172, 173,
	174, 175, 176, 178, 179, 177, 180, 181, 182, 0,
	183, 0, 184, 185, 270, 186, 0, 190, 191, 192,
	193, 0, 271, 194, 195, 196, 0, 197, 187, 188,
	198, 0, 199, 272, 273, 200, 0, 206, 201, 202,
	189, 203, 205, 274, 204, 275, 0, 207, 0, 208,
	209, 210, 211, 212, 0, 276, 277, 278, 0, 0,
	213, 279, 280, 0, 214, 215, 216, 217, 0, 0,
	218, 219, 220, 221, 0, 222, 0, 281, 223, 224,
	225, 282, 283, 89, 0, 226, 0, 0, 0, 0,
	227, 228, 229, 230, 231, 0, 0, 0, 0, 92,
	93, 0, 94, 0, 0, 0, 0, 232, 0, 0,
	0, 0, 95, 96, 97, 233, 234, 235, 236, 98,
	237, 238, 0, 99, 239, 240, 100, 0, 0, 241,
	242, 243, 0, 101, 244, 0, 0, 0, 102, 103,
	104, 0, 105, 0, 106, 107, 108, 0, 0, 109,
	110, 0, 0, 0, 0, 0, 0, 111, 112, 287,
	113, 245, 114, 246, 247, 0, 115, 0, 116, 0,
	0, 0, 117, 118, 0, 119, 0, 0, 0, 248,
	120, 121, 122, 249, 250, 0, 0, 0, 123, 124,
	251, 0, 125, 0, 126, 0, 0, 0, 0, 127,
	252, 0, 253, 0, 128, 129, 130, 131, 254, 255,
	0, 0, 135, 0, 132, 0, 0, 133, 256, 134,
	257, 258, 259, 0, 260, 0, 0, 136, 0, 137,
	138, 0, 140, 139, 0, 261, 0, 141, 0, 0,
	142, 0, 0, 143, 0, 144, 145, 146, 148, 262,
	147, 0, 149, 150, 152, 151, 0, 0, 0, 263,
	153, 264, 154, 155, 0, 156, 0, 536, 157, 0,
	0, 158, 265, 0, 159, 0, 266, 160, 161, 162,
	163, 0, 267, 164, 268, 165, 0, 166, 167, 168,
	169, 269, 170, 171, 0, 172, 173, 174, 175, 176,
	178, 179, 177, 180, 181, 182, 0, 183, 0, 184,
	185, 270, 186, 0, 190, 191, 192, 193, 0, 271,
	194, 195, 196, 0, 197, 187, 188, 198, 0, 199,
	272, 273, 200, 0, 206, 201, 202, 189, 203, 205,
	274, 204, 275, 0, 207, 0, 208, 209, 210, 211,
	212, 0, 276, 277, 278, 0, 0, 213, 279, 280,
	0, 214, 215, 216, 217, 0, 0, 218, 219, 220,
	221, 0, 222, 0, 281, 223, 224, 225, 282, 283,
	89, 0, 226, 0, 0, 0, 0, 227, 228, 229,
	230, 231, 0, 0, 0, 0, 92, 93, 924, 94,
	0, 0, 0, 0, 232, 0, 0, 0, 0, 95,
	96, 97, 233, 234, 235, 236, 98, 237, 238, 0,
	99, 239, 240, 100, 0, 0, 241, 242, 243, 0,
	101, 244, 0, 0, 0, 102, 103, 104, 0, 105,
	0, 106, 107, 108, 0, 0, 109, 110, 0, 0,
	0, 0, 0, 0, 111, 112, 287, 113, 245, 114,
	246, 247, 0, 115, 0, 116, 0, 0, 0, 117,
	118, 0, 119, 0, 0, 0, 248, 120, 121, 122,
	249, 250, 0, 0, 0, 123, 124, 251, 0, 125,
	0, 126, 0, 0, 0, 0, 127, 252, 0, 253,
	0, 128, 129, 130, 131, 254, 255, 0, 0, 135,
	0, 132, 0, 0, 133, 256, 134, 257, 258, 259,
	0, 260, 0, 0, 136, 0, 137, 138, 0, 140,
	139, 0, 261, 0, 141, 0, 0, 142, 0, 0,
	143, 0, 144, 145, 146, 148, 262, 147, 0, 149,
	150, 152, 151, 0, 0, 0, 263, 153, 264, 154,
	155, 0, 156, 0, 0, 157, 0, 0, 158, 265,
	0, 159, 0, 266, 160, 161, 162, 163, 0, 267,
	164, 268, 165, 0, 166, 167, 168, 169, 269, 170,
	171, 0, 172, 173, 174, 175, 176, 178, 179, 177,
	180, 181, 182, 0, 183, 0, 184, 185, 270, 186,
	0, 190, 191, 192, 193, 0, 271, 194, 195, 196,
	0, 197, 187, 188, 198, 0, 199, 272, 273, 200,
	0, 206, 201, 202, 189, 203, 205, 274, 204, 275,
	0, 207, 0, 208, 209, 210, 211, 212, 0, 276,
	277, 278, 0, 0, 213, 279, 280, 0, 214, 215,
	216, 217, 0, 0, 218, 219, 220, 221, 0, 222,
	0, 281, 223, 224, 225, 282, 283, 89, 0, 226,
	0, 0, 0, 0, 227, 228, 229, 230, 231, 0,
	0, 0, 0, 92, 93, 0, 94, 0, 0, 0,
	0, 232, 0, 0, 0, 0, 95, 96, 97, 233,
	234, 235, 236, 98, 237, 238, 0, 99, 239, 240,
	100, 0, 0, 241, 242, 243, 0, 101, 244, 0,
	0, 0, 102, 103, 104, 0, 105, 0, 106, 107,
	108, 0, 0, 109, 110, 0, 0, 0, 0, 0,
	0, 111, 112, 287, 113, 245, 114, 246, 247, 0,
	115, 0, 116, 0, 0, 0, 117, 118, 0, 119,
	0, 0, 0, 248, 120, 121, 122, 249, 250, 0,
	0, 0, 123, 124, 251, 0, 125, 0, 126, 0,
	0, 0, 0, 127, 252, 0, 253, 0, 128, 129,
	130, 131, 840, 255, 0, 0, 135, 0, 132, 0,
	0, 133, 256, 134, 257, 258, 259, 0, 260, 0,
	0, 136, 0, 137, 138, 0, 140, 139, 0, 261,
	0, 141, 0, 0, 142, 0, 0, 143, 0, 144,
	145, 146, 148, 262, 147, 0, 149, 150, 152, 151,
	0, 0, 0, 263, 153, 264, 154, 155, 0, 156,
	0, 536, 157, 0, 0, 158, 265, 0, 159, 0,
	266, 160, 161, 162, 163, 0, 267, 164, 268, 165,
	0, 166, 167, 168, 169, 269, 170, 171, 0, 172,
	173, 174, 175, 176, 178, 179, 177, 180, 181, 182,
	0, 183, 0, 184, 185, 270, 186, 0, 190, 191,
	192, 193, 0, 271, 194, 195, 196, 0, 197, 187,
	188, 198, 0, 199, 272, 273, 200, 0, 206, 201,
	202, 189, 203, 205, 274, 204, 275, 0, 207, 0,
	208, 209, 210, 211, 212, 0, 276, 277, 278, 0,
	0, 213, 279, 280, 0, 214, 215, 216, 217, 0,
	0, 218, 219, 220, 221, 0, 222, 0, 281, 223,
	224, 225, 282, 283, 89, 0, 226, 0, 0, 0,
	0, 227, 228, 229, 230, 231, 0, 0, 0, 0,
	92, 93, 590, 94, 0, 0, 0, 0, 232, 0,
	0, 0, 0, 95, 96, 97, 233, 234, 235, 236,
	98, 237, 238, 0, 99, 239, 240, 100, 0, 0,
	241, 242, 243, 0, 101, 244, 0, 0, 0, 102,
	103, 104, 0, 105, 0, 106, 107, 108, 0, 0,
	109, 110, 0, 0, 0, 0, 0, 0, 111, 112,
	287, 113, 245, 114, 246, 247, 0, 115, 0, 116,
	0, 0, 0, 117, 118, 0, 119, 0, 0, 0,
	248, 120, 121, 122, 249, 250, 0, 0, 0, 123,
	124, 251, 0, 125, 0, 126, 0, 0, 0, 0,
	127, 252, 0, 253, 0, 128, 129, 130, 131, 254,
	255, 0, 0, 135, 0, 132, 0, 0, 133, 256,
	134, 257, 258, 259, 0, 260, 0, 0, 136, 0,
	137, 138, 0, 140, 139, 0, 261, 0, 141, 0,
	0, 142, 0, 0, 143, 0, 144, 145, 146, 148,
	262, 147, 0, 149, 150, 152, 151, 0, 0, 0,
	263, 153, 264, 154, 155, 0, 156, 0, 0, 157,
	0, 0, 158, 265, 0, 159, 0, 266, 160, 161,
	162, 163, 0, 267, 164, 268, 165, 0, 166, 167,
	168, 169, 269, 170, 171, 0, 172, 173, 174, 175,
	176, 178, 179, 177, 180, 181, 182, 0, 183, 0,
	184, 185, 270, 186, 0, 190, 191, 192, 193, 0,
	271, 194, 195, 196, 0, 197, 187, 188, 198, 0,
	199, 272, 273, 200, 0, 206, 201, 202, 189, 203,
	205, 274, 204, 275, 0, 207, 0, 208, 209, 210,
	211, 212, 0, 276, 277, 278, 0, 0, 213, 279,
	280, 0, 214, 215, 216, 217, 0, 0, 218, 219,
	220, 221, 0, 222, 0, 281, 223, 224, 225, 282,
	283, 89, 0, 226, 0, 0, 0, 0, 227, 228,
	229, 230, 231, 0, 0, 0, 0, 92, 93, 0,
	94, 0, 0, 0, 0, 232, 0, 0, 0, 0,
	95, 96, 97, 233, 234, 235, 236, 98, 237, 238,
	0, 99, 239, 240, 100, 0, 0, 241, 242, 243,
	0, 101, 244, 0, 0, 0, 102, 103, 104, 0,
	105, 0, 106, 107, 108, 0, 0, 109, 110, 0,
	0, 0, 0, 0, 0, 111, 112, 287, 113, 245,
	114, 246, 247, 0, 115, 0, 116, 0, 0, 0,
	117, 118, 0, 119, 0, 0, 0, 248, 120, 121,
	122, 249, 250, 0, 0, 0, 123, 124, 251, 0,
	125, 0, 126, 0, 0, 0, 0, 127, 252, 0,
	253, 0, 128, 129, 130, 131, 548, 255, 0, 0,
	135, 0, 132, 0, 0, 133, 256, 134, 257, 258,
	259, 0, 260, 0, 0, 136, 0, 137, 138, 0,
	140, 139, 0, 261, 0, 141, 0, 0, 142, 0,
	0, 143, 0, 144, 145, 146, 148, 262, 147, 0,
	149, 150, 152, 151, 0, 0, 0, 263, 153, 264,
	154, 155, 0, 156, 0, 536, 157, 0, 0, 158,
	265, 0, 159, 0, 266, 160, 161, 162, 163, 0,
	267, 164, 268, 165, 0, 166, 167, 168, 169, 269,
	170, 171, 0, 172, 173, 174, 175, 176, 178, 179,
	177, 180, 181, 182, 0, 183, 0, 184, 185, 270,
	186, 0, 190, 191, 192, 193, 0, 271, 194, 195,
	196, 0, 197, 187, 188, 198, 0, 199, 272, 273,
	200, 0, 206, 201, 202, 189, 203, 205, 274, 204,
	275, 0, 207, 0, 208, 209, 210, 211, 212, 0,
	276, 277, 278, 0, 0, 213, 279, 280, 0, 214,
	215, 216, 217, 0, 0, 218, 219, 220, 221, 0,
	222, 0, 281, 223, 224, 225, 282, 283, 89, 0,
	226, 0, 0, 0, 0, 227, 228, 229, 230, 231,
	0, 0, 0, 0, 92, 93, 0, 94, 0, 0,
	0, 0, 232, 0, 0, 0, 0, 95, 96, 97,
	233, 234, 235, 236, 98, 237, 238, 0, 99, 239,
	240, 100, 0, 0, 241, 242, 243, 0, 101, 244,
	0, 0, 0, 102, 103, 104, 0, 105, 0, 106,
	107, 108, 0, 0, 109, 110, 0, 0, 0, 0,
	0, 0, 111, 112, 287, 113, 245, 114, 246, 247,
	0, 115, 0, 116, 0, 0, 0, 117, 118, 0,
	119, 0, 0, 0, 248, 120, 121, 122, 249, 250,
	0, 0, 0, 123, 124, 251, 0, 125, 0, 126,
	0, 0, 0, 0, 127, 252, 0, 253, 0, 128,
	129, 130, 131, 541, 255, 0, 0, 135, 0, 132,
	0, 0, 133, 256, 134, 257, 258, 259, 0, 260,
	0, 0, 136, 0, 137, 138, 0, 140, 139, 0,
	261, 0, 141, 0, 0, 142, 0, 0, 143, 0,
	144, 145, 146, 148, 262, 147, 0, 149, 150, 152,
	151, 0, 0, 0, 263, 153, 264, 154, 155, 0,
	156, 0, 536, 157, 0, 0, 158, 265, 0, 159,
	0, 266, 160, 161, 162, 163, 0, 267, 164, 268,
	165, 0, 166, 167, 168, 169, 269, 170, 171, 0,
	172, 173, 174, 175, 176, 178, 179, 177, 180, 181,
	182, 0, 183, 0, 184, 185, 270, 186, 0, 190,
	191, 192, 193, 0, 271, 194, 195, 196, 0, 197,
	187, 188, 198, 0, 199, 272, 273, 200, 0, 206,
	201, 202, 189, 203, 205, 274, 204, 275, 0, 207,
	0, 208, 209, 210, 211, 212, 0, 276, 277, 278,
	0, 0, 213, 279, 280, 0, 214, 215, 216, 217,
	0, 0, 218, 219, 220, 221, 0, 222, 0, 281,
	223, 224, 225, 282, 283, 89, 0, 226, 0, 0,
	0, 0, 227, 228, 229, 230, 231, 0, 0, 0,
	0, 92, 93, 417, 94, 0, 0, 0, 0, 232,
	0, 0, 0, 0, 95, 96, 97, 233, 234, 235,
	236, 98, 237, 238, 0, 99, 239, 240, 100, 0,
	0, 241, 242, 243, 0, 101, 244, 0, 0, 0,
	102, 103, 104, 0, 105, 0, 106, 107, 108, 0,
	0, 109, 110, 0, 0, 0, 0, 0, 0, 111,
	112, 287, 113, 245, 114, 246, 247, 0, 115, 0,
	116, 0, 0, 0, 117, 118, 0, 119, 0, 0,
	0, 248, 120, 121, 122, 249, 250, 0, 0, 0,
	123, 124, 251, 0, 125, 0, 126, 0, 0, 0,
	0, 127, 252, 0, 253, 0, 128, 129, 130, 131,
	254, 255, 0, 0, 135, 0, 132, 0, 0, 133,
	256, 134, 257, 258, 259, 0, 260, 0, 0, 136,
	0, 137, 138, 0, 140, 139, 0, 261, 0, 141,
	0, 0, 142, 0, 0, 143, 0, 144, 145, 146,
	148, 262, 147, 0, 149, 150, 152, 151, 0, 0,
	0, 263, 153, 264, 154, 155, 0, 156, 0, 0,
	157, 0, 0, 158, 265, 0, 159, 0, 266, 160,
	161, 162, 163, 0, 267, 164, 268, 416, 0, 166,
	167, 168, 169, 269, 170, 171, 0, 172, 173, 174,
	175, 176, 178, 179, 177, 180, 181, 182, 0, 183,
	0, 184, 185, 270, 186, 0, 190, 191, 192, 193,
	0, 271, 194, 195, 196, 0, 197, 187, 188, 198,
	0, 199, 272, 273, 200, 0, 206, 201, 202, 189,
	203, 205, 274, 204, 275, 0, 207, 0, 208, 209,
	210, 211, 212, 0, 276, 277, 278, 0, 0, 213,
	279, 280, 0, 214, 215, 216, 217, 0, 0, 218,
	219, 220, 221, 0, 222, 0, 281, 223, 224, 225,
	282, 283, 89, 0, 226, 0, 0, 0, 0, 227,
	228, 229, 230, 231, 0, 0, 0, 0, 92, 93,
	0, 94, 0, 0, 0, 0, 232, 0, 0, 0,
	0, 95, 96, 97, 233, 234, 235, 236, 98, 237,
	238, 0, 99, 239, 240, 100, 0, 0, 241, 242,
	243, 0, 101, 244, 0, 0, 0, 102, 103, 104,
	0, 105, 0, 106, 107, 108, 0, 0, 109, 110,
	0, 0, 0, 0, 0, 0, 111, 112, 287, 113,
	245, 114, 246, 247, 0, 115, 0, 116, 0, 0,
	0, 117, 118, 0, 119, 0, 0, 0, 248, 120,
	121, 122, 249, 250, 0, 0, 0, 123, 124, 251,
	0, 125, 0, 126, 0, 0, 0, 0, 127, 252,
	0, 253, 0, 128, 129, 130, 131, 254, 255, 0,
	0, 135, 0, 132, 0, 0, 133, 256, 134, 257,
	258, 259, 0, 260, 0, 0, 136, 0, 137, 138,
	0, 140, 139, 0, 261, 0, 141, 0, 0, 142,
	0, 0, 143, 0, 144, 145, 146, 148, 262, 147,
	0, 149, 150, 152, 151, 0, 0, 0, 263, 153,
	264, 154, 155, 0, 156, 0, 0, 157, 0, 0,
	158, 265, 0, 159, 0, 266, 160, 161, 162, 163,
	0, 267, 164, 268, 165, 0, 166, 167, 168, 169,
	269, 170, 171, 0, 172, 173, 174, 175, 176, 178,
	179, 177, 180, 181, 182, 0, 183, 0, 184, 185,
	270, 186, 0, 190, 191, 192, 193, 0, 271, 194,
	195, 196, 0, 197, 187, 188, 198, 0, 199, 272,
	273, 200, 0, 206, 201, 202, 189, 203, 205, 274,
	204, 275, 0, 207, 0, 208, 209, 210, 211, 212,
	0, 276, 277, 278, 0, 0, 213, 279, 280, 0,
	214, 215, 216, 217, 0, 0, 218, 219, 220, 221,
	0, 222, 0, 281, 223, 224, 225, 282, 283, 89,
	0, 226, 0, 0, 0, 0, 227, 228, 229, 230,
	231, 0, 0, 0, 0, 92, 93, 0, 94, 0,
	0, 0, 0, 232, 0, 0, 0, 0, 95, 96,
	97, 233, 234, 235, 236, 98, 237, 238, 0, 99,
	239, 240, 100, 0, 0, 241, 242, 243, 0, 101,
	244, 0, 0, 0, 102, 103, 104, 0, 105, 0,
	106, 107, 108, 0, 0, 109, 110, 0, 0, 0,
	0, 0, 0, 111, 112, 287, 113, 245, 114, 246,
	247, 0, 115, 0, 116, 0, 0, 0, 117, 118,
	0, 119, 0, 0, 0, 248, 120, 121, 122, 249,
	250, 0, 0, 0, 123, 124, 251, 0, 125, 0,
	126, 0, 0, 0, 0, 127, 252, 0, 253, 0,
	128, 129, 130, 131, 1394, 255, 0, 0, 135, 0,
	132, 0, 0, 133, 256, 134, 257, 258, 259, 0,
	260, 0, 0, 136, 0, 137, 138, 0, 140, 139,
	0, 261, 0, 141, 0, 0, 142, 0, 0, 143,
	0, 144, 145, 146, 148, 262, 147, 0, 149, 150,
	152, 151, 0, 0, 0, 263, 153, 264, 154, 155,
	0, 156, 0, 0, 157, 0, 0, 158, 265, 0,
	159, 0, 266, 160, 161, 162, 163, 0, 267, 164,
	268, 165, 0, 166, 167, 168, 169, 269, 170, 171,
	0, 172, 173, 174, 175, 176, 178, 179, 177, 180,
	181, 182, 0, 183, 0, 184, 185, 270, 186, 0,
	190, 191, 192, 193, 0, 271, 194, 195, 196, 0,
	197, 187, 188, 198, 0, 199, 272, 273, 200, 0,
	206, 201, 202, 189, 203, 205, 274, 204, 275, 0,
	207, 0, 208, 209, 210, 211, 212, 0, 276, 277,
	278, 0, 0, 213, 279, 280, 0, 214, 215, 216,
	217, 0, 0, 218, 219, 220, 221, 0, 222, 0,
	281, 223, 224, 225, 282, 283, 89, 0, 226, 0,
	0, 0, 0, 227, 228, 229, 230, 231, 0, 0,
	0, 0, 92, 93, 0, 94, 0, 0, 0, 0,
	232, 0, 0, 0, 0, 95, 96, 97, 233, 234,
	235, 236, 98, 237, 238, 0, 99, 239, 240, 100,
	0, 0, 241, 242, 243, 0, 101, 244, 0, 0,
	0, 102, 103, 104, 0, 105, 0, 106, 107, 108,
	0, 0, 109, 110, 0, 0, 0, 0, 0, 0,
	111, 112, 287, 113, 245, 114, 246, 247, 0, 115,
	0, 116, 0, 0, 0, 117, 118, 0, 119, 0,
	0, 0, 248, 120, 121, 122, 249, 250, 0, 0,
	0, 123, 124, 251, 0, 125, 0, 126, 0, 0,
	0, 0, 127, 252, 0, 253, 0, 128, 129, 130,
	131, 1392, 255, 0, 0, 135, 0, 132, 0, 0,
	133, 256, 134, 257, 258, 259, 0, 260, 0, 0,
	136, 0, 137, 138, 0, 140, 139, 0, 261, 0,
	141, 0, 0, 142, 0, 0, 143, 0, 144, 145,
	146, 148, 262, 147, 0, 149, 150, 152, 151, 0,
	0, 0, 263, 153, 264, 154, 155, 0, 156, 0,
	0, 157, 0, 0, 158, 265, 0, 159, 0, 266,
	160, 161, 162, 163, 0, 267, 164, 268, 165, 0,
	166, 167, 168, 169, 269, 170, 171, 0, 172, 173,
	174, 175, 176, 178, 179, 177, 180, 181, 182, 0,
	183, 0, 184, 185, 270, 186, 0, 190, 191, 192,
	193, 0, 271, 194, 195, 196, 0, 197, 187, 188,
	198, 0, 199, 272, 273, 200, 0, 206, 201, 202,
	189, 203, 205, 274, 204, 275, 0, 207, 0, 208,
	209, 210, 211, 212, 0, 276, 277, 278, 0, 0,
	213, 279, 280, 0, 214, 215, 216, 217, 0, 0,
	218, 219, 220, 221, 0, 222, 0, 281, 223, 224,
	225, 282, 283, 89, 0, 226, 0, 0, 0, 0,
	227, 228, 229, 230, 231, 0, 0, 0, 0, 92,
	93, 0, 94, 0, 0, 0, 0, 232, 0, 0,
	0, 0, 95, 96, 97, 233, 234, 235, 236, 98,
	237, 238, 0, 99, 239, 240, 100, 0, 0, 241,
	242, 243, 0, 101, 244, 0, 0, 0, 102, 103,
	104, 0, 105, 0, 106, 107, 108, 0, 0, 109,
	110, 0, 0, 0, 0, 0, 0, 111, 112, 287,
	113, 245, 114, 246, 247, 0, 115, 0, 116, 0,
	0, 0, 117, 118, 0, 119, 0, 0, 0, 248,
	120, 121, 122, 249, 250, 0, 0, 0, 123, 124,
	251, 0, 125, 0, 126, 0, 0, 0, 0, 127,
	252, 0, 253, 0, 128, 129, 130, 131, 1381, 255,
	0, 0, 135, 0, 132, 0, 0, 133, 256, 134,
	257, 258, 259, 0, 260, 0, 0, 136, 0, 137,
	138, 0, 140, 139, 0, 261, 0, 141, 0, 0,
	142, 0, 0, 143, 0, 144, 145, 146, 148, 262,
	147, 0, 149, 150, 152, 151, 0, 0, 0, 263,
	153, 264, 154, 155, 0, 156, 0, 0, 157, 0,
	0, 158, 265, 0, 159, 0, 266, 160, 161, 162,
	163, 0, 267, 164, 268, 165, 0, 166, 167, 168,
	169, 269, 170, 171, 0, 172, 173, 174, 175, 176,
	178, 179, 177, 180, 181, 182, 0, 183, 0, 184,
	185, 270, 186, 0, 190, 191, 192, 193, 0, 271,
	194, 195, 196, 0, 197, 187, 188, 198, 0, 199,
	272, 273, 200, 0, 206, 201, 202, 189, 203, 205,
	274, 204, 275, 0, 207, 0, 208, 209, 210, 211,
	212, 0, 276, 277, 278, 0, 0, 213, 279, 280,
	0, 214, 215, 216, 217, 0, 0, 218, 219, 220,
	221, 0, 222, 0, 281, 223, 224, 225, 282, 283,
	89, 0, 226, 0, 0, 0, 0, 227, 228, 229,
	230, 231, 0, 0, 0, 0, 92, 93, 0, 94,
	0, 0, 0, 0, 232, 0, 0, 0, 0, 95,
	96, 97, 233, 234, 235, 236, 98, 237, 238, 0,
	99, 239, 240, 100, 0, 0, 241, 242, 243, 0,
	101, 244, 0, 0, 0, 102, 103, 104, 0, 105,
	0, 106, 107, 108, 0, 0, 109, 110, 0, 0,
	0, 0, 0, 0, 111, 112, 287, 113, 245, 114,
	246, 247, 0, 115, 0, 116, 0, 0, 0, 117,
	118, 0, 119, 0, 0, 0, 248, 120, 121, 122,
	249, 250, 0, 0, 0, 123, 124, 251, 0, 125,
	0, 126, 0, 0, 0, 0, 127, 252, 0, 253,
	0, 128, 129, 130, 131, 952, 255, 0, 0, 135,
	0, 132, 0, 0, 133, 256, 134, 257, 258, 259,
	0, 260, 0, 0, 136, 0, 137, 138, 0, 140,
	139, 0, 261, 0, 141, 0, 0, 142, 0, 0,
	143, 0, 144, 145, 146, 148, 262, 147, 0, 149,
	150, 152, 151, 0, 0, 0, 263, 153, 264, 154,
	155, 0, 156, 0, 0, 157, 0, 0, 158, 265,
	0, 159, 0, 266, 160, 161, 162, 163, 0, 267,
	164, 268, 165, 0, 166, 167, 168, 169, 269, 170,
	171, 0, 172, 173, 174, 175, 176, 178, 179, 177,
	180, 181, 182, 0, 183, 0, 184, 185, 270, 186,
	0, 190, 191, 192, 193, 0, 271, 194, 195, 196,
	0, 197, 187, 188, 198, 0, 199, 272, 273, 200,
	0, 206, 201, 202, 189, 203, 205, 274, 204, 275,
	0, 207, 0, 208, 209, 210, 211, 212, 0, 276,
	277, 278, 0, 0, 213, 279, 280, 0, 214, 215,
	216, 217, 0, 0, 218, 219, 220, 221, 0, 222,
	0, 281, 223, 224, 225, 282, 283, 89, 0, 226,
	0, 0, 0, 0, 227, 228, 229, 230, 231, 0,
	0, 0, 0, 92, 93, 0, 94, 0, 0, 0,
	0, 232, 0, 0, 0, 0, 95, 96, 97, 233,
	234, 235, 236, 98, 237, 238, 0, 99, 239, 240,
	100, 0, 0, 241, 242, 243, 0, 101, 244, 0,
	0, 0, 102, 103, 104, 0, 105, 0, 106, 107,
	108, 0, 0, 109, 110, 0, 0, 0, 0, 0,
	0, 111, 112, 287, 113, 245, 114, 246, 247, 0,
	115, 0, 116, 0, 0, 0, 117, 118, 0, 119,
	0, 0, 0, 248, 120, 121, 122, 249, 250, 0,
	0, 0, 123, 124, 251, 0, 125, 0, 126, 0,
	0, 0, 0, 127, 252, 0, 253, 0, 128, 129,
	130, 131, 254, 255, 0, 0, 135, 0, 132, 0,
	0, 133, 256, 134, 257, 258, 259, 0, 260, 0,
	0, 136, 0, 137, 138, 0, 140, 139, 0, 261,
	0, 141, 0, 0, 142, 0, 0, 143, 0, 144,
	145, 146, 148, 262, 147, 0, 149, 150, 152, 151,
	0, 0, 0, 263, 153, 264, 154, 155, 0, 156,
	0, 0, 157, 0, 0, 158, 265, 0, 159, 0,
	266, 160, 161, 162, 163, 0, 267, 164, 268, 165,
	0, 166, 167, 168, 169, 269, 170, 171, 0, 172,
	173, 174, 175, 176, 178, 179, 177, 180, 181, 182,
	0, 183, 0, 184, 185, 270, 186, 0, 431, 191,
	192, 193, 0, 271, 194, 195, 196, 0, 197, 187,
	188, 198, 0, 199, 272, 273, 200, 0, 206, 201,
	202, 189, 203, 205, 274, 204, 275, 0, 207, 0,
	208, 209, 210, 211, 212, 0, 276, 277, 278, 0,
	0, 213, 279, 280, 0, 214, 215, 216, 217, 0,
	0, 218, 219, 220, 221, 0, 222, 0, 281, 223,
	224, 225, 282, 283, 89, 0, 226, 0, 0, 0,
	0, 227, 228, 229, 230, 231, 0, 0, 0, 0,
	92, 93, 0, 94, 0, 0, 0, 0, 232, 0,
	825, 0, 0, 95, 96, 97, 233, 234, 235, 236,
	98, 237, 238, 0, 99, 239, 240, 100, 0, 0,
	241, 242, 243, 0, 101, 244, 0, 0, 0, 102,
	103, 104, 0, 105, 0, 106, 107, 108, 0, 0,
	109, 110, 0, 0, 0, 0, 0, 0, 111, 112,
	287, 113, 245, 114, 246, 247, 0, 115, 0, 116,
	0, 0, 0, 117, 118, 0, 119, 0, 0, 0,
	248, 120, 121, 122, 249, 250, 0, 0, 0, 123,
	124, 251, 0, 125, 0, 126, 0, 0, 0, 0,
	127, 252, 0, 253, 0, 128, 129, 130, 131, 254,
	255, 0, 0, 135, 0, 132, 0, 0, 133, 256,
	134, 257, 258, 259, 0, 260, 0, 0, 136, 0,
	137, 138, 0, 140, 139, 0, 261, 0, 141, 0,
	0, 142, 0, 0, 143, 0, 144, 145, 146, 148,
	262, 147, 0, 149, 150, 152, 151, 0, 0, 0,
	263, 153, 264, 154, 155, 0, 156, 0, 0, 157,
	0, 0, 158, 265, 0, 159, 0, 266, 160, 161,
	162, 163, 0, 267, 164, 268, 165, 0, 166, 167,
	168, 169, 269, 170, 171, 0, 172, 173, 174, 175,
	176, 178, 179, 177, 180, 181, 182, 0, 183, 0,
	184, 185, 270, 186, 0, 190, 191, 192, 193, 0,
	271, 194, 195, 196, 0, 0, 187, 188, 198, 0,
	199, 272, 273, 200, 0, 206, 201, 202, 189, 203,
	205, 274, 204, 275, 0, 207, 0, 208, 209, 210,
	211, 212, 0, 276, 277, 278, 0, 0, 213, 279,
	280, 0, 214, 215, 216, 217, 0, 0, 218, 219,
	220, 221, 0, 222, 0, 281, 223, 224, 225, 282,
	283, 89, 0, 226, 0, 0, 0, 0, 227, 228,
	229, 230, 231, 0, 0, 0, 0, 92, 93, 0,
	94, 0, 0, 0, 0, 232, 0, 0, 0, 0,
	95, 96, 97, 233, 234, 235, 236, 98, 237, 238,
	0, 99, 239, 240, 100, 0, 0, 241, 242, 243,
	0, 101, 244, 0, 0, 0, 102, 103, 104, 0,
	105, 0, 106, 107, 108, 0, 0, 109, 110, 0,
	0, 0, 0, 0, 0, 111, 112, 287, 113, 245,
	114, 246, 247, 0, 115, 0, 116, 0, 0, 0,
	117, 118, 0, 119, 0, 0, 0, 248, 120, 121,
	122, 249, 250, 0, 0, 0, 123, 124, 251, 0,
	125, 0, 126, 0, 0, 0, 0, 127, 252, 0,
	253, 0, 128, 129, 130, 131, 659, 255, 0, 0,
	135, 0, 132, 0, 0, 133, 256, 134, 257, 258,
	259, 0, 260, 0, 0, 136, 0, 137, 138, 0,
	140, 139, 0, 261, 0, 141, 0, 0, 142, 0,
	0, 143, 0, 144, 145, 146, 148, 262, 147, 0,
	149, 150, 152, 151, 0, 0, 0, 263, 153, 264,
	154, 155, 0, 156, 0, 0, 157, 0, 0, 158,
	265, 0, 159, 0, 266, 160, 161, 162, 163, 0,
	267, 164, 268, 165, 0, 166, 167, 168, 169, 269,
	170, 171, 0, 172, 173, 174, 175, 176, 178, 179,
	177, 180, 181, 182, 0, 183, 0, 184, 185, 270,
	186, 0, 190, 191, 192, 193, 0, 271, 194, 195,
	196, 0, 197, 187, 188, 198, 0, 199, 272, 273,
	200, 0, 206, 201, 202, 189, 203, 205, 274, 204,
	275, 0, 207, 0, 208, 209, 210, 211, 212, 0,
	276, 277, 278, 0, 0, 213, 279, 280, 0, 214,
	215, 216, 217, 0, 0, 218, 219, 220, 221, 0,
	222, 0, 281, 223, 224, 225, 282, 283, 89, 0,
	226, 0, 0, 0, 0, 227, 228, 229, 230, 231,
	0, 0, 0, 0, 92, 93, 0, 94, 0, 0,
	0, 0, 232, 0, 0, 0, 0, 95, 96, 97,
	233, 234, 235, 236, 98, 237, 238, 0, 99, 239,
	240, 100, 0, 0, 241, 242, 243, 0, 101, 244,
	0, 0, 0, 102, 103, 104, 0, 105, 0, 106,
	107, 108, 0, 0, 109, 110, 0, 0, 0, 0,
	0, 0, 111, 112, 287, 113, 245, 114, 246, 247,
	0, 115, 0, 116, 0, 0, 0, 117, 118, 0,
	119, 0, 0, 0, 248, 120, 121, 122, 249, 250,
	0, 0, 0, 123, 124, 251, 0, 125, 0, 126,
	0, 0, 0, 0, 127, 252, 0, 253, 0, 128,
	129, 130, 131, 654, 255, 0, 0, 135, 0, 132,
	0, 0, 133, 256, 134, 257, 258, 259, 0, 260,
	0, 0, 136, 0, 137, 138, 0, 140, 139, 0,
	261, 0, 141, 0, 0, 142, 0, 0, 143, 0,
	144, 145, 146, 148, 262, 147, 0, 149, 150, 152,
	151, 0, 0, 0, 263, 153, 264, 154, 155, 0,
	156, 0, 0, 157, 0, 0, 158, 265, 0, 159,
	0, 266, 160, 161, 162, 163, 0, 267, 164, 268,
	165, 0, 166, 167, 168, 169, 269, 170, 171, 0,
	172, 173, 174, 175, 176, 178, 179, 177, 180, 181,
	182, 0, 183, 0, 184, 185, 270, 186, 0, 190,
	191, 192, 193, 0, 271, 194, 195, 196, 0, 197,
	187, 188, 198, 0, 199, 272, 273, 200, 0, 206,
	201, 202, 189, 203, 205, 274, 204, 275, 0, 207,
	0, 208, 209, 210, 211, 212, 0, 276, 277, 278,
	0, 0, 213, 279, 280, 0, 214, 215, 216, 217,
	0, 0, 218, 219, 220, 221, 0, 222, 0, 281,
	223, 224, 225, 282, 283, 89, 0, 226, 0, 0,
	0, 0, 227, 228, 229, 230, 231, 0, 0, 0,
	0, 92, 93, 0, 94, 0, 0, 0, 0, 232,
	0, 0, 0, 0, 95, 96, 97, 233, 234, 235,
	236, 98, 237, 238, 0, 99, 239, 240, 100, 0,
	0, 241, 242, 596, 0, 101, 244, 0, 0, 0,
	102, 103, 104, 0, 105, 0, 106, 107, 108, 0,
	0, 109, 110, 0, 0, 0, 0, 0, 0, 111,
	112, 287, 113, 245, 114, 246, 247, 0, 115, 0,
	116, 0, 0, 0, 117, 118, 0, 119, 0, 0,
	0, 248, 120, 121, 122, 249, 250, 0, 0, 0,
	123, 124, 251, 0, 125, 0, 126, 0, 0, 0,
	0, 127, 252, 0, 253, 0, 128, 129, 130, 131,
	254, 255, 0, 0, 135, 0, 132, 0, 0, 133,
	256, 134, 257, 258, 259, 0, 260, 0, 0, 136,
	0, 137, 138, 0, 140, 139, 0, 261, 0, 141,
	0, 0, 142, 0, 0, 143, 0, 144, 145, 146,
	148, 262, 445, 0, 149, 150, 152, 151, 0, 0,
	0, 263, 153, 264, 154, 155, 0, 156, 0, 0,
	157, 0, 0, 158, 265, 0, 159, 0, 266, 160,
	161, 162, 163, 0, 267, 164, 268, 165, 0, 166,
	167, 168, 169, 269, 170, 171, 0, 172, 173, 174,
	175, 176, 178, 179, 177, 180, 181, 182, 0, 183,
	0, 184, 185, 270, 186, 0, 190, 191, 192, 193,
	0, 271, 194, 195, 196, 0, 197, 187, 188, 198,
	0, 199, 272, 273, 200, 0, 206, 201, 202, 189,
	203, 205, 274, 204, 275, 0, 207, 0, 208, 209,
	210, 211, 212, 0, 442, 277, 278, 0, 0, 438,
	279, 280, 0, 214, 215, 216, 217, 0, 0, 218,
	219, 220, 221, 0, 222, 0, 281, 223, 224, 225,
	282, 283, 89, 0, 226, 0, 0, 0, 0, 227,
	228, 229, 230, 231, 0, 0, 0, 0, 92, 93,
	0, 94, 0, 0, 0, 0, 232, 0, 0, 0,
	0, 95, 96, 97, 233, 234, 235, 236, 98, 237,
	238, 0, 99, 239, 240, 100, 0, 0, 241, 242,
	243, 0, 101, 244, 0, 0, 0, 102, 103, 104,
	0, 105, 0, 106, 107, 108, 0, 0, 109, 110,
	0, 0, 0, 0, 0, 0, 111, 112, 287, 113,
	245, 114, 246, 247, 0, 115, 0, 116, 0, 0,
	0, 117, 118, 0, 119, 0, 0, 0, 248, 120,
	121, 122, 249, 250, 0, 0, 0, 123, 124, 251,
	0, 125, 0, 126, 0, 0, 0, 0, 127, 252,
	0, 253, 0, 128, 129, 130, 131, 254, 255, 0,
	0, 135, 0, 132, 0, 0, 133, 256, 134, 257,
	258, 259, 0, 260, 0, 0, 136, 0, 137, 138,
	0, 140, 139, 0, 261, 0, 141, 0, 0, 142,
	0, 0, 143, 0, 144, 145, 146, 148, 262, 445,
	0, 149, 150, 152, 151, 0, 0, 0, 263, 153,
	264, 154, 155, 0, 156, 0, 0, 157, 0, 0,
	158, 265, 0, 159, 0, 266, 160, 161, 162, 163,
	0, 267, 164, 268, 165, 0, 166, 167, 168, 169,
	269, 170, 171, 0, 172, 173, 174, 175, 176, 178,
	179, 177, 180, 181, 182, 0, 183, 0, 184, 185,
	270, 186, 0, 190, 191, 192, 193, 0, 271, 194,
	195, 196, 0, 197, 187, 188, 198, 0, 199, 272,
	273, 200, 0, 206, 201, 202, 189, 203, 205, 274,
	204, 275, 0, 207, 0, 208, 209, 210, 211, 212,
	0, 442, 277, 278, 0, 0, 438, 279, 280, 0,
	214, 215, 216, 217, 0, 0, 218, 219, 220, 221,
	0, 222, 0, 281, 223, 224, 225, 282, 283, 89,
	0, 226, 0, 0, 0, 0, 227, 228, 229, 230,
	231, 0, 0, 0, 0, 92, 93, 0, 94, 0,
	0, 0, 0, 232, 0, 0, 0, 0, 95, 96,
	97, 233, 234, 235, 236, 98, 237, 238, 0, 99,
	239, 240, 100, 0, 0, 241, 242, 243, 0, 101,
	244, 0, 0, 0, 102, 103, 104, 0, 105, 0,
	106, 107, 108, 0, 0, 109, 110, 0, 0, 0,
	0, 0, 0, 111, 112, 287, 113, 245, 114, 246,
	247, 0, 115, 0, 116, 0, 0, 0, 117, 118,
	0, 119, 0, 0, 0, 248, 120, 121, 122, 249,
	250, 0, 0, 0, 123, 124, 251, 0, 125, 0,
	126, 0, 0, 0, 0, 127, 252, 0, 253, 0,
	128, 129, 130, 131, 578, 255, 0, 0, 135, 0,
	132, 0, 0, 133, 256, 134, 257, 258, 259, 0,
	260, 0, 0, 136, 0, 137, 138, 0, 140, 139,
	0, 261, 0, 141, 0, 0, 142, 0, 0, 143,
	0, 144, 145, 146, 148, 262, 147, 0, 149, 150,
	152, 151, 0, 0, 0, 263, 153, 264, 154, 155,
	0, 156, 0, 0, 157, 0, 0, 158, 265, 0,
	159, 0, 266, 160, 161, 162, 163, 0, 267, 164,
	268, 165, 0, 166, 167, 168, 169, 269, 170, 171,
	0, 172, 173, 174, 175, 176, 178, 179, 177, 180,
	181, 182, 0, 183, 0, 184, 185, 270, 186, 0,
	190, 191, 192, 193, 0, 271, 194, 195, 196, 0,
	197, 187, 188, 198, 0, 199, 272, 273, 200, 0,
	206, 201, 202, 189, 203, 205, 274, 204, 275, 0,
	207, 0, 208, 209, 210, 211, 212, 0, 276, 277,
	278, 0, 0, 213, 279, 280, 0, 214, 215, 216,
	217, 0, 0, 218, 219, 220, 221, 0, 222, 0,
	281, 223, 224, 225, 282, 283, 89, 0, 226, 0,
	0, 0, 0, 227, 228, 229, 230, 231, 0, 0,
	0, 0, 92, 93, 0, 94, 0, 0, 0, 0,
	232, 0, 0, 0, 0, 95, 96, 97, 233, 234,
	235, 236, 98, 237, 238, 0, 99, 239, 240, 100,
	0, 0, 241, 242, 243, 0, 101, 244, 0, 0,
	0, 102, 103, 104, 0, 105, 0, 106, 107, 108,
	0, 0, 109, 110, 0, 0, 0, 0, 0, 0,
	111, 112, 287, 113, 245, 114, 246, 247, 0, 115,
	0, 116, 0, 0, 0, 117, 118, 0, 119, 0,
	0, 0, 248, 120, 121, 122, 249, 250, 0, 0,
	0, 123, 124, 251, 0, 125, 0, 126, 0, 0,
	0, 0, 127, 252, 0, 253, 0, 128, 129, 130,
	131, 575, 255, 0, 0, 135, 0, 132, 0, 0,
	133, 256, 134, 257, 258, 259, 0, 260, 0, 0,
	136, 0, 137, 138, 0, 140, 139, 0, 261, 0,
	141, 0, 0, 142, 0, 0, 143, 0, 144, 145,
	146, 148, 262, 147, 0, 149, 150, 152, 151, 0,
	0, 0, 263, 153, 264, 154, 155, 0, 156, 0,
	0, 157, 0, 0, 158, 265, 0, 159, 0, 266,
	160, 161, 162, 163, 0, 267, 164, 268, 165, 0,
	166, 167, 168, 169, 269, 170, 171, 0, 172, 173,
	174, 175, 176, 178, 179, 177, 180, 181, 182, 0,
	183, 0, 184, 185, 270, 186, 0, 190, 191, 192,
	193, 0, 271, 194, 195, 196, 0, 197, 187, 188,
	198, 0, 199, 272, 273, 200, 0, 206, 201, 202,
	189, 203, 205, 274, 204, 275, 0, 207, 0, 208,
	209, 210, 211, 212, 0, 276, 277, 278, 0, 0,
	213, 279, 280, 0, 214, 215, 216, 217, 0, 0,
	218, 219, 220, 221, 0, 222, 0, 281, 223, 224,
	225, 282, 283, 89, 0, 226, 0, 0, 0, 0,
	227, 228, 229, 230, 231, 0, 0, 0, 0, 92,
	93, 0, 94, 0, 0, 0, 0, 232, 0, 0,
	0, 0, 95, 96, 97, 233, 234, 235, 236, 98,
	237, 238, 0, 99, 239, 240, 100, 0, 0, 241,
	242, 243, 0, 101, 244, 0, 0, 0, 102, 103,
	104, 0, 105, 0, 106, 107, 108, 0, 0, 109,
	110, 0, 0, 0, 0, 0, 0, 111, 112, 287,
	113, 245, 114, 246, 247, 0, 115, 0, 116, 0,
	0, 0, 117, 118, 0, 119, 0, 0, 0, 248,
	120, 121, 122, 249, 250, 0, 0, 0, 123, 124,
	251, 0, 125, 0, 126, 0, 0, 0, 0, 127,
	252, 0, 253, 0, 128, 129, 130, 131, 572, 255,
	0, 0, 135, 0, 132, 0, 0, 133, 256, 134,
	257, 258, 259, 0, 260, 0, 0, 136, 0, 137,
	138, 0, 140, 139, 0, 261, 0, 141, 0, 0,
	142, 0, 0, 143, 0, 144, 145, 146, 148, 262,
	147, 0, 149, 150, 152, 151, 0, 0, 0, 263,
	153, 264, 154, 155, 0, 156, 0, 0, 157, 0,
	0, 158, 265, 0, 159, 0, 266, 160, 161, 162,
	163, 0, 267, 164, 268, 165, 0, 166, 167, 168,
	169, 269, 170, 171, 0, 172, 173, 174, 175, 176,
	178, 179, 177, 180, 181, 182, 0, 183, 0, 184,
	185, 270, 186, 0, 190, 191, 192, 193, 0, 271,
	194, 195, 196, 0, 197, 187, 188, 198, 0, 199,
	272, 273, 200, 0, 206, 201, 202, 189, 203, 205,
	274, 204, 275, 0, 207, 0, 208, 209, 210, 211,
	212, 0, 276, 277, 278, 0, 0, 213, 279, 280,
	0, 214, 215, 216, 217, 0, 0, 218, 219, 220,
	221, 0, 222, 0, 281, 223, 224, 225, 282, 283,
	89, 0, 226, 0, 0, 0, 0, 227, 228, 229,
	230, 231, 0, 0, 0, 0, 92, 93, 0, 94,
	0, 0, 0, 0, 232, 0, 0, 0, 0, 95,
	96, 97, 233, 234, 235, 236, 98, 237, 238, 0,
	99, 239, 240, 100, 0, 0, 241, 242, 243, 0,
	101, 244, 0, 0, 0, 102, 103, 104, 0, 105,
	0, 106, 107, 108, 0, 0, 109, 110, 0, 0,
	0, 0, 0, 0, 111, 112, 287, 113, 245, 114,
	246, 247, 0, 115, 0, 116, 0, 0, 0, 117,
	118, 0, 119, 0, 0, 0, 248, 120, 121, 122,
	249, 250, 0, 0, 0, 123, 124, 251, 0, 125,
	0, 126, 0, 0, 0, 0, 127, 252, 0, 253,
	0, 128, 129, 130, 131, 570, 255, 0, 0, 135,
	0, 132, 0, 0, 133, 256, 134, 257, 258, 259,
	0, 260, 0, 0, 136, 0, 137, 138, 0, 140,
	139, 0, 261, 0, 141, 0, 0, 142, 0, 0,
	143, 0, 144, 145, 146, 148, 262, 147, 0, 149,
	150, 152, 151, 0, 0, 0, 263, 153, 264, 154,
	155, 0, 156, 0, 0, 157, 0, 0, 158, 265,
	0, 159, 0, 266, 160, 161, 162, 163, 0, 267,
	164, 268, 165, 0, 166, 167, 168, 169, 269, 170,
	171, 0, 172, 173, 174, 175, 176, 178, 179, 177,
	180, 181, 182, 0, 183, 0, 184, 185, 270, 186,
	0, 190, 191, 192, 193, 0, 271, 194, 195, 196,
	0, 197, 187, 188, 198, 0, 199, 272, 273, 200,
	0, 206, 201, 202, 189, 203, 205, 274, 204, 275,
	0, 207, 0, 208, 209, 210, 211, 212, 0, 276,
	277, 278, 0, 0, 213, 279, 280, 0, 214, 215,
	216, 217, 0, 0, 218, 219, 220, 221, 0, 222,
	0, 281, 223, 224, 225, 282, 283, 89, 0, 226,
	0, 0, 0, 0, 227, 228, 229, 230, 231, 0,
	0, 0, 0, 92, 93, 0, 94, 0, 0, 0,
	0, 232, 0, 0, 0, 0, 95, 96, 97, 233,
	234, 235, 236, 98, 237, 238, 0, 99, 239, 240,
	100, 0, 0, 241, 242, 243, 0, 101, 244, 0,
	0, 0, 102, 103, 104, 0, 105, 0, 106, 107,
	108, 0, 0, 109, 110, 0, 0, 0, 0, 0,
	0, 111, 112, 287, 113, 245, 114, 246, 247, 0,
	115, 0, 116, 0, 0, 0, 117, 118, 0, 119,
	0, 0, 0, 248, 120, 121, 122, 249, 250, 0,
	0, 0, 123, 124, 251, 0, 125, 0, 126, 0,
	0, 0, 0, 127, 252, 0, 253, 0, 128, 129,
	130, 131, 544, 255, 0, 0, 135, 0, 132, 0,
	0, 133, 256, 134, 257, 258, 259, 0, 260, 0,
	0, 136, 0, 137, 138, 0, 140, 139, 0, 261,
	0, 141, 0, 0, 142, 0, 0, 143, 0, 144,
	145, 146, 148, 262, 147, 0, 149, 150, 152, 151,
	0, 0, 0, 263, 153, 264, 154, 155, 0, 156,
	0, 0, 157, 0, 0, 158, 265, 0, 159, 0,
	266, 160, 161, 162, 163, 0, 267, 164, 268, 165,
	0, 166, 167, 168, 169, 269, 170, 171, 0, 172,
	173, 174, 175, 176, 178, 179, 177, 180, 181, 182,
	0, 183, 0, 184, 185, 270, 186, 0, 190, 191,
	192, 193, 0, 271, 194, 195, 196, 0, 197, 187,
	188, 198, 0, 199, 272, 273, 200, 0, 206, 201,
	202, 189, 203, 205, 274, 204, 275, 0, 207, 0,
	208, 209, 210, 211, 212, 0, 276, 277, 278, 0,
	0, 213, 279, 280, 0, 214, 215, 216, 217, 0,
	0, 218, 219, 220, 221, 0, 222, 0, 281, 223,
	224, 225, 282, 283, 89, 0, 226, 0, 0, 0,
	0, 227, 228, 229, 230, 231, 0, 0, 0, 0,
	92, 93, 0, 94, 0, 0, 0, 0, 232, 0,
	0, 0, 0, 95, 96, 97, 233, 234, 235, 236,
	98, 237, 238, 0, 99, 239, 240, 100, 0, 0,
	241, 242, 243, 0, 101, 244, 0, 0, 0, 102,
	103, 104, 0, 105, 0, 106, 107, 108, 0, 0,
	109, 110, 0, 0, 0, 0, 0, 0, 111, 112,
	287, 113, 245, 114, 246, 247, 0, 115, 0, 116,
	0, 0, 0, 117, 118, 0, 119, 0, 0, 0,
	248, 120, 121, 122, 249, 250, 0, 0, 0, 123,
	124, 251, 0, 125, 0, 126, 0, 0, 0, 0,
	127, 252, 0, 253, 0, 128, 129, 130, 131, 254,
	255, 0, 0, 135, 0, 132, 0, 0, 133, 256,
	134, 257, 258, 259, 0, 260, 0, 0, 136, 0,
	137, 138, 0, 140, 139, 0, 261, 0, 141, 0,
	0, 142, 0, 0, 143, 0, 144, 145, 146, 148,
	262, 147, 0, 149, 150, 152, 151, 0, 0, 0,
	263, 153, 264, 154, 155, 0, 156, 0, 0, 157,
	0, 0, 158, 265, 0, 159, 0, 266, 160, 161,
	162, 163, 0, 267, 164, 268, 165, 0, 166, 167,
	168, 169, 269, 525, 171, 0, 172, 173, 174, 175,
	176, 178, 179, 177, 180, 181, 182, 0, 183, 0,
	184, 185, 270, 186, 0, 190, 191, 192, 193, 0,
	271, 194, 195, 196, 0, 197, 187, 188, 198, 0,
	199, 272, 273, 200, 0, 206, 201, 202, 189, 203,
	205, 274, 204, 275, 0, 207, 0, 208, 209, 210,
	211, 212, 0, 276, 277, 278, 0, 0, 213, 279,
	280, 0, 214, 215, 216, 217, 0, 0, 218, 219,
	220, 221, 0, 222, 0, 281, 223, 224, 225, 282,
	283, 89, 0, 226, 0, 0, 0, 0, 227, 228,
	229, 230, 231, 0, 0, 0, 0, 92, 93, 0,
	94, 0, 0, 0, 0, 232, 0, 0, 0, 0,
	95, 96, 97, 233, 234, 235, 236, 98, 237, 238,
	0, 99, 239, 240, 100, 0, 0, 241, 242, 243,
	0, 436, 244, 0, 0, 0, 102, 103, 104, 0,
	105, 0, 106, 107, 108, 0, 0, 109, 110, 0,
	0, 0, 0, 0, 0, 111, 112, 287, 113, 245,
	114, 246, 247, 0, 115, 0, 116, 0, 0, 0,
	117, 118, 0, 119, 0, 0, 0, 248, 120, 121,
	122, 249, 250, 0, 0, 0, 123, 124, 251, 0,
	125, 0, 126, 0, 0, 0, 0, 127, 252, 0,
	253, 0, 128, 129, 130, 131, 254, 255, 0, 0,
	135, 0, 132, 0, 0, 133, 256, 134, 257, 258,
	259, 0, 260, 0, 0, 136, 0, 137, 138, 0,
	140, 139, 0, 261, 0, 141, 0, 0, 434, 0,
	0, 143, 0, 144, 145, 146, 148, 262, 445, 0,
	149, 150, 152, 151, 0, 0, 0, 263, 153, 264,
	154, 155, 0, 156, 0, 0, 157, 0, 0, 158,
	265, 0, 159, 0, 266, 160, 161, 162, 163, 0,
	267, 164, 268, 165, 0, 166, 167, 168, 169, 269,
	170, 171, 0, 172, 173, 174, 175, 176, 178, 179,
	177, 180, 181, 182, 0, 183, 0, 184, 185, 437,
	186, 0, 190, 191, 192, 193, 0, 271, 194, 435,
	196, 0, 197, 187, 188, 198, 0, 199, 272, 273,
	200, 0, 206, 201, 202, 189, 203, 205, 274, 204,
	275, 0, 207, 0, 208, 209, 210, 211, 212, 0,
	442, 277, 278, 0, 0, 438, 279, 280, 0, 214,
	215, 216, 217, 0, 0, 218, 219, 220, 221, 0,
	222, 0, 281, 223, 224, 225, 282, 283, 89, 0,
	226, 0, 0, 0, 0, 227, 228, 229, 230, 231,
	0, 0, 0, 0, 92, 93, 0, 94, 0, 0,
	0, 0, 232, 0, 0, 0, 0, 95, 96, 97,
	233, 234, 235, 236, 98, 237, 238, 0, 99, 239,
	240, 100, 0, 0, 241, 242, 243, 0, 101, 244,
	0, 0, 0, 102, 103, 104, 0, 105, 0, 106,
	107, 108, 0, 0, 109, 110, 0, 0, 0, 0,
	0, 0, 111, 112, 287, 113, 245, 114, 246, 247,
	0, 115, 0, 116, 0, 0, 0, 117, 118, 0,
	119, 0, 0, 0, 248, 120, 121, 122, 249, 250,
	0, 0, 0, 123, 124, 251, 0, 125, 0, 126,
	0, 0, 0, 0, 127, 252, 0, 253, 0, 128,
	129, 130, 131, 254, 255, 0, 0, 135, 0, 132,
	0, 0, 133, 256, 134, 257, 258, 259, 0, 260,
	0, 0, 136, 0, 137, 138, 0, 140, 139, 0,
	261, 0, 141, 0, 0, 142, 0, 0, 143, 0,
	144, 145, 146, 148, 262, 147, 0, 149, 150, 152,
	151, 0, 0, 0, 263, 153, 264, 154, 155, 0,
	156, 0, 0, 157, 0, 0, 158, 265, 0, 159,
	0, 266, 160, 161, 0, 163, 0, 267, 164, 268,
	165, 0, 166, 167, 0, 169, 269, 170, 171, 0,
	172, 173, 174, 175, 176, 178, 179, 177, 180, 181,
	182, 0, 183, 0, 184, 185, 270, 0, 0, 190,
	191, 192, 193, 0, 271, 194, 195, 196, 0, 197,
	187, 188, 198, 0, 199, 272, 273, 200, 0, 206,
	201, 202, 189, 203, 205, 274, 204, 275, 0, 207,
	0, 208, 209, 210, 211, 212, 0, 276, 277, 278,
	0, 0, 213, 279, 280, 0, 214, 215, 216, 217,
	0, 0, 218, 219, 220, 221, 0, 222, 0, 281,
	223, 224, 225, 282, 283, 0, 0, 226, 0, 0,
	0, 0, 227, 228, 229, 230, 231, 979, 980, 0,
	999, 1000, 1001, 1009, 1010, 1011, 0, 0, 0, 0,
	0, 0, 0, 1002, 0, 0, 0, 0, 0, 0,
	982, 0, 0, 1013, 0, 0, 0, 0, 0, 979,
	980, 0, 999, 1000, 1001, 1009, 1010, 1011, 0, 0,
	0, 0, 0, 981, 0, 1002, 0, 0, 0, 996,
	0, 0, 982, 0, 0, 1013, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 981, 0, 0, 0, 0,
	0, 996, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 987,
	0, 0, 0, 0, 0, 0, 1555, 1556, 0, 1573,
	1574, 1575, 0, 0, 0, 0, 0, 0, 1006, 1014,
	0, 0, 1726, 0, 0, 0, 0, 0, 0, 0,
	0, 987, 0, 0, 1012, 0, 0, 979, 980, 0,
	999, 1000, 1001, 1009, 1010, 1011, 1004, 0, 0, 0,
	1006, 1014, 997, 1002, 0, 0, 0, 0, 1570, 0,
	982, 0, 0, 1013, 0, 0, 1012, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1003, 1004, 0,
	0, 0, 0, 981, 997, 0, 0, 0, 0, 996,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 1561, 1003,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 998, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1007, 0, 0, 987,
	0, 0, 0, 1576, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 998, 0, 0, 0, 0, 1006, 1014,
	0, 1571, 0, 0, 0, 0, 0, 0, 1007, 0,
	0, 0, 0, 0, 1012, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1004, 0, 0, 0,
	0, 0, 997, 0, 0, 0, 0, 0, 0, 0,
	1005, 0, 0, 993, 994, 995, 1008, 0, 992, 990,
	991, 983, 984, 985, 986, 988, 989, 1003, 0, 0,
	0, 0, 0, 0, 1596, 0, 0, 0, 0, 0,
	1572, 0, 1005, 0, 0, 993, 994, 995, 1008, 0,
	992, 990, 991, 983, 984, 985, 986, 988, 989, 0,
	0, 0, 0, 0, 0, 0, 1595, 0, 0, 979,
	980, 998, 999, 1000, 1001, 1009, 1010, 1011, 0, 0,
	0, 0, 0, 0, 0, 1002, 1007, 0, 0, 0,
	0, 0, 982, 979, 980, 1013, 999, 1000, 1001, 1009,
	1010, 1011, 0, 0, 0, 0, 0, 0, 0, 1002,
	0, 0, 0, 0, 0, 981, 982, 0, 0, 1013,
	0, 996, 1567, 1568, 1569, 0, 0, 1566, 1564, 1565,
	1557, 1558, 1559, 1560, 1562, 1563, 0, 0, 0, 981,
	0, 0, 0, 0, 0, 996, 0, 0, 0, 0,
	1005, 0, 0, 993, 994, 995, 1008, 0, 992, 990,
	991, 983, 984, 985, 986, 988, 989, 0, 0, 0,
	0, 987, 0, 0, 1547, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	1006, 1014, 0, 0, 0, 987, 0, 0, 0, 0,
	1555, 1556, 0, 1573, 1574, 1575, 1012, 0, 0, 0,
	0, 0, 0, 0, 1006, 1014, 1725, 0, 1004, 0,
	0, 0, 0, 0, 997, 0, 0, 0, 0, 0,
	1012, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1004, 0, 0, 0, 0, 0, 997, 1003,
	0, 0, 1570, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1003, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 998, 0, 0, 0, 0, 0, 0,
	0, 0, 1561, 0, 0, 0, 0, 0, 1007, 0,
	0, 0, 0, 0, 0, 0, 0, 998, 979, 980,
	0, 999, 1000, 1001, 1009, 1010, 1011, 0, 0, 0,
	0, 0, 1007, 0, 1002, 0, 0, 1576, 0, 0,
	0, 982, 0, 0, 1013, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1571, 0, 0, 0, 0,
	0, 0, 0, 0, 981, 0, 0, 0, 0, 0,
	996, 0, 1005, 0, 0, 993, 994, 995, 1008, 0,
	992, 990, 991, 983, 984, 985, 986, 988, 989, 0,
	0, 0, 0, 2075, 0, 0, 1005, 0, 0, 993,
	994, 995, 1008, 0, 992, 990, 991, 983, 984, 985,
	986, 988, 989, 0, 0, 0, 0, 2073, 0, 0,
	987, 0, 979, 980, 1572, 999, 1000, 1001, 1009, 1010,
	1011, 0, 0, 0, 0, 0, 0, 0, 1002, 1006,
	1014, 0, 0, 0, 0, 982, 0, 0, 1013, 0,
	0, 0, 0, 0, 0, 1012, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1004, 981, 0,
	0, 0, 0, 997, 996, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 1003, 0,
	0, 0, 0, 0, 0, 0, 1567, 1568, 1569, 0,
	0, 1566, 1564, 1565, 1557, 1558, 1559, 1560, 1562, 1563,
	0, 0, 0, 0, 987, 0, 1555, 1556, 0, 1573,
	1574, 1575, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 998, 1006, 1014, 0, 979, 980, 0, 999,
	1000, 1001, 1009, 1010, 1011, 0, 0, 1007, 0, 1012,
	0, 0, 1002, 0, 0, 0, 0, 0, 0, 982,
	0, 1004, 1013, 0, 0, 0, 0, 997, 1570, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 981, 0, 0, 0, 0, 0, 996, 0,
	0, 0, 1003, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 1005, 0, 0, 993, 994, 995, 1008, 1561, 992,
	990, 991, 983, 984, 985, 986, 988, 989, 0, 0,
	0, 0, 2018, 0, 0, 0, 998, 0, 987, 0,
	979, 980, 0, 999, 1000, 1001, 1009, 1010, 1011, 0,
	0, 1007, 0, 1576, 0, 0, 1002, 1006, 1014, 0,
	0, 0, 0, 982, 0, 0, 1013, 0, 0, 0,
	0, 1571, 0, 1012, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1004, 981, 0, 0, 0,
	0, 997, 996, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1005, 1003, 0, 993, 994,
	995, 1008, 0, 992, 990, 991, 983, 984, 985, 986,
	988, 989, 0, 0, 0, 0, 2013, 0, 0, 0,
	1572, 0, 987, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	998, 1006, 1014, 0, 979, 980, 0, 999, 1000, 1001,
	1009, 1010, 1011, 0, 0, 1007, 0, 1012, 0, 0,
	1002, 0, 0, 0, 0, 0, 0, 982, 0, 1004,
	1013, 0, 0, 0, 0, 997, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	981, 0, 0, 0, 0, 0, 996, 0, 0, 0,
	1003, 0, 1567, 1568, 1569, 0, 0, 1566, 1564, 1565,
	1557, 1558, 1559, 1560, 1562, 1563, 0, 0, 0, 1005,
	0, 0, 993, 994, 995, 1008, 0, 992, 990, 991,
	983, 984, 985, 986, 988, 989, 0, 0, 0, 0,
	2009, 0, 0, 0, 998, 0, 987, 0, 979, 980,
	0, 999, 1000, 1001, 1009, 1010, 1011, 0, 0, 1007,
	0, 0, 0, 0, 1002, 1006, 1014, 0, 0, 0,
	0, 982, 0, 0, 1013, 0, 0, 0, 0, 0,
	0, 1012, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1004, 981, 0, 0, 0, 0, 997,
	996, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1005, 1003, 0, 993, 994, 995, 1008,
	0, 992, 990, 991, 983, 984, 985, 986, 988, 989,
	0, 0, 0, 0, 1948, 0, 0, 0, 0, 0,
	987, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 998, 1006,
	1014, 0, 979, 980, 0, 999, 1000, 1001, 1009, 1010,
	1011, 0, 0, 1007, 0, 1012, 0, 0, 1002, 0,
	0, 0, 0, 0, 0, 982, 0, 1004, 1013, 0,
	0, 0, 0, 997, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 981, 0,
	0, 0, 0, 0, 996, 0, 0, 0, 1003, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1005, 0, 0,
	993, 994, 995, 1008, 0, 992, 990, 991, 983, 984,
	985, 986, 988, 989, 0, 0, 0, 0, 1926, 0,
	0, 0, 998, 0, 987, 0, 979, 980, 0, 999,
	1000, 1001, 1009, 1010, 1011, 0, 0, 1007, 0, 0,
	0, 0, 1002, 1006, 1014, 0, 0, 0, 0, 982,
	0, 0, 1013, 0, 0, 0, 0, 0, 0, 1012,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 1004, 981, 0, 0, 0, 0, 997, 996, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 1005, 1003, 0, 993, 994, 995, 1008, 0, 992,
	990, 991, 983, 984, 985, 986, 988, 989, 0, 0,
	0, 0, 1925, 0, 0, 0, 0, 0, 987, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 998, 1006, 1014, 0,
	979, 980, 0, 999, 1000, 1001, 1009, 1010, 1011, 0,
	0, 1007, 0, 1012, 0, 0, 1002, 0, 0, 0,
	0, 0, 0, 982, 0, 1004, 1013, 0, 0, 0,
	0, 997, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 981, 0, 0, 0,
	0, 0, 996, 0, 0, 0, 1003, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1005, 0, 0, 993, 994,
	995, 1008, 0, 992, 990, 991, 983, 984, 985, 986,
	988, 989, 0, 0, 0, 0, 1815, 0, 0, 0,
	998, 0, 987, 0, 979, 980, 0, 999, 1000, 1001,
	1009, 1010, 1011, 0, 0, 1007, 0, 0, 0, 0,
	1002, 1006, 1014, 0, 0, 0, 0, 982, 0, 0,
	1013, 0, 0, 0, 0, 0, 0, 1012, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 1004,
	981, 0, 0, 0, 0, 997, 996, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 1005,
	1003, 0, 993, 994, 995, 1008, 0, 992, 990, 991,
	983, 984, 985, 986, 988, 989, 0, 0, 0, 0,
	1749, 0, 0, 0, 0, 0, 987, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 998, 1006, 1014, 0, 979, 980,
	0, 999, 1000, 1001, 1009, 1010, 1011, 0, 0, 1007,
	0, 1012, 0, 0, 1002, 0, 0, 0, 0, 0,
	0, 982, 0, 1004, 1013, 0, 0, 0, 0, 997,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 981, 0, 0, 0, 0, 0,
	996, 0, 0, 0, 1003, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1005, 0, 0, 993, 994, 995, 1008,
	0, 992, 990, 991, 983, 984, 985, 986, 988, 989,
	0, 0, 0, 0, 1733, 0, 0, 0, 998, 0,
	987, 0, 979, 980, 0, 999, 1000, 1001, 1009, 1010,
	1011, 0, 0, 1007, 0, 0, 0, 0, 1002, 1006,
	1014, 0, 0, 0, 0, 982, 0, 0, 1013, 0,
	0, 0, 0, 0, 0, 1012, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1004, 981, 0,
	0, 0, 0, 997, 996, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1005, 1003, 0,
	993, 994, 995, 1008, 0, 992, 990, 991, 983, 984,
	985, 986, 988, 989, 0, 0, 0, 0, 1686, 0,
	0, 0, 0, 0, 987, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 998, 1006, 1014, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1007, 0, 1012,
	0, 0, 979, 980, 0, 999, 1000, 1001, 1009, 1010,
	1011, 1004, 0, 0, 0, 0, 0, 997, 1002, 0,
	0, 0, 0, 0, 0, 982, 0, 0, 1013, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1003, 0, 0, 0, 0, 0, 981, 0,
	0, 0, 0, 0, 996, 0, 0, 0, 0, 0,
	0, 1005, 0, 0, 993, 994, 995, 1008, 0, 992,
	990, 991, 983, 984, 985, 986, 988, 989, 0, 0,
	0, 0, 1302, 0, 0, 0, 998, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 1007, 0, 0, 987, 2158, 979, 980, 0, 999,
	1000, 1001, 1009, 1010, 1011, 0, 0, 0, 0, 0,
	0, 0, 1002, 1006, 1014, 0, 0, 0, 0, 982,
	0, 0, 1013, 0, 0, 0, 0, 0, 0, 1012,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 1004, 981, 0, 0, 0, 0, 997, 996, 0,
	0, 0, 0, 0, 0, 1005, 0, 0, 993, 994,
	995, 1008, 0, 992, 990, 991, 983, 984, 985, 986,
	988, 989, 1003, 0, 1522, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 2157, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 987, 0,
	1587, 0, 0, 1586, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 998, 1006, 1014, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 1007, 0, 1012, 0, 0, 979, 980, 0, 999,
	1000, 1001, 1009, 1010, 1011, 1004, 0, 0, 0, 0,
	0, 997, 1002, 0, 0, 0, 0, 1217, 0, 982,
	0, 0, 1013, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1003, 0, 0, 0,
	0, 0, 981, 0, 0, 0, 0, 0, 996, 0,
	0, 0, 0, 0, 0, 1005, 0, 0, 993, 994,
	995, 1008, 0, 992, 990, 991, 983, 984, 985, 986,
	988, 989, 0, 0, 0, 0, 1218, 0, 0, 0,
	998, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	1017, 0, 0, 0, 0, 1007, 979, 980, 987, 999,
	1000, 1001, 1009, 1010, 1011, 0, 0, 0, 0, 0,
	0, 0, 1002, 0, 0, 0, 1016, 1006, 1014, 982,
	0, 0, 1013, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1012, 0, 0, 0, 0, 0, 0,
	0, 0, 981, 0, 0, 1004, 0, 0, 996, 0,
	0, 997, 0, 0, 0, 0, 0, 0, 0, 1005,
	0, 0, 993, 994, 995, 1008, 0, 992, 990, 991,
	983, 984, 985, 986, 988, 989, 1003, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 979, 980, 987, 999,
	1000, 1001, 1009, 1010, 1011, 0, 0, 0, 0, 0,
	0, 0, 1002, 0, 0, 0, 0, 1006, 1014, 982,
	998, 0, 1013, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1012, 0, 1007, 0, 0, 0, 0,
	0, 0, 981, 0, 0, 1004, 0, 0, 996, 0,
	0, 997, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1003, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 987, 1005,
	0, 0, 993, 994, 995, 1008, 0, 992, 990, 991,
	983, 984, 985, 986, 988, 989, 0, 1006, 1014, 0,
	998, 979, 980, 0, 999, 1000, 1001, 1009, 1010, 1011,
	0, 0, 0, 1012, 0, 1007, 0, 1002, 0, 0,
	0, 0, 0, 0, 982, 1004, 0, 1013, 0, 0,
	0, 997, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 981, 0, 0,
	0, 0, 0, 996, 0, 0, 1003, 520, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 1005,
	0, 0, 993, 994, 995, 1008, 0, 992, 990, 991,
	983, 984, 985, 986, 988, 989, 0, 0, 0, 0,
	998, 979, 980, 987, 999, 1000, 1001, 1009, 1010, 1011,
	0, 0, 0, 0, 0, 1007, 0, 1002, 0, 0,
	0, 0, 1006, 1014, 982, 979, 980, 1013, 999, 1000,
	1001, 1009, 1010, 1011, 0, 0, 0, 0, 1012, 0,
	0, 1002, 0, 0, 0, 1588, 0, 981, 982, 0,
	1004, 1013, 0, 996, 0, 0, 997, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 981, 0, 0, 0, 0, 0, 996, 0, 1005,
	0, 1003, 993, 994, 995, 1008, 0, 992, 990, 991,
	983, 984, 985, 986, 988, 989, 0, 0, 0, 0,
	0, 0, 0, 987, 0, 0, 0, 0, 1593, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1006, 1014, 0, 998, 0, 987, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 1012, 0,
	1007, 0, 0, 0, 0, 0, 1006, 1014, 0, 0,
	1004, 0, 0, 0, 0, 0, 997, 0, 0, 0,
	0, 0, 1012, 1737, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1004, 0, 0, 0, 0, 0,
	997, 1003, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1005, 1003, 0, 993, 994, 995,
	1008, 0, 992, 990, 991, 983, 984, 985, 986, 988,
	989, 0, 0, 0, 0, 998, 0, 979, 980, 0,
	999, 1000, 1001, 1009, 1010, 1011, 0, 0, 0, 0,
	1007, 0, 0, 1002, 0, 0, 0, 0, 0, 998,
	982, 979, 980, 1013, 999, 1000, 1001, 1009, 1010, 1011,
	0, 0, 0, 0, 1007, 0, 0, 1002, 0, 0,
	0, 1546, 0, 981, 982, 0, 0, 1013, 0, 996,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 981, 0, 0,
	0, 0, 0, 996, 1005, 0, 0, 993, 994, 995,
	1008, 0, 992, 990, 991, 983, 984, 985, 986, 988,
	989, 0, 0, 0, 0, 0, 0, 0, 1005, 987,
	0, 993, 994, 995, 1008, 0, 992, 990, 991, 983,
	984, 985, 986, 988, 989, 0, 0, 0, 1006, 1014,
	0, 979, 980, 987, 999, 1000, 1001, 1009, 1010, 1011,
	0, 0, 0, 0, 1012, 0, 0, 1002, 0, 0,
	0, 0, 1006, 1014, 982, 0, 1004, 1013, 0, 0,
	0, 0, 997, 0, 0, 0, 0, 0, 1012, 0,
	0, 0, 0, 0, 0, 0, 0, 981, 0, 0,
	1004, 0, 0, 996, 0, 0, 997, 1003, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 1553,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 1003, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 998, 0, 987, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1007, 0, 0, 0,
	0, 0, 1006, 1014, 0, 998, 979, 980, 0, 999,
	1000, 1001, 1009, 1010, 1011, 0, 0, 0, 1012, 0,
	1007, 0, 0, 0, 0, 0, 0, 0, 0, 982,
	1004, 0, 1013, 0, 0, 0, 997, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 981, 0, 0, 0, 0, 0, 996, 0,
	1005, 1003, 0, 993, 994, 995, 1008, 0, 992, 990,
	991, 983, 984, 985, 986, 988, 989, 0, 0, 0,
	0, 0, 0, 0, 1005, 0, 0, 993, 994, 995,
	1008, 0, 992, 990, 991, 983, 984, 985, 986, 988,
	989, 0, 0, 0, 0, 998, 0, 0, 987, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	1007, 0, 0, 0, 0, 0, 0, 1006, 1014, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1004, 0, 0, 0, 0,
	0, 997, 867, 859, 884, 851, 875, 874, 0, 0,
	853, 852, 0, 0, 0, 886, 885, 0, 0, 0,
	0, 0, 0, 0, 1005, 0, 0, 993, 994, 995,
	1008, 0, 992, 990, 991, 983, 984, 985, 986, 988,
	989, 0, 0, 0, 0, 0, 0, 880, 0, 872,
	871, 0, 0, 0, 0, 0, 0, 0, 870, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	998, 0, 0, 0, 0, 0, 869, 0, 0, 0,
	0, 0, 0, 0, 0, 1007, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 862, 861, 863, 864, 865, 0,
	883, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 855, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 873, 0, 1005,
	0, 860, 993, 994, 995, 1008, 0, 992, 990, 991,
	983, 984, 985, 986, 988, 989, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 868, 0, 0,
	0, 1236, 1234, 1235, 1238, 1237, 0, 867, 859, 884,
	851, 875, 874, 0, 0, 853, 852, 0, 0, 0,
	886, 885, 0, 0, 0, 856, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 866, 857, 0, 0,
	0, 0, 0, 0, 0, 0, 888, 0, 0, 0,
	0, 0, 880, 0, 872, 871, 854, 0, 0, 881,
	882, 0, 0, 870, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	858, 869, 0, 0, 0, 887, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 862,
	861, 863, 864, 865, 0, 883, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	855, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 873, 0, 0, 0, 860, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 868, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	856, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 866, 857, 0, 0, 0, 0, 0, 0, 0,
	0, 888, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 854, 0, 0, 881, 882, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 858, 0, 0, 0, 0,
	887,
}
var sqlPact = [...]int{

	249, -1000, 43, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, 767, 16870, 16870, 21028, -1000, -1000, -1000, -1000,
	-1000, -1000, 760, 732, 452, 5260, 21028, 21028, 20731, 2398,
	2398, 22513, -1000, -1000, 26077, -1000, 3106, 527, 536, 527,
	527, 533, 22513, 1129, 643, 13862, 717, 138, -1000, 729,
	-2, 25780, 21028, 1443, 38, 18949, 327, 249, 20434, 25483,
	21028, 20137, 617, 35, 17464, 21028, -1000, 45, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, 1293, 382, 45, -1000, 1290, 1155,
	1142, 18949, 25186, 24889, 24592, 24295, -1000, 12624, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, 800, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, 339, 332, -1000, 19840, -1000, 969, -1000,
	36, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 966,
	-1000, 21028, -1000, -1000, 23998, 23701, 707, 330, 1059, -1000,
	-1000, 604, 450, -1000, -1000, 13553, 49, -1000, -1000, -1000,
	-1000, 1456, 16573, 849, 1289, -1000, 960, 1287, 1285, 1274,
	1269, 1267, -1000, 803, -1000, 1264, 448, 860, 518, -1000,
	1261, 1260, 1059, -1000, 1059, -1000, -1000, -1000, 615, 22513,
	-1000, -1000, -1000, -1000, -1000, 18949, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, 1632, -1000, -1000, -1000,
	-1000, 1668, -1000, -1000, -1000, -1000, 23404, 21028, 21028, 1186,
	23107, -1000, 729, -1000, -1000, -1000, 1161, 1442, 1442, 1442,
	1477, 178, 159, 138, 29, 21028, -1000, 329, 29, 9448,
	9448, -1000, -1000, 327, -1000, 393, 15967, -1000, 8482, -1000,
	792, 1350, 474, 714, 1349, -132, 851, 846, 1348, 16573,
	17464, 35, 34, -1000, -1000, -1000, 4951, 16573, 687, 15063,
	45, -1000, -1000, -1000, 18949, 21028, 21028, 716, 22810, -1000,
	1346, 131, 1342, -1000, 127, 1341, -1000, 127, 1340, 22,
	-1000, -1000, 327, 19543, 21028, 1586, 30130, -1000, 10737, -1000,
	-1000, 16870, 1230, 16870, -1000, -1000, 1585, -1000, 21028, 10737,
	30, -1000, -1000, -1000, -1000, 1084, 1064, 564, 13244, 12935,
	1404, 1258, -1000, -1000, -1000, 46, 5260, 702, -1000, -1000,
	-1000, 19246, -1000, -1000, 21028, 1303, 16870, 21028, 21028, 21028,
	21028, 21028, -1000, -1000, 21028, -1000, 1080, -1000, -1000, 21028,
	21028, 789, 641, -1000, 30, -1000, 22513, -1000, 144, -1000,
	-1000, -1000, -1000, 326, 1038, 460, 145, 22216, 460, 1026,
	-1000, 1161, -1000, 973, 1163, 9771, 1113, 10737, 138, -1000,
	-1000, 138, 138, 10737, -1000, -1000, 21028, 29, 1558, 21028,
	197, -1000, 29016, -1000, -1000, 10737, 10737, 10737, 10737, 10737,
	913, 385, -1000, 324, 323, 6214, -1000, -1000, 1667, -1000,
	-1000, -1000, 165, -1000, -1000, 10737, 45, -1000, -1000, -1000,
	-1000, 321, 1681, -1000, 511, -1000, -1000, -1000, 455, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 1302, 318,
	316, -1000, -1000, -1000, -1000, 315, 309, 304, 303, 301,
	300, 291, 288, 283, 281, 279, 272, 271, 270, 269,
	886, -1000, 479, -1000, -1000, 479, 479, -1000, 260, 260,
	262, -1000, -1000, -1000, -1000, 260, -1000, -1000, -1000, 440,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, 263, 197, -1000,
	-1000, -1000, 21028, 21, -1000, 29691, -1000, 24, 794, -1000,
	18355, 1440, 1420, 1421, 18949, 1519, -2, 1259, 1502, -2,
	1254, 609, 21028, 21028, 606, 605, 18949, 420, -1000, 21028,
	-1000, -1000, 32, -1000, -1000, 1252, 11, -1000, -1000, 472,
	112, 1550, 112, 15365, -1000, 21028, 21028, -1000, 21028, -1000,
	-1000, 21028, -1000, 21028, 21028, -1000, 21028, 152, 17761, 765,
	1338, 701, -2, 7, -1000, 1589, -1000, -1000, -1000, -1000,
	101, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 262,
	886, 260, 260, 260, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, 440, -1000, -1000, 479, 479, 479, -1000, -1000, 0,
	29691, 600, -1000, 1250, 524, -1000, 446, -4, 1059, 752,
	-1000, -1000, -1000, -1000, -1000, -1000, 28, -1000, -1000, 28,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 1680,
	5260, -1000, -1000, -1000, -1000, -1000, -1000, 21028, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 21028, 21028,
	21028, -1000, -1000, 18949, 18058, 1547, 1333, 893, -1000, 1545,
	21028, 959, 1015, -1000, 595, 1332, -1000, -1000, -1000, -1000,
	29691, -1000, 387, -1000, -1000, 29691, 844, 1172, -1000, 1172,
	27, -1000, 28916, -1000, 258, -5, 472, 9448, 14762, 29945,
	30130, 5260, 630, 10737, 10737, 10737, 10737, 10737, 10737, 10737,
	10737, 10737, 10737, 10737, 10737, 10737, 10737, 10737, 10737, 10737,
	10737, 10737, 10737, 10737, 10737, 928, 10737, 599, 10737, 10737,
	10737, 10737, 972, 899, 243, 921, 5260, -1000, -1000, 1620,
	1620, 1620, 4008, 4008, 235, 385, -1000, 10737, -1000, 9126,
	159, 28428, 26, -1000, -1000, -1000, 7181, 476, 29691, 45,
	5891, -1000, 1665, 843, 1279, 1232, 257, 158, 153, 10737,
	10737, 11059, 11059, 10737, 11381, 10737, 10737, 6536, 10737, 10737,
	10737, 10737, 10737, 10737, -1000, 256, -1000, -1000, -1000, -1000,
	1663, -1000, -1000, 1662, -1000, 629, 627, 1660, 472, 149,
	8482, -1000, 765, 21028, 21028, 21028, -1000, -1000, 1014, 21919,
	1010, 30130, 21028, -1000, 250, 248, 1130, 1125, 21028, 21028,
	21622, 21325, 21028, 778, -2, -1000, 247, -2, -1000, 246,
	21028, 831, -1000, 21028, 21028, 782, 1201, 976, -1000, 464,
	16573, 673, 1249, 21028, 758, 10737, 804, -1000, 14461, 488,
	21028, 758, 133, -1000, -1000, -1000, 416, 21028, -1000, -1000,
	-1000, 131, -1000, 127, 127, -1000, -1000, 18949, -1000, -1000,
	-1000, -1000, -1000, -1000, 30130, 383, 367, -1000, 1659, 594,
	-1000, 592, 591, 586, -1000, 245, -1000, 10737, 21028, 21028,
	1131, -1000, -1000, -1000, 747, -1000, 854, -1000, 13862, -1000,
	23, -1000, -1000, -1000, 420, -1000, 128, -10, 25, 30130,
	-1000, -1000, -1000, -1000, -1000, 21028, 331, 21028, -2, 21028,
	-1000, 1679, -2, 21028, 1331, 1360, 410, 21028, 844, -1000,
	10737, 1654, -1000, -1000, -1000, 10737, -1000, -1000, -1000, -2,
	-1000, 1231, -1000, -9, 1233, 993, -136, 156, 429, -1000,
	14160, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, 445, 587, 587, 590, 590, 590, 590, 1747, 2598,
	2372, 2145, 3883, 3883, 3883, 1271, 176, 176, 3883, 3883,
	3883, 4008, 3064, 1072, 10737, 10737, 585, 879, 243, 1072,
	10737, 1072, 1072, 1072, 1072, -1000, 1256, -1000, -1000, -1000,
	-1000, 1246, 241, 11381, 11381, -1000, -1000, -1000, 6214, 11703,
	-1000, -1000, -1000, -1000, -1000, 240, 10737, -1000, 28532, -169,
	-11, -1000, -1000, 10737, -12, -52, -1000, -1000, 684, -1000,
	10737, -1000, 3, 10737, 10737, 10737, 126, 122, -1000, 924,
	239, 238, 10737, -1000, -1000, 29591, 26817, 120, 1244, -108,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, 118, 116, 29567,
	-108, 115, 3937, -1000, 11381, 11381, 11381, 6214, 231, 113,
	28776, -108, 29365, 8804, 8804, 8804, 108, 29341, 10737, -108,
	26709, 26677, 3764, -15, -16, -21, 1653, -26, 107, 441,
	433, 99, 1231, -1000, -1000, -1000, -1000, 581, 579, 1328,
	-1000, 1004, -1000, 493, -1000, 836, 10737, 12323, 229, 221,
	871, -1000, 1324, 1000, 1323, 1000, -1000, 24, 772, -1000,
	10737, -1000, 10737, -1000, 575, -1000, -1000, 572, 464, 1243,
	645, -1000, 946, -1000, -1000, 659, -1000, -1000, 6858, 29691,
	-1000, 758, 1427, -27, -1000, -1000, -1000, 472, 15365, 14762,
	8482, -33, -1000, -1000, -1000, 765, -1000, 546, 1651, 97,
	1050, 889, 799, 721, 1650, 29691, 23, 23, -1000, -1000,
	-1000, -1000, -1000, 21028, -1000, 1189, -1000, 18058, 219, 21028,
	216, -1000, 214, -1000, -1000, 212, 21028, 1089, 410, 17167,
	-1000, 460, 948, 28304, -1000, 96, 1226, 1476, -1000, 14762,
	1138, 1135, 14762, 1215, 926, 926, 926, -1000, 210, 162,
	360, 429, 4319, 10737, 18652, 930, 69, 95, 1233, 10737,
	1072, 1072, 10737, 11381, 11381, -1000, 1072, -1000, -1000, -1000,
	-1000, -1000, 1242, 209, 10737, 30130, 27170, 26786, -34, -1000,
	8160, 17, -1000, 10737, -1000, 28200, -1000, -1000, 322, 1337,
	-1000, 10737, 29241, 93, 7838, -1000, 29116, 1, 1, -1000,
	1677, -1000, 15666, 473, 939, 28076, 29945, 30130, -1000, 10737,
	-1000, -1000, 1241, 10737, -1000, 29945, 30130, 11381, 11381, 11381,
	11381, 11381, 11381, 11381, 11381, 11381, 11381, 11381, 11381, 11381,
	11381, 11381, 11381, 11381, 11381, 11381, 1095, 11381, 1618, 1618,
	1618, 12, 7516, -1000, 1297, 1241, 10737, 10737, 30130, 91,
	90, 86, -1000, 10737, -108, 10737, 10737, 10737, -1000, -1000,
	-1000, 82, -1000, 1646, -1000, -1000, -1000, -1000, 1226, 21028,
	21028, 21028, 1322, -1000, 1888, -1000, 27972, -35, -1000, 320,
	1452, 10737, -1000, -1000, 208, 12323, 21028, -1000, 1108, 1097,
	513, 21028, -1000, 21028, -1000, 21028, 21028, 21028, -48, -55,
	21028, 21028, -1000, 16573, 619, 206, -1000, -46, -1000, -1000,
	228, -2, 758, -1000, -47, -1000, 414, -1000, 358, 357,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 80, -1000,
	-1000, 1193, -1000, 12323, 205, 21028, 18058, 1541, 12323, 958,
	1092, 410, 17167, -1000, 595, -1000, -1000, -1000, 466, 10737,
	10737, 1233, 14762, 14762, 995, 1109, 14762, -1000, -1000, -1000,
	-1000, 350, 375, 347, 12624, 429, 18652, -1000, 1641, 1132,
	-59, -1000, -1000, 21028, 203, -1000, 429, 1529, 1072, 3825,
	2704, 10737, 30130, 29816, -61, 10737, 10737, -1000, -63, -1000,
	10737, 346, 29691, -1000, -1000, -1000, 29691, 10737, 1673, 10737,
	79, 75, 74, -1000, -1000, -1000, 26374, 10737, 73, -1000,
	72, 71, 29691, 1297, 29691, -1000, -1000, 447, 447, 715,
	715, 715, 715, 1618, 985, 2295, 379, 1280, 1280, 1280,
	2187, 412, 412, 1280, 1280, 1280, 1240, 1074, 202, 27496,
	10737, -67, -1000, -1000, -1000, 29691, 29691, 68, -1000, -1000,
	-1000, -108, 3657, 27848, 27744, -1000, 65, 466, -1000, -1000,
	-1000, 21028, -1000, 21028, -1000, 5260, 21028, 1227, 994, -1000,
	-1000, 1123, 200, 11381, 21028, -1000, 850, 12323, 1446, 45,
	5260, 1446, 27620, 5891, -71, -75, 989, -1000, 983, 10737,
	-1000, 30130, 1000, 1000, -1000, 562, 557, 555, 541, -1000,
	-1000, -56, 16276, 1676, 1365, 21028, 1417, -1000, -1000, 199,
	-1000, -1000, -1000, 909, -76, 12323, -77, 62, -2, -83,
	21028, -1000, 410, 17167, -1000, 1360, -1000, 21028, 29691, -108,
	-1000, 995, -1000, 196, 10737, 14762, -1000, -136, -1000, -85,
	-1000, 429, -89, 18652, -1000, 344, -161, -1000, 409, -1000,
	429, 195, 21028, 18652, 10737, 10737, 29816, -90, -1000, 1072,
	1072, -1000, 27516, -1000, 29691, -1000, 29116, -1000, -1000, -1000,
	906, -1000, 27392, -1000, -1000, -1000, -1000, 11381, 1238, 194,
	30130, 27288, -1000, -1000, 10737, -1000, -1000, -1000, -1000, -1000,
	1334, -1000, -1000, 21028, 1001, -1000, -1000, 10737, 27496, 192,
	1189, 190, -1000, -1000, -1000, -1000, -1000, -1000, 1452, 3,
	-1000, 806, -1000, -1000, 29691, 1445, -1000, -1000, 21028, 21028,
	189, 186, -1000, 185, 45, -95, -1000, 405, 616, -99,
	21028, -1000, -1000, 5569, 21028, 850, -101, -1000, 1189, -1000,
	850, 184, 17167, -1000, 1089, -94, -1000, 1528, -1000, 21028,
	29691, -1000, 429, -1000, 1639, 18652, 152, -1000, -1000, 1132,
	-1000, 4639, 18652, 21028, -103, -1000, 1072, 1072, -1000, -1000,
	58, 939, 1471, -1000, 3954, 11381, 30130, -110, -1000, 27063,
	-1000, -1000, 1321, 27039, 1069, 21028, -1000, 21028, 1446, 54,
	21028, 496, 5260, -1000, -1000, 10737, 10737, 10737, 1676, -1000,
	-1000, 1675, 712, -1000, 472, -1000, 181, 1189, 850, -1000,
	1189, 12323, -1000, 1092, 21028, 180, -111, 18652, -1000, -1000,
	343, -1000, -1000, 1619, -1000, -116, -1000, -1000, 841, 10737,
	3954, -121, -1000, -1000, 1311, -1000, 950, 858, 53, -122,
	-1000, -1000, 145, -1000, 10737, -1000, -127, -133, 1, -1000,
	-1000, 15365, -1000, 21028, -1000, 1189, -1000, -134, -1000, -1000,
	-1000, -1000, -1000, 429, 342, -1000, 52, 10415, 10415, -108,
	-1000, 21028, -1000, 955, 952, 703, -1000, -1000, -1000, -1000,
	-1000, 1069, 29691, -1000, -1000, 51, -123, -138, -1000, 850,
	18652, -1000, -1000, -1000, -1000, 12014, 1013, 741, 28672, -1000,
	-1000, -1000, 1370, -1000, 504, 1070, 1070, 950, 1673, -1000,
	975, 1189, -1000, 1593, -1000, -1000, -1000, -1000, -1000, -1000,
	1605, -1000, -1000, 1085, -1000, -1000, -1000, -1000, -1000, -1000,
	10093, -1000, -1000, -1000, -1000,
}
var sqlPgo = [...]int{

	0, 1936, 1933, 1479, 1613, 1931, 1930, 1590, 1929, 1928,
	1927, 1926, 1925, 1923, 119, 1586, 1578, 33, 1567, 1922,
	121, 1921, 1920, 1919, 117, 1918, 1913, 1912, 1911, 56,
	1905, 1904, 110, 1496, 1488, 1486, 1902, 1900, 115, 1899,
	1898, 23, 1896, 94, 1892, 37, 173, 2341, 149, 1889,
	1887, 1885, 19, 130, 89, 1883, 106, 1880, 1874, 61,
	51, 28, 22, 1873, 126, 1872, 1870, 1654, 31, 1869,
	1866, 159, 1865, 39, 42, 101, 166, 164, 139, 140,
	1863, 1856, 1855, 1854, 67, 1851, 2, 1850, 1848, 13,
	75, 17, 1847, 45, 16, 1845, 1844, 150, 1840, 92,
	123, 1468, 143, 152, 158, 1837, 113, 12, 100, 1836,
	1835, 153, 58, 1834, 41, 98, 161, 1833, 70, 168,
	83, 38, 78, 127, 1832, 1831, 1830, 97, 1829, 128,
	84, 1827, 1826, 95, 1825, 151, 155, 1823, 1822, 122,
	1820, 144, 1818, 1817, 162, 171, 1816, 170, 1813, 1812,
	169, 136, 11, 50, 90, 9, 1472, 1463, 131, 65,
	29, 24, 1811, 1989, 990, 798, 43, 99, 69, 74,
	105, 64, 88, 157, 30, 1808, 1805, 135, 1799, 1797,
	1796, 1793, 1792, 103, 1791, 1790, 93, 156, 14, 4,
	15, 112, 53, 62, 109, 129, 165, 132, 1789, 114,
	142, 59, 225, 1788, 1787, 1728, 146, 1786, 1785, 1784,
	1635, 1348, 1292, 253, 1783, 1779, 1232, 669, 1778, 1777,
	77, 1776, 138, 141, 1775, 160, 398, 54, 1774, 44,
	68, 124, 1771, 133, 87, 0, 444, 397, 1770, 147,
	96, 1768, 1767, 1766, 1765, 32, 3, 10, 6, 7,
	5, 25, 21, 1763, 1762, 148, 26, 91, 1760, 167,
	1754, 1750, 1748, 60, 1745, 20, 1738, 18, 1729, 1725,
	8, 1, 1720, 1716, 154, 1715, 125, 1710, 1499, 1698,
	163, 1696, 1687, 1512, 40, 107,
}
var sqlR1 = [...]int{

	0, 1, 2, 2, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 4, 4, 54, 54, 53, 53, 53,
	53, 53, 53, 53, 53, 53, 53, 53, 53, 53,
	53, 53, 51, 51, 56, 56, 56, 58, 58, 55,
	55, 50, 50, 5, 5, 233, 233, 234, 234, 40,
	40, 44, 44, 41, 42, 42, 43, 43, 6, 6,
	6, 7, 7, 7, 7, 7, 7, 14, 15, 15,
	15, 15, 15, 15, 15, 15, 103, 103, 102, 102,
	105, 105, 16, 16, 17, 17, 17, 17, 17, 17,
	17, 17, 17, 17, 17, 17, 17, 201, 201, 200,
	19, 175, 175, 20, 20, 20, 20, 21, 128, 128,
	22, 22, 22, 22, 23, 28, 274, 274, 274, 278,
	278, 279, 279, 280, 280, 280, 280, 280, 280, 280,
	276, 276, 27, 27, 27, 27, 39, 31, 31, 31,
	31, 31, 31, 148, 145, 145, 144, 144, 144, 144,
	146, 146, 146, 146, 149, 149, 83, 83, 226, 225,
	225, 231, 231, 231, 81, 81, 81, 81, 81, 82,
	82, 82, 224, 224, 224, 224, 232, 232, 232, 232,
	232, 232, 230, 230, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32, 32, 18,
	275, 275, 277, 277, 33, 33, 34, 34, 35, 35,
	35, 35, 10, 10, 11, 11, 84, 84, 85, 85,
	154, 154, 154, 154, 86, 86, 57, 57, 57, 153,
	243, 243, 244, 244, 244, 244, 244, 244, 245, 245,
	245, 245, 245, 245, 245, 241, 241, 242, 239, 239,
	240, 240, 240, 240, 281, 281, 152, 152, 89, 89,
	248, 248, 248, 248, 246, 246, 246, 246, 246, 249,
	247, 250, 250, 250, 250, 250, 187, 187, 187, 37,
	12, 63, 63, 13, 9, 9, 132, 132, 93, 93,
	192, 192, 192, 74, 74, 52, 52, 52, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26, 26, 133,
	133, 134, 134, 25, 30, 36, 36, 36, 36, 36,
	283, 283, 70, 70, 70, 70, 71, 71, 147, 147,
	150, 150, 151, 151, 151, 65, 64, 66, 66, 8,
	8, 59, 59, 60, 60, 61, 61, 62, 62, 284,
	284, 24, 24, 24, 77, 77, 141, 141, 141, 143,
	143, 142, 142, 142, 118, 118, 118, 38, 98, 98,
	107, 107, 108, 108, 198, 109, 109, 29, 29, 47,
	47, 45, 45, 45, 45, 45, 45, 46, 46, 48,
	48, 48, 48, 48, 48, 48, 256, 256, 256, 259,
	259, 255, 257, 257, 258, 258, 282, 282, 119, 119,
	119, 88, 87, 87, 91, 91, 90, 92, 92, 191,
	116, 116, 116, 116, 135, 135, 136, 136, 137, 137,
	138, 138, 138, 139, 139, 140, 140, 115, 115, 171,
	171, 49, 49, 97, 97, 99, 99, 161, 161, 161,
	162, 162, 160, 160, 160, 160, 193, 193, 193, 193,
	193, 193, 193, 193, 193, 272, 272, 272, 273, 273,
	190, 190, 194, 194, 194, 194, 194, 194, 188, 188,
	188, 188, 189, 189, 199, 199, 122, 122, 122, 122,
	120, 120, 121, 121, 195, 195, 195, 195, 117, 117,
	196, 196, 196, 155, 155, 202, 202, 202, 220, 220,
	96, 96, 96, 203, 203, 203, 203, 203, 203, 203,
	203, 203, 203, 203, 203, 203, 203, 203, 203, 203,
	204, 204, 204, 204, 206, 206, 206, 205, 205, 205,
	205, 205, 205, 205, 205, 205, 205, 205, 205, 205,
	205, 219, 219, 219, 219, 219, 207, 207, 214, 214,
	215, 215, 216, 217, 208, 208, 209, 209, 210, 211,
	218, 218, 218, 218, 222, 222, 212, 212, 212, 212,
	212, 213, 129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 130, 130, 163, 163,
	163, 163, 163, 163, 163, 163, 163, 163, 163, 163,
	163, 163, 163, 163, 163, 163, 163, 163, 163, 163,
	163, 163, 163, 163, 163, 163, 163, 163, 163, 163,
	163, 163, 163, 163, 163, 163, 163, 163, 163, 163,
	163, 163, 163, 163, 163, 163, 163, 163, 163, 163,
	163, 163, 163, 163, 163, 163, 163, 163, 163, 163,
	163, 164, 164, 164, 164, 164, 164, 164, 164, 164,
	164, 164, 164, 164, 164, 164, 164, 164, 164, 164,
	164, 164, 164, 164, 164, 164, 164, 164, 164, 164,
	165, 165, 165, 165, 167, 167, 167, 167, 167, 167,
	167, 167, 167, 167, 167, 251, 251, 251, 251, 251,
	251, 251, 253, 253, 254, 254, 252, 252, 252, 252,
	252, 252, 252, 252, 252, 252, 252, 252, 252, 252,
	252, 252, 252, 252, 252, 252, 252, 252, 252, 252,
	252, 252, 252, 260, 260, 261, 261, 263, 263, 264,
	264, 265, 266, 266, 266, 267, 268, 268, 262, 262,
	269, 269, 269, 270, 270, 271, 271, 271, 271, 271,
	177, 177, 177, 178, 178, 179, 185, 185, 185, 80,
	80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
	80, 80, 80, 80, 80, 72, 72, 72, 72, 72,
	104, 104, 174, 174, 172, 172, 172, 176, 176, 123,
	123, 221, 221, 221, 221, 221, 221, 221, 124, 124,
	124, 131, 125, 125, 126, 126, 126, 126, 126, 126,
	168, 169, 127, 127, 127, 170, 170, 180, 184, 184,
	183, 182, 182, 181, 181, 158, 158, 159, 159, 157,
	156, 112, 112, 111, 111, 110, 110, 285, 285, 186,
	186, 113, 113, 114, 106, 106, 197, 197, 197, 197,
	100, 100, 79, 79, 101, 101, 75, 75, 78, 78,
	76, 76, 76, 76, 94, 94, 95, 95, 73, 73,
	166, 166, 166, 166, 166, 166, 166, 166, 166, 166,
	166, 223, 223, 223, 173, 67, 67, 67, 68, 68,
	69, 69, 228, 228, 228, 229, 229, 229, 229, 227,
	227, 227, 227, 227, 235, 235, 235, 235, 235, 235,
	235, 235, 235, 235, 235, 235, 235, 235, 235, 235,
	235, 235, 235, 235, 235, 235, 235, 235, 235, 235,
	235, 235, 235, 235, 235, 235, 235, 235, 235, 235,
	235, 235, 235, 235, 235, 235, 235, 235, 235, 235,
	235, 235, 235, 235, 235, 235, 235, 235, 235, 235,
	235, 235, 235, 235, 235, 235, 235, 235, 235, 235,
	235, 235, 235, 235, 235, 235, 235, 235, 235, 235,
	235, 235, 235, 235, 235, 235, 235, 235, 235, 235,
	235, 235, 235, 235, 235, 235, 235, 235, 235, 235,
	235, 235, 235, 235, 235, 235, 235, 235, 235, 235,
	235, 235, 235, 235, 235, 235, 235, 235, 235, 235,
	235, 235, 235, 235, 235, 235, 235, 235, 235, 235,
	235, 235, 235, 235, 235, 235, 235, 235, 235, 235,
	235, 235, 235, 235, 235, 237, 237, 237, 237, 237,
	237, 237, 237, 237, 237, 237, 237, 237, 237, 237,
	237, 237, 237, 237, 237, 237, 237, 237, 237, 237,
	237, 237, 237, 237, 237, 237, 237, 237, 237, 237,
	237, 237, 237, 237, 237, 237, 237, 237, 237, 237,
	237, 237, 237, 237, 237, 237, 237, 236, 236, 236,
	236, 236, 236, 236, 236, 236, 236, 236, 236, 236,
	236, 238, 238, 238, 238, 238, 238, 238, 238, 238,
	238, 238, 238, 238, 238, 238, 238, 238, 238, 238,
	238, 238, 238, 238, 238, 238, 238, 238, 238, 238,
	238, 238, 238, 238, 238, 238, 238, 238, 238, 238,
	238, 238, 238, 238, 238, 238, 238, 238, 238, 238,
	238, 238, 238, 238, 238, 238, 238, 238, 238, 238,
	238, 238, 238, 238, 238, 238, 238, 238, 238, 238,
	238, 238, 238, 238, 238, 238, 238, 238, 238, 238,
	238, 238,
}
var sqlR2 = [...]int{

	0, 1, 3, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 0, 4, 6, 1, 3, 2, 5, 3,
	6, 4, 6, 6, 6, 4, 8, 3, 3, 3,
	6, 4, 3, 2, 1, 1, 0, 2, 0, 2,
	0, 2, 0, 7, 6, 1, 1, 1, 3, 3,
	0, 2, 0, 2, 1, 3, 5, 0, 4, 6,
	7, 1, 1, 1, 1, 1, 1, 6, 3, 5,
	4, 6, 4, 6, 4, 6, 1, 3, 1, 2,
	2, 3, 2, 5, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 3, 1,
	5, 3, 0, 1, 1, 1, 1, 3, 3, 0,
	2, 3, 2, 3, 6, 6, 1, 2, 2, 1,
	1, 1, 3, 1, 1, 1, 1, 1, 1, 1,
	1, 3, 2, 2, 2, 2, 2, 2, 3, 6,
	3, 4, 1, 5, 2, 1, 3, 3, 3, 3,
	1, 3, 3, 1, 2, 2, 1, 0, 1, 1,
	3, 1, 1, 1, 2, 2, 1, 2, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 2, 2, 2, 2, 2, 3,
	4, 4, 4, 4, 2, 4, 4, 4, 4, 4,
	4, 2, 3, 3, 2, 3, 3, 4, 2, 3,
	4, 3, 3, 4, 4, 2, 5, 5, 6, 2,
	2, 0, 2, 0, 6, 6, 5, 5, 4, 12,
	4, 12, 7, 10, 6, 9, 1, 0, 1, 3,
	1, 1, 1, 1, 8, 0, 1, 1, 0, 3,
	2, 0, 3, 1, 2, 2, 3, 6, 2, 1,
	1, 2, 4, 2, 5, 7, 8, 5, 3, 1,
	4, 6, 5, 10, 1, 1, 4, 0, 3, 0,
	2, 2, 2, 0, 1, 1, 2, 2, 0, 3,
	3, 2, 1, 1, 2, 2, 1, 2, 1, 4,
	5, 2, 0, 6, 11, 14, 1, 0, 1, 3,
	3, 3, 5, 2, 0, 1, 1, 0, 6, 6,
	8, 6, 8, 6, 8, 8, 10, 8, 10, 1,
	0, 2, 0, 2, 2, 3, 3, 2, 2, 2,
	1, 0, 1, 3, 2, 0, 2, 1, 1, 0,
	1, 3, 1, 1, 1, 2, 3, 2, 2, 8,
	11, 3, 0, 3, 0, 3, 0, 3, 0, 1,
	0, 6, 7, 6, 1, 3, 1, 4, 2, 8,
	5, 4, 3, 0, 2, 2, 0, 8, 2, 0,
	1, 3, 1, 1, 3, 5, 5, 1, 1, 3,
	3, 1, 2, 3, 2, 3, 4, 1, 1, 8,
	8, 1, 2, 4, 4, 4, 2, 2, 3, 1,
	3, 6, 1, 0, 1, 0, 1, 0, 1, 1,
	0, 1, 1, 0, 1, 0, 3, 1, 3, 2,
	2, 2, 1, 1, 2, 5, 2, 3, 1, 1,
	1, 3, 0, 1, 1, 1, 1, 3, 0, 2,
	0, 2, 3, 3, 0, 1, 3, 3, 5, 1,
	1, 3, 2, 4, 4, 0, 7, 4, 6, 3,
	1, 5, 6, 9, 5, 0, 2, 3, 1, 3,
	2, 0, 3, 4, 5, 4, 5, 4, 5, 2,
	4, 1, 1, 0, 5, 0, 2, 2, 2, 1,
	1, 0, 4, 2, 1, 2, 2, 4, 1, 3,
	1, 2, 3, 2, 0, 2, 5, 2, 1, 1,
	3, 4, 0, 1, 1, 1, 1, 2, 4, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 3, 5, 0, 1, 1, 1,
	1, 1, 1, 1, 2, 2, 2, 2, 2, 1,
	1, 1, 1, 1, 1, 1, 3, 0, 1, 1,
	1, 1, 5, 2, 1, 1, 1, 1, 4, 1,
	2, 2, 1, 1, 1, 0, 1, 1, 4, 1,
	4, 1, 1, 1, 1, 1, 1, 1, 3, 3,
	3, 3, 3, 3, 3, 0, 1, 4, 1, 3,
	3, 3, 5, 2, 2, 2, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 2, 2, 3,
	4, 3, 4, 4, 5, 3, 3, 3, 3, 3,
	4, 3, 4, 3, 3, 4, 3, 4, 3, 4,
	5, 6, 6, 7, 6, 7, 6, 7, 3, 4,
	4, 1, 3, 3, 2, 2, 2, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 5, 6, 6, 7,
	1, 2, 1, 2, 1, 1, 2, 1, 3, 1,
	1, 2, 2, 1, 1, 3, 5, 6, 8, 6,
	6, 4, 4, 1, 1, 1, 5, 1, 3, 1,
	3, 1, 1, 1, 1, 6, 6, 4, 4, 4,
	4, 4, 6, 5, 5, 5, 4, 8, 6, 6,
	4, 4, 4, 5, 0, 5, 0, 2, 0, 1,
	3, 3, 2, 2, 0, 6, 1, 0, 3, 0,
	2, 2, 0, 1, 4, 2, 2, 2, 2, 2,
	4, 3, 5, 4, 3, 5, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2, 1, 2,
	1, 3, 1, 3, 3, 3, 2, 1, 3, 3,
	1, 1, 1, 1, 1, 1, 1, 1, 4, 3,
	1, 2, 3, 0, 3, 3, 2, 2, 1, 0,
	2, 2, 3, 2, 1, 1, 3, 5, 1, 2,
	4, 2, 0, 1, 0, 3, 5, 1, 0, 2,
	2, 1, 1, 1, 2, 1, 2, 1, 0, 1,
	1, 1, 3, 3, 1, 3, 3, 2, 1, 1,
	1, 3, 1, 3, 1, 3, 1, 2, 3, 1,
	1, 1, 2, 2, 1, 3, 3, 0, 1, 2,
	1, 1, 1, 1, 6, 2, 1, 5, 1, 1,
	1, 1, 2, 2, 3, 1, 1, 1, 1, 0,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1,
}
var sqlChk = [...]int{

	-1000, -1, -2, -3, -4, -5, -6, -7, -14, -15,
	-16, -18, -19, -21, -22, -23, -24, -26, -28, -30,
	-29, -31, -32, -33, -34, -35, -36, -25, -27, -37,
	-38, -39, 23, 34, 225, 66, -8, -9, -10, -11,
	-12, -13, -258, 94, 103, 125, 206, 101, 87, 119,
	228, 235, -45, -47, 245, -148, 248, 35, 257, 60,
	97, 230, 223, 224, 282, 291, 68, -256, -48, -46,
	333, 307, 314, 239, -49, 266, 299, 336, 266, 134,
	80, 302, -274, -101, 266, 80, -76, -67, 326, 4,
	-235, -237, 20, 21, 23, 33, 34, 35, 40, 44,
	47, 54, 59, 60, 61, 63, 65, 66, 67, 70,
	71, 78, 79, 81, 83, 87, 89, 93, 94, 96,
	101, 102, 103, 109, 110, 113, 115, 120, 125, 126,
	127, 128, 135, 138, 140, 133, 148, 150, 151, 154,
	153, 158, 161, 164, 166, 167, 168, 171, 169, 173,
	174, 176, 175, 181, 183, 184, 186, 189, 192, 195,
	198, 199, 200, 201, 204, 206, 208, 209, 210, 211,
	213, 214, 216, 217, 218, 219, 220, 223, 221, 222,
	224, 225, 226, 228, 230, 231, 233, 246, 247, 258,
	235, 236, 237, 238, 241, 242, 243, 245, 248, 250,
	253, 256, 257, 259, 262, 260, 255, 265, 267, 268,
	269, 270, 271, 278, 282, 283, 284, 285, 288, 289,
	290, 291, 293, 296, 297, 298, 303, 308, 309, 310,
	311, 312, 28, 36, 37, 38, 39, 41, 42, 45,
	46, 50, 51, 52, 55, 82, 84, 85, 100, 104,
	105, 111, 121, 123, 129, 130, 139, 141, 142, 143,
	145, 156, 170, 180, 182, 193, 197, 203, 205, 212,
	232, 240, 251, 252, 261, 263, 273, 274, 275, 279,
	280, 295, 299, 300, -274, -75, -67, 80, 89, 138,
	290, 289, 80, 134, 266, 302, -17, 333, -29, -7,
	-15, -4, -24, -38, -14, -32, -18, -33, -34, -35,
	-16, 23, -227, 4, -235, -237, -236, -238, 57, 69,
	118, 137, 131, 147, 149, 157, 159, 172, 194, 196,
	229, 249, 22, 24, 25, 26, 27, 29, 30, 31,
	32, 43, 48, 49, 53, 56, 58, 64, 68, 72,
	73, 74, 75, 76, 77, 86, 88, 90, 91, 92,
	95, 97, 99, 106, 107, 108, 114, 116, 117, 119,
	122, 124, 132, 134, 136, 144, 146, 152, 155, 160,
	162, 163, 177, 178, 179, 185, 187, 188, 190, 191,
	202, 207, 215, 227, 239, 244, 254, 264, 266, 272,
	276, 277, 281, 286, 287, 292, 294, 301, 302, 304,
	305, 306, 307, -67, -67, -67, 206, 22, -278, 22,
	-279, -280, 68, 94, 119, 239, 138, 89, 289, -278,
	-71, 235, -67, -145, 161, 242, 54, 232, 278, -146,
	-144, -226, 273, -149, -102, 171, -67, 4, 171, 244,
	80, 22, 34, 54, 59, 81, 120, 134, 135, 64,
	65, 151, 209, 161, 243, 267, 273, 278, 68, 293,
	269, 102, -283, 278, 278, -283, -283, -70, 278, 276,
	-71, 4, 80, 244, 171, -282, 266, -231, -224, -187,
	9, 281, 106, 187, -230, 8, 325, -223, -229, 5,
	7, 324, 4, -235, -237, -236, 266, 292, 302, -132,
	80, 287, -46, -48, -47, -90, -91, 286, 144, 99,
	191, -45, -47, -256, -259, 213, -255, -67, -259, -87,
	-88, 22, 91, 337, -195, -75, 188, -114, 333, -3,
	-195, 129, -75, -78, 129, -75, -67, -195, 129, 276,
	337, -101, -94, -67, -157, -156, 335, 117, 117, 333,
	-111, -112, -156, -157, 117, 146, 146, -196, -195, -67,
	129, -79, 129, -78, -103, 129, -102, -103, 129, -201,
	-200, -229, 299, 266, 134, -175, 333, -128, 333, -67,
	22, 187, 337, 187, -67, -145, 52, -145, 246, 333,
	-150, -151, -64, -65, -66, 148, 208, 211, 276, 318,
	117, 312, -231, -83, 86, -105, 335, 54, -233, -230,
	9, 246, 209, 243, 117, -275, 187, 117, 117, 117,
	117, 117, 209, 243, 117, 312, 148, 208, 258, 266,
	302, 117, 117, -147, -150, -147, 276, -71, -117, -195,
	8, 7, 7, -102, 129, -67, -102, 134, -67, 129,
	-90, -91, -116, -135, -136, 160, 108, 185, -119, 22,
	91, -119, -119, 44, 334, 334, 337, -259, -95, 333,
	-106, -197, -163, 326, -165, 324, 325, 319, 177, 313,
	-177, -167, -180, 100, 232, 333, -75, -166, 338, 9,
	-253, -47, 29, -178, -179, 48, -67, 7, 8, 5,
	6, -73, -204, -173, -213, 281, 106, 179, -251, -252,
	4, -235, -228, -205, -215, -209, -212, 145, 57, 73,
	76, 74, 77, 244, 292, 49, 28, 104, 105, 197,
	203, 263, 279, 280, 129, 180, 130, 55, 121, 156,
	93, 37, 39, 41, 42, 50, 51, 82, 84, 85,
	111, 139, 141, 142, 143, 182, 212, 251, 261, 274,
	275, 300, -236, -216, -217, -210, -211, -218, -106, -114,
	326, -75, 333, -113, -186, -163, 86, -54, 221, -53,
	21, 23, 94, 297, 100, 255, 270, 236, 255, 270,
	236, 221, 100, 338, 221, 221, 100, -233, -76, 337,
	-227, 326, -234, -233, 259, 334, -100, -75, -112, -196,
	-77, -75, -77, 245, -67, 30, 100, -56, 337, 47,
	226, 100, -56, 337, 100, -56, 100, 334, 337, -195,
	129, -78, 30, -174, -202, -203, -205, -214, -208, -212,
	-213, 40, 46, 45, 271, 170, 240, 252, 295, 38,
	186, 140, 139, 141, 142, 143, 251, 37, 212, 111,
	93, 85, 84, 182, 42, 41, -216, -217, -210, -211,
	82, 274, 275, 145, 39, 51, 50, 300, 261, -104,
	-163, -274, -280, -274, 30, -144, -226, -104, 337, 158,
	-82, 164, 176, 126, 188, 310, -225, 86, -231, -225,
	86, 71, -232, 5, 4, -173, -187, 86, 161, -213,
	335, -227, 247, -102, 22, -226, -277, 114, -274, -226,
	-226, -226, -226, -226, -67, 158, -226, -226, 266, 134,
	266, -71, -56, 337, 333, -89, 177, -257, 307, -89,
	333, -68, 129, -67, -257, 177, -116, -136, -135, -137,
	-163, 22, -140, 110, 173, -163, -165, -46, -46, -46,
	-92, -191, -163, -255, 30, -94, -97, 337, 117, 10,
	11, 56, 33, 324, 325, 326, 327, 112, 328, 329,
	322, 323, 321, 316, 317, 318, 62, 165, 234, 13,
	14, 15, 26, 190, 159, 313, 131, 249, 319, 16,
	17, 18, 147, 36, 132, -72, 30, 4, -80, -163,
	-163, -163, -163, -163, 196, -110, -158, 331, -47, 333,
	-47, -163, -104, 7, -47, -172, 331, -181, -163, -111,
	333, 5, 333, 5, -260, 308, 114, 333, 333, 333,
	333, 333, 333, 333, 333, 333, 333, 333, 333, 333,
	333, 333, 333, 333, 205, -222, 303, -222, -222, -206,
	333, -206, -207, 333, -206, 309, 314, 333, -97, -75,
	337, 334, 337, 276, -133, 64, 58, -153, 129, 58,
	-239, -67, 64, -240, 53, 287, 207, 116, -133, 64,
	-133, 64, 64, -195, 33, -29, 117, 33, -29, 117,
	276, -78, -67, 276, 276, -195, -199, 315, -67, -199,
	337, 117, 334, 337, -155, 305, -141, -29, 333, 86,
	30, -141, -107, -108, -198, -109, -75, 333, -67, -67,
	-78, -79, -102, -103, -103, -17, -200, 100, -20, -29,
	-24, -38, -14, 334, 337, -96, 29, -129, 333, 311,
	168, 83, 127, 167, -130, 238, 334, 337, 276, 117,
	278, 334, -151, -81, 211, 253, 222, 241, 337, -227,
	-276, -67, -75, -78, -75, -195, -84, -94, -85, -67,
	-154, -153, -241, -242, -239, 134, 287, 107, 30, 100,
	-63, 201, 30, 187, 177, -59, 268, 100, -138, -223,
	333, 325, -139, 232, 233, 337, -52, 31, 90, 333,
	334, -155, -197, -99, -193, 331, -195, -75, -47, -194,
	333, -220, -202, -219, 217, 218, 216, 220, 219, -202,
	-227, 273, -163, -163, -163, -163, -163, -163, -163, -163,
	-163, -163, -163, -163, -163, -163, -163, -163, -163, -163,
	-163, -163, -163, -163, 159, 131, 249, 36, 132, -163,
	276, -163, -163, -163, -163, 169, 177, 179, 281, 106,
	288, 91, 183, -285, 264, 32, -170, -47, 333, -185,
	27, 254, 22, -227, -177, 232, 333, -158, -163, -159,
	-104, 334, 334, 337, -104, -176, 332, -172, -184, -183,
	304, 334, -104, 301, 22, 91, 326, 7, -129, -261,
	109, 122, 333, 334, 334, -163, -163, -123, -221, -104,
	4, 311, 168, 83, 127, 167, 238, -123, -124, -163,
	-104, -125, -164, -165, 324, 325, 319, 333, 232, -126,
	-163, -104, -163, 43, 155, 277, -127, -163, 117, -104,
	-163, -163, -163, -104, -104, -104, 333, 7, 7, 273,
	273, 7, -155, 334, -186, -53, -75, -67, -67, 177,
	-153, 129, -58, 177, -202, -67, 333, 333, 150, 150,
	-67, -67, 129, -67, 129, -67, -67, -54, 221, -29,
	333, -29, 333, -67, 221, -67, -75, 221, -40, 128,
	183, -43, 307, -233, 259, 117, -75, -118, 227, -163,
	-118, -143, 187, -100, 299, -67, -118, -98, 337, 117,
	318, -100, -56, -56, -56, -195, -202, 331, 331, 7,
	276, 276, 276, 276, 333, -163, -276, -276, -64, 285,
	61, 211, -231, 337, -199, 334, 334, 337, -68, 134,
	-68, -29, -102, 5, -29, -75, 100, -60, 96, -284,
	318, -67, -139, -163, -191, -20, -115, 122, -199, 337,
	69, -122, 149, 172, 118, 157, 229, 137, 7, 103,
	-32, -160, 338, 333, -190, 314, -47, -194, -193, 312,
	-163, -163, 276, -285, 264, -170, -163, 169, 179, 281,
	106, 288, 91, 183, 117, 333, -164, -164, -104, -167,
	333, -104, 332, 341, 334, -163, 332, 332, 337, -182,
	-183, 95, -163, -91, 337, -90, -163, -104, -104, 334,
	334, -266, 195, 333, 333, -163, 30, 337, 334, 117,
	334, 334, -131, 202, 334, 10, 11, 324, 325, 326,
	327, 112, 328, 329, 322, 323, 321, 316, 317, 318,
	62, 165, 234, 13, 14, 15, 147, 132, -164, -164,
	-164, -104, 333, 334, -168, -169, 117, 114, 30, -127,
	-127, -127, 334, 117, -104, 337, 337, 337, 334, 334,
	334, 7, 334, 337, 334, 312, 312, 334, -115, 276,
	276, 100, 177, 296, -243, -240, -163, -93, -192, -67,
	-254, 333, -251, -252, -73, 333, 333, -51, 94, 245,
	-134, 100, -56, 100, -56, 276, -133, 64, -104, -104,
	276, 276, -43, 117, 265, 189, 259, -106, 178, -118,
	63, 334, -155, -108, -99, -186, 334, 332, 7, 7,
	334, 168, 127, 167, -130, 167, -130, -130, 7, -67,
	-86, 133, -154, 333, -68, 333, 333, -89, 333, -67,
	-61, 154, -284, -230, -257, 188, 334, 334, -171, 124,
	44, -193, 149, 149, -193, -122, 149, -120, 194, -120,
	-120, -272, 333, -17, 333, 332, -190, -227, 331, 339,
	-104, -189, -188, 30, -67, 192, 334, -163, -163, -164,
	-164, 117, 333, -163, -174, 26, 26, 334, -104, 334,
	337, -159, -163, 334, -172, 97, -163, 272, 334, 301,
	-91, -91, -91, 5, -267, -67, 333, 305, -90, 334,
	-220, -202, -163, -168, -163, -220, -202, -164, -164, -164,
	-164, -164, -164, -164, -164, -164, -164, -164, -164, -164,
	-164, -164, -164, -164, -164, -164, 91, 177, 183, -164,
	337, -104, 334, -169, -168, -163, -163, -202, 334, 334,
	334, -104, -163, -163, -163, 334, 7, -171, -67, -67,
	-153, 100, -244, 64, -245, 56, 107, 68, 177, 179,
	287, 207, 53, 86, 215, 334, 334, 337, -74, -111,
	56, -74, -163, 333, -93, -94, 177, 86, 177, 86,
	79, 283, -67, -67, -75, -67, -67, 334, 334, -67,
	-75, -234, 273, 333, -142, 333, 187, -29, -118, 318,
	332, 332, 334, 132, -93, 333, -94, -84, 30, -93,
	187, -62, 153, -284, -230, -59, -263, 306, -163, -104,
	-193, -193, -121, 294, 187, 149, -193, 332, 334, -273,
	7, 332, -201, -190, -189, 7, -162, -161, 115, 175,
	334, -67, 333, -190, 26, 26, -163, -174, 334, -163,
	-163, 334, -163, 332, -163, 5, -163, 334, 334, 334,
	-268, -67, -163, 334, 334, 334, -169, 117, 91, 183,
	333, -163, 334, 334, 337, 334, 334, 334, -263, -153,
	-67, -227, -67, 107, 129, 179, 150, 333, -164, -75,
	-152, -281, 67, 262, -192, -52, -227, -52, 334, -104,
	334, 334, 179, 179, -163, -202, -56, -56, 276, 276,
	276, 276, -166, -73, -67, -42, -41, 5, 92, -94,
	64, -114, -47, 333, 198, 334, -93, 334, 334, -29,
	334, -75, -284, -230, -60, -264, -265, -67, -121, 333,
	-163, -193, -160, 334, 337, -190, 334, -189, 332, 337,
	340, 318, -190, 333, -94, -188, -163, -163, 334, 334,
	-91, -262, 200, 334, -164, 117, 333, -174, 334, -163,
	-245, -68, 177, -163, -69, 333, -86, 333, -74, -91,
	215, -55, 56, -67, -67, 333, 333, 333, 337, 334,
	-44, 318, 289, 178, 334, -67, -67, -152, 334, -86,
	-152, 333, -230, -61, 337, 30, -94, -190, 7, -189,
	-17, -161, -227, 331, -189, -94, 334, 334, -91, 44,
	-164, -174, 334, 334, 100, 334, -248, 166, -67, -94,
	-52, 334, -75, -50, 294, -227, -104, -104, -104, -41,
	5, 245, -155, 333, -86, -152, -86, -93, -62, -265,
	-267, 334, -188, 332, 7, 334, -269, 210, 233, -104,
	334, 107, -246, -249, -247, 187, 118, 199, 250, 334,
	334, -89, -163, 334, 334, -91, -107, -94, -86, 334,
	-190, 332, 334, -270, -271, 36, 284, 71, -163, -270,
	-67, -247, 187, -249, 187, 289, 89, -248, 334, -155,
	334, -152, -189, -271, 204, 113, 232, 204, 113, -250,
	174, 226, 47, 245, -250, -246, -57, 47, 226, -86,
	26, 20, 179, 86, -271,
}
var sqlDef = [...]int{

	-2, -2, 1, 3, 4, 5, 6, 7, 8, 9,
	10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	30, 31, 0, 0, 0, 0, 81, 82, 83, 84,
	85, 86, 0, 0, 445, 0, 0, 0, 0, 0,
	0, 0, 417, -2, 0, 162, 0, 361, 0, 361,
	361, 365, 0, 0, 447, 0, 327, 444, -2, 455,
	0, 0, 0, 453, 431, 0, 0, -2, 0, 0,
	0, 0, 0, 136, 0, 985, 914, 920, 921, 945,
	946, 947, 964, 965, 966, 967, 968, 969, 970, 971,
	972, 973, 974, 975, 976, 977, 978, 979, 980, 981,
	982, 983, 984, 986, 987, 988, 989, 990, 991, 992,
	993, 994, 995, 996, 997, 998, 999, 1000, 1001, 1002,
	1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012,
	1013, 1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022,
	1023, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032,
	1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042,
	1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052,
	1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062,
	1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1072,
	1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082,
	1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092,
	1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102,
	1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112,
	1113, 1114, 1115, 1116, 1117, 1118, 1119, 1120, 1121, 1122,
	1123, 1124, 1125, 1126, 1127, 1128, 1129, 1130, 1131, 1132,
	1133, 1134, 1135, 1136, 1137, 1138, 1139, 1140, 1141, 1142,
	1143, 1144, 1145, 1146, 1147, 1148, 1149, 1150, 1151, 1152,
	1153, 1154, 1155, 1156, 0, 0, 916, 985, 0, 0,
	0, 0, 0, 0, 0, 0, 102, 0, 104, 105,
	106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
	116, 0, 239, 959, 960, 961, 962, 963, 1157, 1158,
	1159, 1160, 1161, 1162, 1163, 1164, 1165, 1166, 1167, 1168,
	1169, 1170, 1171, 1172, 1173, 1174, 1175, 1176, 1177, 1178,
	1179, 1180, 1181, 1182, 1183, 1184, 1185, 1186, 1187, 1188,
	1189, 1190, 1191, 1192, 1193, 1194, 1195, 1196, 1197, 1198,
	1199, 1200, 1201, 1202, 1203, 1204, 1205, 1206, 1207, 1208,
	1209, 1210, 1211, 1212, 1213, 1214, 1215, 1216, 1217, 1218,
	1219, 1220, 1221, 1222, 1223, 1224, 1225, 1226, 1227, 1228,
	1229, 1230, 1231, 1232, 1233, 1234, 1235, 1236, 1237, 1238,
	1239, 1240, 1241, 1242, 1243, 1244, 1245, 1246, 1247, 1248,
	1249, 1250, 1251, 122, 129, 130, 1038, 132, 0, 139,
	140, 141, 143, 144, 145, 146, 147, 148, 149, 0,
	354, 1063, 367, 157, 1015, 1068, 973, 1143, 1086, 165,
	170, 0, 1149, 173, 178, -2, 98, 204, 205, 206,
	207, 208, 0, 0, 0, 214, 241, 0, 0, 0,
	0, 0, 221, 0, 224, 228, 0, 0, 0, 235,
	0, 0, 369, 360, 369, 357, 358, 359, 362, 0,
	353, 152, 153, 154, 155, 0, 446, 156, 181, 182,
	183, 192, 193, 194, 195, 316, 0, 318, 202, 203,
	941, 0, 955, 956, 957, 958, 0, 0, 0, 0,
	0, 326, -2, 427, 428, -2, 0, 450, 450, 450,
	0, 0, 428, 0, 436, 1043, 439, 927, 437, 0,
	0, 452, 451, 0, 432, 534, 0, 481, 0, 2,
	0, 1127, 534, 0, 1127, 919, 0, 0, 1127, 0,
	0, 137, 138, 924, 922, 923, 0, 0, 0, 0,
	917, 893, 891, 892, 0, 0, 0, 0, 540, 88,
	1127, 56, 1127, 912, 56, 1127, 96, 56, 1127, 0,
	117, 119, 1155, 0, 0, 0, 0, 127, 0, 131,
	133, 0, 0, 0, 366, 158, 1116, 160, 0, 0,
	164, 370, 372, 373, 374, 0, 0, 0, 0, 0,
	0, 0, 174, 175, 176, 99, 0, 0, 209, 65,
	66, 0, 222, 225, 0, 243, 0, 0, 0, 0,
	0, 0, 223, 226, 0, 229, 0, 231, 232, 0,
	0, 0, 0, 355, 368, 356, 0, 364, 56, 538,
	317, 943, 942, 299, 1127, 443, 299, 949, 443, 1127,
	-2, 0, 423, 462, 463, 0, 0, 0, 0, 448,
	449, 0, 0, 0, 419, 420, 0, 438, 0, 0,
	484, 904, 908, 909, 638, 0, 0, 0, 0, 0,
	0, 730, 732, 1121, 1143, 0, 734, 735, 0, 737,
	739, 740, 0, 743, 744, 884, 916, 930, 931, 932,
	933, 0, 0, 936, 0, 938, 939, 940, 784, 753,
	-2, -2, 928, 570, 571, 572, 573, -2, 1157, 757,
	759, 761, 762, 763, 764, 0, 1105, 1122, 1123, 1139,
	1140, 1148, 1152, 1153, 1127, 1136, 1128, 1117, 1125, 1134,
	990, -2, -2, -2, -2, -2, -2, -2, -2, -2,
	-2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
	-2, -2, 954, 600, 601, 606, 607, 609, 484, 482,
	535, 536, 0, 0, 901, 899, 900, 33, 350, 35,
	0, 350, 350, 0, 0, 0, 0, 248, 0, 0,
	250, 0, 0, 0, 0, 0, 0, 525, 915, 0,
	889, 890, 525, 67, 78, 0, 0, 910, 894, 544,
	0, 394, 0, 0, 541, 0, 0, 90, 0, 54,
	55, 0, 92, 0, 0, 94, 0, 445, 0, 0,
	1127, 0, 445, 0, 842, 552, 553, 554, 555, 556,
	635, 559, 560, 561, 562, 563, 564, 565, 566, 567,
	568, 569, 577, 578, 579, 580, 581, 582, 583, 597,
	0, 576, 576, 576, 589, 590, 598, 599, 604, 605,
	616, 617, 619, 621, 615, 615, 615, 612, 613, 0,
	840, 0, 142, 0, 0, 161, 0, 0, 0, 0,
	375, 189, 190, 191, 377, 378, 166, 168, 179, 167,
	169, 171, 172, 196, 197, 198, 199, 200, 201, 0,
	0, 100, 212, 210, 211, 213, 215, 0, 240, 216,
	217, 218, 219, 220, 227, 230, 233, 234, 0, 0,
	0, 363, 319, 0, 257, 0, 0, 322, 442, 0,
	0, 0, 1127, 948, 382, 0, 426, 460, 461, 464,
	468, 469, 472, 475, 476, 466, 638, 433, 434, 435,
	456, 457, 337, 440, 0, 0, 544, 0, 0, 0,
	0, 0, 0, 819, 820, 821, 822, 823, 824, 827,
	828, 825, 826, 829, 830, 831, 0, 0, 0, 832,
	833, 834, 0, 0, 836, 0, 838, 0, 0, 0,
	0, 0, 0, 898, 0, 0, 0, 907, 835, 643,
	644, 645, 667, 668, 0, 731, 895, 888, 733, 0,
	-2, 840, 0, 736, 741, 742, 0, 0, 883, -2,
	0, 935, 0, 635, 786, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 863, 869, 0, 0, 0, 0,
	0, 0, 0, 0, 585, 603, 614, 611, 610, 587,
	0, 586, 584, 0, 588, 0, 0, 0, 544, 0,
	0, 903, 0, 0, 0, 0, 349, 37, 1127, 0,
	58, 0, 0, 289, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 246, 0, 0, 247, 0,
	0, 0, 918, 0, 0, 0, 70, 0, 925, 77,
	0, 0, 0, 0, 406, 0, 406, 396, 0, 0,
	0, 406, 409, 410, 412, 413, 0, 0, 542, 89,
	913, 56, 97, 56, 56, 103, 118, 0, 120, 123,
	124, 125, 126, 121, 0, 545, 547, 557, 0, 622,
	623, 624, 625, 626, 627, 636, 128, 0, 0, 0,
	0, 163, 371, 376, 0, 186, 0, 188, 0, 101,
	242, 150, 236, 237, 525, 539, 0, 0, 256, 924,
	258, 260, 261, 262, 263, 949, 0, 949, 0, 0,
	320, 0, 0, 0, 0, 384, 390, 0, 0, 470,
	0, 0, 467, 473, 474, 0, 459, 335, 336, 445,
	926, 478, 905, 525, 485, 0, 495, 534, 511, 500,
	0, 639, 548, 549, 591, 592, 593, 594, 595, 640,
	641, 0, 646, 647, 648, 649, 650, 651, 652, 653,
	654, 655, -2, -2, -2, 659, 660, 661, -2, -2,
	-2, 665, 666, -2, 837, 839, 0, 898, 0, -2,
	0, -2, -2, -2, -2, 679, 0, 681, 684, 686,
	688, 0, 0, 0, 0, 897, 698, 875, 0, 0,
	816, 817, 818, 906, 683, 0, 0, 896, 887, 0,
	0, -2, 738, 0, 0, 0, 846, 847, 882, 878,
	0, 745, 455, 0, 0, 0, 0, 0, 944, 794,
	0, 0, 0, 758, 760, 0, 0, 0, 0, 850,
	-2, -2, -2, -2, -2, -2, -2, 0, 0, 840,
	860, 0, 0, 701, 0, 0, 0, 0, 1143, 0,
	840, 868, 0, 0, 0, 0, 0, 840, 0, 874,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 478, 537, 902, 36, 339, 0, 0, 0,
	39, 1127, 47, 0, 271, 0, 0, 0, 0, 0,
	352, 48, 1127, 56, 1127, 56, 49, 34, 350, 244,
	0, 245, 0, 343, 0, 338, 341, 0, 77, 0,
	0, 64, 0, 68, 79, 0, 911, 87, 0, 543,
	391, 406, 0, 0, 398, 395, 393, 544, 0, 0,
	0, 0, 91, 93, 95, 0, 843, 0, 0, 0,
	0, 0, 0, 0, 0, 841, 134, 135, 159, 184,
	185, 187, 180, 0, 238, 265, 298, 0, 0, 949,
	0, 254, 299, 321, 323, 0, 0, 386, 390, 0,
	389, 443, 0, 0, 458, 0, 480, 0, 483, 0,
	0, 0, 0, 0, 531, 531, 531, 529, 505, 445,
	0, 511, 0, 0, 523, 0, -2, 500, 0, 0,
	-2, -2, 0, 0, 0, 699, -2, 680, 682, 685,
	687, 689, 0, 0, 0, 0, 0, 0, 0, 700,
	0, 0, 885, 888, -2, 841, 844, 845, 0, 0,
	879, 0, 0, 0, 0, 454, 455, 455, 455, 751,
	0, 752, 0, 0, 0, 0, 0, 0, 767, 0,
	768, 769, 0, 0, 770, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 704, 705,
	706, 0, 0, 771, 866, 867, 0, 0, 0, 0,
	0, 0, 776, 0, 873, 0, 0, 0, 780, 781,
	782, 0, 574, 0, 596, 618, 620, 608, 480, 0,
	0, 0, 0, 57, 269, 288, 0, 0, 328, 334,
	334, 0, 754, 755, 0, 0, 0, 41, 0, 0,
	0, 0, 45, 0, 51, 0, 0, 0, 0, 0,
	0, 0, 63, 0, 0, 0, 80, 404, 405, 392,
	403, 0, 406, 411, 408, 414, 0, 550, 0, 0,
	558, 628, 629, 630, 631, 632, 633, 634, 0, 151,
	252, 0, 259, 0, 0, 0, 257, 0, 0, 0,
	388, 390, 0, 381, 382, 465, 471, 441, 788, 0,
	0, 486, 0, 0, 0, 0, 0, 526, 530, 527,
	528, 0, 0, 0, 0, 511, 523, 492, 0, 0,
	0, 499, 522, 0, 521, 510, -2, 642, -2, 0,
	0, 0, 0, -2, 0, 0, 0, 876, 0, 811,
	0, 0, 887, -2, 848, 877, 881, 0, 746, 0,
	0, 0, 0, 937, 792, 793, 797, 0, 0, 756,
	0, 0, 849, 859, 861, 702, 703, 707, 708, 709,
	710, 711, 712, 713, 714, 715, 716, -2, -2, -2,
	720, 721, 722, -2, -2, -2, 0, 0, 0, 862,
	0, 0, 814, 864, 865, 870, 871, 0, 773, 774,
	775, 872, 0, 0, 0, 602, 0, 788, 345, 347,
	38, 0, 270, 0, 273, 0, 0, 0, 0, 279,
	280, 0, 0, 0, 0, 290, 297, 0, 337, 929,
	0, 337, 0, 0, 0, 0, 0, 53, 0, 0,
	351, 0, 56, 56, 340, 0, 0, 0, 0, 344,
	342, 69, 0, 0, 0, 0, 0, 397, 407, 0,
	551, 546, 637, 0, 0, 0, 0, 0, 0, 0,
	0, 379, 390, 0, 383, 384, 429, 0, 479, 477,
	513, 0, 515, 0, 0, 0, 517, 495, 506, 0,
	508, 511, 0, 523, 497, 0, 0, 490, 0, 489,
	511, 519, 0, 0, 0, 0, -2, 0, 692, -2,
	-2, 810, 841, 886, 880, 934, 455, 747, 749, 750,
	799, 796, 0, 783, 765, 766, 858, 0, 0, 0,
	0, 841, 813, 772, 0, 778, 779, 575, 430, 40,
	0, 274, 275, 949, 0, 278, 281, 0, 283, 951,
	265, 0, 294, 295, 329, 330, 333, 331, 334, 455,
	292, 0, 42, 43, 52, 60, 44, 50, 0, 0,
	0, 0, 524, 0, 0, 0, 74, 72, 0, 0,
	0, 415, 416, 0, 0, 297, 0, 287, 265, 255,
	297, 0, 0, 385, 386, 787, 789, 0, 514, 0,
	533, 516, 511, 507, 0, 523, 445, 504, 493, 0,
	494, 0, 523, 0, 0, 501, -2, -2, 693, 812,
	0, 455, 0, 785, -2, 0, 0, 0, 815, 0,
	272, 276, 0, 0, 303, 0, 291, 0, 337, 0,
	0, 62, 0, 346, 348, 0, 0, 0, 0, 76,
	73, 0, 0, 400, 544, 402, 0, 265, 297, 253,
	265, 0, 387, 388, 0, 0, 0, 0, 509, 502,
	0, 491, 487, 0, 498, 0, 520, 748, 802, 0,
	-2, 0, 728, 777, 0, 282, 308, 0, 0, 0,
	332, 746, 299, 46, 0, 59, 0, 0, 455, 75,
	71, 0, 401, 0, 285, 265, 324, 0, 380, 790,
	791, 532, 496, 511, 0, 518, 0, 0, 0, 798,
	729, 0, 284, 304, 305, 0, 300, 301, 302, 950,
	296, 303, 61, 249, 251, 0, 544, 0, 286, 297,
	523, 488, 795, 800, 803, -2, 1089, 982, 0, 801,
	277, 306, 0, 307, 0, 0, 0, 308, 0, 399,
	268, 265, 503, 0, 805, 806, 807, 808, 809, 309,
	0, 312, 313, 0, 310, 293, 264, 266, 267, 325,
	0, 311, 314, 315, 804,
}
var sqlTok1 = [...]int{

	1, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 322, 3, 328, 323, 3,
	333, 334, 326, 324, 337, 325, 335, 327, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 341, 336,
	316, 318, 317, 3, 338, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 331, 3, 332, 329, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 339, 321, 340, 319,
}
var sqlTok2 = [...]int{

	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
	62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
	72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
	82, 83, 84, 85, 86, 87, 88, 89, 90, 91,
	92, 93, 94, 95, 96, 97, 98, 99, 100, 101,
	102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
	112, 113, 114, 115, 116, 117, 118, 119, 120, 121,
	122, 123, 124, 125, 126, 127, 128, 129, 130, 131,
	132, 133, 134, 135, 136, 137, 138, 139, 140, 141,
	142, 143, 144, 145, 146, 147, 148, 149, 150, 151,
	152, 153, 154, 155, 156, 157, 158, 159, 160, 161,
	162, 163, 164, 165, 166, 167, 168, 169, 170, 171,
	172, 173, 174, 175, 176, 177, 178, 179, 180, 181,
	182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
	192, 193, 194, 195, 196, 197, 198, 199, 200, 201,
	202, 203, 204, 205, 206, 207, 208, 209, 210, 211,
	212, 213, 214, 215, 216, 217, 218, 219, 220, 221,
	222, 223, 224, 225, 226, 227, 228, 229, 230, 231,
	232, 233, 234, 235, 236, 237, 238, 239, 240, 241,
	242, 243, 244, 245, 246, 247, 248, 249, 250, 251,
	252, 253, 254, 255, 256, 257,
}
var sqlTok3 = [...]int{
	57600, 258, 57601, 259, 57602, 260, 57603, 261, 57604, 262,
	57605, 263, 57606, 264, 57607, 265, 57608, 266, 57609, 267,
	57610, 268, 57611, 269, 57612, 270, 57613, 271, 57614, 272,
	57615, 273, 57616, 274, 57617, 275, 57618, 276, 57619, 277,
	57620, 278, 57621, 279, 57622, 280, 57623, 281, 57624, 282,
	57625, 283, 57626, 284, 57627, 285, 57628, 286, 57629, 287,
	57630, 288, 57631, 289, 57632, 290, 57633, 291, 57634, 292,
	57635, 293, 57636, 294, 57637, 295, 57638, 296, 57639, 297,
	57640, 298, 57641, 299, 57642, 300, 57643, 301, 57644, 302,
	57645, 303, 57646, 304, 57647, 305, 57648, 306, 57649, 307,
	57650, 308, 57651, 309, 57652, 310, 57653, 311, 57654, 312,
	57655, 313, 57656, 314, 57657, 315, 57658, 320, 57659, 330,
	0,
}

var sqlErrorMessages = [...]struct {
	state int
	token int
	msg   string
}{}

//line yaccpar:1

/*	parser for yacc output	*/

var (
	sqlDebug        = 0
	sqlErrorVerbose = false
)

type sqlLexer interface {
	Lex(lval *sqlSymType) int
	Error(s string)
}

type sqlParser interface {
	Parse(sqlLexer) int
	Lookahead() int
}

type sqlParserImpl struct {
	lval  sqlSymType
	stack [sqlInitialStackSize]sqlSymType
	char  int
}

func (p *sqlParserImpl) Lookahead() int {
	return p.char
}

func sqlNewParser() sqlParser {
	return &sqlParserImpl{}
}

const sqlFlag = -1000

func sqlTokname(c int) string {
	if c >= 1 && c-1 < len(sqlToknames) {
		if sqlToknames[c-1] != "" {
			return sqlToknames[c-1]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func sqlStatname(s int) string {
	if s >= 0 && s < len(sqlStatenames) {
		if sqlStatenames[s] != "" {
			return sqlStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func sqlErrorMessage(state, lookAhead int) string {
	const TOKSTART = 4

	if !sqlErrorVerbose {
		return "syntax error"
	}

	for _, e := range sqlErrorMessages {
		if e.state == state && e.token == lookAhead {
			return "syntax error: " + e.msg
		}
	}

	res := "syntax error: unexpected " + sqlTokname(lookAhead)

	// To match Bison, suggest at most four expected tokens.
	expected := make([]int, 0, 4)

	// Look for shiftable tokens.
	base := sqlPact[state]
	for tok := TOKSTART; tok-1 < len(sqlToknames); tok++ {
		if n := base + tok; n >= 0 && n < sqlLast && sqlChk[sqlAct[n]] == tok {
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}
	}

	if sqlDef[state] == -2 {
		i := 0
		for sqlExca[i] != -1 || sqlExca[i+1] != state {
			i += 2
		}

		// Look for tokens that we accept or reduce.
		for i += 2; sqlExca[i] >= 0; i += 2 {
			tok := sqlExca[i]
			if tok < TOKSTART || sqlExca[i+1] == 0 {
				continue
			}
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}

		// If the default action is to accept or reduce, give up.
		if sqlExca[i+1] != 0 {
			return res
		}
	}

	for i, tok := range expected {
		if i == 0 {
			res += ", expecting "
		} else {
			res += " or "
		}
		res += sqlTokname(tok)
	}
	return res
}

func sqllex1(lex sqlLexer, lval *sqlSymType) (char, token int) {
	token = 0
	char = lex.Lex(lval)
	if char <= 0 {
		token = sqlTok1[0]
		goto out
	}
	if char < len(sqlTok1) {
		token = sqlTok1[char]
		goto out
	}
	if char >= sqlPrivate {
		if char < sqlPrivate+len(sqlTok2) {
			token = sqlTok2[char-sqlPrivate]
			goto out
		}
	}
	for i := 0; i < len(sqlTok3); i += 2 {
		token = sqlTok3[i+0]
		if token == char {
			token = sqlTok3[i+1]
			goto out
		}
	}

out:
	if token == 0 {
		token = sqlTok2[1] /* unknown char */
	}
	if sqlDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", sqlTokname(token), uint(char))
	}
	return char, token
}

func sqlParse(sqllex sqlLexer) int {
	return sqlNewParser().Parse(sqllex)
}

func (sqlrcvr *sqlParserImpl) Parse(sqllex sqlLexer) int {
	var sqln int
	var sqlVAL sqlSymType
	var sqlDollar []sqlSymType
	_ = sqlDollar // silence set and not used
	sqlS := sqlrcvr.stack[:]

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	sqlstate := 0
	sqlrcvr.char = -1
	sqltoken := -1 // sqlrcvr.char translated into internal numbering
	defer func() {
		// Make sure we report no lookahead when not parsing.
		sqlstate = -1
		sqlrcvr.char = -1
		sqltoken = -1
	}()
	sqlp := -1
	goto sqlstack

ret0:
	return 0

ret1:
	return 1

sqlstack:
	/* put a state and value onto the stack */
	if sqlDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", sqlTokname(sqltoken), sqlStatname(sqlstate))
	}

	sqlp++
	if sqlp >= len(sqlS) {
		nyys := make([]sqlSymType, len(sqlS)*2)
		copy(nyys, sqlS)
		sqlS = nyys
	}
	sqlS[sqlp] = sqlVAL
	sqlS[sqlp].yys = sqlstate

sqlnewstate:
	sqln = sqlPact[sqlstate]
	if sqln <= sqlFlag {
		goto sqldefault /* simple state */
	}
	if sqlrcvr.char < 0 {
		sqlrcvr.char, sqltoken = sqllex1(sqllex, &sqlrcvr.lval)
	}
	sqln += sqltoken
	if sqln < 0 || sqln >= sqlLast {
		goto sqldefault
	}
	sqln = sqlAct[sqln]
	if sqlChk[sqln] == sqltoken { /* valid shift */
		sqlrcvr.char = -1
		sqltoken = -1
		sqlVAL = sqlrcvr.lval
		sqlstate = sqln
		if Errflag > 0 {
			Errflag--
		}
		goto sqlstack
	}

sqldefault:
	/* default state action */
	sqln = sqlDef[sqlstate]
	if sqln == -2 {
		if sqlrcvr.char < 0 {
			sqlrcvr.char, sqltoken = sqllex1(sqllex, &sqlrcvr.lval)
		}

		/* look through exception table */
		xi := 0
		for {
			if sqlExca[xi+0] == -1 && sqlExca[xi+1] == sqlstate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			sqln = sqlExca[xi+0]
			if sqln < 0 || sqln == sqltoken {
				break
			}
		}
		sqln = sqlExca[xi+1]
		if sqln < 0 {
			goto ret0
		}
	}
	if sqln == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			sqllex.Error(sqlErrorMessage(sqlstate, sqltoken))
			Nerrs++
			if sqlDebug >= 1 {
				__yyfmt__.Printf("%s", sqlStatname(sqlstate))
				__yyfmt__.Printf(" saw %s\n", sqlTokname(sqltoken))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for sqlp >= 0 {
				sqln = sqlPact[sqlS[sqlp].yys] + sqlErrCode
				if sqln >= 0 && sqln < sqlLast {
					sqlstate = sqlAct[sqln] /* simulate a shift of "error" */
					if sqlChk[sqlstate] == sqlErrCode {
						goto sqlstack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if sqlDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", sqlS[sqlp].yys)
				}
				sqlp--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if sqlDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", sqlTokname(sqltoken))
			}
			if sqltoken == sqlEofCode {
				goto ret1
			}
			sqlrcvr.char = -1
			sqltoken = -1
			goto sqlnewstate /* try again in the same state */
		}
	}

	/* reduction by production sqln */
	if sqlDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", sqln, sqlStatname(sqlstate))
	}

	sqlnt := sqln
	sqlpt := sqlp
	_ = sqlpt // guard against "declared and not used"

	sqlp -= sqlR2[sqln]
	// sqlp is now the index of $0. Perform the default action. Iff the
	// reduced production is ε, $1 is possibly out of range.
	if sqlp+1 >= len(sqlS) {
		nyys := make([]sqlSymType, len(sqlS)*2)
		copy(nyys, sqlS)
		sqlS = nyys
	}
	sqlVAL = sqlS[sqlp+1]

	/* consult goto table to find next state */
	sqln = sqlR1[sqln]
	sqlg := sqlPgo[sqln]
	sqlj := sqlg + sqlS[sqlp].yys + 1

	if sqlj >= sqlLast {
		sqlstate = sqlAct[sqlg]
	} else {
		sqlstate = sqlAct[sqlj]
		if sqlChk[sqlstate] != -sqln {
			sqlstate = sqlAct[sqlg]
		}
	}
	// dummy call; replaced with literal code
	switch sqlnt {

	case 1:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:792
		{
			sqllex.(*Scanner).stmts = sqlDollar[1].union.stmts()
		}
	case 2:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:798
		{
			if sqlDollar[3].union.stmt() != nil {
				sqlVAL.union.val = append(sqlDollar[1].union.stmts(), sqlDollar[3].union.stmt())
			}
		}
	case 3:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:804
		{
			if sqlDollar[1].union.stmt() != nil {
				sqlVAL.union.val = []Statement{sqlDollar[1].union.stmt()}
			} else {
				sqlVAL.union.val = []Statement(nil)
			}
		}
	case 20:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:830
		{
			sqlVAL.union.val = sqlDollar[1].union.slct()
		}
	case 32:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:845
		{
			sqlVAL.union.val = Statement(nil)
		}
	case 33:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:851
		{
			sqlVAL.union.val = &AlterTable{Table: sqlDollar[3].union.normalizableTableName(), IfExists: false, Cmds: sqlDollar[4].union.alterTableCmds()}
		}
	case 34:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:855
		{
			sqlVAL.union.val = &AlterTable{Table: sqlDollar[5].union.normalizableTableName(), IfExists: true, Cmds: sqlDollar[6].union.alterTableCmds()}
		}
	case 35:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:861
		{
			sqlVAL.union.val = AlterTableCmds{sqlDollar[1].union.alterTableCmd()}
		}
	case 36:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:865
		{
			sqlVAL.union.val = append(sqlDollar[1].union.alterTableCmds(), sqlDollar[3].union.alterTableCmd())
		}
	case 37:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:872
		{
			sqlVAL.union.val = &AlterTableAddColumn{columnKeyword: false, IfNotExists: false, ColumnDef: sqlDollar[2].union.colDef()}
		}
	case 38:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:877
		{
			sqlVAL.union.val = &AlterTableAddColumn{columnKeyword: false, IfNotExists: true, ColumnDef: sqlDollar[5].union.colDef()}
		}
	case 39:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:882
		{
			sqlVAL.union.val = &AlterTableAddColumn{columnKeyword: true, IfNotExists: false, ColumnDef: sqlDollar[3].union.colDef()}
		}
	case 40:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:887
		{
			sqlVAL.union.val = &AlterTableAddColumn{columnKeyword: true, IfNotExists: true, ColumnDef: sqlDollar[6].union.colDef()}
		}
	case 41:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:892
		{
			sqlVAL.union.val = &AlterTableSetDefault{columnKeyword: sqlDollar[2].union.bool(), Column: Name(sqlDollar[3].str), Default: sqlDollar[4].union.expr()}
		}
	case 42:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:897
		{
			sqlVAL.union.val = &AlterTableDropNotNull{columnKeyword: sqlDollar[2].union.bool(), Column: Name(sqlDollar[3].str)}
		}
	case 43:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:901
		{
			return unimplemented(sqllex, "alter set non null")
		}
	case 44:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:904
		{
			sqlVAL.union.val = &AlterTableDropColumn{
				columnKeyword: sqlDollar[2].union.bool(),
				IfExists:      true,
				Column:        Name(sqlDollar[5].str),
				DropBehavior:  sqlDollar[6].union.dropBehavior(),
			}
		}
	case 45:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:914
		{
			sqlVAL.union.val = &AlterTableDropColumn{
				columnKeyword: sqlDollar[2].union.bool(),
				IfExists:      false,
				Column:        Name(sqlDollar[3].str),
				DropBehavior:  sqlDollar[4].union.dropBehavior(),
			}
		}
	case 46:
		sqlDollar = sqlS[sqlpt-8 : sqlpt+1]
		//line sql.y:924
		{
			return unimplemented(sqllex, "alter set type")
		}
	case 47:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:927
		{
			sqlVAL.union.val = &AlterTableAddConstraint{
				ConstraintDef:      sqlDollar[2].union.constraintDef(),
				ValidationBehavior: sqlDollar[3].union.validationBehavior(),
			}
		}
	case 48:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:934
		{
			return unimplemented(sqllex, "alter constraint")
		}
	case 49:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:937
		{
			sqlVAL.union.val = &AlterTableValidateConstraint{
				Constraint: Name(sqlDollar[3].str),
			}
		}
	case 50:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:944
		{
			sqlVAL.union.val = &AlterTableDropConstraint{
				IfExists:     true,
				Constraint:   Name(sqlDollar[5].str),
				DropBehavior: sqlDollar[6].union.dropBehavior(),
			}
		}
	case 51:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:953
		{
			sqlVAL.union.val = &AlterTableDropConstraint{
				IfExists:     false,
				Constraint:   Name(sqlDollar[3].str),
				DropBehavior: sqlDollar[4].union.dropBehavior(),
			}
		}
	case 52:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:963
		{
			sqlVAL.union.val = sqlDollar[3].union.expr()
		}
	case 53:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:967
		{
			sqlVAL.union.val = nil
		}
	case 54:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:973
		{
			sqlVAL.union.val = DropCascade
		}
	case 55:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:977
		{
			sqlVAL.union.val = DropRestrict
		}
	case 56:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:981
		{
			sqlVAL.union.val = DropDefault
		}
	case 57:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:987
		{
			sqlVAL.union.val = ValidationSkip
		}
	case 58:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:991
		{
			sqlVAL.union.val = ValidationDefault
		}
	case 59:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:996
		{
			return unimplementedWithIssue(sqllex, 2473)
		}
	case 60:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:997
		{
		}
	case 61:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1000
		{
			return unimplemented(sqllex, "alter using")
		}
	case 62:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:1001
		{
		}
	case 63:
		sqlDollar = sqlS[sqlpt-7 : sqlpt+1]
		//line sql.y:1005
		{
			sqlVAL.union.val = &Backup{Targets: sqlDollar[2].union.targetList(), To: sqlDollar[4].union.expr(), IncrementalFrom: sqlDollar[6].union.exprs(), AsOf: sqlDollar[5].union.asOfClause(), Options: sqlDollar[7].union.kvOptions()}
		}
	case 64:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:1009
		{
			sqlVAL.union.val = &Restore{Targets: sqlDollar[2].union.targetList(), From: sqlDollar[4].union.exprs(), AsOf: sqlDollar[5].union.asOfClause(), Options: sqlDollar[6].union.kvOptions()}
		}
	case 65:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1015
		{
			sqlVAL.union.val = &StrVal{s: sqlDollar[1].str}
		}
	case 66:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1019
		{
			sqlVAL.union.val = NewPlaceholder(sqlDollar[1].str)
		}
	case 67:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1025
		{
			sqlVAL.union.val = Exprs{sqlDollar[1].union.expr()}
		}
	case 68:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1029
		{
			sqlVAL.union.val = append(sqlDollar[1].union.exprs(), sqlDollar[3].union.expr())
		}
	case 69:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1035
		{
			sqlVAL.union.val = sqlDollar[3].union.exprs()
		}
	case 70:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:1039
		{
			sqlVAL.union.val = Exprs(nil)
		}
	case 71:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1045
		{
			sqlVAL.str = sqlDollar[2].str
		}
	case 72:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:1049
		{
			sqlVAL.str = ""
		}
	case 73:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1055
		{
			sqlVAL.union.val = KVOption{Key: sqlDollar[1].str, Value: sqlDollar[2].str}
		}
	case 74:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1061
		{
			sqlVAL.union.val = []KVOption{sqlDollar[1].union.kvOption()}
		}
	case 75:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1065
		{
			sqlVAL.union.val = append(sqlDollar[1].union.kvOptions(), sqlDollar[3].union.kvOption())
		}
	case 76:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:1071
		{
			sqlVAL.union.val = sqlDollar[4].union.kvOptions()
		}
	case 77:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:1074
		{
		}
	case 78:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1078
		{
			sqlVAL.union.val = &CopyFrom{Table: sqlDollar[2].union.normalizableTableName(), Stdin: true}
		}
	case 79:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:1082
		{
			sqlVAL.union.val = &CopyFrom{Table: sqlDollar[2].union.normalizableTableName(), Stdin: true}
		}
	case 80:
		sqlDollar = sqlS[sqlpt-7 : sqlpt+1]
		//line sql.y:1086
		{
			sqlVAL.union.val = &CopyFrom{Table: sqlDollar[2].union.normalizableTableName(), Columns: sqlDollar[4].union.unresolvedNames(), Stdin: true}
		}
	case 87:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:1102
		{
			sqlVAL.union.val = &Delete{Table: sqlDollar[4].union.tblExpr(), Where: newWhere(astWhere, sqlDollar[5].union.expr()), Returning: sqlDollar[6].union.retClause()}
		}
	case 88:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1109
		{
			sqlVAL.union.val = &DropDatabase{Name: Name(sqlDollar[3].str), IfExists: false}
		}
	case 89:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:1113
		{
			sqlVAL.union.val = &DropDatabase{Name: Name(sqlDollar[5].str), IfExists: true}
		}
	case 90:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1117
		{
			sqlVAL.union.val = &DropIndex{
				IndexList:    sqlDollar[3].union.tableWithIdxList(),
				IfExists:     false,
				DropBehavior: sqlDollar[4].union.dropBehavior(),
			}
		}
	case 91:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:1125
		{
			sqlVAL.union.val = &DropIndex{
				IndexList:    sqlDollar[5].union.tableWithIdxList(),
				IfExists:     true,
				DropBehavior: sqlDollar[6].union.dropBehavior(),
			}
		}
	case 92:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1133
		{
			sqlVAL.union.val = &DropTable{Names: sqlDollar[3].union.tableNameReferences(), IfExists: false, DropBehavior: sqlDollar[4].union.dropBehavior()}
		}
	case 93:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:1137
		{
			sqlVAL.union.val = &DropTable{Names: sqlDollar[5].union.tableNameReferences(), IfExists: true, DropBehavior: sqlDollar[6].union.dropBehavior()}
		}
	case 94:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1141
		{
			sqlVAL.union.val = &DropView{Names: sqlDollar[3].union.tableNameReferences(), IfExists: false, DropBehavior: sqlDollar[4].union.dropBehavior()}
		}
	case 95:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:1145
		{
			sqlVAL.union.val = &DropView{Names: sqlDollar[5].union.tableNameReferences(), IfExists: true, DropBehavior: sqlDollar[6].union.dropBehavior()}
		}
	case 96:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1151
		{
			sqlVAL.union.val = TableNameReferences{sqlDollar[1].union.unresolvedName()}
		}
	case 97:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1155
		{
			sqlVAL.union.val = append(sqlDollar[1].union.tableNameReferences(), sqlDollar[3].union.unresolvedName())
		}
	case 98:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1161
		{
			sqlVAL.union.val = UnresolvedName{Name(sqlDollar[1].str)}
		}
	case 99:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1165
		{
			sqlVAL.union.val = append(UnresolvedName{Name(sqlDollar[1].str)}, sqlDollar[2].union.unresolvedName()...)
		}
	case 100:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1171
		{
			sqlVAL.union.val = UnresolvedName{Name(sqlDollar[2].str)}
		}
	case 101:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1175
		{
			sqlVAL.union.val = append(sqlDollar[1].union.unresolvedName(), Name(sqlDollar[3].str))
		}
	case 102:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1182
		{
			sqlVAL.union.val = &Explain{Statement: sqlDollar[2].union.stmt()}
		}
	case 103:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:1186
		{
			sqlVAL.union.val = &Explain{Options: sqlDollar[3].union.strs(), Statement: sqlDollar[5].union.stmt()}
		}
	case 104:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1192
		{
			sqlVAL.union.val = sqlDollar[1].union.slct()
		}
	case 116:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1206
		{ /* SKIP DOC */
		}
	case 117:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1210
		{
			sqlVAL.union.val = []string{sqlDollar[1].str}
		}
	case 118:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1214
		{
			sqlVAL.union.val = append(sqlDollar[1].union.strs(), sqlDollar[3].str)
		}
	case 120:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:1224
		{
			sqlVAL.union.val = &Prepare{
				Name:      Name(sqlDollar[2].str),
				Types:     sqlDollar[3].union.colTypes(),
				Statement: sqlDollar[5].union.stmt(),
			}
		}
	case 121:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1234
		{
			sqlVAL.union.val = sqlDollar[2].union.colTypes()
		}
	case 122:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:1238
		{
			sqlVAL.union.val = []ColumnType(nil)
		}
	case 123:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1244
		{
			sqlVAL.union.val = sqlDollar[1].union.slct()
		}
	case 127:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1254
		{
			sqlVAL.union.val = &Execute{
				Name:   Name(sqlDollar[2].str),
				Params: sqlDollar[3].union.exprs(),
			}
		}
	case 128:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1265
		{
			sqlVAL.union.val = sqlDollar[2].union.exprs()
		}
	case 129:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:1269
		{
			sqlVAL.union.val = Exprs(nil)
		}
	case 130:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1276
		{
			sqlVAL.union.val = &Deallocate{
				Name: Name(sqlDollar[2].str),
			}
		}
	case 131:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1282
		{
			sqlVAL.union.val = &Deallocate{
				Name: Name(sqlDollar[3].str),
			}
		}
	case 132:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1288
		{
			sqlVAL.union.val = &Deallocate{}
		}
	case 133:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1292
		{
			sqlVAL.union.val = &Deallocate{}
		}
	case 134:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:1299
		{
			sqlVAL.union.val = &Grant{Privileges: sqlDollar[2].union.privilegeList(), Grantees: sqlDollar[6].union.nameList(), Targets: sqlDollar[4].union.targetList()}
		}
	case 135:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:1306
		{
			sqlVAL.union.val = &Revoke{Privileges: sqlDollar[2].union.privilegeList(), Grantees: sqlDollar[6].union.nameList(), Targets: sqlDollar[4].union.targetList()}
		}
	case 136:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1313
		{
			sqlVAL.union.val = TargetList{Tables: sqlDollar[1].union.tablePatterns()}
		}
	case 137:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1317
		{
			sqlVAL.union.val = TargetList{Tables: sqlDollar[2].union.tablePatterns()}
		}
	case 138:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1321
		{
			sqlVAL.union.val = TargetList{Databases: sqlDollar[2].union.nameList()}
		}
	case 139:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1328
		{
			sqlVAL.union.val = privilege.List{privilege.ALL}
		}
	case 140:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1331
		{
		}
	case 141:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1335
		{
			sqlVAL.union.val = privilege.List{sqlDollar[1].union.privilegeType()}
		}
	case 142:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1339
		{
			sqlVAL.union.val = append(sqlDollar[1].union.privilegeList(), sqlDollar[3].union.privilegeType())
		}
	case 143:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1346
		{
			sqlVAL.union.val = privilege.CREATE
		}
	case 144:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1350
		{
			sqlVAL.union.val = privilege.DROP
		}
	case 145:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1354
		{
			sqlVAL.union.val = privilege.GRANT
		}
	case 146:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1358
		{
			sqlVAL.union.val = privilege.SELECT
		}
	case 147:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1362
		{
			sqlVAL.union.val = privilege.INSERT
		}
	case 148:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1366
		{
			sqlVAL.union.val = privilege.DELETE
		}
	case 149:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1370
		{
			sqlVAL.union.val = privilege.UPDATE
		}
	case 150:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1378
		{
			sqlVAL.union.val = NameList{Name(sqlDollar[1].str)}
		}
	case 151:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1382
		{
			sqlVAL.union.val = append(sqlDollar[1].union.nameList(), Name(sqlDollar[3].str))
		}
	case 152:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1389
		{
			sqlVAL.union.val = &Set{Name: UnresolvedName{Name(sqlDollar[2].str)}, SetMode: SetModeReset}
		}
	case 153:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1393
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Set{Name: UnresolvedName{Name(sqlDollar[2].str)}, SetMode: SetModeReset}
		}
	case 154:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1397
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Set{Name: UnresolvedName{Name(sqlDollar[2].str)}, SetMode: SetModeReset}
		}
	case 155:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1403
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Set{Name: UnresolvedName{Name("client_encoding")}, SetMode: SetModeReset}
		}
	case 156:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1410
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Set{Name: UnresolvedName{Name("database")}, Values: Exprs{sqlDollar[2].union.expr()}}
		}
	case 157:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1419
		{
			sqlVAL.union.val = sqlDollar[2].union.stmt()
		}
	case 158:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1422
		{
			return unimplemented(sqllex, "set local")
		}
	case 159:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:1424
		{
			sqlVAL.union.val = &SetDefaultIsolation{Isolation: sqlDollar[6].union.isoLevel()}
		}
	case 160:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1428
		{
			sqlVAL.union.val = sqlDollar[3].union.stmt()
		}
	case 161:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1432
		{
			sqlVAL.union.val = sqlDollar[4].union.stmt()
			sqlVAL.union.val.(*Set).SetMode = SetModeClusterSetting
		}
	case 162:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1436
		{ /* SKIP DOC */
		}
	case 163:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:1442
		{
			sqlVAL.union.val = &Set{Values: sqlDollar[4].union.exprs()}
		}
	case 164:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1448
		{
			sqlVAL.union.val = &SetTransaction{Modes: sqlDollar[2].union.transactionModes()}
		}
	case 166:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1455
		{
			sqlVAL.union.val = &Set{Name: sqlDollar[1].union.unresolvedName(), Values: sqlDollar[3].union.exprs()}
		}
	case 167:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1459
		{
			sqlVAL.union.val = &Set{Name: sqlDollar[1].union.unresolvedName(), Values: sqlDollar[3].union.exprs()}
		}
	case 168:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1463
		{
			sqlVAL.union.val = &Set{Name: sqlDollar[1].union.unresolvedName()}
		}
	case 169:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1467
		{
			sqlVAL.union.val = &Set{Name: sqlDollar[1].union.unresolvedName()}
		}
	case 171:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1474
		{
			return unimplemented(sqllex, "set from current")
		}
	case 172:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1477
		{
			/* SKIP DOC */
			sqlVAL.union.val = &SetTimeZone{Value: sqlDollar[3].union.expr()}
		}
	case 174:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1486
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Set{Name: UnresolvedName{Name("client_encoding")}, Values: Exprs{sqlDollar[2].union.expr()}}
		}
	case 175:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1490
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Set{Name: UnresolvedName{Name("client_encoding")}, SetMode: SetModeReset}
		}
	case 176:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1494
		{
		}
	case 177:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:1494
		{
		}
	case 179:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1501
		{
			sqlVAL.union.val = Exprs{sqlDollar[1].union.expr()}
		}
	case 180:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1505
		{
			sqlVAL.union.val = append(sqlDollar[1].union.exprs(), sqlDollar[3].union.expr())
		}
	case 183:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1513
		{
			sqlVAL.union.val = NewPlaceholder(sqlDollar[1].str)
		}
	case 184:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1519
		{
			sqlVAL.union.val = SnapshotIsolation
		}
	case 185:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1523
		{
			sqlVAL.union.val = SnapshotIsolation
		}
	case 186:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1527
		{
			sqlVAL.union.val = SnapshotIsolation
		}
	case 187:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1531
		{
			sqlVAL.union.val = SerializableIsolation
		}
	case 188:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1535
		{
			sqlVAL.union.val = SerializableIsolation
		}
	case 189:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1541
		{
			sqlVAL.union.val = Low
		}
	case 190:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1545
		{
			sqlVAL.union.val = Normal
		}
	case 191:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1549
		{
			sqlVAL.union.val = High
		}
	case 192:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1555
		{
			sqlVAL.union.val = MakeDBool(true)
		}
	case 193:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1559
		{
			sqlVAL.union.val = MakeDBool(false)
		}
	case 194:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1563
		{
			sqlVAL.union.val = &StrVal{s: sqlDollar[1].str}
		}
	case 195:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1570
		{
			sqlVAL.union.val = &StrVal{s: sqlDollar[1].str}
		}
	case 196:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1581
		{
			sqlVAL.union.val = &StrVal{s: sqlDollar[1].str}
		}
	case 197:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1585
		{
			sqlVAL.union.val = &StrVal{s: sqlDollar[1].str}
		}
	case 198:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1589
		{
			sqlVAL.union.val = sqlDollar[1].union.expr()
		}
	case 200:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1594
		{
			sqlVAL.union.val = &StrVal{s: sqlDollar[1].str}
		}
	case 201:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1598
		{
			sqlVAL.union.val = &StrVal{s: sqlDollar[1].str}
		}
	case 204:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1608
		{
			sqlVAL.union.val = &Show{Name: sqlDollar[2].str}
		}
	case 205:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1614
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Show{Name: "client_encoding"}
		}
	case 206:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1618
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Show{Name: sqlDollar[2].str}
		}
	case 207:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1622
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Show{Name: sqlDollar[2].str}
		}
	case 208:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1626
		{
			sqlVAL.union.val = &Show{Name: sqlDollar[2].str}
		}
	case 209:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1630
		{
			sqlVAL.union.val = &ShowBackup{Path: sqlDollar[3].union.expr()}
		}
	case 210:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1634
		{
			sqlVAL.union.val = &Show{Name: sqlDollar[4].union.unresolvedName().String(), ClusterSetting: true}
		}
	case 211:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1638
		{
			sqlVAL.union.val = &Show{Name: "all", ClusterSetting: true}
		}
	case 212:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1642
		{
			sqlVAL.union.val = &Show{Name: "all", ClusterSetting: true}
		}
	case 213:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1646
		{
			sqlVAL.union.val = &ShowColumns{Table: sqlDollar[4].union.normalizableTableName()}
		}
	case 214:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1650
		{
			sqlVAL.union.val = &ShowDatabases{}
		}
	case 215:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1654
		{
			sqlVAL.union.val = &ShowGrants{Targets: sqlDollar[3].union.targetListPtr(), Grantees: sqlDollar[4].union.nameList()}
		}
	case 216:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1658
		{
			sqlVAL.union.val = &ShowIndex{Table: sqlDollar[4].union.normalizableTableName()}
		}
	case 217:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1662
		{
			sqlVAL.union.val = &ShowIndex{Table: sqlDollar[4].union.normalizableTableName()}
		}
	case 218:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1666
		{
			sqlVAL.union.val = &ShowConstraints{Table: sqlDollar[4].union.normalizableTableName()}
		}
	case 219:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1670
		{
			sqlVAL.union.val = &ShowConstraints{Table: sqlDollar[4].union.normalizableTableName()}
		}
	case 220:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1674
		{
			sqlVAL.union.val = &ShowIndex{Table: sqlDollar[4].union.normalizableTableName()}
		}
	case 221:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1678
		{
			sqlVAL.union.val = &ShowQueries{Cluster: true}
		}
	case 222:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1682
		{
			sqlVAL.union.val = &ShowQueries{Cluster: true}
		}
	case 223:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1686
		{
			sqlVAL.union.val = &ShowQueries{Cluster: false}
		}
	case 224:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1690
		{
			sqlVAL.union.val = &ShowSessions{Cluster: true}
		}
	case 225:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1694
		{
			sqlVAL.union.val = &ShowSessions{Cluster: true}
		}
	case 226:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1698
		{
			sqlVAL.union.val = &ShowSessions{Cluster: false}
		}
	case 227:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1702
		{
			sqlVAL.union.val = &ShowTables{Database: Name(sqlDollar[4].str)}
		}
	case 228:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1706
		{
			sqlVAL.union.val = &ShowTables{}
		}
	case 229:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1710
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Show{Name: "TIME ZONE"}
		}
	case 230:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1714
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Show{Name: "TRANSACTION ISOLATION LEVEL"}
		}
	case 231:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1718
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Show{Name: "TRANSACTION PRIORITY"}
		}
	case 232:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1722
		{
			/* SKIP DOC */
			sqlVAL.union.val = &ShowTransactionStatus{}
		}
	case 233:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1726
		{
			sqlVAL.union.val = &ShowCreateTable{Table: sqlDollar[4].union.normalizableTableName()}
		}
	case 234:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1730
		{
			sqlVAL.union.val = &ShowCreateView{View: sqlDollar[4].union.normalizableTableName()}
		}
	case 235:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1734
		{
			sqlVAL.union.val = &ShowUsers{}
		}
	case 236:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:1738
		{
			/* SKIP DOC */
			sqlVAL.union.val = &ShowRanges{Table: sqlDollar[5].union.newNormalizableTableName()}
		}
	case 237:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:1742
		{
			/* SKIP DOC */
			sqlVAL.union.val = &ShowRanges{Index: sqlDollar[5].union.tableWithIdx()}
		}
	case 238:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:1746
		{
			/* SKIP DOC */
			sqlVAL.union.val = &ShowFingerprints{Table: sqlDollar[5].union.newNormalizableTableName(), AsOf: sqlDollar[6].union.asOfClause()}
		}
	case 239:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1752
		{
			sqlVAL.union.val = &Help{Name: Name(sqlDollar[2].str)}
		}
	case 240:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1758
		{
			tmp := sqlDollar[2].union.targetList()
			sqlVAL.union.val = &tmp
		}
	case 241:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:1763
		{
			sqlVAL.union.val = (*TargetList)(nil)
		}
	case 242:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1769
		{
			sqlVAL.union.val = sqlDollar[2].union.nameList()
		}
	case 243:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:1773
		{
			sqlVAL.union.val = NameList(nil)
		}
	case 244:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:1779
		{
			sqlVAL.union.val = &Split{Table: sqlDollar[3].union.newNormalizableTableName(), Rows: sqlDollar[6].union.slct()}
		}
	case 245:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:1783
		{
			sqlVAL.union.val = &Split{Index: sqlDollar[3].union.tableWithIdx(), Rows: sqlDollar[6].union.slct()}
		}
	case 246:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:1789
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Relocate{Table: sqlDollar[3].union.newNormalizableTableName(), Rows: sqlDollar[5].union.slct()}
		}
	case 247:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:1793
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Relocate{Index: sqlDollar[3].union.tableWithIdx(), Rows: sqlDollar[5].union.slct()}
		}
	case 248:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1799
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Scatter{Table: sqlDollar[3].union.newNormalizableTableName()}
		}
	case 249:
		sqlDollar = sqlS[sqlpt-12 : sqlpt+1]
		//line sql.y:1803
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Scatter{Table: sqlDollar[3].union.newNormalizableTableName(), From: sqlDollar[7].union.exprs(), To: sqlDollar[11].union.exprs()}
		}
	case 250:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1807
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Scatter{Index: sqlDollar[3].union.tableWithIdx()}
		}
	case 251:
		sqlDollar = sqlS[sqlpt-12 : sqlpt+1]
		//line sql.y:1811
		{
			/* SKIP DOC */
			sqlVAL.union.val = &Scatter{Index: sqlDollar[3].union.tableWithIdx(), From: sqlDollar[7].union.exprs(), To: sqlDollar[11].union.exprs()}
		}
	case 252:
		sqlDollar = sqlS[sqlpt-7 : sqlpt+1]
		//line sql.y:1818
		{
			sqlVAL.union.val = &CreateTable{Table: sqlDollar[3].union.normalizableTableName(), IfNotExists: false, Interleave: sqlDollar[7].union.interleave(), Defs: sqlDollar[5].union.tblDefs(), AsSource: nil, AsColumnNames: nil}
		}
	case 253:
		sqlDollar = sqlS[sqlpt-10 : sqlpt+1]
		//line sql.y:1822
		{
			sqlVAL.union.val = &CreateTable{Table: sqlDollar[6].union.normalizableTableName(), IfNotExists: true, Interleave: sqlDollar[10].union.interleave(), Defs: sqlDollar[8].union.tblDefs(), AsSource: nil, AsColumnNames: nil}
		}
	case 254:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:1828
		{
			sqlVAL.union.val = &CreateTable{Table: sqlDollar[3].union.normalizableTableName(), IfNotExists: false, Interleave: nil, Defs: nil, AsSource: sqlDollar[6].union.slct(), AsColumnNames: sqlDollar[4].union.nameList()}
		}
	case 255:
		sqlDollar = sqlS[sqlpt-9 : sqlpt+1]
		//line sql.y:1832
		{
			sqlVAL.union.val = &CreateTable{Table: sqlDollar[6].union.normalizableTableName(), IfNotExists: true, Interleave: nil, Defs: nil, AsSource: sqlDollar[9].union.slct(), AsColumnNames: sqlDollar[7].union.nameList()}
		}
	case 257:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:1839
		{
			sqlVAL.union.val = TableDefs(nil)
		}
	case 258:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1845
		{
			sqlVAL.union.val = TableDefs{sqlDollar[1].union.tblDef()}
		}
	case 259:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1849
		{
			sqlVAL.union.val = append(sqlDollar[1].union.tblDefs(), sqlDollar[3].union.tblDef())
		}
	case 260:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1855
		{
			sqlVAL.union.val = sqlDollar[1].union.colDef()
		}
	case 263:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1861
		{
			sqlVAL.union.val = sqlDollar[1].union.constraintDef()
		}
	case 264:
		sqlDollar = sqlS[sqlpt-8 : sqlpt+1]
		//line sql.y:1867
		{
			sqlVAL.union.val = &InterleaveDef{
				Parent:       NormalizableTableName{UnresolvedName{Name(sqlDollar[4].str)}},
				Fields:       sqlDollar[6].union.nameList(),
				DropBehavior: sqlDollar[8].union.dropBehavior(),
			}
		}
	case 265:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:1875
		{
			sqlVAL.union.val = (*InterleaveDef)(nil)
		}
	case 266:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1882
		{
			/* SKIP DOC */
			sqlVAL.union.val = DropCascade
		}
	case 267:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1886
		{
			/* SKIP DOC */
			sqlVAL.union.val = DropRestrict
		}
	case 268:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:1890
		{
			sqlVAL.union.val = DropDefault
		}
	case 269:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1896
		{
			tableDef, err := newColumnTableDef(Name(sqlDollar[1].str), sqlDollar[2].union.colType(), sqlDollar[3].union.colQuals())
			if err != nil {
				sqllex.Error(err.Error())
				return 1
			}
			sqlVAL.union.val = tableDef
		}
	case 270:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1907
		{
			sqlVAL.union.val = append(sqlDollar[1].union.colQuals(), sqlDollar[2].union.colQual())
		}
	case 271:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:1911
		{
			sqlVAL.union.val = []NamedColumnQualification(nil)
		}
	case 272:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1917
		{
			sqlVAL.union.val = NamedColumnQualification{Name: Name(sqlDollar[2].str), Qualification: sqlDollar[3].union.colQualElem()}
		}
	case 273:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1921
		{
			sqlVAL.union.val = NamedColumnQualification{Qualification: sqlDollar[1].union.colQualElem()}
		}
	case 274:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1925
		{
			sqlVAL.union.val = NamedColumnQualification{Qualification: ColumnCollation(sqlDollar[2].str)}
		}
	case 275:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1929
		{
			sqlVAL.union.val = NamedColumnQualification{Qualification: &ColumnFamilyConstraint{Family: Name(sqlDollar[2].str)}}
		}
	case 276:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:1933
		{
			sqlVAL.union.val = NamedColumnQualification{Qualification: &ColumnFamilyConstraint{Family: Name(sqlDollar[3].str), Create: true}}
		}
	case 277:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:1937
		{
			sqlVAL.union.val = NamedColumnQualification{Qualification: &ColumnFamilyConstraint{Family: Name(sqlDollar[6].str), Create: true, IfNotExists: true}}
		}
	case 278:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1955
		{
			sqlVAL.union.val = NotNullConstraint{}
		}
	case 279:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1959
		{
			sqlVAL.union.val = NullConstraint{}
		}
	case 280:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:1963
		{
			sqlVAL.union.val = UniqueConstraint{}
		}
	case 281:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1967
		{
			sqlVAL.union.val = PrimaryKeyConstraint{}
		}
	case 282:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:1971
		{
			sqlVAL.union.val = &ColumnCheckConstraint{Expr: sqlDollar[3].union.expr()}
		}
	case 283:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:1975
		{
			sqlVAL.union.val = &ColumnDefault{Expr: sqlDollar[2].union.expr()}
		}
	case 284:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:1979
		{
			sqlVAL.union.val = &ColumnFKConstraint{
				Table: sqlDollar[2].union.normalizableTableName(),
				Col:   Name(sqlDollar[3].str),
			}
		}
	case 285:
		sqlDollar = sqlS[sqlpt-7 : sqlpt+1]
		//line sql.y:1988
		{
			sqlVAL.union.val = &IndexTableDef{
				Name:       Name(sqlDollar[2].str),
				Columns:    sqlDollar[4].union.idxElems(),
				Storing:    sqlDollar[6].union.nameList(),
				Interleave: sqlDollar[7].union.interleave(),
			}
		}
	case 286:
		sqlDollar = sqlS[sqlpt-8 : sqlpt+1]
		//line sql.y:1997
		{
			sqlVAL.union.val = &UniqueConstraintTableDef{
				IndexTableDef: IndexTableDef{
					Name:       Name(sqlDollar[3].str),
					Columns:    sqlDollar[5].union.idxElems(),
					Storing:    sqlDollar[7].union.nameList(),
					Interleave: sqlDollar[8].union.interleave(),
				},
			}
		}
	case 287:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:2010
		{
			sqlVAL.union.val = &FamilyTableDef{
				Name:    Name(sqlDollar[2].str),
				Columns: sqlDollar[4].union.nameList(),
			}
		}
	case 288:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2022
		{
			sqlVAL.union.val = sqlDollar[3].union.constraintDef()
			sqlVAL.union.val.(ConstraintTableDef).setName(Name(sqlDollar[2].str))
		}
	case 289:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2027
		{
			sqlVAL.union.val = sqlDollar[1].union.constraintDef()
		}
	case 290:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:2033
		{
			sqlVAL.union.val = &CheckConstraintTableDef{
				Expr: sqlDollar[3].union.expr(),
			}
		}
	case 291:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:2039
		{
			sqlVAL.union.val = &UniqueConstraintTableDef{
				IndexTableDef: IndexTableDef{
					Columns:    sqlDollar[3].union.idxElems(),
					Storing:    sqlDollar[5].union.nameList(),
					Interleave: sqlDollar[6].union.interleave(),
				},
			}
		}
	case 292:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:2049
		{
			sqlVAL.union.val = &UniqueConstraintTableDef{
				IndexTableDef: IndexTableDef{
					Columns: sqlDollar[4].union.idxElems(),
				},
				PrimaryKey: true,
			}
		}
	case 293:
		sqlDollar = sqlS[sqlpt-10 : sqlpt+1]
		//line sql.y:2059
		{
			sqlVAL.union.val = &ForeignKeyConstraintTableDef{
				Table:    sqlDollar[7].union.normalizableTableName(),
				FromCols: sqlDollar[4].union.nameList(),
				ToCols:   sqlDollar[8].union.nameList(),
			}
		}
	case 296:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:2082
		{
			sqlVAL.union.val = sqlDollar[3].union.nameList()
		}
	case 297:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2086
		{
			sqlVAL.union.val = NameList(nil)
		}
	case 298:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2092
		{
			sqlVAL.union.val = sqlDollar[2].union.nameList()
		}
	case 299:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2096
		{
			sqlVAL.union.val = NameList(nil)
		}
	case 300:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2101
		{
			return unimplemented(sqllex, "match full")
		}
	case 301:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2102
		{
			return unimplemented(sqllex, "match partial")
		}
	case 302:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2103
		{
			return unimplemented(sqllex, "match simple")
		}
	case 303:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2104
		{
		}
	case 304:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2110
		{
		}
	case 305:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2111
		{
		}
	case 306:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2112
		{
		}
	case 307:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2113
		{
		}
	case 308:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2114
		{
		}
	case 309:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2117
		{
		}
	case 310:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2120
		{
		}
	case 311:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2123
		{
			return unimplemented(sqllex, "no action")
		}
	case 312:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2126
		{
		}
	case 313:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2127
		{
			return unimplemented(sqllex, "action cascade")
		}
	case 314:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2128
		{
			return unimplemented(sqllex, "action set null")
		}
	case 315:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2129
		{
			return unimplemented(sqllex, "action set default")
		}
	case 316:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2133
		{
			sqlVAL.union.val = sqlDollar[1].union.numVal()
		}
	case 317:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2137
		{
			sqlVAL.union.val = &NumVal{Value: constant.UnaryOp(token.SUB, sqlDollar[2].union.numVal().Value, 0)}
		}
	case 318:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2141
		{
			sqlVAL.union.val = sqlDollar[1].union.numVal()
		}
	case 319:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:2148
		{
			sqlVAL.union.val = &Truncate{Tables: sqlDollar[3].union.tableNameReferences(), DropBehavior: sqlDollar[4].union.dropBehavior()}
		}
	case 320:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:2155
		{
			sqlVAL.union.val = &CreateUser{Name: Name(sqlDollar[3].str), Password: sqlDollar[5].union.strPtr()}
		}
	case 321:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2161
		{
			pwd := sqlDollar[2].str
			sqlVAL.union.val = &pwd
		}
	case 322:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2165
		{
			sqlVAL.union.val = (*string)(nil)
		}
	case 323:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:2172
		{
			sqlVAL.union.val = &CreateView{
				Name:        sqlDollar[3].union.normalizableTableName(),
				ColumnNames: sqlDollar[4].union.nameList(),
				AsSource:    sqlDollar[6].union.slct(),
			}
		}
	case 324:
		sqlDollar = sqlS[sqlpt-11 : sqlpt+1]
		//line sql.y:2185
		{
			sqlVAL.union.val = &CreateIndex{
				Name:       Name(sqlDollar[4].str),
				Table:      sqlDollar[6].union.normalizableTableName(),
				Unique:     sqlDollar[2].union.bool(),
				Columns:    sqlDollar[8].union.idxElems(),
				Storing:    sqlDollar[10].union.nameList(),
				Interleave: sqlDollar[11].union.interleave(),
			}
		}
	case 325:
		sqlDollar = sqlS[sqlpt-14 : sqlpt+1]
		//line sql.y:2196
		{
			sqlVAL.union.val = &CreateIndex{
				Name:        Name(sqlDollar[7].str),
				Table:       sqlDollar[9].union.normalizableTableName(),
				Unique:      sqlDollar[2].union.bool(),
				IfNotExists: true,
				Columns:     sqlDollar[11].union.idxElems(),
				Storing:     sqlDollar[13].union.nameList(),
				Interleave:  sqlDollar[14].union.interleave(),
			}
		}
	case 326:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2210
		{
			sqlVAL.union.val = true
		}
	case 327:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2214
		{
			sqlVAL.union.val = false
		}
	case 328:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2220
		{
			sqlVAL.union.val = IndexElemList{sqlDollar[1].union.idxElem()}
		}
	case 329:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2224
		{
			sqlVAL.union.val = append(sqlDollar[1].union.idxElems(), sqlDollar[3].union.idxElem())
		}
	case 330:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2233
		{
			sqlVAL.union.val = IndexElem{Column: Name(sqlDollar[1].str), Direction: sqlDollar[3].union.dir()}
		}
	case 331:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2236
		{
			return unimplemented(sqllex, "index_elem func expr")
		}
	case 332:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:2237
		{
			return unimplemented(sqllex, "index_elem a_expr")
		}
	case 333:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2240
		{
			return unimplementedWithIssue(sqllex, 2473)
		}
	case 334:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2241
		{
		}
	case 335:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2245
		{
			sqlVAL.union.val = Ascending
		}
	case 336:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2249
		{
			sqlVAL.union.val = Descending
		}
	case 337:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2253
		{
			sqlVAL.union.val = DefaultDirection
		}
	case 338:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:2260
		{
			sqlVAL.union.val = &RenameDatabase{Name: Name(sqlDollar[3].str), NewName: Name(sqlDollar[6].str)}
		}
	case 339:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:2264
		{
			sqlVAL.union.val = &RenameTable{Name: sqlDollar[3].union.normalizableTableName(), NewName: sqlDollar[6].union.normalizableTableName(), IfExists: false, IsView: false}
		}
	case 340:
		sqlDollar = sqlS[sqlpt-8 : sqlpt+1]
		//line sql.y:2268
		{
			sqlVAL.union.val = &RenameTable{Name: sqlDollar[5].union.normalizableTableName(), NewName: sqlDollar[8].union.normalizableTableName(), IfExists: true, IsView: false}
		}
	case 341:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:2272
		{
			sqlVAL.union.val = &RenameTable{Name: sqlDollar[3].union.normalizableTableName(), NewName: sqlDollar[6].union.normalizableTableName(), IfExists: false, IsView: true}
		}
	case 342:
		sqlDollar = sqlS[sqlpt-8 : sqlpt+1]
		//line sql.y:2276
		{
			sqlVAL.union.val = &RenameTable{Name: sqlDollar[5].union.normalizableTableName(), NewName: sqlDollar[8].union.normalizableTableName(), IfExists: true, IsView: true}
		}
	case 343:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:2280
		{
			sqlVAL.union.val = &RenameIndex{Index: sqlDollar[3].union.tableWithIdx(), NewName: Name(sqlDollar[6].str), IfExists: false}
		}
	case 344:
		sqlDollar = sqlS[sqlpt-8 : sqlpt+1]
		//line sql.y:2284
		{
			sqlVAL.union.val = &RenameIndex{Index: sqlDollar[5].union.tableWithIdx(), NewName: Name(sqlDollar[8].str), IfExists: true}
		}
	case 345:
		sqlDollar = sqlS[sqlpt-8 : sqlpt+1]
		//line sql.y:2288
		{
			sqlVAL.union.val = &RenameColumn{Table: sqlDollar[3].union.normalizableTableName(), Name: Name(sqlDollar[6].str), NewName: Name(sqlDollar[8].str), IfExists: false}
		}
	case 346:
		sqlDollar = sqlS[sqlpt-10 : sqlpt+1]
		//line sql.y:2292
		{
			sqlVAL.union.val = &RenameColumn{Table: sqlDollar[5].union.normalizableTableName(), Name: Name(sqlDollar[8].str), NewName: Name(sqlDollar[10].str), IfExists: true}
		}
	case 347:
		sqlDollar = sqlS[sqlpt-8 : sqlpt+1]
		//line sql.y:2295
		{
			return unimplemented(sqllex, "alter table rename constraint")
		}
	case 348:
		sqlDollar = sqlS[sqlpt-10 : sqlpt+1]
		//line sql.y:2296
		{
			return unimplemented(sqllex, "alter table rename constraint")
		}
	case 349:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2300
		{
			sqlVAL.union.val = true
		}
	case 350:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2304
		{
			sqlVAL.union.val = false
		}
	case 351:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2309
		{
		}
	case 352:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2310
		{
		}
	case 353:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2314
		{
			sqlVAL.union.val = &ReleaseSavepoint{Savepoint: sqlDollar[2].str}
		}
	case 354:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2320
		{
			sqlVAL.union.val = &Savepoint{Name: sqlDollar[2].str}
		}
	case 355:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2327
		{
			sqlVAL.union.val = sqlDollar[3].union.stmt()
		}
	case 356:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2331
		{
			sqlVAL.union.val = sqlDollar[3].union.stmt()
		}
	case 357:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2335
		{
			sqlVAL.union.val = &CommitTransaction{}
		}
	case 358:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2339
		{
			sqlVAL.union.val = &CommitTransaction{}
		}
	case 359:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2343
		{
			if sqlDollar[2].str != "" {
				sqlVAL.union.val = &RollbackToSavepoint{Savepoint: sqlDollar[2].str}
			} else {
				sqlVAL.union.val = &RollbackTransaction{}
			}
		}
	case 360:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2352
		{
		}
	case 361:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2353
		{
		}
	case 362:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2357
		{
			sqlVAL.str = ""
		}
	case 363:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2361
		{
			sqlVAL.str = sqlDollar[3].str
		}
	case 364:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2365
		{
			sqlVAL.str = sqlDollar[2].str
		}
	case 365:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2369
		{
			sqlVAL.str = ""
		}
	case 366:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2375
		{
			sqlVAL.str = sqlDollar[2].str
		}
	case 367:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2379
		{
			sqlVAL.str = sqlDollar[1].str
		}
	case 368:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2385
		{
			sqlVAL.union.val = &BeginTransaction{Modes: sqlDollar[1].union.transactionModes()}
		}
	case 369:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2389
		{
			sqlVAL.union.val = &BeginTransaction{}
		}
	case 370:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2395
		{
			sqlVAL.union.val = sqlDollar[1].union.transactionModes()
		}
	case 371:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2399
		{
			a := sqlDollar[1].union.transactionModes()
			b := sqlDollar[3].union.transactionModes()
			err := a.merge(b)
			if err != nil {
				sqllex.Error(err.Error())
				return 1
			}
			sqlVAL.union.val = a
		}
	case 372:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2409
		{
			sqlVAL.union.val = TransactionModes{Isolation: sqlDollar[1].union.isoLevel()}
		}
	case 373:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2413
		{
			sqlVAL.union.val = TransactionModes{UserPriority: sqlDollar[1].union.userPriority()}
		}
	case 374:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2417
		{
			sqlVAL.union.val = TransactionModes{ReadWriteMode: sqlDollar[1].union.readWriteMode()}
		}
	case 375:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2423
		{
			sqlVAL.union.val = sqlDollar[2].union.userPriority()
		}
	case 376:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2429
		{
			sqlVAL.union.val = sqlDollar[3].union.isoLevel()
		}
	case 377:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2435
		{
			sqlVAL.union.val = ReadOnly
		}
	case 378:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2439
		{
			sqlVAL.union.val = ReadWrite
		}
	case 379:
		sqlDollar = sqlS[sqlpt-8 : sqlpt+1]
		//line sql.y:2445
		{
			sqlVAL.union.val = &CreateDatabase{
				Name:     Name(sqlDollar[3].str),
				Template: sqlDollar[5].str,
				Encoding: sqlDollar[6].str,
				Collate:  sqlDollar[7].str,
				CType:    sqlDollar[8].str,
			}
		}
	case 380:
		sqlDollar = sqlS[sqlpt-11 : sqlpt+1]
		//line sql.y:2455
		{
			sqlVAL.union.val = &CreateDatabase{
				IfNotExists: true,
				Name:        Name(sqlDollar[6].str),
				Template:    sqlDollar[8].str,
				Encoding:    sqlDollar[9].str,
				Collate:     sqlDollar[10].str,
				CType:       sqlDollar[11].str,
			}
		}
	case 381:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2468
		{
			sqlVAL.str = sqlDollar[3].str
		}
	case 382:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2472
		{
			sqlVAL.str = ""
		}
	case 383:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2478
		{
			sqlVAL.str = sqlDollar[3].str
		}
	case 384:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2482
		{
			sqlVAL.str = ""
		}
	case 385:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2488
		{
			sqlVAL.str = sqlDollar[3].str
		}
	case 386:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2492
		{
			sqlVAL.str = ""
		}
	case 387:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2498
		{
			sqlVAL.str = sqlDollar[3].str
		}
	case 388:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2502
		{
			sqlVAL.str = ""
		}
	case 389:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2507
		{
		}
	case 390:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2508
		{
		}
	case 391:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:2512
		{
			sqlVAL.union.val = sqlDollar[5].union.stmt()
			sqlVAL.union.val.(*Insert).Table = sqlDollar[4].union.tblExpr()
			sqlVAL.union.val.(*Insert).Returning = sqlDollar[6].union.retClause()
		}
	case 392:
		sqlDollar = sqlS[sqlpt-7 : sqlpt+1]
		//line sql.y:2518
		{
			sqlVAL.union.val = sqlDollar[5].union.stmt()
			sqlVAL.union.val.(*Insert).Table = sqlDollar[4].union.tblExpr()
			sqlVAL.union.val.(*Insert).OnConflict = sqlDollar[6].union.onConflict()
			sqlVAL.union.val.(*Insert).Returning = sqlDollar[7].union.retClause()
		}
	case 393:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:2525
		{
			sqlVAL.union.val = sqlDollar[5].union.stmt()
			sqlVAL.union.val.(*Insert).Table = sqlDollar[4].union.tblExpr()
			sqlVAL.union.val.(*Insert).OnConflict = &OnConflict{}
			sqlVAL.union.val.(*Insert).Returning = sqlDollar[6].union.retClause()
		}
	case 394:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2538
		{
			sqlVAL.union.val = sqlDollar[1].union.newNormalizableTableName()
		}
	case 395:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2542
		{
			sqlVAL.union.val = &AliasedTableExpr{Expr: sqlDollar[1].union.newNormalizableTableName(), As: AliasClause{Alias: Name(sqlDollar[3].str)}}
		}
	case 396:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2548
		{
			sqlVAL.union.val = &Insert{Rows: sqlDollar[1].union.slct()}
		}
	case 397:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:2552
		{
			sqlVAL.union.val = &Insert{Columns: sqlDollar[2].union.unresolvedNames(), Rows: sqlDollar[4].union.slct()}
		}
	case 398:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2556
		{
			sqlVAL.union.val = &Insert{Rows: &Select{}}
		}
	case 399:
		sqlDollar = sqlS[sqlpt-8 : sqlpt+1]
		//line sql.y:2562
		{
			sqlVAL.union.val = &OnConflict{Columns: sqlDollar[3].union.nameList(), Exprs: sqlDollar[7].union.updateExprs(), Where: newWhere(astWhere, sqlDollar[8].union.expr())}
		}
	case 400:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:2566
		{
			sqlVAL.union.val = &OnConflict{Columns: sqlDollar[3].union.nameList(), DoNothing: true}
		}
	case 401:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:2572
		{
			// TODO(dan): Support the where_clause.
			sqlVAL.union.val = sqlDollar[2].union.nameList()
		}
	case 402:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2576
		{
			return unimplemented(sqllex, "on conflict on constraint")
		}
	case 403:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2578
		{
			sqlVAL.union.val = NameList(nil)
		}
	case 404:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2584
		{
			ret := ReturningExprs(sqlDollar[2].union.selExprs())
			sqlVAL.union.val = &ret
		}
	case 405:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2589
		{
			sqlVAL.union.val = returningNothingClause
		}
	case 406:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2593
		{
			sqlVAL.union.val = AbsentReturningClause
		}
	case 407:
		sqlDollar = sqlS[sqlpt-8 : sqlpt+1]
		//line sql.y:2600
		{
			sqlVAL.union.val = &Update{Table: sqlDollar[3].union.tblExpr(), Exprs: sqlDollar[5].union.updateExprs(), Where: newWhere(astWhere, sqlDollar[7].union.expr()), Returning: sqlDollar[8].union.retClause()}
		}
	case 408:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2606
		{
			return unimplementedWithIssue(sqllex, 7841)
		}
	case 409:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2607
		{
		}
	case 410:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2611
		{
			sqlVAL.union.val = UpdateExprs{sqlDollar[1].union.updateExpr()}
		}
	case 411:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2615
		{
			sqlVAL.union.val = append(sqlDollar[1].union.updateExprs(), sqlDollar[3].union.updateExpr())
		}
	case 414:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2625
		{
			sqlVAL.union.val = &UpdateExpr{Names: UnresolvedNames{sqlDollar[1].union.unresolvedName()}, Expr: sqlDollar[3].union.expr()}
		}
	case 415:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:2637
		{
			sqlVAL.union.val = &UpdateExpr{Tuple: true, Names: sqlDollar[2].union.unresolvedNames(), Expr: &Tuple{Exprs: sqlDollar[5].union.exprs()}}
		}
	case 416:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:2641
		{
			sqlVAL.union.val = &UpdateExpr{Tuple: true, Names: sqlDollar[2].union.unresolvedNames(), Expr: &Subquery{Select: sqlDollar[5].union.selectStmt()}}
		}
	case 418:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2685
		{
			sqlVAL.union.val = &Select{Select: sqlDollar[1].union.selectStmt()}
		}
	case 419:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2691
		{
			sqlVAL.union.val = &ParenSelect{Select: sqlDollar[2].union.slct()}
		}
	case 420:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2695
		{
			sqlVAL.union.val = &ParenSelect{Select: &Select{Select: sqlDollar[2].union.selectStmt()}}
		}
	case 421:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2710
		{
			sqlVAL.union.val = &Select{Select: sqlDollar[1].union.selectStmt()}
		}
	case 422:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2714
		{
			sqlVAL.union.val = &Select{Select: sqlDollar[1].union.selectStmt(), OrderBy: sqlDollar[2].union.orderBy()}
		}
	case 423:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2718
		{
			sqlVAL.union.val = &Select{Select: sqlDollar[1].union.selectStmt(), OrderBy: sqlDollar[2].union.orderBy(), Limit: sqlDollar[3].union.limit()}
		}
	case 424:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2722
		{
			sqlVAL.union.val = &Select{Select: sqlDollar[2].union.selectStmt()}
		}
	case 425:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2726
		{
			sqlVAL.union.val = &Select{Select: sqlDollar[2].union.selectStmt(), OrderBy: sqlDollar[3].union.orderBy()}
		}
	case 426:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:2730
		{
			sqlVAL.union.val = &Select{Select: sqlDollar[2].union.selectStmt(), OrderBy: sqlDollar[3].union.orderBy(), Limit: sqlDollar[4].union.limit()}
		}
	case 429:
		sqlDollar = sqlS[sqlpt-8 : sqlpt+1]
		//line sql.y:2764
		{
			sqlVAL.union.val = &SelectClause{
				Exprs:   sqlDollar[3].union.selExprs(),
				From:    sqlDollar[4].union.from(),
				Where:   newWhere(astWhere, sqlDollar[5].union.expr()),
				GroupBy: sqlDollar[6].union.groupBy(),
				Having:  newWhere(astHaving, sqlDollar[7].union.expr()),
				Window:  sqlDollar[8].union.window(),
			}
		}
	case 430:
		sqlDollar = sqlS[sqlpt-8 : sqlpt+1]
		//line sql.y:2777
		{
			sqlVAL.union.val = &SelectClause{
				Distinct: sqlDollar[2].union.bool(),
				Exprs:    sqlDollar[3].union.selExprs(),
				From:     sqlDollar[4].union.from(),
				Where:    newWhere(astWhere, sqlDollar[5].union.expr()),
				GroupBy:  sqlDollar[6].union.groupBy(),
				Having:   newWhere(astHaving, sqlDollar[7].union.expr()),
				Window:   sqlDollar[8].union.window(),
			}
		}
	case 432:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2790
		{
			sqlVAL.union.val = &SelectClause{
				Exprs:       SelectExprs{starSelectExpr()},
				From:        &From{Tables: TableExprs{sqlDollar[2].union.newNormalizableTableName()}},
				tableSelect: true,
			}
		}
	case 433:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:2798
		{
			sqlVAL.union.val = &UnionClause{
				Type:  UnionOp,
				Left:  &Select{Select: sqlDollar[1].union.selectStmt()},
				Right: &Select{Select: sqlDollar[4].union.selectStmt()},
				All:   sqlDollar[3].union.bool(),
			}
		}
	case 434:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:2807
		{
			sqlVAL.union.val = &UnionClause{
				Type:  IntersectOp,
				Left:  &Select{Select: sqlDollar[1].union.selectStmt()},
				Right: &Select{Select: sqlDollar[4].union.selectStmt()},
				All:   sqlDollar[3].union.bool(),
			}
		}
	case 435:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:2816
		{
			sqlVAL.union.val = &UnionClause{
				Type:  ExceptOp,
				Left:  &Select{Select: sqlDollar[1].union.selectStmt()},
				Right: &Select{Select: sqlDollar[4].union.selectStmt()},
				All:   sqlDollar[3].union.bool(),
			}
		}
	case 436:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2834
		{
			return unimplemented(sqllex, "with cte_list")
		}
	case 437:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2835
		{
			return unimplemented(sqllex, "with cte_list")
		}
	case 438:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2836
		{
			return unimplemented(sqllex, "with cte_list")
		}
	case 439:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2839
		{
			return unimplemented(sqllex, "cte_list")
		}
	case 440:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2840
		{
			return unimplemented(sqllex, "cte_list")
		}
	case 441:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:2843
		{
			return unimplemented(sqllex, "cte")
		}
	case 442:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2846
		{
		}
	case 443:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2847
		{
		}
	case 444:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2850
		{
			return unimplemented(sqllex, "with_clause")
		}
	case 445:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2851
		{
		}
	case 446:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2854
		{
		}
	case 447:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2855
		{
		}
	case 448:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2859
		{
			sqlVAL.union.val = true
		}
	case 449:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2863
		{
			sqlVAL.union.val = false
		}
	case 450:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2867
		{
			sqlVAL.union.val = false
		}
	case 451:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2873
		{
			sqlVAL.union.val = true
		}
	case 452:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2878
		{
		}
	case 453:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2879
		{
		}
	case 454:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2883
		{
			sqlVAL.union.val = sqlDollar[1].union.orderBy()
		}
	case 455:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2887
		{
			sqlVAL.union.val = OrderBy(nil)
		}
	case 456:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2893
		{
			sqlVAL.union.val = OrderBy(sqlDollar[3].union.orders())
		}
	case 457:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2899
		{
			sqlVAL.union.val = []*Order{sqlDollar[1].union.order()}
		}
	case 458:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2903
		{
			sqlVAL.union.val = append(sqlDollar[1].union.orders(), sqlDollar[3].union.order())
		}
	case 459:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2909
		{
			sqlVAL.union.val = &Order{Expr: sqlDollar[1].union.expr(), Direction: sqlDollar[2].union.dir()}
		}
	case 460:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2917
		{
			if sqlDollar[1].union.limit() == nil {
				sqlVAL.union.val = sqlDollar[2].union.limit()
			} else {
				sqlVAL.union.val = sqlDollar[1].union.limit()
				sqlVAL.union.val.(*Limit).Offset = sqlDollar[2].union.limit().Offset
			}
		}
	case 461:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2926
		{
			sqlVAL.union.val = sqlDollar[1].union.limit()
			if sqlDollar[2].union.limit() != nil {
				sqlVAL.union.val.(*Limit).Count = sqlDollar[2].union.limit().Count
			}
		}
	case 464:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2937
		{
			if sqlDollar[2].union.expr() == nil {
				sqlVAL.union.val = (*Limit)(nil)
			} else {
				sqlVAL.union.val = &Limit{Count: sqlDollar[2].union.expr()}
			}
		}
	case 465:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:2946
		{
			sqlVAL.union.val = &Limit{Count: sqlDollar[3].union.expr()}
		}
	case 466:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:2952
		{
			sqlVAL.union.val = &Limit{Offset: sqlDollar[2].union.expr()}
		}
	case 467:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2959
		{
			sqlVAL.union.val = &Limit{Offset: sqlDollar[2].union.expr()}
		}
	case 469:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2966
		{
			sqlVAL.union.val = Expr(nil)
		}
	case 470:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2975
		{
			sqlVAL.union.val = sqlDollar[1].union.expr()
		}
	case 471:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:2979
		{
			sqlVAL.union.val = sqlDollar[2].union.expr()
		}
	case 472:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:2983
		{
			sqlVAL.union.val = &NumVal{Value: constant.MakeInt64(1)}
		}
	case 473:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2989
		{
		}
	case 474:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2990
		{
		}
	case 475:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2993
		{
		}
	case 476:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:2994
		{
		}
	case 477:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3016
		{
			sqlVAL.union.val = GroupBy(sqlDollar[3].union.exprs())
		}
	case 478:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:3020
		{
			sqlVAL.union.val = GroupBy(nil)
		}
	case 479:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3026
		{
			sqlVAL.union.val = sqlDollar[2].union.expr()
		}
	case 480:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:3030
		{
			sqlVAL.union.val = Expr(nil)
		}
	case 481:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3044
		{
			sqlVAL.union.val = &ValuesClause{[]*Tuple{{Exprs: sqlDollar[2].union.exprs()}}}
		}
	case 482:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3048
		{
			valNode := sqlDollar[1].union.selectStmt().(*ValuesClause)
			valNode.Tuples = append(valNode.Tuples, &Tuple{Exprs: sqlDollar[3].union.exprs()})
			sqlVAL.union.val = valNode
		}
	case 483:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3060
		{
			sqlVAL.union.val = &From{Tables: sqlDollar[2].union.tblExprs(), AsOf: sqlDollar[3].union.asOfClause()}
		}
	case 484:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:3064
		{
			sqlVAL.union.val = &From{}
		}
	case 485:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3070
		{
			sqlVAL.union.val = TableExprs{sqlDollar[1].union.tblExpr()}
		}
	case 486:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3074
		{
			sqlVAL.union.val = append(sqlDollar[1].union.tblExprs(), sqlDollar[3].union.tblExpr())
		}
	case 487:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3080
		{
			sqlVAL.union.val = &IndexHints{Index: Name(sqlDollar[3].str)}
		}
	case 488:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:3084
		{
			/* SKIP DOC */
			id, err := sqlDollar[4].union.numVal().AsInt64()
			if err != nil {
				sqllex.Error(err.Error())
				return 1
			}
			sqlVAL.union.val = &IndexHints{IndexID: IndexID(id)}
		}
	case 489:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3091
		{
			sqlVAL.union.val = &IndexHints{NoIndexJoin: true}
		}
	case 490:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3097
		{
			sqlVAL.union.val = sqlDollar[1].union.indexHints()
		}
	case 491:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3102
		{
			a := sqlDollar[1].union.indexHints()
			b := sqlDollar[3].union.indexHints()
			if a.NoIndexJoin && b.NoIndexJoin {
				sqllex.Error("NO_INDEX_JOIN specified multiple times")
				return 1
			}
			if (a.Index != "" || a.IndexID != 0) && (b.Index != "" || b.IndexID != 0) {
				sqllex.Error("FORCE_INDEX specified multiple times")
				return 1
			}
			// At this point either a or b contains "no information"
			// (the empty string for Index and the value 0 for IndexID).
			// Using the addition operator automatically selects the non-zero
			// value, avoiding a conditional branch.
			a.Index = a.Index + b.Index
			a.IndexID = a.IndexID + b.IndexID
			a.NoIndexJoin = a.NoIndexJoin || b.NoIndexJoin
			sqlVAL.union.val = a
		}
	case 492:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3125
		{
			sqlVAL.union.val = &IndexHints{Index: Name(sqlDollar[2].str)}
		}
	case 493:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3129
		{
			id, err := sqlDollar[3].union.numVal().AsInt64()
			if err != nil {
				sqllex.Error(err.Error())
				return 1
			}
			sqlVAL.union.val = &IndexHints{IndexID: IndexID(id)}
		}
	case 494:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3135
		{
			sqlVAL.union.val = sqlDollar[3].union.indexHints()
		}
	case 495:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:3139
		{
			sqlVAL.union.val = (*IndexHints)(nil)
		}
	case 496:
		sqlDollar = sqlS[sqlpt-7 : sqlpt+1]
		//line sql.y:3146
		{
			/* SKIP DOC */
			id, err := sqlDollar[2].union.numVal().AsInt64()
			if err != nil {
				sqllex.Error(err.Error())
				return 1
			}
			sqlVAL.union.val = &AliasedTableExpr{Expr: &TableRef{TableID: id, Columns: sqlDollar[3].union.tableRefCols()},
				Hints:      sqlDollar[5].union.indexHints(),
				Ordinality: sqlDollar[6].union.bool(), As: sqlDollar[7].union.aliasClause()}
		}
	case 497:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3157
		{
			sqlVAL.union.val = &AliasedTableExpr{Expr: sqlDollar[1].union.newNormalizableTableName(), Hints: sqlDollar[2].union.indexHints(), Ordinality: sqlDollar[3].union.bool(), As: sqlDollar[4].union.aliasClause()}
		}
	case 498:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:3161
		{
			sqlVAL.union.val = &AliasedTableExpr{Expr: &FuncExpr{Func: sqlDollar[1].union.resolvableFunctionReference(), Exprs: sqlDollar[3].union.exprs()}, Ordinality: sqlDollar[5].union.bool(), As: sqlDollar[6].union.aliasClause()}
		}
	case 499:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3165
		{
			sqlVAL.union.val = &AliasedTableExpr{Expr: &Subquery{Select: sqlDollar[1].union.selectStmt()}, Ordinality: sqlDollar[2].union.bool(), As: sqlDollar[3].union.aliasClause()}
		}
	case 500:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3169
		{
			sqlVAL.union.val = sqlDollar[1].union.tblExpr()
		}
	case 501:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:3173
		{
			sqlVAL.union.val = &AliasedTableExpr{Expr: &ParenTableExpr{sqlDollar[2].union.tblExpr()}, Ordinality: sqlDollar[4].union.bool(), As: sqlDollar[5].union.aliasClause()}
		}
	case 502:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:3194
		{
			sqlVAL.union.val = &AliasedTableExpr{Expr: &Explain{Statement: sqlDollar[3].union.stmt(), Enclosed: true}, Ordinality: sqlDollar[5].union.bool(), As: sqlDollar[6].union.aliasClause()}
		}
	case 503:
		sqlDollar = sqlS[sqlpt-9 : sqlpt+1]
		//line sql.y:3198
		{
			sqlVAL.union.val = &AliasedTableExpr{Expr: &Explain{Options: sqlDollar[4].union.strs(), Statement: sqlDollar[6].union.stmt(), Enclosed: true}, Ordinality: sqlDollar[8].union.bool(), As: sqlDollar[9].union.aliasClause()}
		}
	case 504:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:3202
		{
			sqlVAL.union.val = &AliasedTableExpr{Expr: &ShowSource{Statement: sqlDollar[2].union.stmt()}, Ordinality: sqlDollar[4].union.bool(), As: sqlDollar[5].union.aliasClause()}
		}
	case 505:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:3207
		{
			sqlVAL.union.val = nil
		}
	case 506:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3208
		{
			sqlVAL.union.val = []ColumnID{}
		}
	case 507:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3209
		{
			sqlVAL.union.val = sqlDollar[2].union.tableRefCols()
		}
	case 508:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3213
		{
			id, err := sqlDollar[1].union.numVal().AsInt64()
			if err != nil {
				sqllex.Error(err.Error())
				return 1
			}
			sqlVAL.union.val = []ColumnID{ColumnID(id)}
		}
	case 509:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3219
		{
			id, err := sqlDollar[3].union.numVal().AsInt64()
			if err != nil {
				sqllex.Error(err.Error())
				return 1
			}
			sqlVAL.union.val = append(sqlDollar[1].union.tableRefCols(), ColumnID(id))
		}
	case 510:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3227
		{
			sqlVAL.union.val = true
		}
	case 511:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:3231
		{
			sqlVAL.union.val = false
		}
	case 512:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3251
		{
			sqlVAL.union.val = &ParenTableExpr{Expr: sqlDollar[2].union.tblExpr()}
		}
	case 513:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3255
		{
			sqlVAL.union.val = &JoinTableExpr{Join: astCrossJoin, Left: sqlDollar[1].union.tblExpr(), Right: sqlDollar[4].union.tblExpr()}
		}
	case 514:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:3259
		{
			sqlVAL.union.val = &JoinTableExpr{Join: sqlDollar[2].str, Left: sqlDollar[1].union.tblExpr(), Right: sqlDollar[4].union.tblExpr(), Cond: sqlDollar[5].union.joinCond()}
		}
	case 515:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3263
		{
			sqlVAL.union.val = &JoinTableExpr{Join: astJoin, Left: sqlDollar[1].union.tblExpr(), Right: sqlDollar[3].union.tblExpr(), Cond: sqlDollar[4].union.joinCond()}
		}
	case 516:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:3267
		{
			sqlVAL.union.val = &JoinTableExpr{Join: sqlDollar[3].str, Left: sqlDollar[1].union.tblExpr(), Right: sqlDollar[5].union.tblExpr(), Cond: NaturalJoinCond{}}
		}
	case 517:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3271
		{
			sqlVAL.union.val = &JoinTableExpr{Join: astJoin, Left: sqlDollar[1].union.tblExpr(), Right: sqlDollar[4].union.tblExpr(), Cond: NaturalJoinCond{}}
		}
	case 518:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:3277
		{
			sqlVAL.union.val = AliasClause{Alias: Name(sqlDollar[2].str), Cols: sqlDollar[4].union.nameList()}
		}
	case 519:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3281
		{
			sqlVAL.union.val = AliasClause{Alias: Name(sqlDollar[2].str)}
		}
	case 520:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3285
		{
			sqlVAL.union.val = AliasClause{Alias: Name(sqlDollar[1].str), Cols: sqlDollar[3].union.nameList()}
		}
	case 521:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3289
		{
			sqlVAL.union.val = AliasClause{Alias: Name(sqlDollar[1].str)}
		}
	case 523:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:3296
		{
			sqlVAL.union.val = AliasClause{}
		}
	case 524:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:3302
		{
			sqlVAL.union.val = AsOfClause{Expr: sqlDollar[5].union.expr()}
		}
	case 525:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:3306
		{
			sqlVAL.union.val = AsOfClause{}
		}
	case 526:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3312
		{
			sqlVAL.str = astFullJoin
		}
	case 527:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3316
		{
			sqlVAL.str = astLeftJoin
		}
	case 528:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3320
		{
			sqlVAL.str = astRightJoin
		}
	case 529:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3324
		{
			sqlVAL.str = astInnerJoin
		}
	case 530:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3330
		{
		}
	case 531:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:3331
		{
		}
	case 532:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3342
		{
			sqlVAL.union.val = &UsingJoinCond{Cols: sqlDollar[3].union.nameList()}
		}
	case 533:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3346
		{
			sqlVAL.union.val = &OnJoinCond{Expr: sqlDollar[2].union.expr()}
		}
	case 534:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3352
		{
			sqlVAL.union.val = sqlDollar[1].union.unresolvedName()
		}
	case 535:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3356
		{
			sqlVAL.union.val = sqlDollar[1].union.unresolvedName()
		}
	case 536:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3360
		{
			sqlVAL.union.val = sqlDollar[2].union.unresolvedName()
		}
	case 537:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3364
		{
			sqlVAL.union.val = sqlDollar[3].union.unresolvedName()
		}
	case 538:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3370
		{
			sqlVAL.union.val = TableNameReferences{sqlDollar[1].union.unresolvedName()}
		}
	case 539:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3374
		{
			sqlVAL.union.val = append(sqlDollar[1].union.tableNameReferences(), sqlDollar[3].union.unresolvedName())
		}
	case 540:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3387
		{
			sqlVAL.union.val = sqlDollar[1].union.newNormalizableTableName()
		}
	case 541:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3391
		{
			sqlVAL.union.val = &AliasedTableExpr{Expr: sqlDollar[1].union.newNormalizableTableName(), As: AliasClause{Alias: Name(sqlDollar[2].str)}}
		}
	case 542:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3395
		{
			sqlVAL.union.val = &AliasedTableExpr{Expr: sqlDollar[1].union.newNormalizableTableName(), As: AliasClause{Alias: Name(sqlDollar[3].str)}}
		}
	case 543:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3401
		{
			sqlVAL.union.val = sqlDollar[2].union.expr()
		}
	case 544:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:3405
		{
			sqlVAL.union.val = Expr(nil)
		}
	case 545:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3417
		{
			if exprs := sqlDollar[2].union.exprs(); exprs != nil {
				var err error
				sqlVAL.union.val, err = arrayOf(sqlDollar[1].union.colType(), exprs)
				if err != nil {
					sqllex.Error(err.Error())
					return 1
				}
			} else {
				sqlVAL.union.val = sqlDollar[1].union.colType()
			}
		}
	case 546:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:3430
		{
			return unimplementedWithIssue(sqllex, 2115)
		}
	case 547:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3431
		{
			return unimplementedWithIssue(sqllex, 2115)
		}
	case 548:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3435
		{
			sqlVAL.union.val = sqlDollar[1].union.colType()
		}
	case 549:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3439
		{
			sqlVAL.union.val = sqlDollar[1].union.castTargetType()
		}
	case 550:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3444
		{
			sqlVAL.union.val = Exprs{NewDInt(DInt(-1))}
		}
	case 551:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3445
		{
			return unimplementedWithIssue(sqllex, 2115)
		}
	case 552:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:3446
		{
			sqlVAL.union.val = Exprs(nil)
		}
	case 558:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3454
		{
			return unimplemented(sqllex, "simple_type const_interval")
		}
	case 559:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3456
		{
			sqlVAL.union.val = bytesColTypeBlob
		}
	case 560:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3460
		{
			sqlVAL.union.val = bytesColTypeBytes
		}
	case 561:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3464
		{
			sqlVAL.union.val = bytesColTypeBytea
		}
	case 562:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3468
		{
			sqlVAL.union.val = stringColTypeText
		}
	case 563:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3472
		{
			sqlVAL.union.val = nameColTypeName
		}
	case 564:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3476
		{
			sqlVAL.union.val = intColTypeSerial
		}
	case 565:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3480
		{
			sqlVAL.union.val = intColTypeSmallSerial
		}
	case 566:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3484
		{
			sqlVAL.union.val = uuidColTypeUUID
		}
	case 567:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3488
		{
			sqlVAL.union.val = intColTypeBigSerial
		}
	case 568:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3492
		{
			sqlVAL.union.val = oidColTypeOid
		}
	case 569:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3496
		{
			sqlVAL.union.val = int2vectorColType
		}
	case 574:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3517
		{
			prec, err := sqlDollar[2].union.numVal().AsInt64()
			if err != nil {
				sqllex.Error(err.Error())
				return 1
			}
			sqlVAL.union.val = &DecimalColType{Prec: int(prec)}
		}
	case 575:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:3526
		{
			prec, err := sqlDollar[2].union.numVal().AsInt64()
			if err != nil {
				sqllex.Error(err.Error())
				return 1
			}
			scale, err := sqlDollar[4].union.numVal().AsInt64()
			if err != nil {
				sqllex.Error(err.Error())
				return 1
			}
			sqlVAL.union.val = &DecimalColType{Prec: int(prec), Scale: int(scale)}
		}
	case 576:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:3540
		{
			sqlVAL.union.val = nil
		}
	case 577:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3547
		{
			sqlVAL.union.val = intColTypeInt
		}
	case 578:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3551
		{
			sqlVAL.union.val = intColTypeInt8
		}
	case 579:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3555
		{
			sqlVAL.union.val = intColTypeInt64
		}
	case 580:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3559
		{
			sqlVAL.union.val = intColTypeInteger
		}
	case 581:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3563
		{
			sqlVAL.union.val = intColTypeSmallInt
		}
	case 582:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3567
		{
			sqlVAL.union.val = intColTypeBigInt
		}
	case 583:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3571
		{
			sqlVAL.union.val = floatColTypeReal
		}
	case 584:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3575
		{
			nv := sqlDollar[2].union.numVal()
			prec, err := nv.AsInt64()
			if err != nil {
				sqllex.Error(err.Error())
				return 1
			}
			sqlVAL.union.val = NewFloatColType(int(prec), len(nv.OrigString) > 0)
		}
	case 585:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3585
		{
			sqlVAL.union.val = floatColTypeDouble
		}
	case 586:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3589
		{
			sqlVAL.union.val = sqlDollar[2].union.colType()
			if sqlVAL.union.val == nil {
				sqlVAL.union.val = decimalColTypeDecimal
			} else {
				sqlVAL.union.val.(*DecimalColType).Name = "DECIMAL"
			}
		}
	case 587:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3598
		{
			sqlVAL.union.val = sqlDollar[2].union.colType()
			if sqlVAL.union.val == nil {
				sqlVAL.union.val = decimalColTypeDec
			} else {
				sqlVAL.union.val.(*DecimalColType).Name = "DEC"
			}
		}
	case 588:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3607
		{
			sqlVAL.union.val = sqlDollar[2].union.colType()
			if sqlVAL.union.val == nil {
				sqlVAL.union.val = decimalColTypeNumeric
			} else {
				sqlVAL.union.val.(*DecimalColType).Name = "NUMERIC"
			}
		}
	case 589:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3616
		{
			sqlVAL.union.val = boolColTypeBoolean
		}
	case 590:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3620
		{
			sqlVAL.union.val = boolColTypeBool
		}
	case 591:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3627
		{
			sqlVAL.union.val = oidColTypeRegProc
		}
	case 592:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3631
		{
			sqlVAL.union.val = oidColTypeRegProcedure
		}
	case 593:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3635
		{
			sqlVAL.union.val = oidColTypeRegClass
		}
	case 594:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3639
		{
			sqlVAL.union.val = oidColTypeRegType
		}
	case 595:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3643
		{
			sqlVAL.union.val = oidColTypeRegNamespace
		}
	case 596:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3649
		{
			sqlVAL.union.val = sqlDollar[2].union.numVal()
		}
	case 597:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:3653
		{
			sqlVAL.union.val = &NumVal{Value: constant.MakeInt64(0)}
		}
	case 602:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:3671
		{
			n, err := sqlDollar[4].union.numVal().AsInt64()
			if err != nil {
				sqllex.Error(err.Error())
				return 1
			}
			bit, err := newIntBitType(int(n))
			if err != nil {
				sqllex.Error(err.Error())
				return 1
			}
			sqlVAL.union.val = bit
		}
	case 603:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3687
		{
			sqlVAL.union.val = intColTypeBit
		}
	case 608:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3703
		{
			n, err := sqlDollar[3].union.numVal().AsInt64()
			if err != nil {
				sqllex.Error(err.Error())
				return 1
			}
			sqlVAL.union.val = sqlDollar[1].union.colType()
			if n != 0 {
				strType := &StringColType{N: int(n)}
				strType.Name = sqlVAL.union.val.(*StringColType).Name
				sqlVAL.union.val = strType
			}
		}
	case 609:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3719
		{
			sqlVAL.union.val = sqlDollar[1].union.colType()
		}
	case 610:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3725
		{
			sqlVAL.union.val = stringColTypeChar
		}
	case 611:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3729
		{
			sqlVAL.union.val = stringColTypeChar
		}
	case 612:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3733
		{
			sqlVAL.union.val = stringColTypeVarChar
		}
	case 613:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3737
		{
			sqlVAL.union.val = stringColTypeString
		}
	case 614:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3742
		{
		}
	case 615:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:3743
		{
		}
	case 616:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3748
		{
			sqlVAL.union.val = dateColTypeDate
		}
	case 617:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3752
		{
			sqlVAL.union.val = timestampColTypeTimestamp
		}
	case 618:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3756
		{
			sqlVAL.union.val = timestampColTypeTimestamp
		}
	case 619:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3760
		{
			sqlVAL.union.val = timestampTzColTypeTimestampWithTZ
		}
	case 620:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3764
		{
			sqlVAL.union.val = timestampTzColTypeTimestampWithTZ
		}
	case 621:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3769
		{
			sqlVAL.union.val = intervalColTypeInterval
		}
	case 622:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3775
		{
			sqlVAL.union.val = year
		}
	case 623:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3779
		{
			sqlVAL.union.val = month
		}
	case 624:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3783
		{
			sqlVAL.union.val = day
		}
	case 625:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3787
		{
			sqlVAL.union.val = hour
		}
	case 626:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3791
		{
			sqlVAL.union.val = minute
		}
	case 627:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3795
		{
			sqlVAL.union.val = sqlDollar[1].union.durationField()
		}
	case 628:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3801
		{
			sqlVAL.union.val = month
		}
	case 629:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3805
		{
			sqlVAL.union.val = hour
		}
	case 630:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3809
		{
			sqlVAL.union.val = minute
		}
	case 631:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3813
		{
			sqlVAL.union.val = sqlDollar[3].union.durationField()
		}
	case 632:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3817
		{
			sqlVAL.union.val = minute
		}
	case 633:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3821
		{
			sqlVAL.union.val = sqlDollar[3].union.durationField()
		}
	case 634:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3825
		{
			sqlVAL.union.val = sqlDollar[3].union.durationField()
		}
	case 635:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:3829
		{
			sqlVAL.union.val = nil
		}
	case 636:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:3835
		{
			sqlVAL.union.val = second
		}
	case 637:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3838
		{
			return unimplemented(sqllex, "interval_second")
		}
	case 639:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3862
		{
			sqlVAL.union.val = &CastExpr{Expr: sqlDollar[1].union.expr(), Type: sqlDollar[3].union.castTargetType(), syntaxMode: castShort}
		}
	case 640:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3866
		{
			sqlVAL.union.val = &AnnotateTypeExpr{Expr: sqlDollar[1].union.expr(), Type: sqlDollar[3].union.colType(), syntaxMode: annotateShort}
		}
	case 641:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3870
		{
			sqlVAL.union.val = &CollateExpr{Expr: sqlDollar[1].union.expr(), Locale: sqlDollar[3].str}
		}
	case 642:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:3873
		{
			return unimplemented(sqllex, "at tz")
		}
	case 643:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3882
		{
			sqlVAL.union.val = &UnaryExpr{Operator: UnaryPlus, Expr: sqlDollar[2].union.expr()}
		}
	case 644:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3886
		{
			sqlVAL.union.val = &UnaryExpr{Operator: UnaryMinus, Expr: sqlDollar[2].union.expr()}
		}
	case 645:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3890
		{
			sqlVAL.union.val = &UnaryExpr{Operator: UnaryComplement, Expr: sqlDollar[2].union.expr()}
		}
	case 646:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3894
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Plus, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 647:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3898
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Minus, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 648:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3902
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Mult, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 649:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3906
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Div, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 650:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3910
		{
			sqlVAL.union.val = &BinaryExpr{Operator: FloorDiv, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 651:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3914
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Mod, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 652:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3918
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Pow, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 653:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3922
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Bitxor, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 654:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3926
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Bitand, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 655:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3930
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Bitor, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 656:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3934
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: LT, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 657:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3938
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: GT, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 658:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3942
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: EQ, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 659:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3946
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Concat, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 660:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3950
		{
			sqlVAL.union.val = &BinaryExpr{Operator: LShift, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 661:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3954
		{
			sqlVAL.union.val = &BinaryExpr{Operator: RShift, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 662:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3958
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: LE, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 663:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3962
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: GE, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 664:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3966
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: NE, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 665:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3970
		{
			sqlVAL.union.val = &AndExpr{Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 666:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3974
		{
			sqlVAL.union.val = &OrExpr{Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 667:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3978
		{
			sqlVAL.union.val = &NotExpr{Expr: sqlDollar[2].union.expr()}
		}
	case 668:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:3982
		{
			sqlVAL.union.val = &NotExpr{Expr: sqlDollar[2].union.expr()}
		}
	case 669:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3986
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: Like, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 670:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3990
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: NotLike, Left: sqlDollar[1].union.expr(), Right: sqlDollar[4].union.expr()}
		}
	case 671:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:3994
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: ILike, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 672:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:3998
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: NotILike, Left: sqlDollar[1].union.expr(), Right: sqlDollar[4].union.expr()}
		}
	case 673:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4002
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: SimilarTo, Left: sqlDollar[1].union.expr(), Right: sqlDollar[4].union.expr()}
		}
	case 674:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:4006
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: NotSimilarTo, Left: sqlDollar[1].union.expr(), Right: sqlDollar[5].union.expr()}
		}
	case 675:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4010
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: RegMatch, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 676:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4014
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: NotRegMatch, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 677:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4018
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: RegIMatch, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 678:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4022
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: NotRegIMatch, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 679:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4026
		{
			sqlVAL.union.val = &FuncExpr{Func: wrapFunction("ISNAN"), Exprs: Exprs{sqlDollar[1].union.expr()}}
		}
	case 680:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4030
		{
			sqlVAL.union.val = &NotExpr{Expr: &FuncExpr{Func: wrapFunction("ISNAN"), Exprs: Exprs{sqlDollar[1].union.expr()}}}
		}
	case 681:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4034
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: Is, Left: sqlDollar[1].union.expr(), Right: DNull}
		}
	case 682:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4038
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: IsNot, Left: sqlDollar[1].union.expr(), Right: DNull}
		}
	case 683:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4041
		{
			return unimplemented(sqllex, "overlaps")
		}
	case 684:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4043
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: Is, Left: sqlDollar[1].union.expr(), Right: MakeDBool(true)}
		}
	case 685:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4047
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: IsNot, Left: sqlDollar[1].union.expr(), Right: MakeDBool(true)}
		}
	case 686:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4051
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: Is, Left: sqlDollar[1].union.expr(), Right: MakeDBool(false)}
		}
	case 687:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4055
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: IsNot, Left: sqlDollar[1].union.expr(), Right: MakeDBool(false)}
		}
	case 688:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4059
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: Is, Left: sqlDollar[1].union.expr(), Right: DNull}
		}
	case 689:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4063
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: IsNot, Left: sqlDollar[1].union.expr(), Right: DNull}
		}
	case 690:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:4067
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: IsDistinctFrom, Left: sqlDollar[1].union.expr(), Right: sqlDollar[5].union.expr()}
		}
	case 691:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:4071
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: IsNotDistinctFrom, Left: sqlDollar[1].union.expr(), Right: sqlDollar[6].union.expr()}
		}
	case 692:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:4075
		{
			sqlVAL.union.val = &IsOfTypeExpr{Expr: sqlDollar[1].union.expr(), Types: sqlDollar[5].union.colTypes()}
		}
	case 693:
		sqlDollar = sqlS[sqlpt-7 : sqlpt+1]
		//line sql.y:4079
		{
			sqlVAL.union.val = &IsOfTypeExpr{Not: true, Expr: sqlDollar[1].union.expr(), Types: sqlDollar[6].union.colTypes()}
		}
	case 694:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:4083
		{
			sqlVAL.union.val = &RangeCond{Left: sqlDollar[1].union.expr(), From: sqlDollar[4].union.expr(), To: sqlDollar[6].union.expr()}
		}
	case 695:
		sqlDollar = sqlS[sqlpt-7 : sqlpt+1]
		//line sql.y:4087
		{
			sqlVAL.union.val = &RangeCond{Not: true, Left: sqlDollar[1].union.expr(), From: sqlDollar[5].union.expr(), To: sqlDollar[7].union.expr()}
		}
	case 696:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:4091
		{
			sqlVAL.union.val = &RangeCond{Left: sqlDollar[1].union.expr(), From: sqlDollar[4].union.expr(), To: sqlDollar[6].union.expr()}
		}
	case 697:
		sqlDollar = sqlS[sqlpt-7 : sqlpt+1]
		//line sql.y:4095
		{
			sqlVAL.union.val = &RangeCond{Not: true, Left: sqlDollar[1].union.expr(), From: sqlDollar[5].union.expr(), To: sqlDollar[7].union.expr()}
		}
	case 698:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4099
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: In, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 699:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4103
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: NotIn, Left: sqlDollar[1].union.expr(), Right: sqlDollar[4].union.expr()}
		}
	case 700:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4107
		{
			op := sqlDollar[3].union.cmpOp()
			subOp := sqlDollar[2].union.op()
			subOpCmp, ok := subOp.(ComparisonOperator)
			if !ok {
				sqllex.Error(fmt.Sprintf("%s %s <array> is invalid because %q is not a boolean operator",
					subOp, op, subOp))
				return 1
			}
			sqlVAL.union.val = &ComparisonExpr{
				Operator:    op,
				SubOperator: subOpCmp,
				Left:        sqlDollar[1].union.expr(),
				Right:       sqlDollar[4].union.expr(),
			}
		}
	case 702:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4135
		{
			sqlVAL.union.val = &CastExpr{Expr: sqlDollar[1].union.expr(), Type: sqlDollar[3].union.castTargetType(), syntaxMode: castShort}
		}
	case 703:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4139
		{
			sqlVAL.union.val = &AnnotateTypeExpr{Expr: sqlDollar[1].union.expr(), Type: sqlDollar[3].union.colType(), syntaxMode: annotateShort}
		}
	case 704:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4143
		{
			sqlVAL.union.val = &UnaryExpr{Operator: UnaryPlus, Expr: sqlDollar[2].union.expr()}
		}
	case 705:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4147
		{
			sqlVAL.union.val = &UnaryExpr{Operator: UnaryMinus, Expr: sqlDollar[2].union.expr()}
		}
	case 706:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4151
		{
			sqlVAL.union.val = &UnaryExpr{Operator: UnaryComplement, Expr: sqlDollar[2].union.expr()}
		}
	case 707:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4155
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Plus, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 708:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4159
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Minus, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 709:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4163
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Mult, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 710:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4167
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Div, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 711:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4171
		{
			sqlVAL.union.val = &BinaryExpr{Operator: FloorDiv, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 712:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4175
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Mod, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 713:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4179
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Pow, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 714:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4183
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Bitxor, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 715:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4187
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Bitand, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 716:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4191
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Bitor, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 717:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4195
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: LT, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 718:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4199
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: GT, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 719:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4203
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: EQ, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 720:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4207
		{
			sqlVAL.union.val = &BinaryExpr{Operator: Concat, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 721:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4211
		{
			sqlVAL.union.val = &BinaryExpr{Operator: LShift, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 722:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4215
		{
			sqlVAL.union.val = &BinaryExpr{Operator: RShift, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 723:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4219
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: LE, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 724:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4223
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: GE, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 725:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4227
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: NE, Left: sqlDollar[1].union.expr(), Right: sqlDollar[3].union.expr()}
		}
	case 726:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:4231
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: IsDistinctFrom, Left: sqlDollar[1].union.expr(), Right: sqlDollar[5].union.expr()}
		}
	case 727:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:4235
		{
			sqlVAL.union.val = &ComparisonExpr{Operator: IsNotDistinctFrom, Left: sqlDollar[1].union.expr(), Right: sqlDollar[6].union.expr()}
		}
	case 728:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:4239
		{
			sqlVAL.union.val = &IsOfTypeExpr{Expr: sqlDollar[1].union.expr(), Types: sqlDollar[5].union.colTypes()}
		}
	case 729:
		sqlDollar = sqlS[sqlpt-7 : sqlpt+1]
		//line sql.y:4243
		{
			sqlVAL.union.val = &IsOfTypeExpr{Not: true, Expr: sqlDollar[1].union.expr(), Types: sqlDollar[6].union.colTypes()}
		}
	case 731:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4256
		{
			sqlVAL.union.val = &IndirectionExpr{
				Expr:        sqlDollar[1].union.expr(),
				Indirection: sqlDollar[2].union.arraySubscripts(),
			}
		}
	case 733:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4264
		{
			sqlVAL.union.val = &ExistsExpr{Subquery: &Subquery{Select: sqlDollar[2].union.selectStmt()}}
		}
	case 734:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4275
		{
			sqlVAL.union.val = sqlDollar[1].union.unresolvedName()
		}
	case 736:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4280
		{
			/* SKIP DOC */
			colNum, err := sqlDollar[2].union.numVal().AsInt64()
			if err != nil {
				sqllex.Error(err.Error())
				return 1
			}
			if colNum < 1 || colNum > int64(MaxInt) {
				sqllex.Error(fmt.Sprintf("invalid column ordinal: @%d", colNum))
				return 1
			}
			sqlVAL.union.val = NewOrdinalReference(int(colNum - 1))
		}
	case 737:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4293
		{
			sqlVAL.union.val = NewPlaceholder(sqlDollar[1].str)
		}
	case 738:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4297
		{
			sqlVAL.union.val = &ParenExpr{Expr: sqlDollar[2].union.expr()}
		}
	case 740:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4302
		{
			sqlVAL.union.val = &Subquery{Select: sqlDollar[1].union.selectStmt()}
		}
	case 741:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4306
		{
			sqlVAL.union.val = &ArrayFlatten{Subquery: &Subquery{Select: sqlDollar[2].union.selectStmt()}}
		}
	case 742:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4310
		{
			sqlVAL.union.val = sqlDollar[2].union.expr()
		}
	case 743:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4314
		{
			sqlVAL.union.val = sqlDollar[1].union.expr()
		}
	case 744:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4318
		{
			sqlVAL.union.val = sqlDollar[1].union.expr()
		}
	case 745:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4326
		{
			sqlVAL.union.val = &FuncExpr{Func: sqlDollar[1].union.resolvableFunctionReference()}
		}
	case 746:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:4330
		{
			sqlVAL.union.val = &FuncExpr{Func: sqlDollar[1].union.resolvableFunctionReference(), Exprs: sqlDollar[3].union.exprs()}
		}
	case 747:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:4333
		{
			return unimplemented(sqllex, "variadic")
		}
	case 748:
		sqlDollar = sqlS[sqlpt-8 : sqlpt+1]
		//line sql.y:4334
		{
			return unimplemented(sqllex, "variadic")
		}
	case 749:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:4336
		{
			sqlVAL.union.val = &FuncExpr{Func: sqlDollar[1].union.resolvableFunctionReference(), Type: AllFuncType, Exprs: sqlDollar[4].union.exprs()}
		}
	case 750:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:4340
		{
			sqlVAL.union.val = &FuncExpr{Func: sqlDollar[1].union.resolvableFunctionReference(), Type: DistinctFuncType, Exprs: sqlDollar[4].union.exprs()}
		}
	case 751:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4344
		{
			sqlVAL.union.val = &FuncExpr{Func: sqlDollar[1].union.resolvableFunctionReference(), Exprs: Exprs{StarExpr()}}
		}
	case 752:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4357
		{
			f := sqlDollar[1].union.expr().(*FuncExpr)
			f.Filter = sqlDollar[3].union.expr()
			f.WindowDef = sqlDollar[4].union.windowDef()
			sqlVAL.union.val = f
		}
	case 753:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4364
		{
			sqlVAL.union.val = sqlDollar[1].union.expr()
		}
	case 754:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4373
		{
			return unimplemented(sqllex, "func_application")
		}
	case 755:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4374
		{
			return unimplemented(sqllex, "func_expr_common_subexpr")
		}
	case 756:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:4378
		{
			return unimplemented(sqllex, "func_expr_common_subexpr collation")
		}
	case 757:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4380
		{
			sqlVAL.union.val = &FuncExpr{Func: wrapFunction(sqlDollar[1].str)}
		}
	case 758:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4384
		{
			sqlVAL.union.val = &FuncExpr{Func: wrapFunction(sqlDollar[1].str)}
		}
	case 759:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4388
		{
			sqlVAL.union.val = &FuncExpr{Func: wrapFunction(sqlDollar[1].str)}
		}
	case 760:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4392
		{
			sqlVAL.union.val = &FuncExpr{Func: wrapFunction(sqlDollar[1].str)}
		}
	case 761:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4395
		{
			return unimplemented(sqllex, "current role")
		}
	case 762:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4396
		{
			return unimplemented(sqllex, "current user")
		}
	case 763:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4397
		{
			return unimplemented(sqllex, "session user")
		}
	case 764:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4398
		{
			return unimplemented(sqllex, "user")
		}
	case 765:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:4400
		{
			sqlVAL.union.val = &CastExpr{Expr: sqlDollar[3].union.expr(), Type: sqlDollar[5].union.castTargetType(), syntaxMode: castExplicit}
		}
	case 766:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:4404
		{
			sqlVAL.union.val = &AnnotateTypeExpr{Expr: sqlDollar[3].union.expr(), Type: sqlDollar[5].union.colType(), syntaxMode: annotateExplicit}
		}
	case 767:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4408
		{
			sqlVAL.union.val = &FuncExpr{Func: wrapFunction(sqlDollar[1].str), Exprs: sqlDollar[3].union.exprs()}
		}
	case 768:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4412
		{
			sqlVAL.union.val = &FuncExpr{Func: wrapFunction(sqlDollar[1].str), Exprs: sqlDollar[3].union.exprs()}
		}
	case 769:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4416
		{
			sqlVAL.union.val = &FuncExpr{Func: wrapFunction(sqlDollar[1].str), Exprs: sqlDollar[3].union.exprs()}
		}
	case 770:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4420
		{
			sqlVAL.union.val = &FuncExpr{Func: wrapFunction("STRPOS"), Exprs: sqlDollar[3].union.exprs()}
		}
	case 771:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4424
		{
			sqlVAL.union.val = &FuncExpr{Func: wrapFunction(sqlDollar[1].str), Exprs: sqlDollar[3].union.exprs()}
		}
	case 772:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:4427
		{
			return unimplemented(sqllex, "treat")
		}
	case 773:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:4429
		{
			sqlVAL.union.val = &FuncExpr{Func: wrapFunction("BTRIM"), Exprs: sqlDollar[4].union.exprs()}
		}
	case 774:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:4433
		{
			sqlVAL.union.val = &FuncExpr{Func: wrapFunction("LTRIM"), Exprs: sqlDollar[4].union.exprs()}
		}
	case 775:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:4437
		{
			sqlVAL.union.val = &FuncExpr{Func: wrapFunction("RTRIM"), Exprs: sqlDollar[4].union.exprs()}
		}
	case 776:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4441
		{
			sqlVAL.union.val = &FuncExpr{Func: wrapFunction("BTRIM"), Exprs: sqlDollar[3].union.exprs()}
		}
	case 777:
		sqlDollar = sqlS[sqlpt-8 : sqlpt+1]
		//line sql.y:4445
		{
			sqlVAL.union.val = &IfExpr{Cond: sqlDollar[3].union.expr(), True: sqlDollar[5].union.expr(), Else: sqlDollar[7].union.expr()}
		}
	case 778:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:4449
		{
			sqlVAL.union.val = &NullIfExpr{Expr1: sqlDollar[3].union.expr(), Expr2: sqlDollar[5].union.expr()}
		}
	case 779:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:4453
		{
			sqlVAL.union.val = &CoalesceExpr{Name: "IFNULL", Exprs: Exprs{sqlDollar[3].union.expr(), sqlDollar[5].union.expr()}}
		}
	case 780:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4457
		{
			sqlVAL.union.val = &CoalesceExpr{Name: "COALESCE", Exprs: sqlDollar[3].union.exprs()}
		}
	case 781:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4461
		{
			sqlVAL.union.val = &FuncExpr{Func: wrapFunction(sqlDollar[1].str), Exprs: sqlDollar[3].union.exprs()}
		}
	case 782:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4465
		{
			sqlVAL.union.val = &FuncExpr{Func: wrapFunction(sqlDollar[1].str), Exprs: sqlDollar[3].union.exprs()}
		}
	case 783:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:4471
		{
			return unimplemented(sqllex, "within group")
		}
	case 784:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:4472
		{
		}
	case 785:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:4476
		{
			sqlVAL.union.val = sqlDollar[4].union.expr()
		}
	case 786:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:4480
		{
			sqlVAL.union.val = Expr(nil)
		}
	case 787:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4487
		{
			sqlVAL.union.val = sqlDollar[2].union.window()
		}
	case 788:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:4491
		{
			sqlVAL.union.val = Window(nil)
		}
	case 789:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4497
		{
			sqlVAL.union.val = Window{sqlDollar[1].union.windowDef()}
		}
	case 790:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4501
		{
			sqlVAL.union.val = append(sqlDollar[1].union.window(), sqlDollar[3].union.windowDef())
		}
	case 791:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4507
		{
			n := sqlDollar[3].union.windowDef()
			n.Name = Name(sqlDollar[1].str)
			sqlVAL.union.val = n
		}
	case 792:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4515
		{
			sqlVAL.union.val = sqlDollar[2].union.windowDef()
		}
	case 793:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4519
		{
			sqlVAL.union.val = &WindowDef{Name: Name(sqlDollar[2].str)}
		}
	case 794:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:4523
		{
			sqlVAL.union.val = (*WindowDef)(nil)
		}
	case 795:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:4530
		{
			sqlVAL.union.val = &WindowDef{
				RefName:    Name(sqlDollar[2].str),
				Partitions: sqlDollar[3].union.exprs(),
				OrderBy:    sqlDollar[4].union.orderBy(),
			}
		}
	case 797:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:4549
		{
			sqlVAL.str = ""
		}
	case 798:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4555
		{
			sqlVAL.union.val = sqlDollar[3].union.exprs()
		}
	case 799:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:4559
		{
			sqlVAL.union.val = Exprs(nil)
		}
	case 800:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4569
		{
			return unimplemented(sqllex, "frame range")
		}
	case 801:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4570
		{
			return unimplemented(sqllex, "frame rows")
		}
	case 802:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:4571
		{
		}
	case 803:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4574
		{
			return unimplemented(sqllex, "frame_extent")
		}
	case 804:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4575
		{
			return unimplemented(sqllex, "frame_extent")
		}
	case 805:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4581
		{
			return unimplemented(sqllex, "frame_bound")
		}
	case 806:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4582
		{
			return unimplemented(sqllex, "frame_bound")
		}
	case 807:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4583
		{
			return unimplemented(sqllex, "frame_bound")
		}
	case 808:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4584
		{
			return unimplemented(sqllex, "frame_bound")
		}
	case 809:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4585
		{
			return unimplemented(sqllex, "frame_bound")
		}
	case 810:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4596
		{
			sqlVAL.union.val = &Tuple{Exprs: sqlDollar[3].union.exprs(), row: true}
		}
	case 811:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4600
		{
			sqlVAL.union.val = &Tuple{Exprs: nil, row: true}
		}
	case 812:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:4604
		{
			sqlVAL.union.val = &Tuple{Exprs: append(sqlDollar[2].union.exprs(), sqlDollar[4].union.expr())}
		}
	case 813:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4610
		{
			sqlVAL.union.val = &Tuple{Exprs: sqlDollar[3].union.exprs(), row: true}
		}
	case 814:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4614
		{
			sqlVAL.union.val = &Tuple{Exprs: nil, row: true}
		}
	case 815:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:4620
		{
			sqlVAL.union.val = &Tuple{Exprs: append(sqlDollar[2].union.exprs(), sqlDollar[4].union.expr())}
		}
	case 816:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4626
		{
			sqlVAL.union.val = Any
		}
	case 817:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4630
		{
			sqlVAL.union.val = Some
		}
	case 818:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4634
		{
			sqlVAL.union.val = All
		}
	case 819:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4639
		{
			sqlVAL.union.val = Plus
		}
	case 820:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4640
		{
			sqlVAL.union.val = Minus
		}
	case 821:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4641
		{
			sqlVAL.union.val = Mult
		}
	case 822:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4642
		{
			sqlVAL.union.val = Div
		}
	case 823:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4643
		{
			sqlVAL.union.val = FloorDiv
		}
	case 824:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4644
		{
			sqlVAL.union.val = Mod
		}
	case 825:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4645
		{
			sqlVAL.union.val = Bitand
		}
	case 826:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4646
		{
			sqlVAL.union.val = Bitor
		}
	case 827:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4647
		{
			sqlVAL.union.val = Pow
		}
	case 828:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4648
		{
			sqlVAL.union.val = Bitxor
		}
	case 829:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4649
		{
			sqlVAL.union.val = LT
		}
	case 830:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4650
		{
			sqlVAL.union.val = GT
		}
	case 831:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4651
		{
			sqlVAL.union.val = EQ
		}
	case 832:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4652
		{
			sqlVAL.union.val = LE
		}
	case 833:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4653
		{
			sqlVAL.union.val = GE
		}
	case 834:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4654
		{
			sqlVAL.union.val = NE
		}
	case 836:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4658
		{
			sqlVAL.union.val = Like
		}
	case 837:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4659
		{
			sqlVAL.union.val = NotLike
		}
	case 838:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4660
		{
			sqlVAL.union.val = ILike
		}
	case 839:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4661
		{
			sqlVAL.union.val = NotILike
		}
	case 840:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4672
		{
			sqlVAL.union.val = Exprs{sqlDollar[1].union.expr()}
		}
	case 841:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4676
		{
			sqlVAL.union.val = append(sqlDollar[1].union.exprs(), sqlDollar[3].union.expr())
		}
	case 842:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4682
		{
			sqlVAL.union.val = []ColumnType{sqlDollar[1].union.colType()}
		}
	case 843:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4686
		{
			sqlVAL.union.val = append(sqlDollar[1].union.colTypes(), sqlDollar[3].union.colType())
		}
	case 844:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4692
		{
			sqlVAL.union.val = &Array{Exprs: sqlDollar[2].union.exprs()}
		}
	case 845:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4696
		{
			sqlVAL.union.val = &Array{Exprs: sqlDollar[2].union.exprs()}
		}
	case 846:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4700
		{
			sqlVAL.union.val = &Array{Exprs: nil}
		}
	case 847:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4706
		{
			sqlVAL.union.val = Exprs{sqlDollar[1].union.expr()}
		}
	case 848:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4710
		{
			sqlVAL.union.val = append(sqlDollar[1].union.exprs(), sqlDollar[3].union.expr())
		}
	case 849:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4716
		{
			sqlVAL.union.val = Exprs{&StrVal{s: sqlDollar[1].str}, sqlDollar[3].union.expr()}
		}
	case 850:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4720
		{
			sqlVAL.union.val = sqlDollar[1].union.exprs()
		}
	case 858:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4742
		{
			sqlVAL.union.val = Exprs{sqlDollar[1].union.expr(), sqlDollar[2].union.expr(), sqlDollar[3].union.expr(), sqlDollar[4].union.expr()}
		}
	case 859:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4746
		{
			sqlVAL.union.val = Exprs{sqlDollar[1].union.expr(), sqlDollar[2].union.expr(), sqlDollar[3].union.expr()}
		}
	case 860:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4750
		{
			sqlVAL.union.val = sqlDollar[1].union.exprs()
		}
	case 861:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4756
		{
			sqlVAL.union.val = sqlDollar[2].union.expr()
		}
	case 862:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4763
		{
			sqlVAL.union.val = Exprs{sqlDollar[3].union.expr(), sqlDollar[1].union.expr()}
		}
	case 863:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:4767
		{
			sqlVAL.union.val = Exprs(nil)
		}
	case 864:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4784
		{
			sqlVAL.union.val = Exprs{sqlDollar[1].union.expr(), sqlDollar[2].union.expr(), sqlDollar[3].union.expr()}
		}
	case 865:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4788
		{
			sqlVAL.union.val = Exprs{sqlDollar[1].union.expr(), sqlDollar[3].union.expr(), sqlDollar[2].union.expr()}
		}
	case 866:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4792
		{
			sqlVAL.union.val = Exprs{sqlDollar[1].union.expr(), sqlDollar[2].union.expr()}
		}
	case 867:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4796
		{
			sqlVAL.union.val = Exprs{sqlDollar[1].union.expr(), NewDInt(1), sqlDollar[2].union.expr()}
		}
	case 868:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4800
		{
			sqlVAL.union.val = sqlDollar[1].union.exprs()
		}
	case 869:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:4804
		{
			sqlVAL.union.val = Exprs(nil)
		}
	case 870:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4810
		{
			sqlVAL.union.val = sqlDollar[2].union.expr()
		}
	case 871:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4816
		{
			sqlVAL.union.val = sqlDollar[2].union.expr()
		}
	case 872:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4822
		{
			sqlVAL.union.val = append(sqlDollar[3].union.exprs(), sqlDollar[1].union.expr())
		}
	case 873:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4826
		{
			sqlVAL.union.val = sqlDollar[2].union.exprs()
		}
	case 874:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4830
		{
			sqlVAL.union.val = sqlDollar[1].union.exprs()
		}
	case 875:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4836
		{
			sqlVAL.union.val = &Subquery{Select: sqlDollar[1].union.selectStmt()}
		}
	case 876:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4840
		{
			sqlVAL.union.val = &Tuple{Exprs: sqlDollar[2].union.exprs()}
		}
	case 877:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:4851
		{
			sqlVAL.union.val = &CaseExpr{Expr: sqlDollar[2].union.expr(), Whens: sqlDollar[3].union.whens(), Else: sqlDollar[4].union.expr()}
		}
	case 878:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4858
		{
			sqlVAL.union.val = []*When{sqlDollar[1].union.when()}
		}
	case 879:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4862
		{
			sqlVAL.union.val = append(sqlDollar[1].union.whens(), sqlDollar[2].union.when())
		}
	case 880:
		sqlDollar = sqlS[sqlpt-4 : sqlpt+1]
		//line sql.y:4868
		{
			sqlVAL.union.val = &When{Cond: sqlDollar[2].union.expr(), Val: sqlDollar[4].union.expr()}
		}
	case 881:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4874
		{
			sqlVAL.union.val = sqlDollar[2].union.expr()
		}
	case 882:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:4878
		{
			sqlVAL.union.val = Expr(nil)
		}
	case 884:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:4885
		{
			sqlVAL.union.val = Expr(nil)
		}
	case 885:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4891
		{
			sqlVAL.union.val = &ArraySubscript{Begin: sqlDollar[2].union.expr()}
		}
	case 886:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:4895
		{
			sqlVAL.union.val = &ArraySubscript{Begin: sqlDollar[2].union.expr(), End: sqlDollar[4].union.expr(), Slice: true}
		}
	case 888:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:4902
		{
			sqlVAL.union.val = Expr(nil)
		}
	case 889:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4908
		{
			sqlVAL.union.val = Name(sqlDollar[2].str)
		}
	case 890:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4914
		{
			sqlVAL.union.val = UnqualifiedStar{}
		}
	case 891:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4920
		{
			sqlVAL.union.val = sqlDollar[1].union.namePart()
		}
	case 892:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4924
		{
			sqlVAL.union.val = sqlDollar[1].union.namePart()
		}
	case 893:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4930
		{
			sqlVAL.union.val = UnresolvedName{sqlDollar[1].union.namePart()}
		}
	case 894:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4934
		{
			sqlVAL.union.val = append(sqlDollar[1].union.unresolvedName(), sqlDollar[2].union.namePart())
		}
	case 895:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4940
		{
			sqlVAL.union.val = ArraySubscripts{sqlDollar[1].union.arraySubscript()}
		}
	case 896:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:4944
		{
			sqlVAL.union.val = append(sqlDollar[1].union.arraySubscripts(), sqlDollar[2].union.arraySubscript())
		}
	case 897:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4949
		{
		}
	case 898:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:4950
		{
		}
	case 900:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4959
		{
			sqlVAL.union.val = DefaultVal{}
		}
	case 901:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4965
		{
			sqlVAL.union.val = Exprs{sqlDollar[1].union.expr()}
		}
	case 902:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4969
		{
			sqlVAL.union.val = append(sqlDollar[1].union.exprs(), sqlDollar[3].union.expr())
		}
	case 903:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4978
		{
			sqlVAL.union.val = sqlDollar[2].union.exprs()
		}
	case 904:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:4984
		{
			sqlVAL.union.val = SelectExprs{sqlDollar[1].union.selExpr()}
		}
	case 905:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4988
		{
			sqlVAL.union.val = append(sqlDollar[1].union.selExprs(), sqlDollar[3].union.selExpr())
		}
	case 906:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:4994
		{
			sqlVAL.union.val = SelectExpr{Expr: sqlDollar[1].union.expr(), As: Name(sqlDollar[3].str)}
		}
	case 907:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:5003
		{
			sqlVAL.union.val = SelectExpr{Expr: sqlDollar[1].union.expr(), As: Name(sqlDollar[2].str)}
		}
	case 908:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5007
		{
			sqlVAL.union.val = SelectExpr{Expr: sqlDollar[1].union.expr()}
		}
	case 909:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5011
		{
			sqlVAL.union.val = starSelectExpr()
		}
	case 910:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5019
		{
			sqlVAL.union.val = UnresolvedNames{sqlDollar[1].union.unresolvedName()}
		}
	case 911:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:5023
		{
			sqlVAL.union.val = append(sqlDollar[1].union.unresolvedNames(), sqlDollar[3].union.unresolvedName())
		}
	case 912:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5029
		{
			sqlVAL.union.val = TableNameWithIndexList{sqlDollar[1].union.tableWithIdx()}
		}
	case 913:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:5033
		{
			sqlVAL.union.val = append(sqlDollar[1].union.tableWithIdxList(), sqlDollar[3].union.tableWithIdx())
		}
	case 914:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5039
		{
			sqlVAL.union.val = TablePatterns{sqlDollar[1].union.unresolvedName()}
		}
	case 915:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:5043
		{
			sqlVAL.union.val = append(sqlDollar[1].union.tablePatterns(), sqlDollar[3].union.unresolvedName())
		}
	case 916:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5054
		{
			sqlVAL.union.val = UnresolvedName{Name(sqlDollar[1].str)}
		}
	case 917:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:5058
		{
			sqlVAL.union.val = append(UnresolvedName{Name(sqlDollar[1].str)}, sqlDollar[2].union.unresolvedName()...)
		}
	case 918:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:5064
		{
			sqlVAL.union.val = &TableNameWithIndex{Table: sqlDollar[1].union.normalizableTableName(), Index: Name(sqlDollar[3].str)}
		}
	case 919:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5068
		{
			// This case allows specifying just an index name (potentially schema-qualified).
			// We temporarily store the index name in Table (see TableNameWithIndex).
			sqlVAL.union.val = &TableNameWithIndex{Table: sqlDollar[1].union.normalizableTableName(), SearchTable: true}
		}
	case 920:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5081
		{
			sqlVAL.union.val = UnresolvedName{Name(sqlDollar[1].str)}
		}
	case 921:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5085
		{
			sqlVAL.union.val = UnresolvedName{UnqualifiedStar{}}
		}
	case 922:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:5089
		{
			sqlVAL.union.val = UnresolvedName{Name(sqlDollar[1].str), sqlDollar[2].union.namePart()}
		}
	case 923:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:5093
		{
			sqlVAL.union.val = UnresolvedName{Name(sqlDollar[1].str), sqlDollar[2].union.namePart()}
		}
	case 924:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5099
		{
			sqlVAL.union.val = NameList{Name(sqlDollar[1].str)}
		}
	case 925:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:5103
		{
			sqlVAL.union.val = append(sqlDollar[1].union.nameList(), Name(sqlDollar[3].str))
		}
	case 926:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:5109
		{
			sqlVAL.union.val = sqlDollar[2].union.nameList()
		}
	case 927:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:5112
		{
		}
	case 928:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5122
		{
			sqlVAL.union.val = UnresolvedName{Name(sqlDollar[1].str)}
		}
	case 929:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:5126
		{
			sqlVAL.union.val = append(UnresolvedName{Name(sqlDollar[1].str)}, sqlDollar[2].union.unresolvedName()...)
		}
	case 930:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5133
		{
			sqlVAL.union.val = sqlDollar[1].union.numVal()
		}
	case 931:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5137
		{
			sqlVAL.union.val = sqlDollar[1].union.numVal()
		}
	case 932:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5141
		{
			sqlVAL.union.val = &StrVal{s: sqlDollar[1].str}
		}
	case 933:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5145
		{
			sqlVAL.union.val = &StrVal{s: sqlDollar[1].str, bytesEsc: true}
		}
	case 934:
		sqlDollar = sqlS[sqlpt-6 : sqlpt+1]
		//line sql.y:5148
		{
			return unimplemented(sqllex, "func const")
		}
	case 935:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:5150
		{
			sqlVAL.union.val = &CastExpr{Expr: &StrVal{s: sqlDollar[2].str}, Type: sqlDollar[1].union.colType(), syntaxMode: castPrepend}
		}
	case 936:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5154
		{
			sqlVAL.union.val = sqlDollar[1].union.expr()
		}
	case 937:
		sqlDollar = sqlS[sqlpt-5 : sqlpt+1]
		//line sql.y:5157
		{
			return unimplemented(sqllex, "expr_const const_interval")
		}
	case 938:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5159
		{
			sqlVAL.union.val = MakeDBool(true)
		}
	case 939:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5163
		{
			sqlVAL.union.val = MakeDBool(false)
		}
	case 940:
		sqlDollar = sqlS[sqlpt-1 : sqlpt+1]
		//line sql.y:5167
		{
			sqlVAL.union.val = DNull
		}
	case 942:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:5174
		{
			sqlVAL.union.val = sqlDollar[2].union.numVal()
		}
	case 943:
		sqlDollar = sqlS[sqlpt-2 : sqlpt+1]
		//line sql.y:5178
		{
			sqlVAL.union.val = &NumVal{Value: constant.UnaryOp(token.SUB, sqlDollar[2].union.numVal().Value, 0)}
		}
	case 944:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:5184
		{
			// We don't carry opt_interval information into the column type, so we need
			// to parse the interval directly.
			var err error
			var d Datum
			if sqlDollar[3].union.val == nil {
				d, err = ParseDInterval(sqlDollar[2].str)
			} else {
				d, err = ParseDIntervalWithField(sqlDollar[2].str, sqlDollar[3].union.durationField())
			}
			if err != nil {
				sqllex.Error(err.Error())
				return 1
			}
			sqlVAL.union.val = d
		}
	case 949:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:5219
		{
			sqlVAL.str = ""
		}
	case 950:
		sqlDollar = sqlS[sqlpt-3 : sqlpt+1]
		//line sql.y:5225
		{
			sqlVAL.str = sqlDollar[2].str
		}
	case 951:
		sqlDollar = sqlS[sqlpt-0 : sqlpt+1]
		//line sql.y:5229
		{
			sqlVAL.str = ""
		}
	}
	goto sqlstack /* stack new state and value */
}
