/^col_name_keyword:/ {
  reserved_keyword = 1
  next
}

/^type_func_name_keyword:/ {
  reserved_keyword = 1
  next
}

/^reserved_keyword:/ {
  reserved_keyword = 1
  next
}

/^$/ {
  reserved_keyword = 0
}

BEGIN {
  printf("// Code generated by reserved_keywords.awk.\n\n")
  printf("package parser\n\n")
  printf("var reservedKeywords = map[string]struct{}{\n")

  # This variable will be associated with a pipe for intermediate output.
  sort = "env LC_ALL=C sort"
}

{
  if (reserved_keyword && $NF != "") {
    printf("\"%s\": {},\n", $NF) | sort
  }
}

END {
  # Flush the intermediate output by closing the pipe.
  close(sort)
  printf("}\n")
}
