// Code generated by protoc-gen-gogo.
// source: cockroach/pkg/server/serverpb/status.proto
// DO NOT EDIT!

package serverpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_build "github.com/cockroachdb/cockroach/pkg/build"
import cockroach_gossip "github.com/cockroachdb/cockroach/pkg/gossip"
import cockroach_roachpb1 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_server_status "github.com/cockroachdb/cockroach/pkg/server/status"
import cockroach_storage_engine_enginepb "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import cockroach_storage_storagebase "github.com/cockroachdb/cockroach/pkg/storage/storagebase"
import cockroach_util_log "github.com/cockroachdb/cockroach/pkg/util/log"
import cockroach_util "github.com/cockroachdb/cockroach/pkg/util"
import raftpb "github.com/coreos/etcd/raft/raftpb"

import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"
import time "time"
import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
import github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// We use an enum to allow reporting of client certs and potential others (eg: UI).
type CertificateDetails_CertificateType int32

const (
	CertificateDetails_CA   CertificateDetails_CertificateType = 0
	CertificateDetails_NODE CertificateDetails_CertificateType = 1
)

var CertificateDetails_CertificateType_name = map[int32]string{
	0: "CA",
	1: "NODE",
}
var CertificateDetails_CertificateType_value = map[string]int32{
	"CA":   0,
	"NODE": 1,
}

func (x CertificateDetails_CertificateType) String() string {
	return proto.EnumName(CertificateDetails_CertificateType_name, int32(x))
}
func (CertificateDetails_CertificateType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorStatus, []int{1, 0}
}

// Enum for phase of execution.
type ActiveQuery_Phase int32

const (
	ActiveQuery_PREPARING ActiveQuery_Phase = 0
	ActiveQuery_EXECUTING ActiveQuery_Phase = 1
)

var ActiveQuery_Phase_name = map[int32]string{
	0: "PREPARING",
	1: "EXECUTING",
}
var ActiveQuery_Phase_value = map[string]int32{
	"PREPARING": 0,
	"EXECUTING": 1,
}

func (x ActiveQuery_Phase) String() string {
	return proto.EnumName(ActiveQuery_Phase_name, int32(x))
}
func (ActiveQuery_Phase) EnumDescriptor() ([]byte, []int) { return fileDescriptorStatus, []int{27, 0} }

type CertificatesRequest struct {
	// figure out how to teach grpc-gateway about custom names.
	//
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *CertificatesRequest) Reset()                    { *m = CertificatesRequest{} }
func (m *CertificatesRequest) String() string            { return proto.CompactTextString(m) }
func (*CertificatesRequest) ProtoMessage()               {}
func (*CertificatesRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{0} }

type CertificateDetails struct {
	Type CertificateDetails_CertificateType `protobuf:"varint,1,opt,name=type,proto3,enum=cockroach.server.serverpb.CertificateDetails_CertificateType" json:"type,omitempty"`
	// "error_message" and "data" are mutually exclusive.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// data is the raw file contents of the certificate. This means PEM-encoded DER data.
	Data []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *CertificateDetails) Reset()                    { *m = CertificateDetails{} }
func (m *CertificateDetails) String() string            { return proto.CompactTextString(m) }
func (*CertificateDetails) ProtoMessage()               {}
func (*CertificateDetails) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{1} }

type CertificatesResponse struct {
	Certificates []CertificateDetails `protobuf:"bytes,1,rep,name=certificates" json:"certificates"`
}

func (m *CertificatesResponse) Reset()                    { *m = CertificatesResponse{} }
func (m *CertificatesResponse) String() string            { return proto.CompactTextString(m) }
func (*CertificatesResponse) ProtoMessage()               {}
func (*CertificatesResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{2} }

// DetailsRequest requests a nodes details.
type DetailsRequest struct {
	// figure out how to teach grpc-gateway about custom names.
	//
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *DetailsRequest) Reset()                    { *m = DetailsRequest{} }
func (m *DetailsRequest) String() string            { return proto.CompactTextString(m) }
func (*DetailsRequest) ProtoMessage()               {}
func (*DetailsRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{3} }

type DetailsResponse struct {
	NodeID    github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	Address   cockroach_util.UnresolvedAddr                       `protobuf:"bytes,2,opt,name=address" json:"address"`
	BuildInfo cockroach_build.Info                                `protobuf:"bytes,3,opt,name=build_info,json=buildInfo" json:"build_info"`
}

func (m *DetailsResponse) Reset()                    { *m = DetailsResponse{} }
func (m *DetailsResponse) String() string            { return proto.CompactTextString(m) }
func (*DetailsResponse) ProtoMessage()               {}
func (*DetailsResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{4} }

type NodesRequest struct {
}

func (m *NodesRequest) Reset()                    { *m = NodesRequest{} }
func (m *NodesRequest) String() string            { return proto.CompactTextString(m) }
func (*NodesRequest) ProtoMessage()               {}
func (*NodesRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{5} }

type NodesResponse struct {
	Nodes []cockroach_server_status.NodeStatus `protobuf:"bytes,1,rep,name=nodes" json:"nodes"`
}

func (m *NodesResponse) Reset()                    { *m = NodesResponse{} }
func (m *NodesResponse) String() string            { return proto.CompactTextString(m) }
func (*NodesResponse) ProtoMessage()               {}
func (*NodesResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{6} }

type NodeRequest struct {
	// figure out how to teach grpc-gateway about custom names.
	//
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *NodeRequest) Reset()                    { *m = NodeRequest{} }
func (m *NodeRequest) String() string            { return proto.CompactTextString(m) }
func (*NodeRequest) ProtoMessage()               {}
func (*NodeRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{7} }

// RaftState gives internal details about a Raft group's state.
// Closely mirrors the upstream definitions in github.com/coreos/etcd/raft.
type RaftState struct {
	ReplicaID uint64           `protobuf:"varint,1,opt,name=replica_id,json=replicaId,proto3" json:"replica_id,omitempty"`
	HardState raftpb.HardState `protobuf:"bytes,2,opt,name=hard_state,json=hardState" json:"hard_state"`
	// Lead is part of Raft's SoftState.
	Lead uint64 `protobuf:"varint,3,opt,name=lead,proto3" json:"lead,omitempty"`
	// State is part of Raft's SoftState.
	// It's not an enum because this is primarily for ui consumption and there
	// are issues associated with them.
	State    string                        `protobuf:"bytes,4,opt,name=state,proto3" json:"state,omitempty"`
	Applied  uint64                        `protobuf:"varint,5,opt,name=applied,proto3" json:"applied,omitempty"`
	Progress map[uint64]RaftState_Progress `protobuf:"bytes,6,rep,name=progress" json:"progress" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *RaftState) Reset()                    { *m = RaftState{} }
func (m *RaftState) String() string            { return proto.CompactTextString(m) }
func (*RaftState) ProtoMessage()               {}
func (*RaftState) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{8} }

type RaftState_Progress struct {
	Match           uint64 `protobuf:"varint,1,opt,name=match,proto3" json:"match,omitempty"`
	Next            uint64 `protobuf:"varint,2,opt,name=next,proto3" json:"next,omitempty"`
	State           string `protobuf:"bytes,3,opt,name=state,proto3" json:"state,omitempty"`
	Paused          bool   `protobuf:"varint,4,opt,name=paused,proto3" json:"paused,omitempty"`
	PendingSnapshot uint64 `protobuf:"varint,5,opt,name=pending_snapshot,json=pendingSnapshot,proto3" json:"pending_snapshot,omitempty"`
}

func (m *RaftState_Progress) Reset()                    { *m = RaftState_Progress{} }
func (m *RaftState_Progress) String() string            { return proto.CompactTextString(m) }
func (*RaftState_Progress) ProtoMessage()               {}
func (*RaftState_Progress) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{8, 0} }

type RangeProblems struct {
	Unavailable          bool `protobuf:"varint,1,opt,name=unavailable,proto3" json:"unavailable,omitempty"`
	LeaderNotLeaseHolder bool `protobuf:"varint,2,opt,name=leader_not_lease_holder,json=leaderNotLeaseHolder,proto3" json:"leader_not_lease_holder,omitempty"`
	NoRaftLeader         bool `protobuf:"varint,3,opt,name=no_raft_leader,json=noRaftLeader,proto3" json:"no_raft_leader,omitempty"`
	Underreplicated      bool `protobuf:"varint,4,opt,name=underreplicated,proto3" json:"underreplicated,omitempty"`
	NoLease              bool `protobuf:"varint,5,opt,name=no_lease,json=noLease,proto3" json:"no_lease,omitempty"`
}

func (m *RangeProblems) Reset()                    { *m = RangeProblems{} }
func (m *RangeProblems) String() string            { return proto.CompactTextString(m) }
func (*RangeProblems) ProtoMessage()               {}
func (*RangeProblems) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{9} }

type RangeInfo struct {
	Span          PrettySpan                                           `protobuf:"bytes,1,opt,name=span" json:"span"`
	RaftState     RaftState                                            `protobuf:"bytes,2,opt,name=raft_state,json=raftState" json:"raft_state"`
	State         cockroach_storage_storagebase.RangeInfo              `protobuf:"bytes,4,opt,name=state" json:"state"`
	SourceNodeID  github_com_cockroachdb_cockroach_pkg_roachpb.NodeID  `protobuf:"varint,5,opt,name=source_node_id,json=sourceNodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"source_node_id,omitempty"`
	SourceStoreID github_com_cockroachdb_cockroach_pkg_roachpb.StoreID `protobuf:"varint,6,opt,name=source_store_id,json=sourceStoreId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.StoreID" json:"source_store_id,omitempty"`
	ErrorMessage  string                                               `protobuf:"bytes,7,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	LeaseHistory  []cockroach_roachpb1.Lease                           `protobuf:"bytes,8,rep,name=lease_history,json=leaseHistory" json:"lease_history"`
	Problems      RangeProblems                                        `protobuf:"bytes,9,opt,name=problems" json:"problems"`
}

func (m *RangeInfo) Reset()                    { *m = RangeInfo{} }
func (m *RangeInfo) String() string            { return proto.CompactTextString(m) }
func (*RangeInfo) ProtoMessage()               {}
func (*RangeInfo) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{10} }

type RangesRequest struct {
	// figure out how to teach grpc-gateway about custom names.
	//
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId   string                                                 `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	RangeIDs []github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,2,rep,packed,name=range_ids,json=rangeIds,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_ids,omitempty"`
}

func (m *RangesRequest) Reset()                    { *m = RangesRequest{} }
func (m *RangesRequest) String() string            { return proto.CompactTextString(m) }
func (*RangesRequest) ProtoMessage()               {}
func (*RangesRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{11} }

type RangesResponse struct {
	Ranges []RangeInfo `protobuf:"bytes,1,rep,name=ranges" json:"ranges"`
}

func (m *RangesResponse) Reset()                    { *m = RangesResponse{} }
func (m *RangesResponse) String() string            { return proto.CompactTextString(m) }
func (*RangesResponse) ProtoMessage()               {}
func (*RangesResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{12} }

type GossipRequest struct {
	// figure out how to teach grpc-gateway about custom names.
	//
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *GossipRequest) Reset()                    { *m = GossipRequest{} }
func (m *GossipRequest) String() string            { return proto.CompactTextString(m) }
func (*GossipRequest) ProtoMessage()               {}
func (*GossipRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{13} }

type JSONResponse struct {
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *JSONResponse) Reset()                    { *m = JSONResponse{} }
func (m *JSONResponse) String() string            { return proto.CompactTextString(m) }
func (*JSONResponse) ProtoMessage()               {}
func (*JSONResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{14} }

type LogsRequest struct {
	// figure out how to teach grpc-gateway about custom names.
	//
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId    string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	Level     string `protobuf:"bytes,2,opt,name=level,proto3" json:"level,omitempty"`
	StartTime string `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	EndTime   string `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	Max       string `protobuf:"bytes,5,opt,name=max,proto3" json:"max,omitempty"`
	Pattern   string `protobuf:"bytes,6,opt,name=pattern,proto3" json:"pattern,omitempty"`
}

func (m *LogsRequest) Reset()                    { *m = LogsRequest{} }
func (m *LogsRequest) String() string            { return proto.CompactTextString(m) }
func (*LogsRequest) ProtoMessage()               {}
func (*LogsRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{15} }

type LogEntriesResponse struct {
	Entries []cockroach_util_log.Entry `protobuf:"bytes,1,rep,name=entries" json:"entries"`
}

func (m *LogEntriesResponse) Reset()                    { *m = LogEntriesResponse{} }
func (m *LogEntriesResponse) String() string            { return proto.CompactTextString(m) }
func (*LogEntriesResponse) ProtoMessage()               {}
func (*LogEntriesResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{16} }

type LogFilesListRequest struct {
	// figure out how to teach grpc-gateway about custom names.
	//
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *LogFilesListRequest) Reset()                    { *m = LogFilesListRequest{} }
func (m *LogFilesListRequest) String() string            { return proto.CompactTextString(m) }
func (*LogFilesListRequest) ProtoMessage()               {}
func (*LogFilesListRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{17} }

type LogFilesListResponse struct {
	Files []cockroach_util_log.FileInfo `protobuf:"bytes,1,rep,name=files" json:"files"`
}

func (m *LogFilesListResponse) Reset()                    { *m = LogFilesListResponse{} }
func (m *LogFilesListResponse) String() string            { return proto.CompactTextString(m) }
func (*LogFilesListResponse) ProtoMessage()               {}
func (*LogFilesListResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{18} }

type LogFileRequest struct {
	// figure out how to teach grpc-gateway about custom names.
	//
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	File   string `protobuf:"bytes,2,opt,name=file,proto3" json:"file,omitempty"`
}

func (m *LogFileRequest) Reset()                    { *m = LogFileRequest{} }
func (m *LogFileRequest) String() string            { return proto.CompactTextString(m) }
func (*LogFileRequest) ProtoMessage()               {}
func (*LogFileRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{19} }

type StacksRequest struct {
	// figure out how to teach grpc-gateway about custom names.
	//
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *StacksRequest) Reset()                    { *m = StacksRequest{} }
func (m *StacksRequest) String() string            { return proto.CompactTextString(m) }
func (*StacksRequest) ProtoMessage()               {}
func (*StacksRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{20} }

type MetricsRequest struct {
	// figure out how to teach grpc-gateway about custom names.
	//
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *MetricsRequest) Reset()                    { *m = MetricsRequest{} }
func (m *MetricsRequest) String() string            { return proto.CompactTextString(m) }
func (*MetricsRequest) ProtoMessage()               {}
func (*MetricsRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{21} }

type RaftRangeNode struct {
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	Range  RangeInfo                                           `protobuf:"bytes,2,opt,name=range" json:"range"`
}

func (m *RaftRangeNode) Reset()                    { *m = RaftRangeNode{} }
func (m *RaftRangeNode) String() string            { return proto.CompactTextString(m) }
func (*RaftRangeNode) ProtoMessage()               {}
func (*RaftRangeNode) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{22} }

type RaftRangeError struct {
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *RaftRangeError) Reset()                    { *m = RaftRangeError{} }
func (m *RaftRangeError) String() string            { return proto.CompactTextString(m) }
func (*RaftRangeError) ProtoMessage()               {}
func (*RaftRangeError) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{23} }

type RaftRangeStatus struct {
	RangeID github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,1,opt,name=range_id,json=rangeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_id,omitempty"`
	Errors  []RaftRangeError                                     `protobuf:"bytes,2,rep,name=errors" json:"errors"`
	Nodes   []RaftRangeNode                                      `protobuf:"bytes,3,rep,name=nodes" json:"nodes"`
}

func (m *RaftRangeStatus) Reset()                    { *m = RaftRangeStatus{} }
func (m *RaftRangeStatus) String() string            { return proto.CompactTextString(m) }
func (*RaftRangeStatus) ProtoMessage()               {}
func (*RaftRangeStatus) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{24} }

type RaftDebugRequest struct {
	RangeIDs []github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,1,rep,packed,name=range_ids,json=rangeIds,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_ids,omitempty"`
}

func (m *RaftDebugRequest) Reset()                    { *m = RaftDebugRequest{} }
func (m *RaftDebugRequest) String() string            { return proto.CompactTextString(m) }
func (*RaftDebugRequest) ProtoMessage()               {}
func (*RaftDebugRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{25} }

type RaftDebugResponse struct {
	Ranges map[github_com_cockroachdb_cockroach_pkg_roachpb.RangeID]RaftRangeStatus `protobuf:"bytes,1,rep,name=ranges,castkey=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"ranges" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	Errors []RaftRangeError                                                         `protobuf:"bytes,2,rep,name=errors" json:"errors"`
}

func (m *RaftDebugResponse) Reset()                    { *m = RaftDebugResponse{} }
func (m *RaftDebugResponse) String() string            { return proto.CompactTextString(m) }
func (*RaftDebugResponse) ProtoMessage()               {}
func (*RaftDebugResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{26} }

// ActiveQuery represents a query in flight on some Session.
type ActiveQuery struct {
	// SQL query string specified by the user.
	Sql string `protobuf:"bytes,1,opt,name=sql,proto3" json:"sql,omitempty"`
	// Start timestamp of this query.
	Start time.Time `protobuf:"bytes,2,opt,name=start,stdtime" json:"start"`
	// True if this query is distributed.
	IsDistributed bool `protobuf:"varint,3,opt,name=is_distributed,json=isDistributed,proto3" json:"is_distributed,omitempty"`
	// phase stores the current phase of execution for this query.
	Phase ActiveQuery_Phase `protobuf:"varint,4,opt,name=phase,proto3,enum=cockroach.server.serverpb.ActiveQuery_Phase" json:"phase,omitempty"`
}

func (m *ActiveQuery) Reset()                    { *m = ActiveQuery{} }
func (m *ActiveQuery) String() string            { return proto.CompactTextString(m) }
func (*ActiveQuery) ProtoMessage()               {}
func (*ActiveQuery) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{27} }

// Request object for ListSessions and ListLocalSessions.
type ListSessionsRequest struct {
	// Username of the user making this request.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
}

func (m *ListSessionsRequest) Reset()                    { *m = ListSessionsRequest{} }
func (m *ListSessionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListSessionsRequest) ProtoMessage()               {}
func (*ListSessionsRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{28} }

// Session represents one SQL session.
type Session struct {
	// ID of node where this session exists.
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	// Username of the user for this session.
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	// Connected client's IP address and port.
	ClientAddress string `protobuf:"bytes,3,opt,name=client_address,json=clientAddress,proto3" json:"client_address,omitempty"`
	// Application name specified by the client.
	ApplicationName string `protobuf:"bytes,4,opt,name=application_name,json=applicationName,proto3" json:"application_name,omitempty"`
	// Queries in progress on this session.
	ActiveQueries []ActiveQuery `protobuf:"bytes,5,rep,name=active_queries,json=activeQueries" json:"active_queries"`
	// Timestamp of session's start.
	Start time.Time `protobuf:"bytes,6,opt,name=start,stdtime" json:"start"`
	// ID of the current KV transaction for this session.
	KvTxnID *github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,7,opt,name=kv_txn_id,json=kvTxnId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"kv_txn_id,omitempty"`
}

func (m *Session) Reset()                    { *m = Session{} }
func (m *Session) String() string            { return proto.CompactTextString(m) }
func (*Session) ProtoMessage()               {}
func (*Session) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{29} }

// An error wrapper object for ListSessionsResponse.
type ListSessionsError struct {
	// ID of node that was being contacted when this error occurred
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	// Error message.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *ListSessionsError) Reset()                    { *m = ListSessionsError{} }
func (m *ListSessionsError) String() string            { return proto.CompactTextString(m) }
func (*ListSessionsError) ProtoMessage()               {}
func (*ListSessionsError) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{30} }

// Response object for ListSessions and ListLocalSessions.
type ListSessionsResponse struct {
	// A list of sessions on this node or cluster.
	Sessions []Session `protobuf:"bytes,1,rep,name=sessions" json:"sessions"`
	// Any errors that occurred during fan-out calls to other nodes.
	Errors []ListSessionsError `protobuf:"bytes,2,rep,name=errors" json:"errors"`
}

func (m *ListSessionsResponse) Reset()                    { *m = ListSessionsResponse{} }
func (m *ListSessionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListSessionsResponse) ProtoMessage()               {}
func (*ListSessionsResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{31} }

type SpanStatsRequest struct {
	NodeID   string                                            `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	StartKey github_com_cockroachdb_cockroach_pkg_roachpb.RKey `protobuf:"bytes,2,opt,name=start_key,json=startKey,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RKey" json:"start_key,omitempty"`
	EndKey   github_com_cockroachdb_cockroach_pkg_roachpb.RKey `protobuf:"bytes,3,opt,name=end_key,json=endKey,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RKey" json:"end_key,omitempty"`
}

func (m *SpanStatsRequest) Reset()                    { *m = SpanStatsRequest{} }
func (m *SpanStatsRequest) String() string            { return proto.CompactTextString(m) }
func (*SpanStatsRequest) ProtoMessage()               {}
func (*SpanStatsRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{32} }

type SpanStatsResponse struct {
	RangeCount int32                                       `protobuf:"varint,2,opt,name=range_count,json=rangeCount,proto3" json:"range_count,omitempty"`
	TotalStats cockroach_storage_engine_enginepb.MVCCStats `protobuf:"bytes,1,opt,name=total_stats,json=totalStats" json:"total_stats"`
}

func (m *SpanStatsResponse) Reset()                    { *m = SpanStatsResponse{} }
func (m *SpanStatsResponse) String() string            { return proto.CompactTextString(m) }
func (*SpanStatsResponse) ProtoMessage()               {}
func (*SpanStatsResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{33} }

// PrettySpan holds a pretty-printed key range.
type PrettySpan struct {
	StartKey string `protobuf:"bytes,1,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey   string `protobuf:"bytes,2,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
}

func (m *PrettySpan) Reset()                    { *m = PrettySpan{} }
func (m *PrettySpan) String() string            { return proto.CompactTextString(m) }
func (*PrettySpan) ProtoMessage()               {}
func (*PrettySpan) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{34} }

func init() {
	proto.RegisterType((*CertificatesRequest)(nil), "cockroach.server.serverpb.CertificatesRequest")
	proto.RegisterType((*CertificateDetails)(nil), "cockroach.server.serverpb.CertificateDetails")
	proto.RegisterType((*CertificatesResponse)(nil), "cockroach.server.serverpb.CertificatesResponse")
	proto.RegisterType((*DetailsRequest)(nil), "cockroach.server.serverpb.DetailsRequest")
	proto.RegisterType((*DetailsResponse)(nil), "cockroach.server.serverpb.DetailsResponse")
	proto.RegisterType((*NodesRequest)(nil), "cockroach.server.serverpb.NodesRequest")
	proto.RegisterType((*NodesResponse)(nil), "cockroach.server.serverpb.NodesResponse")
	proto.RegisterType((*NodeRequest)(nil), "cockroach.server.serverpb.NodeRequest")
	proto.RegisterType((*RaftState)(nil), "cockroach.server.serverpb.RaftState")
	proto.RegisterType((*RaftState_Progress)(nil), "cockroach.server.serverpb.RaftState.Progress")
	proto.RegisterType((*RangeProblems)(nil), "cockroach.server.serverpb.RangeProblems")
	proto.RegisterType((*RangeInfo)(nil), "cockroach.server.serverpb.RangeInfo")
	proto.RegisterType((*RangesRequest)(nil), "cockroach.server.serverpb.RangesRequest")
	proto.RegisterType((*RangesResponse)(nil), "cockroach.server.serverpb.RangesResponse")
	proto.RegisterType((*GossipRequest)(nil), "cockroach.server.serverpb.GossipRequest")
	proto.RegisterType((*JSONResponse)(nil), "cockroach.server.serverpb.JSONResponse")
	proto.RegisterType((*LogsRequest)(nil), "cockroach.server.serverpb.LogsRequest")
	proto.RegisterType((*LogEntriesResponse)(nil), "cockroach.server.serverpb.LogEntriesResponse")
	proto.RegisterType((*LogFilesListRequest)(nil), "cockroach.server.serverpb.LogFilesListRequest")
	proto.RegisterType((*LogFilesListResponse)(nil), "cockroach.server.serverpb.LogFilesListResponse")
	proto.RegisterType((*LogFileRequest)(nil), "cockroach.server.serverpb.LogFileRequest")
	proto.RegisterType((*StacksRequest)(nil), "cockroach.server.serverpb.StacksRequest")
	proto.RegisterType((*MetricsRequest)(nil), "cockroach.server.serverpb.MetricsRequest")
	proto.RegisterType((*RaftRangeNode)(nil), "cockroach.server.serverpb.RaftRangeNode")
	proto.RegisterType((*RaftRangeError)(nil), "cockroach.server.serverpb.RaftRangeError")
	proto.RegisterType((*RaftRangeStatus)(nil), "cockroach.server.serverpb.RaftRangeStatus")
	proto.RegisterType((*RaftDebugRequest)(nil), "cockroach.server.serverpb.RaftDebugRequest")
	proto.RegisterType((*RaftDebugResponse)(nil), "cockroach.server.serverpb.RaftDebugResponse")
	proto.RegisterType((*ActiveQuery)(nil), "cockroach.server.serverpb.ActiveQuery")
	proto.RegisterType((*ListSessionsRequest)(nil), "cockroach.server.serverpb.ListSessionsRequest")
	proto.RegisterType((*Session)(nil), "cockroach.server.serverpb.Session")
	proto.RegisterType((*ListSessionsError)(nil), "cockroach.server.serverpb.ListSessionsError")
	proto.RegisterType((*ListSessionsResponse)(nil), "cockroach.server.serverpb.ListSessionsResponse")
	proto.RegisterType((*SpanStatsRequest)(nil), "cockroach.server.serverpb.SpanStatsRequest")
	proto.RegisterType((*SpanStatsResponse)(nil), "cockroach.server.serverpb.SpanStatsResponse")
	proto.RegisterType((*PrettySpan)(nil), "cockroach.server.serverpb.PrettySpan")
	proto.RegisterEnum("cockroach.server.serverpb.CertificateDetails_CertificateType", CertificateDetails_CertificateType_name, CertificateDetails_CertificateType_value)
	proto.RegisterEnum("cockroach.server.serverpb.ActiveQuery_Phase", ActiveQuery_Phase_name, ActiveQuery_Phase_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Status service

type StatusClient interface {
	Certificates(ctx context.Context, in *CertificatesRequest, opts ...grpc.CallOption) (*CertificatesResponse, error)
	Details(ctx context.Context, in *DetailsRequest, opts ...grpc.CallOption) (*DetailsResponse, error)
	Nodes(ctx context.Context, in *NodesRequest, opts ...grpc.CallOption) (*NodesResponse, error)
	Node(ctx context.Context, in *NodeRequest, opts ...grpc.CallOption) (*cockroach_server_status.NodeStatus, error)
	RaftDebug(ctx context.Context, in *RaftDebugRequest, opts ...grpc.CallOption) (*RaftDebugResponse, error)
	Ranges(ctx context.Context, in *RangesRequest, opts ...grpc.CallOption) (*RangesResponse, error)
	Gossip(ctx context.Context, in *GossipRequest, opts ...grpc.CallOption) (*cockroach_gossip.InfoStatus, error)
	ListSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error)
	ListLocalSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error)
	// SpanStats accepts a key span and node ID, and returns a set of stats
	// summed from all ranges on the stores on that node which contain keys
	// in that span. This is designed to compute stats specific to a SQL table:
	// it will be called with the highest/lowest key for a SQL table, and return
	// information about the resources on a node used by that table.
	SpanStats(ctx context.Context, in *SpanStatsRequest, opts ...grpc.CallOption) (*SpanStatsResponse, error)
	Stacks(ctx context.Context, in *StacksRequest, opts ...grpc.CallOption) (*JSONResponse, error)
	Metrics(ctx context.Context, in *MetricsRequest, opts ...grpc.CallOption) (*JSONResponse, error)
	LogFilesList(ctx context.Context, in *LogFilesListRequest, opts ...grpc.CallOption) (*LogFilesListResponse, error)
	LogFile(ctx context.Context, in *LogFileRequest, opts ...grpc.CallOption) (*LogEntriesResponse, error)
	Logs(ctx context.Context, in *LogsRequest, opts ...grpc.CallOption) (*LogEntriesResponse, error)
}

type statusClient struct {
	cc *grpc.ClientConn
}

func NewStatusClient(cc *grpc.ClientConn) StatusClient {
	return &statusClient{cc}
}

func (c *statusClient) Certificates(ctx context.Context, in *CertificatesRequest, opts ...grpc.CallOption) (*CertificatesResponse, error) {
	out := new(CertificatesResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Certificates", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Details(ctx context.Context, in *DetailsRequest, opts ...grpc.CallOption) (*DetailsResponse, error) {
	out := new(DetailsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Details", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Nodes(ctx context.Context, in *NodesRequest, opts ...grpc.CallOption) (*NodesResponse, error) {
	out := new(NodesResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Nodes", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Node(ctx context.Context, in *NodeRequest, opts ...grpc.CallOption) (*cockroach_server_status.NodeStatus, error) {
	out := new(cockroach_server_status.NodeStatus)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Node", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) RaftDebug(ctx context.Context, in *RaftDebugRequest, opts ...grpc.CallOption) (*RaftDebugResponse, error) {
	out := new(RaftDebugResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/RaftDebug", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Ranges(ctx context.Context, in *RangesRequest, opts ...grpc.CallOption) (*RangesResponse, error) {
	out := new(RangesResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Ranges", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Gossip(ctx context.Context, in *GossipRequest, opts ...grpc.CallOption) (*cockroach_gossip.InfoStatus, error) {
	out := new(cockroach_gossip.InfoStatus)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Gossip", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) ListSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error) {
	out := new(ListSessionsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/ListSessions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) ListLocalSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error) {
	out := new(ListSessionsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/ListLocalSessions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) SpanStats(ctx context.Context, in *SpanStatsRequest, opts ...grpc.CallOption) (*SpanStatsResponse, error) {
	out := new(SpanStatsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/SpanStats", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Stacks(ctx context.Context, in *StacksRequest, opts ...grpc.CallOption) (*JSONResponse, error) {
	out := new(JSONResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Stacks", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Metrics(ctx context.Context, in *MetricsRequest, opts ...grpc.CallOption) (*JSONResponse, error) {
	out := new(JSONResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Metrics", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) LogFilesList(ctx context.Context, in *LogFilesListRequest, opts ...grpc.CallOption) (*LogFilesListResponse, error) {
	out := new(LogFilesListResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/LogFilesList", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) LogFile(ctx context.Context, in *LogFileRequest, opts ...grpc.CallOption) (*LogEntriesResponse, error) {
	out := new(LogEntriesResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/LogFile", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Logs(ctx context.Context, in *LogsRequest, opts ...grpc.CallOption) (*LogEntriesResponse, error) {
	out := new(LogEntriesResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Logs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Status service

type StatusServer interface {
	Certificates(context.Context, *CertificatesRequest) (*CertificatesResponse, error)
	Details(context.Context, *DetailsRequest) (*DetailsResponse, error)
	Nodes(context.Context, *NodesRequest) (*NodesResponse, error)
	Node(context.Context, *NodeRequest) (*cockroach_server_status.NodeStatus, error)
	RaftDebug(context.Context, *RaftDebugRequest) (*RaftDebugResponse, error)
	Ranges(context.Context, *RangesRequest) (*RangesResponse, error)
	Gossip(context.Context, *GossipRequest) (*cockroach_gossip.InfoStatus, error)
	ListSessions(context.Context, *ListSessionsRequest) (*ListSessionsResponse, error)
	ListLocalSessions(context.Context, *ListSessionsRequest) (*ListSessionsResponse, error)
	// SpanStats accepts a key span and node ID, and returns a set of stats
	// summed from all ranges on the stores on that node which contain keys
	// in that span. This is designed to compute stats specific to a SQL table:
	// it will be called with the highest/lowest key for a SQL table, and return
	// information about the resources on a node used by that table.
	SpanStats(context.Context, *SpanStatsRequest) (*SpanStatsResponse, error)
	Stacks(context.Context, *StacksRequest) (*JSONResponse, error)
	Metrics(context.Context, *MetricsRequest) (*JSONResponse, error)
	LogFilesList(context.Context, *LogFilesListRequest) (*LogFilesListResponse, error)
	LogFile(context.Context, *LogFileRequest) (*LogEntriesResponse, error)
	Logs(context.Context, *LogsRequest) (*LogEntriesResponse, error)
}

func RegisterStatusServer(s *grpc.Server, srv StatusServer) {
	s.RegisterService(&_Status_serviceDesc, srv)
}

func _Status_Certificates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CertificatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Certificates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Certificates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Certificates(ctx, req.(*CertificatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Details_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Details(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Details",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Details(ctx, req.(*DetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Nodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Nodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Nodes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Nodes(ctx, req.(*NodesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Node_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Node(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Node",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Node(ctx, req.(*NodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_RaftDebug_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RaftDebugRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).RaftDebug(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/RaftDebug",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).RaftDebug(ctx, req.(*RaftDebugRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Ranges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Ranges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Ranges",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Ranges(ctx, req.(*RangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Gossip_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GossipRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Gossip(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Gossip",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Gossip(ctx, req.(*GossipRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_ListSessions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).ListSessions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/ListSessions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).ListSessions(ctx, req.(*ListSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_ListLocalSessions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).ListLocalSessions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/ListLocalSessions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).ListLocalSessions(ctx, req.(*ListSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_SpanStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SpanStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).SpanStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/SpanStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).SpanStats(ctx, req.(*SpanStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Stacks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StacksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Stacks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Stacks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Stacks(ctx, req.(*StacksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Metrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Metrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Metrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Metrics(ctx, req.(*MetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_LogFilesList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LogFilesListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).LogFilesList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/LogFilesList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).LogFilesList(ctx, req.(*LogFilesListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_LogFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LogFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).LogFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/LogFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).LogFile(ctx, req.(*LogFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Logs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Logs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Logs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Logs(ctx, req.(*LogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Status_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cockroach.server.serverpb.Status",
	HandlerType: (*StatusServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Certificates",
			Handler:    _Status_Certificates_Handler,
		},
		{
			MethodName: "Details",
			Handler:    _Status_Details_Handler,
		},
		{
			MethodName: "Nodes",
			Handler:    _Status_Nodes_Handler,
		},
		{
			MethodName: "Node",
			Handler:    _Status_Node_Handler,
		},
		{
			MethodName: "RaftDebug",
			Handler:    _Status_RaftDebug_Handler,
		},
		{
			MethodName: "Ranges",
			Handler:    _Status_Ranges_Handler,
		},
		{
			MethodName: "Gossip",
			Handler:    _Status_Gossip_Handler,
		},
		{
			MethodName: "ListSessions",
			Handler:    _Status_ListSessions_Handler,
		},
		{
			MethodName: "ListLocalSessions",
			Handler:    _Status_ListLocalSessions_Handler,
		},
		{
			MethodName: "SpanStats",
			Handler:    _Status_SpanStats_Handler,
		},
		{
			MethodName: "Stacks",
			Handler:    _Status_Stacks_Handler,
		},
		{
			MethodName: "Metrics",
			Handler:    _Status_Metrics_Handler,
		},
		{
			MethodName: "LogFilesList",
			Handler:    _Status_LogFilesList_Handler,
		},
		{
			MethodName: "LogFile",
			Handler:    _Status_LogFile_Handler,
		},
		{
			MethodName: "Logs",
			Handler:    _Status_Logs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "cockroach/pkg/server/serverpb/status.proto",
}

func (m *CertificatesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CertificatesRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	return i, nil
}

func (m *CertificateDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CertificateDetails) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Type))
	}
	if len(m.ErrorMessage) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.ErrorMessage)))
		i += copy(dAtA[i:], m.ErrorMessage)
	}
	if len(m.Data) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *CertificatesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CertificatesResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Certificates) > 0 {
		for _, msg := range m.Certificates {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *DetailsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DetailsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	return i, nil
}

func (m *DetailsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DetailsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.NodeID))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.Address.Size()))
	n1, err := m.Address.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x1a
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.BuildInfo.Size()))
	n2, err := m.BuildInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	return i, nil
}

func (m *NodesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodesRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *NodesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodesResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Nodes) > 0 {
		for _, msg := range m.Nodes {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *NodeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	return i, nil
}

func (m *RaftState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftState) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ReplicaID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.ReplicaID))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.HardState.Size()))
	n3, err := m.HardState.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if m.Lead != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Lead))
	}
	if len(m.State) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.State)))
		i += copy(dAtA[i:], m.State)
	}
	if m.Applied != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Applied))
	}
	if len(m.Progress) > 0 {
		keysForProgress := make([]uint64, 0, len(m.Progress))
		for k := range m.Progress {
			keysForProgress = append(keysForProgress, uint64(k))
		}
		github_com_gogo_protobuf_sortkeys.Uint64s(keysForProgress)
		for _, k := range keysForProgress {
			dAtA[i] = 0x32
			i++
			v := m.Progress[uint64(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovStatus(uint64(msgSize))
			}
			mapSize := 1 + sovStatus(uint64(k)) + msgSize
			i = encodeVarintStatus(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintStatus(dAtA, i, uint64(k))
			dAtA[i] = 0x12
			i++
			i = encodeVarintStatus(dAtA, i, uint64((&v).Size()))
			n4, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n4
		}
	}
	return i, nil
}

func (m *RaftState_Progress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftState_Progress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Match != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Match))
	}
	if m.Next != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Next))
	}
	if len(m.State) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.State)))
		i += copy(dAtA[i:], m.State)
	}
	if m.Paused {
		dAtA[i] = 0x20
		i++
		if m.Paused {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.PendingSnapshot != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.PendingSnapshot))
	}
	return i, nil
}

func (m *RangeProblems) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeProblems) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Unavailable {
		dAtA[i] = 0x8
		i++
		if m.Unavailable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.LeaderNotLeaseHolder {
		dAtA[i] = 0x10
		i++
		if m.LeaderNotLeaseHolder {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.NoRaftLeader {
		dAtA[i] = 0x18
		i++
		if m.NoRaftLeader {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Underreplicated {
		dAtA[i] = 0x20
		i++
		if m.Underreplicated {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.NoLease {
		dAtA[i] = 0x28
		i++
		if m.NoLease {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RangeInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.Span.Size()))
	n5, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	dAtA[i] = 0x12
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.RaftState.Size()))
	n6, err := m.RaftState.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	dAtA[i] = 0x22
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.State.Size()))
	n7, err := m.State.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	if m.SourceNodeID != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.SourceNodeID))
	}
	if m.SourceStoreID != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.SourceStoreID))
	}
	if len(m.ErrorMessage) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.ErrorMessage)))
		i += copy(dAtA[i:], m.ErrorMessage)
	}
	if len(m.LeaseHistory) > 0 {
		for _, msg := range m.LeaseHistory {
			dAtA[i] = 0x42
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x4a
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.Problems.Size()))
	n8, err := m.Problems.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	return i, nil
}

func (m *RangesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangesRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	if len(m.RangeIDs) > 0 {
		dAtA10 := make([]byte, len(m.RangeIDs)*10)
		var j9 int
		for _, num1 := range m.RangeIDs {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA10[j9] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j9++
			}
			dAtA10[j9] = uint8(num)
			j9++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(j9))
		i += copy(dAtA[i:], dAtA10[:j9])
	}
	return i, nil
}

func (m *RangesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangesResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Ranges) > 0 {
		for _, msg := range m.Ranges {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *GossipRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GossipRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	return i, nil
}

func (m *JSONResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JSONResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Data) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *LogsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LogsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	if len(m.Level) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Level)))
		i += copy(dAtA[i:], m.Level)
	}
	if len(m.StartTime) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.StartTime)))
		i += copy(dAtA[i:], m.StartTime)
	}
	if len(m.EndTime) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.EndTime)))
		i += copy(dAtA[i:], m.EndTime)
	}
	if len(m.Max) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Max)))
		i += copy(dAtA[i:], m.Max)
	}
	if len(m.Pattern) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Pattern)))
		i += copy(dAtA[i:], m.Pattern)
	}
	return i, nil
}

func (m *LogEntriesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LogEntriesResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for _, msg := range m.Entries {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *LogFilesListRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LogFilesListRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	return i, nil
}

func (m *LogFilesListResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LogFilesListResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *LogFileRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LogFileRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	if len(m.File) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.File)))
		i += copy(dAtA[i:], m.File)
	}
	return i, nil
}

func (m *StacksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StacksRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	return i, nil
}

func (m *MetricsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	return i, nil
}

func (m *RaftRangeNode) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftRangeNode) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.NodeID))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.Range.Size()))
	n11, err := m.Range.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	return i, nil
}

func (m *RaftRangeError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftRangeError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Message)))
		i += copy(dAtA[i:], m.Message)
	}
	return i, nil
}

func (m *RaftRangeStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftRangeStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RangeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.RangeID))
	}
	if len(m.Errors) > 0 {
		for _, msg := range m.Errors {
			dAtA[i] = 0x12
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Nodes) > 0 {
		for _, msg := range m.Nodes {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RaftDebugRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftDebugRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.RangeIDs) > 0 {
		dAtA13 := make([]byte, len(m.RangeIDs)*10)
		var j12 int
		for _, num1 := range m.RangeIDs {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA13[j12] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j12++
			}
			dAtA13[j12] = uint8(num)
			j12++
		}
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(j12))
		i += copy(dAtA[i:], dAtA13[:j12])
	}
	return i, nil
}

func (m *RaftDebugResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftDebugResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Ranges) > 0 {
		keysForRanges := make([]int64, 0, len(m.Ranges))
		for k := range m.Ranges {
			keysForRanges = append(keysForRanges, int64(k))
		}
		github_com_gogo_protobuf_sortkeys.Int64s(keysForRanges)
		for _, k := range keysForRanges {
			dAtA[i] = 0xa
			i++
			v := m.Ranges[github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovStatus(uint64(msgSize))
			}
			mapSize := 1 + sovStatus(uint64(k)) + msgSize
			i = encodeVarintStatus(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintStatus(dAtA, i, uint64(k))
			dAtA[i] = 0x12
			i++
			i = encodeVarintStatus(dAtA, i, uint64((&v).Size()))
			n14, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n14
		}
	}
	if len(m.Errors) > 0 {
		for _, msg := range m.Errors {
			dAtA[i] = 0x12
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ActiveQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ActiveQuery) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Sql) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Sql)))
		i += copy(dAtA[i:], m.Sql)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintStatus(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.Start)))
	n15, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Start, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n15
	if m.IsDistributed {
		dAtA[i] = 0x18
		i++
		if m.IsDistributed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Phase != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Phase))
	}
	return i, nil
}

func (m *ListSessionsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListSessionsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Username) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Username)))
		i += copy(dAtA[i:], m.Username)
	}
	return i, nil
}

func (m *Session) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Session) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.NodeID))
	}
	if len(m.Username) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Username)))
		i += copy(dAtA[i:], m.Username)
	}
	if len(m.ClientAddress) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.ClientAddress)))
		i += copy(dAtA[i:], m.ClientAddress)
	}
	if len(m.ApplicationName) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.ApplicationName)))
		i += copy(dAtA[i:], m.ApplicationName)
	}
	if len(m.ActiveQueries) > 0 {
		for _, msg := range m.ActiveQueries {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x32
	i++
	i = encodeVarintStatus(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.Start)))
	n16, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Start, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n16
	if m.KvTxnID != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.KvTxnID.Size()))
		n17, err := m.KvTxnID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	return i, nil
}

func (m *ListSessionsError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListSessionsError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.NodeID))
	}
	if len(m.Message) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Message)))
		i += copy(dAtA[i:], m.Message)
	}
	return i, nil
}

func (m *ListSessionsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListSessionsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Sessions) > 0 {
		for _, msg := range m.Sessions {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Errors) > 0 {
		for _, msg := range m.Errors {
			dAtA[i] = 0x12
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *SpanStatsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SpanStatsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeID)))
		i += copy(dAtA[i:], m.NodeID)
	}
	if len(m.StartKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	return i, nil
}

func (m *SpanStatsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SpanStatsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.TotalStats.Size()))
	n18, err := m.TotalStats.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	if m.RangeCount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.RangeCount))
	}
	return i, nil
}

func (m *PrettySpan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrettySpan) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.StartKey) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	return i, nil
}

func encodeFixed64Status(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Status(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintStatus(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *CertificatesRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *CertificateDetails) Size() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovStatus(uint64(m.Type))
	}
	l = len(m.ErrorMessage)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *CertificatesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Certificates) > 0 {
		for _, e := range m.Certificates {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *DetailsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *DetailsResponse) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovStatus(uint64(m.NodeID))
	}
	l = m.Address.Size()
	n += 1 + l + sovStatus(uint64(l))
	l = m.BuildInfo.Size()
	n += 1 + l + sovStatus(uint64(l))
	return n
}

func (m *NodesRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *NodesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Nodes) > 0 {
		for _, e := range m.Nodes {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *NodeRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *RaftState) Size() (n int) {
	var l int
	_ = l
	if m.ReplicaID != 0 {
		n += 1 + sovStatus(uint64(m.ReplicaID))
	}
	l = m.HardState.Size()
	n += 1 + l + sovStatus(uint64(l))
	if m.Lead != 0 {
		n += 1 + sovStatus(uint64(m.Lead))
	}
	l = len(m.State)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if m.Applied != 0 {
		n += 1 + sovStatus(uint64(m.Applied))
	}
	if len(m.Progress) > 0 {
		for k, v := range m.Progress {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + sovStatus(uint64(k)) + 1 + l + sovStatus(uint64(l))
			n += mapEntrySize + 1 + sovStatus(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *RaftState_Progress) Size() (n int) {
	var l int
	_ = l
	if m.Match != 0 {
		n += 1 + sovStatus(uint64(m.Match))
	}
	if m.Next != 0 {
		n += 1 + sovStatus(uint64(m.Next))
	}
	l = len(m.State)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if m.Paused {
		n += 2
	}
	if m.PendingSnapshot != 0 {
		n += 1 + sovStatus(uint64(m.PendingSnapshot))
	}
	return n
}

func (m *RangeProblems) Size() (n int) {
	var l int
	_ = l
	if m.Unavailable {
		n += 2
	}
	if m.LeaderNotLeaseHolder {
		n += 2
	}
	if m.NoRaftLeader {
		n += 2
	}
	if m.Underreplicated {
		n += 2
	}
	if m.NoLease {
		n += 2
	}
	return n
}

func (m *RangeInfo) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovStatus(uint64(l))
	l = m.RaftState.Size()
	n += 1 + l + sovStatus(uint64(l))
	l = m.State.Size()
	n += 1 + l + sovStatus(uint64(l))
	if m.SourceNodeID != 0 {
		n += 1 + sovStatus(uint64(m.SourceNodeID))
	}
	if m.SourceStoreID != 0 {
		n += 1 + sovStatus(uint64(m.SourceStoreID))
	}
	l = len(m.ErrorMessage)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if len(m.LeaseHistory) > 0 {
		for _, e := range m.LeaseHistory {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	l = m.Problems.Size()
	n += 1 + l + sovStatus(uint64(l))
	return n
}

func (m *RangesRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if len(m.RangeIDs) > 0 {
		l = 0
		for _, e := range m.RangeIDs {
			l += sovStatus(uint64(e))
		}
		n += 1 + sovStatus(uint64(l)) + l
	}
	return n
}

func (m *RangesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Ranges) > 0 {
		for _, e := range m.Ranges {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *GossipRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *JSONResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *LogsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.Level)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.StartTime)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.EndTime)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.Max)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.Pattern)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *LogEntriesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for _, e := range m.Entries {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *LogFilesListRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *LogFilesListResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *LogFileRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.File)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *StacksRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *MetricsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *RaftRangeNode) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovStatus(uint64(m.NodeID))
	}
	l = m.Range.Size()
	n += 1 + l + sovStatus(uint64(l))
	return n
}

func (m *RaftRangeError) Size() (n int) {
	var l int
	_ = l
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *RaftRangeStatus) Size() (n int) {
	var l int
	_ = l
	if m.RangeID != 0 {
		n += 1 + sovStatus(uint64(m.RangeID))
	}
	if len(m.Errors) > 0 {
		for _, e := range m.Errors {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	if len(m.Nodes) > 0 {
		for _, e := range m.Nodes {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *RaftDebugRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.RangeIDs) > 0 {
		l = 0
		for _, e := range m.RangeIDs {
			l += sovStatus(uint64(e))
		}
		n += 1 + sovStatus(uint64(l)) + l
	}
	return n
}

func (m *RaftDebugResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Ranges) > 0 {
		for k, v := range m.Ranges {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + sovStatus(uint64(k)) + 1 + l + sovStatus(uint64(l))
			n += mapEntrySize + 1 + sovStatus(uint64(mapEntrySize))
		}
	}
	if len(m.Errors) > 0 {
		for _, e := range m.Errors {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *ActiveQuery) Size() (n int) {
	var l int
	_ = l
	l = len(m.Sql)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Start)
	n += 1 + l + sovStatus(uint64(l))
	if m.IsDistributed {
		n += 2
	}
	if m.Phase != 0 {
		n += 1 + sovStatus(uint64(m.Phase))
	}
	return n
}

func (m *ListSessionsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *Session) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovStatus(uint64(m.NodeID))
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.ClientAddress)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.ApplicationName)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if len(m.ActiveQueries) > 0 {
		for _, e := range m.ActiveQueries {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Start)
	n += 1 + l + sovStatus(uint64(l))
	if m.KvTxnID != nil {
		l = m.KvTxnID.Size()
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *ListSessionsError) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovStatus(uint64(m.NodeID))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *ListSessionsResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Sessions) > 0 {
		for _, e := range m.Sessions {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	if len(m.Errors) > 0 {
		for _, e := range m.Errors {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *SpanStatsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *SpanStatsResponse) Size() (n int) {
	var l int
	_ = l
	l = m.TotalStats.Size()
	n += 1 + l + sovStatus(uint64(l))
	if m.RangeCount != 0 {
		n += 1 + sovStatus(uint64(m.RangeCount))
	}
	return n
}

func (m *PrettySpan) Size() (n int) {
	var l int
	_ = l
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func sovStatus(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozStatus(x uint64) (n int) {
	return sovStatus(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *CertificatesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CertificatesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CertificatesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CertificateDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CertificateDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CertificateDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (CertificateDetails_CertificateType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CertificatesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CertificatesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CertificatesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Certificates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Certificates = append(m.Certificates, CertificateDetails{})
			if err := m.Certificates[len(m.Certificates)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DetailsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DetailsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DetailsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DetailsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DetailsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DetailsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Address.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BuildInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.BuildInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nodes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nodes = append(m.Nodes, cockroach_server_status.NodeStatus{})
			if err := m.Nodes[len(m.Nodes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaID", wireType)
			}
			m.ReplicaID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplicaID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HardState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.HardState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lead", wireType)
			}
			m.Lead = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Lead |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.State = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Applied", wireType)
			}
			m.Applied = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Applied |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Progress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var mapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				mapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if m.Progress == nil {
				m.Progress = make(map[uint64]RaftState_Progress)
			}
			if iNdEx < postIndex {
				var valuekey uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					valuekey |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				var mapmsglen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					mapmsglen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if mapmsglen < 0 {
					return ErrInvalidLengthStatus
				}
				postmsgIndex := iNdEx + mapmsglen
				if mapmsglen < 0 {
					return ErrInvalidLengthStatus
				}
				if postmsgIndex > l {
					return io.ErrUnexpectedEOF
				}
				mapvalue := &RaftState_Progress{}
				if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
					return err
				}
				iNdEx = postmsgIndex
				m.Progress[mapkey] = *mapvalue
			} else {
				var mapvalue RaftState_Progress
				m.Progress[mapkey] = mapvalue
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftState_Progress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Progress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Progress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Match", wireType)
			}
			m.Match = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Match |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Next", wireType)
			}
			m.Next = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Next |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.State = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Paused", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Paused = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PendingSnapshot", wireType)
			}
			m.PendingSnapshot = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PendingSnapshot |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeProblems) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeProblems: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeProblems: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unavailable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Unavailable = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaderNotLeaseHolder", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LeaderNotLeaseHolder = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoRaftLeader", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoRaftLeader = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Underreplicated", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Underreplicated = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoLease", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoLease = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RaftState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.State.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceNodeID", wireType)
			}
			m.SourceNodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SourceNodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceStoreID", wireType)
			}
			m.SourceStoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SourceStoreID |= (github_com_cockroachdb_cockroach_pkg_roachpb.StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseHistory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LeaseHistory = append(m.LeaseHistory, cockroach_roachpb1.Lease{})
			if err := m.LeaseHistory[len(m.LeaseHistory)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Problems", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Problems.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.RangeIDs = append(m.RangeIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStatus
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.RangeIDs = append(m.RangeIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeIDs", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ranges = append(m.Ranges, RangeInfo{})
			if err := m.Ranges[len(m.Ranges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GossipRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GossipRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GossipRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JSONResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JSONResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JSONResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Level", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Level = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTime = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndTime = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Max", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Max = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pattern", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogEntriesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogEntriesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogEntriesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Entries = append(m.Entries, cockroach_util_log.Entry{})
			if err := m.Entries[len(m.Entries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogFilesListRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogFilesListRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogFilesListRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogFilesListResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogFilesListResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogFilesListResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, cockroach_util_log.FileInfo{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogFileRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogFileRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogFileRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field File", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.File = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StacksRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StacksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StacksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetricsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftRangeNode) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftRangeNode: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftRangeNode: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Range", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Range.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftRangeError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftRangeError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftRangeError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftRangeStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftRangeStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftRangeStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Errors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Errors = append(m.Errors, RaftRangeError{})
			if err := m.Errors[len(m.Errors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nodes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nodes = append(m.Nodes, RaftRangeNode{})
			if err := m.Nodes[len(m.Nodes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftDebugRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftDebugRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftDebugRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.RangeIDs = append(m.RangeIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStatus
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.RangeIDs = append(m.RangeIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeIDs", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftDebugResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftDebugResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftDebugResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var mapkey int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				mapkey |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if m.Ranges == nil {
				m.Ranges = make(map[github_com_cockroachdb_cockroach_pkg_roachpb.RangeID]RaftRangeStatus)
			}
			if iNdEx < postIndex {
				var valuekey uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					valuekey |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				var mapmsglen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					mapmsglen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if mapmsglen < 0 {
					return ErrInvalidLengthStatus
				}
				postmsgIndex := iNdEx + mapmsglen
				if mapmsglen < 0 {
					return ErrInvalidLengthStatus
				}
				if postmsgIndex > l {
					return io.ErrUnexpectedEOF
				}
				mapvalue := &RaftRangeStatus{}
				if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
					return err
				}
				iNdEx = postmsgIndex
				m.Ranges[github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(mapkey)] = *mapvalue
			} else {
				var mapvalue RaftRangeStatus
				m.Ranges[github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(mapkey)] = mapvalue
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Errors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Errors = append(m.Errors, RaftRangeError{})
			if err := m.Errors[len(m.Errors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ActiveQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ActiveQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ActiveQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sql", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sql = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Start, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDistributed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDistributed = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Phase", wireType)
			}
			m.Phase = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Phase |= (ActiveQuery_Phase(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListSessionsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListSessionsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListSessionsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Session) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Session: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Session: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplicationName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApplicationName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveQueries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActiveQueries = append(m.ActiveQueries, ActiveQuery{})
			if err := m.ActiveQueries[len(m.ActiveQueries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Start, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KvTxnID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cockroachdb_cockroach_pkg_util_uuid.UUID
			m.KvTxnID = &v
			if err := m.KvTxnID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListSessionsError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListSessionsError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListSessionsError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListSessionsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListSessionsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListSessionsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sessions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sessions = append(m.Sessions, Session{})
			if err := m.Sessions[len(m.Sessions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Errors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Errors = append(m.Errors, ListSessionsError{})
			if err := m.Errors[len(m.Errors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SpanStatsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SpanStatsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SpanStatsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SpanStatsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SpanStatsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SpanStatsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TotalStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeCount", wireType)
			}
			m.RangeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeCount |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrettySpan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrettySpan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrettySpan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipStatus(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthStatus
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipStatus(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthStatus = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowStatus   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("cockroach/pkg/server/serverpb/status.proto", fileDescriptorStatus) }

var fileDescriptorStatus = []byte{
	// 2534 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0xcd, 0x6f, 0x1c, 0x49,
	0x15, 0x4f, 0x7b, 0xbe, 0xdf, 0x78, 0x6c, 0xa7, 0xd6, 0xbb, 0xb1, 0x27, 0xbb, 0x1e, 0x6f, 0xe7,
	0xcb, 0x36, 0xc9, 0x0c, 0xeb, 0x65, 0x51, 0x88, 0x58, 0x76, 0x3d, 0xb6, 0x49, 0x9c, 0x38, 0x8e,
	0xb7, 0xed, 0x00, 0xca, 0x61, 0x47, 0x3d, 0xd3, 0xe5, 0x71, 0xe3, 0x9e, 0xee, 0x4e, 0x77, 0x8d,
	0x15, 0x6b, 0x95, 0x55, 0xd8, 0x0b, 0x02, 0x04, 0xac, 0x04, 0x48, 0x9c, 0x39, 0x71, 0xe1, 0xbf,
	0x00, 0x29, 0x47, 0xa4, 0xe5, 0x80, 0x40, 0xf2, 0x82, 0xe1, 0x82, 0x04, 0x47, 0x2e, 0x7b, 0x42,
	0xf5, 0xaa, 0xba, 0x5d, 0x6d, 0x0f, 0x33, 0xe3, 0x5d, 0xc2, 0x21, 0x99, 0xae, 0x57, 0xef, 0xe3,
	0x57, 0xaf, 0x5e, 0xbd, 0xf7, 0xaa, 0x0c, 0x0b, 0x2d, 0xaf, 0xb5, 0x17, 0x78, 0x66, 0x6b, 0xb7,
	0xe6, 0xef, 0xb5, 0x6b, 0x21, 0x0d, 0xf6, 0x69, 0x20, 0x7f, 0xfc, 0x66, 0x2d, 0x64, 0x26, 0xeb,
	0x86, 0x55, 0x3f, 0xf0, 0x98, 0x47, 0xa6, 0x63, 0xde, 0xaa, 0x60, 0xa8, 0x46, 0x7c, 0xe5, 0x99,
	0xa4, 0x9a, 0x66, 0xd7, 0x76, 0xac, 0x9a, 0xed, 0xee, 0x78, 0x42, 0xb4, 0xfc, 0x7a, 0x72, 0xbe,
	0xed, 0x85, 0xa1, 0xed, 0xcb, 0x1f, 0xc9, 0x32, 0x9b, 0x64, 0xc1, 0x2f, 0xbf, 0x59, 0xb3, 0x4c,
	0x66, 0x4a, 0x8e, 0xb9, 0xde, 0x58, 0x11, 0x62, 0x02, 0x69, 0xf9, 0xcb, 0x27, 0x38, 0x99, 0x17,
	0x98, 0x6d, 0x5a, 0xa3, 0x6e, 0xdb, 0x76, 0xa3, 0x1f, 0xbf, 0x59, 0xeb, 0xec, 0xb7, 0x5a, 0x52,
	0xe2, 0x46, 0x6f, 0x09, 0xf9, 0xdb, 0x34, 0x43, 0x8a, 0x16, 0x68, 0x6f, 0xb0, 0x5d, 0x66, 0x3b,
	0x35, 0xc7, 0x6b, 0xf3, 0x7f, 0xbd, 0xc1, 0x22, 0x47, 0xd7, 0x0d, 0x68, 0xe8, 0x39, 0xfb, 0xd4,
	0x6a, 0x98, 0x96, 0x15, 0x48, 0xce, 0x8b, 0x94, 0xb5, 0xac, 0x5a, 0x60, 0xee, 0x30, 0xfc, 0xcf,
	0x6f, 0xe2, 0x8f, 0x9c, 0x9c, 0x6c, 0x7b, 0x6d, 0x0f, 0x3f, 0x6b, 0xfc, 0x4b, 0x52, 0x5f, 0x6d,
	0x7b, 0x5e, 0xdb, 0xa1, 0x35, 0xd3, 0xb7, 0x6b, 0xa6, 0xeb, 0x7a, 0xcc, 0x64, 0xb6, 0xe7, 0x46,
	0xab, 0xaf, 0xc8, 0x59, 0x1c, 0x35, 0xbb, 0x3b, 0x35, 0x66, 0x77, 0x68, 0xc8, 0xcc, 0x8e, 0x74,
	0xb5, 0x5e, 0x85, 0x97, 0x96, 0x69, 0xc0, 0xec, 0x1d, 0xbb, 0x65, 0x32, 0x1a, 0x1a, 0xf4, 0x71,
	0x97, 0x86, 0x8c, 0x5c, 0x80, 0x9c, 0xeb, 0x59, 0xb4, 0x61, 0x5b, 0x53, 0xda, 0xac, 0x36, 0x57,
	0x30, 0xb2, 0x7c, 0xb8, 0x66, 0xe9, 0xbf, 0xd3, 0x80, 0x28, 0x02, 0x2b, 0x94, 0x99, 0xb6, 0x13,
	0x92, 0xf7, 0x20, 0xcd, 0x0e, 0x7c, 0x8a, 0xcc, 0x63, 0x8b, 0x6f, 0x57, 0xff, 0x6b, 0x78, 0x54,
	0x4f, 0x0b, 0xab, 0xa4, 0xed, 0x03, 0x9f, 0x1a, 0xa8, 0x8a, 0x5c, 0x82, 0x12, 0x0d, 0x02, 0x2f,
	0x68, 0x74, 0x68, 0x18, 0x9a, 0x6d, 0x3a, 0x35, 0x82, 0x40, 0x46, 0x91, 0x78, 0x5f, 0xd0, 0x08,
	0x81, 0x34, 0x8f, 0x8a, 0xa9, 0xd4, 0xac, 0x36, 0x37, 0x6a, 0xe0, 0xb7, 0x7e, 0x09, 0xc6, 0x4f,
	0x68, 0x24, 0x59, 0x18, 0x59, 0x5e, 0x9a, 0x38, 0x47, 0xf2, 0x90, 0xde, 0x78, 0xb0, 0xb2, 0x3a,
	0xa1, 0xe9, 0x1e, 0x4c, 0x26, 0xd7, 0x1d, 0xfa, 0x9e, 0x1b, 0x52, 0xf2, 0x6d, 0x18, 0x6d, 0x29,
	0xf4, 0x29, 0x6d, 0x36, 0x35, 0x57, 0x5c, 0xbc, 0x71, 0xa6, 0x05, 0xd5, 0xd3, 0xcf, 0x0f, 0x2b,
	0xe7, 0x8c, 0x84, 0x22, 0x7d, 0x1e, 0xc6, 0xe4, 0xf4, 0x40, 0x1f, 0xff, 0x43, 0x83, 0xf1, 0x98,
	0x57, 0xe2, 0x7a, 0x94, 0x64, 0xce, 0xd4, 0x97, 0x8e, 0x0e, 0x2b, 0xd9, 0x0d, 0x2e, 0xb0, 0xf2,
	0xd9, 0x61, 0xe5, 0xcd, 0xb6, 0xcd, 0x76, 0xbb, 0xcd, 0x6a, 0xcb, 0xeb, 0xd4, 0x62, 0xa8, 0x56,
	0xb3, 0xd6, 0xf3, 0x20, 0x55, 0x85, 0x58, 0x64, 0x8f, 0x7c, 0x03, 0x72, 0x3c, 0x06, 0x69, 0x18,
	0xa2, 0x8f, 0x8b, 0x8b, 0x33, 0xca, 0x72, 0x79, 0xb4, 0x56, 0x1f, 0xc6, 0xd1, 0xba, 0x64, 0x59,
	0x81, 0x5c, 0x5f, 0x24, 0x44, 0x6e, 0x01, 0xe0, 0x29, 0x6f, 0xf0, 0x53, 0x8e, 0x5b, 0x51, 0x5c,
	0x7c, 0x59, 0x51, 0x81, 0x93, 0xd5, 0x35, 0x77, 0xc7, 0x93, 0x92, 0x05, 0xa4, 0x70, 0x82, 0x3e,
	0x06, 0xa3, 0x1c, 0x4d, 0xe4, 0x14, 0x7d, 0x13, 0x4a, 0x72, 0x2c, 0x17, 0xfe, 0x0e, 0x64, 0x38,
	0xcc, 0x68, 0x27, 0x2e, 0xf5, 0xd8, 0x09, 0x71, 0xdc, 0xb9, 0xd8, 0x16, 0x7e, 0x4a, 0x2b, 0x42,
	0x4e, 0xbf, 0x0a, 0x45, 0x3e, 0x35, 0xd0, 0xeb, 0xdf, 0x4f, 0x43, 0xc1, 0x30, 0x77, 0x18, 0xd7,
	0x41, 0xc9, 0x75, 0x80, 0x80, 0xfa, 0x8e, 0xdd, 0x32, 0x23, 0xce, 0x74, 0xbd, 0x74, 0x74, 0x58,
	0x29, 0x18, 0x82, 0xba, 0xb6, 0x62, 0x14, 0x24, 0xc3, 0x9a, 0x45, 0xbe, 0x0a, 0xb0, 0x6b, 0x06,
	0x56, 0x03, 0xf3, 0x82, 0x74, 0xe2, 0xf9, 0xaa, 0x38, 0xc2, 0xd5, 0x3b, 0x66, 0x60, 0xa1, 0xd2,
	0x68, 0xf5, 0xbb, 0x11, 0x81, 0x87, 0xaf, 0x43, 0x4d, 0x0b, 0x7d, 0x96, 0x36, 0xf0, 0x9b, 0x4c,
	0x42, 0x46, 0xa8, 0x49, 0x23, 0x3c, 0x31, 0x20, 0x53, 0x90, 0x33, 0x7d, 0xdf, 0xb1, 0xa9, 0x35,
	0x95, 0x41, 0xe6, 0x68, 0x48, 0xb6, 0x21, 0xef, 0x07, 0x5e, 0x1b, 0xb7, 0x2f, 0x8b, 0x3e, 0x5a,
	0xec, 0x13, 0xad, 0xf1, 0x0a, 0xab, 0x9b, 0x52, 0x68, 0xd5, 0x65, 0xc1, 0x81, 0x84, 0x16, 0x6b,
	0x2a, 0xff, 0x58, 0x83, 0x7c, 0xc4, 0xc1, 0x21, 0x75, 0x4c, 0xd6, 0xda, 0x15, 0x7e, 0x30, 0xc4,
	0x80, 0x83, 0x77, 0xe9, 0x13, 0x86, 0xcb, 0x4d, 0x1b, 0xf8, 0x7d, 0x0c, 0x3e, 0xa5, 0x82, 0x7f,
	0x05, 0xb2, 0xbe, 0xd9, 0x0d, 0xa9, 0x85, 0x6b, 0xca, 0x1b, 0x72, 0x44, 0xe6, 0x61, 0xc2, 0xa7,
	0xae, 0x65, 0xbb, 0xed, 0x46, 0xe8, 0x9a, 0x7e, 0xb8, 0xeb, 0x31, 0xb9, 0xba, 0x71, 0x49, 0xdf,
	0x92, 0xe4, 0xf2, 0x77, 0xa1, 0x94, 0x00, 0x4c, 0x26, 0x20, 0xb5, 0x47, 0x0f, 0x24, 0x22, 0xfe,
	0x49, 0x96, 0x21, 0xb3, 0x6f, 0x3a, 0xdd, 0xc8, 0xff, 0x37, 0xce, 0xe4, 0x05, 0x43, 0xc8, 0xde,
	0x1a, 0xb9, 0xa9, 0xe9, 0x9f, 0x68, 0x50, 0x32, 0x4c, 0xb7, 0x4d, 0x37, 0x03, 0xaf, 0xe9, 0xd0,
	0x4e, 0x48, 0x66, 0xa1, 0xd8, 0x75, 0xcd, 0x7d, 0xd3, 0x76, 0xcc, 0xa6, 0x23, 0xb2, 0x5c, 0xde,
	0x50, 0x49, 0xe4, 0x2d, 0xb8, 0xc0, 0x77, 0x8f, 0x06, 0x0d, 0xd7, 0x63, 0x0d, 0x87, 0x9a, 0x21,
	0x6d, 0xec, 0x7a, 0x8e, 0x45, 0x03, 0x84, 0x93, 0x37, 0x26, 0xc5, 0xf4, 0x86, 0xc7, 0xd6, 0xf9,
	0xe4, 0x1d, 0x9c, 0x23, 0x97, 0x61, 0xcc, 0xf5, 0x1a, 0x3c, 0x50, 0x1a, 0x62, 0x1e, 0x1d, 0x97,
	0x37, 0x46, 0x5d, 0x8f, 0x63, 0x5c, 0x47, 0x1a, 0x99, 0x83, 0xf1, 0xae, 0x6b, 0xd1, 0x40, 0x06,
	0x1c, 0x8b, 0x1d, 0x79, 0x92, 0x4c, 0xa6, 0x21, 0xef, 0x7a, 0xc2, 0x3c, 0x7a, 0x32, 0x6f, 0xe4,
	0x5c, 0x0f, 0x0d, 0xea, 0xff, 0xc6, 0xf8, 0x76, 0xdb, 0x94, 0x9f, 0x3b, 0xf2, 0x0e, 0xa4, 0x43,
	0xdf, 0x74, 0x71, 0x29, 0xc5, 0xc5, 0x2b, 0x7d, 0x7c, 0xb5, 0x19, 0x50, 0xc6, 0x0e, 0xb6, 0x7c,
	0xd3, 0x95, 0x41, 0x82, 0x82, 0x64, 0x0d, 0x00, 0x61, 0xab, 0x21, 0x7f, 0x79, 0x18, 0x97, 0x47,
	0xa7, 0x20, 0x88, 0xcf, 0xda, 0x8a, 0x1a, 0xf1, 0xc5, 0xc5, 0x39, 0x55, 0x8b, 0x28, 0xba, 0x55,
	0xa5, 0xf8, 0x56, 0xe3, 0x45, 0x44, 0xe7, 0x5c, 0x04, 0x59, 0x07, 0xc6, 0x42, 0xaf, 0x1b, 0xb4,
	0x68, 0x23, 0x3a, 0xdf, 0x19, 0x4c, 0x94, 0xb7, 0x8f, 0x0e, 0x2b, 0xa3, 0x5b, 0x38, 0xf3, 0xc5,
	0xd2, 0xe5, 0x68, 0x78, 0xac, 0xc4, 0x22, 0x8f, 0x61, 0x5c, 0x9a, 0xe3, 0xd8, 0xd0, 0x5e, 0x16,
	0xed, 0xad, 0x1d, 0x1d, 0x56, 0x4a, 0xc2, 0xde, 0x16, 0x9f, 0x41, 0x83, 0x5f, 0x39, 0x93, 0x41,
	0x29, 0x67, 0x94, 0x42, 0x45, 0x8d, 0x75, 0xba, 0x22, 0xe6, 0x7a, 0x54, 0xc4, 0x65, 0x28, 0xc9,
	0xe8, 0xb3, 0x39, 0xb0, 0x83, 0xa9, 0x3c, 0xe6, 0x84, 0x29, 0xc5, 0xa9, 0x91, 0x19, 0x8c, 0x8b,
	0xa8, 0x58, 0xa1, 0xd0, 0x1d, 0x21, 0x43, 0xee, 0x62, 0x4e, 0xc1, 0xd8, 0x9f, 0x2a, 0x9c, 0xde,
	0x94, 0x53, 0x5b, 0xab, 0x9c, 0x15, 0x25, 0x93, 0xe0, 0x58, 0xff, 0x51, 0x74, 0x9a, 0x06, 0x16,
	0x3e, 0x62, 0x42, 0x21, 0xe0, 0x9c, 0x0d, 0xdb, 0xe2, 0xa5, 0x28, 0x35, 0x97, 0xaa, 0xaf, 0x1c,
	0x1d, 0x56, 0xf2, 0x62, 0xc7, 0x57, 0xc2, 0x33, 0x3b, 0x52, 0x0a, 0x1a, 0x79, 0x54, 0xbb, 0x66,
	0x85, 0xfa, 0x36, 0x8c, 0x45, 0x60, 0x64, 0x81, 0xa9, 0x43, 0x16, 0x67, 0xa3, 0x0a, 0x73, 0x79,
	0xd0, 0x4a, 0x95, 0xd0, 0x93, 0x92, 0xfa, 0x1c, 0x94, 0x6e, 0x63, 0x03, 0x3b, 0xb0, 0xca, 0xe8,
	0x30, 0x7a, 0x77, 0xeb, 0xc1, 0x46, 0x6c, 0x3d, 0x6a, 0x60, 0x34, 0xa5, 0x81, 0xf9, 0x95, 0x06,
	0xc5, 0x75, 0xaf, 0x3d, 0xd8, 0x5f, 0x93, 0x90, 0x71, 0xe8, 0x3e, 0x75, 0x64, 0x6b, 0x24, 0x06,
	0xe4, 0x35, 0x80, 0x90, 0x99, 0x01, 0x6b, 0xf0, 0x5e, 0x4f, 0x26, 0xe2, 0x02, 0x52, 0xb6, 0xed,
	0x0e, 0xe5, 0x29, 0x82, 0xba, 0x96, 0x98, 0x14, 0x25, 0x26, 0x47, 0x5d, 0x0b, 0xa7, 0x26, 0x20,
	0xd5, 0x31, 0x9f, 0xe0, 0xb9, 0x29, 0x18, 0xfc, 0x93, 0x97, 0x1d, 0xdf, 0x64, 0x8c, 0x06, 0x2e,
	0x46, 0x77, 0xc1, 0x88, 0x86, 0xfa, 0x03, 0x20, 0xeb, 0x5e, 0x9b, 0xe7, 0x62, 0x5b, 0x71, 0xe6,
	0xd7, 0x20, 0x47, 0x05, 0x49, 0x7a, 0x73, 0xfa, 0x64, 0x2b, 0xc1, 0xdb, 0x62, 0xb5, 0xe4, 0x44,
	0xfc, 0xbc, 0x13, 0x5d, 0xf7, 0xda, 0xdf, 0xb4, 0x1d, 0x1a, 0xae, 0xdb, 0x21, 0x1b, 0xe8, 0xc9,
	0x4d, 0x98, 0x4c, 0xf2, 0x4b, 0x08, 0x37, 0x21, 0xb3, 0xc3, 0x89, 0x12, 0xc0, 0xab, 0xbd, 0x00,
	0x70, 0x29, 0x35, 0x83, 0xa0, 0x80, 0xfe, 0x36, 0x8c, 0x49, 0x8d, 0x03, 0x3d, 0x4f, 0x20, 0xcd,
	0x65, 0xa4, 0xe3, 0xf1, 0x9b, 0x07, 0xc1, 0x16, 0x33, 0x5b, 0x7b, 0x83, 0x1b, 0xbc, 0x79, 0x18,
	0xbb, 0x4f, 0x59, 0x60, 0xb7, 0x06, 0xb3, 0xfe, 0x06, 0x4f, 0xcf, 0x0e, 0xc3, 0xc8, 0xe3, 0xa9,
	0xe7, 0x85, 0x76, 0x82, 0xef, 0x42, 0x06, 0x23, 0x7a, 0xa8, 0x7c, 0x7e, 0x22, 0x0b, 0xa3, 0xa0,
	0xbe, 0xc0, 0xcf, 0x97, 0x84, 0xbb, 0xca, 0xf3, 0x12, 0x0f, 0xa1, 0x28, 0x5f, 0x89, 0xa5, 0x45,
	0x43, 0xfd, 0xd9, 0x08, 0x8c, 0xc7, 0xcc, 0xa2, 0x75, 0x23, 0xef, 0x43, 0x3e, 0x4a, 0x01, 0xc8,
	0x9e, 0xaa, 0x2f, 0x1f, 0x1d, 0x56, 0x72, 0xf2, 0x20, 0x7f, 0xee, 0x04, 0x90, 0x93, 0x09, 0x80,
	0xdc, 0x86, 0x2c, 0xa6, 0x4b, 0x91, 0x5f, 0x8a, 0x8b, 0xf3, 0x03, 0x4a, 0xd6, 0xf1, 0x42, 0xa2,
	0x23, 0x2f, 0xc4, 0x79, 0xd1, 0x12, 0x7d, 0x69, 0x0a, 0xf5, 0xcc, 0x0d, 0xa3, 0x87, 0x7b, 0x3b,
	0xd9, 0x9c, 0x76, 0x61, 0x82, 0xcf, 0xae, 0xd0, 0x66, 0xb7, 0x1d, 0xc5, 0x42, 0x22, 0x0b, 0x6a,
	0x2f, 0x24, 0x0b, 0xfe, 0x61, 0x04, 0xce, 0x2b, 0x76, 0xe5, 0xc9, 0xf9, 0x89, 0x76, 0x22, 0x15,
	0xde, 0x1c, 0xb0, 0xa8, 0x84, 0xb8, 0x30, 0x23, 0xdb, 0xc9, 0xaf, 0xf3, 0x45, 0x7e, 0xf4, 0xe9,
	0xe7, 0x04, 0x2a, 0x51, 0xfc, 0xcf, 0x36, 0xab, 0x4c, 0xa1, 0xa8, 0xa0, 0x53, 0x7b, 0xc7, 0x94,
	0xe8, 0x1d, 0xdf, 0x4d, 0xf6, 0x8e, 0x0b, 0xc3, 0x18, 0x12, 0x11, 0xab, 0x36, 0x8e, 0xff, 0xd2,
	0xa0, 0xb8, 0xd4, 0x62, 0xf6, 0x3e, 0x7d, 0xaf, 0x4b, 0x85, 0x9d, 0xf0, 0xb1, 0x23, 0xc3, 0x9e,
	0x7f, 0x92, 0x5b, 0xd8, 0xea, 0x04, 0x4c, 0xda, 0x29, 0x57, 0xc5, 0xfd, 0xbc, 0x1a, 0xdd, 0xcf,
	0xab, 0xdb, 0xd1, 0xfd, 0xbc, 0x9e, 0xe7, 0x2b, 0xf8, 0xf8, 0xd3, 0x8a, 0x66, 0x08, 0x11, 0x72,
	0x05, 0xc6, 0xec, 0xb0, 0x61, 0xd9, 0x21, 0x0b, 0xec, 0x66, 0x97, 0x37, 0x81, 0xa2, 0x57, 0x2c,
	0xd9, 0xe1, 0xca, 0x31, 0x91, 0xd4, 0x21, 0xe3, 0xef, 0xf2, 0xfe, 0x2f, 0x8d, 0x77, 0xf1, 0xeb,
	0x7d, 0x96, 0xa2, 0x60, 0xad, 0x6e, 0x72, 0x19, 0x43, 0x88, 0xea, 0x57, 0x20, 0x83, 0x63, 0x52,
	0x82, 0xc2, 0xa6, 0xb1, 0xba, 0xb9, 0x64, 0xac, 0x6d, 0xdc, 0x9e, 0x38, 0xc7, 0x87, 0xab, 0xdf,
	0x59, 0x5d, 0x7e, 0xb8, 0xcd, 0x87, 0x9a, 0xfe, 0x06, 0xbc, 0xc4, 0x53, 0xef, 0x16, 0x0d, 0x43,
	0xdb, 0x73, 0xe3, 0x64, 0x56, 0x86, 0x7c, 0x37, 0xa4, 0x81, 0x6b, 0x76, 0xa2, 0x23, 0x1f, 0x8f,
	0xf5, 0xdf, 0xa6, 0x20, 0x27, 0xf9, 0x5f, 0x68, 0x26, 0x53, 0x31, 0x8c, 0x24, 0x31, 0x70, 0x47,
	0xb6, 0x1c, 0x9b, 0xba, 0xac, 0x11, 0x5d, 0x7b, 0x45, 0x91, 0x2c, 0x09, 0xea, 0x92, 0xbc, 0xd6,
	0xce, 0xc3, 0x04, 0xde, 0xb1, 0x5a, 0xf8, 0xa2, 0xd2, 0x40, 0x55, 0xa2, 0x60, 0x8e, 0x2b, 0xf4,
	0x0d, 0xae, 0x71, 0x0b, 0xc6, 0x4c, 0xf4, 0x65, 0xe3, 0x71, 0x97, 0x62, 0xf5, 0xcb, 0x60, 0xc0,
	0x5e, 0x1d, 0xce, 0xf9, 0x32, 0x5a, 0x4b, 0x66, 0x4c, 0xb2, 0x69, 0x78, 0x1c, 0x2b, 0xd9, 0xb3,
	0xc7, 0xca, 0xfb, 0x50, 0xd8, 0xdb, 0x6f, 0xb0, 0x27, 0x2e, 0x77, 0x2e, 0x6f, 0x13, 0x47, 0xeb,
	0xf5, 0x3f, 0x0d, 0xeb, 0x52, 0xf1, 0x40, 0xd5, 0xb5, 0xad, 0xea, 0xc3, 0x87, 0x6b, 0x3c, 0xf5,
	0xe4, 0xee, 0xed, 0x6f, 0x3f, 0x71, 0x79, 0x1a, 0xdd, 0xc3, 0x0f, 0x4b, 0xff, 0x81, 0x06, 0xe7,
	0xd5, 0xad, 0x17, 0xa9, 0xfe, 0x45, 0x6e, 0xa8, 0x52, 0x46, 0x46, 0x92, 0x65, 0xe4, 0xd7, 0x1a,
	0x4c, 0x26, 0xc3, 0x50, 0xe6, 0xb3, 0x15, 0xc8, 0x87, 0x92, 0x26, 0x13, 0x9a, 0xde, 0x67, 0x3f,
	0xa4, 0x78, 0xd4, 0xbf, 0x46, 0x92, 0xe4, 0xee, 0x89, 0x24, 0xd4, 0xef, 0x40, 0x9d, 0x72, 0x49,
	0x32, 0x0f, 0xe9, 0x7f, 0xd6, 0x60, 0x82, 0xdf, 0xa4, 0x78, 0xea, 0x88, 0x8f, 0xcb, 0xa5, 0x13,
	0xb5, 0xbf, 0x0e, 0xc7, 0x5e, 0x8b, 0x97, 0x6f, 0x80, 0x68, 0xe1, 0x1a, 0x3c, 0x71, 0x8d, 0xe0,
	0x86, 0xbe, 0xf5, 0xd9, 0x61, 0xe5, 0x8d, 0xb3, 0xe5, 0xd7, 0x7b, 0xf4, 0xc0, 0xc8, 0xa3, 0x9e,
	0x7b, 0xf4, 0x80, 0x6c, 0xf0, 0x66, 0xcd, 0x42, 0x8d, 0xa9, 0x2f, 0xa2, 0x31, 0x4b, 0x5d, 0xeb,
	0x1e, 0x3d, 0xc0, 0xa0, 0x50, 0x56, 0x27, 0x77, 0x61, 0x0b, 0x8a, 0xcc, 0x63, 0xa6, 0x83, 0x37,
	0xc5, 0x50, 0x5e, 0x38, 0xaf, 0xf7, 0xb8, 0xe3, 0x89, 0xb7, 0xd8, 0x6a, 0xf4, 0x24, 0x5b, 0xbd,
	0xff, 0xad, 0xe5, 0x65, 0x54, 0x25, 0x9d, 0x08, 0xa8, 0x06, 0x29, 0xa4, 0x02, 0x45, 0x51, 0x23,
	0x5b, 0x5e, 0xd7, 0x15, 0xd9, 0x34, 0x63, 0x00, 0x92, 0x96, 0x39, 0x45, 0xaf, 0x03, 0x1c, 0x5f,
	0x5c, 0xc9, 0x45, 0xd5, 0x7b, 0x32, 0x25, 0xc5, 0x6e, 0xb8, 0x70, 0xec, 0x06, 0x11, 0x59, 0x72,
	0x3d, 0x8b, 0xff, 0x1c, 0x87, 0xac, 0x6c, 0x4b, 0x7e, 0xa9, 0xc1, 0xa8, 0xfa, 0x5e, 0x48, 0xaa,
	0xc3, 0xbd, 0x08, 0x46, 0x9b, 0x5c, 0xae, 0x0d, 0xcd, 0x2f, 0xdc, 0xa6, 0x5f, 0xfb, 0xe8, 0x93,
	0xbf, 0xff, 0x6c, 0xe4, 0x75, 0x52, 0xa9, 0x35, 0xe4, 0xb3, 0xb6, 0xfa, 0x9c, 0x58, 0xfb, 0x40,
	0x86, 0xcc, 0x53, 0xf2, 0x53, 0x0d, 0x72, 0xd1, 0x33, 0x6c, 0xbf, 0x02, 0x99, 0x7c, 0x7d, 0x2c,
	0x2f, 0x0c, 0xc3, 0x2a, 0xb1, 0xdc, 0x40, 0x2c, 0xd7, 0x48, 0x39, 0xc6, 0x62, 0x09, 0x8e, 0x63,
	0x18, 0x8f, 0x0a, 0x24, 0x57, 0xdb, 0xa5, 0xa6, 0xc3, 0x76, 0x49, 0x00, 0x19, 0x7c, 0xc3, 0x23,
	0xd7, 0xfa, 0xd8, 0x50, 0x5f, 0xfd, 0xca, 0x73, 0x83, 0x19, 0x25, 0x94, 0x57, 0x10, 0xca, 0x04,
	0x19, 0x8b, 0xa1, 0x60, 0x23, 0x45, 0xba, 0x90, 0xc6, 0xee, 0xf8, 0xea, 0x00, 0x4d, 0x91, 0xc5,
	0x61, 0xde, 0x11, 0xf5, 0x59, 0x34, 0x56, 0x26, 0x53, 0x49, 0x63, 0x8a, 0xf3, 0x9f, 0x8a, 0x37,
	0x43, 0x6c, 0x84, 0xc8, 0x97, 0x86, 0x6b, 0x97, 0x04, 0x80, 0xeb, 0x67, 0xe9, 0xad, 0xf4, 0x97,
	0x11, 0xc9, 0x38, 0x29, 0xc5, 0x48, 0x02, 0x73, 0x87, 0x91, 0x67, 0x1a, 0x64, 0x45, 0x63, 0x43,
	0x06, 0x5e, 0xd0, 0x63, 0x67, 0xcf, 0x0f, 0xc1, 0x29, 0xcd, 0xbe, 0x8e, 0x66, 0x2f, 0x92, 0x69,
	0xc5, 0x2c, 0x67, 0x50, 0x3c, 0x10, 0x42, 0x56, 0x5c, 0x7d, 0xfb, 0x22, 0x48, 0xdc, 0x8e, 0xcb,
	0xea, 0x9d, 0x4c, 0xfe, 0xe1, 0x87, 0xdf, 0x24, 0xa4, 0xd7, 0x4f, 0x1b, 0x95, 0x7f, 0x23, 0x3a,
	0x36, 0xfa, 0x43, 0x0d, 0x46, 0xd5, 0x5c, 0xdb, 0xf7, 0x38, 0xf6, 0x68, 0x51, 0xfa, 0x1e, 0xc7,
	0x5e, 0xb5, 0x44, 0x9f, 0x46, 0x50, 0x2f, 0x91, 0xf3, 0x31, 0xa8, 0xb8, 0x40, 0xfc, 0x42, 0xd6,
	0xc2, 0x75, 0xaf, 0x65, 0x3a, 0xff, 0x3f, 0x44, 0x15, 0x44, 0x34, 0x4d, 0x2e, 0xc4, 0x88, 0x1c,
	0x0e, 0xa0, 0x11, 0xe3, 0x7a, 0xa6, 0x41, 0x21, 0x4e, 0xc7, 0x7d, 0x83, 0xf3, 0x64, 0x49, 0xea,
	0x1b, 0x9c, 0xa7, 0x32, 0xbc, 0x3e, 0x85, 0x48, 0x88, 0x7e, 0x1c, 0x9c, 0xa1, 0x6f, 0xba, 0xb7,
	0xb4, 0x05, 0xf2, 0x21, 0x26, 0xd0, 0xd6, 0x5e, 0xff, 0xf0, 0x4c, 0xdc, 0x9a, 0xcb, 0xfd, 0x92,
	0x86, 0xfa, 0x74, 0xd2, 0x23, 0x4e, 0x42, 0x54, 0xa4, 0xc4, 0xc9, 0xf7, 0x34, 0xc8, 0xc9, 0x9b,
	0x76, 0xdf, 0xdc, 0x98, 0xbc, 0x8d, 0x0f, 0x0f, 0x41, 0x47, 0x08, 0xaf, 0x2a, 0x89, 0xb1, 0x23,
	0x34, 0x29, 0x18, 0x7e, 0xce, 0x63, 0x55, 0x79, 0xa8, 0xe8, 0x1f, 0x19, 0xa7, 0x5f, 0x40, 0xfa,
	0x47, 0x46, 0x8f, 0x17, 0x10, 0xfd, 0x12, 0xa2, 0x7a, 0x8d, 0x5c, 0x54, 0x22, 0xa3, 0x8d, 0x4f,
	0x1c, 0x27, 0xca, 0x86, 0x94, 0xee, 0xeb, 0x9a, 0xe4, 0x8b, 0x48, 0xf9, 0x46, 0x7f, 0xd6, 0x13,
	0xef, 0x41, 0xfa, 0x02, 0x42, 0xb9, 0x4c, 0xf4, 0x3e, 0x50, 0x6a, 0x1f, 0x70, 0xc2, 0x53, 0xf2,
	0x21, 0xa4, 0xd7, 0xbd, 0x76, 0xd8, 0x37, 0x85, 0x2b, 0xcf, 0x62, 0x67, 0x85, 0xd2, 0xeb, 0xbc,
	0xb4, 0x15, 0x18, 0x75, 0xfd, 0xf9, 0x5f, 0x67, 0xce, 0x3d, 0x3f, 0x9a, 0xd1, 0x7e, 0x7f, 0x34,
	0xa3, 0xfd, 0xf1, 0x68, 0x46, 0xfb, 0xcb, 0xd1, 0x8c, 0xf6, 0xf1, 0xdf, 0x66, 0xce, 0x3d, 0xca,
	0x47, 0x7a, 0x9b, 0x59, 0x6c, 0xbe, 0xdf, 0xfc, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x51, 0x13,
	0x0c, 0xba, 0x2c, 0x1f, 0x00, 0x00,
}
