// Code generated by protoc-gen-gogo.
// source: cockroach/pkg/roachpb/data.proto
// DO NOT EDIT!

package roachpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_storage_engine_enginepb "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// ValueType defines a set of type constants placed in the "tag" field of Value
// messages. These are defined as a protocol buffer enumeration so that they
// can be used portably between our Go and C code. The tags are used by the
// RocksDB Merge Operator to perform specialized merges.
type ValueType int32

const (
	// This is a subset of the SQL column type values, representing the underlying
	// storage for various types. The DELIMITED_foo entries each represent a foo
	// variant that self-delimits length.
	ValueType_UNKNOWN           ValueType = 0
	ValueType_NULL              ValueType = 7
	ValueType_INT               ValueType = 1
	ValueType_FLOAT             ValueType = 2
	ValueType_BYTES             ValueType = 3
	ValueType_DELIMITED_BYTES   ValueType = 8
	ValueType_TIME              ValueType = 4
	ValueType_DECIMAL           ValueType = 5
	ValueType_DELIMITED_DECIMAL ValueType = 9
	ValueType_DURATION          ValueType = 6
	// TUPLE represents a DTuple, encoded as repeated pairs of varint field number
	// followed by a value encoded Datum.
	ValueType_TUPLE ValueType = 10
	// TIMESERIES is applied to values which contain InternalTimeSeriesData.
	ValueType_TIMESERIES ValueType = 100
)

var ValueType_name = map[int32]string{
	0:   "UNKNOWN",
	7:   "NULL",
	1:   "INT",
	2:   "FLOAT",
	3:   "BYTES",
	8:   "DELIMITED_BYTES",
	4:   "TIME",
	5:   "DECIMAL",
	9:   "DELIMITED_DECIMAL",
	6:   "DURATION",
	10:  "TUPLE",
	100: "TIMESERIES",
}
var ValueType_value = map[string]int32{
	"UNKNOWN":           0,
	"NULL":              7,
	"INT":               1,
	"FLOAT":             2,
	"BYTES":             3,
	"DELIMITED_BYTES":   8,
	"TIME":              4,
	"DECIMAL":           5,
	"DELIMITED_DECIMAL": 9,
	"DURATION":          6,
	"TUPLE":             10,
	"TIMESERIES":        100,
}

func (x ValueType) Enum() *ValueType {
	p := new(ValueType)
	*p = x
	return p
}
func (x ValueType) String() string {
	return proto.EnumName(ValueType_name, int32(x))
}
func (x *ValueType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ValueType_value, data, "ValueType")
	if err != nil {
		return err
	}
	*x = ValueType(value)
	return nil
}
func (ValueType) EnumDescriptor() ([]byte, []int) { return fileDescriptorData, []int{0} }

// ReplicaChangeType is a parameter of ChangeReplicasTrigger.
type ReplicaChangeType int32

const (
	ADD_REPLICA    ReplicaChangeType = 0
	REMOVE_REPLICA ReplicaChangeType = 1
)

var ReplicaChangeType_name = map[int32]string{
	0: "ADD_REPLICA",
	1: "REMOVE_REPLICA",
}
var ReplicaChangeType_value = map[string]int32{
	"ADD_REPLICA":    0,
	"REMOVE_REPLICA": 1,
}

func (x ReplicaChangeType) Enum() *ReplicaChangeType {
	p := new(ReplicaChangeType)
	*p = x
	return p
}
func (x ReplicaChangeType) String() string {
	return proto.EnumName(ReplicaChangeType_name, int32(x))
}
func (x *ReplicaChangeType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ReplicaChangeType_value, data, "ReplicaChangeType")
	if err != nil {
		return err
	}
	*x = ReplicaChangeType(value)
	return nil
}
func (ReplicaChangeType) EnumDescriptor() ([]byte, []int) { return fileDescriptorData, []int{1} }

// TransactionStatus specifies possible states for a transaction.
type TransactionStatus int32

const (
	// PENDING is the default state for a new transaction. Transactions
	// move from PENDING to one of COMMITTED or ABORTED. Mutations made
	// as part of a PENDING transactions are recorded as "intents" in
	// the underlying MVCC model.
	PENDING TransactionStatus = 0
	// COMMITTED is the state for a transaction which has been
	// committed. Mutations made as part of a transaction which is moved
	// into COMMITTED state become durable and visible to other
	// transactions, moving from "intents" to permanent versioned
	// values.
	COMMITTED TransactionStatus = 1
	// ABORTED is the state for a transaction which has been aborted.
	// Mutations made as part of a transaction which is moved into
	// ABORTED state are deleted and are never made visible to other
	// transactions.
	ABORTED TransactionStatus = 2
)

var TransactionStatus_name = map[int32]string{
	0: "PENDING",
	1: "COMMITTED",
	2: "ABORTED",
}
var TransactionStatus_value = map[string]int32{
	"PENDING":   0,
	"COMMITTED": 1,
	"ABORTED":   2,
}

func (x TransactionStatus) Enum() *TransactionStatus {
	p := new(TransactionStatus)
	*p = x
	return p
}
func (x TransactionStatus) String() string {
	return proto.EnumName(TransactionStatus_name, int32(x))
}
func (x *TransactionStatus) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TransactionStatus_value, data, "TransactionStatus")
	if err != nil {
		return err
	}
	*x = TransactionStatus(value)
	return nil
}
func (TransactionStatus) EnumDescriptor() ([]byte, []int) { return fileDescriptorData, []int{2} }

// Span is supplied with every storage node request.
type Span struct {
	// The key for request. If the request operates on a range, this
	// represents the starting key for the range.
	Key Key `protobuf:"bytes,3,opt,name=key,casttype=Key" json:"key,omitempty"`
	// The end key is empty if the request spans only a single key. Otherwise,
	// it must order strictly after Key. In such a case, the header indicates
	// that the operation takes place on the key range from Key to EndKey,
	// including Key and excluding EndKey.
	EndKey Key `protobuf:"bytes,4,opt,name=end_key,json=endKey,casttype=Key" json:"end_key,omitempty"`
}

func (m *Span) Reset()                    { *m = Span{} }
func (*Span) ProtoMessage()               {}
func (*Span) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{0} }

// Value specifies the value at a key. Multiple values at the same key are
// supported based on timestamp. The data stored within a value is typed
// (ValueType) and custom encoded into the raw_bytes field. A custom encoding
// is used instead of separate proto fields to avoid proto overhead and to
// avoid unnecessary encoding and decoding as the value gets read from disk and
// passed through the network. The format is:
//
//   <4-byte-checksum><1-byte-tag><encoded-data>
//
// A CRC-32-IEEE checksum is computed from the associated key, tag and encoded
// data, in that order.
//
// TODO(peter): Is a 4-byte checksum overkill when most (all?) values
// will be less than 64KB?
type Value struct {
	// raw_bytes contains the encoded value and checksum.
	RawBytes []byte `protobuf:"bytes,1,opt,name=raw_bytes,json=rawBytes" json:"raw_bytes,omitempty"`
	// Timestamp of value.
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp"`
}

func (m *Value) Reset()                    { *m = Value{} }
func (m *Value) String() string            { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()               {}
func (*Value) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{1} }

// KeyValue is a pair of Key and Value for returned Key/Value pairs
// from ScanRequest/ScanResponse. It embeds a Key and a Value.
type KeyValue struct {
	Key   Key   `protobuf:"bytes,1,opt,name=key,casttype=Key" json:"key,omitempty"`
	Value Value `protobuf:"bytes,2,opt,name=value" json:"value"`
}

func (m *KeyValue) Reset()                    { *m = KeyValue{} }
func (m *KeyValue) String() string            { return proto.CompactTextString(m) }
func (*KeyValue) ProtoMessage()               {}
func (*KeyValue) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{2} }

// A StoreIdent uniquely identifies a store in the cluster. The
// StoreIdent is written to the underlying storage engine at a
// store-reserved system key (KeyLocalIdent).
type StoreIdent struct {
	ClusterID github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"cluster_id"`
	NodeID    NodeID                                              `protobuf:"varint,2,opt,name=node_id,json=nodeId,casttype=NodeID" json:"node_id"`
	StoreID   StoreID                                             `protobuf:"varint,3,opt,name=store_id,json=storeId,casttype=StoreID" json:"store_id"`
}

func (m *StoreIdent) Reset()                    { *m = StoreIdent{} }
func (m *StoreIdent) String() string            { return proto.CompactTextString(m) }
func (*StoreIdent) ProtoMessage()               {}
func (*StoreIdent) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{3} }

// A SplitTrigger is run after a successful commit of an AdminSplit
// command. It provides the updated left hand side of the split's
// range descriptor (left_desc) and the new range descriptor covering
// the right hand side of the split (right_desc). This information
// allows the final bookkeeping for the split to be completed and the
// new range put into operation.
type SplitTrigger struct {
	LeftDesc  RangeDescriptor `protobuf:"bytes,1,opt,name=left_desc,json=leftDesc" json:"left_desc"`
	RightDesc RangeDescriptor `protobuf:"bytes,2,opt,name=right_desc,json=rightDesc" json:"right_desc"`
}

func (m *SplitTrigger) Reset()                    { *m = SplitTrigger{} }
func (m *SplitTrigger) String() string            { return proto.CompactTextString(m) }
func (*SplitTrigger) ProtoMessage()               {}
func (*SplitTrigger) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{4} }

// A MergeTrigger is run after a successful commit of an AdminMerge
// command. It provides the updated left hand side of the split's
// range descriptor (left_desc) that now encompasses what was
// originally both ranges and the soon-to-be-invalid range descriptor
// that used to cover the subsumed, right hand side of the merge
// (right_desc). This information allows the final bookkeeping for the
// merge to be completed and put into operation.
type MergeTrigger struct {
	LeftDesc  RangeDescriptor `protobuf:"bytes,1,opt,name=left_desc,json=leftDesc" json:"left_desc"`
	RightDesc RangeDescriptor `protobuf:"bytes,2,opt,name=right_desc,json=rightDesc" json:"right_desc"`
}

func (m *MergeTrigger) Reset()                    { *m = MergeTrigger{} }
func (m *MergeTrigger) String() string            { return proto.CompactTextString(m) }
func (*MergeTrigger) ProtoMessage()               {}
func (*MergeTrigger) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{5} }

type ChangeReplicasTrigger struct {
	ChangeType ReplicaChangeType `protobuf:"varint,1,opt,name=change_type,json=changeType,enum=cockroach.roachpb.ReplicaChangeType" json:"change_type"`
	// The replica being modified.
	Replica ReplicaDescriptor `protobuf:"bytes,2,opt,name=replica" json:"replica"`
	// The new replica list with this change applied.
	UpdatedReplicas []ReplicaDescriptor `protobuf:"bytes,3,rep,name=updated_replicas,json=updatedReplicas" json:"updated_replicas"`
	NextReplicaID   ReplicaID           `protobuf:"varint,4,opt,name=next_replica_id,json=nextReplicaId,casttype=ReplicaID" json:"next_replica_id"`
}

func (m *ChangeReplicasTrigger) Reset()                    { *m = ChangeReplicasTrigger{} }
func (m *ChangeReplicasTrigger) String() string            { return proto.CompactTextString(m) }
func (*ChangeReplicasTrigger) ProtoMessage()               {}
func (*ChangeReplicasTrigger) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{6} }

// ModifiedSpanTrigger indicates that a specific span has been modified.
// This can be used to trigger scan-and-gossip for the given span.
type ModifiedSpanTrigger struct {
	SystemConfigSpan bool `protobuf:"varint,1,opt,name=system_config_span,json=systemConfigSpan" json:"system_config_span"`
	// node_liveness_span is set to indicate that node liveness records
	// need re-gossiping after modification or range lease updates. The
	// span is set to a single key when nodes update their liveness records
	// with heartbeats to extend the expiration timestamp. Changes to the
	// range lease for the range containing node liveness triggers re-gossip
	// of the entire node liveness key range.
	NodeLivenessSpan *Span `protobuf:"bytes,2,opt,name=node_liveness_span,json=nodeLivenessSpan" json:"node_liveness_span,omitempty"`
}

func (m *ModifiedSpanTrigger) Reset()                    { *m = ModifiedSpanTrigger{} }
func (m *ModifiedSpanTrigger) String() string            { return proto.CompactTextString(m) }
func (*ModifiedSpanTrigger) ProtoMessage()               {}
func (*ModifiedSpanTrigger) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{7} }

// InternalCommitTrigger encapsulates all of the internal-only commit triggers.
// Only one may be set.
type InternalCommitTrigger struct {
	SplitTrigger          *SplitTrigger          `protobuf:"bytes,1,opt,name=split_trigger,json=splitTrigger" json:"split_trigger,omitempty"`
	MergeTrigger          *MergeTrigger          `protobuf:"bytes,2,opt,name=merge_trigger,json=mergeTrigger" json:"merge_trigger,omitempty"`
	ChangeReplicasTrigger *ChangeReplicasTrigger `protobuf:"bytes,3,opt,name=change_replicas_trigger,json=changeReplicasTrigger" json:"change_replicas_trigger,omitempty"`
	ModifiedSpanTrigger   *ModifiedSpanTrigger   `protobuf:"bytes,4,opt,name=modified_span_trigger,json=modifiedSpanTrigger" json:"modified_span_trigger,omitempty"`
}

func (m *InternalCommitTrigger) Reset()                    { *m = InternalCommitTrigger{} }
func (m *InternalCommitTrigger) String() string            { return proto.CompactTextString(m) }
func (*InternalCommitTrigger) ProtoMessage()               {}
func (*InternalCommitTrigger) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{8} }

func (m *InternalCommitTrigger) GetSplitTrigger() *SplitTrigger {
	if m != nil {
		return m.SplitTrigger
	}
	return nil
}

func (m *InternalCommitTrigger) GetMergeTrigger() *MergeTrigger {
	if m != nil {
		return m.MergeTrigger
	}
	return nil
}

func (m *InternalCommitTrigger) GetChangeReplicasTrigger() *ChangeReplicasTrigger {
	if m != nil {
		return m.ChangeReplicasTrigger
	}
	return nil
}

func (m *InternalCommitTrigger) GetModifiedSpanTrigger() *ModifiedSpanTrigger {
	if m != nil {
		return m.ModifiedSpanTrigger
	}
	return nil
}

type ObservedTimestamp struct {
	NodeID    NodeID                       `protobuf:"varint,1,opt,name=node_id,json=nodeId,casttype=NodeID" json:"node_id"`
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp"`
}

func (m *ObservedTimestamp) Reset()                    { *m = ObservedTimestamp{} }
func (m *ObservedTimestamp) String() string            { return proto.CompactTextString(m) }
func (*ObservedTimestamp) ProtoMessage()               {}
func (*ObservedTimestamp) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{9} }

// A Transaction is a unit of work performed on the database.
// Cockroach transactions support two isolation levels: snapshot
// isolation and serializable snapshot isolation. Each Cockroach
// transaction is assigned a random priority. This priority will be
// used to decide whether a transaction will be aborted during
// contention.
//
// If you add fields to Transaction you'll need to update
// Transaction.Clone. Failure to do so will result in test failures.
type Transaction struct {
	// The transaction metadata. These are persisted with every intent.
	cockroach_storage_engine_enginepb.TxnMeta `protobuf:"bytes,1,opt,name=meta,embedded=meta" json:"meta"`
	// A free-text identifier for debug purposes.
	Name          string                       `protobuf:"bytes,2,opt,name=name" json:"name"`
	Status        TransactionStatus            `protobuf:"varint,4,opt,name=status,enum=cockroach.roachpb.TransactionStatus" json:"status"`
	LastHeartbeat cockroach_util_hlc.Timestamp `protobuf:"bytes,5,opt,name=last_heartbeat,json=lastHeartbeat" json:"last_heartbeat"`
	// The original timestamp at which the transaction started. For serializable
	// transactions, if the timestamp drifts from the original timestamp, the
	// transaction will retry.
	//
	// This timestamp is the one at which all transactions will read. It is also,
	// surprisingly, the timestamp at which transactions will _write_. This is
	// ultimately because of correctness concerns around SNAPSHOT transactions.
	// Note first that for SERIALIZABLE transactions, the original and commit
	// timestamps must not diverge, and so an intent which may be committed is
	// always written when both timestamps coincide.
	//
	// For a SNAPSHOT transaction however, this is not the case. Intuitively,
	// one could think that the timestamp at which intents should be written
	// should be the provisional commit timestamp, and while this is morally
	// true, consider the following scenario, where txn1 is a SNAPSHOT txn:
	//
	// - txn1 at orig_timestamp=5 reads key1: {Amount: 1, Price: 10}
	// - txn1 writes elsewhere, has its commit timestamp increased to 20.
	// - txn2 at orig_timestamp=10 reads key1: {Amount: 1, Price: 10}
	// - txn2 increases Price by 5: {Amount: 1, Price: 15} and commits
	// - txn1 increases Amount by 1: {Amount: 2, Price: 10}, attempts commit
	//
	// If txn1 uses its orig_timestamp for updating key1 (as it does), it
	// conflicts with txn2's committed value (which is at timestamp 10, in the
	// future of 5), and restarts.
	// Using instead its candidate commit timestamp, it wouldn't see a conflict
	// and commit, but this is not the expected outcome {Amount: 2, Price: 15}
	// and we are experiencing the Lost Update Anomaly.
	//
	// Note that in practice, before restarting, txn1 would still lay down an
	// intent (just above the committed value) not with the intent to commit it,
	// but to avoid being starved by short-lived transactions on that key which
	// would otherwise not have to go through conflict resolution with txn1.
	OrigTimestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,6,opt,name=orig_timestamp,json=origTimestamp" json:"orig_timestamp"`
	// Initial Timestamp + clock skew. Reads which encounter values with
	// timestamps between timestamp and max_timestamp trigger a txn
	// retry error, unless the node being read is listed in observed_timestamps
	// (in which case no more read uncertainty can occur).
	// The case max_timestamp < timestamp is possible for transactions which have
	// been pushed; in this case, max_timestamp should be ignored.
	MaxTimestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,7,opt,name=max_timestamp,json=maxTimestamp" json:"max_timestamp"`
	// A list of <NodeID, timestamp> pairs. The list maps NodeIDs to timestamps
	// as observed from their local clock during this transaction. The purpose of
	// this map is to avoid uncertainty related restarts which normally occur
	// when reading a value in the near future as per the max_timestamp field.
	//
	// When this list holds a corresponding entry for the node the current
	// request is executing on, we can run the command with the map's timestamp
	// as the top boundary of our uncertainty interval, limiting (and often
	// avoiding) uncertainty restarts.
	//
	// The list of observed timestamps is kept sorted by NodeID. Use
	// Transaction.UpdateObservedTimestamp to maintain the sorted order.
	ObservedTimestamps []ObservedTimestamp `protobuf:"bytes,8,rep,name=observed_timestamps,json=observedTimestamps" json:"observed_timestamps"`
	// Writing is true if the transaction has previously executed a successful
	// write request, i.e. a request that may have left intents (across retries).
	Writing bool `protobuf:"varint,9,opt,name=writing" json:"writing"`
	// If this is true, the transaction must retry. Relevant only for
	// SNAPSHOT transactions: a SERIALIZABLE transaction would have to
	// retry anyway due to its commit timestamp having moved forward.
	// This bool is set instead of immediately returning a txn retry
	// error so that intents can continue to be laid down, minimizing
	// work required on txn restart.
	WriteTooOld bool `protobuf:"varint,12,opt,name=write_too_old,json=writeTooOld" json:"write_too_old"`
	// If retry_on_push is true, the transaction must retry in the event
	// that the commit timestamp is pushed forward. This flag is set if
	// the transaction contains any calls to DeleteRange, in order to
	// prevent the LostDeleteRange anomaly. This flag is relevant only
	// for SNAPSHOT transactions.
	RetryOnPush bool   `protobuf:"varint,13,opt,name=retry_on_push,json=retryOnPush" json:"retry_on_push"`
	Intents     []Span `protobuf:"bytes,11,rep,name=intents" json:"intents"`
}

func (m *Transaction) Reset()                    { *m = Transaction{} }
func (*Transaction) ProtoMessage()               {}
func (*Transaction) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{10} }

// A Intent is a Span together with a Transaction metadata and its status.
type Intent struct {
	Span   `protobuf:"bytes,1,opt,name=span,embedded=span" json:"span"`
	Txn    cockroach_storage_engine_enginepb.TxnMeta `protobuf:"bytes,2,opt,name=txn" json:"txn"`
	Status TransactionStatus                         `protobuf:"varint,3,opt,name=status,enum=cockroach.roachpb.TransactionStatus" json:"status"`
}

func (m *Intent) Reset()                    { *m = Intent{} }
func (m *Intent) String() string            { return proto.CompactTextString(m) }
func (*Intent) ProtoMessage()               {}
func (*Intent) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{11} }

// Lease contains information about range leases including the
// expiration and lease holder.
type Lease struct {
	// The start is a timestamp at which the lease begins. This value
	// must be greater than the last lease expiration or the lease request
	// is considered invalid.
	Start cockroach_util_hlc.Timestamp `protobuf:"bytes,1,opt,name=start" json:"start"`
	// The expiration is a timestamp at which the lease expires. This means that
	// a new lease can be granted for a later timestamp.
	Expiration cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=expiration" json:"expiration"`
	// The address of the would-be lease holder.
	Replica ReplicaDescriptor `protobuf:"bytes,3,opt,name=replica" json:"replica"`
	// The start of the lease stasis period. This field is deprecated.
	DeprecatedStartStasis cockroach_util_hlc.Timestamp `protobuf:"bytes,4,opt,name=deprecated_start_stasis,json=deprecatedStartStasis" json:"deprecated_start_stasis"`
	// The current timestamp when this lease has been proposed. Used after a
	// transfer and after a node restart to enforce that a node only uses leases
	// proposed after the time of the said transfer or restart. This is nullable
	// to help with the rollout (such that a lease applied by some nodes before
	// the rollout and some nodes after the rollout is serialized the same).
	// TODO(andrei): Make this non-nullable after the rollout.
	ProposedTS *cockroach_util_hlc.Timestamp `protobuf:"bytes,5,opt,name=proposed_ts,json=proposedTs" json:"proposed_ts,omitempty"`
	// The epoch of the lease holder's node liveness entry. If this value
	// is non-zero, the start and expiration values are ignored.
	Epoch *int64 `protobuf:"varint,6,opt,name=epoch" json:"epoch,omitempty"`
}

func (m *Lease) Reset()                    { *m = Lease{} }
func (*Lease) ProtoMessage()               {}
func (*Lease) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{12} }

// AbortCacheEntry contains information about a transaction which has
// been aborted. It's written to a range's abort cache if the range
// may have contained intents of the aborted txn. In the event that
// the same transaction attempts to read keys it may have written
// previously, this entry informs the transaction that it has aborted
// and must start fresh with an updated priority.
type AbortCacheEntry struct {
	// The key of the associated transaction.
	Key Key `protobuf:"bytes,1,opt,name=key,casttype=Key" json:"key,omitempty"`
	// The candidate commit timestamp the transaction record held at the time
	// it was aborted.
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp"`
	// The priority of the transaction.
	Priority int32 `protobuf:"varint,3,opt,name=priority" json:"priority"`
}

func (m *AbortCacheEntry) Reset()                    { *m = AbortCacheEntry{} }
func (m *AbortCacheEntry) String() string            { return proto.CompactTextString(m) }
func (*AbortCacheEntry) ProtoMessage()               {}
func (*AbortCacheEntry) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{13} }

func init() {
	proto.RegisterType((*Span)(nil), "cockroach.roachpb.Span")
	proto.RegisterType((*Value)(nil), "cockroach.roachpb.Value")
	proto.RegisterType((*KeyValue)(nil), "cockroach.roachpb.KeyValue")
	proto.RegisterType((*StoreIdent)(nil), "cockroach.roachpb.StoreIdent")
	proto.RegisterType((*SplitTrigger)(nil), "cockroach.roachpb.SplitTrigger")
	proto.RegisterType((*MergeTrigger)(nil), "cockroach.roachpb.MergeTrigger")
	proto.RegisterType((*ChangeReplicasTrigger)(nil), "cockroach.roachpb.ChangeReplicasTrigger")
	proto.RegisterType((*ModifiedSpanTrigger)(nil), "cockroach.roachpb.ModifiedSpanTrigger")
	proto.RegisterType((*InternalCommitTrigger)(nil), "cockroach.roachpb.InternalCommitTrigger")
	proto.RegisterType((*ObservedTimestamp)(nil), "cockroach.roachpb.ObservedTimestamp")
	proto.RegisterType((*Transaction)(nil), "cockroach.roachpb.Transaction")
	proto.RegisterType((*Intent)(nil), "cockroach.roachpb.Intent")
	proto.RegisterType((*Lease)(nil), "cockroach.roachpb.Lease")
	proto.RegisterType((*AbortCacheEntry)(nil), "cockroach.roachpb.AbortCacheEntry")
	proto.RegisterEnum("cockroach.roachpb.ValueType", ValueType_name, ValueType_value)
	proto.RegisterEnum("cockroach.roachpb.ReplicaChangeType", ReplicaChangeType_name, ReplicaChangeType_value)
	proto.RegisterEnum("cockroach.roachpb.TransactionStatus", TransactionStatus_name, TransactionStatus_value)
}
func (m *Span) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Key != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if m.EndKey != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	return i, nil
}

func (m *Value) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RawBytes != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.RawBytes)))
		i += copy(dAtA[i:], m.RawBytes)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Timestamp.Size()))
	n1, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	return i, nil
}

func (m *KeyValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyValue) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Key != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Value.Size()))
	n2, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	return i, nil
}

func (m *StoreIdent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreIdent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.ClusterID.Size()))
	n3, err := m.ClusterID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	dAtA[i] = 0x10
	i++
	i = encodeVarintData(dAtA, i, uint64(m.NodeID))
	dAtA[i] = 0x18
	i++
	i = encodeVarintData(dAtA, i, uint64(m.StoreID))
	return i, nil
}

func (m *SplitTrigger) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SplitTrigger) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.LeftDesc.Size()))
	n4, err := m.LeftDesc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.RightDesc.Size()))
	n5, err := m.RightDesc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	return i, nil
}

func (m *MergeTrigger) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeTrigger) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.LeftDesc.Size()))
	n6, err := m.LeftDesc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.RightDesc.Size()))
	n7, err := m.RightDesc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	return i, nil
}

func (m *ChangeReplicasTrigger) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChangeReplicasTrigger) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintData(dAtA, i, uint64(m.ChangeType))
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Replica.Size()))
	n8, err := m.Replica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	if len(m.UpdatedReplicas) > 0 {
		for _, msg := range m.UpdatedReplicas {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x20
	i++
	i = encodeVarintData(dAtA, i, uint64(m.NextReplicaID))
	return i, nil
}

func (m *ModifiedSpanTrigger) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ModifiedSpanTrigger) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	if m.SystemConfigSpan {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if m.NodeLivenessSpan != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintData(dAtA, i, uint64(m.NodeLivenessSpan.Size()))
		n9, err := m.NodeLivenessSpan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}

func (m *InternalCommitTrigger) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InternalCommitTrigger) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SplitTrigger != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(m.SplitTrigger.Size()))
		n10, err := m.SplitTrigger.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.MergeTrigger != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintData(dAtA, i, uint64(m.MergeTrigger.Size()))
		n11, err := m.MergeTrigger.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.ChangeReplicasTrigger != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintData(dAtA, i, uint64(m.ChangeReplicasTrigger.Size()))
		n12, err := m.ChangeReplicasTrigger.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.ModifiedSpanTrigger != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintData(dAtA, i, uint64(m.ModifiedSpanTrigger.Size()))
		n13, err := m.ModifiedSpanTrigger.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}

func (m *ObservedTimestamp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ObservedTimestamp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintData(dAtA, i, uint64(m.NodeID))
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Timestamp.Size()))
	n14, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n14
	return i, nil
}

func (m *Transaction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Transaction) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.TxnMeta.Size()))
	n15, err := m.TxnMeta.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n15
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	dAtA[i] = 0x20
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Status))
	dAtA[i] = 0x2a
	i++
	i = encodeVarintData(dAtA, i, uint64(m.LastHeartbeat.Size()))
	n16, err := m.LastHeartbeat.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n16
	dAtA[i] = 0x32
	i++
	i = encodeVarintData(dAtA, i, uint64(m.OrigTimestamp.Size()))
	n17, err := m.OrigTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n17
	dAtA[i] = 0x3a
	i++
	i = encodeVarintData(dAtA, i, uint64(m.MaxTimestamp.Size()))
	n18, err := m.MaxTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	if len(m.ObservedTimestamps) > 0 {
		for _, msg := range m.ObservedTimestamps {
			dAtA[i] = 0x42
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x48
	i++
	if m.Writing {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if len(m.Intents) > 0 {
		for _, msg := range m.Intents {
			dAtA[i] = 0x5a
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x60
	i++
	if m.WriteTooOld {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x68
	i++
	if m.RetryOnPush {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *Intent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Intent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Span.Size()))
	n19, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n19
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Txn.Size()))
	n20, err := m.Txn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n20
	dAtA[i] = 0x18
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Status))
	return i, nil
}

func (m *Lease) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Lease) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Start.Size()))
	n21, err := m.Start.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n21
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Expiration.Size()))
	n22, err := m.Expiration.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n22
	dAtA[i] = 0x1a
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Replica.Size()))
	n23, err := m.Replica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n23
	dAtA[i] = 0x22
	i++
	i = encodeVarintData(dAtA, i, uint64(m.DeprecatedStartStasis.Size()))
	n24, err := m.DeprecatedStartStasis.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n24
	if m.ProposedTS != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintData(dAtA, i, uint64(m.ProposedTS.Size()))
		n25, err := m.ProposedTS.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	if m.Epoch != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintData(dAtA, i, uint64(*m.Epoch))
	}
	return i, nil
}

func (m *AbortCacheEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AbortCacheEntry) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Key != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Timestamp.Size()))
	n26, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n26
	dAtA[i] = 0x18
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Priority))
	return i, nil
}

func encodeFixed64Data(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Data(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintData(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedSpan(r randyData, easy bool) *Span {
	this := &Span{}
	if r.Intn(10) != 0 {
		v1 := r.Intn(100)
		this.Key = make(Key, v1)
		for i := 0; i < v1; i++ {
			this.Key[i] = byte(r.Intn(256))
		}
	}
	if r.Intn(10) != 0 {
		v2 := r.Intn(100)
		this.EndKey = make(Key, v2)
		for i := 0; i < v2; i++ {
			this.EndKey[i] = byte(r.Intn(256))
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedObservedTimestamp(r randyData, easy bool) *ObservedTimestamp {
	this := &ObservedTimestamp{}
	this.NodeID = NodeID(r.Int31())
	if r.Intn(2) == 0 {
		this.NodeID *= -1
	}
	v3 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.Timestamp = *v3
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedTransaction(r randyData, easy bool) *Transaction {
	this := &Transaction{}
	v4 := cockroach_storage_engine_enginepb.NewPopulatedTxnMeta(r, easy)
	this.TxnMeta = *v4
	this.Name = string(randStringData(r))
	this.Status = TransactionStatus([]int32{0, 1, 2}[r.Intn(3)])
	v5 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.LastHeartbeat = *v5
	v6 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.OrigTimestamp = *v6
	v7 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.MaxTimestamp = *v7
	if r.Intn(10) != 0 {
		v8 := r.Intn(5)
		this.ObservedTimestamps = make([]ObservedTimestamp, v8)
		for i := 0; i < v8; i++ {
			v9 := NewPopulatedObservedTimestamp(r, easy)
			this.ObservedTimestamps[i] = *v9
		}
	}
	this.Writing = bool(bool(r.Intn(2) == 0))
	if r.Intn(10) != 0 {
		v10 := r.Intn(5)
		this.Intents = make([]Span, v10)
		for i := 0; i < v10; i++ {
			v11 := NewPopulatedSpan(r, easy)
			this.Intents[i] = *v11
		}
	}
	this.WriteTooOld = bool(bool(r.Intn(2) == 0))
	this.RetryOnPush = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedLease(r randyData, easy bool) *Lease {
	this := &Lease{}
	v12 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.Start = *v12
	v13 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.Expiration = *v13
	v14 := NewPopulatedReplicaDescriptor(r, easy)
	this.Replica = *v14
	v15 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.DeprecatedStartStasis = *v15
	if r.Intn(10) != 0 {
		this.ProposedTS = cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	}
	if r.Intn(10) != 0 {
		v16 := int64(r.Int63())
		if r.Intn(2) == 0 {
			v16 *= -1
		}
		this.Epoch = &v16
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedAbortCacheEntry(r randyData, easy bool) *AbortCacheEntry {
	this := &AbortCacheEntry{}
	if r.Intn(10) != 0 {
		v17 := r.Intn(100)
		this.Key = make(Key, v17)
		for i := 0; i < v17; i++ {
			this.Key[i] = byte(r.Intn(256))
		}
	}
	v18 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.Timestamp = *v18
	this.Priority = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.Priority *= -1
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyData interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneData(r randyData) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringData(r randyData) string {
	v19 := r.Intn(100)
	tmps := make([]rune, v19)
	for i := 0; i < v19; i++ {
		tmps[i] = randUTF8RuneData(r)
	}
	return string(tmps)
}
func randUnrecognizedData(r randyData, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldData(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldData(dAtA []byte, r randyData, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateData(dAtA, uint64(key))
		v20 := r.Int63()
		if r.Intn(2) == 0 {
			v20 *= -1
		}
		dAtA = encodeVarintPopulateData(dAtA, uint64(v20))
	case 1:
		dAtA = encodeVarintPopulateData(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateData(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateData(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateData(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateData(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Span) Size() (n int) {
	var l int
	_ = l
	if m.Key != nil {
		l = len(m.Key)
		n += 1 + l + sovData(uint64(l))
	}
	if m.EndKey != nil {
		l = len(m.EndKey)
		n += 1 + l + sovData(uint64(l))
	}
	return n
}

func (m *Value) Size() (n int) {
	var l int
	_ = l
	if m.RawBytes != nil {
		l = len(m.RawBytes)
		n += 1 + l + sovData(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *KeyValue) Size() (n int) {
	var l int
	_ = l
	if m.Key != nil {
		l = len(m.Key)
		n += 1 + l + sovData(uint64(l))
	}
	l = m.Value.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *StoreIdent) Size() (n int) {
	var l int
	_ = l
	l = m.ClusterID.Size()
	n += 1 + l + sovData(uint64(l))
	n += 1 + sovData(uint64(m.NodeID))
	n += 1 + sovData(uint64(m.StoreID))
	return n
}

func (m *SplitTrigger) Size() (n int) {
	var l int
	_ = l
	l = m.LeftDesc.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.RightDesc.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *MergeTrigger) Size() (n int) {
	var l int
	_ = l
	l = m.LeftDesc.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.RightDesc.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *ChangeReplicasTrigger) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovData(uint64(m.ChangeType))
	l = m.Replica.Size()
	n += 1 + l + sovData(uint64(l))
	if len(m.UpdatedReplicas) > 0 {
		for _, e := range m.UpdatedReplicas {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	n += 1 + sovData(uint64(m.NextReplicaID))
	return n
}

func (m *ModifiedSpanTrigger) Size() (n int) {
	var l int
	_ = l
	n += 2
	if m.NodeLivenessSpan != nil {
		l = m.NodeLivenessSpan.Size()
		n += 1 + l + sovData(uint64(l))
	}
	return n
}

func (m *InternalCommitTrigger) Size() (n int) {
	var l int
	_ = l
	if m.SplitTrigger != nil {
		l = m.SplitTrigger.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.MergeTrigger != nil {
		l = m.MergeTrigger.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.ChangeReplicasTrigger != nil {
		l = m.ChangeReplicasTrigger.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.ModifiedSpanTrigger != nil {
		l = m.ModifiedSpanTrigger.Size()
		n += 1 + l + sovData(uint64(l))
	}
	return n
}

func (m *ObservedTimestamp) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovData(uint64(m.NodeID))
	l = m.Timestamp.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *Transaction) Size() (n int) {
	var l int
	_ = l
	l = m.TxnMeta.Size()
	n += 1 + l + sovData(uint64(l))
	l = len(m.Name)
	n += 1 + l + sovData(uint64(l))
	n += 1 + sovData(uint64(m.Status))
	l = m.LastHeartbeat.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.OrigTimestamp.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.MaxTimestamp.Size()
	n += 1 + l + sovData(uint64(l))
	if len(m.ObservedTimestamps) > 0 {
		for _, e := range m.ObservedTimestamps {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	n += 2
	if len(m.Intents) > 0 {
		for _, e := range m.Intents {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	n += 2
	n += 2
	return n
}

func (m *Intent) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.Txn.Size()
	n += 1 + l + sovData(uint64(l))
	n += 1 + sovData(uint64(m.Status))
	return n
}

func (m *Lease) Size() (n int) {
	var l int
	_ = l
	l = m.Start.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.Expiration.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.Replica.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.DeprecatedStartStasis.Size()
	n += 1 + l + sovData(uint64(l))
	if m.ProposedTS != nil {
		l = m.ProposedTS.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.Epoch != nil {
		n += 1 + sovData(uint64(*m.Epoch))
	}
	return n
}

func (m *AbortCacheEntry) Size() (n int) {
	var l int
	_ = l
	if m.Key != nil {
		l = len(m.Key)
		n += 1 + l + sovData(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovData(uint64(l))
	n += 1 + sovData(uint64(m.Priority))
	return n
}

func sovData(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozData(x uint64) (n int) {
	return sovData(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Span) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Span: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Span: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawBytes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawBytes = append(m.RawBytes[:0], dAtA[iNdEx:postIndex]...)
			if m.RawBytes == nil {
				m.RawBytes = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeyValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreIdent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreIdent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreIdent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ClusterID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SplitTrigger) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SplitTrigger: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SplitTrigger: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeftDesc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LeftDesc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RightDesc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RightDesc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeTrigger) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeTrigger: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeTrigger: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeftDesc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LeftDesc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RightDesc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RightDesc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChangeReplicasTrigger) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChangeReplicasTrigger: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChangeReplicasTrigger: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeType", wireType)
			}
			m.ChangeType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ChangeType |= (ReplicaChangeType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Replica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatedReplicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UpdatedReplicas = append(m.UpdatedReplicas, ReplicaDescriptor{})
			if err := m.UpdatedReplicas[len(m.UpdatedReplicas)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextReplicaID", wireType)
			}
			m.NextReplicaID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextReplicaID |= (ReplicaID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ModifiedSpanTrigger) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ModifiedSpanTrigger: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ModifiedSpanTrigger: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SystemConfigSpan", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SystemConfigSpan = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeLivenessSpan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NodeLivenessSpan == nil {
				m.NodeLivenessSpan = &Span{}
			}
			if err := m.NodeLivenessSpan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InternalCommitTrigger) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InternalCommitTrigger: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InternalCommitTrigger: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SplitTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SplitTrigger == nil {
				m.SplitTrigger = &SplitTrigger{}
			}
			if err := m.SplitTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergeTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MergeTrigger == nil {
				m.MergeTrigger = &MergeTrigger{}
			}
			if err := m.MergeTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeReplicasTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ChangeReplicasTrigger == nil {
				m.ChangeReplicasTrigger = &ChangeReplicasTrigger{}
			}
			if err := m.ChangeReplicasTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ModifiedSpanTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ModifiedSpanTrigger == nil {
				m.ModifiedSpanTrigger = &ModifiedSpanTrigger{}
			}
			if err := m.ModifiedSpanTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ObservedTimestamp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ObservedTimestamp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ObservedTimestamp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Transaction) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Transaction: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Transaction: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (TransactionStatus(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbeat", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LastHeartbeat.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrigTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OrigTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MaxTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObservedTimestamps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ObservedTimestamps = append(m.ObservedTimestamps, ObservedTimestamp{})
			if err := m.ObservedTimestamps[len(m.ObservedTimestamps)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Writing", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Writing = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Intents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Intents = append(m.Intents, Span{})
			if err := m.Intents[len(m.Intents)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteTooOld", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WriteTooOld = bool(v != 0)
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryOnPush", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RetryOnPush = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Intent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Intent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Intent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (TransactionStatus(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Lease) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Lease: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Lease: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Start.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expiration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Expiration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Replica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedStartStasis", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.DeprecatedStartStasis.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposedTS", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProposedTS == nil {
				m.ProposedTS = &cockroach_util_hlc.Timestamp{}
			}
			if err := m.ProposedTS.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Epoch", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Epoch = &v
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AbortCacheEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AbortCacheEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AbortCacheEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipData(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowData
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowData
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowData
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthData
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowData
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipData(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthData = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowData   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("cockroach/pkg/roachpb/data.proto", fileDescriptorData) }

var fileDescriptorData = []byte{
	// 1508 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x56, 0x4d, 0x6f, 0xdb, 0xcc,
	0x11, 0x16, 0x2d, 0xc9, 0x92, 0x46, 0x92, 0x4d, 0xaf, 0x6b, 0x44, 0x75, 0x51, 0xc9, 0x15, 0x5e,
	0xbc, 0x30, 0x7c, 0x90, 0x5a, 0xb7, 0x41, 0xd1, 0x1c, 0x0a, 0xe8, 0x83, 0x8d, 0x19, 0xeb, 0xc3,
	0xa0, 0xe8, 0x14, 0x4d, 0x0e, 0x2c, 0x4d, 0x6e, 0x28, 0x22, 0x12, 0x49, 0x70, 0x57, 0x8e, 0xf5,
	0x0f, 0x72, 0x6b, 0x6e, 0xed, 0xa9, 0x08, 0xd0, 0xdc, 0x8a, 0xde, 0xfb, 0x0f, 0xea, 0x4b, 0x81,
	0x1c, 0x8b, 0x1e, 0xd4, 0xd6, 0x3d, 0xf4, 0x3f, 0xe4, 0x54, 0xec, 0x72, 0x29, 0x31, 0xb5, 0x12,
	0xd8, 0xc9, 0xa5, 0x17, 0x69, 0x39, 0x33, 0xcf, 0x33, 0xb3, 0xbb, 0xf3, 0xb1, 0x70, 0x60, 0xf9,
	0xd6, 0xcb, 0xd0, 0x37, 0xad, 0x71, 0x33, 0x78, 0xe9, 0x34, 0xf9, 0x2a, 0xb8, 0x68, 0xda, 0x26,
	0x35, 0x1b, 0x41, 0xe8, 0x53, 0x1f, 0xed, 0x2c, 0x2d, 0x1a, 0x42, 0xbb, 0xff, 0xcd, 0x7a, 0xd0,
	0x14, 0x53, 0x73, 0x05, 0xdc, 0xff, 0xe1, 0xc7, 0x56, 0x84, 0xfa, 0xa1, 0xe9, 0xe0, 0x26, 0xf6,
	0x1c, 0xd7, 0x8b, 0xff, 0x18, 0xea, 0xd2, 0xb2, 0x04, 0xe2, 0xdb, 0x8f, 0x11, 0x33, 0xea, 0x4e,
	0x9a, 0xe3, 0x89, 0xd5, 0xa4, 0xee, 0x14, 0x13, 0x6a, 0x4e, 0x03, 0x61, 0xf7, 0x1d, 0xc7, 0x77,
	0x7c, 0xbe, 0x6c, 0xb2, 0x55, 0x24, 0xad, 0xf7, 0x21, 0x33, 0x0a, 0x4c, 0x0f, 0x7d, 0x17, 0xd2,
	0x2f, 0xf1, 0xbc, 0x92, 0x3e, 0x90, 0x0e, 0x4b, 0xed, 0xdc, 0x87, 0x45, 0x2d, 0x7d, 0x8a, 0xe7,
	0x1a, 0x93, 0xa1, 0x03, 0xc8, 0x61, 0xcf, 0x36, 0x98, 0x3a, 0xf3, 0xb1, 0x7a, 0x13, 0x7b, 0xf6,
	0x29, 0x9e, 0x3f, 0xca, 0xff, 0xee, 0x6d, 0x2d, 0xf5, 0xe7, 0xb7, 0x35, 0xa9, 0xee, 0x40, 0xf6,
	0xa9, 0x39, 0x99, 0x61, 0xf4, 0x3d, 0x28, 0x84, 0xe6, 0x2b, 0xe3, 0x62, 0x4e, 0x31, 0xa9, 0x48,
	0x0c, 0xa6, 0xe5, 0x43, 0xf3, 0x55, 0x9b, 0x7d, 0xa3, 0x16, 0x14, 0x96, 0xd1, 0x55, 0x36, 0x0e,
	0xa4, 0xc3, 0xe2, 0xf1, 0xf7, 0x1b, 0xab, 0x13, 0x63, 0x5b, 0x68, 0x8c, 0x27, 0x56, 0x43, 0x8f,
	0x8d, 0xda, 0x99, 0xeb, 0x45, 0x2d, 0xa5, 0xad, 0x50, 0xf5, 0xe7, 0x90, 0x3f, 0xc5, 0xf3, 0xc8,
	0x97, 0x88, 0x5d, 0x5a, 0x13, 0xfb, 0x4f, 0x20, 0x7b, 0xc9, 0x6c, 0x84, 0x97, 0x4a, 0xe3, 0xd6,
	0xbd, 0x34, 0x38, 0x87, 0x70, 0x10, 0x19, 0xd7, 0xff, 0x21, 0x01, 0x8c, 0xa8, 0x1f, 0x62, 0xd5,
	0xc6, 0x1e, 0x45, 0x0e, 0x80, 0x35, 0x99, 0x11, 0x8a, 0x43, 0xc3, 0xb5, 0x85, 0x9b, 0x13, 0x66,
	0xff, 0xf7, 0x45, 0xed, 0xc7, 0x8e, 0x4b, 0xc7, 0xb3, 0x8b, 0x86, 0xe5, 0x4f, 0x9b, 0x4b, 0x6e,
	0xfb, 0xa2, 0xb9, 0xe6, 0x52, 0x66, 0x33, 0xd7, 0x6e, 0x9c, 0x9f, 0xab, 0xdd, 0x9b, 0x45, 0xad,
	0xd0, 0x89, 0x08, 0xd5, 0xae, 0x56, 0x10, 0xdc, 0xaa, 0x8d, 0x7e, 0x04, 0x39, 0xcf, 0xb7, 0x31,
	0xf3, 0xc2, 0xe2, 0xcd, 0xb6, 0x2b, 0xcc, 0xcb, 0xcd, 0xa2, 0xb6, 0x39, 0xf0, 0x6d, 0xac, 0x76,
	0x3f, 0x2c, 0x57, 0xda, 0x26, 0x33, 0x54, 0x6d, 0xf4, 0x10, 0xf2, 0x2c, 0x47, 0x38, 0x26, 0xcd,
	0x31, 0xfb, 0x02, 0x93, 0x8b, 0x76, 0xc0, 0x40, 0xf1, 0x52, 0xcb, 0x91, 0x68, 0x57, 0xf5, 0x77,
	0x12, 0x94, 0x46, 0xc1, 0xc4, 0xa5, 0x7a, 0xe8, 0x3a, 0x0e, 0x0e, 0x91, 0x02, 0x85, 0x09, 0x7e,
	0x41, 0x0d, 0x1b, 0x13, 0x8b, 0x6f, 0xb1, 0x78, 0x5c, 0x5f, 0x73, 0x58, 0x9a, 0xe9, 0x39, 0xb8,
	0x8b, 0x89, 0x15, 0xba, 0x01, 0xf5, 0x43, 0x71, 0x6c, 0x79, 0x06, 0x65, 0x52, 0xf4, 0x18, 0x20,
	0x74, 0x9d, 0xb1, 0xe0, 0xd9, 0xb8, 0x27, 0x4f, 0x81, 0x63, 0x99, 0xf8, 0x49, 0x26, 0x9f, 0x96,
	0x33, 0xf5, 0xdf, 0x4b, 0x50, 0xea, 0xe3, 0xd0, 0xc1, 0xff, 0xa7, 0x61, 0xd6, 0xff, 0xba, 0x01,
	0x7b, 0x9d, 0x31, 0xb3, 0xd2, 0x70, 0x30, 0x71, 0x2d, 0x93, 0xc4, 0x91, 0x9e, 0x42, 0xd1, 0xe2,
	0x0a, 0x83, 0xce, 0x03, 0xcc, 0x63, 0xdd, 0x3a, 0xfe, 0x66, 0x9d, 0x8f, 0x08, 0x18, 0xb1, 0xe8,
	0xf3, 0x20, 0xce, 0x45, 0xb0, 0x96, 0x12, 0xd4, 0x85, 0x5c, 0x18, 0x99, 0x89, 0x60, 0x3f, 0x43,
	0x74, 0x2b, 0xdc, 0x18, 0x8a, 0xce, 0x41, 0x9e, 0x05, 0xb6, 0x49, 0xb1, 0x6d, 0x08, 0x11, 0xa9,
	0xa4, 0x0f, 0xd2, 0xf7, 0xa4, 0xdb, 0x16, 0x1c, 0xf1, 0x86, 0xd1, 0x13, 0xd8, 0xf6, 0xf0, 0x15,
	0x8d, 0x39, 0x59, 0x26, 0x66, 0x78, 0x26, 0xd6, 0x45, 0x26, 0x96, 0x07, 0xf8, 0x8a, 0x0a, 0x73,
	0x9e, 0x8f, 0x85, 0xe5, 0x87, 0x56, 0xf6, 0x12, 0x3a, 0xbb, 0xfe, 0x46, 0x82, 0xdd, 0xbe, 0x6f,
	0xbb, 0x2f, 0x5c, 0x6c, 0xb3, 0xbe, 0x14, 0x9f, 0xe6, 0x31, 0x20, 0x32, 0x27, 0x14, 0x4f, 0x0d,
	0xcb, 0xf7, 0x5e, 0xb8, 0x8e, 0x41, 0x02, 0xd3, 0xe3, 0x87, 0x9a, 0x17, 0x61, 0xc9, 0x91, 0xbe,
	0xc3, 0xd5, 0xbc, 0xa5, 0x29, 0x80, 0x78, 0x35, 0x4d, 0xdc, 0x4b, 0xec, 0x61, 0x42, 0x22, 0x4c,
	0x74, 0x7e, 0x0f, 0xd6, 0x6c, 0x98, 0x81, 0x34, 0x99, 0x41, 0x7a, 0x02, 0xc1, 0x24, 0xf5, 0xff,
	0x6c, 0xc0, 0x9e, 0xea, 0x51, 0x1c, 0x7a, 0xe6, 0xa4, 0xe3, 0x4f, 0xa7, 0xab, 0x9a, 0xe9, 0x42,
	0x99, 0xb0, 0x1a, 0x32, 0x68, 0x24, 0x10, 0x09, 0x59, 0x5b, 0xcb, 0xbd, 0xaa, 0x35, 0xad, 0x44,
	0x92, 0x95, 0xd7, 0x85, 0xf2, 0x94, 0xa5, 0xf8, 0x92, 0x65, 0xe3, 0x93, 0x2c, 0xc9, 0x52, 0xd0,
	0x4a, 0xd3, 0x64, 0x61, 0xfc, 0x1a, 0x1e, 0x88, 0x74, 0x8b, 0xaf, 0x76, 0xc9, 0x97, 0xe6, 0x7c,
	0x87, 0x6b, 0xf8, 0xd6, 0x66, 0xae, 0xb6, 0x67, 0xad, 0x4d, 0xe8, 0x67, 0xb0, 0x37, 0x15, 0x37,
	0xc3, 0x4f, 0x72, 0xc9, 0x9f, 0xe1, 0xfc, 0xdf, 0xae, 0x8b, 0xf7, 0xf6, 0x4d, 0x6a, 0xbb, 0xd3,
	0xdb, 0xc2, 0x47, 0x99, 0xd7, 0x6c, 0x78, 0xfc, 0x46, 0x82, 0x9d, 0xe1, 0x05, 0xc1, 0xe1, 0x25,
	0xb6, 0x97, 0xad, 0x3f, 0xd9, 0x14, 0xa5, 0x3b, 0x36, 0xc5, 0xaf, 0x9f, 0x2f, 0x8f, 0x32, 0x7c,
	0x9c, 0xfd, 0x31, 0x0b, 0x45, 0x3d, 0x34, 0x3d, 0x62, 0x5a, 0xd4, 0xf5, 0x3d, 0x74, 0x02, 0x19,
	0x36, 0xaf, 0xc5, 0x45, 0x1f, 0x25, 0x38, 0xc5, 0xa0, 0x6e, 0x44, 0x13, 0xba, 0x11, 0x0f, 0xea,
	0x86, 0x7e, 0xe5, 0xf5, 0x31, 0x35, 0xdb, 0x79, 0xe6, 0xe0, 0xfd, 0xa2, 0x26, 0x69, 0x9c, 0x01,
	0x55, 0x20, 0xe3, 0x99, 0xd3, 0x68, 0x2e, 0x15, 0x84, 0x7b, 0x2e, 0x41, 0x6d, 0xd8, 0x24, 0xd4,
	0xa4, 0x33, 0xc2, 0x0f, 0x76, 0x7d, 0xcf, 0x48, 0xc4, 0x34, 0xe2, 0xb6, 0x82, 0x41, 0x20, 0xd1,
	0x13, 0xd8, 0x9a, 0x98, 0x84, 0x1a, 0x63, 0x6c, 0x86, 0xf4, 0x02, 0x9b, 0xb4, 0x92, 0xbd, 0xfb,
	0x29, 0x94, 0x19, 0xf4, 0x24, 0x46, 0x32, 0x2e, 0x3f, 0x74, 0x1d, 0x63, 0x75, 0xa2, 0x9b, 0xf7,
	0xe0, 0x62, 0xd0, 0xd5, 0x5d, 0x9e, 0x40, 0x79, 0x6a, 0x5e, 0x25, 0xa8, 0x72, 0x77, 0xa7, 0x2a,
	0x4d, 0xcd, 0xab, 0x15, 0xd3, 0x73, 0xd8, 0xf5, 0x45, 0xaa, 0xac, 0xe8, 0x48, 0x25, 0xff, 0xc9,
	0x76, 0x76, 0x2b, 0xb1, 0x04, 0x2d, 0xf2, 0xff, 0x57, 0x41, 0x50, 0x15, 0x72, 0xaf, 0x42, 0x97,
	0xba, 0x9e, 0x53, 0x29, 0x24, 0x5a, 0x4c, 0x2c, 0x44, 0x3f, 0x85, 0x9c, 0xeb, 0x51, 0xec, 0x51,
	0x52, 0x29, 0x72, 0x87, 0x9f, 0x6a, 0x27, 0x31, 0x50, 0x58, 0xa3, 0x43, 0x28, 0x33, 0x0e, 0x6c,
	0x50, 0xdf, 0x37, 0xfc, 0x89, 0x5d, 0x29, 0x25, 0xe8, 0x8b, 0x5c, 0xa5, 0xfb, 0xfe, 0x70, 0x62,
	0x33, 0xcb, 0x10, 0xd3, 0x70, 0x6e, 0xf8, 0x9e, 0x11, 0xcc, 0xc8, 0xb8, 0x52, 0x4e, 0x5a, 0x72,
	0xd5, 0xd0, 0x3b, 0x9b, 0x91, 0x71, 0xe2, 0xf1, 0xf5, 0x17, 0x09, 0x36, 0x55, 0xee, 0x09, 0x3d,
	0x84, 0xcc, 0xb2, 0x43, 0x7e, 0x26, 0xbc, 0x44, 0x56, 0x32, 0x73, 0xd4, 0x86, 0x34, 0xbd, 0x8a,
	0x7b, 0xe4, 0x7d, 0xd2, 0x3b, 0x8a, 0x8b, 0x81, 0x13, 0xf9, 0x9b, 0xfe, 0xd2, 0xfc, 0xad, 0xbf,
	0x4b, 0x43, 0xb6, 0x87, 0x4d, 0x82, 0xd1, 0xcf, 0x20, 0x4b, 0xa8, 0x19, 0x52, 0xb1, 0x93, 0x3b,
	0x65, 0x4a, 0x84, 0x40, 0x1d, 0x00, 0x7c, 0x15, 0xb8, 0xa1, 0xc9, 0xdc, 0xdc, 0xa7, 0x0d, 0x24,
	0x60, 0xc9, 0xc9, 0x9b, 0xfe, 0xf2, 0xc9, 0xfb, 0x1c, 0x1e, 0xd8, 0x38, 0x08, 0xb1, 0xc5, 0x87,
	0x2f, 0x0f, 0x8f, 0xfd, 0x12, 0x97, 0x88, 0xee, 0x79, 0xa7, 0xb8, 0xf6, 0x56, 0x1c, 0x23, 0x46,
	0x31, 0xe2, 0x0c, 0x48, 0x83, 0x62, 0x10, 0xfa, 0x81, 0x4f, 0x58, 0x29, 0x90, 0xbb, 0x55, 0x3a,
	0xba, 0x5e, 0xd4, 0xa4, 0x9b, 0x45, 0x0d, 0xce, 0x04, 0x52, 0x1f, 0x69, 0x10, 0xb3, 0xe8, 0x04,
	0xed, 0x43, 0x16, 0x07, 0xbe, 0x35, 0xe6, 0xb5, 0x9e, 0xe6, 0xfe, 0x25, 0x2d, 0x12, 0x25, 0x12,
	0xee, 0xb7, 0x12, 0x6c, 0xb7, 0x2e, 0xfc, 0x90, 0x76, 0x4c, 0x6b, 0x8c, 0x15, 0x8f, 0x86, 0xf3,
	0xcf, 0x3d, 0xc6, 0xbf, 0xbe, 0x2d, 0xa3, 0x03, 0xc8, 0x07, 0xa1, 0xeb, 0x87, 0x2e, 0x9d, 0x8b,
	0xe7, 0xae, 0x78, 0xda, 0xc5, 0xd2, 0xa8, 0x71, 0x1f, 0xfd, 0x49, 0x82, 0x02, 0x7f, 0xd8, 0xf3,
	0xe7, 0x53, 0x11, 0x72, 0xe7, 0x83, 0xd3, 0xc1, 0xf0, 0x97, 0x03, 0x39, 0x85, 0xf2, 0x90, 0x19,
	0x9c, 0xf7, 0x7a, 0x72, 0x0e, 0xe5, 0x20, 0xad, 0x0e, 0x74, 0x59, 0x42, 0x05, 0xc8, 0xfe, 0xa2,
	0x37, 0x6c, 0xe9, 0xf2, 0x06, 0x5b, 0xb6, 0x7f, 0xa5, 0x2b, 0x23, 0x39, 0x8d, 0x76, 0x61, 0xbb,
	0xab, 0xf4, 0xd4, 0xbe, 0xaa, 0x2b, 0x5d, 0x23, 0x12, 0xe6, 0x19, 0x5a, 0x57, 0xfb, 0x8a, 0x9c,
	0x61, 0xa4, 0x5d, 0xa5, 0xa3, 0xf6, 0x5b, 0x3d, 0x39, 0x8b, 0xf6, 0x60, 0x67, 0x65, 0x1b, 0x8b,
	0x0b, 0xa8, 0x04, 0xf9, 0xee, 0xb9, 0xd6, 0xd2, 0xd5, 0xe1, 0x40, 0xde, 0x64, 0xdc, 0xfa, 0xf9,
	0x59, 0x4f, 0x91, 0x01, 0x6d, 0x01, 0x30, 0x9a, 0x91, 0xa2, 0xa9, 0xca, 0x48, 0xb6, 0x8f, 0x7e,
	0x0e, 0x3b, 0xb7, 0xde, 0x81, 0x68, 0x1b, 0x8a, 0xad, 0x6e, 0xd7, 0xd0, 0x94, 0xb3, 0x9e, 0xda,
	0x69, 0xc9, 0x29, 0x84, 0x60, 0x4b, 0x53, 0xfa, 0xc3, 0xa7, 0xca, 0x52, 0x26, 0xed, 0x67, 0x5e,
	0xff, 0xa1, 0x9a, 0x3a, 0x6a, 0xc3, 0xce, 0xad, 0x9a, 0x62, 0x11, 0x9e, 0x29, 0x83, 0xae, 0x3a,
	0x78, 0x2c, 0xa7, 0x50, 0x19, 0x0a, 0x9d, 0x61, 0xbf, 0xaf, 0xea, 0xba, 0xd2, 0x95, 0x25, 0xa6,
	0x6b, 0xb5, 0x87, 0x1a, 0xfb, 0xd8, 0x88, 0x38, 0xda, 0x3f, 0xb8, 0xfe, 0x57, 0x35, 0x75, 0x7d,
	0x53, 0x95, 0xde, 0xdf, 0x54, 0xa5, 0xbf, 0xdd, 0x54, 0xa5, 0x7f, 0xde, 0x54, 0xa5, 0x37, 0xff,
	0xae, 0xa6, 0x9e, 0xe5, 0x44, 0xa2, 0xff, 0x37, 0x00, 0x00, 0xff, 0xff, 0x72, 0x0e, 0x49, 0x1b,
	0xf9, 0x0e, 0x00, 0x00,
}
