package servicebus

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/servicebus/mgmt/2015-08-01/servicebus"

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// Listen ...
	Listen AccessRights = "Listen"
	// Manage ...
	Manage AccessRights = "Manage"
	// Send ...
	Send AccessRights = "Send"
)

// PossibleAccessRightsValues returns an array of possible values for the AccessRights const type.
func PossibleAccessRightsValues() []AccessRights {
	return []AccessRights{Listen, Manage, Send}
}

// EntityAvailabilityStatus enumerates the values for entity availability status.
type EntityAvailabilityStatus string

const (
	// Available ...
	Available EntityAvailabilityStatus = "Available"
	// Limited ...
	Limited EntityAvailabilityStatus = "Limited"
	// Renaming ...
	Renaming EntityAvailabilityStatus = "Renaming"
	// Restoring ...
	Restoring EntityAvailabilityStatus = "Restoring"
	// Unknown ...
	Unknown EntityAvailabilityStatus = "Unknown"
)

// PossibleEntityAvailabilityStatusValues returns an array of possible values for the EntityAvailabilityStatus const type.
func PossibleEntityAvailabilityStatusValues() []EntityAvailabilityStatus {
	return []EntityAvailabilityStatus{Available, Limited, Renaming, Restoring, Unknown}
}

// EntityStatus enumerates the values for entity status.
type EntityStatus string

const (
	// EntityStatusActive ...
	EntityStatusActive EntityStatus = "Active"
	// EntityStatusCreating ...
	EntityStatusCreating EntityStatus = "Creating"
	// EntityStatusDeleting ...
	EntityStatusDeleting EntityStatus = "Deleting"
	// EntityStatusDisabled ...
	EntityStatusDisabled EntityStatus = "Disabled"
	// EntityStatusReceiveDisabled ...
	EntityStatusReceiveDisabled EntityStatus = "ReceiveDisabled"
	// EntityStatusRenaming ...
	EntityStatusRenaming EntityStatus = "Renaming"
	// EntityStatusRestoring ...
	EntityStatusRestoring EntityStatus = "Restoring"
	// EntityStatusSendDisabled ...
	EntityStatusSendDisabled EntityStatus = "SendDisabled"
	// EntityStatusUnknown ...
	EntityStatusUnknown EntityStatus = "Unknown"
)

// PossibleEntityStatusValues returns an array of possible values for the EntityStatus const type.
func PossibleEntityStatusValues() []EntityStatus {
	return []EntityStatus{EntityStatusActive, EntityStatusCreating, EntityStatusDeleting, EntityStatusDisabled, EntityStatusReceiveDisabled, EntityStatusRenaming, EntityStatusRestoring, EntityStatusSendDisabled, EntityStatusUnknown}
}

// NamespaceState enumerates the values for namespace state.
type NamespaceState string

const (
	// NamespaceStateActivating ...
	NamespaceStateActivating NamespaceState = "Activating"
	// NamespaceStateActive ...
	NamespaceStateActive NamespaceState = "Active"
	// NamespaceStateCreated ...
	NamespaceStateCreated NamespaceState = "Created"
	// NamespaceStateCreating ...
	NamespaceStateCreating NamespaceState = "Creating"
	// NamespaceStateDisabled ...
	NamespaceStateDisabled NamespaceState = "Disabled"
	// NamespaceStateDisabling ...
	NamespaceStateDisabling NamespaceState = "Disabling"
	// NamespaceStateEnabling ...
	NamespaceStateEnabling NamespaceState = "Enabling"
	// NamespaceStateFailed ...
	NamespaceStateFailed NamespaceState = "Failed"
	// NamespaceStateRemoved ...
	NamespaceStateRemoved NamespaceState = "Removed"
	// NamespaceStateRemoving ...
	NamespaceStateRemoving NamespaceState = "Removing"
	// NamespaceStateSoftDeleted ...
	NamespaceStateSoftDeleted NamespaceState = "SoftDeleted"
	// NamespaceStateSoftDeleting ...
	NamespaceStateSoftDeleting NamespaceState = "SoftDeleting"
	// NamespaceStateUnknown ...
	NamespaceStateUnknown NamespaceState = "Unknown"
)

// PossibleNamespaceStateValues returns an array of possible values for the NamespaceState const type.
func PossibleNamespaceStateValues() []NamespaceState {
	return []NamespaceState{NamespaceStateActivating, NamespaceStateActive, NamespaceStateCreated, NamespaceStateCreating, NamespaceStateDisabled, NamespaceStateDisabling, NamespaceStateEnabling, NamespaceStateFailed, NamespaceStateRemoved, NamespaceStateRemoving, NamespaceStateSoftDeleted, NamespaceStateSoftDeleting, NamespaceStateUnknown}
}

// Policykey enumerates the values for policykey.
type Policykey string

const (
	// PrimaryKey ...
	PrimaryKey Policykey = "PrimaryKey"
	// SecondaryKey ...
	SecondaryKey Policykey = "SecondaryKey"
)

// PossiblePolicykeyValues returns an array of possible values for the Policykey const type.
func PossiblePolicykeyValues() []Policykey {
	return []Policykey{PrimaryKey, SecondaryKey}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Basic ...
	Basic SkuName = "Basic"
	// Premium ...
	Premium SkuName = "Premium"
	// Standard ...
	Standard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{Basic, Premium, Standard}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// SkuTierBasic ...
	SkuTierBasic SkuTier = "Basic"
	// SkuTierPremium ...
	SkuTierPremium SkuTier = "Premium"
	// SkuTierStandard ...
	SkuTierStandard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{SkuTierBasic, SkuTierPremium, SkuTierStandard}
}

// UnavailableReason enumerates the values for unavailable reason.
type UnavailableReason string

const (
	// InvalidName ...
	InvalidName UnavailableReason = "InvalidName"
	// NameInLockdown ...
	NameInLockdown UnavailableReason = "NameInLockdown"
	// NameInUse ...
	NameInUse UnavailableReason = "NameInUse"
	// None ...
	None UnavailableReason = "None"
	// SubscriptionIsDisabled ...
	SubscriptionIsDisabled UnavailableReason = "SubscriptionIsDisabled"
	// TooManyNamespaceInCurrentSubscription ...
	TooManyNamespaceInCurrentSubscription UnavailableReason = "TooManyNamespaceInCurrentSubscription"
)

// PossibleUnavailableReasonValues returns an array of possible values for the UnavailableReason const type.
func PossibleUnavailableReasonValues() []UnavailableReason {
	return []UnavailableReason{InvalidName, NameInLockdown, NameInUse, None, SubscriptionIsDisabled, TooManyNamespaceInCurrentSubscription}
}

// CheckNameAvailability description of a Check Name availability request properties.
type CheckNameAvailability struct {
	// Name - The Name to check the namespce name availability and The namespace name can contain only letters, numbers, and hyphens. The namespace must start with a letter, and it must end with a letter or number.
	Name *string `json:"name,omitempty"`
}

// CheckNameAvailabilityResult description of a Check Name availability request properties.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - Value indicating namespace is availability, true if the namespace is available; otherwise, false.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason for unavailability of a namespace. Possible values include: 'None', 'InvalidName', 'SubscriptionIsDisabled', 'NameInUse', 'NameInLockdown', 'TooManyNamespaceInCurrentSubscription'
	Reason UnavailableReason `json:"reason,omitempty"`
	// Message - The detailed info regarding the reason associated with the namespace.
	Message *string `json:"message,omitempty"`
}

// MessageCountDetails message Count Details.
type MessageCountDetails struct {
	// ActiveMessageCount - Number of active messages in the queue, topic, or subscription.
	ActiveMessageCount *int64 `json:"activeMessageCount,omitempty"`
	// DeadLetterMessageCount - Number of messages that are dead lettered.
	DeadLetterMessageCount *int64 `json:"deadLetterMessageCount,omitempty"`
	// ScheduledMessageCount - Number of scheduled messages.
	ScheduledMessageCount *int64 `json:"scheduledMessageCount,omitempty"`
	// TransferDeadLetterMessageCount - Number of messages transferred into dead letters.
	TransferDeadLetterMessageCount *int64 `json:"transferDeadLetterMessageCount,omitempty"`
	// TransferMessageCount - Number of messages transferred to another queue, topic, or subscription.
	TransferMessageCount *int64 `json:"transferMessageCount,omitempty"`
}

// NamespaceCreateOrUpdateParameters parameters supplied to the Create Or Update Namespace operation.
type NamespaceCreateOrUpdateParameters struct {
	// Location - Namespace location.
	Location *string `json:"location,omitempty"`
	Sku      *Sku    `json:"sku,omitempty"`
	// Tags - Namespace tags.
	Tags                 map[string]*string `json:"tags"`
	*NamespaceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for NamespaceCreateOrUpdateParameters.
func (ncoup NamespaceCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ncoup.Location != nil {
		objectMap["location"] = ncoup.Location
	}
	if ncoup.Sku != nil {
		objectMap["sku"] = ncoup.Sku
	}
	if ncoup.Tags != nil {
		objectMap["tags"] = ncoup.Tags
	}
	if ncoup.NamespaceProperties != nil {
		objectMap["properties"] = ncoup.NamespaceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NamespaceCreateOrUpdateParameters struct.
func (ncoup *NamespaceCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ncoup.Location = &location
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ncoup.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ncoup.Tags = tags
			}
		case "properties":
			if v != nil {
				var namespaceProperties NamespaceProperties
				err = json.Unmarshal(*v, &namespaceProperties)
				if err != nil {
					return err
				}
				ncoup.NamespaceProperties = &namespaceProperties
			}
		}
	}

	return nil
}

// NamespaceListResult the response of the List Namespace operation.
type NamespaceListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Namespace operation.
	Value *[]NamespaceResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of Namespaces.
	NextLink *string `json:"nextLink,omitempty"`
}

// NamespaceListResultIterator provides access to a complete listing of NamespaceResource values.
type NamespaceListResultIterator struct {
	i    int
	page NamespaceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NamespaceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NamespaceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NamespaceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NamespaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NamespaceListResultIterator) Response() NamespaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NamespaceListResultIterator) Value() NamespaceResource {
	if !iter.page.NotDone() {
		return NamespaceResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NamespaceListResultIterator type.
func NewNamespaceListResultIterator(page NamespaceListResultPage) NamespaceListResultIterator {
	return NamespaceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nlr NamespaceListResult) IsEmpty() bool {
	return nlr.Value == nil || len(*nlr.Value) == 0
}

// namespaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nlr NamespaceListResult) namespaceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if nlr.NextLink == nil || len(to.String(nlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nlr.NextLink)))
}

// NamespaceListResultPage contains a page of NamespaceResource values.
type NamespaceListResultPage struct {
	fn  func(context.Context, NamespaceListResult) (NamespaceListResult, error)
	nlr NamespaceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NamespaceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NamespaceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.nlr)
	if err != nil {
		return err
	}
	page.nlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NamespaceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NamespaceListResultPage) NotDone() bool {
	return !page.nlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NamespaceListResultPage) Response() NamespaceListResult {
	return page.nlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NamespaceListResultPage) Values() []NamespaceResource {
	if page.nlr.IsEmpty() {
		return nil
	}
	return *page.nlr.Value
}

// Creates a new instance of the NamespaceListResultPage type.
func NewNamespaceListResultPage(getNextPage func(context.Context, NamespaceListResult) (NamespaceListResult, error)) NamespaceListResultPage {
	return NamespaceListResultPage{fn: getNextPage}
}

// NamespaceProperties properties of the namespace.
type NamespaceProperties struct {
	// ProvisioningState - Provisioning state of the namespace.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Status - State of the namespace. Possible values include: 'NamespaceStateUnknown', 'NamespaceStateCreating', 'NamespaceStateCreated', 'NamespaceStateActivating', 'NamespaceStateEnabling', 'NamespaceStateActive', 'NamespaceStateDisabling', 'NamespaceStateDisabled', 'NamespaceStateSoftDeleting', 'NamespaceStateSoftDeleted', 'NamespaceStateRemoving', 'NamespaceStateRemoved', 'NamespaceStateFailed'
	Status NamespaceState `json:"status,omitempty"`
	// CreatedAt - The time the namespace was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// UpdatedAt - The time the namespace was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// ServiceBusEndpoint - Endpoint you can use to perform Service Bus operations.
	ServiceBusEndpoint *string `json:"serviceBusEndpoint,omitempty"`
	// CreateACSNamespace - Indicates whether to create an ACS namespace.
	CreateACSNamespace *bool `json:"createACSNamespace,omitempty"`
	// Enabled - Specifies whether this instance is enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// NamespaceResource description of a namespace resource.
type NamespaceResource struct {
	autorest.Response    `json:"-"`
	Sku                  *Sku `json:"sku,omitempty"`
	*NamespaceProperties `json:"properties,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NamespaceResource.
func (nr NamespaceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nr.Sku != nil {
		objectMap["sku"] = nr.Sku
	}
	if nr.NamespaceProperties != nil {
		objectMap["properties"] = nr.NamespaceProperties
	}
	if nr.Tags != nil {
		objectMap["tags"] = nr.Tags
	}
	if nr.ID != nil {
		objectMap["id"] = nr.ID
	}
	if nr.Name != nil {
		objectMap["name"] = nr.Name
	}
	if nr.Location != nil {
		objectMap["location"] = nr.Location
	}
	if nr.Type != nil {
		objectMap["type"] = nr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NamespaceResource struct.
func (nr *NamespaceResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				nr.Sku = &sku
			}
		case "properties":
			if v != nil {
				var namespaceProperties NamespaceProperties
				err = json.Unmarshal(*v, &namespaceProperties)
				if err != nil {
					return err
				}
				nr.NamespaceProperties = &namespaceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				nr.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				nr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nr.Type = &typeVar
			}
		}
	}

	return nil
}

// NamespacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type NamespacesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *NamespacesCreateOrUpdateFuture) Result(client NamespacesClient) (nr NamespaceResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicebus.NamespacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicebus.NamespacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if nr.Response.Response, err = future.GetResult(sender); err == nil && nr.Response.Response.StatusCode != http.StatusNoContent {
		nr, err = client.CreateOrUpdateResponder(nr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicebus.NamespacesCreateOrUpdateFuture", "Result", nr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// NamespacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type NamespacesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *NamespacesDeleteFuture) Result(client NamespacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicebus.NamespacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicebus.NamespacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// NamespaceUpdateParameters parameters supplied to the Patch Namespace operation.
type NamespaceUpdateParameters struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for NamespaceUpdateParameters.
func (nup NamespaceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nup.Tags != nil {
		objectMap["tags"] = nup.Tags
	}
	if nup.Sku != nil {
		objectMap["sku"] = nup.Sku
	}
	return json.Marshal(objectMap)
}

// Operation a ServiceBus REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.ServiceBus
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Invoice, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list ServiceBus operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of ServiceBus operations supported by the Microsoft.ServiceBus resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// QueueCreateOrUpdateParameters parameters supplied to the Create Or Update Queue operation.
type QueueCreateOrUpdateParameters struct {
	// Name - Queue name.
	Name *string `json:"name,omitempty"`
	// Location - location of the resource.
	Location         *string `json:"location,omitempty"`
	*QueueProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for QueueCreateOrUpdateParameters.
func (qcoup QueueCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qcoup.Name != nil {
		objectMap["name"] = qcoup.Name
	}
	if qcoup.Location != nil {
		objectMap["location"] = qcoup.Location
	}
	if qcoup.QueueProperties != nil {
		objectMap["properties"] = qcoup.QueueProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for QueueCreateOrUpdateParameters struct.
func (qcoup *QueueCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				qcoup.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				qcoup.Location = &location
			}
		case "properties":
			if v != nil {
				var queueProperties QueueProperties
				err = json.Unmarshal(*v, &queueProperties)
				if err != nil {
					return err
				}
				qcoup.QueueProperties = &queueProperties
			}
		}
	}

	return nil
}

// QueueListResult the response to the List Queues operation.
type QueueListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Queues operation.
	Value *[]QueueResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of queues.
	NextLink *string `json:"nextLink,omitempty"`
}

// QueueListResultIterator provides access to a complete listing of QueueResource values.
type QueueListResultIterator struct {
	i    int
	page QueueListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *QueueListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QueueListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *QueueListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter QueueListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter QueueListResultIterator) Response() QueueListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter QueueListResultIterator) Value() QueueResource {
	if !iter.page.NotDone() {
		return QueueResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the QueueListResultIterator type.
func NewQueueListResultIterator(page QueueListResultPage) QueueListResultIterator {
	return QueueListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (qlr QueueListResult) IsEmpty() bool {
	return qlr.Value == nil || len(*qlr.Value) == 0
}

// queueListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (qlr QueueListResult) queueListResultPreparer(ctx context.Context) (*http.Request, error) {
	if qlr.NextLink == nil || len(to.String(qlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(qlr.NextLink)))
}

// QueueListResultPage contains a page of QueueResource values.
type QueueListResultPage struct {
	fn  func(context.Context, QueueListResult) (QueueListResult, error)
	qlr QueueListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *QueueListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QueueListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.qlr)
	if err != nil {
		return err
	}
	page.qlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *QueueListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page QueueListResultPage) NotDone() bool {
	return !page.qlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page QueueListResultPage) Response() QueueListResult {
	return page.qlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page QueueListResultPage) Values() []QueueResource {
	if page.qlr.IsEmpty() {
		return nil
	}
	return *page.qlr.Value
}

// Creates a new instance of the QueueListResultPage type.
func NewQueueListResultPage(getNextPage func(context.Context, QueueListResult) (QueueListResult, error)) QueueListResultPage {
	return QueueListResultPage{fn: getNextPage}
}

// QueueProperties the Queue Properties definition.
type QueueProperties struct {
	// LockDuration - The duration of a peek-lock; that is, the amount of time that the message is locked for other receivers. The maximum value for LockDuration is 5 minutes; the default value is 1 minute.
	LockDuration *string `json:"lockDuration,omitempty"`
	// AccessedAt - Last time a message was sent, or the last time there was a receive request to this queue.
	AccessedAt *date.Time `json:"accessedAt,omitempty"`
	// AutoDeleteOnIdle - the TimeSpan idle interval after which the queue is automatically deleted. The minimum duration is 5 minutes.
	AutoDeleteOnIdle *string `json:"autoDeleteOnIdle,omitempty"`
	// EntityAvailabilityStatus - Entity availability status for the queue. Possible values include: 'Available', 'Limited', 'Renaming', 'Restoring', 'Unknown'
	EntityAvailabilityStatus EntityAvailabilityStatus `json:"entityAvailabilityStatus,omitempty"`
	// CreatedAt - The exact time the message was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// DefaultMessageTimeToLive - The default message time to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
	DefaultMessageTimeToLive *string `json:"defaultMessageTimeToLive,omitempty"`
	// DuplicateDetectionHistoryTimeWindow - TimeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
	DuplicateDetectionHistoryTimeWindow *string `json:"duplicateDetectionHistoryTimeWindow,omitempty"`
	// EnableBatchedOperations - A value that indicates whether server-side batched operations are enabled.
	EnableBatchedOperations *bool `json:"enableBatchedOperations,omitempty"`
	// DeadLetteringOnMessageExpiration - A value that indicates whether this queue has dead letter support when a message expires.
	DeadLetteringOnMessageExpiration *bool `json:"deadLetteringOnMessageExpiration,omitempty"`
	// EnableExpress - A value that indicates whether Express Entities are enabled. An express queue holds a message in memory temporarily before writing it to persistent storage.
	EnableExpress *bool `json:"enableExpress,omitempty"`
	// EnablePartitioning - A value that indicates whether the queue is to be partitioned across multiple message brokers.
	EnablePartitioning *bool `json:"enablePartitioning,omitempty"`
	// IsAnonymousAccessible - A value that indicates whether the message is accessible anonymously.
	IsAnonymousAccessible *bool `json:"isAnonymousAccessible,omitempty"`
	// MaxDeliveryCount - The maximum delivery count. A message is automatically deadlettered after this number of deliveries.
	MaxDeliveryCount *int32 `json:"maxDeliveryCount,omitempty"`
	// MaxSizeInMegabytes - The maximum size of the queue in megabytes, which is the size of memory allocated for the queue.
	MaxSizeInMegabytes *int64 `json:"maxSizeInMegabytes,omitempty"`
	// MessageCount - The number of messages in the queue.
	MessageCount *int64               `json:"messageCount,omitempty"`
	CountDetails *MessageCountDetails `json:"countDetails,omitempty"`
	// RequiresDuplicateDetection - A value indicating if this queue requires duplicate detection.
	RequiresDuplicateDetection *bool `json:"requiresDuplicateDetection,omitempty"`
	// RequiresSession - A value that indicates whether the queue supports the concept of sessions.
	RequiresSession *bool `json:"requiresSession,omitempty"`
	// SizeInBytes - The size of the queue, in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`
	// Status - Enumerates the possible values for the status of a messaging entity. Possible values include: 'EntityStatusActive', 'EntityStatusCreating', 'EntityStatusDeleting', 'EntityStatusDisabled', 'EntityStatusReceiveDisabled', 'EntityStatusRenaming', 'EntityStatusRestoring', 'EntityStatusSendDisabled', 'EntityStatusUnknown'
	Status EntityStatus `json:"status,omitempty"`
	// SupportOrdering - A value that indicates whether the queue supports ordering.
	SupportOrdering *bool `json:"supportOrdering,omitempty"`
	// UpdatedAt - The exact time the message was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
}

// QueueResource description of queue Resource.
type QueueResource struct {
	autorest.Response `json:"-"`
	*QueueProperties  `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for QueueResource.
func (qr QueueResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qr.QueueProperties != nil {
		objectMap["properties"] = qr.QueueProperties
	}
	if qr.ID != nil {
		objectMap["id"] = qr.ID
	}
	if qr.Name != nil {
		objectMap["name"] = qr.Name
	}
	if qr.Location != nil {
		objectMap["location"] = qr.Location
	}
	if qr.Type != nil {
		objectMap["type"] = qr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for QueueResource struct.
func (qr *QueueResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var queueProperties QueueProperties
				err = json.Unmarshal(*v, &queueProperties)
				if err != nil {
					return err
				}
				qr.QueueProperties = &queueProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				qr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				qr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				qr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				qr.Type = &typeVar
			}
		}
	}

	return nil
}

// RegenerateKeysParameters parameters supplied to the Regenerate Authorization Rule operation.
type RegenerateKeysParameters struct {
	// Policykey - Key that needs to be regenerated. Possible values include: 'PrimaryKey', 'SecondaryKey'
	Policykey Policykey `json:"Policykey,omitempty"`
}

// Resource the Resource definition for other than namespace.
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// ResourceListKeys namespace/ServiceBus Connection String
type ResourceListKeys struct {
	autorest.Response `json:"-"`
	// PrimaryConnectionString - Primary connection string of the created namespace authorization rule.
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty"`
	// SecondaryConnectionString - Secondary connection string of the created namespace authorization rule.
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`
	// PrimaryKey - A base64-encoded 256-bit primary key for signing and validating the SAS token.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - A base64-encoded 256-bit primary key for signing and validating the SAS token.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// KeyName - A string that describes the authorization rule.
	KeyName *string `json:"keyName,omitempty"`
}

// SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters supplied to the Create Or Update
// Authorization Rules operation.
type SharedAccessAuthorizationRuleCreateOrUpdateParameters struct {
	// Location - data center location.
	Location *string `json:"location,omitempty"`
	// Name - Name of the authorization rule.
	Name                                     *string `json:"name,omitempty"`
	*SharedAccessAuthorizationRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedAccessAuthorizationRuleCreateOrUpdateParameters.
func (saarcoup SharedAccessAuthorizationRuleCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if saarcoup.Location != nil {
		objectMap["location"] = saarcoup.Location
	}
	if saarcoup.Name != nil {
		objectMap["name"] = saarcoup.Name
	}
	if saarcoup.SharedAccessAuthorizationRuleProperties != nil {
		objectMap["properties"] = saarcoup.SharedAccessAuthorizationRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SharedAccessAuthorizationRuleCreateOrUpdateParameters struct.
func (saarcoup *SharedAccessAuthorizationRuleCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				saarcoup.Location = &location
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				saarcoup.Name = &name
			}
		case "properties":
			if v != nil {
				var sharedAccessAuthorizationRuleProperties SharedAccessAuthorizationRuleProperties
				err = json.Unmarshal(*v, &sharedAccessAuthorizationRuleProperties)
				if err != nil {
					return err
				}
				saarcoup.SharedAccessAuthorizationRuleProperties = &sharedAccessAuthorizationRuleProperties
			}
		}
	}

	return nil
}

// SharedAccessAuthorizationRuleListResult the response to the List Namespace operation.
type SharedAccessAuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Authorization Rules operation.
	Value *[]SharedAccessAuthorizationRuleResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of Authorization Rules.
	NextLink *string `json:"nextLink,omitempty"`
}

// SharedAccessAuthorizationRuleListResultIterator provides access to a complete listing of
// SharedAccessAuthorizationRuleResource values.
type SharedAccessAuthorizationRuleListResultIterator struct {
	i    int
	page SharedAccessAuthorizationRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SharedAccessAuthorizationRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedAccessAuthorizationRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SharedAccessAuthorizationRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SharedAccessAuthorizationRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SharedAccessAuthorizationRuleListResultIterator) Response() SharedAccessAuthorizationRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SharedAccessAuthorizationRuleListResultIterator) Value() SharedAccessAuthorizationRuleResource {
	if !iter.page.NotDone() {
		return SharedAccessAuthorizationRuleResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SharedAccessAuthorizationRuleListResultIterator type.
func NewSharedAccessAuthorizationRuleListResultIterator(page SharedAccessAuthorizationRuleListResultPage) SharedAccessAuthorizationRuleListResultIterator {
	return SharedAccessAuthorizationRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (saarlr SharedAccessAuthorizationRuleListResult) IsEmpty() bool {
	return saarlr.Value == nil || len(*saarlr.Value) == 0
}

// sharedAccessAuthorizationRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (saarlr SharedAccessAuthorizationRuleListResult) sharedAccessAuthorizationRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if saarlr.NextLink == nil || len(to.String(saarlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(saarlr.NextLink)))
}

// SharedAccessAuthorizationRuleListResultPage contains a page of SharedAccessAuthorizationRuleResource
// values.
type SharedAccessAuthorizationRuleListResultPage struct {
	fn     func(context.Context, SharedAccessAuthorizationRuleListResult) (SharedAccessAuthorizationRuleListResult, error)
	saarlr SharedAccessAuthorizationRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SharedAccessAuthorizationRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedAccessAuthorizationRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.saarlr)
	if err != nil {
		return err
	}
	page.saarlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SharedAccessAuthorizationRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SharedAccessAuthorizationRuleListResultPage) NotDone() bool {
	return !page.saarlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SharedAccessAuthorizationRuleListResultPage) Response() SharedAccessAuthorizationRuleListResult {
	return page.saarlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SharedAccessAuthorizationRuleListResultPage) Values() []SharedAccessAuthorizationRuleResource {
	if page.saarlr.IsEmpty() {
		return nil
	}
	return *page.saarlr.Value
}

// Creates a new instance of the SharedAccessAuthorizationRuleListResultPage type.
func NewSharedAccessAuthorizationRuleListResultPage(getNextPage func(context.Context, SharedAccessAuthorizationRuleListResult) (SharedAccessAuthorizationRuleListResult, error)) SharedAccessAuthorizationRuleListResultPage {
	return SharedAccessAuthorizationRuleListResultPage{fn: getNextPage}
}

// SharedAccessAuthorizationRuleProperties sharedAccessAuthorizationRule properties.
type SharedAccessAuthorizationRuleProperties struct {
	// Rights - The rights associated with the rule.
	Rights *[]AccessRights `json:"rights,omitempty"`
}

// SharedAccessAuthorizationRuleResource description of a namespace authorization rule.
type SharedAccessAuthorizationRuleResource struct {
	autorest.Response                        `json:"-"`
	*SharedAccessAuthorizationRuleProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedAccessAuthorizationRuleResource.
func (saarr SharedAccessAuthorizationRuleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if saarr.SharedAccessAuthorizationRuleProperties != nil {
		objectMap["properties"] = saarr.SharedAccessAuthorizationRuleProperties
	}
	if saarr.ID != nil {
		objectMap["id"] = saarr.ID
	}
	if saarr.Name != nil {
		objectMap["name"] = saarr.Name
	}
	if saarr.Location != nil {
		objectMap["location"] = saarr.Location
	}
	if saarr.Type != nil {
		objectMap["type"] = saarr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SharedAccessAuthorizationRuleResource struct.
func (saarr *SharedAccessAuthorizationRuleResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sharedAccessAuthorizationRuleProperties SharedAccessAuthorizationRuleProperties
				err = json.Unmarshal(*v, &sharedAccessAuthorizationRuleProperties)
				if err != nil {
					return err
				}
				saarr.SharedAccessAuthorizationRuleProperties = &sharedAccessAuthorizationRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				saarr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				saarr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				saarr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				saarr.Type = &typeVar
			}
		}
	}

	return nil
}

// Sku SKU of the namespace.
type Sku struct {
	// Name - Name of this SKU. Possible values include: 'Basic', 'Standard', 'Premium'
	Name SkuName `json:"name,omitempty"`
	// Tier - The billing tier of this particular SKU. Possible values include: 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
	// Capacity - The specified messaging units for the tier.
	Capacity *int32 `json:"capacity,omitempty"`
}

// SubscriptionCreateOrUpdateParameters parameters supplied to the Create Or Update Subscription operation.
type SubscriptionCreateOrUpdateParameters struct {
	// Location - Subscription data center location.
	Location *string `json:"location,omitempty"`
	// Type - Resource manager type of the resource.
	Type                    *string `json:"type,omitempty"`
	*SubscriptionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionCreateOrUpdateParameters.
func (scoup SubscriptionCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scoup.Location != nil {
		objectMap["location"] = scoup.Location
	}
	if scoup.Type != nil {
		objectMap["type"] = scoup.Type
	}
	if scoup.SubscriptionProperties != nil {
		objectMap["properties"] = scoup.SubscriptionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubscriptionCreateOrUpdateParameters struct.
func (scoup *SubscriptionCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				scoup.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scoup.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var subscriptionProperties SubscriptionProperties
				err = json.Unmarshal(*v, &subscriptionProperties)
				if err != nil {
					return err
				}
				scoup.SubscriptionProperties = &subscriptionProperties
			}
		}
	}

	return nil
}

// SubscriptionListResult the response to the List Subscriptions operation.
type SubscriptionListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Subscriptions operation.
	Value *[]SubscriptionResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of subscriptions.
	NextLink *string `json:"nextLink,omitempty"`
}

// SubscriptionListResultIterator provides access to a complete listing of SubscriptionResource values.
type SubscriptionListResultIterator struct {
	i    int
	page SubscriptionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubscriptionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubscriptionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubscriptionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubscriptionListResultIterator) Response() SubscriptionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubscriptionListResultIterator) Value() SubscriptionResource {
	if !iter.page.NotDone() {
		return SubscriptionResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubscriptionListResultIterator type.
func NewSubscriptionListResultIterator(page SubscriptionListResultPage) SubscriptionListResultIterator {
	return SubscriptionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr SubscriptionListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// subscriptionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SubscriptionListResult) subscriptionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if slr.NextLink == nil || len(to.String(slr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// SubscriptionListResultPage contains a page of SubscriptionResource values.
type SubscriptionListResultPage struct {
	fn  func(context.Context, SubscriptionListResult) (SubscriptionListResult, error)
	slr SubscriptionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubscriptionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.slr)
	if err != nil {
		return err
	}
	page.slr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubscriptionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubscriptionListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubscriptionListResultPage) Response() SubscriptionListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubscriptionListResultPage) Values() []SubscriptionResource {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the SubscriptionListResultPage type.
func NewSubscriptionListResultPage(getNextPage func(context.Context, SubscriptionListResult) (SubscriptionListResult, error)) SubscriptionListResultPage {
	return SubscriptionListResultPage{fn: getNextPage}
}

// SubscriptionProperties description of Subscription Resource.
type SubscriptionProperties struct {
	// AccessedAt - Last time there was a receive request to this subscription.
	AccessedAt *date.Time `json:"accessedAt,omitempty"`
	// AutoDeleteOnIdle - TimeSpan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
	AutoDeleteOnIdle *string              `json:"autoDeleteOnIdle,omitempty"`
	CountDetails     *MessageCountDetails `json:"countDetails,omitempty"`
	// CreatedAt - Exact time the message was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// DefaultMessageTimeToLive - Default message time to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
	DefaultMessageTimeToLive *string `json:"defaultMessageTimeToLive,omitempty"`
	// DeadLetteringOnFilterEvaluationExceptions - Value that indicates whether a subscription has dead letter support on filter evaluation exceptions.
	DeadLetteringOnFilterEvaluationExceptions *bool `json:"deadLetteringOnFilterEvaluationExceptions,omitempty"`
	// DeadLetteringOnMessageExpiration - Value that indicates whether a subscription has dead letter support when a message expires.
	DeadLetteringOnMessageExpiration *bool `json:"deadLetteringOnMessageExpiration,omitempty"`
	// EnableBatchedOperations - Value that indicates whether server-side batched operations are enabled.
	EnableBatchedOperations *bool `json:"enableBatchedOperations,omitempty"`
	// EntityAvailabilityStatus - Entity availability status for the topic. Possible values include: 'Available', 'Limited', 'Renaming', 'Restoring', 'Unknown'
	EntityAvailabilityStatus EntityAvailabilityStatus `json:"entityAvailabilityStatus,omitempty"`
	// IsReadOnly - Value that indicates whether the entity description is read-only.
	IsReadOnly *bool `json:"isReadOnly,omitempty"`
	// LockDuration - The lock duration time span for the subscription.
	LockDuration *string `json:"lockDuration,omitempty"`
	// MaxDeliveryCount - Number of maximum deliveries.
	MaxDeliveryCount *int32 `json:"maxDeliveryCount,omitempty"`
	// MessageCount - Number of messages.
	MessageCount *int64 `json:"messageCount,omitempty"`
	// RequiresSession - Value indicating if a subscription supports the concept of sessions.
	RequiresSession *bool `json:"requiresSession,omitempty"`
	// Status - Enumerates the possible values for the status of a messaging entity. Possible values include: 'EntityStatusActive', 'EntityStatusCreating', 'EntityStatusDeleting', 'EntityStatusDisabled', 'EntityStatusReceiveDisabled', 'EntityStatusRenaming', 'EntityStatusRestoring', 'EntityStatusSendDisabled', 'EntityStatusUnknown'
	Status EntityStatus `json:"status,omitempty"`
	// UpdatedAt - The exact time the message was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
}

// SubscriptionResource description of subscription resource.
type SubscriptionResource struct {
	autorest.Response       `json:"-"`
	*SubscriptionProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionResource.
func (sr SubscriptionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.SubscriptionProperties != nil {
		objectMap["properties"] = sr.SubscriptionProperties
	}
	if sr.ID != nil {
		objectMap["id"] = sr.ID
	}
	if sr.Name != nil {
		objectMap["name"] = sr.Name
	}
	if sr.Location != nil {
		objectMap["location"] = sr.Location
	}
	if sr.Type != nil {
		objectMap["type"] = sr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubscriptionResource struct.
func (sr *SubscriptionResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subscriptionProperties SubscriptionProperties
				err = json.Unmarshal(*v, &subscriptionProperties)
				if err != nil {
					return err
				}
				sr.SubscriptionProperties = &subscriptionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sr.Type = &typeVar
			}
		}
	}

	return nil
}

// TopicCreateOrUpdateParameters parameters supplied to the Create Or Update Topic operation.
type TopicCreateOrUpdateParameters struct {
	// Name - Topic name.
	Name *string `json:"name,omitempty"`
	// Location - Location of the resource.
	Location         *string `json:"location,omitempty"`
	*TopicProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TopicCreateOrUpdateParameters.
func (tcoup TopicCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tcoup.Name != nil {
		objectMap["name"] = tcoup.Name
	}
	if tcoup.Location != nil {
		objectMap["location"] = tcoup.Location
	}
	if tcoup.TopicProperties != nil {
		objectMap["properties"] = tcoup.TopicProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TopicCreateOrUpdateParameters struct.
func (tcoup *TopicCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tcoup.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tcoup.Location = &location
			}
		case "properties":
			if v != nil {
				var topicProperties TopicProperties
				err = json.Unmarshal(*v, &topicProperties)
				if err != nil {
					return err
				}
				tcoup.TopicProperties = &topicProperties
			}
		}
	}

	return nil
}

// TopicListResult the response to the List Topics operation.
type TopicListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Topics operation.
	Value *[]TopicResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of topics.
	NextLink *string `json:"nextLink,omitempty"`
}

// TopicListResultIterator provides access to a complete listing of TopicResource values.
type TopicListResultIterator struct {
	i    int
	page TopicListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TopicListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopicListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TopicListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TopicListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TopicListResultIterator) Response() TopicListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TopicListResultIterator) Value() TopicResource {
	if !iter.page.NotDone() {
		return TopicResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TopicListResultIterator type.
func NewTopicListResultIterator(page TopicListResultPage) TopicListResultIterator {
	return TopicListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tlr TopicListResult) IsEmpty() bool {
	return tlr.Value == nil || len(*tlr.Value) == 0
}

// topicListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tlr TopicListResult) topicListResultPreparer(ctx context.Context) (*http.Request, error) {
	if tlr.NextLink == nil || len(to.String(tlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tlr.NextLink)))
}

// TopicListResultPage contains a page of TopicResource values.
type TopicListResultPage struct {
	fn  func(context.Context, TopicListResult) (TopicListResult, error)
	tlr TopicListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TopicListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopicListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tlr)
	if err != nil {
		return err
	}
	page.tlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TopicListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TopicListResultPage) NotDone() bool {
	return !page.tlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TopicListResultPage) Response() TopicListResult {
	return page.tlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TopicListResultPage) Values() []TopicResource {
	if page.tlr.IsEmpty() {
		return nil
	}
	return *page.tlr.Value
}

// Creates a new instance of the TopicListResultPage type.
func NewTopicListResultPage(getNextPage func(context.Context, TopicListResult) (TopicListResult, error)) TopicListResultPage {
	return TopicListResultPage{fn: getNextPage}
}

// TopicProperties the Tpoic Properties definition.
type TopicProperties struct {
	// AccessedAt - Last time the message was sent, or a request was received, for this topic.
	AccessedAt *date.Time `json:"accessedAt,omitempty"`
	// AutoDeleteOnIdle - TimeSpan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
	AutoDeleteOnIdle *string `json:"autoDeleteOnIdle,omitempty"`
	// EntityAvailabilityStatus - Entity availability status for the topic. Possible values include: 'Available', 'Limited', 'Renaming', 'Restoring', 'Unknown'
	EntityAvailabilityStatus EntityAvailabilityStatus `json:"entityAvailabilityStatus,omitempty"`
	// CreatedAt - Exact time the message was created.
	CreatedAt    *date.Time           `json:"createdAt,omitempty"`
	CountDetails *MessageCountDetails `json:"countDetails,omitempty"`
	// DefaultMessageTimeToLive - Default message time to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
	DefaultMessageTimeToLive *string `json:"defaultMessageTimeToLive,omitempty"`
	// DuplicateDetectionHistoryTimeWindow - TimeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
	DuplicateDetectionHistoryTimeWindow *string `json:"duplicateDetectionHistoryTimeWindow,omitempty"`
	// EnableBatchedOperations - Value that indicates whether server-side batched operations are enabled.
	EnableBatchedOperations *bool `json:"enableBatchedOperations,omitempty"`
	// EnableExpress - Value that indicates whether Express Entities are enabled. An express topic holds a message in memory temporarily before writing it to persistent storage.
	EnableExpress *bool `json:"enableExpress,omitempty"`
	// EnablePartitioning - Value that indicates whether the topic to be partitioned across multiple message brokers is enabled.
	EnablePartitioning *bool `json:"enablePartitioning,omitempty"`
	// FilteringMessagesBeforePublishing - Whether messages should be filtered before publishing.
	FilteringMessagesBeforePublishing *bool `json:"filteringMessagesBeforePublishing,omitempty"`
	// IsAnonymousAccessible - Value that indicates whether the message is accessible anonymously.
	IsAnonymousAccessible *bool `json:"isAnonymousAccessible,omitempty"`
	IsExpress             *bool `json:"isExpress,omitempty"`
	// MaxSizeInMegabytes - Maximum size of the topic in megabytes, which is the size of the memory allocated for the topic.
	MaxSizeInMegabytes *int64 `json:"maxSizeInMegabytes,omitempty"`
	// RequiresDuplicateDetection - Value indicating if this topic requires duplicate detection.
	RequiresDuplicateDetection *bool `json:"requiresDuplicateDetection,omitempty"`
	// SizeInBytes - Size of the topic, in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`
	// Status - Enumerates the possible values for the status of a messaging entity. Possible values include: 'EntityStatusActive', 'EntityStatusCreating', 'EntityStatusDeleting', 'EntityStatusDisabled', 'EntityStatusReceiveDisabled', 'EntityStatusRenaming', 'EntityStatusRestoring', 'EntityStatusSendDisabled', 'EntityStatusUnknown'
	Status EntityStatus `json:"status,omitempty"`
	// SubscriptionCount - Number of subscriptions.
	SubscriptionCount *int32 `json:"subscriptionCount,omitempty"`
	// SupportOrdering - Value that indicates whether the topic supports ordering.
	SupportOrdering *bool `json:"supportOrdering,omitempty"`
	// UpdatedAt - The exact time the message was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
}

// TopicResource description of topic resource.
type TopicResource struct {
	autorest.Response `json:"-"`
	*TopicProperties  `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TopicResource.
func (tr TopicResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.TopicProperties != nil {
		objectMap["properties"] = tr.TopicProperties
	}
	if tr.ID != nil {
		objectMap["id"] = tr.ID
	}
	if tr.Name != nil {
		objectMap["name"] = tr.Name
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Type != nil {
		objectMap["type"] = tr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TopicResource struct.
func (tr *TopicResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var topicProperties TopicProperties
				err = json.Unmarshal(*v, &topicProperties)
				if err != nil {
					return err
				}
				tr.TopicProperties = &topicProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tr.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tr.Type = &typeVar
			}
		}
	}

	return nil
}

// TrackedResource the Resource definition.
type TrackedResource struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.ID != nil {
		objectMap["id"] = tr.ID
	}
	if tr.Name != nil {
		objectMap["name"] = tr.Name
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Type != nil {
		objectMap["type"] = tr.Type
	}
	return json.Marshal(objectMap)
}
