package resourcehealthapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/resourcehealth/mgmt/2015-01-01/resourcehealth"
)

// AvailabilityStatusesClientAPI contains the set of methods on the AvailabilityStatusesClient type.
type AvailabilityStatusesClientAPI interface {
	GetByResource(ctx context.Context, resourceURI string, filter string, expand string) (result resourcehealth.AvailabilityStatus, err error)
	List(ctx context.Context, resourceURI string, filter string, expand string) (result resourcehealth.AvailabilityStatusListResultPage, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, filter string, expand string) (result resourcehealth.AvailabilityStatusListResultPage, err error)
	ListBySubscriptionID(ctx context.Context, filter string, expand string) (result resourcehealth.AvailabilityStatusListResultPage, err error)
}

var _ AvailabilityStatusesClientAPI = (*resourcehealth.AvailabilityStatusesClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result resourcehealth.OperationListResult, err error)
}

var _ OperationsClientAPI = (*resourcehealth.OperationsClient)(nil)
